/* rygel-lms-artist.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-lms-artist.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <sqlite3.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define RYGEL_LMS_ARTIST_SQL_ALL_TEMPLATE "SELECT audio_albums.id, audio_albums.name " "FROM audio_albums " "WHERE audio_albums.artist_id = %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ARTIST_SQL_COUNT_TEMPLATE "SELECT COUNT(audio_albums.id) " "FROM audio_albums " "WHERE audio_albums.artist_id = %s"
#define RYGEL_LMS_ARTIST_SQL_FIND_OBJECT_TEMPLATE "SELECT audio_albums.id, audio_albums.name " "FROM audio_albums " "WHERE audio_albums.id = ? AND audio_albums.artist_id = %s;"

enum  {
	RYGEL_LMS_ARTIST_0_PROPERTY,
	RYGEL_LMS_ARTIST_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_artist_properties[RYGEL_LMS_ARTIST_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_lms_artist_parent_class = NULL;

static gchar* rygel_lms_artist_get_sql_all (const gchar* id);
static gchar* rygel_lms_artist_get_sql_find_object (const gchar* id);
static gchar* rygel_lms_artist_get_sql_count (const gchar* id);
static RygelMediaObject* rygel_lms_artist_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                               sqlite3_stmt* statement);
static GType rygel_lms_artist_get_type_once (void);

static gchar*
rygel_lms_artist_get_sql_all (const gchar* id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ARTIST_SQL_ALL_TEMPLATE, id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_artist_get_sql_find_object (const gchar* id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ARTIST_SQL_FIND_OBJECT_TEMPLATE, id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_artist_get_sql_count (const gchar* id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ARTIST_SQL_COUNT_TEMPLATE, id);
	result = _tmp0_;
	return result;
}

static RygelMediaObject*
rygel_lms_artist_real_object_from_statement (RygelLMSCategoryContainer* base,
                                             sqlite3_stmt* statement)
{
	RygelLMSArtist * self;
	gchar* db_id = NULL;
	gchar* _tmp0_;
	gchar* title = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	RygelLMSDatabase* _tmp3_;
	RygelLMSDatabase* _tmp4_;
	RygelLMSAlbum* _tmp5_;
	RygelMediaObject* result;
	self = (RygelLMSArtist*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d", sqlite3_column_int (statement, 0));
	db_id = _tmp0_;
	_tmp1_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_lms_album_new (db_id, (RygelMediaContainer*) self, title, _tmp4_);
	result = (RygelMediaObject*) _tmp5_;
	_g_free0 (title);
	_g_free0 (db_id);
	return result;
}

RygelLMSArtist*
rygel_lms_artist_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            RygelLMSDatabase* lms_db)
{
	RygelLMSArtist * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = rygel_lms_artist_get_sql_all (id);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_lms_artist_get_sql_find_object (id);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_lms_artist_get_sql_count (id);
	_tmp5_ = _tmp4_;
	self = (RygelLMSArtist*) rygel_lms_category_container_construct (object_type, id, parent, title, lms_db, _tmp1_, _tmp3_, _tmp5_, NULL, NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

RygelLMSArtist*
rygel_lms_artist_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      RygelLMSDatabase* lms_db)
{
	return rygel_lms_artist_construct (RYGEL_LMS_TYPE_ARTIST, id, parent, title, lms_db);
}

static void
rygel_lms_artist_class_init (RygelLMSArtistClass * klass,
                             gpointer klass_data)
{
	rygel_lms_artist_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_artist_real_object_from_statement;
}

static void
rygel_lms_artist_instance_init (RygelLMSArtist * self,
                                gpointer klass)
{
}

static GType
rygel_lms_artist_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSArtistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_artist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSArtist), 0, (GInstanceInitFunc) rygel_lms_artist_instance_init, NULL };
	GType rygel_lms_artist_type_id;
	rygel_lms_artist_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSArtist", &g_define_type_info, 0);
	return rygel_lms_artist_type_id;
}

GType
rygel_lms_artist_get_type (void)
{
	static volatile gsize rygel_lms_artist_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_artist_type_id__once)) {
		GType rygel_lms_artist_type_id;
		rygel_lms_artist_type_id = rygel_lms_artist_get_type_once ();
		g_once_init_leave (&rygel_lms_artist_type_id__once, rygel_lms_artist_type_id);
	}
	return rygel_lms_artist_type_id__once;
}

