/* rygel-lms-image-year.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-lms-image-year.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <sqlite3.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define RYGEL_LMS_IMAGE_YEAR_SQL_ALL_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id AND year = '%s' " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_IMAGE_YEAR_SQL_COUNT_TEMPLATE "SELECT count(images.id), strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id AND year = '%s';"
#define RYGEL_LMS_IMAGE_YEAR_SQL_FIND_OBJECT_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND files.id = ? AND images.id = files.id AND year = '" \
"%s';"
#define RYGEL_LMS_IMAGE_YEAR_SQL_ADDED_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id AND year = '%s' " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_IMAGE_YEAR_SQL_REMOVED_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime <> 0 AND images.id = files.id AND year = '%s' " "AND update_id > ? AND update_id <= ?;"

enum  {
	RYGEL_LMS_IMAGE_YEAR_0_PROPERTY,
	RYGEL_LMS_IMAGE_YEAR_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_image_year_properties[RYGEL_LMS_IMAGE_YEAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

static gpointer rygel_lms_image_year_parent_class = NULL;

static RygelMediaObject* rygel_lms_image_year_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                                   sqlite3_stmt* statement);
static gchar* rygel_lms_image_year_get_sql_all (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_find_object (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_count (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_added (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_removed (const gchar* year);
static GType rygel_lms_image_year_get_type_once (void);

static RygelMediaObject*
rygel_lms_image_year_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                 sqlite3_stmt* statement)
{
	RygelLMSImageYear * self;
	gint id = 0;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	RygelImageItem* image = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RygelImageItem* _tmp14_;
	RygelImageItem* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GDateTime* dt = NULL;
	GDateTime* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GFile* file = NULL;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	RygelMediaObject* result;
	self = (RygelLMSImageYear*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 6);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 9);
	_tmp3_ = g_strdup (_tmp2_);
	mime_type = _tmp3_;
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = mime_type;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = path;
		g_debug ("rygel-lms-image-year.vala:67: Image item %d (%s) has no MIME type", id, _tmp9_);
	}
	_tmp10_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp11_ = g_strdup (_tmp10_);
	title = _tmp11_;
	_tmp12_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	_tmp13_ = _tmp12_;
	_tmp14_ = rygel_image_item_new (_tmp13_, (RygelMediaContainer*) self, title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	image = _tmp15_;
	_tmp16_ = rygel_lms_category_container_build_reference_id ((RygelLMSCategoryContainer*) self, id);
	_tmp17_ = _tmp16_;
	rygel_media_object_set_ref_id ((RygelMediaObject*) image, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = (const gchar*) sqlite3_column_text (statement, 2);
	rygel_media_object_set_creator ((RygelMediaObject*) image, _tmp18_);
	_tmp19_ = g_date_time_new_from_unix_utc ((gint64) ((glong) sqlite3_column_int (statement, 3)));
	dt = _tmp19_;
	_tmp20_ = g_date_time_format (dt, "%Y-%m-%dT%H:%M:%S");
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("%sZ", _tmp21_);
	_tmp23_ = _tmp22_;
	rygel_media_object_set_date ((RygelMediaObject*) image, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	rygel_visual_item_set_width ((RygelVisualItem*) image, sqlite3_column_int (statement, 4));
	rygel_visual_item_set_height ((RygelVisualItem*) image, sqlite3_column_int (statement, 5));
	rygel_media_file_item_set_size ((RygelMediaFileItem*) image, (gint64) sqlite3_column_int (statement, 7));
	_tmp24_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) image, _tmp24_);
	_tmp25_ = (const gchar*) sqlite3_column_text (statement, 8);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) image, _tmp25_);
	_tmp26_ = path;
	_tmp27_ = g_file_new_for_path (_tmp26_);
	file = _tmp27_;
	_tmp28_ = g_file_get_uri (file);
	_tmp29_ = _tmp28_;
	rygel_media_object_add_uri ((RygelMediaObject*) image, _tmp29_);
	_g_free0 (_tmp29_);
	result = (RygelMediaObject*) image;
	_g_object_unref0 (file);
	_g_date_time_unref0 (dt);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}

static gchar*
rygel_lms_image_year_get_sql_all (const gchar* year)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_ALL_TEMPLATE, year);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_image_year_get_sql_find_object (const gchar* year)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_FIND_OBJECT_TEMPLATE, year);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_image_year_get_sql_count (const gchar* year)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_COUNT_TEMPLATE, year);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_image_year_get_sql_added (const gchar* year)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_ADDED_TEMPLATE, year);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_image_year_get_sql_removed (const gchar* year)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_REMOVED_TEMPLATE, year);
	result = _tmp0_;
	return result;
}

RygelLMSImageYear*
rygel_lms_image_year_construct (GType object_type,
                                RygelMediaContainer* parent,
                                const gchar* year,
                                RygelLMSDatabase* lms_db)
{
	RygelLMSImageYear * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (year != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s", year);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_lms_image_year_get_sql_all (year);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_lms_image_year_get_sql_find_object (year);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_lms_image_year_get_sql_count (year);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_lms_image_year_get_sql_added (year);
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_lms_image_year_get_sql_removed (year);
	_tmp11_ = _tmp10_;
	self = (RygelLMSImageYear*) rygel_lms_category_container_construct (object_type, _tmp1_, parent, year, lms_db, _tmp3_, _tmp5_, _tmp7_, _tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

RygelLMSImageYear*
rygel_lms_image_year_new (RygelMediaContainer* parent,
                          const gchar* year,
                          RygelLMSDatabase* lms_db)
{
	return rygel_lms_image_year_construct (RYGEL_LMS_TYPE_IMAGE_YEAR, parent, year, lms_db);
}

static void
rygel_lms_image_year_class_init (RygelLMSImageYearClass * klass,
                                 gpointer klass_data)
{
	rygel_lms_image_year_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_image_year_real_object_from_statement;
}

static void
rygel_lms_image_year_instance_init (RygelLMSImageYear * self,
                                    gpointer klass)
{
}

static GType
rygel_lms_image_year_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSImageYearClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_image_year_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSImageYear), 0, (GInstanceInitFunc) rygel_lms_image_year_instance_init, NULL };
	GType rygel_lms_image_year_type_id;
	rygel_lms_image_year_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSImageYear", &g_define_type_info, 0);
	return rygel_lms_image_year_type_id;
}

GType
rygel_lms_image_year_get_type (void)
{
	static volatile gsize rygel_lms_image_year_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_image_year_type_id__once)) {
		GType rygel_lms_image_year_type_id;
		rygel_lms_image_year_type_id = rygel_lms_image_year_get_type_once ();
		g_once_init_leave (&rygel_lms_image_year_type_id__once, rygel_lms_image_year_type_id);
	}
	return rygel_lms_image_year_type_id__once;
}

