/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.catalina.Cluster;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JvmRouteBinderValve
extends ValveBase
implements ClusterValve {
    public static final Log log = LogFactory.getLog(JvmRouteBinderValve.class);
    protected CatalinaCluster cluster;
    protected static final StringManager sm = StringManager.getManager(JvmRouteBinderValve.class);
    protected boolean enabled = true;
    protected long numberOfSessions = 0L;
    protected String sessionIdAttribute = "org.apache.catalina.ha.session.JvmRouteOriginalSessionID";

    public JvmRouteBinderValve() {
        super(true);
    }

    public String getSessionIdAttribute() {
        return this.sessionIdAttribute;
    }

    public void setSessionIdAttribute(String string) {
        this.sessionIdAttribute = string;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Manager manager;
        if (this.getEnabled() && request.getContext() != null && request.getContext().getDistributable() && !request.isAsyncDispatching() && (manager = request.getContext().getManager()) != null && (manager instanceof ClusterManager && this.getCluster() != null && this.getCluster().getManager(((ClusterManager)manager).getName()) != null || manager instanceof PersistentManager)) {
            this.handlePossibleTurnover(request);
        }
        this.getNext().invoke(request, response);
    }

    protected void handlePossibleTurnover(Request request) {
        String string = request.getRequestedSessionId();
        if (string != null) {
            long l = System.currentTimeMillis();
            String string2 = this.getLocalJvmRoute(request);
            if (string2 == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jvmRoute.missingJvmRouteAttribute"));
                }
                return;
            }
            this.handleJvmRoute(request, string, string2);
            if (log.isDebugEnabled()) {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                log.debug((Object)sm.getString("jvmRoute.turnoverInfo", new Object[]{l3}));
            }
        }
    }

    protected String getLocalJvmRoute(Request request) {
        Manager manager = this.getManager(request);
        if (manager instanceof ManagerBase) {
            return ((ManagerBase)manager).getJvmRoute();
        }
        return null;
    }

    protected Manager getManager(Request request) {
        Manager manager = request.getContext().getManager();
        if (log.isDebugEnabled()) {
            if (manager != null) {
                log.debug((Object)sm.getString("jvmRoute.foundManager", new Object[]{manager, request.getContext().getName()}));
            } else {
                log.debug((Object)sm.getString("jvmRoute.notFoundManager", new Object[]{request.getContext().getName()}));
            }
        }
        return manager;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster catalinaCluster) {
        this.cluster = catalinaCluster;
    }

    protected void handleJvmRoute(Request request, String string, String string2) {
        String string3 = null;
        int n = string.indexOf(46);
        if (n > 0) {
            string3 = string.substring(n + 1);
        }
        if (string3 != null && !string3.equals(string2)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jvmRoute.failover", new Object[]{string3, string2, string}));
            }
            Session session = null;
            try {
                session = this.getManager(request).findSession(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string4 = string.substring(0, n);
            String string5 = string4 + "." + string2;
            if (session != null) {
                this.changeSessionID(request, string, string5, session);
                ++this.numberOfSessions;
            } else {
                try {
                    session = this.getManager(request).findSession(string5);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (session != null) {
                    this.changeRequestSessionID(request, string, string5);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jvmRoute.cannotFindSession", new Object[]{string}));
                }
            }
        }
    }

    protected void changeSessionID(Request request, String string, String string2, Session session) {
        this.fireLifecycleEvent("Before session migration", session);
        session.getManager().changeSessionId(session, string2);
        this.changeRequestSessionID(request, string, string2);
        this.fireLifecycleEvent("After session migration", session);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jvmRoute.changeSession", new Object[]{string, string2}));
        }
    }

    protected void changeRequestSessionID(Request request, String string, String string2) {
        request.changeSessionId(string2);
        if (this.sessionIdAttribute != null && !this.sessionIdAttribute.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jvmRoute.set.originalsessionid", new Object[]{this.sessionIdAttribute, string}));
            }
            request.setAttribute(this.sessionIdAttribute, (Object)string);
        }
    }

    protected synchronized void startInternal() throws LifecycleException {
        Cluster cluster;
        if (this.cluster == null && (cluster = this.getContainer().getCluster()) instanceof CatalinaCluster) {
            this.setCluster((CatalinaCluster)cluster);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("jvmRoute.valve.started"));
            if (this.cluster == null) {
                log.info((Object)sm.getString("jvmRoute.noCluster"));
            }
        }
        super.startInternal();
    }

    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.cluster = null;
        this.numberOfSessions = 0L;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("jvmRoute.valve.stopped"));
        }
    }
}

