// WARNING: Portions of this file are autogenerated from codes.def and /build/kjs/src/kjs-5.97.0/src/kjs/bytecode/machine.cpp.in.
// (which is what the licensing terms apply to)
// Any changes you make here may be lost!
#line 1 "/build/kjs/src/kjs-5.97.0/src/kjs/bytecode/machine.cpp.in"
/*
 *  Main VM dispatch loop and related routines for KJS/Frostbyte
 *  This file is part of the KDE libraries
 *  Copyright (C) 2008 Maksim Orlovich (maksim@kde.org)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "completion.h"
#include "ExecState.h"
#include "value.h"

#include "nodes.h"
#include "opcodes.h"
#include "LocalStorage.h"
#include "bytecode/opargs.h"
#include "bytecode/machine.h"
#include "scriptfunction.h"
#include "internal.h" // for printInfo
#include "ustring.h"
#include "debugger.h"

#include <stdio.h>

// maximum global call stack size. Protects against accidental or
// malicious infinite recursions. Define to -1 if you want no limit.
#if PLATFORM(DARWIN)
// Given OS X stack sizes we run out of stack at about 350 levels.
// If we improve our stack usage, we can bump this number.
#define KJS_MAX_STACK 100
#else
#define KJS_MAX_STACK 1000 // ### set system specific
#endif

namespace KJS {

#if defined(__GNUC__)
#define USE_LABEL_VALS
#endif

// We can either do jumps via switch or a GCC extension
#ifdef USE_LABEL_VALS
    #define handler(X) l##X
#else
    #define handler(X) case OpByteCode_##X
#endif


// #define COUNT_INSTRS

// A little profiling aid -- counts the # of dynamic instances of each instruction.
#ifdef COUNT_INSTRS

static unsigned instrCounts[OpByteCode_NumValues];

struct InstrCountPrinter
{
    ~InstrCountPrinter() {
        for (int c = 0; c < OpByteCode_NumValues; ++c) {
            printf("%9d %s\n", instrCounts[c], OpByteCodeVals[c]);
        }
    }
};

static InstrCountPrinter dumpCounts;
#endif

// ### Need to consolidate this w/things remaining in nodes.cpp somehow.
static void substitute(UString &string, const UString &substring)
{
    int position = string.find("%s");
    assert(position != -1);
    UString newString = string.substr(0, position);
    newString.append(substring);
    newString.append(string.substr(position + 2));
    string = newString;
}

NEVER_INLINE void throwUndefinedVariableError(ExecState* exec, const Identifier& ident)
{
    UString msg = "Can't find variable: %s";
    substitute(msg, ident.ustring());
    throwError(exec, ReferenceError, msg);
}

static JSValue* typeStringForValue(JSValue* v)
{
    switch (JSValue::type(v)) {
    case UndefinedType:
        return jsString("undefined");
    case NullType:
        return jsString("object");
    case BooleanType:
        return jsString("boolean");
    case NumberType:
        return jsString("number");
    case StringType:
        return jsString("string");
    default:
        if (JSValue::isObject(v)) {
            // Return "undefined" for objects that should be treated
            // as null when doing comparisons.
            if (static_cast<JSObject*>(v)->masqueradeAsUndefined())
                return jsString("undefined");
            else if (static_cast<JSObject*>(v)->isFunctionType())
                return jsString("function");
        }

        return jsString("object");
    }
}

template<bool errorOut, bool trySkipOne, bool replaceActivations>
ALWAYS_INLINE void lookupScopeAndFetch(ExecState* exec, Identifier* varName, JSValue*& scopeOut, JSValue*& valOut)
{
    const ScopeChain& chain = exec->scopeChain();
    ScopeChainIterator iter = chain.begin();
    ScopeChainIterator end = chain.end();

    // we must always have something in the scope chain
    assert(iter != end);

    JSObject *scopeObj = *iter;
    if (trySkipOne && !scopeObj->isLocalInjected()) {
        // Unless eval introduced new variables dynamically,
        // we know this isn't in the top scope
        ++iter;
    }

    PropertySlot slot;
    do {
        scopeObj = *iter;
        ++iter;
        if (scopeObj->getPropertySlot(exec, *varName, slot)) {
            if (!replaceActivations) {
                scopeOut = scopeObj;
            } else {
                // Common case: we found it in global object -- no need to check
                // if it's an activation
                if (iter == end || !scopeObj->isActivation())
                    scopeOut = scopeObj;
                else
                    scopeOut = exec->dynamicInterpreter()->globalObject();
            }
            valOut   = slot.getValue(exec, scopeObj, *varName);
            return;
        }
    } while (iter != end);

    scopeOut = scopeObj;
    valOut = jsUndefined();
    if (errorOut) {
        throwUndefinedVariableError(exec, *varName);
    }
}

static int depth;

NEVER_INLINE JSValue* handleStackOverflow(ExecState* exec) {
    depth -= 11; //Give the debugger some room..
    JSValue *ret = throwError(exec, RangeError, "Maximum call stack size exceeded.");
    depth += 10; //Put it back..
    return ret;
}

enum Dir { Enter, Exit };

NEVER_INLINE void changeDebugContext(Dir d, ExecState* exec, Node* n) {
    FunctionBodyNode* body = static_cast<FunctionBodyNode*>(n);
    Debugger* dbg = exec->dynamicInterpreter()->debugger();
    List args;
    FunctionImp* fn = nullptr;

    // Find the activation that contains arguments, fn
    const ScopeChain& chain = exec->scopeChain();
    for (ScopeChainIterator iter = chain.begin(); iter != chain.end(); ++iter) {
        JSObject* scopeObj = *iter;

        if (scopeObj->isActivation()) {
            ActivationImp* act = static_cast<ActivationImp*>(scopeObj);
            args = act->passedInArguments();
            fn   = static_cast<FunctionImp*>(act->function());
            break;
        }
    }

    if (d == Enter)
        dbg->enterContext(exec, body->sourceId(), body->firstLine(), fn, args);
    else
        dbg->exitContext(exec, body->sourceId(), body->lastLine(), fn);
}

class ForInState: public JSObject {
public:
    PropertyNameArray* array;
    int                pos;

    ForInState() {
        array = new PropertyNameArray;
        pos   = 0;
    }
    
    ~ForInState() override {
        delete array;
    }
};

struct DepthCleanup
{
    ~DepthCleanup() { --depth; }
};


ALWAYS_INLINE_INTO JSValue*
Machine::runBlock(ExecState* exec, const CodeBlock& codeBlock, ExecState* parentExec) {

#ifdef USE_LABEL_VALS
    // Jump table, if needed
static void* kjsVMOpHandlers[] = {
    __extension__ &&lRBool_Int32_Ireg_Ibool, 
    __extension__ &&lRBool_Int32_Ireg_Rbool, 
    __extension__ &&lRBool_Value_Ireg_Ibool, 
    __extension__ &&lRBool_Value_Ireg_Rbool, 
    __extension__ &&lRBool_Number_Ireg_Ibool, 
    __extension__ &&lRBool_Number_Ireg_Rbool, 
    __extension__ &&lRValue_Bool_Ireg_Ivalue_Pad, 
    __extension__ &&lRValue_Bool_Ireg_Ivalue, 
    __extension__ &&lRValue_Bool_Ireg_Rvalue, 
    __extension__ &&lRValue_Int32_Ireg_Ivalue_Pad, 
    __extension__ &&lRValue_Int32_Ireg_Ivalue, 
    __extension__ &&lRValue_Int32_Ireg_Rvalue, 
    __extension__ &&lRValue_Number_Ireg_Ivalue_Pad, 
    __extension__ &&lRValue_Number_Ireg_Ivalue, 
    __extension__ &&lRValue_Number_Ireg_Rvalue, 
    __extension__ &&lRInt32_Bool_Ireg_Iint32, 
    __extension__ &&lRInt32_Bool_Ireg_Rint32, 
    __extension__ &&lRInt32_Value_Ireg_Iint32, 
    __extension__ &&lRInt32_Value_Ireg_Rint32, 
    __extension__ &&lRInt32_Number_Ireg_Iint32, 
    __extension__ &&lRInt32_Number_Ireg_Rint32, 
    __extension__ &&lRNumber_Bool_Ireg_Inumber_Pad, 
    __extension__ &&lRNumber_Bool_Ireg_Inumber, 
    __extension__ &&lRNumber_Bool_Ireg_Rnumber, 
    __extension__ &&lRNumber_Value_Ireg_Inumber_Pad, 
    __extension__ &&lRNumber_Value_Ireg_Inumber, 
    __extension__ &&lRNumber_Value_Ireg_Rnumber, 
    __extension__ &&lRNumber_Int32_Ireg_Inumber_Pad, 
    __extension__ &&lRNumber_Int32_Ireg_Inumber, 
    __extension__ &&lRNumber_Int32_Ireg_Rnumber, 
    __extension__ &&lRInt32_Value_NonImm_Ireg_Iint32, 
    __extension__ &&lRInt32_Value_NonImm_Ireg_Rint32, 
    __extension__ &&lRNum_Value_NonImm_Ireg_Inumber_Pad, 
    __extension__ &&lRNum_Value_NonImm_Ireg_Inumber, 
    __extension__ &&lRNum_Value_NonImm_Ireg_Rnumber, 
    __extension__ &&lPrintInfo_Ivalue_Pad, 
    __extension__ &&lPrintInfo_Ivalue, 
    __extension__ &&lPrintInfo_Rvalue, 
    __extension__ &&lAtStatement_Inode_Pad, 
    __extension__ &&lAtStatement_Inode, 
    __extension__ &&lExit, 
    __extension__ &&lJump_Iaddr, 
    __extension__ &&lIfJump_Ibool_Iaddr, 
    __extension__ &&lIfJump_Rbool_Iaddr, 
    __extension__ &&lIfJump_Rvalue_Iaddr, 
    __extension__ &&lIfNotJump_Ibool_Iaddr, 
    __extension__ &&lIfNotJump_Rbool_Iaddr, 
    __extension__ &&lIfNotJump_Rvalue_Iaddr, 
    __extension__ &&lBeginForIn_Ireg_Ivalue_Ireg_Pad, 
    __extension__ &&lBeginForIn_Ireg_Ivalue_Ireg, 
    __extension__ &&lBeginForIn_Ireg_Rvalue_Ireg, 
    __extension__ &&lNextForInEntry_Ireg_Rvalue_Rvalue_Iaddr, 
    __extension__ &&lPushScope_Ivalue_Pad, 
    __extension__ &&lPushScope_Ivalue, 
    __extension__ &&lPushScope_Rvalue, 
    __extension__ &&lUnwindStacks_Iint32, 
    __extension__ &&lUnwindStacks_Rint32, 
    __extension__ &&lPopScope, 
    __extension__ &&lPopExceptionHandler, 
    __extension__ &&lPushExceptionHandler_Iaddr, 
    __extension__ &&lEnterCatch_Iident_Pad, 
    __extension__ &&lEnterCatch_Iident, 
    __extension__ &&lExitCatch, 
    __extension__ &&lDeferCompletion, 
    __extension__ &&lReactivateCompletion_Ibool, 
    __extension__ &&lReactivateCompletion_Rbool, 
    __extension__ &&lReactivateCompletionDebug_Ibool_Inode_Pad, 
    __extension__ &&lReactivateCompletionDebug_Ibool_Inode, 
    __extension__ &&lReactivateCompletionDebug_Rbool_Inode_Pad, 
    __extension__ &&lReactivateCompletionDebug_Rbool_Inode, 
    __extension__ &&lThrow_Ivalue_Pad, 
    __extension__ &&lThrow_Ivalue, 
    __extension__ &&lThrow_Rvalue, 
    __extension__ &&lContBreakInTryFinally_Iaddr, 
    __extension__ &&lReturnInTryFinally_Ivalue_Pad, 
    __extension__ &&lReturnInTryFinally_Ivalue, 
    __extension__ &&lReturnInTryFinally_Rvalue, 
    __extension__ &&lPropagateException, 
    __extension__ &&lReturn_Ivalue_Pad, 
    __extension__ &&lReturn_Ivalue, 
    __extension__ &&lReturn_Rvalue, 
    __extension__ &&lRaiseError_Inode_Iint32_Icstr_Pad, 
    __extension__ &&lRaiseError_Inode_Iint32_Icstr, 
    __extension__ &&lRaiseError_Inode_Rint32_Icstr_Pad, 
    __extension__ &&lRaiseError_Inode_Rint32_Icstr, 
    __extension__ &&lPreamble_Ireg_Ireg_Ireg, 
    __extension__ &&lEnterDebugContext_Inode_Pad, 
    __extension__ &&lEnterDebugContext_Inode, 
    __extension__ &&lExitDebugContext_Inode_Pad, 
    __extension__ &&lExitDebugContext_Inode, 
    __extension__ &&lFunctionLookupAndGet_Ireg_Ireg_Iident_Pad, 
    __extension__ &&lFunctionLookupAndGet_Ireg_Ireg_Iident, 
    __extension__ &&lNonLocalFunctionLookupAndGet_Ireg_Ireg_Iident_Pad, 
    __extension__ &&lNonLocalFunctionLookupAndGet_Ireg_Ireg_Iident, 
    __extension__ &&lScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad, 
    __extension__ &&lScopeLookupAndGetChecked_Ireg_Ireg_Iident, 
    __extension__ &&lScopeLookupAndGet_Ireg_Ireg_Iident_Pad, 
    __extension__ &&lScopeLookupAndGet_Ireg_Ireg_Iident, 
    __extension__ &&lNonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad, 
    __extension__ &&lNonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident, 
    __extension__ &&lNonLocalScopeLookupAndGet_Ireg_Ireg_Iident_Pad, 
    __extension__ &&lNonLocalScopeLookupAndGet_Ireg_Ireg_Iident, 
    __extension__ &&lScopeLookup_Ireg_Iident_Inode_Pad, 
    __extension__ &&lScopeLookup_Ireg_Iident_Inode, 
    __extension__ &&lNonLocalScopeLookup_Ireg_Iident_Inode_Pad, 
    __extension__ &&lNonLocalScopeLookup_Ireg_Iident_Inode, 
    __extension__ &&lVarGet_Ireg_Iident_Pad, 
    __extension__ &&lVarGet_Ireg_Iident, 
    __extension__ &&lNonLocalVarGet_Ireg_Iident_Pad, 
    __extension__ &&lNonLocalVarGet_Ireg_Iident, 
    __extension__ &&lRegPutValue_Ireg_Ivalue_Pad, 
    __extension__ &&lRegPutValue_Ireg_Ivalue, 
    __extension__ &&lRegPutValue_Ireg_Rvalue, 
    __extension__ &&lRegPutValue_Ireg_Rnumber, 
    __extension__ &&lRegPutNumber_Ireg_Inumber_Pad, 
    __extension__ &&lRegPutNumber_Ireg_Inumber, 
    __extension__ &&lRegPutNumber_Ireg_Rnumber, 
    __extension__ &&lRegPutBool_Ireg_Ibool, 
    __extension__ &&lRegPutBool_Ireg_Rbool, 
    __extension__ &&lRegPutInt32_Ireg_Iint32, 
    __extension__ &&lRegPutInt32_Ireg_Rint32, 
    __extension__ &&lToObject_Ireg_Ivalue_Pad, 
    __extension__ &&lToObject_Ireg_Ivalue, 
    __extension__ &&lToObject_Ireg_Rvalue, 
    __extension__ &&lSymPutKnownObject_Rvalue_Iident_Ivalue_Pad, 
    __extension__ &&lSymPutKnownObject_Rvalue_Iident_Ivalue, 
    __extension__ &&lSymPutKnownObject_Rvalue_Iident_Rvalue_Pad, 
    __extension__ &&lSymPutKnownObject_Rvalue_Iident_Rvalue, 
    __extension__ &&lSymPutKnownObject_Rvalue_Iident_Rnumber_Pad, 
    __extension__ &&lSymPutKnownObject_Rvalue_Iident_Rnumber, 
    __extension__ &&lSymGet_Ireg_Ivalue_Iident_Pad, 
    __extension__ &&lSymGet_Ireg_Ivalue_Iident, 
    __extension__ &&lSymGet_Ireg_Rvalue_Iident_Pad, 
    __extension__ &&lSymGet_Ireg_Rvalue_Iident, 
    __extension__ &&lSymGetKnownObject_Ireg_Ivalue_Iident_Pad, 
    __extension__ &&lSymGetKnownObject_Ireg_Ivalue_Iident, 
    __extension__ &&lSymGetKnownObject_Ireg_Rvalue_Iident_Pad, 
    __extension__ &&lSymGetKnownObject_Ireg_Rvalue_Iident, 
    __extension__ &&lSymGetAndBind_Ireg_Ireg_Rvalue_Iident_Pad, 
    __extension__ &&lSymGetAndBind_Ireg_Ireg_Rvalue_Iident, 
    __extension__ &&lBracketGet_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lBracketGet_Ireg_Rvalue_Ivalue, 
    __extension__ &&lBracketGet_Ireg_Rvalue_Rvalue, 
    __extension__ &&lBracketGet_Ireg_Rvalue_Iint32, 
    __extension__ &&lBracketGet_Ireg_Rvalue_Rint32, 
    __extension__ &&lBracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lBracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue, 
    __extension__ &&lBracketGetAndBind_Ireg_Ireg_Rvalue_Rvalue, 
    __extension__ &&lBracketGetAndBind_Ireg_Ireg_Rvalue_Iint32, 
    __extension__ &&lBracketGetAndBind_Ireg_Ireg_Rvalue_Rint32, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Ivalue_Ivalue_Pad, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Ivalue_Ivalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Ivalue_Rvalue_Pad, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Ivalue_Rvalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Rvalue_Ivalue_Pad, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Rvalue_Ivalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Rvalue_Rvalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Iint32_Ivalue_Pad, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Iint32_Ivalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Iint32_Rvalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Rint32_Ivalue_Pad, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Rint32_Ivalue, 
    __extension__ &&lBracketPutKnownObject_Rvalue_Rint32_Rvalue, 
    __extension__ &&lGlobalObjectGet_Ireg_Iident_Pad, 
    __extension__ &&lGlobalObjectGet_Ireg_Iident, 
    __extension__ &&lSymDeleteKnownObject_Ireg_Ivalue_Iident_Pad, 
    __extension__ &&lSymDeleteKnownObject_Ireg_Ivalue_Iident, 
    __extension__ &&lSymDeleteKnownObject_Ireg_Rvalue_Iident_Pad, 
    __extension__ &&lSymDeleteKnownObject_Ireg_Rvalue_Iident, 
    __extension__ &&lSymDelete_Ireg_Ivalue_Iident_Pad, 
    __extension__ &&lSymDelete_Ireg_Ivalue_Iident, 
    __extension__ &&lSymDelete_Ireg_Rvalue_Iident_Pad, 
    __extension__ &&lSymDelete_Ireg_Rvalue_Iident, 
    __extension__ &&lBracketDelete_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lBracketDelete_Ireg_Rvalue_Ivalue, 
    __extension__ &&lBracketDelete_Ireg_Rvalue_Rvalue, 
    __extension__ &&lBracketDelete_Ireg_Ivalue_Iint32_Pad, 
    __extension__ &&lBracketDelete_Ireg_Ivalue_Iint32, 
    __extension__ &&lBracketDelete_Ireg_Ivalue_Rint32_Pad, 
    __extension__ &&lBracketDelete_Ireg_Ivalue_Rint32, 
    __extension__ &&lBracketDelete_Ireg_Rvalue_Iint32, 
    __extension__ &&lBracketDelete_Ireg_Rvalue_Rint32, 
    __extension__ &&lOwnedString_Ireg_Istring_Pad, 
    __extension__ &&lOwnedString_Ireg_Istring, 
    __extension__ &&lNewEmptyArray_Ireg, 
    __extension__ &&lNewObject_Ireg, 
    __extension__ &&lNewRegExp_Ireg_Istring_Istring_Pad, 
    __extension__ &&lNewRegExp_Ireg_Istring_Istring, 
    __extension__ &&lDefineGetter_Rvalue_Iident_Ivalue_Pad, 
    __extension__ &&lDefineGetter_Rvalue_Iident_Ivalue, 
    __extension__ &&lDefineGetter_Rvalue_Iident_Rvalue_Pad, 
    __extension__ &&lDefineGetter_Rvalue_Iident_Rvalue, 
    __extension__ &&lDefineSetter_Rvalue_Iident_Ivalue_Pad, 
    __extension__ &&lDefineSetter_Rvalue_Iident_Ivalue, 
    __extension__ &&lDefineSetter_Rvalue_Iident_Rvalue_Pad, 
    __extension__ &&lDefineSetter_Rvalue_Iident_Rvalue, 
    __extension__ &&lAdd1_Ireg_Inumber_Pad, 
    __extension__ &&lAdd1_Ireg_Inumber, 
    __extension__ &&lAdd1_Ireg_Rnumber, 
    __extension__ &&lAdd1_Ireg_Rvalue, 
    __extension__ &&lSub1_Ireg_Inumber_Pad, 
    __extension__ &&lSub1_Ireg_Inumber, 
    __extension__ &&lSub1_Ireg_Rnumber, 
    __extension__ &&lNeg_Ireg_Inumber_Pad, 
    __extension__ &&lNeg_Ireg_Inumber, 
    __extension__ &&lNeg_Ireg_Rnumber, 
    __extension__ &&lNeg_Ireg_Rvalue, 
    __extension__ &&lMult_Ireg_Inumber_Inumber_Pad, 
    __extension__ &&lMult_Ireg_Inumber_Inumber, 
    __extension__ &&lMult_Ireg_Inumber_Rnumber_Pad, 
    __extension__ &&lMult_Ireg_Inumber_Rnumber, 
    __extension__ &&lMult_Ireg_Rnumber_Inumber_Pad, 
    __extension__ &&lMult_Ireg_Rnumber_Inumber, 
    __extension__ &&lMult_Ireg_Rnumber_Rnumber, 
    __extension__ &&lMult_Ireg_Rvalue_Rvalue, 
    __extension__ &&lMult_Ireg_Rvalue_Rnumber, 
    __extension__ &&lMult_Ireg_Rnumber_Rvalue, 
    __extension__ &&lDiv_Ireg_Inumber_Inumber_Pad, 
    __extension__ &&lDiv_Ireg_Inumber_Inumber, 
    __extension__ &&lDiv_Ireg_Inumber_Rnumber_Pad, 
    __extension__ &&lDiv_Ireg_Inumber_Rnumber, 
    __extension__ &&lDiv_Ireg_Rnumber_Inumber_Pad, 
    __extension__ &&lDiv_Ireg_Rnumber_Inumber, 
    __extension__ &&lDiv_Ireg_Rnumber_Rnumber, 
    __extension__ &&lMod_Ireg_Inumber_Inumber_Pad, 
    __extension__ &&lMod_Ireg_Inumber_Inumber, 
    __extension__ &&lMod_Ireg_Inumber_Rnumber_Pad, 
    __extension__ &&lMod_Ireg_Inumber_Rnumber, 
    __extension__ &&lMod_Ireg_Rnumber_Inumber_Pad, 
    __extension__ &&lMod_Ireg_Rnumber_Inumber, 
    __extension__ &&lMod_Ireg_Rnumber_Rnumber, 
    __extension__ &&lExp_Ireg_Inumber_Inumber_Pad, 
    __extension__ &&lExp_Ireg_Inumber_Inumber, 
    __extension__ &&lExp_Ireg_Inumber_Rnumber_Pad, 
    __extension__ &&lExp_Ireg_Inumber_Rnumber, 
    __extension__ &&lExp_Ireg_Rnumber_Inumber_Pad, 
    __extension__ &&lExp_Ireg_Rnumber_Inumber, 
    __extension__ &&lExp_Ireg_Rnumber_Rnumber, 
    __extension__ &&lSub_Ireg_Inumber_Inumber_Pad, 
    __extension__ &&lSub_Ireg_Inumber_Inumber, 
    __extension__ &&lSub_Ireg_Inumber_Rnumber_Pad, 
    __extension__ &&lSub_Ireg_Inumber_Rnumber, 
    __extension__ &&lSub_Ireg_Rnumber_Inumber_Pad, 
    __extension__ &&lSub_Ireg_Rnumber_Inumber, 
    __extension__ &&lSub_Ireg_Rnumber_Rnumber, 
    __extension__ &&lAdd_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lAdd_Ireg_Ivalue_Ivalue, 
    __extension__ &&lAdd_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lAdd_Ireg_Ivalue_Rvalue, 
    __extension__ &&lAdd_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lAdd_Ireg_Rvalue_Ivalue, 
    __extension__ &&lAdd_Ireg_Rvalue_Rvalue, 
    __extension__ &&lAdd_Ireg_Inumber_Inumber_Pad, 
    __extension__ &&lAdd_Ireg_Inumber_Inumber, 
    __extension__ &&lAdd_Ireg_Inumber_Rnumber_Pad, 
    __extension__ &&lAdd_Ireg_Inumber_Rnumber, 
    __extension__ &&lAdd_Ireg_Rnumber_Inumber_Pad, 
    __extension__ &&lAdd_Ireg_Rnumber_Inumber, 
    __extension__ &&lAdd_Ireg_Rnumber_Rnumber, 
    __extension__ &&lLShift_Ireg_Iint32_Iint32, 
    __extension__ &&lLShift_Ireg_Iint32_Rint32, 
    __extension__ &&lLShift_Ireg_Rint32_Iint32, 
    __extension__ &&lLShift_Ireg_Rint32_Rint32, 
    __extension__ &&lRShift_Ireg_Iint32_Iint32, 
    __extension__ &&lRShift_Ireg_Iint32_Rint32, 
    __extension__ &&lRShift_Ireg_Rint32_Iint32, 
    __extension__ &&lRShift_Ireg_Rint32_Rint32, 
    __extension__ &&lURShift_Ireg_Iint32_Iint32, 
    __extension__ &&lURShift_Ireg_Iint32_Rint32, 
    __extension__ &&lURShift_Ireg_Rint32_Iint32, 
    __extension__ &&lURShift_Ireg_Rint32_Rint32, 
    __extension__ &&lLess_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lLess_Ireg_Ivalue_Ivalue, 
    __extension__ &&lLess_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lLess_Ireg_Ivalue_Rvalue, 
    __extension__ &&lLess_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lLess_Ireg_Rvalue_Ivalue, 
    __extension__ &&lLess_Ireg_Rvalue_Rvalue, 
    __extension__ &&lLess_Ireg_Ivalue_Inumber_Pad, 
    __extension__ &&lLess_Ireg_Ivalue_Inumber, 
    __extension__ &&lLess_Ireg_Ivalue_Rnumber_Pad, 
    __extension__ &&lLess_Ireg_Ivalue_Rnumber, 
    __extension__ &&lLess_Ireg_Rvalue_Inumber_Pad, 
    __extension__ &&lLess_Ireg_Rvalue_Inumber, 
    __extension__ &&lLess_Ireg_Rvalue_Rnumber, 
    __extension__ &&lLess_Ireg_Ivalue_Iint32_Pad, 
    __extension__ &&lLess_Ireg_Ivalue_Iint32, 
    __extension__ &&lLess_Ireg_Ivalue_Rint32_Pad, 
    __extension__ &&lLess_Ireg_Ivalue_Rint32, 
    __extension__ &&lLess_Ireg_Rvalue_Iint32, 
    __extension__ &&lLess_Ireg_Rvalue_Rint32, 
    __extension__ &&lGreaterEq_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lGreaterEq_Ireg_Ivalue_Ivalue, 
    __extension__ &&lGreaterEq_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lGreaterEq_Ireg_Ivalue_Rvalue, 
    __extension__ &&lGreaterEq_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lGreaterEq_Ireg_Rvalue_Ivalue, 
    __extension__ &&lGreaterEq_Ireg_Rvalue_Rvalue, 
    __extension__ &&lGreater_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lGreater_Ireg_Ivalue_Ivalue, 
    __extension__ &&lGreater_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lGreater_Ireg_Ivalue_Rvalue, 
    __extension__ &&lGreater_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lGreater_Ireg_Rvalue_Ivalue, 
    __extension__ &&lGreater_Ireg_Rvalue_Rvalue, 
    __extension__ &&lLessEq_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lLessEq_Ireg_Ivalue_Ivalue, 
    __extension__ &&lLessEq_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lLessEq_Ireg_Ivalue_Rvalue, 
    __extension__ &&lLessEq_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lLessEq_Ireg_Rvalue_Ivalue, 
    __extension__ &&lLessEq_Ireg_Rvalue_Rvalue, 
    __extension__ &&lEqEq_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lEqEq_Ireg_Ivalue_Ivalue, 
    __extension__ &&lEqEq_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lEqEq_Ireg_Ivalue_Rvalue, 
    __extension__ &&lEqEq_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lEqEq_Ireg_Rvalue_Ivalue, 
    __extension__ &&lEqEq_Ireg_Rvalue_Rvalue, 
    __extension__ &&lEqEq_Ireg_Ivalue_Iint32_Pad, 
    __extension__ &&lEqEq_Ireg_Ivalue_Iint32, 
    __extension__ &&lEqEq_Ireg_Ivalue_Rint32_Pad, 
    __extension__ &&lEqEq_Ireg_Ivalue_Rint32, 
    __extension__ &&lEqEq_Ireg_Rvalue_Iint32, 
    __extension__ &&lEqEq_Ireg_Rvalue_Rint32, 
    __extension__ &&lNotEq_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lNotEq_Ireg_Ivalue_Ivalue, 
    __extension__ &&lNotEq_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lNotEq_Ireg_Ivalue_Rvalue, 
    __extension__ &&lNotEq_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lNotEq_Ireg_Rvalue_Ivalue, 
    __extension__ &&lNotEq_Ireg_Rvalue_Rvalue, 
    __extension__ &&lNotEq_Ireg_Ivalue_Iint32_Pad, 
    __extension__ &&lNotEq_Ireg_Ivalue_Iint32, 
    __extension__ &&lNotEq_Ireg_Ivalue_Rint32_Pad, 
    __extension__ &&lNotEq_Ireg_Ivalue_Rint32, 
    __extension__ &&lNotEq_Ireg_Rvalue_Iint32, 
    __extension__ &&lNotEq_Ireg_Rvalue_Rint32, 
    __extension__ &&lStrEq_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lStrEq_Ireg_Ivalue_Ivalue, 
    __extension__ &&lStrEq_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lStrEq_Ireg_Ivalue_Rvalue, 
    __extension__ &&lStrEq_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lStrEq_Ireg_Rvalue_Ivalue, 
    __extension__ &&lStrEq_Ireg_Rvalue_Rvalue, 
    __extension__ &&lStrNEq_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lStrNEq_Ireg_Ivalue_Ivalue, 
    __extension__ &&lStrNEq_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lStrNEq_Ireg_Ivalue_Rvalue, 
    __extension__ &&lStrNEq_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lStrNEq_Ireg_Rvalue_Ivalue, 
    __extension__ &&lStrNEq_Ireg_Rvalue_Rvalue, 
    __extension__ &&lBitNot_Ireg_Iint32, 
    __extension__ &&lBitNot_Ireg_Rint32, 
    __extension__ &&lBitAnd_Ireg_Iint32_Iint32, 
    __extension__ &&lBitAnd_Ireg_Iint32_Rint32, 
    __extension__ &&lBitAnd_Ireg_Rint32_Iint32, 
    __extension__ &&lBitAnd_Ireg_Rint32_Rint32, 
    __extension__ &&lBitAnd_Ireg_Rvalue_Rvalue, 
    __extension__ &&lBitAnd_Ireg_Rvalue_Rint32, 
    __extension__ &&lBitAnd_Ireg_Rint32_Rvalue, 
    __extension__ &&lBitXOr_Ireg_Iint32_Iint32, 
    __extension__ &&lBitXOr_Ireg_Iint32_Rint32, 
    __extension__ &&lBitXOr_Ireg_Rint32_Iint32, 
    __extension__ &&lBitXOr_Ireg_Rint32_Rint32, 
    __extension__ &&lBitOr_Ireg_Iint32_Iint32, 
    __extension__ &&lBitOr_Ireg_Iint32_Rint32, 
    __extension__ &&lBitOr_Ireg_Rint32_Iint32, 
    __extension__ &&lBitOr_Ireg_Rint32_Rint32, 
    __extension__ &&lLogicalNot_Ireg_Ibool, 
    __extension__ &&lLogicalNot_Ireg_Rbool, 
    __extension__ &&lTypeOf_Ireg_Ivalue_Pad, 
    __extension__ &&lTypeOf_Ireg_Ivalue, 
    __extension__ &&lTypeOf_Ireg_Rvalue, 
    __extension__ &&lIn_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lIn_Ireg_Ivalue_Ivalue, 
    __extension__ &&lIn_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lIn_Ireg_Ivalue_Rvalue, 
    __extension__ &&lIn_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lIn_Ireg_Rvalue_Ivalue, 
    __extension__ &&lIn_Ireg_Rvalue_Rvalue, 
    __extension__ &&lInstanceOf_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lInstanceOf_Ireg_Ivalue_Ivalue, 
    __extension__ &&lInstanceOf_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lInstanceOf_Ireg_Ivalue_Rvalue, 
    __extension__ &&lInstanceOf_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lInstanceOf_Ireg_Rvalue_Ivalue, 
    __extension__ &&lInstanceOf_Ireg_Rvalue_Rvalue, 
    __extension__ &&lClearArgs, 
    __extension__ &&lAddArg_Ivalue_Pad, 
    __extension__ &&lAddArg_Ivalue, 
    __extension__ &&lAddArg_Rvalue, 
    __extension__ &&lAdd2Arg_Ivalue_Ivalue_Pad, 
    __extension__ &&lAdd2Arg_Ivalue_Ivalue, 
    __extension__ &&lAdd2Arg_Ivalue_Rvalue_Pad, 
    __extension__ &&lAdd2Arg_Ivalue_Rvalue, 
    __extension__ &&lAdd2Arg_Rvalue_Ivalue_Pad, 
    __extension__ &&lAdd2Arg_Rvalue_Ivalue, 
    __extension__ &&lAdd2Arg_Rvalue_Rvalue, 
    __extension__ &&lAdd3Arg_Ivalue_Ivalue_Ivalue_Pad, 
    __extension__ &&lAdd3Arg_Ivalue_Ivalue_Ivalue, 
    __extension__ &&lAdd3Arg_Ivalue_Ivalue_Rvalue_Pad, 
    __extension__ &&lAdd3Arg_Ivalue_Ivalue_Rvalue, 
    __extension__ &&lAdd3Arg_Ivalue_Rvalue_Ivalue_Pad, 
    __extension__ &&lAdd3Arg_Ivalue_Rvalue_Ivalue, 
    __extension__ &&lAdd3Arg_Ivalue_Rvalue_Rvalue_Pad, 
    __extension__ &&lAdd3Arg_Ivalue_Rvalue_Rvalue, 
    __extension__ &&lAdd3Arg_Rvalue_Ivalue_Ivalue_Pad, 
    __extension__ &&lAdd3Arg_Rvalue_Ivalue_Ivalue, 
    __extension__ &&lAdd3Arg_Rvalue_Ivalue_Rvalue_Pad, 
    __extension__ &&lAdd3Arg_Rvalue_Ivalue_Rvalue, 
    __extension__ &&lAdd3Arg_Rvalue_Rvalue_Ivalue_Pad, 
    __extension__ &&lAdd3Arg_Rvalue_Rvalue_Ivalue, 
    __extension__ &&lAdd3Arg_Rvalue_Rvalue_Rvalue, 
    __extension__ &&lFunctionCall_Ireg_Ivalue_Ivalue_Pad, 
    __extension__ &&lFunctionCall_Ireg_Ivalue_Ivalue, 
    __extension__ &&lFunctionCall_Ireg_Ivalue_Rvalue_Pad, 
    __extension__ &&lFunctionCall_Ireg_Ivalue_Rvalue, 
    __extension__ &&lFunctionCall_Ireg_Rvalue_Ivalue_Pad, 
    __extension__ &&lFunctionCall_Ireg_Rvalue_Ivalue, 
    __extension__ &&lFunctionCall_Ireg_Rvalue_Rvalue, 
    __extension__ &&lCtorCall_Ireg_Ivalue_Pad, 
    __extension__ &&lCtorCall_Ireg_Ivalue, 
    __extension__ &&lCtorCall_Ireg_Rvalue, 
    __extension__ &&lEvalFuncExpr_Ireg_Iident_Inode_Pad, 
    __extension__ &&lEvalFuncExpr_Ireg_Iident_Inode
};

#line 233 "/build/kjs/src/kjs-5.97.0/src/kjs/bytecode/machine.cpp.in"
#endif

    ++depth;
    if (depth > KJS_MAX_STACK)
        return handleStackOverflow(exec);

    DepthCleanup dc;

    const unsigned char* base = codeBlock.data();
    const unsigned char* pc   = base;
    List workList;
    LocalStorageEntry* localStore = exec->localStorage();
    exec->setMachineRegisters(base, &pc, &localStore);
    JSObject* globalObject = exec->dynamicInterpreter()->globalObject();

    while (true) {
	// did a alarm handler get called in the meantime?
	// ### TODO Can we avoid doing this check in the loop? Ideally
	// the alarm handler in interpreter.cpp changes 'pc' to an
	// exit opcode. But that's unsafe in a signal handler that can
	// interrupt the machine execution at any time??
	if (exec->dynamicInterpreter()->checkTimeout()) {
	    throwError(exec,  GeneralError, "Execution timeout. Aborting.");
	    return jsUndefined();
	}
#ifdef COUNT_INSTRS
        OpByteCode opCodeLog = *reinterpret_cast<const OpByteCode*>(pc);
        ++instrCounts[opCodeLog];
#endif
        OpByteCode op = *reinterpret_cast<const OpByteCode*>(pc);
#ifdef USE_LABEL_VALS
        goto *kjsVMOpHandlers[op];
        {
#else
        switch (op) {
#endif
            handler(RBool_Int32_Ireg_Ibool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool in = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
#line 78 "codes.def"
                int32_t out = convertIBool_Int32(exec, in);
                localStore[fbDestReg].val.int32Val = out;
            }
            continue;

            handler(RBool_Int32_Ireg_Rbool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
#line 78 "codes.def"
                int32_t out = convertIBool_Int32(exec, in);
                localStore[fbDestReg].val.int32Val = out;
            }
            continue;

            handler(RBool_Value_Ireg_Ibool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool in = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
#line 87 "codes.def"
                JSValue* out = convertIBool_Value(exec, in);
                localStore[fbDestReg].val.valueVal = out;
            }
            continue;

            handler(RBool_Value_Ireg_Rbool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
#line 87 "codes.def"
                JSValue* out = convertIBool_Value(exec, in);
                localStore[fbDestReg].val.valueVal = out;
            }
            continue;

            handler(RBool_Number_Ireg_Ibool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool in = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
#line 96 "codes.def"
                double out = convertIBool_Number(exec, in);
                localStore[fbDestReg].val.numberVal = out;
            }
            continue;

            handler(RBool_Number_Ireg_Rbool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
#line 96 "codes.def"
                double out = convertIBool_Number(exec, in);
                localStore[fbDestReg].val.numberVal = out;
            }
            continue;

            handler(RValue_Bool_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(RValue_Bool_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* in = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 108 "codes.def"
                bool out = convertIValue_Bool(exec, in);
                localStore[fbDestReg].val.boolVal = out;
            }
            continue;

            handler(RValue_Bool_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 108 "codes.def"
                bool out = convertIValue_Bool(exec, in);
                localStore[fbDestReg].val.boolVal = out;
            }
            continue;

            handler(RValue_Int32_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(RValue_Int32_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* in = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 117 "codes.def"
                int32_t out = convertIValue_Int32(exec, in);
                localStore[fbDestReg].val.int32Val = out;
            }
            continue;

            handler(RValue_Int32_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 117 "codes.def"
                int32_t out = convertIValue_Int32(exec, in);
                localStore[fbDestReg].val.int32Val = out;
            }
            continue;

            handler(RValue_Number_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(RValue_Number_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* in = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 126 "codes.def"
                double out = convertIValue_Number(exec, in);
                localStore[fbDestReg].val.numberVal = out;
            }
            continue;

            handler(RValue_Number_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 126 "codes.def"
                double out = convertIValue_Number(exec, in);
                localStore[fbDestReg].val.numberVal = out;
            }
            continue;

            handler(RInt32_Bool_Ireg_Iint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t in = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 138 "codes.def"
                bool out = convertIInt32_Bool(exec, in);
                localStore[fbDestReg].val.boolVal = out;
            }
            continue;

            handler(RInt32_Bool_Ireg_Rint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 138 "codes.def"
                bool out = convertIInt32_Bool(exec, in);
                localStore[fbDestReg].val.boolVal = out;
            }
            continue;

            handler(RInt32_Value_Ireg_Iint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t in = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 147 "codes.def"
                JSValue* out = convertIInt32_Value(exec, in);
                localStore[fbDestReg].val.valueVal = out;
            }
            continue;

            handler(RInt32_Value_Ireg_Rint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 147 "codes.def"
                JSValue* out = convertIInt32_Value(exec, in);
                localStore[fbDestReg].val.valueVal = out;
            }
            continue;

            handler(RInt32_Number_Ireg_Iint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t in = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 156 "codes.def"
                double out = convertIInt32_Number(exec, in);
                localStore[fbDestReg].val.numberVal = out;
            }
            continue;

            handler(RInt32_Number_Ireg_Rint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 156 "codes.def"
                double out = convertIInt32_Number(exec, in);
                localStore[fbDestReg].val.numberVal = out;
            }
            continue;

            handler(RNumber_Bool_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(RNumber_Bool_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double in = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 168 "codes.def"
                bool out = convertINumber_Bool(exec, in);
                localStore[fbDestReg].val.boolVal = out;
            }
            continue;

            handler(RNumber_Bool_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 168 "codes.def"
                bool out = convertINumber_Bool(exec, in);
                localStore[fbDestReg].val.boolVal = out;
            }
            continue;

            handler(RNumber_Value_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(RNumber_Value_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double in = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 177 "codes.def"
                JSValue* out = convertINumber_Value(exec, in);
                localStore[fbDestReg].val.valueVal = out;
            }
            continue;

            handler(RNumber_Value_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 177 "codes.def"
                JSValue* out = convertINumber_Value(exec, in);
                localStore[fbDestReg].val.valueVal = out;
            }
            continue;

            handler(RNumber_Int32_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(RNumber_Int32_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double in = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 186 "codes.def"
                int32_t out = convertINumber_Int32(exec, in);
                localStore[fbDestReg].val.int32Val = out;
            }
            continue;

            handler(RNumber_Int32_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 186 "codes.def"
                int32_t out = convertINumber_Int32(exec, in);
                localStore[fbDestReg].val.int32Val = out;
            }
            continue;

            handler(RInt32_Value_NonImm_Ireg_Iint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t val = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 200 "codes.def"
                localStore[fbDestReg].val.valueVal = jsNumberCell(val);
            }
            continue;

            handler(RInt32_Value_NonImm_Ireg_Rint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 200 "codes.def"
                localStore[fbDestReg].val.valueVal = jsNumberCell(val);
            }
            continue;

            handler(RNum_Value_NonImm_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(RNum_Value_NonImm_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double val = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 206 "codes.def"
                localStore[fbDestReg].val.valueVal = jsNumberCell(val);
            }
            continue;

            handler(RNum_Value_NonImm_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 206 "codes.def"
                localStore[fbDestReg].val.valueVal = jsNumberCell(val);
            }
            continue;

            handler(PrintInfo_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(PrintInfo_Ivalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* in = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 221 "codes.def"
                printInfo(exec, "", in);
            }
            continue;

            handler(PrintInfo_Rvalue): {
                pc += 8;
                const unsigned char* localPC = pc;
                JSValue* in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 221 "codes.def"
                printInfo(exec, "", in);
            }
            continue;

            handler(AtStatement_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(AtStatement_Inode): {
                pc += 12;
                const unsigned char* localPC = pc;
                Node* in = reinterpret_cast<const WideArg*>(localPC -8)->nodeVal;
#line 230 "codes.def"
                static_cast<StatementNode*>(in)->hitStatement(exec);
            }
            continue;

            handler(Exit): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 239 "codes.def"
                return jsUndefined();
            }
            continue;

            handler(Jump_Iaddr): {
                pc += 8;
                const unsigned char* localPC = pc;
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 245 "codes.def"
                pc = base + dest;
            }
            continue;

            handler(IfJump_Ibool_Iaddr): {
                pc += 12;
                const unsigned char* localPC = pc;
                bool condResult = reinterpret_cast<const NarrowArg*>(localPC -8)->boolVal;
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 251 "codes.def"
                if (condResult)
                    pc = base + dest;
            }
            continue;

            handler(IfJump_Rbool_Iaddr): {
                pc += 12;
                const unsigned char* localPC = pc;
                bool condResult = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.boolVal;
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 251 "codes.def"
                if (condResult)
                    pc = base + dest;
            }
            continue;

            handler(IfJump_Rvalue_Iaddr): {
                pc += 12;
                const unsigned char* localPC = pc;
                bool condResult = convertIValue_Bool(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal);
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 251 "codes.def"
                if (condResult)
                    pc = base + dest;
            }
            continue;

            handler(IfNotJump_Ibool_Iaddr): {
                pc += 12;
                const unsigned char* localPC = pc;
                bool condResult = reinterpret_cast<const NarrowArg*>(localPC -8)->boolVal;
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 260 "codes.def"
                if (!condResult)
                    pc = base +dest;
            }
            continue;

            handler(IfNotJump_Rbool_Iaddr): {
                pc += 12;
                const unsigned char* localPC = pc;
                bool condResult = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.boolVal;
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 260 "codes.def"
                if (!condResult)
                    pc = base +dest;
            }
            continue;

            handler(IfNotJump_Rvalue_Iaddr): {
                pc += 12;
                const unsigned char* localPC = pc;
                bool condResult = convertIValue_Bool(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal);
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 260 "codes.def"
                if (!condResult)
                    pc = base +dest;
            }
            continue;

            handler(BeginForIn_Ireg_Ivalue_Ireg_Pad):
                pc += 4;
                // Fallthrough
            handler(BeginForIn_Ireg_Ivalue_Ireg): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* e = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                Register stateReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
#line 271 "codes.def"
                ForInState* st = new ForInState();
                localStore[stateReg].val.valueVal = st;

                if (!JSValue::isUndefinedOrNull(e)) {
                    JSObject* v = JSValue::toObject(e, exec);
                    // The above might raise an exception..
                    if (pc != localPC) continue;

                    v->getPropertyNames(exec, *st->array);
                    localStore[fbDestReg].val.valueVal = v;
                } else {
                    // empty array, so this doesn't matter.
                    localStore[fbDestReg].val.valueVal = jsUndefined();
                }
            }
            continue;

            handler(BeginForIn_Ireg_Rvalue_Ireg): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* e = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                Register stateReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
#line 271 "codes.def"
                ForInState* st = new ForInState();
                localStore[stateReg].val.valueVal = st;

                if (!JSValue::isUndefinedOrNull(e)) {
                    JSObject* v = JSValue::toObject(e, exec);
                    // The above might raise an exception..
                    if (pc != localPC) continue;

                    v->getPropertyNames(exec, *st->array);
                    localStore[fbDestReg].val.valueVal = v;
                } else {
                    // empty array, so this doesn't matter.
                    localStore[fbDestReg].val.valueVal = jsUndefined();
                }
            }
            continue;

            handler(NextForInEntry_Ireg_Rvalue_Rvalue_Iaddr): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -16)->regVal;
                JSValue* e = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -12)->regVal)->val.valueVal;
                JSValue* ctx = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                Addr jumpToIfDone = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 290 "codes.def"
                ForInState* st = static_cast<ForInState*>(ctx);
                PropertyNameArray& pa  = *st->array;

                // Invariant: pos = next entry to consider.
                int& pos = st->pos;

                localStore[fbDestReg].val.valueVal = jsUndefined();
                while (pos < pa.size()) {
                    ASSERT(JSValue::isObject(e));
                    JSObject* v = static_cast<JSObject*>(e);

                    Identifier& name = pa[pos];
                    ++pos;

                    if (v->hasProperty(exec, name)) {
                        // Wasn't deleted during iteration..
                        localStore[fbDestReg].val.valueVal = jsOwnedString(name.ustring());
                        break;
                    }
                }

                if (localStore[fbDestReg].val.valueVal == jsUndefined()) // Nothing found. Jump to end of the loop
                    pc = base + jumpToIfDone;
            }
            continue;

            handler(PushScope_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(PushScope_Ivalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* in = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 320 "codes.def"
                JSObject* obj = JSValue::toObject(in, exec);
                if (exec->hadException())
                    continue; // will jump to handler.

                exec->pushScope(obj);
                exec->pushExceptionHandler(ExecState::PopScope);
            }
            continue;

            handler(PushScope_Rvalue): {
                pc += 8;
                const unsigned char* localPC = pc;
                JSValue* in = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 320 "codes.def"
                JSObject* obj = JSValue::toObject(in, exec);
                if (exec->hadException())
                    continue; // will jump to handler.

                exec->pushScope(obj);
                exec->pushExceptionHandler(ExecState::PopScope);
            }
            continue;

            handler(UnwindStacks_Iint32): {
                pc += 8;
                const unsigned char* localPC = pc;
                int32_t handlers = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 331 "codes.def"
                // This op is used when a break or continue is used to jump out
                // of a context that updated various stacks in ExecState,
                // in order to clean them up. Each of those ops contributes an
                // entry to the main exception handler stack, and perhaps some others.
                // We unwind the main stack, using the cleanup entries on it as appropriate.
                exec->quietUnwind(handlers);
            }
            continue;

            handler(UnwindStacks_Rint32): {
                pc += 8;
                const unsigned char* localPC = pc;
                int32_t handlers = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 331 "codes.def"
                // This op is used when a break or continue is used to jump out
                // of a context that updated various stacks in ExecState,
                // in order to clean them up. Each of those ops contributes an
                // entry to the main exception handler stack, and perhaps some others.
                // We unwind the main stack, using the cleanup entries on it as appropriate.
                exec->quietUnwind(handlers);
            }
            continue;

            handler(PopScope): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 342 "codes.def"
                // As PushScope does not Push anything on Exception case, we can not Pop.
                // NOTE: the Exception checking on Push/Pop-Scope is not optimal.
                // Such a Situation, where PushScope already has a Exception can only
                // occur if import is used inside the the "with"-statement. As import is
                // executed at the beginning of the code (as val decl) and can leave a exception.
                // As "import" is not (yet) part of ECMA-262 the correct behavior is unknown
                // when this changes we can rework the behavior, but for now just fix the crash.
                if (exec->hadException())
                        continue;

                exec->popScope();
                exec->popExceptionHandler();
            }
            continue;

            handler(PopExceptionHandler): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 359 "codes.def"
                exec->popExceptionHandler();
            }
            continue;

            handler(PushExceptionHandler_Iaddr): {
                pc += 8;
                const unsigned char* localPC = pc;
                Addr handler = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 365 "codes.def"
                exec->pushExceptionHandler(ExecState::JumpToCatch, handler);
            }
            continue;

            handler(EnterCatch_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(EnterCatch_Iident): {
                pc += 12;
                const unsigned char* localPC = pc;
                Identifier* exceptionIdent = reinterpret_cast<const WideArg*>(localPC -8)->identVal;
#line 371 "codes.def"
                // First, check if we have a non-exception indirect continuation,
                // if so, we re-raise it directly to the finally (and skip the rest of the catch section)
                if (exec->abruptCompletion().complType() != Throw) {
                    // By this point, the previous handler has been popped, so we should have the
                    // 'finally' bound as the handler. Hence, set the completion again to jump to it.
                    exec->setAbruptCompletion(exec->abruptCompletion());
                    continue;
                }

                // Now we have a plain, old exception. Grab & clear exception it exec state,
                // and put it in a scope w/a name to it
                JSValue* exception = exec->exception();
                exec->clearException();

                JSObject *obj = new JSObject;
                obj->put(exec, *exceptionIdent, exception, DontDelete);
                exec->pushScope(obj);
                exec->pushExceptionHandler(ExecState::PopScope);
            }
            continue;

            handler(ExitCatch): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 394 "codes.def"
                exec->popScope();
                exec->popExceptionHandler();
            }
            continue;

            handler(DeferCompletion): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 401 "codes.def"
                exec->deferCompletion();
            }
            continue;

            handler(ReactivateCompletion_Ibool): {
                pc += 8;
                const unsigned char* localPC = pc;
                bool insideFinally = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
#line 407 "codes.def"
                JSValue* retVal = exec->reactivateCompletion(insideFinally);
                if (retVal)
                    return retVal;
            }
            continue;

            handler(ReactivateCompletion_Rbool): {
                pc += 8;
                const unsigned char* localPC = pc;
                bool insideFinally = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
#line 407 "codes.def"
                JSValue* retVal = exec->reactivateCompletion(insideFinally);
                if (retVal)
                    return retVal;
            }
            continue;

            handler(ReactivateCompletionDebug_Ibool_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(ReactivateCompletionDebug_Ibool_Inode): {
                pc += 16;
                const unsigned char* localPC = pc;
                bool insideFinally = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
                Node* n = reinterpret_cast<const WideArg*>(localPC -12)->nodeVal;
#line 416 "codes.def"
                JSValue* retVal = exec->reactivateCompletion(insideFinally);
                if (retVal) {
                    changeDebugContext(Exit, exec, n);
                    return retVal;
                }
            }
            continue;

            handler(ReactivateCompletionDebug_Rbool_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(ReactivateCompletionDebug_Rbool_Inode): {
                pc += 16;
                const unsigned char* localPC = pc;
                bool insideFinally = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
                Node* n = reinterpret_cast<const WideArg*>(localPC -12)->nodeVal;
#line 416 "codes.def"
                JSValue* retVal = exec->reactivateCompletion(insideFinally);
                if (retVal) {
                    changeDebugContext(Exit, exec, n);
                    return retVal;
                }
            }
            continue;

            handler(Throw_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Throw_Ivalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* exception = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 426 "codes.def"
                exec->setException(exception);
            }
            continue;

            handler(Throw_Rvalue): {
                pc += 8;
                const unsigned char* localPC = pc;
                JSValue* exception = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 426 "codes.def"
                exec->setException(exception);
            }
            continue;

            handler(ContBreakInTryFinally_Iaddr): {
                pc += 8;
                const unsigned char* localPC = pc;
                Addr dest = reinterpret_cast<const NarrowArg*>(localPC -4)->addrVal;
#line 432 "codes.def"
                exec->setAbruptCompletion(Completion(Continue /*or break, doesn't matter*/, nullptr, dest));
            }
            continue;

            handler(ReturnInTryFinally_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(ReturnInTryFinally_Ivalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 438 "codes.def"
                exec->setAbruptCompletion(Completion(ReturnValue, val));
            }
            continue;

            handler(ReturnInTryFinally_Rvalue): {
                pc += 8;
                const unsigned char* localPC = pc;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 438 "codes.def"
                exec->setAbruptCompletion(Completion(ReturnValue, val));
            }
            continue;

            handler(PropagateException): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 444 "codes.def"
                JSValue* e = exec->exception();
                if (parentExec)
                    parentExec->setException(e);
                return e;
            }
            continue;

            handler(Return_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Return_Ivalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* retVal = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 453 "codes.def"
                return retVal;
            }
            continue;

            handler(Return_Rvalue): {
                pc += 8;
                const unsigned char* localPC = pc;
                JSValue* retVal = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 453 "codes.def"
                return retVal;
            }
            continue;

            handler(RaiseError_Inode_Iint32_Icstr_Pad):
                pc += 4;
                // Fallthrough
            handler(RaiseError_Inode_Iint32_Icstr): {
                pc += 24;
                const unsigned char* localPC = pc;
                Node* node = reinterpret_cast<const WideArg*>(localPC -20)->nodeVal;
                int32_t errorType = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
                const char* msg = reinterpret_cast<const WideArg*>(localPC -12)->cstrVal;
#line 459 "codes.def"
                node->throwError(exec, ErrorType(errorType), msg);
            }
            continue;

            handler(RaiseError_Inode_Rint32_Icstr_Pad):
                pc += 4;
                // Fallthrough
            handler(RaiseError_Inode_Rint32_Icstr): {
                pc += 24;
                const unsigned char* localPC = pc;
                Node* node = reinterpret_cast<const WideArg*>(localPC -20)->nodeVal;
                int32_t errorType = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
                const char* msg = reinterpret_cast<const WideArg*>(localPC -12)->cstrVal;
#line 459 "codes.def"
                node->throwError(exec, ErrorType(errorType), msg);
            }
            continue;

            handler(Preamble_Ireg_Ireg_Ireg): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register scopeReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                Register globalReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register thisReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
#line 466 "codes.def"
                localStore[scopeReg ].val.valueVal = exec->variableObject();
                localStore[thisReg  ].val.valueVal = exec->thisValue();
                localStore[globalReg].val.valueVal = globalObject;
            }
            continue;

            handler(EnterDebugContext_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(EnterDebugContext_Inode): {
                pc += 12;
                const unsigned char* localPC = pc;
                Node* n = reinterpret_cast<const WideArg*>(localPC -8)->nodeVal;
#line 474 "codes.def"
                changeDebugContext(Enter, exec, n);
            }
            continue;

            handler(ExitDebugContext_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(ExitDebugContext_Inode): {
                pc += 12;
                const unsigned char* localPC = pc;
                Node* n = reinterpret_cast<const WideArg*>(localPC -8)->nodeVal;
#line 480 "codes.def"
                changeDebugContext(Exit, exec, n);
            }
            continue;

            handler(FunctionLookupAndGet_Ireg_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(FunctionLookupAndGet_Ireg_Ireg_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register thisOutReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 490 "codes.def"
                JSValue* res;
                JSValue* thisOut;
                lookupScopeAndFetch<true /*error out*/, false /* don't skip one*/, true /* want this value*/>
                        (exec, varName, thisOut, res);
                localStore[thisOutReg].val.valueVal = thisOut;
                localStore[fbDestReg].val.valueVal = res;
            }
            continue;

            handler(NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register thisOutReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 501 "codes.def"
                JSValue* res;
                JSValue* thisOut;
                lookupScopeAndFetch<true /*error out*/, true /* skip one*/, true /* want this value*/>
                        (exec, varName, thisOut, res);
                localStore[fbDestReg].val.valueVal = res;
                localStore[thisOutReg].val.valueVal = thisOut;
            }
            continue;

            handler(ScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(ScopeLookupAndGetChecked_Ireg_Ireg_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register valOutReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 512 "codes.def"
                JSValue* scopeOut;
                JSValue* val;

                lookupScopeAndFetch<true /*error out*/, false /* don't skip one*/, false /* scope, not this*/>
                            (exec, varName, scopeOut, val);
                localStore[fbDestReg].val.valueVal = scopeOut;
                localStore[valOutReg].val.valueVal = val;
            }
            continue;

            handler(ScopeLookupAndGet_Ireg_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(ScopeLookupAndGet_Ireg_Ireg_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register valOutReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 524 "codes.def"
                JSValue* scopeOut;
                JSValue* val;

                lookupScopeAndFetch<false /*don't error out*/, false /* no skip*/, false /* scope, not this*/ >
                            (exec, varName, scopeOut, val);
                localStore[fbDestReg].val.valueVal = scopeOut;
                localStore[valOutReg].val.valueVal = val;
            }
            continue;

            handler(NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register valOutReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 536 "codes.def"
                JSValue* scopeOut;
                JSValue* val;

                lookupScopeAndFetch<true /*error out*/, true /* skip one */, false /* scope, not this*/ >
                            (exec, varName, scopeOut, val);
                localStore[fbDestReg].val.valueVal = scopeOut;
                localStore[valOutReg].val.valueVal = val;
            }
            continue;

            handler(NonLocalScopeLookupAndGet_Ireg_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(NonLocalScopeLookupAndGet_Ireg_Ireg_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                Register valOutReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 548 "codes.def"
                JSValue* scopeOut;
                JSValue* val;

                lookupScopeAndFetch<false /*don't error out*/, true /* skip one */, false /* scope, not this*/ >
                            (exec, varName, scopeOut, val);
                localStore[fbDestReg].val.valueVal = scopeOut;
                localStore[valOutReg].val.valueVal = val;
            }
            continue;

            handler(ScopeLookup_Ireg_Iident_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(ScopeLookup_Ireg_Iident_Inode): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
                Node* errorNode = reinterpret_cast<const WideArg*>(localPC -12)->nodeVal;
#line 563 "codes.def"
                const ScopeChain& chain = exec->scopeChain();
                ScopeChainIterator iter = chain.begin();
                ScopeChainIterator end = chain.end();

                // we must always have something in the scope chain
                assert(iter != end);

                JSObject *scopeObj;
                PropertySlot slot;
                do {
                    scopeObj = *iter;

                    if (scopeObj->getPropertySlot(exec, *varName, slot))
                        break;
                    ++iter;
                } while (iter != end);

                if (errorNode && iter == end) {
                    localStore[fbDestReg].val.valueVal = errorNode->throwUndefinedVariableError(exec, *varName);
                    continue;
                }

                localStore[fbDestReg].val.valueVal = scopeObj;
            }
            continue;

            handler(NonLocalScopeLookup_Ireg_Iident_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(NonLocalScopeLookup_Ireg_Iident_Inode): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
                Node* errorNode = reinterpret_cast<const WideArg*>(localPC -12)->nodeVal;
#line 592 "codes.def"
                const ScopeChain& chain = exec->scopeChain();
                ScopeChainIterator iter = chain.begin();
                ScopeChainIterator end = chain.end();

                // we must always have something in the scope chain
                assert(iter != end);

                JSObject *scopeObj = *iter;
                if (!scopeObj->isLocalInjected()) {
                    // Unless eval introduced new variables dynamically,
                    // we know this isn't in the top scope
                    ++iter;
                }

                PropertySlot slot;
                do {
                    scopeObj = *iter;

                    if (scopeObj->getPropertySlot(exec, *varName, slot))
                        break;
                    ++iter;
                } while (iter != end);

                if (errorNode && iter == end) {
                    localStore[fbDestReg].val.valueVal = errorNode->throwUndefinedVariableError(exec, *varName);
                    continue;
                }
                localStore[fbDestReg].val.valueVal = scopeObj;
            }
            continue;

            handler(VarGet_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(VarGet_Ireg_Iident): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 627 "codes.def"
                JSValue* scopeOut;
                JSValue* val;

                lookupScopeAndFetch<true /*error out*/, false /* don't skip one*/, false /*no this*/ >(exec, varName, scopeOut, val);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(NonLocalVarGet_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(NonLocalVarGet_Ireg_Iident): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 638 "codes.def"
                JSValue* scopeOut;
                JSValue* val;

                lookupScopeAndFetch<true /*error out*/, true /* don't skip one*/, false /*no this*/ >(exec, varName, scopeOut, val);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(RegPutValue_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(RegPutValue_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 648 "codes.def"
                localStore[destReg].val.valueVal = val;
            }
            continue;

            handler(RegPutValue_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 648 "codes.def"
                localStore[destReg].val.valueVal = val;
            }
            continue;

            handler(RegPutValue_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* val = convertINumber_Value(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 648 "codes.def"
                localStore[destReg].val.valueVal = val;
            }
            continue;

            handler(RegPutNumber_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(RegPutNumber_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double val = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 656 "codes.def"
                localStore[destReg].val.numberVal = val;
            }
            continue;

            handler(RegPutNumber_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 656 "codes.def"
                localStore[destReg].val.numberVal = val;
            }
            continue;

            handler(RegPutBool_Ireg_Ibool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool val = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
#line 662 "codes.def"
                localStore[destReg].val.boolVal = val;
            }
            continue;

            handler(RegPutBool_Ireg_Rbool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
#line 662 "codes.def"
                localStore[destReg].val.boolVal = val;
            }
            continue;

            handler(RegPutInt32_Ireg_Iint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t val = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 668 "codes.def"
                localStore[destReg].val.int32Val = val;
            }
            continue;

            handler(RegPutInt32_Ireg_Rint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register destReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 668 "codes.def"
                localStore[destReg].val.int32Val = val;
            }
            continue;

            handler(ToObject_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(ToObject_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 674 "codes.def"
                localStore[fbDestReg].val.valueVal = JSValue::toObject(val, exec);
            }
            continue;

            handler(ToObject_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 674 "codes.def"
                localStore[fbDestReg].val.valueVal = JSValue::toObject(val, exec);
            }
            continue;

            handler(SymPutKnownObject_Rvalue_Iident_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(SymPutKnownObject_Rvalue_Iident_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* scope = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 681 "codes.def"
                ASSERT(JSValue::isObject(scope));
                static_cast<JSObject*>(scope)->put(exec, *varName, val);
            }
            continue;

            handler(SymPutKnownObject_Rvalue_Iident_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(SymPutKnownObject_Rvalue_Iident_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* scope = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 681 "codes.def"
                ASSERT(JSValue::isObject(scope));
                static_cast<JSObject*>(scope)->put(exec, *varName, val);
            }
            continue;

            handler(SymPutKnownObject_Rvalue_Iident_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(SymPutKnownObject_Rvalue_Iident_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* scope = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
                JSValue* val = convertINumber_Value(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 681 "codes.def"
                ASSERT(JSValue::isObject(scope));
                static_cast<JSObject*>(scope)->put(exec, *varName, val);
            }
            continue;

            handler(SymGet_Ireg_Ivalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymGet_Ireg_Ivalue_Iident): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* base = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                Identifier* prop = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 691 "codes.def"
                JSObject* baseObj = JSValue::toObject(base, exec);
                // toObject may fail and return an exception object, but get from it is harmless

                // IMPORTANT: The call and store to localStore[fbDestReg].val.valueVal should be two steps, since ::get can tear off frames!
                JSValue* val = baseObj->get(exec, *prop);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(SymGet_Ireg_Rvalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymGet_Ireg_Rvalue_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* prop = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 691 "codes.def"
                JSObject* baseObj = JSValue::toObject(base, exec);
                // toObject may fail and return an exception object, but get from it is harmless

                // IMPORTANT: The call and store to localStore[fbDestReg].val.valueVal should be two steps, since ::get can tear off frames!
                JSValue* val = baseObj->get(exec, *prop);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(SymGetKnownObject_Ireg_Ivalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymGetKnownObject_Ireg_Ivalue_Iident): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* base = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                Identifier* prop = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 703 "codes.def"
                ASSERT(JSValue::isObject(base));

                localStore[fbDestReg].val.valueVal = static_cast<JSObject*>(base)->get(exec, *prop);
            }
            continue;

            handler(SymGetKnownObject_Ireg_Rvalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymGetKnownObject_Ireg_Rvalue_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* prop = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 703 "codes.def"
                ASSERT(JSValue::isObject(base));

                localStore[fbDestReg].val.valueVal = static_cast<JSObject*>(base)->get(exec, *prop);
            }
            continue;

            handler(SymGetAndBind_Ireg_Ireg_Rvalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymGetAndBind_Ireg_Ireg_Rvalue_Iident): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                Register objDest = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
#line 712 "codes.def"
                JSObject* baseObj = JSValue::toObject(base, exec);
                // toObject may fail and return an exception object, but get from it is harmless
                localStore[objDest].val.valueVal = baseObj;

                // IMPORTANT: The call and store to localStore[fbDestReg].val.valueVal should be two steps, since ::get can tear off frames!
                JSValue* val = baseObj->get(exec, *varName);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(BracketGet_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketGet_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 724 "codes.def"
                uint32_t i;

                if (JSValue::getUInt32(v2, i)) {
                   localStore[fbDestReg].val.valueVal = JSValue::getByIndex(v1, exec, i);
                   continue;
                }

                JSObject *o = JSValue::toObject(v1, exec);
                // Make sure to  handle exception immediately, here, since toString might throw, too!
                if (exec->hadException())
                    continue;

                // IMPORTANT: The call and store to localStore[fbDestReg].val.valueVal should be two steps, since ::get can tear off frames!
                JSValue* val = o->get(exec, Identifier(JSValue::toString(v2, exec)));
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(BracketGet_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 724 "codes.def"
                uint32_t i;

                if (JSValue::getUInt32(v2, i)) {
                   localStore[fbDestReg].val.valueVal = JSValue::getByIndex(v1, exec, i);
                   continue;
                }

                JSObject *o = JSValue::toObject(v1, exec);
                // Make sure to  handle exception immediately, here, since toString might throw, too!
                if (exec->hadException())
                    continue;

                // IMPORTANT: The call and store to localStore[fbDestReg].val.valueVal should be two steps, since ::get can tear off frames!
                JSValue* val = o->get(exec, Identifier(JSValue::toString(v2, exec)));
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(BracketGet_Ireg_Rvalue_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 742 "codes.def"
                if (prop >= 0) {
                    localStore[fbDestReg].val.valueVal = JSValue::getByIndex(base, exec, static_cast<uint32_t>(prop));
                } else {
                    // Have to go as a string, as above.
                    JSObject* o = JSValue::toObject(base, exec);
                    JSValue* val = o->get(exec, Identifier(UString::from(prop)));
                    localStore[fbDestReg].val.valueVal = val;
                }
            }
            continue;

            handler(BracketGet_Ireg_Rvalue_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 742 "codes.def"
                if (prop >= 0) {
                    localStore[fbDestReg].val.valueVal = JSValue::getByIndex(base, exec, static_cast<uint32_t>(prop));
                } else {
                    // Have to go as a string, as above.
                    JSObject* o = JSValue::toObject(base, exec);
                    JSValue* val = o->get(exec, Identifier(UString::from(prop)));
                    localStore[fbDestReg].val.valueVal = val;
                }
            }
            continue;

            handler(BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                Register objDest = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
#line 756 "codes.def"
                uint32_t i;
                JSObject *o = JSValue::toObject(v1, exec);
                // Make sure to  handle exception immediately, here, since toString might throw, too!
                if (exec->hadException())
                    continue;

                localStore[objDest].val.valueVal = o;

                JSValue* val;
                if (JSValue::getUInt32(v2, i))
                    val = o->get(exec, i);
                else
                    val = o->get(exec, Identifier(JSValue::toString(v2, exec)));
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(BracketGetAndBind_Ireg_Ireg_Rvalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -16)->regVal;
                Register objDest = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 756 "codes.def"
                uint32_t i;
                JSObject *o = JSValue::toObject(v1, exec);
                // Make sure to  handle exception immediately, here, since toString might throw, too!
                if (exec->hadException())
                    continue;

                localStore[objDest].val.valueVal = o;

                JSValue* val;
                if (JSValue::getUInt32(v2, i))
                    val = o->get(exec, i);
                else
                    val = o->get(exec, Identifier(JSValue::toString(v2, exec)));
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(BracketGetAndBind_Ireg_Ireg_Rvalue_Iint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -16)->regVal;
                Register objDest = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 773 "codes.def"
                JSObject* baseObj = JSValue::toObject(base, exec);
                // toObject may fail and return an exception object, but get from it is harmless
                localStore[objDest].val.valueVal = baseObj;

                if (prop >= 0) {
                    localStore[fbDestReg].val.valueVal = baseObj->get(exec, static_cast<uint32_t>(prop));
                } else {
                    JSValue* val = baseObj->get(exec, Identifier(UString::from(prop)));
                    localStore[fbDestReg].val.valueVal = val;
                }
            }
            continue;

            handler(BracketGetAndBind_Ireg_Ireg_Rvalue_Rint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -16)->regVal;
                Register objDest = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 773 "codes.def"
                JSObject* baseObj = JSValue::toObject(base, exec);
                // toObject may fail and return an exception object, but get from it is harmless
                localStore[objDest].val.valueVal = baseObj;

                if (prop >= 0) {
                    localStore[fbDestReg].val.valueVal = baseObj->get(exec, static_cast<uint32_t>(prop));
                } else {
                    JSValue* val = baseObj->get(exec, Identifier(UString::from(prop)));
                    localStore[fbDestReg].val.valueVal = val;
                }
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketPutKnownObject_Rvalue_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v3 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 789 "codes.def"
                ASSERT(JSValue::isObject(v1));
                uint32_t i;
                JSObject *o = static_cast<JSObject*>(v1);

                if (JSValue::getUInt32(v2, i))
                    o->put(exec, i, v3);
                else
                    o->put(exec, Identifier(JSValue::toString(v2, exec)), v3);
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketPutKnownObject_Rvalue_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v3 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 789 "codes.def"
                ASSERT(JSValue::isObject(v1));
                uint32_t i;
                JSObject *o = static_cast<JSObject*>(v1);

                if (JSValue::getUInt32(v2, i))
                    o->put(exec, i, v3);
                else
                    o->put(exec, Identifier(JSValue::toString(v2, exec)), v3);
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketPutKnownObject_Rvalue_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v3 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 789 "codes.def"
                ASSERT(JSValue::isObject(v1));
                uint32_t i;
                JSObject *o = static_cast<JSObject*>(v1);

                if (JSValue::getUInt32(v2, i))
                    o->put(exec, i, v3);
                else
                    o->put(exec, Identifier(JSValue::toString(v2, exec)), v3);
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -12)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v3 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 789 "codes.def"
                ASSERT(JSValue::isObject(v1));
                uint32_t i;
                JSObject *o = static_cast<JSObject*>(v1);

                if (JSValue::getUInt32(v2, i))
                    o->put(exec, i, v3);
                else
                    o->put(exec, Identifier(JSValue::toString(v2, exec)), v3);
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Iint32_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketPutKnownObject_Rvalue_Iint32_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 800 "codes.def"
                ASSERT(JSValue::isObject(base));
                if (prop >= 0) {
                    static_cast<JSObject*>(base)->put(exec, static_cast<uint32_t>(prop), val);
                } else {
                    static_cast<JSObject*>(base)->put(exec, Identifier(UString::from(prop)), val);
                }
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Iint32_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -12)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 800 "codes.def"
                ASSERT(JSValue::isObject(base));
                if (prop >= 0) {
                    static_cast<JSObject*>(base)->put(exec, static_cast<uint32_t>(prop), val);
                } else {
                    static_cast<JSObject*>(base)->put(exec, Identifier(UString::from(prop)), val);
                }
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Rint32_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketPutKnownObject_Rvalue_Rint32_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 800 "codes.def"
                ASSERT(JSValue::isObject(base));
                if (prop >= 0) {
                    static_cast<JSObject*>(base)->put(exec, static_cast<uint32_t>(prop), val);
                } else {
                    static_cast<JSObject*>(base)->put(exec, Identifier(UString::from(prop)), val);
                }
            }
            continue;

            handler(BracketPutKnownObject_Rvalue_Rint32_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -12)->regVal)->val.valueVal;
                int32_t prop = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 800 "codes.def"
                ASSERT(JSValue::isObject(base));
                if (prop >= 0) {
                    static_cast<JSObject*>(base)->put(exec, static_cast<uint32_t>(prop), val);
                } else {
                    static_cast<JSObject*>(base)->put(exec, Identifier(UString::from(prop)), val);
                }
            }
            continue;

            handler(GlobalObjectGet_Ireg_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(GlobalObjectGet_Ireg_Iident): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* varName = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 811 "codes.def"
                JSObject* scopeObj = globalObject;
                PropertySlot slot;
                if (scopeObj->getPropertySlot(exec, *varName, slot)) {
                    JSValue* val = slot.getValue(exec, scopeObj, *varName);;
                    localStore[fbDestReg].val.valueVal = val;
                } else {
                    throwUndefinedVariableError(exec, *varName);
                }
            }
            continue;

            handler(SymDeleteKnownObject_Ireg_Ivalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymDeleteKnownObject_Ireg_Ivalue_Iident): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* scope = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 824 "codes.def"
                ASSERT(JSValue::isObject(scope));
                localStore[fbDestReg].val.boolVal = static_cast<JSObject*>(scope)->deleteProperty(exec, *name);
            }
            continue;

            handler(SymDeleteKnownObject_Ireg_Rvalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymDeleteKnownObject_Ireg_Rvalue_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* scope = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 824 "codes.def"
                ASSERT(JSValue::isObject(scope));
                localStore[fbDestReg].val.boolVal = static_cast<JSObject*>(scope)->deleteProperty(exec, *name);
            }
            continue;

            handler(SymDelete_Ireg_Ivalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymDelete_Ireg_Ivalue_Iident): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* scope = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -12)->identVal;
#line 831 "codes.def"
                JSObject* o = JSValue::toObject(scope, exec);
                if (pc == localPC) // No exception!
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, *name);
            }
            continue;

            handler(SymDelete_Ireg_Rvalue_Iident_Pad):
                pc += 4;
                // Fallthrough
            handler(SymDelete_Ireg_Rvalue_Iident): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* scope = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
#line 831 "codes.def"
                JSObject* o = JSValue::toObject(scope, exec);
                if (pc == localPC) // No exception!
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, *name);
            }
            continue;

            handler(BracketDelete_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketDelete_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 839 "codes.def"
                uint32_t i;
                JSObject *o = JSValue::toObject(v1, exec);
                if (pc != localPC)
                    continue;

                if (JSValue::getUInt32(v2, i))
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, i);
                else
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, Identifier(JSValue::toString(v2, exec)));
            }
            continue;

            handler(BracketDelete_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 839 "codes.def"
                uint32_t i;
                JSObject *o = JSValue::toObject(v1, exec);
                if (pc != localPC)
                    continue;

                if (JSValue::getUInt32(v2, i))
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, i);
                else
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, Identifier(JSValue::toString(v2, exec)));
            }
            continue;

            handler(BracketDelete_Ireg_Ivalue_Iint32_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketDelete_Ireg_Ivalue_Iint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t i = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 851 "codes.def"
                JSObject *o = JSValue::toObject(v1, exec);
                if (pc != localPC)
                    continue;

                if (i >= 0)
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, static_cast<uint32_t>(i));
                else
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, Identifier(UString::from(i)));
            }
            continue;

            handler(BracketDelete_Ireg_Ivalue_Rint32_Pad):
                pc += 4;
                // Fallthrough
            handler(BracketDelete_Ireg_Ivalue_Rint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t i = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 851 "codes.def"
                JSObject *o = JSValue::toObject(v1, exec);
                if (pc != localPC)
                    continue;

                if (i >= 0)
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, static_cast<uint32_t>(i));
                else
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, Identifier(UString::from(i)));
            }
            continue;

            handler(BracketDelete_Ireg_Rvalue_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t i = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 851 "codes.def"
                JSObject *o = JSValue::toObject(v1, exec);
                if (pc != localPC)
                    continue;

                if (i >= 0)
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, static_cast<uint32_t>(i));
                else
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, Identifier(UString::from(i)));
            }
            continue;

            handler(BracketDelete_Ireg_Rvalue_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t i = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 851 "codes.def"
                JSObject *o = JSValue::toObject(v1, exec);
                if (pc != localPC)
                    continue;

                if (i >= 0)
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, static_cast<uint32_t>(i));
                else
                    localStore[fbDestReg].val.boolVal = o->deleteProperty(exec, Identifier(UString::from(i)));
            }
            continue;

            handler(OwnedString_Ireg_Istring_Pad):
                pc += 4;
                // Fallthrough
            handler(OwnedString_Ireg_Istring): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                UString* in = reinterpret_cast<const WideArg*>(localPC -12)->stringVal;
#line 867 "codes.def"
                localStore[fbDestReg].val.valueVal = jsOwnedString(*in);
            }
            continue;

            handler(NewEmptyArray_Ireg): {
                pc += 8;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
#line 873 "codes.def"
                localStore[fbDestReg].val.valueVal = exec->lexicalInterpreter()->builtinArray()->construct(exec, List::empty());
            }
            continue;

            handler(NewObject_Ireg): {
                pc += 8;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
#line 879 "codes.def"
                localStore[fbDestReg].val.valueVal = new JSObject(exec->lexicalInterpreter()->builtinObjectPrototype());
            }
            continue;

            handler(NewRegExp_Ireg_Istring_Istring_Pad):
                pc += 4;
                // Fallthrough
            handler(NewRegExp_Ireg_Istring_Istring): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                UString* pattern = reinterpret_cast<const WideArg*>(localPC -20)->stringVal;
                UString* flags = reinterpret_cast<const WideArg*>(localPC -12)->stringVal;
#line 885 "codes.def"
                // ### TODO: this is -very- wasteful
                List list;
                list.append(jsOwnedString(*pattern));
                list.append(jsOwnedString(*flags));

                JSObject *reg = exec->lexicalInterpreter()->builtinRegExp();
                localStore[fbDestReg].val.valueVal = reg->construct(exec,list);
            }
            continue;

            handler(DefineGetter_Rvalue_Iident_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(DefineGetter_Rvalue_Iident_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
                JSValue* getter = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 897 "codes.def"
                ASSERT(JSValue::isObject(base));
                ASSERT(JSValue::isObject(getter));
                static_cast<JSObject*>(base)->defineGetter(exec, *name, static_cast<JSObject*>(getter));
            }
            continue;

            handler(DefineGetter_Rvalue_Iident_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(DefineGetter_Rvalue_Iident_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
                JSValue* getter = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 897 "codes.def"
                ASSERT(JSValue::isObject(base));
                ASSERT(JSValue::isObject(getter));
                static_cast<JSObject*>(base)->defineGetter(exec, *name, static_cast<JSObject*>(getter));
            }
            continue;

            handler(DefineSetter_Rvalue_Iident_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(DefineSetter_Rvalue_Iident_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
                JSValue* setter = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 905 "codes.def"
                ASSERT(JSValue::isObject(base));
                ASSERT(JSValue::isObject(setter));
                static_cast<JSObject*>(base)->defineSetter(exec, *name, static_cast<JSObject*>(setter));
            }
            continue;

            handler(DefineSetter_Rvalue_Iident_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(DefineSetter_Rvalue_Iident_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* base = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                Identifier* name = reinterpret_cast<const WideArg*>(localPC -16)->identVal;
                JSValue* setter = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 905 "codes.def"
                ASSERT(JSValue::isObject(base));
                ASSERT(JSValue::isObject(setter));
                static_cast<JSObject*>(base)->defineSetter(exec, *name, static_cast<JSObject*>(setter));
            }
            continue;

            handler(Add1_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Add1_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double old = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 917 "codes.def"
                localStore[fbDestReg].val.numberVal = old + 1.0;
            }
            continue;

            handler(Add1_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double old = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 917 "codes.def"
                localStore[fbDestReg].val.numberVal = old + 1.0;
            }
            continue;

            handler(Add1_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double old = convertIValue_Number(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 917 "codes.def"
                localStore[fbDestReg].val.numberVal = old + 1.0;
            }
            continue;

            handler(Sub1_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Sub1_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double old = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 925 "codes.def"
                localStore[fbDestReg].val.numberVal = old - 1.0;
            }
            continue;

            handler(Sub1_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double old = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 925 "codes.def"
                localStore[fbDestReg].val.numberVal = old - 1.0;
            }
            continue;

            handler(Neg_Ireg_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Neg_Ireg_Inumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double old = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 931 "codes.def"
                localStore[fbDestReg].val.numberVal = -old;
            }
            continue;

            handler(Neg_Ireg_Rnumber): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double old = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 931 "codes.def"
                localStore[fbDestReg].val.numberVal = -old;
            }
            continue;

            handler(Neg_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double old = convertIValue_Number(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 931 "codes.def"
                localStore[fbDestReg].val.numberVal = -old;
            }
            continue;

            handler(Mult_Ireg_Inumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Mult_Ireg_Inumber_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -20)->numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Mult_Ireg_Inumber_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Mult_Ireg_Inumber_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Mult_Ireg_Rnumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Mult_Ireg_Rnumber_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Mult_Ireg_Rnumber_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Mult_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = convertIValue_Number(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
                double v2 = convertIValue_Number(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Mult_Ireg_Rvalue_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = convertIValue_Number(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Mult_Ireg_Rnumber_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double v2 = convertIValue_Number(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 939 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 * v2;
            }
            continue;

            handler(Div_Ireg_Inumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Div_Ireg_Inumber_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -20)->numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 949 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 / v2;
            }
            continue;

            handler(Div_Ireg_Inumber_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Div_Ireg_Inumber_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 949 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 / v2;
            }
            continue;

            handler(Div_Ireg_Rnumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Div_Ireg_Rnumber_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 949 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 / v2;
            }
            continue;

            handler(Div_Ireg_Rnumber_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 949 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 / v2;
            }
            continue;

            handler(Mod_Ireg_Inumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Mod_Ireg_Inumber_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -20)->numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 955 "codes.def"
                localStore[fbDestReg].val.numberVal = fmod(v1, v2);
            }
            continue;

            handler(Mod_Ireg_Inumber_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Mod_Ireg_Inumber_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 955 "codes.def"
                localStore[fbDestReg].val.numberVal = fmod(v1, v2);
            }
            continue;

            handler(Mod_Ireg_Rnumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Mod_Ireg_Rnumber_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 955 "codes.def"
                localStore[fbDestReg].val.numberVal = fmod(v1, v2);
            }
            continue;

            handler(Mod_Ireg_Rnumber_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 955 "codes.def"
                localStore[fbDestReg].val.numberVal = fmod(v1, v2);
            }
            continue;

            handler(Exp_Ireg_Inumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Exp_Ireg_Inumber_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -20)->numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 961 "codes.def"
                localStore[fbDestReg].val.numberVal = exponentiation(v1, v2);
            }
            continue;

            handler(Exp_Ireg_Inumber_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Exp_Ireg_Inumber_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 961 "codes.def"
                localStore[fbDestReg].val.numberVal = exponentiation(v1, v2);
            }
            continue;

            handler(Exp_Ireg_Rnumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Exp_Ireg_Rnumber_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 961 "codes.def"
                localStore[fbDestReg].val.numberVal = exponentiation(v1, v2);
            }
            continue;

            handler(Exp_Ireg_Rnumber_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 961 "codes.def"
                localStore[fbDestReg].val.numberVal = exponentiation(v1, v2);
            }
            continue;

            handler(Sub_Ireg_Inumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Sub_Ireg_Inumber_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -20)->numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 967 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 - v2;
            }
            continue;

            handler(Sub_Ireg_Inumber_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Sub_Ireg_Inumber_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 967 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 - v2;
            }
            continue;

            handler(Sub_Ireg_Rnumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Sub_Ireg_Rnumber_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 967 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 - v2;
            }
            continue;

            handler(Sub_Ireg_Rnumber_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 967 "codes.def"
                localStore[fbDestReg].val.numberVal = v1 - v2;
            }
            continue;

            handler(Add_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 973 "codes.def"
                // exception for the Date exception in defaultValue()
                JSValue *p1 = JSValue::toPrimitive(v1, exec, UnspecifiedType);
                if (pc != localPC) continue;
                JSValue *p2 = JSValue::toPrimitive(v2, exec, UnspecifiedType);
                if (pc != localPC) continue;

                if (JSValue::isString(p1) || JSValue::isString(p2)) {
                    UString value = JSValue::toString(p1, exec) + JSValue::toString(p2, exec);
                    if (value.isNull()) {
                        JSObject *error = Error::create(exec, GeneralError, "Out of memory");
                        exec->setException(error);
                    } else {
                        localStore[fbDestReg].val.valueVal = jsString(value);
                    }
                } else {
                    localStore[fbDestReg].val.valueVal = jsNumber(JSValue::toNumber(p1, exec) + JSValue::toNumber(p2, exec));
                }
            }
            continue;

            handler(Add_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 973 "codes.def"
                // exception for the Date exception in defaultValue()
                JSValue *p1 = JSValue::toPrimitive(v1, exec, UnspecifiedType);
                if (pc != localPC) continue;
                JSValue *p2 = JSValue::toPrimitive(v2, exec, UnspecifiedType);
                if (pc != localPC) continue;

                if (JSValue::isString(p1) || JSValue::isString(p2)) {
                    UString value = JSValue::toString(p1, exec) + JSValue::toString(p2, exec);
                    if (value.isNull()) {
                        JSObject *error = Error::create(exec, GeneralError, "Out of memory");
                        exec->setException(error);
                    } else {
                        localStore[fbDestReg].val.valueVal = jsString(value);
                    }
                } else {
                    localStore[fbDestReg].val.valueVal = jsNumber(JSValue::toNumber(p1, exec) + JSValue::toNumber(p2, exec));
                }
            }
            continue;

            handler(Add_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 973 "codes.def"
                // exception for the Date exception in defaultValue()
                JSValue *p1 = JSValue::toPrimitive(v1, exec, UnspecifiedType);
                if (pc != localPC) continue;
                JSValue *p2 = JSValue::toPrimitive(v2, exec, UnspecifiedType);
                if (pc != localPC) continue;

                if (JSValue::isString(p1) || JSValue::isString(p2)) {
                    UString value = JSValue::toString(p1, exec) + JSValue::toString(p2, exec);
                    if (value.isNull()) {
                        JSObject *error = Error::create(exec, GeneralError, "Out of memory");
                        exec->setException(error);
                    } else {
                        localStore[fbDestReg].val.valueVal = jsString(value);
                    }
                } else {
                    localStore[fbDestReg].val.valueVal = jsNumber(JSValue::toNumber(p1, exec) + JSValue::toNumber(p2, exec));
                }
            }
            continue;

            handler(Add_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 973 "codes.def"
                // exception for the Date exception in defaultValue()
                JSValue *p1 = JSValue::toPrimitive(v1, exec, UnspecifiedType);
                if (pc != localPC) continue;
                JSValue *p2 = JSValue::toPrimitive(v2, exec, UnspecifiedType);
                if (pc != localPC) continue;

                if (JSValue::isString(p1) || JSValue::isString(p2)) {
                    UString value = JSValue::toString(p1, exec) + JSValue::toString(p2, exec);
                    if (value.isNull()) {
                        JSObject *error = Error::create(exec, GeneralError, "Out of memory");
                        exec->setException(error);
                    } else {
                        localStore[fbDestReg].val.valueVal = jsString(value);
                    }
                } else {
                    localStore[fbDestReg].val.valueVal = jsNumber(JSValue::toNumber(p1, exec) + JSValue::toNumber(p2, exec));
                }
            }
            continue;

            handler(Add_Ireg_Inumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Add_Ireg_Inumber_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                double n1 = reinterpret_cast<const WideArg*>(localPC -20)->numberVal;
                double n2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 993 "codes.def"
                localStore[fbDestReg].val.numberVal = n1 + n2;
            }
            continue;

            handler(Add_Ireg_Inumber_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Add_Ireg_Inumber_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double n1 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
                double n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 993 "codes.def"
                localStore[fbDestReg].val.numberVal = n1 + n2;
            }
            continue;

            handler(Add_Ireg_Rnumber_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Add_Ireg_Rnumber_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                double n1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
                double n2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 993 "codes.def"
                localStore[fbDestReg].val.numberVal = n1 + n2;
            }
            continue;

            handler(Add_Ireg_Rnumber_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                double n1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.numberVal;
                double n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 993 "codes.def"
                localStore[fbDestReg].val.numberVal = n1 + n2;
            }
            continue;

            handler(LShift_Ireg_Iint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t v2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1000 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 << ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(LShift_Ireg_Iint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1000 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 << ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(LShift_Ireg_Rint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t v2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1000 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 << ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(LShift_Ireg_Rint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1000 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 << ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(RShift_Ireg_Iint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t v2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1006 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(RShift_Ireg_Iint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1006 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(RShift_Ireg_Rint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t v2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1006 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(RShift_Ireg_Rint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1006 "codes.def"
                localStore[fbDestReg].val.int32Val = (v1 >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(URShift_Ireg_Iint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t v2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1013 "codes.def"
                localStore[fbDestReg].val.numberVal = (uint32_t(v1) >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(URShift_Ireg_Iint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1013 "codes.def"
                localStore[fbDestReg].val.numberVal = (uint32_t(v1) >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(URShift_Ireg_Rint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t v2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1013 "codes.def"
                localStore[fbDestReg].val.numberVal = (uint32_t(v1) >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(URShift_Ireg_Rint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1013 "codes.def"
                localStore[fbDestReg].val.numberVal = (uint32_t(v1) >> ((uint32_t)v2 & 0x1f));
            }
            continue;

            handler(Less_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1021 "codes.def"
                // operator <
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => false
                //  1: v1 <  v2       => true;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 1);
            }
            continue;

            handler(Less_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1021 "codes.def"
                // operator <
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => false
                //  1: v1 <  v2       => true;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 1);
            }
            continue;

            handler(Less_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1021 "codes.def"
                // operator <
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => false
                //  1: v1 <  v2       => true;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 1);
            }
            continue;

            handler(Less_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1021 "codes.def"
                // operator <
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => false
                //  1: v1 <  v2       => true;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 1);
            }
            continue;

            handler(Less_Ireg_Ivalue_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Ivalue_Inumber): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                double n2 = reinterpret_cast<const WideArg*>(localPC -12)->numberVal;
#line 1029 "codes.def"
                // As above..
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Ivalue_Rnumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Ivalue_Rnumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                double n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 1029 "codes.def"
                // As above..
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Rvalue_Inumber_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Rvalue_Inumber): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                double n2 = reinterpret_cast<const WideArg*>(localPC -16)->numberVal;
#line 1029 "codes.def"
                // As above..
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Rvalue_Rnumber): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                double n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.numberVal;
#line 1029 "codes.def"
                // As above..
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Ivalue_Iint32_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Ivalue_Iint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t n2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1034 "codes.def"
                // As above... 
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Ivalue_Rint32_Pad):
                pc += 4;
                // Fallthrough
            handler(Less_Ireg_Ivalue_Rint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1034 "codes.def"
                // As above... 
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Rvalue_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t n2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1034 "codes.def"
                // As above... 
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(Less_Ireg_Rvalue_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1034 "codes.def"
                // As above... 
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, n2) == 1);
            }
            continue;

            handler(GreaterEq_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(GreaterEq_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1041 "codes.def"
                // operator >=
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => true
                //  1: v1 <  v2       => false;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 0);
            }
            continue;

            handler(GreaterEq_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(GreaterEq_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1041 "codes.def"
                // operator >=
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => true
                //  1: v1 <  v2       => false;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 0);
            }
            continue;

            handler(GreaterEq_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(GreaterEq_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1041 "codes.def"
                // operator >=
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => true
                //  1: v1 <  v2       => false;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 0);
            }
            continue;

            handler(GreaterEq_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1041 "codes.def"
                // operator >=
                // -1: NaN, undefined => false
                //  0: v1 >= v2       => true
                //  1: v1 <  v2       => false;
                localStore[fbDestReg].val.boolVal = (relation(exec, v1, v2) == 0);
            }
            continue;

            handler(Greater_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Greater_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1051 "codes.def"
                // operator >
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => false
                //  1: v2 <  v1       => true
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 1);
            }
            continue;

            handler(Greater_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Greater_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1051 "codes.def"
                // operator >
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => false
                //  1: v2 <  v1       => true
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 1);
            }
            continue;

            handler(Greater_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Greater_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1051 "codes.def"
                // operator >
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => false
                //  1: v2 <  v1       => true
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 1);
            }
            continue;

            handler(Greater_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1051 "codes.def"
                // operator >
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => false
                //  1: v2 <  v1       => true
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 1);
            }
            continue;

            handler(LessEq_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(LessEq_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1061 "codes.def"
                // operator <=
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => true
                //  1: v2 <  v1       => false
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 0);
            }
            continue;

            handler(LessEq_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(LessEq_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1061 "codes.def"
                // operator <=
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => true
                //  1: v2 <  v1       => false
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 0);
            }
            continue;

            handler(LessEq_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(LessEq_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1061 "codes.def"
                // operator <=
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => true
                //  1: v2 <  v1       => false
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 0);
            }
            continue;

            handler(LessEq_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1061 "codes.def"
                // operator <=
                // -1: NaN, undefined => false
                //  0: v2 >= v1       => true
                //  1: v2 <  v1       => false
                localStore[fbDestReg].val.boolVal = (relation(exec, v2, v1, false) == 0);
            }
            continue;

            handler(EqEq_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(EqEq_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1071 "codes.def"
                // operator ==
                localStore[fbDestReg].val.boolVal = equal(exec, v1, v2);
            }
            continue;

            handler(EqEq_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(EqEq_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1071 "codes.def"
                // operator ==
                localStore[fbDestReg].val.boolVal = equal(exec, v1, v2);
            }
            continue;

            handler(EqEq_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(EqEq_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1071 "codes.def"
                // operator ==
                localStore[fbDestReg].val.boolVal = equal(exec, v1, v2);
            }
            continue;

            handler(EqEq_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1071 "codes.def"
                // operator ==
                localStore[fbDestReg].val.boolVal = equal(exec, v1, v2);
            }
            continue;

            handler(EqEq_Ireg_Ivalue_Iint32_Pad):
                pc += 4;
                // Fallthrough
            handler(EqEq_Ireg_Ivalue_Iint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t n2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1076 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 == n2);
                else
                    localStore[fbDestReg].val.boolVal = equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(EqEq_Ireg_Ivalue_Rint32_Pad):
                pc += 4;
                // Fallthrough
            handler(EqEq_Ireg_Ivalue_Rint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1076 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 == n2);
                else
                    localStore[fbDestReg].val.boolVal = equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(EqEq_Ireg_Rvalue_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t n2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1076 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 == n2);
                else
                    localStore[fbDestReg].val.boolVal = equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(EqEq_Ireg_Rvalue_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1076 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 == n2);
                else
                    localStore[fbDestReg].val.boolVal = equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(NotEq_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(NotEq_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1086 "codes.def"
                // operator !=
                localStore[fbDestReg].val.boolVal = !equal(exec,v1, v2);
            }
            continue;

            handler(NotEq_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(NotEq_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1086 "codes.def"
                // operator !=
                localStore[fbDestReg].val.boolVal = !equal(exec,v1, v2);
            }
            continue;

            handler(NotEq_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(NotEq_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1086 "codes.def"
                // operator !=
                localStore[fbDestReg].val.boolVal = !equal(exec,v1, v2);
            }
            continue;

            handler(NotEq_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1086 "codes.def"
                // operator !=
                localStore[fbDestReg].val.boolVal = !equal(exec,v1, v2);
            }
            continue;

            handler(NotEq_Ireg_Ivalue_Iint32_Pad):
                pc += 4;
                // Fallthrough
            handler(NotEq_Ireg_Ivalue_Iint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t n2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1091 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 != n2);
                else
                    localStore[fbDestReg].val.boolVal = !equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(NotEq_Ireg_Ivalue_Rint32_Pad):
                pc += 4;
                // Fallthrough
            handler(NotEq_Ireg_Ivalue_Rint32): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                int32_t n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1091 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 != n2);
                else
                    localStore[fbDestReg].val.boolVal = !equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(NotEq_Ireg_Rvalue_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t n2 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1091 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 != n2);
                else
                    localStore[fbDestReg].val.boolVal = !equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(NotEq_Ireg_Rvalue_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                int32_t n2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1091 "codes.def"
                double n1;
                if (JSValue::getNumber(v1, n1))
                    localStore[fbDestReg].val.boolVal = (n1 != n2);
                else
                    localStore[fbDestReg].val.boolVal = !equal(exec, v1, jsNumber(n2));
            }
            continue;

            handler(StrEq_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(StrEq_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1102 "codes.def"
                // operator ===
                localStore[fbDestReg].val.boolVal = strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrEq_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(StrEq_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1102 "codes.def"
                // operator ===
                localStore[fbDestReg].val.boolVal = strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrEq_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(StrEq_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1102 "codes.def"
                // operator ===
                localStore[fbDestReg].val.boolVal = strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrEq_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1102 "codes.def"
                // operator ===
                localStore[fbDestReg].val.boolVal = strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrNEq_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(StrNEq_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1109 "codes.def"
                // operator !==
                localStore[fbDestReg].val.boolVal = !strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrNEq_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(StrNEq_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1109 "codes.def"
                // operator !==
                localStore[fbDestReg].val.boolVal = !strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrNEq_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(StrNEq_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1109 "codes.def"
                // operator !==
                localStore[fbDestReg].val.boolVal = !strictEqual(exec,v1, v2);
            }
            continue;

            handler(StrNEq_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1109 "codes.def"
                // operator !==
                localStore[fbDestReg].val.boolVal = !strictEqual(exec,v1, v2);
            }
            continue;

            handler(BitNot_Ireg_Iint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t old = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1120 "codes.def"
                localStore[fbDestReg].val.int32Val = ~old;
            }
            continue;

            handler(BitNot_Ireg_Rint32): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                int32_t old = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1120 "codes.def"
                localStore[fbDestReg].val.int32Val = ~old;
            }
            continue;

            handler(BitAnd_Ireg_Iint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t a1 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitAnd_Ireg_Iint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitAnd_Ireg_Rint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitAnd_Ireg_Rint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitAnd_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = convertIValue_Int32(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
                int32_t a1 = convertIValue_Int32(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitAnd_Ireg_Rvalue_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = convertIValue_Int32(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitAnd_Ireg_Rint32_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = convertIValue_Int32(exec, reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal);
                if (pc != localPC) // {// Exception or reload
                    continue;
#line 1126 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 & a1;
            }
            continue;

            handler(BitXOr_Ireg_Iint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t a1 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1136 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 ^ a1;
            }
            continue;

            handler(BitXOr_Ireg_Iint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1136 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 ^ a1;
            }
            continue;

            handler(BitXOr_Ireg_Rint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1136 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 ^ a1;
            }
            continue;

            handler(BitXOr_Ireg_Rint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1136 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 ^ a1;
            }
            continue;

            handler(BitOr_Ireg_Iint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t a1 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1142 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 | a1;
            }
            continue;

            handler(BitOr_Ireg_Iint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const NarrowArg*>(localPC -8)->int32Val;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1142 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 | a1;
            }
            continue;

            handler(BitOr_Ireg_Rint32_Iint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = reinterpret_cast<const NarrowArg*>(localPC -4)->int32Val;
#line 1142 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 | a1;
            }
            continue;

            handler(BitOr_Ireg_Rint32_Rint32): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                int32_t a0 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.int32Val;
                int32_t a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.int32Val;
#line 1142 "codes.def"
                localStore[fbDestReg].val.int32Val = a0 | a1;
            }
            continue;

            handler(LogicalNot_Ireg_Ibool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool old = reinterpret_cast<const NarrowArg*>(localPC -4)->boolVal;
#line 1152 "codes.def"
                localStore[fbDestReg].val.boolVal = !old;
            }
            continue;

            handler(LogicalNot_Ireg_Rbool): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                bool old = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.boolVal;
#line 1152 "codes.def"
                localStore[fbDestReg].val.boolVal = !old;
            }
            continue;

            handler(TypeOf_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(TypeOf_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1161 "codes.def"
                localStore[fbDestReg].val.valueVal = typeStringForValue(v);
            }
            continue;

            handler(TypeOf_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1161 "codes.def"
                localStore[fbDestReg].val.valueVal = typeStringForValue(v);
            }
            continue;

            handler(In_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(In_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1167 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with IN expression.");
                    continue;
                }
                JSObject* o2 = static_cast<JSObject*>(v2);
                localStore[fbDestReg].val.boolVal = o2->hasProperty(exec, Identifier(JSValue::toString(v1, exec)));
            }
            continue;

            handler(In_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(In_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1167 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with IN expression.");
                    continue;
                }
                JSObject* o2 = static_cast<JSObject*>(v2);
                localStore[fbDestReg].val.boolVal = o2->hasProperty(exec, Identifier(JSValue::toString(v1, exec)));
            }
            continue;

            handler(In_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(In_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1167 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with IN expression.");
                    continue;
                }
                JSObject* o2 = static_cast<JSObject*>(v2);
                localStore[fbDestReg].val.boolVal = o2->hasProperty(exec, Identifier(JSValue::toString(v1, exec)));
            }
            continue;

            handler(In_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1167 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with IN expression.");
                    continue;
                }
                JSObject* o2 = static_cast<JSObject*>(v2);
                localStore[fbDestReg].val.boolVal = o2->hasProperty(exec, Identifier(JSValue::toString(v1, exec)));
            }
            continue;

            handler(InstanceOf_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(InstanceOf_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1178 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with instanceof operator.");
                    continue;
                }

                JSObject* o2 = static_cast<JSObject*>(v2);
                if (!o2->implementsHasInstance())
                    // According to the spec, only some types of objects "implement" the [HasInstance] property.
                    // But we are supposed to throw an exception where the object does not "have" the [HasInstance]
                    // property. It seems that all object have the property, but not all implement it, so in this
                    // case we return false (consistent with mozilla)
                    localStore[fbDestReg].val.boolVal = false;
                else
                    localStore[fbDestReg].val.boolVal = o2->hasInstance(exec, v1);
            }
            continue;

            handler(InstanceOf_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(InstanceOf_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1178 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with instanceof operator.");
                    continue;
                }

                JSObject* o2 = static_cast<JSObject*>(v2);
                if (!o2->implementsHasInstance())
                    // According to the spec, only some types of objects "implement" the [HasInstance] property.
                    // But we are supposed to throw an exception where the object does not "have" the [HasInstance]
                    // property. It seems that all object have the property, but not all implement it, so in this
                    // case we return false (consistent with mozilla)
                    localStore[fbDestReg].val.boolVal = false;
                else
                    localStore[fbDestReg].val.boolVal = o2->hasInstance(exec, v1);
            }
            continue;

            handler(InstanceOf_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(InstanceOf_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1178 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with instanceof operator.");
                    continue;
                }

                JSObject* o2 = static_cast<JSObject*>(v2);
                if (!o2->implementsHasInstance())
                    // According to the spec, only some types of objects "implement" the [HasInstance] property.
                    // But we are supposed to throw an exception where the object does not "have" the [HasInstance]
                    // property. It seems that all object have the property, but not all implement it, so in this
                    // case we return false (consistent with mozilla)
                    localStore[fbDestReg].val.boolVal = false;
                else
                    localStore[fbDestReg].val.boolVal = o2->hasInstance(exec, v1);
            }
            continue;

            handler(InstanceOf_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* v2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1178 "codes.def"
                if (!JSValue::isObject(v2)) {
                    throwError(exec,  TypeError, "Value is not an object. Cannot be used with instanceof operator.");
                    continue;
                }

                JSObject* o2 = static_cast<JSObject*>(v2);
                if (!o2->implementsHasInstance())
                    // According to the spec, only some types of objects "implement" the [HasInstance] property.
                    // But we are supposed to throw an exception where the object does not "have" the [HasInstance]
                    // property. It seems that all object have the property, but not all implement it, so in this
                    // case we return false (consistent with mozilla)
                    localStore[fbDestReg].val.boolVal = false;
                else
                    localStore[fbDestReg].val.boolVal = o2->hasInstance(exec, v1);
            }
            continue;

            handler(ClearArgs): {
                pc += 4;
                const unsigned char* localPC = pc;
#line 1201 "codes.def"
                workList.clear();
            }
            continue;

            handler(AddArg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(AddArg_Ivalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* val = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 1207 "codes.def"
                workList.append(val);
            }
            continue;

            handler(AddArg_Rvalue): {
                pc += 8;
                const unsigned char* localPC = pc;
                JSValue* val = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1207 "codes.def"
                workList.append(val);
            }
            continue;

            handler(Add2Arg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add2Arg_Ivalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* a2 = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 1213 "codes.def"
                workList.append(a1);
                workList.append(a2);
            }
            continue;

            handler(Add2Arg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add2Arg_Ivalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
                JSValue* a2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1213 "codes.def"
                workList.append(a1);
                workList.append(a2);
            }
            continue;

            handler(Add2Arg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add2Arg_Rvalue_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* a2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1213 "codes.def"
                workList.append(a1);
                workList.append(a2);
            }
            continue;

            handler(Add2Arg_Rvalue_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* a2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1213 "codes.def"
                workList.append(a1);
                workList.append(a2);
            }
            continue;

            handler(Add3Arg_Ivalue_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Ivalue_Ivalue_Ivalue): {
                pc += 28;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const WideArg*>(localPC -24)->valueVal;
                JSValue* a2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* a3 = reinterpret_cast<const WideArg*>(localPC -8)->valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Ivalue_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Ivalue_Ivalue_Rvalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* a2 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
                JSValue* a3 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Ivalue_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Ivalue_Rvalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* a2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* a3 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Ivalue_Rvalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Ivalue_Rvalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* a2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* a3 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Rvalue_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Rvalue_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* a2 = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* a3 = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Rvalue_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Rvalue_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* a2 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* a3 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Rvalue_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(Add3Arg_Rvalue_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* a2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* a3 = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(Add3Arg_Rvalue_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                JSValue* a1 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -12)->regVal)->val.valueVal;
                JSValue* a2 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* a3 = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1220 "codes.def"
                workList.append(a1);
                workList.append(a2);
                workList.append(a3);
            }
            continue;

            handler(FunctionCall_Ireg_Ivalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(FunctionCall_Ireg_Ivalue_Ivalue): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v = reinterpret_cast<const WideArg*>(localPC -20)->valueVal;
                JSValue* thisVal = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1228 "codes.def"
                ASSERT(JSValue::isObject(thisVal));
                ASSERT(!static_cast<JSObject*>(thisVal)->isActivation());

                if (!JSValue::implementsCall(v)) {
                    throwError(exec, TypeError, "Attempt to use a non-function object or a value as a function.");
                    //return throwError(exec, TypeError, notAnObjectMessage(), v, expr.get());
                    continue;
                }

                JSObject *func = static_cast<JSObject*>(v);
                JSValue* val;
                val = func->call(exec, static_cast<JSObject*>(thisVal), workList);
                localStore[fbDestReg].val.valueVal  = val;
            }
            continue;

            handler(FunctionCall_Ireg_Ivalue_Rvalue_Pad):
                pc += 4;
                // Fallthrough
            handler(FunctionCall_Ireg_Ivalue_Rvalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
                JSValue* thisVal = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1228 "codes.def"
                ASSERT(JSValue::isObject(thisVal));
                ASSERT(!static_cast<JSObject*>(thisVal)->isActivation());

                if (!JSValue::implementsCall(v)) {
                    throwError(exec, TypeError, "Attempt to use a non-function object or a value as a function.");
                    //return throwError(exec, TypeError, notAnObjectMessage(), v, expr.get());
                    continue;
                }

                JSObject *func = static_cast<JSObject*>(v);
                JSValue* val;
                val = func->call(exec, static_cast<JSObject*>(thisVal), workList);
                localStore[fbDestReg].val.valueVal  = val;
            }
            continue;

            handler(FunctionCall_Ireg_Rvalue_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(FunctionCall_Ireg_Rvalue_Ivalue): {
                pc += 20;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
                JSValue* thisVal = reinterpret_cast<const WideArg*>(localPC -16)->valueVal;
#line 1228 "codes.def"
                ASSERT(JSValue::isObject(thisVal));
                ASSERT(!static_cast<JSObject*>(thisVal)->isActivation());

                if (!JSValue::implementsCall(v)) {
                    throwError(exec, TypeError, "Attempt to use a non-function object or a value as a function.");
                    //return throwError(exec, TypeError, notAnObjectMessage(), v, expr.get());
                    continue;
                }

                JSObject *func = static_cast<JSObject*>(v);
                JSValue* val;
                val = func->call(exec, static_cast<JSObject*>(thisVal), workList);
                localStore[fbDestReg].val.valueVal  = val;
            }
            continue;

            handler(FunctionCall_Ireg_Rvalue_Rvalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -12)->regVal;
                JSValue* v = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -8)->regVal)->val.valueVal;
                JSValue* thisVal = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1228 "codes.def"
                ASSERT(JSValue::isObject(thisVal));
                ASSERT(!static_cast<JSObject*>(thisVal)->isActivation());

                if (!JSValue::implementsCall(v)) {
                    throwError(exec, TypeError, "Attempt to use a non-function object or a value as a function.");
                    //return throwError(exec, TypeError, notAnObjectMessage(), v, expr.get());
                    continue;
                }

                JSObject *func = static_cast<JSObject*>(v);
                JSValue* val;
                val = func->call(exec, static_cast<JSObject*>(thisVal), workList);
                localStore[fbDestReg].val.valueVal  = val;
            }
            continue;

            handler(CtorCall_Ireg_Ivalue_Pad):
                pc += 4;
                // Fallthrough
            handler(CtorCall_Ireg_Ivalue): {
                pc += 16;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                JSValue* v = reinterpret_cast<const WideArg*>(localPC -12)->valueVal;
#line 1246 "codes.def"
                if (!JSValue::isObject(v)) {
                    throwError(exec, TypeError, "Value is not an object. Cannot be used with new.");
                    //return throwError(exec, TypeError, "Value %s (result of expression %s) is not an object. Cannot be used with new.", v, expr.get());
                    continue;
                }

                JSObject *constr = static_cast<JSObject*>(v);
                if (!constr->implementsConstruct()) {
                    throwError(exec, TypeError, "Value is not a constructor. Cannot be used with new.");
                    // ### TODO
                    // return throwError(exec, TypeError, "Value %s (result of expression %s) is not a constructor. Cannot be used with new.", v, expr.get());
                    continue;
                }

                JSValue* val = constr->construct(exec, workList);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(CtorCall_Ireg_Rvalue): {
                pc += 12;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -8)->regVal;
                JSValue* v = reinterpret_cast<const LocalStorageEntry*>(reinterpret_cast<const unsigned char*>(localStore) + reinterpret_cast<const NarrowArg*>(localPC -4)->regVal)->val.valueVal;
#line 1246 "codes.def"
                if (!JSValue::isObject(v)) {
                    throwError(exec, TypeError, "Value is not an object. Cannot be used with new.");
                    //return throwError(exec, TypeError, "Value %s (result of expression %s) is not an object. Cannot be used with new.", v, expr.get());
                    continue;
                }

                JSObject *constr = static_cast<JSObject*>(v);
                if (!constr->implementsConstruct()) {
                    throwError(exec, TypeError, "Value is not a constructor. Cannot be used with new.");
                    // ### TODO
                    // return throwError(exec, TypeError, "Value %s (result of expression %s) is not a constructor. Cannot be used with new.", v, expr.get());
                    continue;
                }

                JSValue* val = constr->construct(exec, workList);
                localStore[fbDestReg].val.valueVal = val;
            }
            continue;

            handler(EvalFuncExpr_Ireg_Iident_Inode_Pad):
                pc += 4;
                // Fallthrough
            handler(EvalFuncExpr_Ireg_Iident_Inode): {
                pc += 24;
                const unsigned char* localPC = pc;
                Register fbDestReg = reinterpret_cast<const NarrowArg*>(localPC -4)->regVal;
                Identifier* ident = reinterpret_cast<const WideArg*>(localPC -20)->identVal;
                Node* body = reinterpret_cast<const WideArg*>(localPC -12)->nodeVal;
#line 1267 "codes.def"
                bool named = !ident->isNull();
                JSObject *functionScopeObject = nullptr;

                if (named) {
                    // named FunctionExpressions can recursively call themselves,
                    // but they won't register with the current scope chain and should
                    // be contained as single property in an anonymous object.
                    functionScopeObject = new JSObject;
                    exec->pushScope(functionScopeObject);
                }

                FunctionImp *func = new FunctionImp(exec, *ident, static_cast<FunctionBodyNode*>(body), exec->scopeChain());
                JSObject *proto = exec->lexicalInterpreter()->builtinObject()->construct(exec, List::empty());
                proto->put(exec, exec->propertyNames().constructor, func, DontEnum);
                func->put(exec, exec->propertyNames().prototype, proto, Internal|DontDelete|DontEnum);

                if (named) {
                    functionScopeObject->put(exec, *ident, func, Internal | ReadOnly | (exec->codeType() == EvalCode ? 0 : DontDelete));
                        exec->popScope();
                }

                localStore[fbDestReg].val.valueVal = func;
            }
            continue;

        }

#line 263 "/build/kjs/src/kjs-5.97.0/src/kjs/bytecode/machine.cpp.in"
    }
}

}

// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on; hl c++;

