// services/network/public/mojom/cookie_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cookie_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/cookie_manager.mojom-params-data.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cookie_manager.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
CookieManagerParams::CookieManagerParams()
    : block_third_party_cookies(false),
      settings(),
      secure_origin_cookies_allowed_schemes(),
      matching_scheme_cookies_allowed_schemes(),
      third_party_cookies_allowed_schemes(),
      allow_file_scheme_cookies(false),
      settings_for_legacy_cookie_access(),
      settings_for_storage_access(),
      cookie_access_delegate_type(CookieAccessDelegateType::USE_CONTENT_SETTINGS) {}

CookieManagerParams::CookieManagerParams(
    bool block_third_party_cookies_in,
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings_in,
    WTF::Vector<WTF::String> secure_origin_cookies_allowed_schemes_in,
    WTF::Vector<WTF::String> matching_scheme_cookies_allowed_schemes_in,
    WTF::Vector<WTF::String> third_party_cookies_allowed_schemes_in,
    bool allow_file_scheme_cookies_in,
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings_for_legacy_cookie_access_in,
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings_for_storage_access_in,
    CookieAccessDelegateType cookie_access_delegate_type_in)
    : block_third_party_cookies(std::move(block_third_party_cookies_in)),
      settings(std::move(settings_in)),
      secure_origin_cookies_allowed_schemes(std::move(secure_origin_cookies_allowed_schemes_in)),
      matching_scheme_cookies_allowed_schemes(std::move(matching_scheme_cookies_allowed_schemes_in)),
      third_party_cookies_allowed_schemes(std::move(third_party_cookies_allowed_schemes_in)),
      allow_file_scheme_cookies(std::move(allow_file_scheme_cookies_in)),
      settings_for_legacy_cookie_access(std::move(settings_for_legacy_cookie_access_in)),
      settings_for_storage_access(std::move(settings_for_storage_access_in)),
      cookie_access_delegate_type(std::move(cookie_access_delegate_type_in)) {}

CookieManagerParams::~CookieManagerParams() = default;

void CookieManagerParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("block_third_party_cookies", this->block_third_party_cookies);
  value->BeginArray("settings");
  for (const auto& item0 : this->settings) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->BeginArray("secure_origin_cookies_allowed_schemes");
  for (const auto& item0 : this->secure_origin_cookies_allowed_schemes) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
  value->BeginArray("matching_scheme_cookies_allowed_schemes");
  for (const auto& item0 : this->matching_scheme_cookies_allowed_schemes) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
  value->BeginArray("third_party_cookies_allowed_schemes");
  for (const auto& item0 : this->third_party_cookies_allowed_schemes) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
  value->SetBoolean("allow_file_scheme_cookies", this->allow_file_scheme_cookies);
  value->BeginArray("settings_for_legacy_cookie_access");
  for (const auto& item0 : this->settings_for_legacy_cookie_access) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->BeginArray("settings_for_storage_access");
  for (const auto& item0 : this->settings_for_storage_access) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("cookie_access_delegate_type", base::trace_event::ValueToString(this->cookie_access_delegate_type));
}

bool CookieManagerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieSameSiteContext::CookieSameSiteContext()
    : context(ContextType::CROSS_SITE),
      schemeful_context(ContextType::CROSS_SITE) {}

CookieSameSiteContext::CookieSameSiteContext(
    ContextType context_in,
    ContextType schemeful_context_in)
    : context(std::move(context_in)),
      schemeful_context(std::move(schemeful_context_in)) {}

CookieSameSiteContext::~CookieSameSiteContext() = default;
size_t CookieSameSiteContext::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->context);
  seed = mojo::internal::WTFHash(seed, this->schemeful_context);
  return seed;
}

void CookieSameSiteContext::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("context", base::trace_event::ValueToString(this->context));
  value->SetString("schemeful_context", base::trace_event::ValueToString(this->schemeful_context));
}

bool CookieSameSiteContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOptions::CookieOptions()
    : exclude_httponly(true),
      same_site_cookie_context(),
      update_access_time(true),
      return_excluded_cookies(false) {}

CookieOptions::CookieOptions(
    bool exclude_httponly_in,
    CookieSameSiteContextPtr same_site_cookie_context_in,
    bool update_access_time_in,
    bool return_excluded_cookies_in)
    : exclude_httponly(std::move(exclude_httponly_in)),
      same_site_cookie_context(std::move(same_site_cookie_context_in)),
      update_access_time(std::move(update_access_time_in)),
      return_excluded_cookies(std::move(return_excluded_cookies_in)) {}

CookieOptions::~CookieOptions() = default;
size_t CookieOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->exclude_httponly);
  seed = mojo::internal::WTFHash(seed, this->same_site_cookie_context);
  seed = mojo::internal::WTFHash(seed, this->update_access_time);
  seed = mojo::internal::WTFHash(seed, this->return_excluded_cookies);
  return seed;
}

void CookieOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("exclude_httponly", this->exclude_httponly);
  if (this->same_site_cookie_context.is_null()) {
    value->SetString("same_site_cookie_context", "nullptr");
  } else {
    value->BeginDictionary("same_site_cookie_context");
    this->same_site_cookie_context->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("update_access_time", this->update_access_time);
  value->SetBoolean("return_excluded_cookies", this->return_excluded_cookies);
}

bool CookieOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CanonicalCookie::CanonicalCookie()
    : name(),
      value(),
      domain(),
      path(),
      creation(),
      expiry(),
      last_access(),
      secure(false),
      httponly(false),
      site_restrictions(CookieSameSite::NO_RESTRICTION),
      priority(CookiePriority::MEDIUM),
      source_scheme(CookieSourceScheme::kUnset) {}

CanonicalCookie::CanonicalCookie(
    const WTF::String& name_in,
    const WTF::String& value_in,
    const WTF::String& domain_in,
    const WTF::String& path_in,
    ::base::Time creation_in,
    ::base::Time expiry_in,
    ::base::Time last_access_in,
    bool secure_in,
    bool httponly_in,
    CookieSameSite site_restrictions_in,
    CookiePriority priority_in,
    CookieSourceScheme source_scheme_in)
    : name(std::move(name_in)),
      value(std::move(value_in)),
      domain(std::move(domain_in)),
      path(std::move(path_in)),
      creation(std::move(creation_in)),
      expiry(std::move(expiry_in)),
      last_access(std::move(last_access_in)),
      secure(std::move(secure_in)),
      httponly(std::move(httponly_in)),
      site_restrictions(std::move(site_restrictions_in)),
      priority(std::move(priority_in)),
      source_scheme(std::move(source_scheme_in)) {}

CanonicalCookie::~CanonicalCookie() = default;

void CanonicalCookie::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", this->name.Utf8());
  value->SetString("value", this->value.Utf8());
  value->SetString("domain", this->domain.Utf8());
  value->SetString("path", this->path.Utf8());
  value->SetString("creation", base::trace_event::ValueToString(this->creation, "<value of type ::base::Time>"));
  value->SetString("expiry", base::trace_event::ValueToString(this->expiry, "<value of type ::base::Time>"));
  value->SetString("last_access", base::trace_event::ValueToString(this->last_access, "<value of type ::base::Time>"));
  value->SetBoolean("secure", this->secure);
  value->SetBoolean("httponly", this->httponly);
  value->SetString("site_restrictions", base::trace_event::ValueToString(this->site_restrictions));
  value->SetString("priority", base::trace_event::ValueToString(this->priority));
  value->SetString("source_scheme", base::trace_event::ValueToString(this->source_scheme));
}

bool CanonicalCookie::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieInclusionStatus::CookieInclusionStatus()
    : exclusion_reasons(),
      warning_reasons() {}

CookieInclusionStatus::CookieInclusionStatus(
    uint32_t exclusion_reasons_in,
    uint32_t warning_reasons_in)
    : exclusion_reasons(std::move(exclusion_reasons_in)),
      warning_reasons(std::move(warning_reasons_in)) {}

CookieInclusionStatus::~CookieInclusionStatus() = default;
size_t CookieInclusionStatus::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->exclusion_reasons);
  seed = mojo::internal::WTFHash(seed, this->warning_reasons);
  return seed;
}

void CookieInclusionStatus::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("exclusion_reasons", base::NumberToString(this->exclusion_reasons));
  value->SetString("warning_reasons", base::NumberToString(this->warning_reasons));
}

bool CookieInclusionStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieAndLineWithAccessResult::CookieAndLineWithAccessResult()
    : cookie(),
      cookie_string(),
      access_result() {}

CookieAndLineWithAccessResult::CookieAndLineWithAccessResult(
    const base::Optional<::blink::CanonicalCookie>& cookie_in,
    const WTF::String& cookie_string_in,
    CookieAccessResultPtr access_result_in)
    : cookie(std::move(cookie_in)),
      cookie_string(std::move(cookie_string_in)),
      access_result(std::move(access_result_in)) {}

CookieAndLineWithAccessResult::~CookieAndLineWithAccessResult() = default;

void CookieAndLineWithAccessResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("cookie", base::trace_event::ValueToString(this->cookie, "<value of type const base::Optional<::blink::CanonicalCookie>&>"));
  value->SetString("cookie_string", this->cookie_string.Utf8());
  if (this->access_result.is_null()) {
    value->SetString("access_result", "nullptr");
  } else {
    value->BeginDictionary("access_result");
    this->access_result->AsValueInto(value);
    value->EndDictionary();
  }
}

bool CookieAndLineWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieAccessResult::CookieAccessResult()
    : effective_same_site(),
      access_semantics(),
      status() {}

CookieAccessResult::CookieAccessResult(
    CookieEffectiveSameSite effective_same_site_in,
    CookieAccessSemantics access_semantics_in,
    CookieInclusionStatusPtr status_in)
    : effective_same_site(std::move(effective_same_site_in)),
      access_semantics(std::move(access_semantics_in)),
      status(std::move(status_in)) {}

CookieAccessResult::~CookieAccessResult() = default;
size_t CookieAccessResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->effective_same_site);
  seed = mojo::internal::WTFHash(seed, this->access_semantics);
  seed = mojo::internal::WTFHash(seed, this->status);
  return seed;
}

void CookieAccessResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("effective_same_site", base::trace_event::ValueToString(this->effective_same_site));
  value->SetString("access_semantics", base::trace_event::ValueToString(this->access_semantics));
  if (this->status.is_null()) {
    value->SetString("status", "nullptr");
  } else {
    value->BeginDictionary("status");
    this->status->AsValueInto(value);
    value->EndDictionary();
  }
}

bool CookieAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieWithAccessResult::CookieWithAccessResult()
    : cookie(),
      access_result() {}

CookieWithAccessResult::CookieWithAccessResult(
    const ::blink::CanonicalCookie& cookie_in,
    CookieAccessResultPtr access_result_in)
    : cookie(std::move(cookie_in)),
      access_result(std::move(access_result_in)) {}

CookieWithAccessResult::~CookieWithAccessResult() = default;

void CookieWithAccessResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("cookie", base::trace_event::ValueToString(this->cookie, "<value of type const ::blink::CanonicalCookie&>"));
  if (this->access_result.is_null()) {
    value->SetString("access_result", "nullptr");
  } else {
    value->BeginDictionary("access_result");
    this->access_result->AsValueInto(value);
    value->EndDictionary();
  }
}

bool CookieWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieChangeInfo::CookieChangeInfo()
    : cookie(),
      access_result(),
      cause() {}

CookieChangeInfo::CookieChangeInfo(
    const ::blink::CanonicalCookie& cookie_in,
    CookieAccessResultPtr access_result_in,
    CookieChangeCause cause_in)
    : cookie(std::move(cookie_in)),
      access_result(std::move(access_result_in)),
      cause(std::move(cause_in)) {}

CookieChangeInfo::~CookieChangeInfo() = default;

void CookieChangeInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("cookie", base::trace_event::ValueToString(this->cookie, "<value of type const ::blink::CanonicalCookie&>"));
  if (this->access_result.is_null()) {
    value->SetString("access_result", "nullptr");
  } else {
    value->BeginDictionary("access_result");
    this->access_result->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("cause", base::trace_event::ValueToString(this->cause));
}

bool CookieChangeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieDeletionFilter::CookieDeletionFilter()
    : created_after_time(),
      created_before_time(),
      excluding_domains(),
      including_domains(),
      cookie_name(),
      host_name(),
      url(),
      session_control(CookieDeletionSessionControl::IGNORE_CONTROL) {}

CookieDeletionFilter::CookieDeletionFilter(
    base::Optional<::base::Time> created_after_time_in,
    base::Optional<::base::Time> created_before_time_in,
    base::Optional<WTF::Vector<WTF::String>> excluding_domains_in,
    base::Optional<WTF::Vector<WTF::String>> including_domains_in,
    const WTF::String& cookie_name_in,
    const WTF::String& host_name_in,
    const base::Optional<::blink::KURL>& url_in,
    CookieDeletionSessionControl session_control_in)
    : created_after_time(std::move(created_after_time_in)),
      created_before_time(std::move(created_before_time_in)),
      excluding_domains(std::move(excluding_domains_in)),
      including_domains(std::move(including_domains_in)),
      cookie_name(std::move(cookie_name_in)),
      host_name(std::move(host_name_in)),
      url(std::move(url_in)),
      session_control(std::move(session_control_in)) {}

CookieDeletionFilter::~CookieDeletionFilter() = default;

void CookieDeletionFilter::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("created_after_time", base::trace_event::ValueToString(this->created_after_time, "<value of type base::Optional<::base::Time>>"));
  value->SetString("created_before_time", base::trace_event::ValueToString(this->created_before_time, "<value of type base::Optional<::base::Time>>"));
  if (this->excluding_domains.has_value()) {
    value->BeginArray("excluding_domains");
    for (const auto& item0 : this->excluding_domains.value()) {
      value->AppendString(item0.Utf8());
    }
    value->EndArray();
  } else {
    value->SetString("excluding_domains", "base::nullopt");
  }
  if (this->including_domains.has_value()) {
    value->BeginArray("including_domains");
    for (const auto& item0 : this->including_domains.value()) {
      value->AppendString(item0.Utf8());
    }
    value->EndArray();
  } else {
    value->SetString("including_domains", "base::nullopt");
  }
  value->SetString("cookie_name", this->cookie_name.Utf8());
  value->SetString("host_name", this->host_name.Utf8());
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const base::Optional<::blink::KURL>&>"));
  value->SetString("session_control", base::trace_event::ValueToString(this->session_control));
}

bool CookieDeletionFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CookieChangeListener::Name_[] = "network.mojom.CookieChangeListener";

CookieChangeListenerProxy::CookieChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieChangeListenerProxy::OnCookieChange(
    CookieChangeInfoPtr in_change) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieChangeListener::OnCookieChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_change.is_null()) {
        raw_value->SetString("change", "nullptr");
      } else {
        raw_value->BeginDictionary("change");
        in_change->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieChangeListener_OnCookieChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieChangeListener_OnCookieChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->change)::BaseType::BufferWriter
      change_writer;
  mojo::internal::Serialize<::network::mojom::CookieChangeInfoDataView>(
      in_change, buffer, &change_writer, &serialization_context);
  params->change.Set(
      change_writer.is_null() ? nullptr : change_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->change.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null change in CookieChangeListener.OnCookieChange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieChangeListener::Name_);
  message.set_method_name("OnCookieChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CookieChangeListenerStubDispatch::Accept(
    CookieChangeListener* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCookieChangeListener_OnCookieChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieChangeListener::OnCookieChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieChangeListener::OnCookieChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieChangeListener_OnCookieChange_Params_Data* params =
          reinterpret_cast<internal::CookieChangeListener_OnCookieChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CookieChangeInfoPtr p_change{};
      CookieChangeListener_OnCookieChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChange(&p_change))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieChangeListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCookieChange(
std::move(p_change));
      return true;
    }
  }
  return false;
}

// static
bool CookieChangeListenerStubDispatch::AcceptWithResponder(
    CookieChangeListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieChangeListener_OnCookieChange_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieChangeListenerValidationInfo[] = {
    {internal::kCookieChangeListener_OnCookieChange_Name,
     {&internal::CookieChangeListener_OnCookieChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CookieChangeListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieChangeListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieChangeListenerValidationInfo);
}

const char CookieRemoteAccessFilter::Name_[] = "network.mojom.CookieRemoteAccessFilter";

class CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(
      CookieRemoteAccessFilter::AllowedAccessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieRemoteAccessFilter::AllowedAccessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback);
};

CookieRemoteAccessFilterProxy::CookieRemoteAccessFilterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieRemoteAccessFilterProxy::AllowedAccess(
    const ::blink::KURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, AllowedAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieRemoteAccessFilter::AllowedAccess", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieRemoteAccessFilter_AllowedAccess_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieRemoteAccessFilter.AllowedAccess request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in CookieRemoteAccessFilter.AllowedAccess request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieRemoteAccessFilter::Name_);
  message.set_method_name("AllowedAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder {
 public:
  static CookieRemoteAccessFilter::AllowedAccessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder> proxy(
        new CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieRemoteAccessFilter::AllowedAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder);
};

bool CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieRemoteAccessFilter::AllowedAccessCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_allowed{};
  CookieRemoteAccessFilter_AllowedAccess_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieRemoteAccessFilter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_allowed));
  return true;
}

void CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccessCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("allowed", in_allowed);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieRemoteAccessFilter_AllowedAccess_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->allowed = in_allowed;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieRemoteAccessFilter::Name_);
  message.set_method_name("AllowedAccess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieRemoteAccessFilterStubDispatch::Accept(
    CookieRemoteAccessFilter* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCookieRemoteAccessFilter_AllowedAccess_Name: {
      break;
    }
  }
  return false;
}

// static
bool CookieRemoteAccessFilterStubDispatch::AcceptWithResponder(
    CookieRemoteAccessFilter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieRemoteAccessFilter_AllowedAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data* params =
          reinterpret_cast<
              internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      CookieRemoteAccessFilter_AllowedAccess_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieRemoteAccessFilter::Name_, 0, false);
        return false;
      }
      CookieRemoteAccessFilter::AllowedAccessCallback callback =
          CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowedAccess(
std::move(p_url), 
std::move(p_site_for_cookies), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieRemoteAccessFilterValidationInfo[] = {
    {internal::kCookieRemoteAccessFilter_AllowedAccess_Name,
     {&internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data::Validate,
      &internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data::Validate}},
};

bool CookieRemoteAccessFilterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieRemoteAccessFilter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieRemoteAccessFilterValidationInfo);
}

bool CookieRemoteAccessFilterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieRemoteAccessFilter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCookieRemoteAccessFilterValidationInfo);

}
const char CookieManager::Name_[] = "network.mojom.CookieManager";

class CookieManager_GetAllCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetAllCookies_ForwardToCallback(
      CookieManager::GetAllCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetAllCookiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookies_ForwardToCallback);
};

class CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(
      CookieManager::GetAllCookiesWithAccessSemanticsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetAllCookiesWithAccessSemanticsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback);
};

class CookieManager_GetCookieList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetCookieList_ForwardToCallback(
      CookieManager::GetCookieListCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetCookieListCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetCookieList_ForwardToCallback);
};

class CookieManager_SetCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_SetCanonicalCookie_ForwardToCallback(
      CookieManager::SetCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::SetCanonicalCookieCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetCanonicalCookie_ForwardToCallback);
};

class CookieManager_DeleteCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteCanonicalCookie_ForwardToCallback(
      CookieManager::DeleteCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteCanonicalCookieCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCanonicalCookie_ForwardToCallback);
};

class CookieManager_DeleteCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteCookies_ForwardToCallback(
      CookieManager::DeleteCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteCookiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCookies_ForwardToCallback);
};

class CookieManager_FlushCookieStore_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_FlushCookieStore_ForwardToCallback(
      CookieManager::FlushCookieStoreCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::FlushCookieStoreCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_FlushCookieStore_ForwardToCallback);
};

class CookieManager_AllowFileSchemeCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_AllowFileSchemeCookies_ForwardToCallback(
      CookieManager::AllowFileSchemeCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::AllowFileSchemeCookiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_AllowFileSchemeCookies_ForwardToCallback);
};

class CookieManager_SetStorageAccessGrantSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_SetStorageAccessGrantSettings_ForwardToCallback(
      CookieManager::SetStorageAccessGrantSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::SetStorageAccessGrantSettingsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetStorageAccessGrantSettings_ForwardToCallback);
};

CookieManagerProxy::CookieManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieManagerProxy::GetAllCookies(
    GetAllCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::GetAllCookies");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_GetAllCookies_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetAllCookies_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::GetAllCookiesWithAccessSemantics(
    GetAllCookiesWithAccessSemanticsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::GetAllCookiesWithAccessSemantics");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookiesWithAccessSemantics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::GetCookieList(
    const ::blink::KURL& in_url, CookieOptionsPtr in_cookie_options, GetCookieListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::GetCookieList", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      if (in_cookie_options.is_null()) {
        raw_value->SetString("cookie_options", "nullptr");
      } else {
        raw_value->BeginDictionary("cookie_options");
        in_cookie_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetCookieList_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_GetCookieList_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieManager.GetCookieList request");
  typename decltype(params->cookie_options)::BaseType::BufferWriter
      cookie_options_writer;
  mojo::internal::Serialize<::network::mojom::CookieOptionsDataView>(
      in_cookie_options, buffer, &cookie_options_writer, &serialization_context);
  params->cookie_options.Set(
      cookie_options_writer.is_null() ? nullptr : cookie_options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_options in CookieManager.GetCookieList request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetCookieList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetCookieList_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::SetCanonicalCookie(
    const ::blink::CanonicalCookie& in_cookie, const ::blink::KURL& in_source_url, CookieOptionsPtr in_cookie_options, SetCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetCanonicalCookie", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cookie", base::trace_event::ValueToString(in_cookie, "<value of type const ::blink::CanonicalCookie&>"));
      raw_value->SetString("source_url", base::trace_event::ValueToString(in_source_url, "<value of type const ::blink::KURL&>"));
      if (in_cookie_options.is_null()) {
        raw_value->SetString("cookie_options", "nullptr");
      } else {
        raw_value->BeginDictionary("cookie_options");
        in_cookie_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetCanonicalCookie_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookie)::BaseType::BufferWriter
      cookie_writer;
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie, buffer, &cookie_writer, &serialization_context);
  params->cookie.Set(
      cookie_writer.is_null() ? nullptr : cookie_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieManager.SetCanonicalCookie request");
  typename decltype(params->source_url)::BaseType::BufferWriter
      source_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_source_url, buffer, &source_url_writer, &serialization_context);
  params->source_url.Set(
      source_url_writer.is_null() ? nullptr : source_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_url in CookieManager.SetCanonicalCookie request");
  typename decltype(params->cookie_options)::BaseType::BufferWriter
      cookie_options_writer;
  mojo::internal::Serialize<::network::mojom::CookieOptionsDataView>(
      in_cookie_options, buffer, &cookie_options_writer, &serialization_context);
  params->cookie_options.Set(
      cookie_options_writer.is_null() ? nullptr : cookie_options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_options in CookieManager.SetCanonicalCookie request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_SetCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::DeleteCanonicalCookie(
    const ::blink::CanonicalCookie& in_cookie, DeleteCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::DeleteCanonicalCookie", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cookie", base::trace_event::ValueToString(in_cookie, "<value of type const ::blink::CanonicalCookie&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_DeleteCanonicalCookie_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookie)::BaseType::BufferWriter
      cookie_writer;
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie, buffer, &cookie_writer, &serialization_context);
  params->cookie.Set(
      cookie_writer.is_null() ? nullptr : cookie_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieManager.DeleteCanonicalCookie request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::DeleteCookies(
    CookieDeletionFilterPtr in_filter, DeleteCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::DeleteCookies", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_DeleteCookies_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::CookieDeletionFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in CookieManager.DeleteCookies request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteCookies_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::AddCookieChangeListener(
    const ::blink::KURL& in_url, const WTF::String& in_name, ::mojo::PendingRemote<CookieChangeListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::AddCookieChangeListener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetString("name", in_name.Utf8());
      raw_value->SetBoolean("listener", in_listener.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AddCookieChangeListener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_AddCookieChangeListener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieManager.AddCookieChangeListener request");
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
      in_listener, &params->listener, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in CookieManager.AddCookieChangeListener request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AddCookieChangeListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::AddGlobalChangeListener(
    ::mojo::PendingRemote<CookieChangeListener> in_notification_pointer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::AddGlobalChangeListener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("notification_pointer", in_notification_pointer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AddGlobalChangeListener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_AddGlobalChangeListener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
      in_notification_pointer, &params->notification_pointer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->notification_pointer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid notification_pointer in CookieManager.AddGlobalChangeListener request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AddGlobalChangeListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::CloneInterface(
    ::mojo::PendingReceiver<CookieManager> in_new_interface) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::CloneInterface", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("new_interface", in_new_interface.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_CloneInterface_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_CloneInterface_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
      in_new_interface, &params->new_interface, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->new_interface),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid new_interface in CookieManager.CloneInterface request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("CloneInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::FlushCookieStore(
    FlushCookieStoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::FlushCookieStore");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_FlushCookieStore_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_FlushCookieStore_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("FlushCookieStore");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_FlushCookieStore_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::AllowFileSchemeCookies(
    bool in_allow, AllowFileSchemeCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::AllowFileSchemeCookies", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("allow", in_allow);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AllowFileSchemeCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_AllowFileSchemeCookies_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->allow = in_allow;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AllowFileSchemeCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_AllowFileSchemeCookies_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::SetContentSettings(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetContentSettings", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("settings");
      for (const auto& item0 : in_settings) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetContentSettings_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetContentSettings_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->settings)::BaseType::BufferWriter
      settings_writer;
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, buffer, &settings_writer, &settings_validate_params,
      &serialization_context);
  params->settings.Set(
      settings_writer.is_null() ? nullptr : settings_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in CookieManager.SetContentSettings request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetContentSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetRemoteFilter(
    ::mojo::PendingRemote<CookieRemoteAccessFilter> in_remote_access_filter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetRemoteFilter", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("remote_access_filter", in_remote_access_filter.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetRemoteFilter_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetRemoteFilter_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieRemoteAccessFilterInterfaceBase>>(
      in_remote_access_filter, &params->remote_access_filter, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote_access_filter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote_access_filter in CookieManager.SetRemoteFilter request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetRemoteFilter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::SetForceKeepSessionState");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetForceKeepSessionState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetForceKeepSessionState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::BlockThirdPartyCookies(
    bool in_block) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::BlockThirdPartyCookies", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("block", in_block);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_BlockThirdPartyCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_BlockThirdPartyCookies_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->block = in_block;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("BlockThirdPartyCookies");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetContentSettingsForLegacyCookieAccess(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetContentSettingsForLegacyCookieAccess", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("settings");
      for (const auto& item0 : in_settings) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->settings)::BaseType::BufferWriter
      settings_writer;
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, buffer, &settings_writer, &settings_validate_params,
      &serialization_context);
  params->settings.Set(
      settings_writer.is_null() ? nullptr : settings_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in CookieManager.SetContentSettingsForLegacyCookieAccess request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetContentSettingsForLegacyCookieAccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetStorageAccessGrantSettings(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings, SetStorageAccessGrantSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetStorageAccessGrantSettings", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("settings");
      for (const auto& item0 : in_settings) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetStorageAccessGrantSettings_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetStorageAccessGrantSettings_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->settings)::BaseType::BufferWriter
      settings_writer;
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, buffer, &settings_writer, &settings_validate_params,
      &serialization_context);
  params->settings.Set(
      settings_writer.is_null() ? nullptr : settings_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in CookieManager.SetStorageAccessGrantSettings request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetStorageAccessGrantSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_SetStorageAccessGrantSettings_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CookieManager_GetAllCookies_ProxyToResponder {
 public:
  static CookieManager::GetAllCookiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_GetAllCookies_ProxyToResponder> proxy(
        new CookieManager_GetAllCookies_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_GetAllCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetAllCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_GetAllCookies_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetAllCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::blink::CanonicalCookie>& in_cookies);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookies_ProxyToResponder);
};

bool CookieManager_GetAllCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::GetAllCookiesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_GetAllCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetAllCookies_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<::blink::CanonicalCookie> p_cookies{};
  CookieManager_GetAllCookies_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies));
  return true;
}

void CookieManager_GetAllCookies_ProxyToResponder::Run(
    const WTF::Vector<::blink::CanonicalCookie>& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("cookies");
      for (const auto& item0 : in_cookies) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::blink::CanonicalCookie&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_GetAllCookies_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookies)::BaseType::BufferWriter
      cookies_writer;
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
      in_cookies, buffer, &cookies_writer, &cookies_validate_params,
      &serialization_context);
  params->cookies.Set(
      cookies_writer.is_null() ? nullptr : cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookies");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder {
 public:
  static CookieManager::GetAllCookiesWithAccessSemanticsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder> proxy(
        new CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetAllCookiesWithAccessSemanticsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::blink::CanonicalCookie>& in_cookies, const WTF::Vector<CookieAccessSemantics>& in_access_semantics_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder);
};

bool CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::GetAllCookiesWithAccessSemanticsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<::blink::CanonicalCookie> p_cookies{};
  WTF::Vector<CookieAccessSemantics> p_access_semantics_list{};
  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (success && !input_data_view.ReadAccessSemanticsList(&p_access_semantics_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies), 
std::move(p_access_semantics_list));
  return true;
}

void CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::Run(
    const WTF::Vector<::blink::CanonicalCookie>& in_cookies, const WTF::Vector<CookieAccessSemantics>& in_access_semantics_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemanticsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("cookies");
      for (const auto& item0 : in_cookies) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::blink::CanonicalCookie&>"));
      }
      raw_value->EndArray();
      raw_value->BeginArray("access_semantics_list");
      for (const auto& item0 : in_access_semantics_list) {
        raw_value->AppendString(base::trace_event::ValueToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookies)::BaseType::BufferWriter
      cookies_writer;
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
      in_cookies, buffer, &cookies_writer, &cookies_validate_params,
      &serialization_context);
  params->cookies.Set(
      cookies_writer.is_null() ? nullptr : cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  typename decltype(params->access_semantics_list)::BaseType::BufferWriter
      access_semantics_list_writer;
  const mojo::internal::ContainerValidateParams access_semantics_list_validate_params(
      0, ::network::mojom::internal::CookieAccessSemantics_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAccessSemantics>>(
      in_access_semantics_list, buffer, &access_semantics_list_writer, &access_semantics_list_validate_params,
      &serialization_context);
  params->access_semantics_list.Set(
      access_semantics_list_writer.is_null() ? nullptr : access_semantics_list_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->access_semantics_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_semantics_list in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemanticsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookiesWithAccessSemantics");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_GetCookieList_ProxyToResponder {
 public:
  static CookieManager::GetCookieListCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_GetCookieList_ProxyToResponder> proxy(
        new CookieManager_GetCookieList_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_GetCookieList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetCookieList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_GetCookieList_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetCookieListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<CookieWithAccessResultPtr> in_cookies, WTF::Vector<CookieWithAccessResultPtr> in_excluded_cookies);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetCookieList_ProxyToResponder);
};

bool CookieManager_GetCookieList_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::GetCookieListCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_GetCookieList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetCookieList_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<CookieWithAccessResultPtr> p_cookies{};
  WTF::Vector<CookieWithAccessResultPtr> p_excluded_cookies{};
  CookieManager_GetCookieList_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (success && !input_data_view.ReadExcludedCookies(&p_excluded_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies), 
std::move(p_excluded_cookies));
  return true;
}

void CookieManager_GetCookieList_ProxyToResponder::Run(
    WTF::Vector<CookieWithAccessResultPtr> in_cookies, WTF::Vector<CookieWithAccessResultPtr> in_excluded_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::GetCookieListCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("cookies");
      for (const auto& item0 : in_cookies) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->BeginArray("excluded_cookies");
      for (const auto& item0 : in_excluded_cookies) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetCookieList_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_GetCookieList_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookies)::BaseType::BufferWriter
      cookies_writer;
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_cookies, buffer, &cookies_writer, &cookies_validate_params,
      &serialization_context);
  params->cookies.Set(
      cookies_writer.is_null() ? nullptr : cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  typename decltype(params->excluded_cookies)::BaseType::BufferWriter
      excluded_cookies_writer;
  const mojo::internal::ContainerValidateParams excluded_cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_excluded_cookies, buffer, &excluded_cookies_writer, &excluded_cookies_validate_params,
      &serialization_context);
  params->excluded_cookies.Set(
      excluded_cookies_writer.is_null() ? nullptr : excluded_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->excluded_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null excluded_cookies in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::GetCookieListCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetCookieList");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_SetCanonicalCookie_ProxyToResponder {
 public:
  static CookieManager::SetCanonicalCookieCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_SetCanonicalCookie_ProxyToResponder> proxy(
        new CookieManager_SetCanonicalCookie_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_SetCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_SetCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_SetCanonicalCookie_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::SetCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CookieAccessResultPtr in_access_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetCanonicalCookie_ProxyToResponder);
};

bool CookieManager_SetCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::SetCanonicalCookieCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_SetCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_SetCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CookieAccessResultPtr p_access_result{};
  CookieManager_SetCanonicalCookie_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadAccessResult(&p_access_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_access_result));
  return true;
}

void CookieManager_SetCanonicalCookie_ProxyToResponder::Run(
    CookieAccessResultPtr in_access_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::SetCanonicalCookieCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_access_result.is_null()) {
        raw_value->SetString("access_result", "nullptr");
      } else {
        raw_value->BeginDictionary("access_result");
        in_access_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetCanonicalCookie_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->access_result)::BaseType::BufferWriter
      access_result_writer;
  mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
      in_access_result, buffer, &access_result_writer, &serialization_context);
  params->access_result.Set(
      access_result_writer.is_null() ? nullptr : access_result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->access_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::SetCanonicalCookieCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteCanonicalCookie_ProxyToResponder {
 public:
  static CookieManager::DeleteCanonicalCookieCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_DeleteCanonicalCookie_ProxyToResponder> proxy(
        new CookieManager_DeleteCanonicalCookie_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_DeleteCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_DeleteCanonicalCookie_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCanonicalCookie_ProxyToResponder);
};

bool CookieManager_DeleteCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::DeleteCanonicalCookieCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  CookieManager_DeleteCanonicalCookie_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void CookieManager_DeleteCanonicalCookie_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::DeleteCanonicalCookieCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::DeleteCanonicalCookieCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteCookies_ProxyToResponder {
 public:
  static CookieManager::DeleteCookiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_DeleteCookies_ProxyToResponder> proxy(
        new CookieManager_DeleteCookies_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_DeleteCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_DeleteCookies_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_num_deleted);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCookies_ProxyToResponder);
};

bool CookieManager_DeleteCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::DeleteCookiesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteCookies_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  uint32_t p_num_deleted{};
  CookieManager_DeleteCookies_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_num_deleted = input_data_view.num_deleted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_num_deleted));
  return true;
}

void CookieManager_DeleteCookies_ProxyToResponder::Run(
    uint32_t in_num_deleted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::DeleteCookiesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("num_deleted", base::NumberToString(in_num_deleted));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_DeleteCookies_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->num_deleted = in_num_deleted;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::DeleteCookiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCookies");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_FlushCookieStore_ProxyToResponder {
 public:
  static CookieManager::FlushCookieStoreCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_FlushCookieStore_ProxyToResponder> proxy(
        new CookieManager_FlushCookieStore_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_FlushCookieStore_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_FlushCookieStore_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_FlushCookieStore_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::FlushCookieStoreCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_FlushCookieStore_ProxyToResponder);
};

bool CookieManager_FlushCookieStore_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::FlushCookieStoreCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_FlushCookieStore_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_FlushCookieStore_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CookieManager_FlushCookieStore_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CookieManager_FlushCookieStore_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::CookieManager::FlushCookieStoreCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_FlushCookieStore_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_FlushCookieStore_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::FlushCookieStoreCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("FlushCookieStore");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_AllowFileSchemeCookies_ProxyToResponder {
 public:
  static CookieManager::AllowFileSchemeCookiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_AllowFileSchemeCookies_ProxyToResponder> proxy(
        new CookieManager_AllowFileSchemeCookies_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_AllowFileSchemeCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_AllowFileSchemeCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_AllowFileSchemeCookies_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::AllowFileSchemeCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_AllowFileSchemeCookies_ProxyToResponder);
};

bool CookieManager_AllowFileSchemeCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::AllowFileSchemeCookiesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  CookieManager_AllowFileSchemeCookies_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void CookieManager_AllowFileSchemeCookies_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::AllowFileSchemeCookiesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AllowFileSchemeCookies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::AllowFileSchemeCookiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AllowFileSchemeCookies");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_SetStorageAccessGrantSettings_ProxyToResponder {
 public:
  static CookieManager::SetStorageAccessGrantSettingsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_SetStorageAccessGrantSettings_ProxyToResponder> proxy(
        new CookieManager_SetStorageAccessGrantSettings_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_SetStorageAccessGrantSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_SetStorageAccessGrantSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_SetStorageAccessGrantSettings_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::SetStorageAccessGrantSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetStorageAccessGrantSettings_ProxyToResponder);
};

bool CookieManager_SetStorageAccessGrantSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::SetStorageAccessGrantSettingsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CookieManager_SetStorageAccessGrantSettings_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CookieManager_SetStorageAccessGrantSettings_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettingsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetStorageAccessGrantSettings_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettingsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetStorageAccessGrantSettings");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieManagerStubDispatch::Accept(
    CookieManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCookieManager_GetAllCookies_Name: {
      break;
    }
    case internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name: {
      break;
    }
    case internal::kCookieManager_GetCookieList_Name: {
      break;
    }
    case internal::kCookieManager_SetCanonicalCookie_Name: {
      break;
    }
    case internal::kCookieManager_DeleteCanonicalCookie_Name: {
      break;
    }
    case internal::kCookieManager_DeleteCookies_Name: {
      break;
    }
    case internal::kCookieManager_AddCookieChangeListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::AddCookieChangeListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::AddCookieChangeListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_AddCookieChangeListener_Params_Data* params =
          reinterpret_cast<internal::CookieManager_AddCookieChangeListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_name{};
      ::mojo::PendingRemote<CookieChangeListener> p_listener{};
      CookieManager_AddCookieChangeListener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCookieChangeListener(
std::move(p_url), 
std::move(p_name), 
std::move(p_listener));
      return true;
    }
    case internal::kCookieManager_AddGlobalChangeListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::AddGlobalChangeListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::AddGlobalChangeListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_AddGlobalChangeListener_Params_Data* params =
          reinterpret_cast<internal::CookieManager_AddGlobalChangeListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<CookieChangeListener> p_notification_pointer{};
      CookieManager_AddGlobalChangeListener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_notification_pointer =
            input_data_view.TakeNotificationPointer<decltype(p_notification_pointer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddGlobalChangeListener(
std::move(p_notification_pointer));
      return true;
    }
    case internal::kCookieManager_CloneInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::CloneInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::CloneInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_CloneInterface_Params_Data* params =
          reinterpret_cast<internal::CookieManager_CloneInterface_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<CookieManager> p_new_interface{};
      CookieManager_CloneInterface_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_new_interface =
            input_data_view.TakeNewInterface<decltype(p_new_interface)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneInterface(
std::move(p_new_interface));
      return true;
    }
    case internal::kCookieManager_FlushCookieStore_Name: {
      break;
    }
    case internal::kCookieManager_AllowFileSchemeCookies_Name: {
      break;
    }
    case internal::kCookieManager_SetContentSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetContentSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetContentSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetContentSettings_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetContentSettings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetContentSettings_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContentSettings(
std::move(p_settings));
      return true;
    }
    case internal::kCookieManager_SetRemoteFilter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetRemoteFilter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetRemoteFilter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetRemoteFilter_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetRemoteFilter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<CookieRemoteAccessFilter> p_remote_access_filter{};
      CookieManager_SetRemoteFilter_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_remote_access_filter =
            input_data_view.TakeRemoteAccessFilter<decltype(p_remote_access_filter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRemoteFilter(
std::move(p_remote_access_filter));
      return true;
    }
    case internal::kCookieManager_SetForceKeepSessionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetForceKeepSessionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetForceKeepSessionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CookieManager_SetForceKeepSessionState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForceKeepSessionState();
      return true;
    }
    case internal::kCookieManager_BlockThirdPartyCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::BlockThirdPartyCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::BlockThirdPartyCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_BlockThirdPartyCookies_Params_Data* params =
          reinterpret_cast<internal::CookieManager_BlockThirdPartyCookies_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_block{};
      CookieManager_BlockThirdPartyCookies_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_block = input_data_view.block();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlockThirdPartyCookies(
std::move(p_block));
      return true;
    }
    case internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetContentSettingsForLegacyCookieAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetContentSettingsForLegacyCookieAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetContentSettingsForLegacyCookieAccess_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContentSettingsForLegacyCookieAccess(
std::move(p_settings));
      return true;
    }
    case internal::kCookieManager_SetStorageAccessGrantSettings_Name: {
      break;
    }
  }
  return false;
}

// static
bool CookieManagerStubDispatch::AcceptWithResponder(
    CookieManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieManager_GetAllCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::GetAllCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::GetAllCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_GetAllCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetAllCookies_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieManager_GetAllCookies_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 0, false);
        return false;
      }
      CookieManager::GetAllCookiesCallback callback =
          CookieManager_GetAllCookies_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookies(std::move(callback));
      return true;
    }
    case internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemantics",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemantics");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieManager_GetAllCookiesWithAccessSemantics_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 1, false);
        return false;
      }
      CookieManager::GetAllCookiesWithAccessSemanticsCallback callback =
          CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookiesWithAccessSemantics(std::move(callback));
      return true;
    }
    case internal::kCookieManager_GetCookieList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::GetCookieList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::GetCookieList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_GetCookieList_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetCookieList_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      CookieOptionsPtr p_cookie_options{};
      CookieManager_GetCookieList_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadCookieOptions(&p_cookie_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 2, false);
        return false;
      }
      CookieManager::GetCookieListCallback callback =
          CookieManager_GetCookieList_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookieList(
std::move(p_url), 
std::move(p_cookie_options), std::move(callback));
      return true;
    }
    case internal::kCookieManager_SetCanonicalCookie_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetCanonicalCookie",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetCanonicalCookie");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_SetCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_SetCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::CanonicalCookie p_cookie{};
      ::blink::KURL p_source_url{};
      CookieOptionsPtr p_cookie_options{};
      CookieManager_SetCanonicalCookie_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (success && !input_data_view.ReadCookieOptions(&p_cookie_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 3, false);
        return false;
      }
      CookieManager::SetCanonicalCookieCallback callback =
          CookieManager_SetCanonicalCookie_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanonicalCookie(
std::move(p_cookie), 
std::move(p_source_url), 
std::move(p_cookie_options), std::move(callback));
      return true;
    }
    case internal::kCookieManager_DeleteCanonicalCookie_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::DeleteCanonicalCookie",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::DeleteCanonicalCookie");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_DeleteCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::CanonicalCookie p_cookie{};
      CookieManager_DeleteCanonicalCookie_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 4, false);
        return false;
      }
      CookieManager::DeleteCanonicalCookieCallback callback =
          CookieManager_DeleteCanonicalCookie_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCanonicalCookie(
std::move(p_cookie), std::move(callback));
      return true;
    }
    case internal::kCookieManager_DeleteCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::DeleteCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::DeleteCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_DeleteCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteCookies_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieDeletionFilterPtr p_filter{};
      CookieManager_DeleteCookies_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 5, false);
        return false;
      }
      CookieManager::DeleteCookiesCallback callback =
          CookieManager_DeleteCookies_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCookies(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kCookieManager_AddCookieChangeListener_Name: {
      break;
    }
    case internal::kCookieManager_AddGlobalChangeListener_Name: {
      break;
    }
    case internal::kCookieManager_CloneInterface_Name: {
      break;
    }
    case internal::kCookieManager_FlushCookieStore_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::FlushCookieStore",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::FlushCookieStore");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_FlushCookieStore_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_FlushCookieStore_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieManager_FlushCookieStore_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 9, false);
        return false;
      }
      CookieManager::FlushCookieStoreCallback callback =
          CookieManager_FlushCookieStore_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushCookieStore(std::move(callback));
      return true;
    }
    case internal::kCookieManager_AllowFileSchemeCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::AllowFileSchemeCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::AllowFileSchemeCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_AllowFileSchemeCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_AllowFileSchemeCookies_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_allow{};
      CookieManager_AllowFileSchemeCookies_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_allow = input_data_view.allow();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 10, false);
        return false;
      }
      CookieManager::AllowFileSchemeCookiesCallback callback =
          CookieManager_AllowFileSchemeCookies_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowFileSchemeCookies(
std::move(p_allow), std::move(callback));
      return true;
    }
    case internal::kCookieManager_SetContentSettings_Name: {
      break;
    }
    case internal::kCookieManager_SetRemoteFilter_Name: {
      break;
    }
    case internal::kCookieManager_SetForceKeepSessionState_Name: {
      break;
    }
    case internal::kCookieManager_BlockThirdPartyCookies_Name: {
      break;
    }
    case internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name: {
      break;
    }
    case internal::kCookieManager_SetStorageAccessGrantSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_SetStorageAccessGrantSettings_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_SetStorageAccessGrantSettings_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetStorageAccessGrantSettings_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 16, false);
        return false;
      }
      CookieManager::SetStorageAccessGrantSettingsCallback callback =
          CookieManager_SetStorageAccessGrantSettings_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetStorageAccessGrantSettings(
std::move(p_settings), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieManagerValidationInfo[] = {
    {internal::kCookieManager_GetAllCookies_Name,
     {&internal::CookieManager_GetAllCookies_Params_Data::Validate,
      &internal::CookieManager_GetAllCookies_ResponseParams_Data::Validate}},
    {internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name,
     {&internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data::Validate,
      &internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data::Validate}},
    {internal::kCookieManager_GetCookieList_Name,
     {&internal::CookieManager_GetCookieList_Params_Data::Validate,
      &internal::CookieManager_GetCookieList_ResponseParams_Data::Validate}},
    {internal::kCookieManager_SetCanonicalCookie_Name,
     {&internal::CookieManager_SetCanonicalCookie_Params_Data::Validate,
      &internal::CookieManager_SetCanonicalCookie_ResponseParams_Data::Validate}},
    {internal::kCookieManager_DeleteCanonicalCookie_Name,
     {&internal::CookieManager_DeleteCanonicalCookie_Params_Data::Validate,
      &internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data::Validate}},
    {internal::kCookieManager_DeleteCookies_Name,
     {&internal::CookieManager_DeleteCookies_Params_Data::Validate,
      &internal::CookieManager_DeleteCookies_ResponseParams_Data::Validate}},
    {internal::kCookieManager_AddCookieChangeListener_Name,
     {&internal::CookieManager_AddCookieChangeListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_AddGlobalChangeListener_Name,
     {&internal::CookieManager_AddGlobalChangeListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_CloneInterface_Name,
     {&internal::CookieManager_CloneInterface_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_FlushCookieStore_Name,
     {&internal::CookieManager_FlushCookieStore_Params_Data::Validate,
      &internal::CookieManager_FlushCookieStore_ResponseParams_Data::Validate}},
    {internal::kCookieManager_AllowFileSchemeCookies_Name,
     {&internal::CookieManager_AllowFileSchemeCookies_Params_Data::Validate,
      &internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data::Validate}},
    {internal::kCookieManager_SetContentSettings_Name,
     {&internal::CookieManager_SetContentSettings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetRemoteFilter_Name,
     {&internal::CookieManager_SetRemoteFilter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetForceKeepSessionState_Name,
     {&internal::CookieManager_SetForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_BlockThirdPartyCookies_Name,
     {&internal::CookieManager_BlockThirdPartyCookies_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name,
     {&internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetStorageAccessGrantSettings_Name,
     {&internal::CookieManager_SetStorageAccessGrantSettings_Params_Data::Validate,
      &internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data::Validate}},
};

bool CookieManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieManagerValidationInfo);
}

bool CookieManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCookieManagerValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CookieManagerParams::DataView, ::network::mojom::blink::CookieManagerParamsPtr>::Read(
    ::network::mojom::blink::CookieManagerParams::DataView input,
    ::network::mojom::blink::CookieManagerParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieManagerParamsPtr result(::network::mojom::blink::CookieManagerParams::New());
  
      if (success)
        result->block_third_party_cookies = input.block_third_party_cookies();
      if (success && !input.ReadSettings(&result->settings))
        success = false;
      if (success && !input.ReadSecureOriginCookiesAllowedSchemes(&result->secure_origin_cookies_allowed_schemes))
        success = false;
      if (success && !input.ReadMatchingSchemeCookiesAllowedSchemes(&result->matching_scheme_cookies_allowed_schemes))
        success = false;
      if (success && !input.ReadThirdPartyCookiesAllowedSchemes(&result->third_party_cookies_allowed_schemes))
        success = false;
      if (success)
        result->allow_file_scheme_cookies = input.allow_file_scheme_cookies();
      if (success && !input.ReadSettingsForLegacyCookieAccess(&result->settings_for_legacy_cookie_access))
        success = false;
      if (success && !input.ReadSettingsForStorageAccess(&result->settings_for_storage_access))
        success = false;
      if (success && !input.ReadCookieAccessDelegateType(&result->cookie_access_delegate_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieSameSiteContext::DataView, ::network::mojom::blink::CookieSameSiteContextPtr>::Read(
    ::network::mojom::blink::CookieSameSiteContext::DataView input,
    ::network::mojom::blink::CookieSameSiteContextPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieSameSiteContextPtr result(::network::mojom::blink::CookieSameSiteContext::New());
  
      if (success && !input.ReadContext(&result->context))
        success = false;
      if (success && !input.ReadSchemefulContext(&result->schemeful_context))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieOptions::DataView, ::network::mojom::blink::CookieOptionsPtr>::Read(
    ::network::mojom::blink::CookieOptions::DataView input,
    ::network::mojom::blink::CookieOptionsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieOptionsPtr result(::network::mojom::blink::CookieOptions::New());
  
      if (success)
        result->exclude_httponly = input.exclude_httponly();
      if (success && !input.ReadSameSiteCookieContext(&result->same_site_cookie_context))
        success = false;
      if (success)
        result->update_access_time = input.update_access_time();
      if (success)
        result->return_excluded_cookies = input.return_excluded_cookies();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CanonicalCookie::DataView, ::network::mojom::blink::CanonicalCookiePtr>::Read(
    ::network::mojom::blink::CanonicalCookie::DataView input,
    ::network::mojom::blink::CanonicalCookiePtr* output) {
  bool success = true;
  ::network::mojom::blink::CanonicalCookiePtr result(::network::mojom::blink::CanonicalCookie::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadCreation(&result->creation))
        success = false;
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success && !input.ReadLastAccess(&result->last_access))
        success = false;
      if (success)
        result->secure = input.secure();
      if (success)
        result->httponly = input.httponly();
      if (success && !input.ReadSiteRestrictions(&result->site_restrictions))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadSourceScheme(&result->source_scheme))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieInclusionStatus::DataView, ::network::mojom::blink::CookieInclusionStatusPtr>::Read(
    ::network::mojom::blink::CookieInclusionStatus::DataView input,
    ::network::mojom::blink::CookieInclusionStatusPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieInclusionStatusPtr result(::network::mojom::blink::CookieInclusionStatus::New());
  
      if (success)
        result->exclusion_reasons = input.exclusion_reasons();
      if (success)
        result->warning_reasons = input.warning_reasons();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieAndLineWithAccessResult::DataView, ::network::mojom::blink::CookieAndLineWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieAndLineWithAccessResult::DataView input,
    ::network::mojom::blink::CookieAndLineWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAndLineWithAccessResultPtr result(::network::mojom::blink::CookieAndLineWithAccessResult::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadCookieString(&result->cookie_string))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieAccessResult::DataView, ::network::mojom::blink::CookieAccessResultPtr>::Read(
    ::network::mojom::blink::CookieAccessResult::DataView input,
    ::network::mojom::blink::CookieAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAccessResultPtr result(::network::mojom::blink::CookieAccessResult::New());
  
      if (success && !input.ReadEffectiveSameSite(&result->effective_same_site))
        success = false;
      if (success && !input.ReadAccessSemantics(&result->access_semantics))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieWithAccessResult::DataView, ::network::mojom::blink::CookieWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieWithAccessResult::DataView input,
    ::network::mojom::blink::CookieWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieWithAccessResultPtr result(::network::mojom::blink::CookieWithAccessResult::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieChangeInfo::DataView, ::network::mojom::blink::CookieChangeInfoPtr>::Read(
    ::network::mojom::blink::CookieChangeInfo::DataView input,
    ::network::mojom::blink::CookieChangeInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieChangeInfoPtr result(::network::mojom::blink::CookieChangeInfo::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
      if (success && !input.ReadCause(&result->cause))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieDeletionFilter::DataView, ::network::mojom::blink::CookieDeletionFilterPtr>::Read(
    ::network::mojom::blink::CookieDeletionFilter::DataView input,
    ::network::mojom::blink::CookieDeletionFilterPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieDeletionFilterPtr result(::network::mojom::blink::CookieDeletionFilter::New());
  
      if (success && !input.ReadCreatedAfterTime(&result->created_after_time))
        success = false;
      if (success && !input.ReadCreatedBeforeTime(&result->created_before_time))
        success = false;
      if (success && !input.ReadExcludingDomains(&result->excluding_domains))
        success = false;
      if (success && !input.ReadIncludingDomains(&result->including_domains))
        success = false;
      if (success && !input.ReadCookieName(&result->cookie_name))
        success = false;
      if (success && !input.ReadHostName(&result->host_name))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSessionControl(&result->session_control))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif