/* baobab-window.c generated by valac 0.56.0, the Vala compiler
 * generated from baobab-window.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <gtk/gtk.h>
#include <adwaita.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"

enum  {
	BAOBAB_WINDOW_0_PROPERTY,
	BAOBAB_WINDOW_NUM_PROPERTIES
};
static GParamSpec* baobab_window_properties[BAOBAB_WINDOW_NUM_PROPERTIES];
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block9Data Block9Data;

struct _BaobabWindowPrivate {
	GtkEventControllerFocus* focus_controller;
	GtkDropTarget* drop_target;
	GtkGestureClick* back_gesture;
	GtkBox* vbox;
	AdwHeaderBar* header_bar;
	BaobabPathbar* pathbar;
	GtkButton* back_button;
	GtkButton* reload_button;
	GtkMenuButton* menu_button;
	GtkStack* main_stack;
	GtkWidget* home_page;
	GtkWidget* result_page;
	GtkInfoBar* infobar;
	GtkLabel* infobar_primary_label;
	GtkLabel* infobar_secondary_label;
	GtkButton* infobar_close_button;
	BaobabLocationList* location_list;
	BaobabFolderDisplay* folder_display;
	GtkTreeView* treeview;
	GtkPopoverMenu* treeview_popover_menu;
	GtkTreeViewColumn* size_column;
	GtkTreeViewColumn* contents_column;
	GtkTreeViewColumn* time_modified_column;
	GtkGestureClick* treeview_right_click_gesture;
	GtkStack* chart_stack;
	GtkStack* spinner_stack;
	GtkStackSwitcher* chart_stack_switcher;
	BaobabChart* rings_chart;
	BaobabChart* treemap_chart;
	GtkSpinner* spinner;
	BaobabLocation* active_location;
	gboolean is_busy;
	gulong scan_completed_handler;
	guint scanning_progress_id;
};

struct _Block6Data {
	int _ref_count_;
	BaobabWindow* self;
	GSettings* ui_settings;
};

struct _Block7Data {
	int _ref_count_;
	BaobabWindow* self;
	GtkFileChooserNative* file_chooser;
};

struct _Block8Data {
	int _ref_count_;
	BaobabWindow* self;
	BaobabLocation* location;
};

struct _Block9Data {
	int _ref_count_;
	BaobabWindow* self;
	BaobabLocation* location;
};

static gint BaobabWindow_private_offset;
static gpointer baobab_window_parent_class = NULL;
static GdkCursor* baobab_window_busy_cursor;
static GdkCursor* baobab_window_busy_cursor = NULL;

static void baobab_window_on_show_primary_menu_activate (BaobabWindow* self,
                                                  GSimpleAction* action);
static void _baobab_window_on_show_primary_menu_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void baobab_window_on_show_home_page_activate (BaobabWindow* self);
static void _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void baobab_window_on_scan_folder_activate (BaobabWindow* self);
static void _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void baobab_window_on_reload_activate (BaobabWindow* self);
static void _baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void baobab_window_on_clear_recent (BaobabWindow* self);
static void _baobab_window_on_clear_recent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void baobab_window_on_show_preferences (BaobabWindow* self);
static void _baobab_window_on_show_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void baobab_window_on_help_activate (BaobabWindow* self);
static void _baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void baobab_window_on_about_activate (BaobabWindow* self);
static void _baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void baobab_window_on_show_treeview_popover (BaobabWindow* self);
static void _baobab_window_on_show_treeview_popover_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void baobab_window_on_treeview_expand_row (BaobabWindow* self);
static void _baobab_window_on_treeview_expand_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void baobab_window_on_treeview_collapse_row (BaobabWindow* self);
static void _baobab_window_on_treeview_collapse_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void baobab_window_go_up_treeview (BaobabWindow* self);
static void _baobab_window_go_up_treeview_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void baobab_window_on_treeview_open_folder (BaobabWindow* self);
static void _baobab_window_on_treeview_open_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void baobab_window_on_treeview_copy (BaobabWindow* self);
static void _baobab_window_on_treeview_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void baobab_window_on_treeview_trash (BaobabWindow* self);
static void _baobab_window_on_treeview_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void baobab_window_location_activated (BaobabWindow* self,
                                       BaobabLocation* location);
static void _baobab_window_location_activated_baobab_location_list_location_activated (BaobabLocationList* _sender,
                                                                                BaobabLocation* location,
                                                                                gpointer self);
static void baobab_window_setup_treeview (BaobabWindow* self);
static void __lambda25_ (BaobabWindow* self);
static void baobab_window_clear_message (BaobabWindow* self);
static void ___lambda25__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda26_ (BaobabWindow* self);
static void ___lambda26__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void baobab_window_on_chart_item_activated (BaobabWindow* self,
                                            BaobabChart* chart,
                                            GtkTreeIter* iter);
static void _baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender,
                                                                         GtkTreeIter* iter,
                                                                         gpointer self);
static void baobab_window_on_pathbar_item_activated (BaobabWindow* self,
                                              BaobabPathbar* pathbar,
                                              GtkTreePath* path);
static void _baobab_window_on_pathbar_item_activated_baobab_pathbar_item_activated (BaobabPathbar* _sender,
                                                                             GtkTreePath* path,
                                                                             gpointer self);
static void baobab_window_on_folder_display_activated (BaobabWindow* self);
static void _baobab_window_on_folder_display_activated_baobab_folder_display_activated (BaobabFolderDisplay* _sender,
                                                                                 gpointer self);
static gboolean baobab_window_on_drop (BaobabWindow* self,
                                GtkDropTarget* target,
                                GValue* value,
                                gdouble x,
                                gdouble y);
static gboolean _baobab_window_on_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                      GValue* value,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static gboolean baobab_window_on_drop_target_accept (BaobabWindow* self,
                                              GtkDropTarget* target,
                                              GdkDrop* drop);
static gboolean _baobab_window_on_drop_target_accept_gtk_drop_target_accept (GtkDropTarget* _sender,
                                                                      GdkDrop* drop,
                                                                      gpointer self);
static gboolean __lambda27_ (Block6Data* _data6_);
static gboolean ___lambda27__gtk_window_close_request (GtkWindow* _sender,
                                                gpointer self);
static void baobab_window_set_ui_state (BaobabWindow* self,
                                 GtkWidget* child,
                                 gboolean busy);
static void __lambda28_ (BaobabWindow* self,
                  gint n_press,
                  gdouble x,
                  gdouble y);
static void ___lambda28__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                             gint n_press,
                                             gdouble x,
                                             gdouble y,
                                             gpointer self);
static void __lambda29_ (BaobabWindow* self);
static void ___lambda29__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                    gpointer self);
static void baobab_window_cancel_scan (BaobabWindow* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda16_ (Block7Data* _data7_,
                  gint response);
static void ___lambda16__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void baobab_window_set_busy (BaobabWindow* self,
                             gboolean busy);
static void __lambda22_ (Block8Data* _data8_,
                  GObject* location_,
                  GAsyncResult* res);
static void baobab_window_scan_location (BaobabWindow* self,
                                  BaobabLocation* location,
                                  gboolean force);
static void baobab_window_message (BaobabWindow* self,
                            const gchar* primary_msg,
                            const gchar* secondary_msg,
                            GtkMessageType type);
static void ___lambda22__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void baobab_window_reroot_treeview (BaobabWindow* self,
                                    GtkTreePath* path,
                                    gboolean select_first);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static GtkTreePath* baobab_window_convert_child_path_to_path (BaobabWindow* self,
                                                       GtkTreePath* path);
static gboolean baobab_window_show_treeview_popover (BaobabWindow* self,
                                              GtkPopoverMenu* popover,
                                              gint x,
                                              gint y);
static gboolean baobab_window_get_selected_iter (BaobabWindow* self,
                                          GtkTreeIter* iter);
static void baobab_window_convert_iter_to_child_iter (BaobabWindow* self,
                                               GtkTreeIter* child_iter,
                                               GtkTreeIter* iter);
static GtkTreePath* baobab_window_convert_path_to_child_path (BaobabWindow* self,
                                                       GtkTreePath* path);
static void __lambda23_ (BaobabWindow* self,
                  gint n_press,
                  gdouble x,
                  gdouble y);
static void ___lambda23__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                             gint n_press,
                                             gdouble x,
                                             gdouble y,
                                             gpointer self);
static void __lambda24_ (BaobabWindow* self,
                  GtkTreePath* wrapper_path,
                  GtkTreeViewColumn* column);
static void ___lambda24__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static void baobab_window_reset_treeview_sorting (BaobabWindow* self);
static void _baobab_window_reset_treeview_sorting_gtk_tree_sortable_sort_column_changed (GtkTreeSortable* _sender,
                                                                                  gpointer self);
static void baobab_window_copy_treeview_column_sizes (BaobabWindow* self);
static void _baobab_window_copy_treeview_column_sizes_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void baobab_window_set_chart_location (BaobabWindow* self,
                                       BaobabLocation* location);
static void baobab_window_scanner_completed (BaobabWindow* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void _baobab_window_scanner_completed_baobab_scanner_completed (BaobabScanner* _sender,
                                                                gpointer self);
static gboolean __lambda17_ (Block9Data* _data9_);
static gboolean ___lambda17__gsource_func (gpointer self);
static void baobab_window_finalize (GObject * obj);
static GType baobab_window_get_type_once (void);

static const GActionEntry BAOBAB_WINDOW_action_entries[15] = {{"show-primary-menu", _baobab_window_on_show_primary_menu_activate_gsimple_action_activate_callback, NULL, "false", NULL}, {"show-home-page", _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback}, {"scan-folder", _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback}, {"reload", _baobab_window_on_reload_activate_gsimple_action_activate_callback}, {"clear-recent", _baobab_window_on_clear_recent_gsimple_action_activate_callback}, {"show-preferences", _baobab_window_on_show_preferences_gsimple_action_activate_callback}, {"help", _baobab_window_on_help_activate_gsimple_action_activate_callback}, {"about", _baobab_window_on_about_activate_gsimple_action_activate_callback}, {"show-treeview-popover", _baobab_window_on_show_treeview_popover_gsimple_action_activate_callback}, {"treeview-expand-row", _baobab_window_on_treeview_expand_row_gsimple_action_activate_callback}, {"treeview-collapse-row", _baobab_window_on_treeview_collapse_row_gsimple_action_activate_callback}, {"treeview-go-up", _baobab_window_go_up_treeview_gsimple_action_activate_callback}, {"treeview-open-folder", _baobab_window_on_treeview_open_folder_gsimple_action_activate_callback}, {"treeview-copy", _baobab_window_on_treeview_copy_gsimple_action_activate_callback}, {"treeview-trash", _baobab_window_on_treeview_trash_gsimple_action_activate_callback}};
static const BaobabWindowActionState BAOBAB_WINDOW_actions_while_scanning[1] = {{"scan-folder", FALSE}};

static inline gpointer
baobab_window_get_instance_private (BaobabWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabWindow_private_offset);
}

static void
_baobab_window_on_show_primary_menu_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	baobab_window_on_show_primary_menu_activate ((BaobabWindow*) self, action);
}

static void
_baobab_window_on_show_home_page_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	baobab_window_on_show_home_page_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	baobab_window_on_scan_folder_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	baobab_window_on_reload_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_clear_recent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	baobab_window_on_clear_recent ((BaobabWindow*) self);
}

static void
_baobab_window_on_show_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	baobab_window_on_show_preferences ((BaobabWindow*) self);
}

static void
_baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	baobab_window_on_help_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	baobab_window_on_about_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_show_treeview_popover_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	baobab_window_on_show_treeview_popover ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_expand_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	baobab_window_on_treeview_expand_row ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_collapse_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	baobab_window_on_treeview_collapse_row ((BaobabWindow*) self);
}

static void
_baobab_window_go_up_treeview_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	baobab_window_go_up_treeview ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_open_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	baobab_window_on_treeview_open_folder ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	baobab_window_on_treeview_copy ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	baobab_window_on_treeview_trash ((BaobabWindow*) self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BaobabWindow* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->ui_settings);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_baobab_window_location_activated_baobab_location_list_location_activated (BaobabLocationList* _sender,
                                                                           BaobabLocation* location,
                                                                           gpointer self)
{
	baobab_window_location_activated ((BaobabWindow*) self, location);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda25_ (BaobabWindow* self)
{
	baobab_window_clear_message (self);
}

static void
___lambda25__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda25_ ((BaobabWindow*) self);
}

static void
__lambda26_ (BaobabWindow* self)
{
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->chart_stack;
	g_settings_unbind ((GObject*) _tmp0_, "visible-child-name");
}

static void
___lambda26__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda26_ ((BaobabWindow*) self);
}

static void
_baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self)
{
	baobab_window_on_chart_item_activated ((BaobabWindow*) self, _sender, iter);
}

static void
_baobab_window_on_pathbar_item_activated_baobab_pathbar_item_activated (BaobabPathbar* _sender,
                                                                        GtkTreePath* path,
                                                                        gpointer self)
{
	baobab_window_on_pathbar_item_activated ((BaobabWindow*) self, _sender, path);
}

static void
_baobab_window_on_folder_display_activated_baobab_folder_display_activated (BaobabFolderDisplay* _sender,
                                                                            gpointer self)
{
	baobab_window_on_folder_display_activated ((BaobabWindow*) self);
}

static gboolean
_baobab_window_on_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                             GValue* value,
                                             gdouble x,
                                             gdouble y,
                                             gpointer self)
{
	gboolean result;
	result = baobab_window_on_drop ((BaobabWindow*) self, _sender, value, x, y);
	return result;
}

static gboolean
_baobab_window_on_drop_target_accept_gtk_drop_target_accept (GtkDropTarget* _sender,
                                                             GdkDrop* drop,
                                                             gpointer self)
{
	gboolean result;
	result = baobab_window_on_drop_target_accept ((BaobabWindow*) self, _sender, drop);
	return result;
}

static gboolean
__lambda27_ (Block6Data* _data6_)
{
	BaobabWindow* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GSettings* _tmp5_;
	gboolean result;
	self = _data6_->self;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gint win_width = 0;
		gint win_height = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GSettings* _tmp4_;
		gtk_window_get_default_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		win_width = _tmp2_;
		win_height = _tmp3_;
		_tmp4_ = _data6_->ui_settings;
		g_settings_set (_tmp4_, "window-size", "(ii)", win_width, win_height);
	}
	_tmp5_ = _data6_->ui_settings;
	g_settings_apply (_tmp5_);
	result = FALSE;
	return result;
}

static gboolean
___lambda27__gtk_window_close_request (GtkWindow* _sender,
                                       gpointer self)
{
	gboolean result;
	result = __lambda27_ (self);
	return result;
}

static void
__lambda28_ (BaobabWindow* self,
             gint n_press,
             gdouble x,
             gdouble y)
{
	GAction* _tmp0_;
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "show-home-page");
	g_action_activate (_tmp0_, NULL);
}

static void
___lambda28__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                        gint n_press,
                                        gdouble x,
                                        gdouble y,
                                        gpointer self)
{
	__lambda28_ ((BaobabWindow*) self, n_press, x, y);
}

static void
__lambda29_ (BaobabWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_withdraw_notification ((GApplication*) _tmp1_, "scan-completed");
}

static void
___lambda29__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                               gpointer self)
{
	__lambda29_ ((BaobabWindow*) self);
}

BaobabWindow*
baobab_window_construct (GType object_type,
                         BaobabApplication* app)
{
	BaobabWindow * self = NULL;
	Block6Data* _data6_;
	GdkCursor* _tmp0_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GAction* action = NULL;
	GSettings* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	BaobabLocationList* _tmp7_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp8_;
	GMenuModel* treeview_menu = NULL;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GMenuModel* _tmp11_;
	GtkPopoverMenu* _tmp12_;
	GMenuModel* _tmp13_;
	GtkButton* _tmp14_;
	GSettings* _tmp15_;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	BaobabChart* _tmp18_;
	BaobabChart* _tmp19_;
	BaobabPathbar* _tmp20_;
	BaobabFolderDisplay* _tmp21_;
	GtkDropTarget* _tmp22_;
	GType* _tmp23_;
	GType* _tmp24_;
	gint _tmp24__length1;
	GtkDropTarget* _tmp25_;
	GtkDropTarget* _tmp26_;
	GSettings* _tmp27_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp28_;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GSettings* _tmp31_;
	GtkWidget* _tmp32_;
	GtkGestureClick* _tmp33_;
	GtkEventControllerFocus* _tmp34_;
	g_return_val_if_fail (app != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	self = (BaobabWindow*) g_object_new (object_type, "application", app, NULL);
	_data6_->self = g_object_ref (self);
	_tmp0_ = baobab_window_busy_cursor;
	if (_tmp0_ == NULL) {
		GdkCursor* _tmp1_;
		_tmp1_ = gdk_cursor_new_from_name ("wait", NULL);
		_g_object_unref0 (baobab_window_busy_cursor);
		baobab_window_busy_cursor = _tmp1_;
	}
	_tmp2_ = g_settings_new ("org.gnome.baobab.ui");
	_data6_->ui_settings = _tmp2_;
	_tmp3_ = _data6_->ui_settings;
	g_settings_delay (_tmp3_);
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_WINDOW_action_entries, (gint) G_N_ELEMENTS (BAOBAB_WINDOW_action_entries), self);
	_tmp4_ = _data6_->ui_settings;
	_tmp5_ = g_settings_create_action (_tmp4_, "active-chart");
	action = _tmp5_;
	_tmp6_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp6_);
	_tmp7_ = self->priv->location_list;
	g_signal_connect_object (_tmp7_, "location-activated", (GCallback) _baobab_window_location_activated_baobab_location_list_location_activated, self, 0);
	_tmp8_ = gtk_builder_new_from_resource ("/org/gnome/baobab/ui/baobab-treeview-menu.ui");
	builder = _tmp8_;
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "treeview_menu");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_menu_model_get_type (), GMenuModel));
	treeview_menu = _tmp11_;
	baobab_window_setup_treeview (self);
	_tmp12_ = self->priv->treeview_popover_menu;
	_tmp13_ = treeview_menu;
	gtk_popover_menu_set_menu_model (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->infobar_close_button;
	g_signal_connect_object (_tmp14_, "clicked", (GCallback) ___lambda25__gtk_button_clicked, self, 0);
	_tmp15_ = _data6_->ui_settings;
	_tmp16_ = self->priv->chart_stack;
	g_settings_bind (_tmp15_, "active-chart", (GObject*) _tmp16_, "visible-child-name", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = self->priv->chart_stack;
	g_signal_connect_object ((GtkWidget*) _tmp17_, "destroy", (GCallback) ___lambda26__gtk_widget_destroy, self, 0);
	_tmp18_ = self->priv->rings_chart;
	g_signal_connect_object (_tmp18_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	_tmp19_ = self->priv->treemap_chart;
	g_signal_connect_object (_tmp19_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	_tmp20_ = self->priv->pathbar;
	g_signal_connect_object (_tmp20_, "item-activated", (GCallback) _baobab_window_on_pathbar_item_activated_baobab_pathbar_item_activated, self, 0);
	_tmp21_ = self->priv->folder_display;
	g_signal_connect_object (_tmp21_, "activated", (GCallback) _baobab_window_on_folder_display_activated_baobab_folder_display_activated, self, 0);
	_tmp22_ = self->priv->drop_target;
	_tmp23_ = g_new0 (GType, 1);
	_tmp23_[0] = gdk_file_list_get_type ();
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	gtk_drop_target_set_gtypes (_tmp22_, _tmp24_, (gsize) 1);
	_tmp24_ = (g_free (_tmp24_), NULL);
	_tmp25_ = self->priv->drop_target;
	g_signal_connect_object (_tmp25_, "drop", (GCallback) _baobab_window_on_drop_gtk_drop_target_drop, self, 0);
	_tmp26_ = self->priv->drop_target;
	g_signal_connect_object (_tmp26_, "accept", (GCallback) _baobab_window_on_drop_target_accept_gtk_drop_target_accept, self, 0);
	_tmp27_ = _data6_->ui_settings;
	if (g_settings_get_boolean (_tmp27_, "is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp28_ = _data6_->ui_settings;
	g_settings_get (_tmp28_, "window-size", "(ii)", &_tmp29_, &_tmp30_);
	width = _tmp29_;
	height = _tmp30_;
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
	_tmp31_ = _data6_->ui_settings;
	g_settings_bind (_tmp31_, "is-maximized", (GObject*) self, "maximized", G_SETTINGS_BIND_SET);
	g_signal_connect_data ((GtkWindow*) self, "close-request", (GCallback) ___lambda27__gtk_window_close_request, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp32_ = self->priv->home_page;
	baobab_window_set_ui_state (self, _tmp32_, FALSE);
	_tmp33_ = self->priv->back_gesture;
	g_signal_connect_object (_tmp33_, "pressed", (GCallback) ___lambda28__gtk_gesture_click_pressed, self, 0);
	_tmp34_ = self->priv->focus_controller;
	g_signal_connect_object (_tmp34_, "enter", (GCallback) ___lambda29__gtk_event_controller_focus_enter, self, 0);
	gtk_window_present ((GtkWindow*) self);
	_g_object_unref0 (treeview_menu);
	_g_object_unref0 (builder);
	_g_object_unref0 (action);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

BaobabWindow*
baobab_window_new (BaobabApplication* app)
{
	return baobab_window_construct (BAOBAB_TYPE_WINDOW, app);
}

static void
baobab_window_on_show_primary_menu_activate (BaobabWindow* self,
                                             GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	_g_variant_unref0 (_tmp1_);
	state = _tmp2_;
	_tmp3_ = g_variant_new_boolean (!state);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (action, _tmp4_);
	_g_variant_unref0 (_tmp4_);
}

static void
baobab_window_on_show_home_page_activate (BaobabWindow* self)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	baobab_window_cancel_scan (self);
	baobab_window_clear_message (self);
	_tmp0_ = self->priv->home_page;
	baobab_window_set_ui_state (self, _tmp0_, FALSE);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BaobabWindow* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->file_chooser);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
__lambda16_ (Block7Data* _data7_,
             gint response)
{
	BaobabWindow* self;
	self = _data7_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		gboolean recurse = FALSE;
		const gchar* _tmp0_;
		BaobabScanFlags _tmp1_ = 0U;
		BaobabScanFlags flags = 0U;
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp0_ = gtk_file_chooser_get_choice ((GtkFileChooser*) _data7_->file_chooser, "recurse");
		recurse = bool_parse (_tmp0_);
		if (recurse) {
			_tmp1_ = BAOBAB_SCAN_FLAGS_NONE;
		} else {
			_tmp1_ = BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS;
		}
		flags = _tmp1_;
		_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data7_->file_chooser);
		_tmp3_ = _tmp2_;
		baobab_window_scan_directory (self, _tmp3_, flags);
		_g_object_unref0 (_tmp3_);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data7_->file_chooser);
}

static void
___lambda16__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda16_ (self, response_id);
}

static void
baobab_window_on_scan_folder_activate (BaobabWindow* self)
{
	Block7Data* _data7_;
	GtkFileChooserNative* _tmp0_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = gtk_file_chooser_native_new (_ ("Select Folder"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, NULL, NULL);
	_data7_->file_chooser = _tmp0_;
	gtk_native_dialog_set_modal ((GtkNativeDialog*) _data7_->file_chooser, TRUE);
	gtk_file_chooser_add_choice ((GtkFileChooser*) _data7_->file_chooser, "recurse", _ ("Recursively analyze mount points"), NULL, NULL);
	g_signal_connect_data ((GtkNativeDialog*) _data7_->file_chooser, "response", (GCallback) ___lambda16__gtk_native_dialog_response, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data7_->file_chooser);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static gpointer
_baobab_location_ref0 (gpointer self)
{
	return self ? baobab_location_ref (self) : NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BaobabWindow* self;
		self = _data8_->self;
		_baobab_location_unref0 (_data8_->location);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda22_ (Block8Data* _data8_,
             GObject* location_,
             GAsyncResult* res)
{
	BaobabWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	{
		baobab_location_mount_volume_finish (_data8_->location, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		baobab_window_scan_location (self, _data8_->location, FALSE);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		baobab_window_set_busy (self, FALSE);
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		baobab_window_message (self, _ ("Could not analyze volume."), _tmp1_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda22__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda22_ (self, source_object, res);
	block8_data_unref (self);
}

static void
baobab_window_location_activated (BaobabWindow* self,
                                  BaobabLocation* location)
{
	Block8Data* _data8_;
	BaobabLocation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _baobab_location_ref0 (location);
	_baobab_location_unref0 (_data8_->location);
	_data8_->location = _tmp0_;
	baobab_window_set_busy (self, TRUE);
	baobab_location_mount_volume (_data8_->location, ___lambda22__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
baobab_window_on_reload_activate (BaobabWindow* self)
{
	BaobabLocation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_location;
	baobab_window_scan_location (self, _tmp0_, TRUE);
}

static void
baobab_window_cancel_scan (BaobabWindow* self)
{
	gboolean _tmp0_ = FALSE;
	BaobabLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->active_location;
	if (_tmp1_ != NULL) {
		BaobabLocation* _tmp2_;
		BaobabScanner* _tmp3_;
		BaobabScanner* _tmp4_;
		_tmp2_ = self->priv->active_location;
		_tmp3_ = baobab_location_get_scanner (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BaobabLocation* _tmp5_;
		BaobabScanner* _tmp6_;
		BaobabScanner* _tmp7_;
		_tmp5_ = self->priv->active_location;
		_tmp6_ = baobab_location_get_scanner (_tmp5_);
		_tmp7_ = _tmp6_;
		baobab_scanner_cancel (_tmp7_);
	}
	if (self->priv->scan_completed_handler > ((gulong) 0)) {
		BaobabLocation* _tmp8_;
		BaobabScanner* _tmp9_;
		BaobabScanner* _tmp10_;
		_tmp8_ = self->priv->active_location;
		_tmp9_ = baobab_location_get_scanner (_tmp8_);
		_tmp10_ = _tmp9_;
		g_signal_handler_disconnect ((GObject*) _tmp10_, self->priv->scan_completed_handler);
		self->priv->scan_completed_handler = (gulong) 0;
	}
	_baobab_location_unref0 (self->priv->active_location);
	self->priv->active_location = NULL;
}

static void
baobab_window_on_clear_recent (BaobabWindow* self)
{
	BaobabLocationList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->location_list;
	baobab_location_list_clear_recent (_tmp0_, TRUE);
}

static void
baobab_window_on_show_preferences (BaobabWindow* self)
{
	BaobabPreferencesDialog* dialog = NULL;
	BaobabPreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_preferences_dialog_new ();
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) self);
	gtk_window_present ((GtkWindow*) dialog);
	_g_object_unref0 (dialog);
}

static void
baobab_window_on_help_activate (BaobabWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_show_uri ((GtkWindow*) self, "help:baobab", (guint32) GDK_CURRENT_TIME);
}

static void
baobab_window_on_about_activate (BaobabWindow* self)
{
	static const gchar* authors[7] = {"Ryan Lortie <desrt@desrt.ca>", "Fabio Marzocca <thesaltydog@gmail.com>", "Paolo Borelli <pborelli@gnome.com>", "Stefano Facchini <stefano.facchini@gmail.com>", "Benoît Dejean <benoit@placenet.org>", "Igalia (rings-chart and treemap widget) <www.igalia.com>", NULL};
	static const char copyright[] = "Copyright \xc2\xa9 2005-2011 Fabio Marzocca, Paolo Borelli, Benoît Dej" \
"ean, Igalia\n" "Copyright \xc2\xa9 2011-2012 Ryan Lortie, Paolo Borelli, Stefano Facch" \
"ini\n";
	g_return_if_fail (self != NULL);
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", _ ("Disk Usage Analyzer"), "logo-icon-name", "org.gnome.baobab", "version", VERSION, "comments", _ ("A graphical tool to analyze disk usage."), "website", "https://wiki.gnome.org/action/show/Apps/DiskUsageAnalyzer", "copyright", copyright, "license-type", GTK_LICENSE_GPL_2_0, "wrap-license", FALSE, "authors", authors, "translator-credits", _ ("translator-credits"), NULL, NULL);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
baobab_window_on_chart_item_activated (BaobabWindow* self,
                                       BaobabChart* chart,
                                       GtkTreeIter* iter)
{
	GtkTreePath* path = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreePath* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chart != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	_tmp4_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp2_, &_tmp3_);
	path = _tmp4_;
	baobab_window_reroot_treeview (self, path, FALSE);
	__vala_GtkTreePath_free0 (path);
}

static void
baobab_window_on_pathbar_item_activated (BaobabWindow* self,
                                         BaobabPathbar* pathbar,
                                         GtkTreePath* path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (pathbar != NULL);
	g_return_if_fail (path != NULL);
	baobab_window_reroot_treeview (self, path, FALSE);
}

static void
baobab_window_on_folder_display_activated (BaobabWindow* self)
{
	g_return_if_fail (self != NULL);
	baobab_window_go_up_treeview (self);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
baobab_window_go_up_treeview (BaobabWindow* self)
{
	GtkTreePath* path = NULL;
	BaobabFolderDisplay* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkTreePath* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_display;
	_tmp1_ = baobab_folder_display_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_GtkTreePath_copy0 (_tmp2_);
	path = _tmp3_;
	_tmp5_ = path;
	if (_tmp5_ != NULL) {
		GtkTreePath* _tmp6_;
		_tmp6_ = path;
		_tmp4_ = gtk_tree_path_get_depth (_tmp6_) > 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkTreePath* cursor_path = NULL;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		GtkTreePath* _tmp11_;
		GtkTreePath* _tmp12_;
		GtkTreeView* _tmp13_;
		GtkTreePath* _tmp14_;
		_tmp7_ = path;
		_tmp8_ = gtk_tree_path_copy (_tmp7_);
		cursor_path = _tmp8_;
		_tmp9_ = path;
		gtk_tree_path_up (_tmp9_);
		_tmp10_ = path;
		baobab_window_reroot_treeview (self, _tmp10_, FALSE);
		_tmp11_ = cursor_path;
		_tmp12_ = baobab_window_convert_child_path_to_path (self, _tmp11_);
		__vala_GtkTreePath_free0 (cursor_path);
		cursor_path = _tmp12_;
		_tmp13_ = self->priv->treeview;
		_tmp14_ = cursor_path;
		gtk_tree_view_set_cursor (_tmp13_, _tmp14_, NULL, FALSE);
		__vala_GtkTreePath_free0 (cursor_path);
	}
	__vala_GtkTreePath_free0 (path);
}

static gboolean
baobab_window_on_drop_target_accept (BaobabWindow* self,
                                     GtkDropTarget* target,
                                     GdkDrop* drop)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	g_return_val_if_fail (drop != NULL, FALSE);
	result = !self->priv->is_busy;
	return result;
}

static gboolean
baobab_window_on_drop (BaobabWindow* self,
                       GtkDropTarget* target,
                       GValue* value,
                       gdouble x,
                       gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (G_VALUE_TYPE (value) == gdk_file_list_get_type ()) {
		GSList* files = NULL;
		void* _tmp0_;
		GFile* dir = NULL;
		gboolean _tmp1_ = FALSE;
		GSList* _tmp2_;
		GFile* _tmp8_;
		_tmp0_ = g_value_get_boxed (value);
		files = (GSList*) _tmp0_;
		dir = NULL;
		_tmp2_ = files;
		if (_tmp2_ != NULL) {
			GSList* _tmp3_;
			_tmp3_ = files;
			_tmp1_ = g_slist_length (_tmp3_) == ((guint) 1);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GSList* _tmp4_;
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GFile* _tmp7_;
			_tmp4_ = files;
			_tmp5_ = g_slist_nth (_tmp4_, (guint) 0);
			_tmp6_ = _tmp5_->data;
			_tmp7_ = _g_object_ref0 ((GFile*) _tmp6_);
			_g_object_unref0 (dir);
			dir = _tmp7_;
		}
		_tmp8_ = dir;
		if (_tmp8_ != NULL) {
			GFile* _tmp9_;
			_tmp9_ = dir;
			baobab_window_scan_directory (self, _tmp9_, BAOBAB_SCAN_FLAGS_NONE);
		}
		result = TRUE;
		_g_object_unref0 (dir);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
baobab_window_show_treeview_popover (BaobabWindow* self,
                                     GtkPopoverMenu* popover,
                                     gint x,
                                     gint y)
{
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (popover != NULL, FALSE);
	_tmp0_.x = x;
	_tmp0_.y = y;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	rect = _tmp0_;
	_tmp1_ = rect;
	gtk_popover_set_pointing_to ((GtkPopover*) popover, &_tmp1_);
	gtk_popover_popup ((GtkPopover*) popover);
	result = GDK_EVENT_STOP;
	return result;
}

void
baobab_window_open_item (BaobabWindow* self,
                         GtkTreeIter* iter)
{
	GFile* file = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GtkTreeIter _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	_tmp4_ = baobab_scanner_get_file (_tmp2_, &_tmp3_);
	file = _tmp4_;
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_file_get_uri (file);
		_tmp6_ = _tmp5_;
		g_app_info_launch_default_for_uri (_tmp6_, NULL, &_inner_error0_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		baobab_window_message (self, _ ("Failed to open file"), _tmp8_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

void
baobab_window_copy_path (BaobabWindow* self,
                         GtkTreeIter* iter)
{
	gchar* parse_name = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GtkTreeIter _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GdkClipboard* clipboard = NULL;
	GdkClipboard* _tmp8_;
	GdkClipboard* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	_tmp4_ = baobab_scanner_get_file (_tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_parse_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	parse_name = _tmp7_;
	_tmp8_ = gtk_widget_get_clipboard ((GtkWidget*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	clipboard = _tmp9_;
	gdk_clipboard_set_text (clipboard, parse_name);
	_g_object_unref0 (clipboard);
	_g_free0 (parse_name);
}

void
baobab_window_trash_file (BaobabWindow* self,
                          GtkTreeIter* iter)
{
	GFile* file = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GtkTreeIter _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	_tmp4_ = baobab_scanner_get_file (_tmp2_, &_tmp3_);
	file = _tmp4_;
	{
		BaobabLocation* _tmp5_;
		BaobabScanner* _tmp6_;
		BaobabScanner* _tmp7_;
		g_file_trash (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->priv->active_location;
		_tmp6_ = baobab_location_get_scanner (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_tree_store_remove ((GtkTreeStore*) _tmp7_, iter);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		baobab_window_message (self, _ ("Failed to move file to the trash"), _tmp9_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static gboolean
baobab_window_get_selected_iter (BaobabWindow* self,
                                 GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter wrapper_iter = {0};
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	gboolean _result_ = FALSE;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeIter _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp4_ = gtk_tree_selection_get_selected (selection, NULL, &_tmp3_);
	wrapper_iter = _tmp3_;
	_result_ = _tmp4_;
	_tmp5_ = wrapper_iter;
	baobab_window_convert_iter_to_child_iter (self, &_tmp6_, &_tmp5_);
	_vala_iter = _tmp6_;
	result = _result_;
	_g_object_unref0 (selection);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
baobab_window_convert_iter_to_child_iter (BaobabWindow* self,
                                          GtkTreeIter* child_iter,
                                          GtkTreeIter* iter)
{
	GtkTreeIter _vala_child_iter = {0};
	GtkTreeIter filter_iter = {0};
	GtkTreeModelSort* sort = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModelSort* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkTreeModelFilter* filter = NULL;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModelFilter* _tmp8_;
	GtkTreeIter _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_tree_model_sort_get_type (), GtkTreeModelSort));
	sort = _tmp3_;
	_tmp4_ = *iter;
	gtk_tree_model_sort_convert_iter_to_child_iter (sort, &_tmp5_, &_tmp4_);
	filter_iter = _tmp5_;
	_tmp6_ = gtk_tree_model_sort_get_model (sort);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_tree_model_filter_get_type (), GtkTreeModelFilter));
	filter = _tmp8_;
	_tmp9_ = filter_iter;
	gtk_tree_model_filter_convert_iter_to_child_iter (filter, &_tmp10_, &_tmp9_);
	_vala_child_iter = _tmp10_;
	_g_object_unref0 (filter);
	_g_object_unref0 (sort);
	if (child_iter) {
		*child_iter = _vala_child_iter;
	}
}

static GtkTreePath*
baobab_window_convert_path_to_child_path (BaobabWindow* self,
                                          GtkTreePath* path)
{
	GtkTreeModelSort* sort = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModelSort* _tmp3_;
	GtkTreePath* filter_path = NULL;
	GtkTreePath* _tmp4_;
	GtkTreeModelFilter* filter = NULL;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModelFilter* _tmp7_;
	GtkTreePath* _tmp8_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_tree_model_sort_get_type (), GtkTreeModelSort));
	sort = _tmp3_;
	_tmp4_ = gtk_tree_model_sort_convert_path_to_child_path (sort, path);
	filter_path = _tmp4_;
	_tmp5_ = gtk_tree_model_sort_get_model (sort);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_filter_get_type (), GtkTreeModelFilter));
	filter = _tmp7_;
	_tmp8_ = gtk_tree_model_filter_convert_path_to_child_path (filter, filter_path);
	result = _tmp8_;
	_g_object_unref0 (filter);
	__vala_GtkTreePath_free0 (filter_path);
	_g_object_unref0 (sort);
	return result;
}

static GtkTreePath*
baobab_window_convert_child_path_to_path (BaobabWindow* self,
                                          GtkTreePath* path)
{
	GtkTreeModelSort* sort = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModelSort* _tmp3_;
	GtkTreeModelFilter* filter = NULL;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModelFilter* _tmp6_;
	GtkTreePath* filter_path = NULL;
	GtkTreePath* _tmp7_;
	GtkTreePath* _tmp8_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_tree_model_sort_get_type (), GtkTreeModelSort));
	sort = _tmp3_;
	_tmp4_ = gtk_tree_model_sort_get_model (sort);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tree_model_filter_get_type (), GtkTreeModelFilter));
	filter = _tmp6_;
	_tmp7_ = gtk_tree_model_filter_convert_child_path_to_path (filter, path);
	filter_path = _tmp7_;
	_tmp8_ = gtk_tree_model_sort_convert_child_path_to_path (sort, filter_path);
	result = _tmp8_;
	__vala_GtkTreePath_free0 (filter_path);
	_g_object_unref0 (filter);
	_g_object_unref0 (sort);
	return result;
}

static void
baobab_window_on_show_treeview_popover (BaobabWindow* self)
{
	GtkPopoverMenu* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview_popover_menu;
	_tmp1_ = self->priv->treeview;
	_tmp2_ = self->priv->treeview;
	baobab_window_show_treeview_popover (self, _tmp0_, gtk_widget_get_allocated_width ((GtkWidget*) _tmp1_) / 2, gtk_widget_get_allocated_height ((GtkWidget*) _tmp2_) / 2);
}

static void
baobab_window_on_treeview_expand_row (BaobabWindow* self)
{
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp3_ = gtk_tree_selection_get_selected (_tmp1_, NULL, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreePath* path = NULL;
		GtkTreeView* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GtkTreePath* _tmp8_;
		GtkTreeView* _tmp9_;
		GtkTreePath* _tmp10_;
		_tmp4_ = self->priv->treeview;
		_tmp5_ = gtk_tree_view_get_model (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = iter;
		_tmp8_ = gtk_tree_model_get_path (_tmp6_, &_tmp7_);
		path = _tmp8_;
		_tmp9_ = self->priv->treeview;
		_tmp10_ = path;
		gtk_tree_view_expand_row (_tmp9_, _tmp10_, FALSE);
		__vala_GtkTreePath_free0 (path);
	}
}

static void
baobab_window_on_treeview_collapse_row (BaobabWindow* self)
{
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp3_ = gtk_tree_selection_get_selected (_tmp1_, NULL, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreePath* path = NULL;
		GtkTreeView* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GtkTreePath* _tmp8_;
		gboolean _tmp9_ = FALSE;
		GtkTreeView* _tmp10_;
		GtkTreePath* _tmp11_;
		_tmp4_ = self->priv->treeview;
		_tmp5_ = gtk_tree_view_get_model (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = iter;
		_tmp8_ = gtk_tree_model_get_path (_tmp6_, &_tmp7_);
		path = _tmp8_;
		_tmp10_ = self->priv->treeview;
		_tmp11_ = path;
		if (!gtk_tree_view_collapse_row (_tmp10_, _tmp11_)) {
			GtkTreePath* _tmp12_;
			_tmp12_ = path;
			_tmp9_ = gtk_tree_path_up (_tmp12_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkTreeView* _tmp13_;
			GtkTreePath* _tmp14_;
			_tmp13_ = self->priv->treeview;
			_tmp14_ = path;
			gtk_tree_view_set_cursor (_tmp13_, _tmp14_, NULL, FALSE);
		}
		__vala_GtkTreePath_free0 (path);
	}
}

static void
baobab_window_on_treeview_open_folder (BaobabWindow* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = baobab_window_get_selected_iter (self, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter _tmp2_;
		_tmp2_ = iter;
		baobab_window_open_item (self, &_tmp2_);
	}
}

static void
baobab_window_on_treeview_copy (BaobabWindow* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = baobab_window_get_selected_iter (self, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter _tmp2_;
		_tmp2_ = iter;
		baobab_window_copy_path (self, &_tmp2_);
	}
}

static void
baobab_window_on_treeview_trash (BaobabWindow* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = baobab_window_get_selected_iter (self, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter _tmp2_;
		_tmp2_ = iter;
		baobab_window_trash_file (self, &_tmp2_);
	}
}

static void
__lambda23_ (BaobabWindow* self,
             gint n_press,
             gdouble x,
             gdouble y)
{
	GtkTreePath* path = NULL;
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	gboolean _tmp2_;
	_tmp0_ = self->priv->treeview;
	_tmp2_ = gtk_tree_view_get_path_at_pos (_tmp0_, (gint) x, (gint) y, &_tmp1_, NULL, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	if (_tmp2_) {
		GtkTreeView* _tmp3_;
		GtkTreeSelection* _tmp4_;
		GtkTreePath* _tmp5_;
		GtkPopoverMenu* _tmp6_;
		_tmp3_ = self->priv->treeview;
		_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
		_tmp5_ = path;
		gtk_tree_selection_select_path (_tmp4_, _tmp5_);
		_tmp6_ = self->priv->treeview_popover_menu;
		baobab_window_show_treeview_popover (self, _tmp6_, (gint) x, (gint) y);
	}
	__vala_GtkTreePath_free0 (path);
}

static void
___lambda23__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                        gint n_press,
                                        gdouble x,
                                        gdouble y,
                                        gpointer self)
{
	__lambda23_ ((BaobabWindow*) self, n_press, x, y);
}

static void
__lambda24_ (BaobabWindow* self,
             GtkTreePath* wrapper_path,
             GtkTreeViewColumn* column)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	g_return_if_fail (wrapper_path != NULL);
	_tmp0_ = baobab_window_convert_path_to_child_path (self, wrapper_path);
	path = _tmp0_;
	baobab_window_reroot_treeview (self, path, TRUE);
	__vala_GtkTreePath_free0 (path);
}

static void
___lambda24__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
	__lambda24_ ((BaobabWindow*) self, path, column);
}

static void
_baobab_window_reset_treeview_sorting_gtk_tree_sortable_sort_column_changed (GtkTreeSortable* _sender,
                                                                             gpointer self)
{
	baobab_window_reset_treeview_sorting ((BaobabWindow*) self);
}

static void
_baobab_window_copy_treeview_column_sizes_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	baobab_window_copy_treeview_column_sizes ((BaobabWindow*) self);
}

static void
baobab_window_setup_treeview (BaobabWindow* self)
{
	GtkGestureClick* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSortable* folder_display_model = NULL;
	BaobabFolderDisplay* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeSortable* _tmp5_;
	BaobabFolderDisplay* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	BaobabFolderDisplay* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	BaobabFolderDisplay* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview_right_click_gesture;
	g_signal_connect_object (_tmp0_, "pressed", (GCallback) ___lambda23__gtk_gesture_click_pressed, self, 0);
	_tmp1_ = self->priv->treeview;
	g_signal_connect_object (_tmp1_, "row-activated", (GCallback) ___lambda24__gtk_tree_view_row_activated, self, 0);
	_tmp2_ = self->priv->folder_display;
	_tmp3_ = gtk_tree_view_get_model ((GtkTreeView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_tree_sortable_get_type (), GtkTreeSortable));
	folder_display_model = _tmp5_;
	g_signal_connect_object (folder_display_model, "sort-column-changed", (GCallback) _baobab_window_reset_treeview_sorting_gtk_tree_sortable_sort_column_changed, self, 0);
	_tmp6_ = self->priv->folder_display;
	_tmp7_ = _tmp6_->size_column;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::width", (GCallback) _baobab_window_copy_treeview_column_sizes_g_object_notify, self, 0);
	_tmp8_ = self->priv->folder_display;
	_tmp9_ = _tmp8_->contents_column;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::width", (GCallback) _baobab_window_copy_treeview_column_sizes_g_object_notify, self, 0);
	_tmp10_ = self->priv->folder_display;
	_tmp11_ = _tmp10_->time_modified_column;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::width", (GCallback) _baobab_window_copy_treeview_column_sizes_g_object_notify, self, 0);
	_g_object_unref0 (folder_display_model);
}

static void
baobab_window_copy_treeview_column_sizes (BaobabWindow* self)
{
	GtkTreeViewColumn* _tmp0_;
	BaobabFolderDisplay* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	BaobabFolderDisplay* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	BaobabFolderDisplay* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size_column;
	_tmp1_ = self->priv->folder_display;
	_tmp2_ = _tmp1_->size_column;
	_tmp3_ = gtk_tree_view_column_get_width (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_tree_view_column_set_min_width (_tmp0_, _tmp4_);
	_tmp5_ = self->priv->contents_column;
	_tmp6_ = self->priv->folder_display;
	_tmp7_ = _tmp6_->contents_column;
	_tmp8_ = gtk_tree_view_column_get_width (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_tree_view_column_set_min_width (_tmp5_, _tmp9_);
	_tmp10_ = self->priv->time_modified_column;
	_tmp11_ = self->priv->folder_display;
	_tmp12_ = _tmp11_->time_modified_column;
	_tmp13_ = gtk_tree_view_column_get_width (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_tree_view_column_set_min_width (_tmp10_, _tmp14_);
}

static void
baobab_window_reset_treeview_sorting (BaobabWindow* self)
{
	gint id = 0;
	GtkSortType sort_type = 0;
	GtkTreeSortable* folder_display_model = NULL;
	BaobabFolderDisplay* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeSortable* _tmp3_;
	GtkTreeSortable* treeview_model = NULL;
	GtkTreeView* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeSortable* _tmp7_;
	gint _tmp8_ = 0;
	GtkSortType _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_display;
	_tmp1_ = gtk_tree_view_get_model ((GtkTreeView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_tree_sortable_get_type (), GtkTreeSortable));
	folder_display_model = _tmp3_;
	_tmp4_ = self->priv->treeview;
	_tmp5_ = gtk_tree_view_get_model (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_sortable_get_type (), GtkTreeSortable));
	treeview_model = _tmp7_;
	gtk_tree_sortable_get_sort_column_id (folder_display_model, &_tmp8_, &_tmp9_);
	id = _tmp8_;
	sort_type = _tmp9_;
	gtk_tree_sortable_set_sort_column_id (treeview_model, id, sort_type);
	_g_object_unref0 (treeview_model);
	_g_object_unref0 (folder_display_model);
}

static void
baobab_window_reroot_treeview (BaobabWindow* self,
                               GtkTreePath* path,
                               gboolean select_first)
{
	GtkTreeIter iter = {0};
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	BaobabLocation* _tmp4_;
	BaobabScanner* _tmp5_;
	BaobabScanner* _tmp6_;
	GtkTreeIter _tmp7_;
	BaobabChart* _tmp8_;
	BaobabChart* _tmp9_;
	BaobabFolderDisplay* _tmp10_;
	BaobabPathbar* _tmp11_;
	GtkTreeModelFilter* filter = NULL;
	BaobabLocation* _tmp12_;
	BaobabScanner* _tmp13_;
	BaobabScanner* _tmp14_;
	GtkTreeModelFilter* _tmp15_;
	GtkTreeView* _tmp16_;
	GtkTreeModelFilter* _tmp17_;
	GtkTreeModelSort* _tmp18_;
	GtkTreeModelSort* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp3_, path);
	iter = _tmp3_;
	_tmp4_ = self->priv->active_location;
	_tmp5_ = baobab_location_get_scanner (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = iter;
	if (!gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp6_, &_tmp7_)) {
		return;
	}
	_tmp8_ = self->priv->rings_chart;
	baobab_chart_set_tree_root (_tmp8_, path);
	_tmp9_ = self->priv->treemap_chart;
	baobab_chart_set_tree_root (_tmp9_, path);
	_tmp10_ = self->priv->folder_display;
	baobab_folder_display_set_path (_tmp10_, path);
	_tmp11_ = self->priv->pathbar;
	baobab_pathbar_set_path (_tmp11_, path);
	_tmp12_ = self->priv->active_location;
	_tmp13_ = baobab_location_get_scanner (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp14_, path);
	filter = _tmp15_;
	_tmp16_ = self->priv->treeview;
	_tmp17_ = filter;
	_tmp18_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) _tmp17_);
	_tmp19_ = _tmp18_;
	gtk_tree_view_set_model (_tmp16_, (GtkTreeModel*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	baobab_window_reset_treeview_sorting (self);
	if (select_first) {
		GtkTreeView* _tmp20_;
		GtkTreePath* _tmp21_;
		GtkTreePath* _tmp22_;
		_tmp20_ = self->priv->treeview;
		_tmp21_ = gtk_tree_path_new_first ();
		_tmp22_ = _tmp21_;
		gtk_tree_view_set_cursor (_tmp20_, _tmp22_, NULL, FALSE);
		__vala_GtkTreePath_free0 (_tmp22_);
	}
	_g_object_unref0 (filter);
}

static void
baobab_window_message (BaobabWindow* self,
                       const gchar* primary_msg,
                       const gchar* secondary_msg,
                       GtkMessageType type)
{
	GtkInfoBar* _tmp0_;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkInfoBar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_msg != NULL);
	g_return_if_fail (secondary_msg != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_info_bar_set_message_type (_tmp0_, type);
	_tmp1_ = self->priv->infobar_primary_label;
	_tmp2_ = g_strdup_printf ("<b>%s</b>", primary_msg);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->infobar_secondary_label;
	_tmp5_ = g_strdup_printf ("<small>%s</small>", secondary_msg);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->infobar;
	gtk_widget_show ((GtkWidget*) _tmp7_);
}

static void
baobab_window_clear_message (BaobabWindow* self)
{
	GtkInfoBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
baobab_window_set_busy (BaobabWindow* self,
                        gboolean busy)
{
	GdkCursor* new_cursor = NULL;
	GdkCursor* _tmp12_;
	g_return_if_fail (self != NULL);
	new_cursor = NULL;
	self->priv->is_busy = busy;
	if (busy) {
		GdkCursor* _tmp0_;
		GdkCursor* _tmp1_;
		GtkStackSwitcher* _tmp2_;
		GtkStack* _tmp3_;
		GtkSpinner* _tmp4_;
		GtkSpinner* _tmp5_;
		BaobabPathbar* _tmp6_;
		_tmp0_ = baobab_window_busy_cursor;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (new_cursor);
		new_cursor = _tmp1_;
		_tmp2_ = self->priv->chart_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->spinner_stack;
		_tmp4_ = self->priv->spinner;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->spinner;
		gtk_spinner_start (_tmp5_);
		_tmp6_ = self->priv->pathbar;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
	} else {
		GtkSpinner* _tmp7_;
		GtkStack* _tmp8_;
		GtkStack* _tmp9_;
		GtkStackSwitcher* _tmp10_;
		BaobabPathbar* _tmp11_;
		_tmp7_ = self->priv->spinner;
		gtk_spinner_stop (_tmp7_);
		_tmp8_ = self->priv->spinner_stack;
		_tmp9_ = self->priv->chart_stack;
		gtk_stack_set_visible_child (_tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = self->priv->chart_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
		_tmp11_ = self->priv->pathbar;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
	}
	_tmp12_ = new_cursor;
	gtk_widget_set_cursor ((GtkWidget*) self, _tmp12_);
	{
		BaobabWindowActionState* action_state_collection = NULL;
		gint action_state_collection_length1 = 0;
		gint _action_state_collection_size_ = 0;
		gint action_state_it = 0;
		action_state_collection = BAOBAB_WINDOW_actions_while_scanning;
		action_state_collection_length1 = G_N_ELEMENTS (BAOBAB_WINDOW_actions_while_scanning);
		for (action_state_it = 0; action_state_it < action_state_collection_length1; action_state_it = action_state_it + 1) {
			BaobabWindowActionState _tmp13_;
			BaobabWindowActionState _tmp14_ = {0};
			BaobabWindowActionState action_state = {0};
			_tmp13_ = action_state_collection[action_state_it];
			baobab_window_action_state_copy (&_tmp13_, &_tmp14_);
			action_state = _tmp14_;
			{
				GSimpleAction* action = NULL;
				BaobabWindowActionState _tmp15_;
				const gchar* _tmp16_;
				GAction* _tmp17_;
				GSimpleAction* _tmp18_;
				GSimpleAction* _tmp19_;
				BaobabWindowActionState _tmp20_;
				_tmp15_ = action_state;
				_tmp16_ = _tmp15_.name;
				_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, _tmp16_);
				_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL);
				action = _tmp18_;
				_tmp19_ = action;
				_tmp20_ = action_state;
				g_simple_action_set_enabled (_tmp19_, busy == _tmp20_.enable);
				_g_object_unref0 (action);
				baobab_window_action_state_destroy (&action_state);
			}
		}
	}
	_g_object_unref0 (new_cursor);
}

static void
baobab_window_set_ui_state (BaobabWindow* self,
                            GtkWidget* child,
                            gboolean busy)
{
	GtkMenuButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	AdwHeaderBar* _tmp6_;
	GtkWidget* _tmp7_;
	GtkStack* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->menu_button;
	_tmp1_ = self->priv->home_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, child == _tmp1_);
	_tmp2_ = self->priv->reload_button;
	_tmp3_ = self->priv->result_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, child == _tmp3_);
	_tmp4_ = self->priv->back_button;
	_tmp5_ = self->priv->result_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, child == _tmp5_);
	baobab_window_set_busy (self, busy);
	_tmp6_ = self->priv->header_bar;
	adw_header_bar_set_title_widget (_tmp6_, NULL);
	_tmp7_ = self->priv->home_page;
	if (child == _tmp7_) {
		GSimpleAction* action = NULL;
		GAction* _tmp8_;
		GSimpleAction* _tmp9_;
		GSimpleAction* _tmp10_;
		_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "reload");
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
		action = _tmp9_;
		_tmp10_ = action;
		g_simple_action_set_enabled (_tmp10_, FALSE);
		gtk_window_set_title ((GtkWindow*) self, _ ("Devices & Locations"));
		_g_object_unref0 (action);
	} else {
		GSimpleAction* action = NULL;
		GAction* _tmp11_;
		GSimpleAction* _tmp12_;
		GSimpleAction* _tmp13_;
		BaobabLocation* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GtkWidget* _tmp17_;
		_tmp11_ = g_action_map_lookup_action ((GActionMap*) self, "reload");
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp11_) : NULL);
		action = _tmp12_;
		_tmp13_ = action;
		g_simple_action_set_enabled (_tmp13_, TRUE);
		_tmp14_ = self->priv->active_location;
		_tmp15_ = baobab_location_get_name (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_window_set_title ((GtkWindow*) self, _tmp16_);
		_tmp17_ = self->priv->result_page;
		if (child == _tmp17_) {
			AdwHeaderBar* _tmp18_;
			BaobabPathbar* _tmp19_;
			_tmp18_ = self->priv->header_bar;
			_tmp19_ = self->priv->pathbar;
			adw_header_bar_set_title_widget (_tmp18_, (GtkWidget*) _tmp19_);
		}
		_g_object_unref0 (action);
	}
	_tmp20_ = self->priv->main_stack;
	gtk_stack_set_visible_child (_tmp20_, child);
}

static void
baobab_window_set_chart_location (BaobabWindow* self,
                                  BaobabLocation* location)
{
	BaobabChart* _tmp0_;
	BaobabChart* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->rings_chart;
	baobab_chart_set_location (_tmp0_, location);
	_tmp1_ = self->priv->treemap_chart;
	baobab_chart_set_location (_tmp1_, location);
}

static void
baobab_window_scanner_completed (BaobabWindow* self)
{
	BaobabScanner* scanner = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	BaobabScanner* _tmp3_;
	GtkTreePath* _tmp17_;
	GtkTreePath* _tmp18_;
	BaobabLocation* _tmp19_;
	GtkWidget* _tmp20_;
	BaobabFolderDisplay* _tmp21_;
	GtkTreePath* _tmp22_;
	GtkTreePath* _tmp23_;
	BaobabScanner* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	scanner = _tmp3_;
	if (self->priv->scan_completed_handler > ((gulong) 0)) {
		BaobabScanner* _tmp4_;
		_tmp4_ = scanner;
		g_signal_handler_disconnect ((GObject*) _tmp4_, self->priv->scan_completed_handler);
		self->priv->scan_completed_handler = (gulong) 0;
	}
	if (self->priv->scanning_progress_id > ((guint) 0)) {
		g_source_remove (self->priv->scanning_progress_id);
		self->priv->scanning_progress_id = (guint) 0;
	}
	{
		BaobabScanner* _tmp5_;
		_tmp5_ = scanner;
		baobab_scanner_finish (_tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (scanner);
		return;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* primary = NULL;
		BaobabScanner* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		GtkWidget* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = scanner;
		_tmp7_ = baobab_scanner_get_directory (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_parse_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf (_ ("Could not scan folder “%s”"), _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		primary = _tmp12_;
		_tmp13_ = primary;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		baobab_window_message (self, _tmp13_, _tmp15_, GTK_MESSAGE_ERROR);
		_tmp16_ = self->priv->home_page;
		baobab_window_set_ui_state (self, _tmp16_, FALSE);
		_g_free0 (primary);
		_g_error_free0 (e);
		_g_object_unref0 (scanner);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (scanner);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = gtk_tree_path_new_first ();
	_tmp18_ = _tmp17_;
	baobab_window_reroot_treeview (self, _tmp18_, FALSE);
	__vala_GtkTreePath_free0 (_tmp18_);
	_tmp19_ = self->priv->active_location;
	baobab_window_set_chart_location (self, _tmp19_);
	_tmp20_ = self->priv->result_page;
	baobab_window_set_ui_state (self, _tmp20_, FALSE);
	_tmp21_ = self->priv->folder_display;
	_tmp22_ = gtk_tree_path_new_first ();
	_tmp23_ = _tmp22_;
	baobab_folder_display_set_path (_tmp21_, _tmp23_);
	__vala_GtkTreePath_free0 (_tmp23_);
	baobab_window_copy_treeview_column_sizes (self);
	_tmp24_ = scanner;
	_tmp25_ = baobab_scanner_get_show_allocated_size (_tmp24_);
	_tmp26_ = _tmp25_;
	if (!_tmp26_) {
		baobab_window_message (self, _ ("Could not always detect occupied disk sizes."), _ ("Apparent sizes may be shown instead."), GTK_MESSAGE_INFO);
	}
	g_object_get ((GtkWindow*) self, "is-active", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	if (!_tmp28_) {
		GNotification* notification = NULL;
		GNotification* _tmp29_;
		GNotification* _tmp30_;
		BaobabScanner* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GtkApplication* _tmp38_;
		GNotification* _tmp39_;
		_tmp29_ = g_notification_new (_ ("Scan completed"));
		notification = _tmp29_;
		_tmp30_ = notification;
		_tmp31_ = scanner;
		_tmp32_ = baobab_scanner_get_directory (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_file_get_parse_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf (_ ("Completed scan of “%s”"), _tmp35_);
		_tmp37_ = _tmp36_;
		g_notification_set_body (_tmp30_, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_tmp38_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp39_ = notification;
		g_application_send_notification ((GApplication*) _tmp38_, "scan-completed", _tmp39_);
		_g_object_unref0 (notification);
	}
	_g_object_unref0 (scanner);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BaobabWindow* self;
		self = _data9_->self;
		_baobab_location_unref0 (_data9_->location);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_baobab_window_scanner_completed_baobab_scanner_completed (BaobabScanner* _sender,
                                                           gpointer self)
{
	baobab_window_scanner_completed ((BaobabWindow*) self);
}

static gboolean
__lambda17_ (Block9Data* _data9_)
{
	BaobabWindow* self;
	gboolean result;
	self = _data9_->self;
	g_signal_emit_by_name (_data9_->location, "progress");
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ (self);
	return result;
}

static void
baobab_window_scan_location (BaobabWindow* self,
                             BaobabLocation* location,
                             gboolean force)
{
	Block9Data* _data9_;
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	BaobabPathbar* _tmp2_;
	BaobabFolderDisplay* _tmp3_;
	BaobabLocationList* _tmp4_;
	GtkTreeView* _tmp5_;
	BaobabScanner* scanner = NULL;
	BaobabScanner* _tmp6_;
	BaobabScanner* _tmp7_;
	BaobabScanner* _tmp8_;
	gulong _tmp9_;
	GtkWidget* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = _baobab_location_ref0 (location);
	_baobab_location_unref0 (_data9_->location);
	_data9_->location = _tmp0_;
	baobab_window_cancel_scan (self);
	_tmp1_ = _baobab_location_ref0 (_data9_->location);
	_baobab_location_unref0 (self->priv->active_location);
	self->priv->active_location = _tmp1_;
	_tmp2_ = self->priv->pathbar;
	baobab_pathbar_set_location (_tmp2_, _data9_->location);
	_tmp3_ = self->priv->folder_display;
	baobab_folder_display_set_location (_tmp3_, _data9_->location);
	_tmp4_ = self->priv->location_list;
	baobab_location_list_add_location (_tmp4_, _data9_->location);
	_tmp5_ = self->priv->treeview;
	gtk_tree_view_set_model (_tmp5_, NULL);
	_tmp6_ = baobab_location_get_scanner (_data9_->location);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	scanner = _tmp8_;
	_tmp9_ = g_signal_connect_object (scanner, "completed", (GCallback) _baobab_window_scanner_completed_baobab_scanner_completed, self, 0);
	self->priv->scan_completed_handler = _tmp9_;
	baobab_window_clear_message (self);
	self->priv->scanning_progress_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda17__gsource_func, block9_data_ref (_data9_), block9_data_unref);
	_tmp10_ = self->priv->result_page;
	baobab_window_set_ui_state (self, _tmp10_, TRUE);
	baobab_scanner_scan (scanner, force);
	_g_object_unref0 (scanner);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

void
baobab_window_scan_directory (BaobabWindow* self,
                              GFile* directory,
                              BaobabScanFlags flags)
{
	GFileInfo* info = NULL;
	gboolean _tmp3_ = FALSE;
	GFileInfo* _tmp4_;
	BaobabLocation* location = NULL;
	BaobabLocation* _tmp11_;
	BaobabLocation* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	info = NULL;
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp1_ = g_file_query_info (directory, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info);
		info = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = info;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GFileInfo* _tmp5_;
		_tmp5_ = info;
		_tmp3_ = g_file_info_get_file_type (_tmp5_) != G_FILE_TYPE_DIRECTORY;
	}
	if (_tmp3_) {
		gchar* primary = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = g_file_get_parse_name (directory);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_ ("“%s” is not a valid folder"), _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		primary = _tmp9_;
		_tmp10_ = primary;
		baobab_window_message (self, _tmp10_, _ ("Could not analyze disk usage."), GTK_MESSAGE_ERROR);
		_g_free0 (primary);
		_g_object_unref0 (info);
		return;
	}
	_tmp11_ = baobab_location_new_for_file (directory, flags);
	location = _tmp11_;
	_tmp12_ = location;
	baobab_window_scan_location (self, _tmp12_, FALSE);
	_baobab_location_unref0 (location);
	_g_object_unref0 (info);
}

void
baobab_window_action_state_copy (const BaobabWindowActionState* self,
                                 BaobabWindowActionState* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).enable = (*self).enable;
}

void
baobab_window_action_state_destroy (BaobabWindowActionState* self)
{
	_g_free0 ((*self).name);
}

BaobabWindowActionState*
baobab_window_action_state_dup (const BaobabWindowActionState* self)
{
	BaobabWindowActionState* dup;
	dup = g_new0 (BaobabWindowActionState, 1);
	baobab_window_action_state_copy (self, dup);
	return dup;
}

void
baobab_window_action_state_free (BaobabWindowActionState* self)
{
	baobab_window_action_state_destroy (self);
	g_free (self);
}

static GType
baobab_window_action_state_get_type_once (void)
{
	GType baobab_window_action_state_type_id;
	baobab_window_action_state_type_id = g_boxed_type_register_static ("BaobabWindowActionState", (GBoxedCopyFunc) baobab_window_action_state_dup, (GBoxedFreeFunc) baobab_window_action_state_free);
	return baobab_window_action_state_type_id;
}

GType
baobab_window_action_state_get_type (void)
{
	static volatile gsize baobab_window_action_state_type_id__once = 0;
	if (g_once_init_enter (&baobab_window_action_state_type_id__once)) {
		GType baobab_window_action_state_type_id;
		baobab_window_action_state_type_id = baobab_window_action_state_get_type_once ();
		g_once_init_leave (&baobab_window_action_state_type_id__once, baobab_window_action_state_type_id);
	}
	return baobab_window_action_state_type_id__once;
}

static void
baobab_window_class_init (BaobabWindowClass * klass,
                          gpointer klass_data)
{
	baobab_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = baobab_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "focus_controller", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, focus_controller));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "drop_target", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, drop_target));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_gesture", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, back_gesture));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "vbox", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, vbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, pathbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reload_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, reload_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "home_page", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, home_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_page", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, result_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_primary_label", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar_primary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_secondary_label", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar_secondary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_close_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar_close_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_list", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, location_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "folder_display", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, folder_display));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_popover_menu", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_popover_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "size_column", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, size_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contents_column", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, contents_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_modified_column", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, time_modified_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_right_click_gesture", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_right_click_gesture));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "chart_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, chart_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, spinner_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "chart_stack_switcher", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, chart_stack_switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rings_chart", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, rings_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treemap_chart", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treemap_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, spinner));
}

static void
baobab_window_instance_init (BaobabWindow * self,
                             gpointer klass)
{
	self->priv = baobab_window_get_instance_private (self);
	self->priv->active_location = NULL;
	self->priv->is_busy = FALSE;
	self->priv->scan_completed_handler = (gulong) 0;
	self->priv->scanning_progress_id = (guint) 0;
	g_type_ensure (BAOBAB_TYPE_PATHBAR);
	g_type_ensure (BAOBAB_TYPE_LOCATION_LIST);
	g_type_ensure (BAOBAB_TYPE_FOLDER_DISPLAY);
	g_type_ensure (BAOBAB_TYPE_CHART);
	g_type_ensure (BAOBAB_TYPE_CHART);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_window_finalize (GObject * obj)
{
	BaobabWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_WINDOW, BaobabWindow);
	_baobab_location_unref0 (self->priv->active_location);
	G_OBJECT_CLASS (baobab_window_parent_class)->finalize (obj);
}

static GType
baobab_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabWindow), 0, (GInstanceInitFunc) baobab_window_instance_init, NULL };
	GType baobab_window_type_id;
	baobab_window_type_id = g_type_register_static (adw_application_window_get_type (), "BaobabWindow", &g_define_type_info, 0);
	BaobabWindow_private_offset = g_type_add_instance_private (baobab_window_type_id, sizeof (BaobabWindowPrivate));
	return baobab_window_type_id;
}

GType
baobab_window_get_type (void)
{
	static volatile gsize baobab_window_type_id__once = 0;
	if (g_once_init_enter (&baobab_window_type_id__once)) {
		GType baobab_window_type_id;
		baobab_window_type_id = baobab_window_get_type_once ();
		g_once_init_leave (&baobab_window_type_id__once, baobab_window_type_id);
	}
	return baobab_window_type_id__once;
}

