/* browser-window.c generated by valac 0.56.2, the Vala compiler
 * generated from browser-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define BROWSER_WINDOW_root_path "/"
#define MODEL_UTILS_folder_context_id_string "1"
#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#define MODEL_UTILS_folder_context_id ((guint16) 1)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;
typedef struct _AdaptativeWindowPrivate AdaptativeWindowPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;
typedef struct _BaseWindowPrivate BaseWindowPrivate;

#define TYPE_BROWSER_WINDOW (browser_window_get_type ())
#define BROWSER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_WINDOW, BrowserWindow))
#define BROWSER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_WINDOW, BrowserWindowClass))
#define IS_BROWSER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_WINDOW))
#define IS_BROWSER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_WINDOW))
#define BROWSER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_WINDOW, BrowserWindowClass))

typedef struct _BrowserWindow BrowserWindow;
typedef struct _BrowserWindowClass BrowserWindowClass;
typedef struct _BrowserWindowPrivate BrowserWindowPrivate;

#define TYPE_NIGHT_TIME_AWARE_HEADER_BAR (night_time_aware_header_bar_get_type ())
#define NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBar))
#define NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define NIGHT_TIME_AWARE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))

typedef struct _NightTimeAwareHeaderBar NightTimeAwareHeaderBar;
typedef struct _NightTimeAwareHeaderBarClass NightTimeAwareHeaderBarClass;

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;

#define TYPE_BROWSER_HEADER_BAR (browser_header_bar_get_type ())
#define BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar))
#define BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))
#define IS_BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_HEADER_BAR))
#define IS_BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_HEADER_BAR))
#define BROWSER_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))

typedef struct _BrowserHeaderBar BrowserHeaderBar;
typedef struct _BrowserHeaderBarClass BrowserHeaderBarClass;

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;

#define TYPE_BROWSER_VIEW (browser_view_get_type ())
#define BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_VIEW, BrowserView))
#define BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_VIEW, BrowserViewClass))
#define IS_BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_VIEW))
#define IS_BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_VIEW))
#define BROWSER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_VIEW, BrowserViewClass))

typedef struct _BrowserView BrowserView;
typedef struct _BrowserViewClass BrowserViewClass;
enum  {
	BROWSER_WINDOW_0_PROPERTY,
	BROWSER_WINDOW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY,
	BROWSER_WINDOW_MOUSE_BACK_BUTTON_PROPERTY,
	BROWSER_WINDOW_MOUSE_FORWARD_BUTTON_PROPERTY,
	BROWSER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* browser_window_properties[BROWSER_WINDOW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PATH_ENTRY_SEARCH_MODE_UNCLEAR,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD,
	PATH_ENTRY_SEARCH_MODE_SEARCH
} PathEntrySearchMode;

#define PATH_ENTRY_TYPE_SEARCH_MODE (path_entry_search_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_BROWSER_ENTRY (browser_entry_get_type ())
#define BROWSER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_ENTRY, BrowserEntry))
#define BROWSER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_ENTRY, BrowserEntryClass))
#define IS_BROWSER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_ENTRY))
#define IS_BROWSER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_ENTRY))
#define BROWSER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_ENTRY, BrowserEntryClass))

typedef struct _BrowserEntry BrowserEntry;
typedef struct _BrowserEntryClass BrowserEntryClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWindow {
	GtkApplicationWindow parent_instance;
	AdaptativeWindowPrivate * priv;
};

struct _AdaptativeWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*before_destroy) (AdaptativeWindow* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseWindow {
	AdaptativeWindow parent_instance;
	BaseWindowPrivate * priv;
};

struct _BaseWindowClass {
	AdaptativeWindowClass parent_class;
	gboolean (*handle_copy_text) (BaseWindow* self, gchar** copy_text);
	gboolean (*get_alt_copy_text) (BaseWindow* self, gchar** copy_text);
	void (*paste_text) (BaseWindow* self, const gchar* text);
	void (*menu_pressed) (BaseWindow* self);
	gboolean (*on_key_press_event) (BaseWindow* self, GtkWidget* widget, GdkEventKey* event);
	void (*set_window_size) (BaseWindow* self, AdaptativeWidgetWindowSize new_size);
	void (*close_in_window_panels) (BaseWindow* self);
	gboolean (*escape_pressed) (BaseWindow* self);
	void (*show_default_view) (BaseWindow* self);
};

struct _BrowserWindow {
	BaseWindow parent_instance;
	BrowserWindowPrivate * priv;
	gchar* current_path;
	ViewType current_type;
	ViewType saved_type;
	gchar* saved_view;
	gchar* saved_selection;
	GSimpleAction* reload_search_action;
};

struct _BrowserWindowClass {
	BaseWindowClass parent_class;
	void (*request_folder) (BrowserWindow* self, const gchar* full_name, const gchar* selected_or_empty, gboolean notify_missing);
	void (*request_object) (BrowserWindow* self, const gchar* full_name, guint16 context_id, gboolean notify_missing, const gchar* schema_id);
	void (*request_config) (BrowserWindow* self, const gchar* full_name);
	void (*reconfigure_search) (BrowserWindow* self, gboolean local_search);
	gboolean (*intercept_next_match) (BrowserWindow* self, gboolean* interception_result);
	gboolean (*intercept_previous_match) (BrowserWindow* self, gboolean* interception_result);
};

struct _BrowserWindowPrivate {
	BrowserHeaderBar* headerbar;
	BrowserView* main_view;
	GSimpleAction* disabled_state_action;
	GSimpleAction* open_path_action;
	gchar* last_search_entry_text;
	gboolean init_next_search;
	gboolean search_is_local;
	gchar* last_non_empty_search;
	gboolean _mouse_use_extra_buttons;
	gint _mouse_back_button;
	gint _mouse_forward_button;
};

static gint BrowserWindow_private_offset;
static gpointer browser_window_parent_class = NULL;

VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint8 view_type_to_byte (ViewType type);
VALA_EXTERN ViewType view_type_from_byte (guint8 type);
VALA_EXTERN gboolean view_type_displays_objects_list (ViewType type);
VALA_EXTERN gboolean view_type_displays_object_infos (ViewType type);
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType browser_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserWindow, g_object_unref)
VALA_EXTERN GType night_time_aware_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightTimeAwareHeaderBar, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType browser_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserHeaderBar, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType browser_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserView, g_object_unref)
VALA_EXTERN void browser_window_request_folder (BrowserWindow* self,
                                    const gchar* full_name,
                                    const gchar* selected_or_empty,
                                    gboolean notify_missing);
VALA_EXTERN void browser_window_request_object (BrowserWindow* self,
                                    const gchar* full_name,
                                    guint16 context_id,
                                    gboolean notify_missing,
                                    const gchar* schema_id);
VALA_EXTERN void browser_window_request_config (BrowserWindow* self,
                                    const gchar* full_name);
VALA_EXTERN void browser_window_reconfigure_search (BrowserWindow* self,
                                        gboolean local_search);
VALA_EXTERN gboolean base_window_escape_pressed (BaseWindow* self);
VALA_EXTERN void base_window_show_default_view (BaseWindow* self);
VALA_EXTERN gboolean browser_window_intercept_next_match (BrowserWindow* self,
                                              gboolean* interception_result);
VALA_EXTERN gboolean browser_window_intercept_previous_match (BrowserWindow* self,
                                                  gboolean* interception_result);
VALA_EXTERN void base_window_paste_text (BaseWindow* self,
                             const gchar* text);
VALA_EXTERN void base_window_menu_pressed (BaseWindow* self);
VALA_EXTERN gboolean base_window_on_key_press_event (BaseWindow* self,
                                         GtkWidget* widget,
                                         GdkEventKey* event);
static void browser_window_empty (BrowserWindow* self);
static void _browser_window_empty_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void browser_window_open_folder (BrowserWindow* self,
                                 GSimpleAction* action,
                                 GVariant* path_variant);
static void _browser_window_open_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_open_object (BrowserWindow* self,
                                 GSimpleAction* action,
                                 GVariant* path_variant);
static void _browser_window_open_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_open_config (BrowserWindow* self,
                                 GSimpleAction* action,
                                 GVariant* path_variant);
static void _browser_window_open_config_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_open_config_local (BrowserWindow* self);
static void _browser_window_open_config_local_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void browser_window_open_search (BrowserWindow* self,
                                 GSimpleAction* action,
                                 GVariant* search_variant);
static void _browser_window_open_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_open_search_local (BrowserWindow* self);
static void _browser_window_open_search_local_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void browser_window_open_search_global (BrowserWindow* self);
static void _browser_window_open_search_global_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void browser_window_open_search_root (BrowserWindow* self);
static void _browser_window_open_search_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void browser_window_next_search (BrowserWindow* self,
                                 GSimpleAction* action,
                                 GVariant* search_variant);
static void _browser_window_next_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_open_parent (BrowserWindow* self,
                                 GSimpleAction* action,
                                 GVariant* path_variant);
static void _browser_window_open_parent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_open_path (BrowserWindow* self,
                               GSimpleAction* action,
                               GVariant* path_variant);
static void _browser_window_open_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void browser_window_reload_folder (BrowserWindow* self);
static void _browser_window_reload_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_reload_object (BrowserWindow* self);
static void _browser_window_reload_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_reload_search (BrowserWindow* self);
static void _browser_window_reload_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_hide_search (BrowserWindow* self);
static void _browser_window_hide_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_show_search (BrowserWindow* self);
static void _browser_window_show_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void browser_window_toggle_search (BrowserWindow* self,
                                   GSimpleAction* action,
                                   GVariant* path_variant);
static void _browser_window_toggle_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_search_changed (BrowserWindow* self,
                                    GSimpleAction* action,
                                    GVariant* path_variant);
static void _browser_window_search_changed_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void browser_window_next_match (BrowserWindow* self);
static void _browser_window_next_match_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void browser_window_previous_match (BrowserWindow* self);
static void _browser_window_previous_match_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void browser_window_toggle_config (BrowserWindow* self);
static void _browser_window_toggle_config_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_search_global (BrowserWindow* self,
                                   GSimpleAction* action,
                                   GVariant* variant);
static void _browser_window_search_global_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_search_local (BrowserWindow* self,
                                  GSimpleAction* action,
                                  GVariant* variant);
static void _browser_window_search_local_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void browser_window_edit_path_end (BrowserWindow* self);
static void _browser_window_edit_path_end_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void browser_window_edit_path_last (BrowserWindow* self);
static void _browser_window_edit_path_last_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void browser_window_open_root (BrowserWindow* self);
static void _browser_window_open_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void browser_window_open_current_parent (BrowserWindow* self);
static void _browser_window_open_current_parent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void browser_window_open_child (BrowserWindow* self);
static void _browser_window_open_child_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void browser_window_open_last_child (BrowserWindow* self);
static void _browser_window_open_last_child_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void browser_window_install_browser_action_entries (BrowserWindow* self);
VALA_EXTERN void base_window_close_in_window_panels (BaseWindow* self);
VALA_EXTERN void base_header_bar_close_popovers (BaseHeaderBar* self);
VALA_EXTERN GType path_entry_search_mode_get_type (void) G_GNUC_CONST ;
static void browser_window_request_search (BrowserWindow* self,
                                    PathEntrySearchMode mode,
                                    const gchar* search,
                                    gboolean local_search);
VALA_EXTERN ViewType browser_view_get_current_view (BrowserView* self);
VALA_EXTERN gchar* model_utils_get_parent_path (const gchar* path);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN gchar* browser_view_get_selected_row_name (BrowserView* self);
VALA_EXTERN void browser_window_stop_search (BrowserWindow* self);
VALA_EXTERN gboolean browser_header_bar_get_search_mode_enabled (BrowserHeaderBar* self);
VALA_EXTERN void browser_view_row_grab_focus (BrowserView* self);
VALA_EXTERN void browser_window_update_current_path (BrowserWindow* self,
                                         ViewType type,
                                         const gchar* path);
static GVariant* _variant_new8 (gboolean value);
VALA_EXTERN void browser_view_set_path (BrowserView* self,
                            ViewType type,
                            const gchar* path);
VALA_EXTERN void browser_header_bar_set_path (BrowserHeaderBar* self,
                                  ViewType type,
                                  const gchar* path);
static void browser_window_real_request_folder (BrowserWindow* self,
                                         const gchar* full_name,
                                         const gchar* selected_or_empty,
                                         gboolean notify_missing);
static void browser_window_real_request_object (BrowserWindow* self,
                                         const gchar* full_name,
                                         guint16 context_id,
                                         gboolean notify_missing,
                                         const gchar* schema_id);
static void browser_window_real_request_config (BrowserWindow* self,
                                         const gchar* full_name);
static void browser_window_init_search (BrowserWindow* self,
                                 gboolean local_search);
VALA_EXTERN void browser_header_bar_prepare_search (BrowserHeaderBar* self,
                                        PathEntrySearchMode mode,
                                        const gchar* search);
VALA_EXTERN void browser_view_select_row (BrowserView* self,
                              const gchar* selected_or_empty);
static gboolean browser_window_search_entry_has_focus (BrowserWindow* self);
VALA_EXTERN void browser_header_bar_entry_grab_focus (BrowserHeaderBar* self,
                                          gboolean select);
static void browser_window_real_reconfigure_search (BrowserWindow* self,
                                             gboolean local_search);
VALA_EXTERN GType browser_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserEntry, g_object_unref)
VALA_EXTERN gboolean browser_window_is_path_invalid (const gchar* path);
VALA_EXTERN gboolean browser_window_is_in_in_window_mode (BrowserWindow* self);
VALA_EXTERN gboolean base_view_is_in_in_window_mode (BaseView* self);
VALA_EXTERN gboolean browser_header_bar_get_in_window_properties (BrowserHeaderBar* self);
VALA_EXTERN gboolean browser_window_row_action_blocked (BrowserWindow* self);
VALA_EXTERN gboolean base_header_bar_has_popover (BaseHeaderBar* self);
static gboolean browser_window_real_escape_pressed (BaseWindow* base);
static void browser_window_real_show_default_view (BaseWindow* base);
VALA_EXTERN gboolean base_window_get_in_window_about (BaseWindow* self);
static void browser_window_go_backward (BrowserWindow* self,
                                 gboolean shift);
VALA_EXTERN void base_view_close_popovers (BaseView* self);
static void browser_window_go_forward (BrowserWindow* self,
                                gboolean shift);
VALA_EXTERN void browser_header_bar_get_fallback_path_and_complete_path (BrowserHeaderBar* self,
                                                             gchar** fallback_path,
                                                             gchar** complete_path);
VALA_EXTERN gboolean model_utils_is_key_path (const gchar* path);
VALA_EXTERN void browser_window_reload_view (BrowserWindow* self);
static void browser_window_install_key_action_entries (BrowserWindow* self);
static gboolean _browser_window_next_match (BrowserWindow* self);
static gboolean _browser_window_previous_match (BrowserWindow* self);
VALA_EXTERN gboolean browser_view_next_match (BrowserView* self);
VALA_EXTERN gboolean browser_view_previous_match (BrowserView* self);
static gboolean browser_window_real_intercept_next_match (BrowserWindow* self,
                                                   gboolean* interception_result);
static gboolean browser_window_real_intercept_previous_match (BrowserWindow* self,
                                                       gboolean* interception_result);
static void browser_window_real_paste_text (BaseWindow* base,
                                     const gchar* text);
static void browser_window_real_menu_pressed (BaseWindow* base);
VALA_EXTERN gboolean browser_view_toggle_row_popover (BrowserView* self);
VALA_EXTERN void base_header_bar_toggle_hamburger_menu (BaseHeaderBar* self);
static gboolean browser_window_real_on_key_press_event (BaseWindow* base,
                                                 GtkWidget* widget,
                                                 GdkEventKey* event);
VALA_EXTERN void browser_header_bar_toggle_pathbar_menu (BrowserHeaderBar* self);
VALA_EXTERN gboolean browser_view_return_pressed (BrowserView* self);
VALA_EXTERN gboolean browser_header_bar_handle_event (BrowserHeaderBar* self,
                                          GdkEventKey* event);
static void browser_window_bind_mouse_config (BrowserWindow* self);
static gboolean browser_window_on_button_press_event (GtkWidget* widget,
                                               GdkEventButton* event);
static gboolean browser_window_get_mouse_use_extra_buttons (BrowserWindow* self);
static gint browser_window_get_mouse_back_button (BrowserWindow* self);
static gint browser_window_get_mouse_forward_button (BrowserWindow* self);
VALA_EXTERN BrowserWindow* browser_window_construct (GType object_type);
VALA_EXTERN BaseWindow* base_window_new (void);
VALA_EXTERN BaseWindow* base_window_construct (GType object_type);
VALA_EXTERN void browser_window_set_mouse_use_extra_buttons (BrowserWindow* self,
                                                 gboolean value);
VALA_EXTERN void browser_window_set_mouse_back_button (BrowserWindow* self,
                                           gint value);
VALA_EXTERN void browser_window_set_mouse_forward_button (BrowserWindow* self,
                                              gint value);
static GObject * browser_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
VALA_EXTERN NightTimeAwareHeaderBar* adaptative_window_get_nta_headerbar (AdaptativeWindow* self);
VALA_EXTERN BaseView* base_window_get_base_view (BaseWindow* self);
static gboolean _browser_window_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static void browser_window_finalize (GObject * obj);
static GType browser_window_get_type_once (void);
static void _vala_browser_window_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_browser_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry BROWSER_WINDOW_browser_action_entries[22] = {{"empty", _browser_window_empty_gsimple_action_activate_callback, "*"}, {"empty-null", _browser_window_empty_gsimple_action_activate_callback}, {"disabled-state-s", _browser_window_empty_gsimple_action_activate_callback, "s", "''"}, {"disabled-state-sq", _browser_window_empty_gsimple_action_activate_callback, "(sq)", "('',uint16 65535)"}, {"open-folder", _browser_window_open_folder_gsimple_action_activate_callback, "s"}, {"open-object", _browser_window_open_object_gsimple_action_activate_callback, "(sq)"}, {"open-config", _browser_window_open_config_gsimple_action_activate_callback, "s"}, {"open-config-local", _browser_window_open_config_local_gsimple_action_activate_callback}, {"open-search", _browser_window_open_search_gsimple_action_activate_callback, "s"}, {"open-search-local", _browser_window_open_search_local_gsimple_action_activate_callback}, {"open-search-global", _browser_window_open_search_global_gsimple_action_activate_callback}, {"open-search-root", _browser_window_open_search_root_gsimple_action_activate_callback}, {"next-search", _browser_window_next_search_gsimple_action_activate_callback, "s"}, {"open-parent", _browser_window_open_parent_gsimple_action_activate_callback, "s"}, {"open-path", _browser_window_open_path_gsimple_action_activate_callback, "(sq)", "('/',uint16 " MODEL_UTILS_folder_context_id_string ")"}, {"reload-folder", _browser_window_reload_folder_gsimple_action_activate_callback}, {"reload-object", _browser_window_reload_object_gsimple_action_activate_callback}, {"reload-search", _browser_window_reload_search_gsimple_action_activate_callback}, {"hide-search", _browser_window_hide_search_gsimple_action_activate_callback}, {"show-search", _browser_window_show_search_gsimple_action_activate_callback}, {"toggle-search", _browser_window_toggle_search_gsimple_action_activate_callback, "b", "false"}, {"search-changed", _browser_window_search_changed_gsimple_action_activate_callback, "ms"}};
static const GActionEntry BROWSER_WINDOW_key_action_entries[11] = {{"next-match", _browser_window_next_match_gsimple_action_activate_callback}, {"previous-match", _browser_window_previous_match_gsimple_action_activate_callback}, {"toggle-config", _browser_window_toggle_config_gsimple_action_activate_callback}, {"search-global", _browser_window_search_global_gsimple_action_activate_callback, "b"}, {"search-local", _browser_window_search_local_gsimple_action_activate_callback, "b"}, {"edit-path-end", _browser_window_edit_path_end_gsimple_action_activate_callback}, {"edit-path-last", _browser_window_edit_path_last_gsimple_action_activate_callback}, {"open-root", _browser_window_open_root_gsimple_action_activate_callback}, {"open-parent", _browser_window_open_current_parent_gsimple_action_activate_callback}, {"open-child", _browser_window_open_child_gsimple_action_activate_callback}, {"open-last-child", _browser_window_open_last_child_gsimple_action_activate_callback}};

guint8
view_type_to_byte (ViewType type)
{
	guint8 result;
	switch (type) {
		case VIEW_TYPE_OBJECT:
		{
			result = (guint8) 0;
			return result;
		}
		case VIEW_TYPE_FOLDER:
		{
			result = (guint8) 1;
			return result;
		}
		case VIEW_TYPE_SEARCH:
		{
			result = (guint8) 2;
			return result;
		}
		case VIEW_TYPE_CONFIG:
		{
			result = (guint8) 3;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

ViewType
view_type_from_byte (guint8 type)
{
	ViewType result;
	switch (type) {
		case 0:
		{
			result = VIEW_TYPE_OBJECT;
			return result;
		}
		case 1:
		{
			result = VIEW_TYPE_FOLDER;
			return result;
		}
		case 2:
		{
			result = VIEW_TYPE_SEARCH;
			return result;
		}
		case 3:
		{
			result = VIEW_TYPE_CONFIG;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gboolean
view_type_displays_objects_list (ViewType type)
{
	gboolean result;
	switch (type) {
		case VIEW_TYPE_OBJECT:
		case VIEW_TYPE_CONFIG:
		{
			result = FALSE;
			return result;
		}
		case VIEW_TYPE_FOLDER:
		case VIEW_TYPE_SEARCH:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gboolean
view_type_displays_object_infos (ViewType type)
{
	gboolean result;
	switch (type) {
		case VIEW_TYPE_OBJECT:
		case VIEW_TYPE_CONFIG:
		{
			result = TRUE;
			return result;
		}
		case VIEW_TYPE_FOLDER:
		case VIEW_TYPE_SEARCH:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
view_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VIEW_TYPE_OBJECT, "VIEW_TYPE_OBJECT", "object"}, {VIEW_TYPE_FOLDER, "VIEW_TYPE_FOLDER", "folder"}, {VIEW_TYPE_SEARCH, "VIEW_TYPE_SEARCH", "search"}, {VIEW_TYPE_CONFIG, "VIEW_TYPE_CONFIG", "config"}, {0, NULL, NULL}};
	GType view_type_type_id;
	view_type_type_id = g_enum_register_static ("ViewType", values);
	return view_type_type_id;
}

GType
view_type_get_type (void)
{
	static volatile gsize view_type_type_id__once = 0;
	if (g_once_init_enter (&view_type_type_id__once)) {
		GType view_type_type_id;
		view_type_type_id = view_type_get_type_once ();
		g_once_init_leave (&view_type_type_id__once, view_type_type_id);
	}
	return view_type_type_id__once;
}

static inline gpointer
browser_window_get_instance_private (BrowserWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BrowserWindow_private_offset);
}

static void
_browser_window_empty_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	browser_window_empty ((BrowserWindow*) self);
}

static void
_browser_window_open_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_open_folder ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_open_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_open_object ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_open_config_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_open_config ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_open_config_local_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	browser_window_open_config_local ((BrowserWindow*) self);
}

static void
_browser_window_open_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_open_search ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_open_search_local_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	browser_window_open_search_local ((BrowserWindow*) self);
}

static void
_browser_window_open_search_global_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	browser_window_open_search_global ((BrowserWindow*) self);
}

static void
_browser_window_open_search_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	browser_window_open_search_root ((BrowserWindow*) self);
}

static void
_browser_window_next_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_next_search ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_open_parent_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_open_parent ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_open_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	browser_window_open_path ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_reload_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_reload_folder ((BrowserWindow*) self);
}

static void
_browser_window_reload_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_reload_object ((BrowserWindow*) self);
}

static void
_browser_window_reload_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_reload_search ((BrowserWindow*) self);
}

static void
_browser_window_hide_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_hide_search ((BrowserWindow*) self);
}

static void
_browser_window_show_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	browser_window_show_search ((BrowserWindow*) self);
}

static void
_browser_window_toggle_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_toggle_search ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_search_changed_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	browser_window_search_changed ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_next_match_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	browser_window_next_match ((BrowserWindow*) self);
}

static void
_browser_window_previous_match_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	browser_window_previous_match ((BrowserWindow*) self);
}

static void
_browser_window_toggle_config_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_toggle_config ((BrowserWindow*) self);
}

static void
_browser_window_search_global_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_search_global ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_search_local_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	browser_window_search_local ((BrowserWindow*) self, action, parameter);
}

static void
_browser_window_edit_path_end_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	browser_window_edit_path_end ((BrowserWindow*) self);
}

static void
_browser_window_edit_path_last_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	browser_window_edit_path_last ((BrowserWindow*) self);
}

static void
_browser_window_open_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	browser_window_open_root ((BrowserWindow*) self);
}

static void
_browser_window_open_current_parent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	browser_window_open_current_parent ((BrowserWindow*) self);
}

static void
_browser_window_open_child_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	browser_window_open_child ((BrowserWindow*) self);
}

static void
_browser_window_open_last_child_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	browser_window_open_last_child ((BrowserWindow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
browser_window_install_browser_action_entries (BrowserWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BROWSER_WINDOW_browser_action_entries, (gint) G_N_ELEMENTS (BROWSER_WINDOW_browser_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "browser", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "disabled-state-s");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->disabled_state_action);
	self->priv->disabled_state_action = _tmp2_;
	_tmp3_ = self->priv->disabled_state_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) action_group, "disabled-state-sq");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->disabled_state_action);
	self->priv->disabled_state_action = _tmp5_;
	_tmp6_ = self->priv->disabled_state_action;
	g_simple_action_set_enabled (_tmp6_, FALSE);
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) action_group, "open-path");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->open_path_action);
	self->priv->open_path_action = _tmp8_;
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) action_group, "reload-search");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->reload_search_action);
	self->reload_search_action = _tmp10_;
	_tmp11_ = self->reload_search_action;
	g_simple_action_set_enabled (_tmp11_, FALSE);
	_g_object_unref0 (action_group);
}

static void
browser_window_empty (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
}

static void
browser_window_open_folder (BrowserWindow* self,
                            GSimpleAction* action,
                            GVariant* path_variant)
{
	gchar* full_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	base_window_close_in_window_panels ((BaseWindow*) self);
	_tmp0_ = g_variant_get_string ((GVariant*) path_variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	full_name = _tmp1_;
	browser_window_request_folder (self, full_name, "", TRUE);
	_g_free0 (full_name);
}

static void
browser_window_open_object (BrowserWindow* self,
                            GSimpleAction* action,
                            GVariant* path_variant)
{
	gchar* full_name = NULL;
	guint16 context_id = 0U;
	gchar* _tmp0_ = NULL;
	guint16 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	base_window_close_in_window_panels ((BaseWindow*) self);
	g_variant_get ((GVariant*) path_variant, "(sq)", &_tmp0_, &_tmp1_, NULL);
	_g_free0 (full_name);
	full_name = _tmp0_;
	context_id = _tmp1_;
	browser_window_request_object (self, full_name, context_id, TRUE, "");
	_g_free0 (full_name);
}

static void
browser_window_open_config (BrowserWindow* self,
                            GSimpleAction* action,
                            GVariant* path_variant)
{
	BrowserHeaderBar* _tmp0_;
	gchar* full_name = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers ((BaseHeaderBar*) _tmp0_);
	_tmp1_ = g_variant_get_string ((GVariant*) path_variant, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	full_name = _tmp2_;
	browser_window_request_config (self, full_name);
	_g_free0 (full_name);
}

static void
browser_window_open_config_local (BrowserWindow* self)
{
	BrowserHeaderBar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers ((BaseHeaderBar*) _tmp0_);
	_tmp1_ = self->current_path;
	browser_window_request_config (self, _tmp1_);
}

static void
browser_window_open_search (BrowserWindow* self,
                            GSimpleAction* action,
                            GVariant* search_variant)
{
	gchar* search = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (search_variant != NULL, "search_variant != null");
	base_window_close_in_window_panels ((BaseWindow*) self);
	_tmp0_ = g_variant_get_string ((GVariant*) search_variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	search = _tmp1_;
	self->priv->init_next_search = TRUE;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL, search, FALSE);
	_g_free0 (search);
}

static void
browser_window_open_search_local (BrowserWindow* self)
{
	BrowserView* _tmp0_;
	ViewType _tmp1_;
	ViewType _tmp2_;
	g_return_if_fail (self != NULL);
	base_window_close_in_window_panels ((BaseWindow*) self);
	self->priv->init_next_search = TRUE;
	_tmp0_ = self->priv->main_view;
	_tmp1_ = browser_view_get_current_view (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VIEW_TYPE_SEARCH) {
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, TRUE);
	} else {
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, TRUE);
	}
}

static void
browser_window_open_search_global (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	base_window_close_in_window_panels ((BaseWindow*) self);
	self->priv->init_next_search = TRUE;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, FALSE);
}

static void
browser_window_open_search_root (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	base_window_close_in_window_panels ((BaseWindow*) self);
	self->priv->init_next_search = TRUE;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, "/", FALSE);
}

static void
browser_window_next_search (BrowserWindow* self,
                            GSimpleAction* action,
                            GVariant* search_variant)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (search_variant != NULL, "search_variant != null");
	self->saved_type = VIEW_TYPE_FOLDER;
	_tmp0_ = g_variant_get_string ((GVariant*) search_variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->saved_view);
	self->saved_view = _tmp1_;
	self->priv->init_next_search = TRUE;
	_tmp2_ = self->saved_view;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, _tmp2_, FALSE);
}

static void
browser_window_open_parent (BrowserWindow* self,
                            GSimpleAction* action,
                            GVariant* path_variant)
{
	gchar* full_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	base_window_close_in_window_panels ((BaseWindow*) self);
	_tmp0_ = g_variant_get_string ((GVariant*) path_variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	full_name = _tmp1_;
	_tmp2_ = model_utils_get_parent_path (full_name);
	_tmp3_ = _tmp2_;
	browser_window_request_folder (self, _tmp3_, full_name, TRUE);
	_g_free0 (_tmp3_);
	_g_free0 (full_name);
}

static void
browser_window_open_path (BrowserWindow* self,
                          GSimpleAction* action,
                          GVariant* path_variant)
{
	gchar* full_name = NULL;
	guint16 context_id = 0U;
	gchar* _tmp0_ = NULL;
	guint16 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	base_window_close_in_window_panels ((BaseWindow*) self);
	g_variant_get ((GVariant*) path_variant, "(sq)", &_tmp0_, &_tmp1_, NULL);
	_g_free0 (full_name);
	full_name = _tmp0_;
	context_id = _tmp1_;
	g_simple_action_set_state (action, (GVariant*) path_variant);
	if (model_utils_is_folder_context_id (context_id)) {
		const gchar* _tmp2_;
		_tmp2_ = full_name;
		browser_window_request_folder (self, _tmp2_, "", TRUE);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = full_name;
		browser_window_request_object (self, _tmp3_, context_id, TRUE, "");
	}
	_g_free0 (full_name);
}

static void
browser_window_reload_folder (BrowserWindow* self)
{
	const gchar* _tmp0_;
	BrowserView* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->current_path;
	_tmp1_ = self->priv->main_view;
	_tmp2_ = browser_view_get_selected_row_name (_tmp1_);
	_tmp3_ = _tmp2_;
	browser_window_request_folder (self, _tmp0_, _tmp3_, TRUE);
	_g_free0 (_tmp3_);
}

static void
browser_window_reload_object (BrowserWindow* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->current_path;
	browser_window_request_object (self, _tmp0_, MODEL_UTILS_undefined_context_id, FALSE, "");
}

static void
browser_window_reload_search (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	self->priv->init_next_search = TRUE;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, FALSE);
}

static void
browser_window_hide_search (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	browser_window_stop_search (self);
}

void
browser_window_stop_search (BrowserWindow* self)
{
	BrowserHeaderBar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BrowserView* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = browser_header_bar_get_search_mode_enabled (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->main_view;
	browser_view_row_grab_focus (_tmp3_);
	_tmp4_ = self->reload_search_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	if (self->saved_type == VIEW_TYPE_FOLDER) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->saved_view;
		_tmp6_ = self->saved_selection;
		browser_window_request_folder (self, _tmp5_, _tmp6_, TRUE);
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->saved_view;
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = _tmp8_;
		browser_window_update_current_path (self, self->saved_type, _tmp9_);
		_g_free0 (_tmp9_);
	}
	self->priv->init_next_search = TRUE;
}

static void
browser_window_show_search (BrowserWindow* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->init_next_search = TRUE;
	_tmp0_ = self->current_path;
	if (g_strcmp0 (_tmp0_, "/") == 0) {
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, FALSE);
	} else {
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL, NULL, FALSE);
	}
}

static GVariant*
_variant_new8 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
browser_window_toggle_search (BrowserWindow* self,
                              GSimpleAction* action,
                              GVariant* path_variant)
{
	gboolean search_request = FALSE;
	GVariant* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	search_request = g_variant_get_boolean ((GVariant*) path_variant);
	_tmp0_ = _variant_new8 (search_request);
	g_signal_emit_by_name (action, "change-state", _tmp0_);
	_g_variant_unref0 (_tmp0_);
	if (search_request) {
		BrowserHeaderBar* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->headerbar;
		_tmp3_ = browser_header_bar_get_search_mode_enabled (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_;
		self->priv->init_next_search = TRUE;
		_tmp5_ = self->current_path;
		if (g_strcmp0 (_tmp5_, "/") == 0) {
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, FALSE);
		} else {
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL, NULL, FALSE);
		}
	} else {
		gboolean _tmp6_ = FALSE;
		if (!search_request) {
			BrowserHeaderBar* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = self->priv->headerbar;
			_tmp8_ = browser_header_bar_get_search_mode_enabled (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp6_ = _tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			browser_window_stop_search (self);
		}
	}
}

static void
browser_window_search_changed (BrowserWindow* self,
                               GSimpleAction* action,
                               GVariant* path_variant)
{
	GVariant* variant = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	_tmp0_ = g_variant_get_maybe ((GVariant*) path_variant);
	variant = _tmp0_;
	_tmp1_ = variant;
	if (_tmp1_ == NULL) {
		browser_window_stop_search (self);
	} else {
		GVariant* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = variant;
		_tmp3_ = g_variant_get_string ((GVariant*) _tmp2_, NULL);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->last_search_entry_text);
		self->priv->last_search_entry_text = _tmp4_;
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, FALSE);
	}
	_g_variant_unref0 (variant);
}

void
browser_window_update_current_path (BrowserWindow* self,
                                    ViewType type,
                                    const gchar* path)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gchar* _tmp7_;
	BrowserView* _tmp8_;
	BrowserHeaderBar* _tmp9_;
	guint16 _tmp10_ = 0U;
	gboolean _tmp11_ = FALSE;
	GVariant* variant = NULL;
	GVariant* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (type == VIEW_TYPE_OBJECT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == VIEW_TYPE_FOLDER;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		self->saved_type = type;
		_tmp1_ = g_strdup (path);
		_g_free0 (self->saved_view);
		self->saved_view = _tmp1_;
		self->priv->init_next_search = TRUE;
	} else {
		if (self->current_type == VIEW_TYPE_FOLDER) {
			BrowserView* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->main_view;
			_tmp3_ = browser_view_get_selected_row_name (_tmp2_);
			_g_free0 (self->saved_selection);
			self->saved_selection = _tmp3_;
		} else {
			if (self->current_type == VIEW_TYPE_OBJECT) {
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("");
				_g_free0 (self->saved_selection);
				self->saved_selection = _tmp4_;
			}
		}
	}
	if (type == VIEW_TYPE_SEARCH) {
		_tmp5_ = g_strcmp0 (path, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (path);
		_g_free0 (self->priv->last_non_empty_search);
		self->priv->last_non_empty_search = _tmp6_;
	}
	self->current_type = type;
	_tmp7_ = g_strdup (path);
	_g_free0 (self->current_path);
	self->current_path = _tmp7_;
	_tmp8_ = self->priv->main_view;
	browser_view_set_path (_tmp8_, type, path);
	_tmp9_ = self->priv->headerbar;
	browser_header_bar_set_path (_tmp9_, type, path);
	if (type == VIEW_TYPE_FOLDER) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = type == VIEW_TYPE_CONFIG;
	}
	if (_tmp11_) {
		_tmp10_ = MODEL_UTILS_folder_context_id;
	} else {
		_tmp10_ = MODEL_UTILS_undefined_context_id;
	}
	_tmp12_ = g_variant_new ("(sq)", path, _tmp10_, NULL);
	g_variant_ref_sink (_tmp12_);
	variant = _tmp12_;
	_tmp13_ = self->priv->open_path_action;
	g_simple_action_set_state (_tmp13_, variant);
	_tmp14_ = self->priv->disabled_state_action;
	g_simple_action_set_state (_tmp14_, variant);
	_g_variant_unref0 (variant);
}

static void
browser_window_real_request_folder (BrowserWindow* self,
                                    const gchar* full_name,
                                    const gchar* selected_or_empty,
                                    gboolean notify_missing)
{
	g_critical ("Type `%s' does not implement abstract method `browser_window_request_folder'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
browser_window_request_folder (BrowserWindow* self,
                               const gchar* full_name,
                               const gchar* selected_or_empty,
                               gboolean notify_missing)
{
	BrowserWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BROWSER_WINDOW_GET_CLASS (self);
	if (_klass_->request_folder) {
		_klass_->request_folder (self, full_name, selected_or_empty, notify_missing);
	}
}

static void
browser_window_real_request_object (BrowserWindow* self,
                                    const gchar* full_name,
                                    guint16 context_id,
                                    gboolean notify_missing,
                                    const gchar* schema_id)
{
	g_critical ("Type `%s' does not implement abstract method `browser_window_request_object'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
browser_window_request_object (BrowserWindow* self,
                               const gchar* full_name,
                               guint16 context_id,
                               gboolean notify_missing,
                               const gchar* schema_id)
{
	BrowserWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BROWSER_WINDOW_GET_CLASS (self);
	if (_klass_->request_object) {
		_klass_->request_object (self, full_name, context_id, notify_missing, schema_id);
	}
}

static void
browser_window_real_request_config (BrowserWindow* self,
                                    const gchar* full_name)
{
	g_critical ("Type `%s' does not implement abstract method `browser_window_request_config'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
browser_window_request_config (BrowserWindow* self,
                               const gchar* full_name)
{
	BrowserWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BROWSER_WINDOW_GET_CLASS (self);
	if (_klass_->request_config) {
		_klass_->request_config (self, full_name);
	}
}

static void
browser_window_request_search (BrowserWindow* self,
                               PathEntrySearchMode mode,
                               const gchar* search,
                               gboolean local_search)
{
	gchar* selected_row = NULL;
	BrowserView* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp3_ = NULL;
	gchar* search_text = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	_tmp1_ = browser_view_get_selected_row_name (_tmp0_);
	selected_row = _tmp1_;
	if (self->priv->init_next_search) {
		browser_window_init_search (self, local_search);
	}
	if (mode != PATH_ENTRY_SEARCH_MODE_UNCLEAR) {
		BrowserHeaderBar* _tmp2_;
		_tmp2_ = self->priv->headerbar;
		browser_header_bar_prepare_search (_tmp2_, mode, search);
	}
	if (search == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->last_search_entry_text;
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = (const gchar*) search;
	}
	_tmp5_ = g_strdup (_tmp3_);
	search_text = _tmp5_;
	_tmp6_ = search_text;
	browser_window_update_current_path (self, VIEW_TYPE_SEARCH, _tmp6_);
	if (mode != PATH_ENTRY_SEARCH_MODE_UNCLEAR) {
		BrowserView* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->main_view;
		_tmp8_ = selected_row;
		browser_view_select_row (_tmp7_, _tmp8_);
	}
	if (!browser_window_search_entry_has_focus (self)) {
		BrowserHeaderBar* _tmp9_;
		_tmp9_ = self->priv->headerbar;
		browser_header_bar_entry_grab_focus (_tmp9_, FALSE);
	}
	_g_free0 (search_text);
	_g_free0 (selected_row);
}

static void
browser_window_init_search (BrowserWindow* self,
                            gboolean local_search)
{
	GSimpleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->reload_search_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	browser_window_reconfigure_search (self, local_search);
	self->priv->search_is_local = local_search;
	self->priv->init_next_search = FALSE;
}

static void
browser_window_real_reconfigure_search (BrowserWindow* self,
                                        gboolean local_search)
{
	g_critical ("Type `%s' does not implement abstract method `browser_window_reconfigure_search'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
browser_window_reconfigure_search (BrowserWindow* self,
                                   gboolean local_search)
{
	BrowserWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BROWSER_WINDOW_GET_CLASS (self);
	if (_klass_->reconfigure_search) {
		_klass_->reconfigure_search (self, local_search);
	}
}

static gboolean
browser_window_search_entry_has_focus (BrowserWindow* self)
{
	GtkWidget* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_window_get_focus ((GtkWindow*) self);
	result = IS_BROWSER_ENTRY (_tmp0_);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
browser_window_is_path_invalid (const gchar* path)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	if (g_str_has_prefix (path, "/")) {
		gboolean _tmp1_ = FALSE;
		if (string_contains (path, "//")) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = string_contains (path, " ");
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
browser_window_is_in_in_window_mode (BrowserWindow* self)
{
	gboolean _tmp0_ = FALSE;
	BrowserView* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->main_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		BrowserHeaderBar* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->headerbar;
		_tmp3_ = browser_header_bar_get_in_window_properties (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gboolean
browser_window_row_action_blocked (BrowserWindow* self)
{
	BrowserHeaderBar* _tmp0_;
	BrowserView* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->headerbar;
	if (base_header_bar_has_popover ((BaseHeaderBar*) _tmp0_)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->main_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp1_)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
browser_window_real_escape_pressed (BaseWindow* base)
{
	BrowserWindow * self;
	BrowserHeaderBar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BrowserHeaderBar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	self = (BrowserWindow*) base;
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = browser_header_bar_get_in_window_properties (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		base_window_show_default_view ((BaseWindow*) self);
		result = TRUE;
		return result;
	}
	if (BASE_WINDOW_CLASS (browser_window_parent_class)->escape_pressed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_WINDOW, BaseWindow))) {
		result = TRUE;
		return result;
	}
	if (self->current_type == VIEW_TYPE_CONFIG) {
		const gchar* _tmp3_;
		_tmp3_ = self->current_path;
		browser_window_request_folder (self, _tmp3_, "", TRUE);
		result = TRUE;
		return result;
	}
	_tmp4_ = self->priv->headerbar;
	_tmp5_ = browser_header_bar_get_search_mode_enabled (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		browser_window_stop_search (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
browser_window_real_show_default_view (BaseWindow* base)
{
	BrowserWindow * self;
	BrowserHeaderBar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (BrowserWindow*) base;
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = browser_header_bar_get_in_window_properties (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		const gchar* _tmp3_;
		_tmp3_ = self->current_path;
		browser_window_request_folder (self, _tmp3_, "", TRUE);
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = base_window_get_in_window_about ((BaseWindow*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			BASE_WINDOW_CLASS (browser_window_parent_class)->show_default_view (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_WINDOW, BaseWindow));
			if (self->current_type == VIEW_TYPE_CONFIG) {
				const gchar* _tmp6_;
				_tmp6_ = self->current_path;
				browser_window_request_folder (self, _tmp6_, "", TRUE);
			}
		} else {
			BASE_WINDOW_CLASS (browser_window_parent_class)->show_default_view (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_WINDOW, BaseWindow));
		}
	}
}

static void
browser_window_go_backward (BrowserWindow* self,
                            gboolean shift)
{
	BrowserHeaderBar* _tmp0_;
	BrowserView* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	if (browser_window_is_in_in_window_mode (self)) {
		return;
	}
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers ((BaseHeaderBar*) _tmp0_);
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp1_);
	_tmp3_ = self->current_path;
	if (g_strcmp0 (_tmp3_, BROWSER_WINDOW_root_path) == 0) {
		BrowserView* _tmp4_;
		ViewType _tmp5_;
		ViewType _tmp6_;
		_tmp4_ = self->priv->main_view;
		_tmp5_ = browser_view_get_current_view (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != VIEW_TYPE_CONFIG;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	if (shift) {
		BrowserView* _tmp7_;
		ViewType _tmp8_;
		ViewType _tmp9_;
		_tmp7_ = self->priv->main_view;
		_tmp8_ = browser_view_get_current_view (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == VIEW_TYPE_SEARCH) {
			self->priv->init_next_search = TRUE;
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, "/", FALSE);
		} else {
			browser_window_request_folder (self, BROWSER_WINDOW_root_path, "", TRUE);
		}
	} else {
		BrowserView* _tmp10_;
		ViewType _tmp11_;
		ViewType _tmp12_;
		_tmp10_ = self->priv->main_view;
		_tmp11_ = browser_view_get_current_view (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VIEW_TYPE_SEARCH) {
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			self->priv->init_next_search = TRUE;
			_tmp13_ = self->current_path;
			_tmp14_ = model_utils_get_parent_path (_tmp13_);
			_tmp15_ = _tmp14_;
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, _tmp15_, FALSE);
			_g_free0 (_tmp15_);
		} else {
			BrowserView* _tmp16_;
			ViewType _tmp17_;
			ViewType _tmp18_;
			_tmp16_ = self->priv->main_view;
			_tmp17_ = browser_view_get_current_view (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == VIEW_TYPE_CONFIG) {
				const gchar* _tmp19_;
				_tmp19_ = self->current_path;
				browser_window_request_folder (self, _tmp19_, "", TRUE);
			} else {
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp20_ = self->current_path;
				_tmp21_ = model_utils_get_parent_path (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->current_path;
				_tmp24_ = g_strdup (_tmp23_);
				_tmp25_ = _tmp24_;
				browser_window_request_folder (self, _tmp22_, _tmp25_, TRUE);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
			}
		}
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
browser_window_go_forward (BrowserWindow* self,
                           gboolean shift)
{
	BrowserHeaderBar* _tmp0_;
	BrowserView* _tmp1_;
	BrowserView* _tmp2_;
	ViewType _tmp3_;
	ViewType _tmp4_;
	gchar* fallback_path = NULL;
	gchar* complete_path = NULL;
	BrowserHeaderBar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	if (browser_window_is_in_in_window_mode (self)) {
		return;
	}
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers ((BaseHeaderBar*) _tmp0_);
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp1_);
	_tmp2_ = self->priv->main_view;
	_tmp3_ = browser_view_get_current_view (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == VIEW_TYPE_SEARCH) {
		self->priv->init_next_search = FALSE;
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, NULL, FALSE);
		return;
	}
	_tmp5_ = self->priv->headerbar;
	browser_header_bar_get_fallback_path_and_complete_path (_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (fallback_path);
	fallback_path = _tmp6_;
	_g_free0 (complete_path);
	complete_path = _tmp7_;
	_tmp8_ = self->current_path;
	_tmp9_ = complete_path;
	if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
		_g_free0 (complete_path);
		_g_free0 (fallback_path);
		return;
	}
	if (shift) {
		const gchar* _tmp10_;
		_tmp10_ = fallback_path;
		if (model_utils_is_key_path (_tmp10_)) {
			const gchar* _tmp11_;
			_tmp11_ = fallback_path;
			browser_window_request_object (self, _tmp11_, MODEL_UTILS_undefined_context_id, TRUE, "");
		} else {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = fallback_path;
			_tmp13_ = self->current_path;
			if (g_strcmp0 (_tmp12_, _tmp13_) != 0) {
				const gchar* _tmp14_;
				_tmp14_ = fallback_path;
				browser_window_request_folder (self, _tmp14_, "", TRUE);
			} else {
				const gchar* _tmp15_;
				_tmp15_ = complete_path;
				if (model_utils_is_key_path (_tmp15_)) {
					const gchar* _tmp16_;
					_tmp16_ = complete_path;
					browser_window_request_object (self, _tmp16_, MODEL_UTILS_undefined_context_id, TRUE, "");
				} else {
					const gchar* _tmp17_;
					_tmp17_ = complete_path;
					browser_window_request_folder (self, _tmp17_, "", TRUE);
				}
			}
		}
	} else {
		gint index_of_last_slash = 0;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp18_ = complete_path;
		_tmp19_ = self->current_path;
		_tmp20_ = strlen ((const gchar*) _tmp19_);
		_tmp21_ = _tmp20_;
		index_of_last_slash = string_index_of (_tmp18_, "/", _tmp21_);
		if (index_of_last_slash != -1) {
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp22_ = complete_path;
			_tmp23_ = string_slice (_tmp22_, (glong) 0, (glong) (index_of_last_slash + 1));
			_tmp24_ = _tmp23_;
			browser_window_request_folder (self, _tmp24_, "", TRUE);
			_g_free0 (_tmp24_);
		} else {
			const gchar* _tmp25_;
			_tmp25_ = complete_path;
			if (model_utils_is_key_path (_tmp25_)) {
				const gchar* _tmp26_;
				_tmp26_ = complete_path;
				browser_window_request_object (self, _tmp26_, MODEL_UTILS_undefined_context_id, TRUE, "");
			} else {
				const gchar* _tmp27_;
				_tmp27_ = complete_path;
				browser_window_request_folder (self, _tmp27_, "", TRUE);
			}
		}
	}
	_g_free0 (complete_path);
	_g_free0 (fallback_path);
}

void
browser_window_reload_view (BrowserWindow* self)
{
	BrowserView* _tmp0_;
	ViewType _tmp1_;
	ViewType _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	_tmp1_ = browser_view_get_current_view (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VIEW_TYPE_FOLDER) {
		const gchar* _tmp3_;
		BrowserView* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->current_path;
		_tmp4_ = self->priv->main_view;
		_tmp5_ = browser_view_get_selected_row_name (_tmp4_);
		_tmp6_ = _tmp5_;
		browser_window_request_folder (self, _tmp3_, _tmp6_, TRUE);
		_g_free0 (_tmp6_);
	} else {
		BrowserView* _tmp7_;
		ViewType _tmp8_;
		ViewType _tmp9_;
		_tmp7_ = self->priv->main_view;
		_tmp8_ = browser_view_get_current_view (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == VIEW_TYPE_OBJECT) {
			const gchar* _tmp10_;
			_tmp10_ = self->current_path;
			browser_window_request_object (self, _tmp10_, MODEL_UTILS_undefined_context_id, FALSE, "");
		} else {
			BrowserView* _tmp11_;
			ViewType _tmp12_;
			ViewType _tmp13_;
			_tmp11_ = self->priv->main_view;
			_tmp12_ = browser_view_get_current_view (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ == VIEW_TYPE_SEARCH) {
				self->priv->init_next_search = TRUE;
				browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, FALSE);
			}
		}
	}
}

static void
browser_window_install_key_action_entries (BrowserWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BROWSER_WINDOW_key_action_entries, (gint) G_N_ELEMENTS (BROWSER_WINDOW_key_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "key", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
}

static void
browser_window_next_match (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	_browser_window_next_match (self);
}

static void
browser_window_previous_match (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	_browser_window_previous_match (self);
}

static gboolean
_browser_window_next_match (BrowserWindow* self)
{
	gboolean interception_result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = browser_window_intercept_next_match (self, &_tmp0_);
	interception_result = _tmp0_;
	if (_tmp1_) {
		result = interception_result;
		return result;
	} else {
		BrowserView* _tmp2_;
		_tmp2_ = self->priv->main_view;
		result = browser_view_next_match (_tmp2_);
		return result;
	}
}

static gboolean
_browser_window_previous_match (BrowserWindow* self)
{
	gboolean interception_result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = browser_window_intercept_previous_match (self, &_tmp0_);
	interception_result = _tmp0_;
	if (_tmp1_) {
		result = interception_result;
		return result;
	} else {
		BrowserView* _tmp2_;
		_tmp2_ = self->priv->main_view;
		result = browser_view_previous_match (_tmp2_);
		return result;
	}
}

static gboolean
browser_window_real_intercept_next_match (BrowserWindow* self,
                                          gboolean* interception_result)
{
	gboolean _vala_interception_result = FALSE;
	gboolean result;
	_vala_interception_result = FALSE;
	result = FALSE;
	if (interception_result) {
		*interception_result = _vala_interception_result;
	}
	return result;
}

gboolean
browser_window_intercept_next_match (BrowserWindow* self,
                                     gboolean* interception_result)
{
	BrowserWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BROWSER_WINDOW_GET_CLASS (self);
	if (_klass_->intercept_next_match) {
		return _klass_->intercept_next_match (self, interception_result);
	}
	return FALSE;
}

static gboolean
browser_window_real_intercept_previous_match (BrowserWindow* self,
                                              gboolean* interception_result)
{
	gboolean _vala_interception_result = FALSE;
	gboolean result;
	_vala_interception_result = FALSE;
	result = FALSE;
	if (interception_result) {
		*interception_result = _vala_interception_result;
	}
	return result;
}

gboolean
browser_window_intercept_previous_match (BrowserWindow* self,
                                         gboolean* interception_result)
{
	BrowserWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BROWSER_WINDOW_GET_CLASS (self);
	if (_klass_->intercept_previous_match) {
		return _klass_->intercept_previous_match (self, interception_result);
	}
	return FALSE;
}

static void
browser_window_toggle_config (BrowserWindow* self)
{
	BrowserView* _tmp0_;
	ViewType _tmp1_;
	ViewType _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	_tmp1_ = browser_view_get_current_view (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VIEW_TYPE_CONFIG) {
		const gchar* _tmp3_;
		_tmp3_ = self->current_path;
		browser_window_request_folder (self, _tmp3_, "", TRUE);
	} else {
		BrowserView* _tmp4_;
		_tmp4_ = self->priv->main_view;
		if (base_view_is_in_in_window_mode ((BaseView*) _tmp4_)) {
			return;
		} else {
			BrowserView* _tmp5_;
			ViewType _tmp6_;
			ViewType _tmp7_;
			_tmp5_ = self->priv->main_view;
			_tmp6_ = browser_view_get_current_view (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ == VIEW_TYPE_FOLDER) {
				const gchar* _tmp8_;
				_tmp8_ = self->current_path;
				browser_window_request_config (self, _tmp8_);
			}
		}
	}
}

static void
browser_window_search_global (BrowserWindow* self,
                              GSimpleAction* action,
                              GVariant* variant)
{
	BrowserHeaderBar* _tmp0_;
	BrowserView* _tmp1_;
	BrowserHeaderBar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	if (browser_window_is_in_in_window_mode (self)) {
		return;
	}
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers ((BaseHeaderBar*) _tmp0_);
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp1_);
	_tmp2_ = self->priv->headerbar;
	_tmp3_ = browser_header_bar_get_search_mode_enabled (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		self->priv->init_next_search = TRUE;
		if (g_variant_get_boolean ((GVariant*) variant)) {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->last_non_empty_search;
			_tmp5_ = g_strcmp0 (_tmp6_, "") != 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			const gchar* _tmp7_;
			_tmp7_ = self->priv->last_non_empty_search;
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL, _tmp7_, FALSE);
		} else {
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, FALSE);
		}
	} else {
		if (!browser_window_search_entry_has_focus (self)) {
			BrowserHeaderBar* _tmp8_;
			_tmp8_ = self->priv->headerbar;
			browser_header_bar_entry_grab_focus (_tmp8_, TRUE);
		} else {
			if (self->priv->search_is_local) {
				self->priv->init_next_search = TRUE;
				browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, FALSE);
			} else {
				const gchar* _tmp9_;
				_tmp9_ = self->priv->last_search_entry_text;
				if (g_str_has_prefix (_tmp9_, "/")) {
					self->priv->init_next_search = TRUE;
					browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, FALSE);
				} else {
					browser_window_stop_search (self);
				}
			}
		}
	}
}

static void
browser_window_search_local (BrowserWindow* self,
                             GSimpleAction* action,
                             GVariant* variant)
{
	BrowserHeaderBar* _tmp0_;
	BrowserView* _tmp1_;
	BrowserHeaderBar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	if (browser_window_is_in_in_window_mode (self)) {
		return;
	}
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers ((BaseHeaderBar*) _tmp0_);
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp1_);
	_tmp2_ = self->priv->headerbar;
	_tmp3_ = browser_header_bar_get_search_mode_enabled (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		self->priv->init_next_search = TRUE;
		if (g_variant_get_boolean ((GVariant*) variant)) {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->last_non_empty_search;
			_tmp5_ = g_strcmp0 (_tmp6_, "") != 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->last_non_empty_search;
			_tmp8_ = self->current_path;
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL, _tmp7_, g_strcmp0 (_tmp8_, "/") != 0);
		} else {
			const gchar* _tmp9_;
			_tmp9_ = self->current_path;
			browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, g_strcmp0 (_tmp9_, "/") != 0);
		}
	} else {
		if (!browser_window_search_entry_has_focus (self)) {
			BrowserHeaderBar* _tmp10_;
			_tmp10_ = self->priv->headerbar;
			browser_header_bar_entry_grab_focus (_tmp10_, TRUE);
		} else {
			if (self->priv->search_is_local) {
				browser_window_stop_search (self);
			} else {
				const gchar* _tmp11_;
				_tmp11_ = self->priv->last_search_entry_text;
				if (g_str_has_prefix (_tmp11_, "/")) {
					self->priv->init_next_search = TRUE;
					browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, TRUE);
				} else {
					const gchar* _tmp12_;
					_tmp12_ = self->saved_view;
					if (g_strcmp0 (_tmp12_, BROWSER_WINDOW_root_path) != 0) {
						self->priv->init_next_search = TRUE;
						browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_UNCLEAR, NULL, TRUE);
					}
				}
			}
		}
	}
}

static void
browser_window_edit_path_end (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	if (browser_window_is_in_in_window_mode (self)) {
		return;
	}
	self->priv->init_next_search = TRUE;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, NULL, FALSE);
}

static void
browser_window_edit_path_last (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	if (browser_window_is_in_in_window_mode (self)) {
		return;
	}
	self->priv->init_next_search = TRUE;
	browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD, NULL, FALSE);
}

static void
browser_window_real_paste_text (BaseWindow* base,
                                const gchar* text)
{
	BrowserWindow * self;
	self = (BrowserWindow*) base;
	self->priv->init_next_search = TRUE;
	if (text != NULL) {
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, text, FALSE);
	} else {
		browser_window_request_search (self, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL, FALSE);
	}
}

static void
browser_window_open_root (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	browser_window_go_backward (self, TRUE);
}

static void
browser_window_open_current_parent (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	browser_window_go_backward (self, FALSE);
}

static void
browser_window_open_child (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	browser_window_go_forward (self, FALSE);
}

static void
browser_window_open_last_child (BrowserWindow* self)
{
	g_return_if_fail (self != NULL);
	browser_window_go_forward (self, TRUE);
}

static void
browser_window_real_menu_pressed (BaseWindow* base)
{
	BrowserWindow * self;
	BrowserView* _tmp0_;
	self = (BrowserWindow*) base;
	_tmp0_ = self->priv->main_view;
	if (browser_view_toggle_row_popover (_tmp0_)) {
		BrowserHeaderBar* _tmp1_;
		_tmp1_ = self->priv->headerbar;
		base_header_bar_close_popovers ((BaseHeaderBar*) _tmp1_);
	} else {
		BrowserHeaderBar* _tmp2_;
		BrowserView* _tmp3_;
		_tmp2_ = self->priv->headerbar;
		base_header_bar_toggle_hamburger_menu ((BaseHeaderBar*) _tmp2_);
		_tmp3_ = self->priv->main_view;
		base_view_close_popovers ((BaseView*) _tmp3_);
	}
}

static gboolean
browser_window_real_on_key_press_event (BaseWindow* base,
                                        GtkWidget* widget,
                                        GdkEventKey* event)
{
	BrowserWindow * self;
	guint keyval = 0U;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	BrowserHeaderBar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	BrowserHeaderBar* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GtkWidget* focus = NULL;
	GtkWidget* _tmp52_;
	GtkWidget* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GtkWidget* _tmp55_;
	gboolean focus_is_text_widget = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean result;
	self = (BrowserWindow*) base;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (BASE_WINDOW_CLASS (browser_window_parent_class)->on_key_press_event (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_WINDOW, BaseWindow), widget, event)) {
		result = TRUE;
		return result;
	}
	keyval = event->keyval;
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp2_;
	if (keyval == GDK_KEY_Tab) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = keyval == GDK_KEY_KP_Tab;
	}
	if (_tmp3_) {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_tmp5_ = name;
	if (g_strcmp0 (_tmp5_, "Down") == 0) {
		_tmp4_ = (event->state & GDK_MOD1_MASK) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = _browser_window_next_match (self);
		_g_free0 (name);
		return result;
	}
	_tmp7_ = name;
	if (g_strcmp0 (_tmp7_, "Up") == 0) {
		_tmp6_ = (event->state & GDK_MOD1_MASK) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = _browser_window_previous_match (self);
		_g_free0 (name);
		return result;
	}
	if (browser_window_is_in_in_window_mode (self)) {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_tmp9_ = name;
	if (g_strcmp0 (_tmp9_, "F10") == 0) {
		_tmp8_ = (event->state & GDK_SHIFT_MASK) != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GtkWidget* focus = NULL;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GtkWidget* _tmp13_;
		BrowserHeaderBar* _tmp17_;
		_tmp10_ = gtk_window_get_focus ((GtkWindow*) self);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		focus = _tmp11_;
		_tmp13_ = focus;
		if (_tmp13_ != NULL) {
			gboolean _tmp14_ = FALSE;
			GtkWidget* _tmp15_;
			_tmp15_ = focus;
			if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), gtk_entry_get_type ())) {
				_tmp14_ = TRUE;
			} else {
				GtkWidget* _tmp16_;
				_tmp16_ = focus;
				_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type ());
			}
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			result = FALSE;
			_g_object_unref0 (focus);
			_g_free0 (name);
			return result;
		}
		_tmp17_ = self->priv->headerbar;
		browser_header_bar_toggle_pathbar_menu (_tmp17_);
		result = TRUE;
		_g_object_unref0 (focus);
		_g_free0 (name);
		return result;
	}
	_tmp19_ = name;
	if (g_strcmp0 (_tmp19_, "Return") == 0) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = name;
		_tmp18_ = g_strcmp0 (_tmp20_, "KP_Enter") == 0;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		BrowserView* _tmp23_;
		ViewType _tmp24_;
		ViewType _tmp25_;
		_tmp23_ = self->priv->main_view;
		_tmp24_ = browser_view_get_current_view (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == VIEW_TYPE_SEARCH) {
			_tmp22_ = browser_window_search_entry_has_focus (self);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			BrowserView* _tmp26_;
			_tmp26_ = self->priv->main_view;
			_tmp21_ = browser_view_return_pressed (_tmp26_);
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			result = TRUE;
			_g_free0 (name);
			return result;
		}
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_tmp27_ = self->priv->headerbar;
	if (base_header_bar_has_popover ((BaseHeaderBar*) _tmp27_)) {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_tmp29_ = self->priv->headerbar;
	_tmp30_ = browser_header_bar_get_search_mode_enabled (_tmp29_);
	_tmp31_ = _tmp30_;
	if (!_tmp31_) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_ = FALSE;
		gboolean _tmp46_ = FALSE;
		gboolean _tmp47_ = FALSE;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_ = FALSE;
		if (keyval == GDK_KEY_Up) {
			_tmp49_ = TRUE;
		} else {
			_tmp49_ = keyval == GDK_KEY_KP_Up;
		}
		if (_tmp49_) {
			_tmp48_ = TRUE;
		} else {
			_tmp48_ = keyval == GDK_KEY_Down;
		}
		if (_tmp48_) {
			_tmp47_ = TRUE;
		} else {
			_tmp47_ = keyval == GDK_KEY_KP_Down;
		}
		if (_tmp47_) {
			_tmp46_ = TRUE;
		} else {
			_tmp46_ = keyval == GDK_KEY_Left;
		}
		if (_tmp46_) {
			_tmp45_ = TRUE;
		} else {
			_tmp45_ = keyval == GDK_KEY_KP_Left;
		}
		if (_tmp45_) {
			_tmp44_ = TRUE;
		} else {
			_tmp44_ = keyval == GDK_KEY_Right;
		}
		if (_tmp44_) {
			_tmp43_ = TRUE;
		} else {
			_tmp43_ = keyval == GDK_KEY_KP_Right;
		}
		if (_tmp43_) {
			_tmp42_ = TRUE;
		} else {
			_tmp42_ = keyval == GDK_KEY_Home;
		}
		if (_tmp42_) {
			_tmp41_ = TRUE;
		} else {
			_tmp41_ = keyval == GDK_KEY_KP_Home;
		}
		if (_tmp41_) {
			_tmp40_ = TRUE;
		} else {
			_tmp40_ = keyval == GDK_KEY_End;
		}
		if (_tmp40_) {
			_tmp39_ = TRUE;
		} else {
			_tmp39_ = keyval == GDK_KEY_KP_End;
		}
		if (_tmp39_) {
			_tmp38_ = TRUE;
		} else {
			_tmp38_ = keyval == GDK_KEY_Page_Up;
		}
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			_tmp37_ = keyval == GDK_KEY_KP_Page_Up;
		}
		if (_tmp37_) {
			_tmp36_ = TRUE;
		} else {
			_tmp36_ = keyval == GDK_KEY_Page_Down;
		}
		if (_tmp36_) {
			_tmp35_ = TRUE;
		} else {
			_tmp35_ = keyval == GDK_KEY_KP_Page_Down;
		}
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = (event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK)) != 0;
		}
		if (_tmp34_) {
			_tmp33_ = TRUE;
		} else {
			const gchar* _tmp50_;
			_tmp50_ = name;
			_tmp33_ = g_strcmp0 (_tmp50_, "space") == 0;
		}
		if (_tmp33_) {
			_tmp32_ = TRUE;
		} else {
			const gchar* _tmp51_;
			_tmp51_ = name;
			_tmp32_ = g_strcmp0 (_tmp51_, "KP_Space") == 0;
		}
		_tmp28_ = _tmp32_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_tmp52_ = gtk_window_get_focus ((GtkWindow*) self);
	_tmp53_ = _g_object_ref0 (_tmp52_);
	focus = _tmp53_;
	_tmp55_ = focus;
	if (_tmp55_ != NULL) {
		gboolean _tmp56_ = FALSE;
		GtkWidget* _tmp57_;
		_tmp57_ = focus;
		if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget), gtk_entry_get_type ())) {
			_tmp56_ = TRUE;
		} else {
			GtkWidget* _tmp58_;
			_tmp58_ = focus;
			_tmp56_ = G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type ());
		}
		_tmp54_ = _tmp56_;
	} else {
		_tmp54_ = FALSE;
	}
	focus_is_text_widget = _tmp54_;
	if (!focus_is_text_widget) {
		_tmp61_ = event->is_modifier == ((guint) 0);
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		_tmp60_ = event->length != 0;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		BrowserHeaderBar* _tmp62_;
		_tmp62_ = self->priv->headerbar;
		_tmp59_ = browser_header_bar_handle_event (_tmp62_, event);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		result = TRUE;
		_g_object_unref0 (focus);
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (focus);
	_g_free0 (name);
	return result;
}

static void
browser_window_bind_mouse_config (BrowserWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
	settings = _tmp0_;
	g_settings_bind (settings, "mouse-use-extra-buttons", (GObject*) self, "mouse-use-extra-buttons", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	g_settings_bind (settings, "mouse-back-button", (GObject*) self, "mouse-back-button", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	g_settings_bind (settings, "mouse-forward-button", (GObject*) self, "mouse-forward-button", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_g_object_unref0 (settings);
}

static gboolean
browser_window_on_button_press_event (GtkWidget* widget,
                                      GdkEventButton* event)
{
	BrowserWindow* _this = NULL;
	BrowserWindow* _tmp0_;
	BrowserWindow* _tmp1_;
	gboolean _tmp2_;
	BrowserWindow* _tmp3_;
	gint _tmp4_;
	BrowserWindow* _tmp10_;
	gint _tmp11_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, TYPE_BROWSER_WINDOW, BrowserWindow));
	_this = _tmp0_;
	_tmp1_ = _this;
	_tmp2_ = _tmp1_->priv->_mouse_use_extra_buttons;
	if (!_tmp2_) {
		result = FALSE;
		_g_object_unref0 (_this);
		return result;
	}
	_tmp3_ = _this;
	_tmp4_ = _tmp3_->priv->_mouse_back_button;
	if (event->button == ((guint) _tmp4_)) {
		BrowserWindow* _tmp5_;
		gint _tmp6_;
		BrowserWindow* _tmp7_;
		gint _tmp8_;
		BrowserWindow* _tmp9_;
		_tmp5_ = _this;
		_tmp6_ = _tmp5_->priv->_mouse_back_button;
		_tmp7_ = _this;
		_tmp8_ = _tmp7_->priv->_mouse_forward_button;
		if (_tmp6_ == _tmp8_) {
			g_warning ("browser-window.vala:906: %s", _ ("The same mouse button is set for going backward and forward. Doing not" \
"hing."));
			result = FALSE;
			_g_object_unref0 (_this);
			return result;
		}
		_tmp9_ = _this;
		browser_window_go_backward (_tmp9_, (event->state & GDK_SHIFT_MASK) != 0);
		result = TRUE;
		_g_object_unref0 (_this);
		return result;
	}
	_tmp10_ = _this;
	_tmp11_ = _tmp10_->priv->_mouse_forward_button;
	if (event->button == ((guint) _tmp11_)) {
		BrowserWindow* _tmp12_;
		_tmp12_ = _this;
		browser_window_go_forward (_tmp12_, (event->state & GDK_SHIFT_MASK) != 0);
		result = TRUE;
		_g_object_unref0 (_this);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (_this);
	return result;
}

BrowserWindow*
browser_window_construct (GType object_type)
{
	BrowserWindow * self = NULL;
	self = (BrowserWindow*) base_window_construct (object_type);
	return self;
}

static gboolean
browser_window_get_mouse_use_extra_buttons (BrowserWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mouse_use_extra_buttons;
	return result;
}

void
browser_window_set_mouse_use_extra_buttons (BrowserWindow* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_use_extra_buttons = value;
}

static gint
browser_window_get_mouse_back_button (BrowserWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mouse_back_button;
	return result;
}

void
browser_window_set_mouse_back_button (BrowserWindow* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_back_button = value;
}

static gint
browser_window_get_mouse_forward_button (BrowserWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mouse_forward_button;
	return result;
}

void
browser_window_set_mouse_forward_button (BrowserWindow* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_forward_button = value;
}

static gboolean
_browser_window_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = browser_window_on_button_press_event (_sender, event);
	return result;
}

static GObject *
browser_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BrowserWindow * self;
	NightTimeAwareHeaderBar* _tmp0_;
	NightTimeAwareHeaderBar* _tmp1_;
	BrowserHeaderBar* _tmp2_;
	BaseView* _tmp3_;
	BaseView* _tmp4_;
	BrowserView* _tmp5_;
	parent_class = G_OBJECT_CLASS (browser_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_WINDOW, BrowserWindow);
	_tmp0_ = adaptative_window_get_nta_headerbar ((AdaptativeWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp2_;
	_tmp3_ = base_window_get_base_view ((BaseWindow*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_BROWSER_VIEW, BrowserView));
	_g_object_unref0 (self->priv->main_view);
	self->priv->main_view = _tmp5_;
	g_signal_connect ((GtkWidget*) self, "button-press-event", (GCallback) _browser_window_on_button_press_event_gtk_widget_button_press_event, NULL);
	browser_window_install_browser_action_entries (self);
	browser_window_install_key_action_entries (self);
	browser_window_bind_mouse_config (self);
	return obj;
}

static void
browser_window_class_init (BrowserWindowClass * klass,
                           gpointer klass_data)
{
	browser_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BrowserWindow_private_offset);
	((BrowserWindowClass *) klass)->request_folder = (void (*) (BrowserWindow*, const gchar*, const gchar*, gboolean)) browser_window_real_request_folder;
	((BrowserWindowClass *) klass)->request_object = (void (*) (BrowserWindow*, const gchar*, guint16, gboolean, const gchar*)) browser_window_real_request_object;
	((BrowserWindowClass *) klass)->request_config = (void (*) (BrowserWindow*, const gchar*)) browser_window_real_request_config;
	((BrowserWindowClass *) klass)->reconfigure_search = (void (*) (BrowserWindow*, gboolean)) browser_window_real_reconfigure_search;
	((BaseWindowClass *) klass)->escape_pressed = (gboolean (*) (BaseWindow*)) browser_window_real_escape_pressed;
	((BaseWindowClass *) klass)->show_default_view = (void (*) (BaseWindow*)) browser_window_real_show_default_view;
	((BrowserWindowClass *) klass)->intercept_next_match = (gboolean (*) (BrowserWindow*, gboolean*)) browser_window_real_intercept_next_match;
	((BrowserWindowClass *) klass)->intercept_previous_match = (gboolean (*) (BrowserWindow*, gboolean*)) browser_window_real_intercept_previous_match;
	((BaseWindowClass *) klass)->paste_text = (void (*) (BaseWindow*, const gchar*)) browser_window_real_paste_text;
	((BaseWindowClass *) klass)->menu_pressed = (void (*) (BaseWindow*)) browser_window_real_menu_pressed;
	((BaseWindowClass *) klass)->on_key_press_event = (gboolean (*) (BaseWindow*, GtkWidget*, GdkEventKey*)) browser_window_real_on_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_browser_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_browser_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = browser_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_WINDOW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY, browser_window_properties[BROWSER_WINDOW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY] = g_param_spec_boolean ("mouse-use-extra-buttons", "mouse-use-extra-buttons", "mouse-use-extra-buttons", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_WINDOW_MOUSE_BACK_BUTTON_PROPERTY, browser_window_properties[BROWSER_WINDOW_MOUSE_BACK_BUTTON_PROPERTY] = g_param_spec_int ("mouse-back-button", "mouse-back-button", "mouse-back-button", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_WINDOW_MOUSE_FORWARD_BUTTON_PROPERTY, browser_window_properties[BROWSER_WINDOW_MOUSE_FORWARD_BUTTON_PROPERTY] = g_param_spec_int ("mouse-forward-button", "mouse-forward-button", "mouse-forward-button", G_MININT, G_MAXINT, 9, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
browser_window_instance_init (BrowserWindow * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = browser_window_get_instance_private (self);
	_tmp0_ = g_strdup (BROWSER_WINDOW_root_path);
	self->current_path = _tmp0_;
	self->current_type = VIEW_TYPE_FOLDER;
	self->saved_type = VIEW_TYPE_FOLDER;
	_tmp1_ = g_strdup ("/");
	self->saved_view = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->saved_selection = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->last_search_entry_text = _tmp3_;
	self->priv->init_next_search = TRUE;
	self->priv->search_is_local = FALSE;
	_tmp4_ = g_strdup ("");
	self->priv->last_non_empty_search = _tmp4_;
	self->priv->_mouse_use_extra_buttons = TRUE;
	self->priv->_mouse_back_button = 8;
	self->priv->_mouse_forward_button = 9;
}

static void
browser_window_finalize (GObject * obj)
{
	BrowserWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_WINDOW, BrowserWindow);
	_g_free0 (self->current_path);
	_g_free0 (self->saved_view);
	_g_free0 (self->saved_selection);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->main_view);
	_g_object_unref0 (self->priv->disabled_state_action);
	_g_object_unref0 (self->priv->open_path_action);
	_g_object_unref0 (self->reload_search_action);
	_g_free0 (self->priv->last_search_entry_text);
	_g_free0 (self->priv->last_non_empty_search);
	G_OBJECT_CLASS (browser_window_parent_class)->finalize (obj);
}

static GType
browser_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrowserWindow), 0, (GInstanceInitFunc) browser_window_instance_init, NULL };
	GType browser_window_type_id;
	browser_window_type_id = g_type_register_static (TYPE_BASE_WINDOW, "BrowserWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BrowserWindow_private_offset = g_type_add_instance_private (browser_window_type_id, sizeof (BrowserWindowPrivate));
	return browser_window_type_id;
}

GType
browser_window_get_type (void)
{
	static volatile gsize browser_window_type_id__once = 0;
	if (g_once_init_enter (&browser_window_type_id__once)) {
		GType browser_window_type_id;
		browser_window_type_id = browser_window_get_type_once ();
		g_once_init_leave (&browser_window_type_id__once, browser_window_type_id);
	}
	return browser_window_type_id__once;
}

static void
_vala_browser_window_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BrowserWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_WINDOW, BrowserWindow);
	switch (property_id) {
		case BROWSER_WINDOW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY:
		g_value_set_boolean (value, browser_window_get_mouse_use_extra_buttons (self));
		break;
		case BROWSER_WINDOW_MOUSE_BACK_BUTTON_PROPERTY:
		g_value_set_int (value, browser_window_get_mouse_back_button (self));
		break;
		case BROWSER_WINDOW_MOUSE_FORWARD_BUTTON_PROPERTY:
		g_value_set_int (value, browser_window_get_mouse_forward_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_browser_window_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BrowserWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_WINDOW, BrowserWindow);
	switch (property_id) {
		case BROWSER_WINDOW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY:
		browser_window_set_mouse_use_extra_buttons (self, g_value_get_boolean (value));
		break;
		case BROWSER_WINDOW_MOUSE_BACK_BUTTON_PROPERTY:
		browser_window_set_mouse_back_button (self, g_value_get_int (value));
		break;
		case BROWSER_WINDOW_MOUSE_FORWARD_BUTTON_PROPERTY:
		browser_window_set_mouse_forward_button (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

