
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "pluginproxy_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void PluginProxyWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::PluginProxy::EventHandlerType >("PluginProxy::EventHandlerType");
}

void PluginProxyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

PluginProxyWrapper::PluginProxyWrapper(QObject * parent) : PluginProxy(parent)
{
    resetPyMethodCache();
    // ... middle
}

void PluginProxyWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void PluginProxyWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void PluginProxyWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void PluginProxyWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool PluginProxyWrapper::event(QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PluginProxy.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool PluginProxyWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PluginProxy.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void PluginProxyWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *PluginProxyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return PluginProxy::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int PluginProxyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = PluginProxy::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *PluginProxyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< PluginProxyWrapper *>(this));
        return PluginProxy::qt_metacast(_clname);
}

PluginProxyWrapper::~PluginProxyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PluginProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PluginProxy >()))
        return -1;

    ::PluginProxyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:PluginProxy", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PluginProxy::PluginProxy(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // PluginProxy(QObject*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // PluginProxy(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxy_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_PluginProxy_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_PluginProxy_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                // fall through to handle extra keyword signals and properties
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // PluginProxy(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::PluginProxyWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::PluginProxyWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PluginProxy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_PluginProxy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_PluginProxy_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_PluginProxy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_PluginProxyFunc_acceptNavigationRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.acceptNavigationRequest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "acceptNavigationRequest", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX])->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
        overloadId = 0; // acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_acceptNavigationRequest_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QWebEnginePage::NavigationType cppArg2{QWebEnginePage::NavigationTypeLinkClicked};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
            bool cppResult = cppSelf->acceptNavigationRequest(cppArg0, *cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_acceptNavigationRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_emitMainWindowCreated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.emitMainWindowCreated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitMainWindowCreated(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), (pyArg)))) {
        overloadId = 0; // emitMainWindowCreated(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_emitMainWindowCreated_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // emitMainWindowCreated(BrowserWindow*)
            cppSelf->emitMainWindowCreated(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_emitMainWindowCreated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_emitMainWindowDeleted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.emitMainWindowDeleted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitMainWindowDeleted(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), (pyArg)))) {
        overloadId = 0; // emitMainWindowDeleted(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_emitMainWindowDeleted_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // emitMainWindowDeleted(BrowserWindow*)
            cppSelf->emitMainWindowDeleted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_emitMainWindowDeleted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_emitWebPageCreated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.emitWebPageCreated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitWebPageCreated(WebPage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyArg)))) {
        overloadId = 0; // emitWebPageCreated(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_emitWebPageCreated_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // emitWebPageCreated(WebPage*)
            cppSelf->emitWebPageCreated(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_emitWebPageCreated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_emitWebPageDeleted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.emitWebPageDeleted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitWebPageDeleted(WebPage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyArg)))) {
        overloadId = 0; // emitWebPageDeleted(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_emitWebPageDeleted_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // emitWebPageDeleted(WebPage*)
            cppSelf->emitWebPageDeleted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_emitWebPageDeleted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_pluginUnloaded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.pluginUnloaded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Plugins::pluginUnloaded(PluginInterface*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), (pyArg)))) {
        overloadId = 0; // pluginUnloaded(PluginInterface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_pluginUnloaded_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "pluginUnloaded(PluginInterface * plugin)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_pluginUnloaded_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_populateExtensionsMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.populateExtensionsMenu";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::populateExtensionsMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMENU_IDX]), (pyArg)))) {
        overloadId = 0; // populateExtensionsMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_populateExtensionsMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // populateExtensionsMenu(QMenu*)
            cppSelf->populateExtensionsMenu(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_populateExtensionsMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_populateWebViewMenu(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.populateWebViewMenu";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "populateWebViewMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMENU_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBVIEW_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_populateWebViewMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebView *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::WebHitTestResult cppArg2_local = ::WebHitTestResult(static_cast<::WebPage*>(nullptr), ::QPoint());
        ::WebHitTestResult *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
            cppSelf->populateWebViewMenu(cppArg0, cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_populateWebViewMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processKeyPress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processKeyPress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processKeyPress", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processKeyPress(Qz::ObjectName,QObject*,QKeyEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processKeyPress(Qz::ObjectName,QObject*,QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processKeyPress_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeyEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processKeyPress(Qz::ObjectName,QObject*,QKeyEvent*)
            bool cppResult = cppSelf->processKeyPress(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processKeyPress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processKeyRelease(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processKeyRelease";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processKeyRelease", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processKeyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processKeyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processKeyRelease_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeyEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processKeyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
            bool cppResult = cppSelf->processKeyRelease(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processKeyRelease_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processMouseDoubleClick(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processMouseDoubleClick";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processMouseDoubleClick", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processMouseDoubleClick_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processMouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMouseDoubleClick(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processMouseDoubleClick_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processMouseMove(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processMouseMove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processMouseMove", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processMouseMove_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processMouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMouseMove(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processMouseMove_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processMousePress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processMousePress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processMousePress", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMousePress(Qz::ObjectName,QObject*,QMouseEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMousePress(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processMousePress_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processMousePress(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMousePress(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processMousePress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processMouseRelease(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processMouseRelease";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processMouseRelease", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processMouseRelease_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processMouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMouseRelease(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processMouseRelease_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_processWheelEvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.processWheelEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "processWheelEvent", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processWheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_OBJECTNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processWheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_processWheelEvent_TypeError;

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWheelEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // processWheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
            bool cppResult = cppSelf->processWheelEvent(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PluginProxyFunc_processWheelEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PluginProxyFunc_registerAppEventHandler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginProxy.registerAppEventHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "registerAppEventHandler", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::registerAppEventHandler(PluginProxy::EventHandlerType,PluginInterface*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerAppEventHandler(PluginProxy::EventHandlerType,PluginInterface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginProxyFunc_registerAppEventHandler_TypeError;

    // Call function/method
    {
        ::PluginProxy::EventHandlerType cppArg0{PluginProxy::MouseDoubleClickHandler};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::PluginInterface *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerAppEventHandler(PluginProxy::EventHandlerType,PluginInterface*)
            cppSelf->registerAppEventHandler(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PluginProxyFunc_registerAppEventHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_PluginProxy_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PluginProxy_methods[] = {
    {"acceptNavigationRequest", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_acceptNavigationRequest), METH_VARARGS},
    {"emitMainWindowCreated", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitMainWindowCreated), METH_O},
    {"emitMainWindowDeleted", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitMainWindowDeleted), METH_O},
    {"emitWebPageCreated", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitWebPageCreated), METH_O},
    {"emitWebPageDeleted", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitWebPageDeleted), METH_O},
    {"pluginUnloaded", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_pluginUnloaded), METH_O},
    {"populateExtensionsMenu", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_populateExtensionsMenu), METH_O},
    {"populateWebViewMenu", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_populateWebViewMenu), METH_VARARGS},
    {"processKeyPress", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processKeyPress), METH_VARARGS},
    {"processKeyRelease", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processKeyRelease), METH_VARARGS},
    {"processMouseDoubleClick", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMouseDoubleClick), METH_VARARGS},
    {"processMouseMove", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMouseMove), METH_VARARGS},
    {"processMousePress", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMousePress), METH_VARARGS},
    {"processMouseRelease", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMouseRelease), METH_VARARGS},
    {"processWheelEvent", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processWheelEvent), METH_VARARGS},
    {"registerAppEventHandler", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_registerAppEventHandler), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_PluginProxy_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<PluginProxyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PluginProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_PluginProxy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_PluginProxy_Type = nullptr;
static SbkObjectType *Sbk_PluginProxy_TypeF(void)
{
    return _Sbk_PluginProxy_Type;
}

static PyType_Slot Sbk_PluginProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PluginProxy_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PluginProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PluginProxy_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PluginProxy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PluginProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_PluginProxy_spec = {
    "1:PyFalkon.PluginProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_PluginProxy_slots
};

} //extern "C"

static void *Sbk_PluginProxy_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::PluginProxy *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void PluginProxy_EventHandlerType_PythonToCpp_PluginProxy_EventHandlerType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::PluginProxy::EventHandlerType *>(cppOut) =
        static_cast<::PluginProxy::EventHandlerType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_PluginProxy_EventHandlerType_PythonToCpp_PluginProxy_EventHandlerType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX]))
        return PluginProxy_EventHandlerType_PythonToCpp_PluginProxy_EventHandlerType;
    return {};
}
static PyObject *PluginProxy_EventHandlerType_CppToPython_PluginProxy_EventHandlerType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::PluginProxy::EventHandlerType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PluginProxy_PythonToCpp_PluginProxy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_PluginProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PluginProxy_PythonToCpp_PluginProxy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PluginProxy_TypeF())))
        return PluginProxy_PythonToCpp_PluginProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PluginProxy_PTR_CppToPython_PluginProxy(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::PluginProxy *>(const_cast<void *>(cppIn)), Sbk_PluginProxy_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *PluginProxy_SignatureStrings[] = {
    "PyFalkon.PluginProxy(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PyFalkon.PluginProxy.acceptNavigationRequest(self,page:PyFalkon.WebPage,url:PySide2.QtCore.QUrl,type:PySide2.QtWebEngineWidgets.QWebEnginePage.NavigationType,isMainFrame:bool)->bool",
    "PyFalkon.PluginProxy.emitMainWindowCreated(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.PluginProxy.emitMainWindowDeleted(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.PluginProxy.emitWebPageCreated(self,page:PyFalkon.WebPage)",
    "PyFalkon.PluginProxy.emitWebPageDeleted(self,page:PyFalkon.WebPage)",
    "PyFalkon.PluginProxy.pluginUnloaded(self,plugin:PyFalkon.PluginInterface)",
    "PyFalkon.PluginProxy.populateExtensionsMenu(self,menu:PySide2.QtWidgets.QMenu)",
    "PyFalkon.PluginProxy.populateWebViewMenu(self,menu:PySide2.QtWidgets.QMenu,view:PyFalkon.WebView,r:PyFalkon.WebHitTestResult)",
    "PyFalkon.PluginProxy.processKeyPress(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QKeyEvent)->bool",
    "PyFalkon.PluginProxy.processKeyRelease(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QKeyEvent)->bool",
    "PyFalkon.PluginProxy.processMouseDoubleClick(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processMouseMove(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processMousePress(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processMouseRelease(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processWheelEvent(self,type:PyFalkon.Qz.ObjectName,obj:PySide2.QtCore.QObject,event:PySide2.QtGui.QWheelEvent)->bool",
    "PyFalkon.PluginProxy.registerAppEventHandler(self,type:PyFalkon.PluginProxy.EventHandlerType,obj:PyFalkon.PluginInterface)",
    nullptr}; // Sentinel

void init_PluginProxy(PyObject *module)
{
    _Sbk_PluginProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PluginProxy",
        "PluginProxy*",
        &Sbk_PluginProxy_spec,
        &Shiboken::callCppDestructor< ::PluginProxy >,
        reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_PluginProxy_Type);
    InitSignatureStrings(pyType, PluginProxy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_PluginProxy_Type), Sbk_PluginProxy_PropertyStrings);
    SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_PluginProxy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_PluginProxy_TypeF(),
        PluginProxy_PythonToCpp_PluginProxy_PTR,
        is_PluginProxy_PythonToCpp_PluginProxy_PTR_Convertible,
        PluginProxy_PTR_CppToPython_PluginProxy);

    Shiboken::Conversions::registerConverterName(converter, "PluginProxy");
    Shiboken::Conversions::registerConverterName(converter, "PluginProxy*");
    Shiboken::Conversions::registerConverterName(converter, "PluginProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PluginProxy).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::PluginProxyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_PluginProxy_TypeF(), &Sbk_PluginProxy_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'EventHandlerType'.
    SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_PluginProxy_TypeF(),
        "EventHandlerType",
        "1:PyFalkon.PluginProxy.EventHandlerType",
        "PluginProxy::EventHandlerType");
    if (!SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "MouseDoubleClickHandler", (long) PluginProxy::EventHandlerType::MouseDoubleClickHandler))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "MousePressHandler", (long) PluginProxy::EventHandlerType::MousePressHandler))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "MouseReleaseHandler", (long) PluginProxy::EventHandlerType::MouseReleaseHandler))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "MouseMoveHandler", (long) PluginProxy::EventHandlerType::MouseMoveHandler))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "KeyPressHandler", (long) PluginProxy::EventHandlerType::KeyPressHandler))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "KeyReleaseHandler", (long) PluginProxy::EventHandlerType::KeyReleaseHandler))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
        Sbk_PluginProxy_TypeF(), "WheelEventHandler", (long) PluginProxy::EventHandlerType::WheelEventHandler))
        return;
    // Register converter for enum 'PluginProxy::EventHandlerType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX],
            PluginProxy_EventHandlerType_CppToPython_PluginProxy_EventHandlerType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            PluginProxy_EventHandlerType_PythonToCpp_PluginProxy_EventHandlerType,
            is_PluginProxy_EventHandlerType_PythonToCpp_PluginProxy_EventHandlerType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_PLUGINPROXY_EVENTHANDLERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "PluginProxy::EventHandlerType");
        Shiboken::Conversions::registerConverterName(converter, "EventHandlerType");
    }
    // End of 'EventHandlerType' enum.

    PySide::Signal::registerSignals(Sbk_PluginProxy_TypeF(), &::PluginProxy::staticMetaObject);
    PluginProxyWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_PluginProxy_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_PluginProxy_TypeF(), &::PluginProxy::staticMetaObject, sizeof(PluginProxyWrapper));
}
