// THIS FILE IS GENERATED
// WARNING! All changes made in this file will be lost!

#include "phpparser.h"
#include "phpast.h"
#include "parserdebug.h"


# 1110 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1


#include <QtCore/QDebug>
#include <language/editor/documentrange.h>

namespace Php
{

void Parser::tokenize(const QString& contents, int initialState)
{
    m_contents = contents;
    Lexer lexer(tokenStream, contents, initialState);
    int kind = Parser::Token_EOF;
    int lastDocCommentBegin;
    int lastDocCommentEnd;

    do
    {
        lastDocCommentBegin = 0;
        lastDocCommentEnd = 0;
        kind = lexer.nextTokenKind();
        while (kind == Parser::Token_WHITESPACE || kind == Parser::Token_COMMENT || kind == Parser::Token_DOC_COMMENT)
        {
            if (kind == Parser::Token_COMMENT || kind == Parser::Token_DOC_COMMENT)
            {
                extractTodosFromComment(tokenText(lexer.tokenBegin(), lexer.tokenEnd()), lexer.tokenBegin());
            }
            if (kind == Parser::Token_DOC_COMMENT)
            {
                lastDocCommentBegin = lexer.tokenBegin();
                lastDocCommentEnd = lexer.tokenEnd();
            }
            kind = lexer.nextTokenKind();
        }
        if ( !kind ) // when the lexer returns 0, the end of file is reached
        {
            kind = Parser::Token_EOF;
        }
        Parser::Token &t = tokenStream->push();
        t.begin = lexer.tokenBegin();
        t.end = lexer.tokenEnd();
        t.kind = kind;
        t.docCommentBegin = lastDocCommentBegin;
        t.docCommentEnd = lastDocCommentEnd;
        //if ( m_debug ) qDebug() << kind << tokenText(t.begin,t.end) << t.begin << t.end;
    }
    while ( kind != Parser::Token_EOF );

    yylex(); // produce the look ahead token
}

void Parser::extractTodosFromComment(const QString& comment, qint64 startPosition)
{
    auto i = m_todoMarkers.globalMatch(comment);
    while (i.hasNext())
    {
        auto match = i.next();
        auto p = reportProblem(Todo, match.captured(1), 0);
        if (!p)
        {
            continue;
        }

        qint64 line = 0;
        qint64 column = 0;
        tokenStream->locationTable()->positionAt(startPosition, &line, &column);

        auto location = p->finalLocation();
        location.setStart(KTextEditor::Cursor(line, column + match.capturedStart(1)));
        location.setEnd(KTextEditor::Cursor(line, column + match.capturedEnd(1)));
        p->setFinalLocation(location);
    };
}

void Parser::setTodoMarkers(const QStringList& markers)
{
    QString pattern = QStringLiteral("^(?:[/\\*\\s]*)(.*(?:");
    bool first = true;
    foreach(const QString& marker, markers)
    {
        if (!first)
        {
            pattern += '|';
        }
        pattern += QRegularExpression::escape(marker);
        first = false;
    }
    pattern += QStringLiteral(").*?)(?:[/\\*\\s]*)$");
    m_todoMarkers.setPatternOptions(QRegularExpression::MultilineOption);
    m_todoMarkers.setPattern(pattern);
}

QString Parser::tokenText(qint64 begin, qint64 end)
{
    return m_contents.mid(begin,end-begin+1);
}


KDevelop::ProblemPointer Parser::reportProblem( Parser::ProblemType type, const QString& message, int offset )
{
    qint64 sLine;
    qint64 sCol;
    qint64 index = tokenStream->index() + offset;
    if (index >= tokenStream->size())
    {
        return {};
    }
    tokenStream->startPosition(index, &sLine, &sCol);
    qint64 eLine;
    qint64 eCol;
    tokenStream->endPosition(index, &eLine, &eCol);
    auto p = KDevelop::ProblemPointer(new KDevelop::Problem());
    p->setSource(KDevelop::IProblem::Parser);
    switch ( type )
    {
    case Error:
        p->setSeverity(KDevelop::IProblem::Error);
        break;
    case Warning:
        p->setSeverity(KDevelop::IProblem::Warning);
        break;
    case Info:
        p->setSeverity(KDevelop::IProblem::Hint);
        break;
    case Todo:
        p->setSeverity(KDevelop::IProblem::Hint);
        p->setSource(KDevelop::IProblem::ToDo);
        break;
    }
    p->setDescription(message);
    KTextEditor::Range range(sLine, sCol, eLine, eCol + 1);
    p->setFinalLocation(KDevelop::DocumentRange(m_currentDocument, range));
    m_problems << p;
    return p;
}


// custom error recovery
void Parser::expectedToken(int /*expected*/, qint64 /*where*/, const QString& name)
{
    reportProblem( Parser::Error, QStringLiteral("Expected token \"%1\"").arg(name));
}

void Parser::expectedSymbol(int /*expectedSymbol*/, const QString& name)
{
    qint64 line;
    qint64 col;
    qint64 index = tokenStream->index()-1;
    Token &token = tokenStream->at(index);
    qCDebug(PARSER) << "token starts at:" << token.begin;
    qCDebug(PARSER) << "index is:" << index;
    tokenStream->startPosition(index, &line, &col);
    QString tokenValue = tokenText(token.begin, token.end);
    qint64 eLine;
    qint64 eCol;
    tokenStream->endPosition(index, &eLine, &eCol);
    reportProblem( Parser::Error,
                   QStringLiteral("Expected symbol \"%1\" (current token: \"%2\" [%3] at %4:%5 - %6:%7)")
                   .arg(name,
                        token.kind != 0 ? tokenValue : QStringLiteral("EOF"))
                   .arg(token.kind)
                   .arg(line)
                   .arg(col)
                   .arg(eLine)
                   .arg(eCol));
}

void Parser::setDebug( bool debug )
{
    m_debug = debug;
}

void Parser::setCurrentDocument(KDevelop::IndexedString url)
{
    m_currentDocument = url;
}


Parser::ParserState *Parser::copyCurrentState()
{
    ParserState *state = new ParserState();
    state->varExpressionState = m_state.varExpressionState;
    state->varExpressionIsVariable = m_state.varExpressionIsVariable;
    return state;
}

void Parser::restoreState( Parser::ParserState* state)
{
    m_state.varExpressionState = state->varExpressionState;
    m_state.varExpressionIsVariable = state->varExpressionIsVariable;
}

} // end of namespace Php


namespace Php
{

bool Parser::parseAdditiveExpression(AdditiveExpressionAst **yynode)
{
    *yynode = create<AdditiveExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        MultiplicativeExpressionAst *__node_0 = nullptr;
        if (!parseMultiplicativeExpression(&__node_0))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::MultiplicativeExpressionKind, QStringLiteral("multiplicativeExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_0;

        while (yytoken == Token_CONCAT
               || yytoken == Token_MINUS
               || yytoken == Token_PLUS)
        {
            AdditiveExpressionRestAst *__node_1 = nullptr;
            if (!parseAdditiveExpressionRest(&__node_1))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AdditiveExpressionRestKind, QStringLiteral("additiveExpressionRest"));
                }
                return false;
            }
            (*yynode)->additionalExpressionSequence = snoc((*yynode)->additionalExpressionSequence, __node_1, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseAdditiveExpressionRest(AdditiveExpressionRestAst **yynode)
{
    *yynode = create<AdditiveExpressionRestAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_CONCAT
        || yytoken == Token_MINUS
        || yytoken == Token_PLUS)
    {
        if (yytoken == Token_PLUS)
        {
            if (yytoken != Token_PLUS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PLUS, QStringLiteral("+"));
                }
                return false;
            }
            yylex();


# 478 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationPlus;
        }
        else if (yytoken == Token_MINUS)
        {
            if (yytoken != Token_MINUS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_MINUS, QStringLiteral("-"));
                }
                return false;
            }
            yylex();


# 479 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationMinus;
        }
        else if (yytoken == Token_CONCAT)
        {
            if (yytoken != Token_CONCAT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONCAT, QStringLiteral("."));
                }
                return false;
            }
            yylex();


# 480 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationConcat;
        }
        else
        {
            return false;
        }
        MultiplicativeExpressionAst *__node_2 = nullptr;
        if (!parseMultiplicativeExpression(&__node_2))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::MultiplicativeExpressionKind, QStringLiteral("multiplicativeExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_2;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseArrayIndexSpecifier(ArrayIndexSpecifierAst **yynode)
{
    *yynode = create<ArrayIndexSpecifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACKET)
    {
        if (yytoken != Token_LBRACKET)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACKET, QStringLiteral("["));
            }
            return false;
        }
        yylex();

        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_DEC
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_VARIABLE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            ExprAst *__node_3 = nullptr;
            if (!parseExpr(&__node_3))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_3;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken != Token_RBRACKET)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACKET, QStringLiteral("]"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseArrayPairValue(ArrayPairValueAst **yynode)
{
    *yynode = create<ArrayPairValueAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BIT_AND
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_DEC
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_VARIABLE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            ExprAst *__node_4 = nullptr;
            if (!parseExpr(&__node_4))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_4;

            if (yytoken == Token_DOUBLE_ARROW)
            {
                if (yytoken != Token_DOUBLE_ARROW)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_DOUBLE_ARROW, QStringLiteral("=>"));
                    }
                    return false;
                }
                yylex();

                if (yytoken == Token_ARRAY
                    || yytoken == Token_ARRAY_CAST
                    || yytoken == Token_AT
                    || yytoken == Token_BACKSLASH
                    || yytoken == Token_BACKTICK
                    || yytoken == Token_BANG
                    || yytoken == Token_BOOL_CAST
                    || yytoken == Token_CLASS_C
                    || yytoken == Token_CLONE
                    || yytoken == Token_CONSTANT_ENCAPSED_STRING
                    || yytoken == Token_DEC
                    || yytoken == Token_DIR
                    || yytoken == Token_DNUMBER
                    || yytoken == Token_DOLLAR
                    || yytoken == Token_DOUBLE_CAST
                    || yytoken == Token_DOUBLE_QUOTE
                    || yytoken == Token_EMPTY
                    || yytoken == Token_EVAL
                    || yytoken == Token_EXIT
                    || yytoken == Token_FILE
                    || yytoken == Token_FUNCTION
                    || yytoken == Token_FUNC_C
                    || yytoken == Token_INC
                    || yytoken == Token_INCLUDE
                    || yytoken == Token_INCLUDE_ONCE
                    || yytoken == Token_INT_CAST
                    || yytoken == Token_ISSET
                    || yytoken == Token_LBRACKET
                    || yytoken == Token_LINE
                    || yytoken == Token_LIST
                    || yytoken == Token_LNUMBER
                    || yytoken == Token_LPAREN
                    || yytoken == Token_METHOD_C
                    || yytoken == Token_MINUS
                    || yytoken == Token_NAMESPACE_C
                    || yytoken == Token_NEW
                    || yytoken == Token_OBJECT_CAST
                    || yytoken == Token_PLUS
                    || yytoken == Token_PRINT
                    || yytoken == Token_REQUIRE
                    || yytoken == Token_REQUIRE_ONCE
                    || yytoken == Token_START_HEREDOC
                    || yytoken == Token_START_NOWDOC
                    || yytoken == Token_STRING
                    || yytoken == Token_STRING_CAST
                    || yytoken == Token_STRING_VARNAME
                    || yytoken == Token_TILDE
                    || yytoken == Token_TRAIT_C
                    || yytoken == Token_UNSET_CAST
                    || yytoken == Token_VARIABLE
                    || yytoken == Token_YIELD
                    || yytoken == Token_YIELD_FROM)
                {
                    ExprAst *__node_5 = nullptr;
                    if (!parseExpr(&__node_5))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                        }
                        return false;
                    }
                    (*yynode)->exprValue = __node_5;

                }
                else if (yytoken == Token_BIT_AND)
                {
                    if (yytoken != Token_BIT_AND)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                        }
                        return false;
                    }
                    yylex();

                    VariableAst *__node_6 = nullptr;
                    if (!parseVariable(&__node_6))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                        }
                        return false;
                    }
                    (*yynode)->varValue = __node_6;

                }
                else
                {
                    return false;
                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            yylex();

            VariableAst *__node_7 = nullptr;
            if (!parseVariable(&__node_7))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->variable = __node_7;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseAssignmentExpression(AssignmentExpressionAst **yynode)
{
    *yynode = create<AssignmentExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {

# 361 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
        m_state.varExpressionIsVariable = false;
        ConditionalExpressionAst *__node_8 = nullptr;
        if (!parseConditionalExpression(&__node_8))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ConditionalExpressionKind, QStringLiteral("conditionalExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_8;

        if (yytoken == Token_ASSIGN)
        {
            AssignmentExpressionEqualAst *__node_9 = nullptr;
            if (!parseAssignmentExpressionEqual(&__node_9))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentExpressionEqualKind, QStringLiteral("assignmentExpressionEqual"));
                }
                return false;
            }
            (*yynode)->assignmentExpressionEqual = __node_9;

        }
        else if (yytoken == Token_AND_ASSIGN
                 || yytoken == Token_CONCAT_ASSIGN
                 || yytoken == Token_DIV_ASSIGN
                 || yytoken == Token_EXP_ASSIGN
                 || yytoken == Token_MINUS_ASSIGN
                 || yytoken == Token_MOD_ASSIGN
                 || yytoken == Token_MUL_ASSIGN
                 || yytoken == Token_OR_ASSIGN
                 || yytoken == Token_PLUS_ASSIGN
                 || yytoken == Token_SL_ASSIGN
                 || yytoken == Token_SR_ASSIGN
                 || yytoken == Token_XOR_ASSIGN)
        {
            if (yytoken == Token_PLUS_ASSIGN)
            {
                if (yytoken != Token_PLUS_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_PLUS_ASSIGN, QStringLiteral("+="));
                    }
                    return false;
                }
                yylex();


# 366 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationPlus;
            }
            else if (yytoken == Token_MINUS_ASSIGN)
            {
                if (yytoken != Token_MINUS_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_MINUS_ASSIGN, QStringLiteral("-="));
                    }
                    return false;
                }
                yylex();


# 367 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationMinus;
            }
            else if (yytoken == Token_MUL_ASSIGN)
            {
                if (yytoken != Token_MUL_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_MUL_ASSIGN, QStringLiteral("*="));
                    }
                    return false;
                }
                yylex();


# 368 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationMul;
            }
            else if (yytoken == Token_EXP_ASSIGN)
            {
                if (yytoken != Token_EXP_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_EXP_ASSIGN, QStringLiteral("**="));
                    }
                    return false;
                }
                yylex();


# 369 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationExp;
            }
            else if (yytoken == Token_DIV_ASSIGN)
            {
                if (yytoken != Token_DIV_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_DIV_ASSIGN, QStringLiteral("/="));
                    }
                    return false;
                }
                yylex();


# 370 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationDiv;
            }
            else if (yytoken == Token_CONCAT_ASSIGN)
            {
                if (yytoken != Token_CONCAT_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_CONCAT_ASSIGN, QStringLiteral(".="));
                    }
                    return false;
                }
                yylex();


# 371 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationConcat;
            }
            else if (yytoken == Token_MOD_ASSIGN)
            {
                if (yytoken != Token_MOD_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_MOD_ASSIGN, QStringLiteral("%="));
                    }
                    return false;
                }
                yylex();


# 372 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationMod;
            }
            else if (yytoken == Token_AND_ASSIGN)
            {
                if (yytoken != Token_AND_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_AND_ASSIGN, QStringLiteral("&="));
                    }
                    return false;
                }
                yylex();


# 373 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationAnd;
            }
            else if (yytoken == Token_OR_ASSIGN)
            {
                if (yytoken != Token_OR_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_OR_ASSIGN, QStringLiteral("|="));
                    }
                    return false;
                }
                yylex();


# 374 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationOr;
            }
            else if (yytoken == Token_XOR_ASSIGN)
            {
                if (yytoken != Token_XOR_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_XOR_ASSIGN, QStringLiteral("^="));
                    }
                    return false;
                }
                yylex();


# 375 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationXor;
            }
            else if (yytoken == Token_SL_ASSIGN)
            {
                if (yytoken != Token_SL_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SL_ASSIGN, QStringLiteral("<<="));
                    }
                    return false;
                }
                yylex();


# 376 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationSl;
            }
            else if (yytoken == Token_SR_ASSIGN)
            {
                if (yytoken != Token_SR_ASSIGN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SR_ASSIGN, QStringLiteral(">>="));
                    }
                    return false;
                }
                yylex();


# 377 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->operation = OperationSr;
            }
            else
            {
                return false;
            }
            AssignmentExpressionCheckIfVariableAst *__node_10 = nullptr;
            if (!parseAssignmentExpressionCheckIfVariable(&__node_10))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentExpressionCheckIfVariableKind, QStringLiteral("assignmentExpressionCheckIfVariable"));
                }
                return false;
            }
            AssignmentExpressionAst *__node_11 = nullptr;
            if (!parseAssignmentExpression(&__node_11))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentExpressionKind, QStringLiteral("assignmentExpression"));
                }
                return false;
            }
            (*yynode)->assignmentExpression = __node_11;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseAssignmentExpressionCheckIfVariable(AssignmentExpressionCheckIfVariableAst **yynode)
{
    *yynode = create<AssignmentExpressionCheckIfVariableAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (true /*epsilon*/ || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BIT_AND
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {

# 407 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1

        if (!m_state.varExpressionIsVariable)
        {
            reportProblem(Error, QStringLiteral("Left side is not a variable"));
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseAssignmentExpressionEqual(AssignmentExpressionEqualAst **yynode)
{
    *yynode = create<AssignmentExpressionEqualAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ASSIGN)
    {
        if (yytoken != Token_ASSIGN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
            }
            return false;
        }
        yylex();

        AssignmentExpressionCheckIfVariableAst *__node_12 = nullptr;
        if (!parseAssignmentExpressionCheckIfVariable(&__node_12))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::AssignmentExpressionCheckIfVariableKind, QStringLiteral("assignmentExpressionCheckIfVariable"));
            }
            return false;
        }
        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            yylex();


# 394 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            if (yytoken == Token_NEW)
            {
                reportProblem(Warning, QStringLiteral("=& new foo() is deprecated"), -2);
                m_state.varExpressionState = OnlyNewObject;
            }
            else
            {
                m_state.varExpressionState = OnlyVariable;
            }
        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        AssignmentExpressionAst *__node_13 = nullptr;
        if (!parseAssignmentExpression(&__node_13))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::AssignmentExpressionKind, QStringLiteral("assignmentExpression"));
            }
            return false;
        }
        (*yynode)->assignmentExpression = __node_13;


# 400 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
        m_state.varExpressionState = Normal;
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseAssignmentList(AssignmentListAst **yynode)
{
    *yynode = create<AssignmentListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_COMMA
        || yytoken == Token_DOLLAR
        || yytoken == Token_LIST
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE || yytoken == Token_RPAREN)
    {
        AssignmentListElementAst *__node_14 = nullptr;
        if (!parseAssignmentListElement(&__node_14))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::AssignmentListElementKind, QStringLiteral("assignmentListElement"));
            }
            return false;
        }
        (*yynode)->elementSequence = snoc((*yynode)->elementSequence, __node_14, memoryPool);

        while (yytoken == Token_COMMA)
        {
            if (yytoken != Token_COMMA)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                }
                return false;
            }
            yylex();

            AssignmentListElementAst *__node_15 = nullptr;
            if (!parseAssignmentListElement(&__node_15))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentListElementKind, QStringLiteral("assignmentListElement"));
                }
                return false;
            }
            (*yynode)->elementSequence = snoc((*yynode)->elementSequence, __node_15, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseAssignmentListElement(AssignmentListElementAst **yynode)
{
    *yynode = create<AssignmentListElementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_DOLLAR
        || yytoken == Token_LIST
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE || yytoken == Token_COMMA
        || yytoken == Token_RPAREN)
    {
        if (yytoken == Token_BACKSLASH
            || yytoken == Token_DOLLAR
            || yytoken == Token_STRING
            || yytoken == Token_VARIABLE)
        {
            VariableAst *__node_16 = nullptr;
            if (!parseVariable(&__node_16))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->variable = __node_16;

        }
        else if (yytoken == Token_LIST)
        {
            if (yytoken != Token_LIST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LIST, QStringLiteral("list"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            AssignmentListAst *__node_17 = nullptr;
            if (!parseAssignmentList(&__node_17))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentListKind, QStringLiteral("assignmentList"));
                }
                return false;
            }
            (*yynode)->assignmentList = __node_17;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBaseVariable(BaseVariableAst **yynode)
{
    *yynode = create<BaseVariableAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_DOLLAR
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_DOLLAR
            || yytoken == Token_VARIABLE)
        {
            CompoundVariableWithSimpleIndirectReferenceAst *__node_18 = nullptr;
            if (!parseCompoundVariableWithSimpleIndirectReference(&__node_18))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::CompoundVariableWithSimpleIndirectReferenceKind, QStringLiteral("compoundVariableWithSimpleIndirectReference"));
                }
                return false;
            }
            (*yynode)->var = __node_18;

            while (yytoken == Token_LBRACE
                   || yytoken == Token_LBRACKET)
            {
                DimListItemAst *__node_19 = nullptr;
                if (!parseDimListItem(&__node_19))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::DimListItemKind, QStringLiteral("dimListItem"));
                    }
                    return false;
                }
                (*yynode)->offsetItemsSequence = snoc((*yynode)->offsetItemsSequence, __node_19, memoryPool);

            }
        }
        else if (yytoken == Token_BACKSLASH
                 || yytoken == Token_STRING)
        {
            StaticMemberAst *__node_20 = nullptr;
            if (!parseStaticMember(&__node_20))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticMemberKind, QStringLiteral("staticMember"));
                }
                return false;
            }
            (*yynode)->staticMember = __node_20;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBaseVariableWithFunctionCalls(BaseVariableWithFunctionCallsAst **yynode)
{
    *yynode = create<BaseVariableWithFunctionCallsAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_DOLLAR
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        bool blockErrors_1 = blockErrors(true);
        qint64 try_startToken_1 = tokenStream->index() - 1;
        ParserState *try_startState_1 = copyCurrentState();
        {
            FunctionCallAst *__node_21 = nullptr;
            if (!parseFunctionCall(&__node_21))
            {
                goto __catch_1;
            }
            (*yynode)->functionCall = __node_21;

            while (yytoken == Token_LBRACKET)
            {
                ArrayIndexSpecifierAst *__node_22 = nullptr;
                if (!parseArrayIndexSpecifier(&__node_22))
                {
                    goto __catch_1;
                }
                (*yynode)->arrayIndex = __node_22;

            }
        }
        blockErrors(blockErrors_1);
        if (try_startState_1)
            delete try_startState_1;

        if (false) // the only way to enter here is using goto
        {
__catch_1:
            if (try_startState_1)
            {
                restoreState(try_startState_1);
                delete try_startState_1;
            }
            blockErrors(blockErrors_1);
            rewind(try_startToken_1);

            BaseVariableAst *__node_23 = nullptr;
            if (!parseBaseVariable(&__node_23))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::BaseVariableKind, QStringLiteral("baseVariable"));
                }
                return false;
            }
            (*yynode)->baseVariable = __node_23;

        }

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBitAndExpression(BitAndExpressionAst **yynode)
{
    *yynode = create<BitAndExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        EqualityExpressionAst *__node_24 = nullptr;
        if (!parseEqualityExpression(&__node_24))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::EqualityExpressionKind, QStringLiteral("equalityExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_24, memoryPool);

        while (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            yylex();

            EqualityExpressionAst *__node_25 = nullptr;
            if (!parseEqualityExpression(&__node_25))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EqualityExpressionKind, QStringLiteral("equalityExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_25, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBitOrExpression(BitOrExpressionAst **yynode)
{
    *yynode = create<BitOrExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        BitXorExpressionAst *__node_26 = nullptr;
        if (!parseBitXorExpression(&__node_26))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::BitXorExpressionKind, QStringLiteral("bitXorExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_26, memoryPool);

        while (yytoken == Token_BIT_OR)
        {
            if (yytoken != Token_BIT_OR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_OR, QStringLiteral("|"));
                }
                return false;
            }
            yylex();

            BitXorExpressionAst *__node_27 = nullptr;
            if (!parseBitXorExpression(&__node_27))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::BitXorExpressionKind, QStringLiteral("bitXorExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_27, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBitXorExpression(BitXorExpressionAst **yynode)
{
    *yynode = create<BitXorExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        BitAndExpressionAst *__node_28 = nullptr;
        if (!parseBitAndExpression(&__node_28))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::BitAndExpressionKind, QStringLiteral("bitAndExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_28, memoryPool);

        while (yytoken == Token_BIT_XOR)
        {
            if (yytoken != Token_BIT_XOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_XOR, QStringLiteral("^"));
                }
                return false;
            }
            yylex();

            BitAndExpressionAst *__node_29 = nullptr;
            if (!parseBitAndExpression(&__node_29))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::BitAndExpressionKind, QStringLiteral("bitAndExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_29, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBooleanAndExpression(BooleanAndExpressionAst **yynode)
{
    *yynode = create<BooleanAndExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        BitOrExpressionAst *__node_30 = nullptr;
        if (!parseBitOrExpression(&__node_30))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::BitOrExpressionKind, QStringLiteral("bitOrExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_30, memoryPool);

        while (yytoken == Token_BOOLEAN_AND)
        {
            if (yytoken != Token_BOOLEAN_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BOOLEAN_AND, QStringLiteral("&&"));
                }
                return false;
            }
            yylex();

            BitOrExpressionAst *__node_31 = nullptr;
            if (!parseBitOrExpression(&__node_31))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::BitOrExpressionKind, QStringLiteral("bitOrExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_31, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseBooleanOrExpression(BooleanOrExpressionAst **yynode)
{
    *yynode = create<BooleanOrExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        BooleanAndExpressionAst *__node_32 = nullptr;
        if (!parseBooleanAndExpression(&__node_32))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::BooleanAndExpressionKind, QStringLiteral("booleanAndExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_32, memoryPool);

        while (yytoken == Token_BOOLEAN_OR)
        {
            if (yytoken != Token_BOOLEAN_OR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BOOLEAN_OR, QStringLiteral("||"));
                }
                return false;
            }
            yylex();

            BooleanAndExpressionAst *__node_33 = nullptr;
            if (!parseBooleanAndExpression(&__node_33))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::BooleanAndExpressionKind, QStringLiteral("booleanAndExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_33, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCaseList(CaseListAst **yynode)
{
    *yynode = create<CaseListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_CASE
        || yytoken == Token_DEFAULT || yytoken == Token_ENDSWITCH
        || yytoken == Token_RBRACE)
    {
        while (yytoken == Token_CASE
               || yytoken == Token_DEFAULT)
        {
            Case_itemAst *__node_34 = nullptr;
            if (!parseCase_item(&__node_34))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::Case_itemKind, QStringLiteral("case_item"));
                }
                return false;
            }
            (*yynode)->caseItemsSequence = snoc((*yynode)->caseItemsSequence, __node_34, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCase_item(Case_itemAst **yynode)
{
    *yynode = create<Case_itemAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->def = -1;

    if (yytoken == Token_CASE
        || yytoken == Token_DEFAULT)
    {
        if (yytoken == Token_CASE)
        {
            if (yytoken != Token_CASE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CASE, QStringLiteral("case"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_35 = nullptr;
            if (!parseExpr(&__node_35))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_35;

            if (yytoken == Token_COLON)
            {
                if (yytoken != Token_COLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                    }
                    return false;
                }
                yylex();

            }
            else if (yytoken == Token_SEMICOLON)
            {
                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
            InnerStatementListAst *__node_36 = nullptr;
            if (!parseInnerStatementList(&__node_36))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_36;

        }
        else if (yytoken == Token_DEFAULT)
        {
            if (yytoken != Token_DEFAULT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DEFAULT, QStringLiteral("default"));
                }
                return false;
            }
            (*yynode)->def = tokenStream->index() - 1;
            yylex();

            if (yytoken == Token_COLON)
            {
                if (yytoken != Token_COLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                    }
                    return false;
                }
                yylex();

            }
            else if (yytoken == Token_SEMICOLON)
            {
                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
            InnerStatementListAst *__node_37 = nullptr;
            if (!parseInnerStatementList(&__node_37))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_37;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCatchItem(CatchItemAst **yynode)
{
    *yynode = create<CatchItemAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_CATCH)
    {
        if (yytoken != Token_CATCH)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_CATCH, QStringLiteral("catch"));
            }
            return false;
        }
        yylex();

        if (yytoken != Token_LPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
            }
            return false;
        }
        yylex();

        NamespacedIdentifierAst *__node_38 = nullptr;
        if (!parseNamespacedIdentifier(&__node_38))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->catchClassSequence = snoc((*yynode)->catchClassSequence, __node_38, memoryPool);

        while (yytoken == Token_BIT_OR)
        {
            if (yytoken != Token_BIT_OR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_OR, QStringLiteral("|"));
                }
                return false;
            }
            yylex();

            NamespacedIdentifierAst *__node_39 = nullptr;
            if (!parseNamespacedIdentifier(&__node_39))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->catchClassSequence = snoc((*yynode)->catchClassSequence, __node_39, memoryPool);

        }
        VariableIdentifierAst *__node_40 = nullptr;
        if (!parseVariableIdentifier(&__node_40))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
            }
            return false;
        }
        (*yynode)->var = __node_40;

        if (yytoken != Token_RPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
            }
            return false;
        }
        yylex();

        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        qint64 try_startToken_2 = tokenStream->index() - 1;
        ParserState *try_startState_2 = copyCurrentState();
        {
            InnerStatementListAst *__node_41 = nullptr;
            if (!parseInnerStatementList(&__node_41))
            {
                goto __catch_2;
            }
            (*yynode)->statements = __node_41;

        }
        if (try_startState_2)
            delete try_startState_2;

        if (false) // the only way to enter here is using goto
        {
__catch_2:
            if (try_startState_2)
            {
                restoreState(try_startState_2);
                delete try_startState_2;
            }
            if (try_startToken_2 == tokenStream->index() - 1  && yytoken != Token_EOF)
                yylex();

            while (yytoken != Token_EOF
                   && yytoken != Token_RBRACE)
            {
                yylex();
            }
        }

        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassBody(ClassBodyAst **yynode)
{
    *yynode = create<ClassBodyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CONST
        || yytoken == Token_FINAL
        || yytoken == Token_FUNCTION
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_QUESTION
        || yytoken == Token_RBRACE
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_VARIABLE)
    {

# 1004 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
        bool reported = false;
        while ( true )
        {
            while (yytoken == Token_ABSTRACT
                   || yytoken == Token_ARRAY
                   || yytoken == Token_BACKSLASH
                   || yytoken == Token_CONST
                   || yytoken == Token_FINAL
                   || yytoken == Token_FUNCTION
                   || yytoken == Token_PRIVATE
                   || yytoken == Token_PROTECTED
                   || yytoken == Token_PUBLIC
                   || yytoken == Token_QUESTION
                   || yytoken == Token_STATIC
                   || yytoken == Token_STRING
                   || yytoken == Token_USE
                   || yytoken == Token_VAR
                   || yytoken == Token_VARIABLE)
            {
                qint64 try_startToken_3 = tokenStream->index() - 1;
                ParserState *try_startState_3 = copyCurrentState();
                {
                    ClassStatementAst *__node_42 = nullptr;
                    if (!parseClassStatement(&__node_42))
                    {
                        goto __catch_3;
                    }
                    (*yynode)->classStatementsSequence = snoc((*yynode)->classStatementsSequence, __node_42, memoryPool);

                }
                if (try_startState_3)
                    delete try_startState_3;

                if (false) // the only way to enter here is using goto
                {
__catch_3:
                    if (try_startState_3)
                    {
                        restoreState(try_startState_3);
                        delete try_startState_3;
                    }
                    if (try_startToken_3 == tokenStream->index() - 1  && yytoken != Token_EOF)
                        yylex();

                    while (yytoken != Token_EOF
                           && yytoken != Token_STRING
                           && yytoken != Token_RBRACE
                           && yytoken != Token_USE
                           && yytoken != Token_PUBLIC
                           && yytoken != Token_PRIVATE
                           && yytoken != Token_VAR
                           && yytoken != Token_QUESTION
                           && yytoken != Token_STATIC
                           && yytoken != Token_CONST
                           && yytoken != Token_VARIABLE
                           && yytoken != Token_PROTECTED
                           && yytoken != Token_FUNCTION
                           && yytoken != Token_BACKSLASH
                           && yytoken != Token_ABSTRACT
                           && yytoken != Token_FINAL
                           && yytoken != Token_ARRAY)
                    {
                        yylex();
                    }
                }

            }

# 1006 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            if (yytoken != Token_RBRACE && yytoken != Token_EOF && yytoken != Token_CLOSE_TAG)
            {
                if (!reported)
                {
                    reportProblem(Error, QStringLiteral("Unexpected token in class context."));
                    reported = true;
                }
                yylex();
            }
            else
            {
                break;
            }
        }
        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();


# 1016 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
        rewind(tokenStream->index() - 2);
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassConstant(ClassConstantAst **yynode)
{
    *yynode = create<ClassConstantAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_AS
        || yytoken == Token_BREAK
        || yytoken == Token_CALLABLE
        || yytoken == Token_CASE
        || yytoken == Token_CATCH
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONST
        || yytoken == Token_CONTINUE
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DO
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_EXTENDS
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FINALLY
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_IMPLEMENTS
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_INSTEADOF
        || yytoken == Token_INTERFACE
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD)
    {
        SemiReservedIdentifierAst *__node_43 = nullptr;
        if (!parseSemiReservedIdentifier(&__node_43))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::SemiReservedIdentifierKind, QStringLiteral("semiReservedIdentifier"));
            }
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassConstantDeclaration(ClassConstantDeclarationAst **yynode)
{
    *yynode = create<ClassConstantDeclarationAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_AS
        || yytoken == Token_BREAK
        || yytoken == Token_CALLABLE
        || yytoken == Token_CASE
        || yytoken == Token_CATCH
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONST
        || yytoken == Token_CONTINUE
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DO
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_EXTENDS
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FINALLY
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_IMPLEMENTS
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_INSTEADOF
        || yytoken == Token_INTERFACE
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD)
    {
        SemiReservedIdentifierAst *__node_44 = nullptr;
        if (!parseSemiReservedIdentifier(&__node_44))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::SemiReservedIdentifierKind, QStringLiteral("semiReservedIdentifier"));
            }
            return false;
        }
        (*yynode)->identifier = __node_44;

        if (yytoken != Token_ASSIGN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
            }
            return false;
        }
        yylex();

        ExprAst *__node_45 = nullptr;
        if (!parseExpr(&__node_45))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
            }
            return false;
        }
        (*yynode)->scalar = __node_45;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassDeclarationStatement(ClassDeclarationStatementAst **yynode)
{
    *yynode = create<ClassDeclarationStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_CLASS
        || yytoken == Token_FINAL)
    {
        OptionalClassModifierAst *__node_46 = nullptr;
        if (!parseOptionalClassModifier(&__node_46))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::OptionalClassModifierKind, QStringLiteral("optionalClassModifier"));
            }
            return false;
        }
        (*yynode)->modifier = __node_46;

        if (yytoken != Token_CLASS)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_CLASS, QStringLiteral("class"));
            }
            return false;
        }
        yylex();

        IdentifierAst *__node_47 = nullptr;
        if (!parseIdentifier(&__node_47))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
            }
            return false;
        }
        (*yynode)->className = __node_47;

        if (yytoken == Token_EXTENDS)
        {
            if (yytoken != Token_EXTENDS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EXTENDS, QStringLiteral("extends"));
                }
                return false;
            }
            yylex();

            ClassExtendsAst *__node_48 = nullptr;
            if (!parseClassExtends(&__node_48))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassExtendsKind, QStringLiteral("classExtends"));
                }
                return false;
            }
            (*yynode)->extends = __node_48;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken == Token_IMPLEMENTS)
        {
            if (yytoken != Token_IMPLEMENTS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IMPLEMENTS, QStringLiteral("implements"));
                }
                return false;
            }
            yylex();

            ClassImplementsAst *__node_49 = nullptr;
            if (!parseClassImplements(&__node_49))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassImplementsKind, QStringLiteral("classImplements"));
                }
                return false;
            }
            (*yynode)->implements = __node_49;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        ClassBodyAst *__node_50 = nullptr;
        if (!parseClassBody(&__node_50))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ClassBodyKind, QStringLiteral("classBody"));
            }
            return false;
        }
        (*yynode)->body = __node_50;

        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassExtends(ClassExtendsAst **yynode)
{
    *yynode = create<ClassExtendsAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        NamespacedIdentifierAst *__node_51 = nullptr;
        if (!parseNamespacedIdentifier(&__node_51))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->identifier = __node_51;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassImplements(ClassImplementsAst **yynode)
{
    *yynode = create<ClassImplementsAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        NamespacedIdentifierAst *__node_52 = nullptr;
        if (!parseNamespacedIdentifier(&__node_52))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->implementsSequence = snoc((*yynode)->implementsSequence, __node_52, memoryPool);

        while (yytoken == Token_COMMA)
        {
            if (yytoken != Token_COMMA)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                }
                return false;
            }
            yylex();

            NamespacedIdentifierAst *__node_53 = nullptr;
            if (!parseNamespacedIdentifier(&__node_53))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->implementsSequence = snoc((*yynode)->implementsSequence, __node_53, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassName(ClassNameAst **yynode)
{
    *yynode = create<ClassNameAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->staticIdentifier = -1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STATIC
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_BACKSLASH
            || yytoken == Token_STRING)
        {
            NamespacedIdentifierAst *__node_54 = nullptr;
            if (!parseNamespacedIdentifier(&__node_54))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->identifier = __node_54;

        }
        else if (yytoken == Token_STATIC)
        {
            if (yytoken != Token_STATIC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STATIC, QStringLiteral("static"));
                }
                return false;
            }
            (*yynode)->staticIdentifier = tokenStream->index() - 1;
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassNameReference(ClassNameReferenceAst **yynode)
{
    *yynode = create<ClassNameReferenceAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_DOLLAR
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_BACKSLASH
            || yytoken == Token_STATIC
            || yytoken == Token_STRING)
        {
            ClassNameAst *__node_55 = nullptr;
            if (!parseClassName(&__node_55))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassNameKind, QStringLiteral("className"));
                }
                return false;
            }
            (*yynode)->className = __node_55;

            if (yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
            {
                StaticPropertyAst *__node_56 = nullptr;
                if (!parseStaticProperty(&__node_56))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StaticPropertyKind, QStringLiteral("staticProperty"));
                    }
                    return false;
                }
                (*yynode)->staticProperty = __node_56;

                while (yytoken == Token_OBJECT_OPERATOR
                       || yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
                {
                    ClassPropertyAst *__node_57 = nullptr;
                    if (!parseClassProperty(&__node_57))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ClassPropertyKind, QStringLiteral("classProperty"));
                        }
                        return false;
                    }
                    (*yynode)->propertiesSequence = snoc((*yynode)->propertiesSequence, __node_57, memoryPool);

                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_DOLLAR
                 || yytoken == Token_VARIABLE)
        {
            VariableWithoutObjectsAst *__node_58 = nullptr;
            if (!parseVariableWithoutObjects(&__node_58))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableWithoutObjectsKind, QStringLiteral("variableWithoutObjects"));
                }
                return false;
            }
            (*yynode)->baseVariable = __node_58;

            while (yytoken == Token_OBJECT_OPERATOR
                   || yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
            {
                ClassPropertyAst *__node_59 = nullptr;
                if (!parseClassProperty(&__node_59))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ClassPropertyKind, QStringLiteral("classProperty"));
                    }
                    return false;
                }
                (*yynode)->propertiesSequence = snoc((*yynode)->propertiesSequence, __node_59, memoryPool);

            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassProperty(ClassPropertyAst **yynode)
{
    *yynode = create<ClassPropertyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_OBJECT_OPERATOR
        || yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
    {
        if (yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
        {
            StaticPropertyAst *__node_60 = nullptr;
            if (!parseStaticProperty(&__node_60))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticPropertyKind, QStringLiteral("staticProperty"));
                }
                return false;
            }
            (*yynode)->staticProperty = __node_60;

        }
        else if (yytoken == Token_OBJECT_OPERATOR)
        {
            if (yytoken != Token_OBJECT_OPERATOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_OBJECT_OPERATOR, QStringLiteral("->"));
                }
                return false;
            }
            yylex();

            ObjectPropertyAst *__node_61 = nullptr;
            if (!parseObjectProperty(&__node_61))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ObjectPropertyKind, QStringLiteral("objectProperty"));
                }
                return false;
            }
            (*yynode)->property = __node_61;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassStatement(ClassStatementAst **yynode)
{
    *yynode = create<ClassStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CONST
        || yytoken == Token_FINAL
        || yytoken == Token_FUNCTION
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_QUESTION
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_VAR)
        {
            if (yytoken != Token_VAR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_VAR, QStringLiteral("var "));
                }
                return false;
            }
            yylex();

            ClassVariableDeclarationAst *__node_62 = nullptr;
            if (!parseClassVariableDeclaration(&__node_62))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassVariableDeclarationKind, QStringLiteral("classVariableDeclaration"));
                }
                return false;
            }
            (*yynode)->variable = __node_62;

            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ABSTRACT
                 || yytoken == Token_ARRAY
                 || yytoken == Token_BACKSLASH
                 || yytoken == Token_CONST
                 || yytoken == Token_FINAL
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_PRIVATE
                 || yytoken == Token_PROTECTED
                 || yytoken == Token_PUBLIC
                 || yytoken == Token_QUESTION
                 || yytoken == Token_STATIC
                 || yytoken == Token_STRING
                 || yytoken == Token_VARIABLE)
        {
            OptionalModifiersAst *__node_63 = nullptr;
            if (!parseOptionalModifiers(&__node_63))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::OptionalModifiersKind, QStringLiteral("optionalModifiers"));
                }
                return false;
            }
            (*yynode)->modifiers = __node_63;

            if (yytoken == Token_ARRAY
                || yytoken == Token_BACKSLASH
                || yytoken == Token_QUESTION
                || yytoken == Token_STRING
                || yytoken == Token_VARIABLE)
            {
                if (yytoken == Token_ARRAY
                    || yytoken == Token_BACKSLASH
                    || yytoken == Token_QUESTION
                    || yytoken == Token_STRING)
                {
                    PropertyTypeAst *__node_64 = nullptr;
                    if (!parsePropertyType(&__node_64))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::PropertyTypeKind, QStringLiteral("propertyType"));
                        }
                        return false;
                    }
                    (*yynode)->propertyType = __node_64;

                }
                else if (true /*epsilon*/)
                {
                }
                else
                {
                    return false;
                }
                ClassVariableDeclarationAst *__node_65 = nullptr;
                if (!parseClassVariableDeclaration(&__node_65))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ClassVariableDeclarationKind, QStringLiteral("classVariableDeclaration"));
                    }
                    return false;
                }
                (*yynode)->variable = __node_65;

                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else if (yytoken == Token_FUNCTION)
            {
                if (yytoken != Token_FUNCTION)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_FUNCTION, QStringLiteral("function"));
                    }
                    return false;
                }
                yylex();

                if (yytoken == Token_BIT_AND)
                {
                    if (yytoken != Token_BIT_AND)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                        }
                        return false;
                    }
                    yylex();

                }
                else if (true /*epsilon*/)
                {
                }
                else
                {
                    return false;
                }
                SemiReservedIdentifierAst *__node_66 = nullptr;
                if (!parseSemiReservedIdentifier(&__node_66))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::SemiReservedIdentifierKind, QStringLiteral("semiReservedIdentifier"));
                    }
                    return false;
                }
                (*yynode)->methodName = __node_66;

                if (yytoken != Token_LPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                    }
                    return false;
                }
                yylex();

                ParameterListAst *__node_67 = nullptr;
                if (!parseParameterList(&__node_67))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ParameterListKind, QStringLiteral("parameterList"));
                    }
                    return false;
                }
                (*yynode)->parameters = __node_67;

                if (yytoken != Token_RPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                    }
                    return false;
                }
                yylex();

                if (yytoken == Token_COLON)
                {
                    if (yytoken != Token_COLON)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                        }
                        return false;
                    }
                    yylex();

                    ReturnTypeAst *__node_68 = nullptr;
                    if (!parseReturnType(&__node_68))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ReturnTypeKind, QStringLiteral("returnType"));
                        }
                        return false;
                    }
                    (*yynode)->returnType = __node_68;

                }
                else if (true /*epsilon*/)
                {
                }
                else
                {
                    return false;
                }
                MethodBodyAst *__node_69 = nullptr;
                if (!parseMethodBody(&__node_69))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::MethodBodyKind, QStringLiteral("methodBody"));
                    }
                    return false;
                }
                (*yynode)->methodBody = __node_69;

            }
            else if (yytoken == Token_CONST)
            {
                if (yytoken != Token_CONST)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_CONST, QStringLiteral("const"));
                    }
                    return false;
                }
                yylex();

                ClassConstantDeclarationAst *__node_70 = nullptr;
                if (!parseClassConstantDeclaration(&__node_70))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ClassConstantDeclarationKind, QStringLiteral("classConstantDeclaration"));
                    }
                    return false;
                }
                (*yynode)->constsSequence = snoc((*yynode)->constsSequence, __node_70, memoryPool);

                while (yytoken == Token_COMMA)
                {
                    if (yytoken != Token_COMMA)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                        }
                        return false;
                    }
                    yylex();

                    ClassConstantDeclarationAst *__node_71 = nullptr;
                    if (!parseClassConstantDeclaration(&__node_71))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ClassConstantDeclarationKind, QStringLiteral("classConstantDeclaration"));
                        }
                        return false;
                    }
                    (*yynode)->constsSequence = snoc((*yynode)->constsSequence, __node_71, memoryPool);

                }
                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_USE)
        {
            if (yytoken != Token_USE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_USE, QStringLiteral("use"));
                }
                return false;
            }
            yylex();

            NamespacedIdentifierAst *__node_72 = nullptr;
            if (!parseNamespacedIdentifier(&__node_72))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->traitsSequence = snoc((*yynode)->traitsSequence, __node_72, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                NamespacedIdentifierAst *__node_73 = nullptr;
                if (!parseNamespacedIdentifier(&__node_73))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                    }
                    return false;
                }
                (*yynode)->traitsSequence = snoc((*yynode)->traitsSequence, __node_73, memoryPool);

            }
            if (yytoken == Token_LBRACE)
            {
                TraitAliasDeclarationAst *__node_74 = nullptr;
                if (!parseTraitAliasDeclaration(&__node_74))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::TraitAliasDeclarationKind, QStringLiteral("traitAliasDeclaration"));
                    }
                    return false;
                }
                (*yynode)->imports = __node_74;

            }
            else if (yytoken == Token_SEMICOLON)
            {
                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassVariable(ClassVariableAst **yynode)
{
    *yynode = create<ClassVariableAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_VARIABLE)
    {
        VariableIdentifierAst *__node_75 = nullptr;
        if (!parseVariableIdentifier(&__node_75))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
            }
            return false;
        }
        (*yynode)->variable = __node_75;

        if (yytoken == Token_ASSIGN)
        {
            if (yytoken != Token_ASSIGN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
                }
                return false;
            }
            yylex();

            StaticScalarAst *__node_76 = nullptr;
            if (!parseStaticScalar(&__node_76))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
                }
                return false;
            }
            (*yynode)->value = __node_76;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClassVariableDeclaration(ClassVariableDeclarationAst **yynode)
{
    *yynode = create<ClassVariableDeclarationAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_VARIABLE)
    {
        ClassVariableAst *__node_77 = nullptr;
        if (!parseClassVariable(&__node_77))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ClassVariableKind, QStringLiteral("classVariable"));
            }
            return false;
        }
        (*yynode)->varsSequence = snoc((*yynode)->varsSequence, __node_77, memoryPool);

        while (yytoken == Token_COMMA)
        {
            if (yytoken != Token_COMMA)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                }
                return false;
            }
            yylex();

            ClassVariableAst *__node_78 = nullptr;
            if (!parseClassVariable(&__node_78))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassVariableKind, QStringLiteral("classVariable"));
                }
                return false;
            }
            (*yynode)->varsSequence = snoc((*yynode)->varsSequence, __node_78, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseClosure(ClosureAst **yynode)
{
    *yynode = create<ClosureAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isRef = -1;

    if (yytoken == Token_FUNCTION)
    {
        if (yytoken != Token_FUNCTION)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_FUNCTION, QStringLiteral("function"));
            }
            return false;
        }
        yylex();

        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            (*yynode)->isRef = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken != Token_LPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
            }
            return false;
        }
        yylex();

        ParameterListAst *__node_79 = nullptr;
        if (!parseParameterList(&__node_79))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ParameterListKind, QStringLiteral("parameterList"));
            }
            return false;
        }
        (*yynode)->parameters = __node_79;

        if (yytoken != Token_RPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
            }
            return false;
        }
        yylex();

        if (yytoken == Token_USE)
        {
            if (yytoken != Token_USE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_USE, QStringLiteral("use"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            LexicalVarListAst *__node_80 = nullptr;
            if (!parseLexicalVarList(&__node_80))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::LexicalVarListKind, QStringLiteral("lexicalVarList"));
                }
                return false;
            }
            (*yynode)->lexicalVars = __node_80;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            ReturnTypeAst *__node_81 = nullptr;
            if (!parseReturnType(&__node_81))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ReturnTypeKind, QStringLiteral("returnType"));
                }
                return false;
            }
            (*yynode)->returnType = __node_81;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        qint64 try_startToken_4 = tokenStream->index() - 1;
        ParserState *try_startState_4 = copyCurrentState();
        {
            InnerStatementListAst *__node_82 = nullptr;
            if (!parseInnerStatementList(&__node_82))
            {
                goto __catch_4;
            }
            (*yynode)->functionBody = __node_82;

        }
        if (try_startState_4)
            delete try_startState_4;

        if (false) // the only way to enter here is using goto
        {
__catch_4:
            if (try_startState_4)
            {
                restoreState(try_startState_4);
                delete try_startState_4;
            }
            if (try_startToken_4 == tokenStream->index() - 1  && yytoken != Token_EOF)
                yylex();

            while (yytoken != Token_EOF
                   && yytoken != Token_RBRACE)
            {
                yylex();
            }
        }

        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCommonScalar(CommonScalarAst **yynode)
{
    *yynode = create<CommonScalarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->string = -1;

    if (yytoken == Token_CLASS_C
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_FILE
        || yytoken == Token_FUNC_C
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_TRAIT_C)
    {
        if (yytoken == Token_LNUMBER)
        {
            if (yytoken != Token_LNUMBER)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LNUMBER, QStringLiteral("long number"));
                }
                return false;
            }
            yylex();


# 864 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeInt;
        }
        else if (yytoken == Token_DNUMBER)
        {
            if (yytoken != Token_DNUMBER)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DNUMBER, QStringLiteral("double number"));
                }
                return false;
            }
            yylex();


# 865 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeFloat;
        }
        else if (yytoken == Token_CONSTANT_ENCAPSED_STRING)
        {
            if (yytoken != Token_CONSTANT_ENCAPSED_STRING)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONSTANT_ENCAPSED_STRING, QStringLiteral("constant encapsed string"));
                }
                return false;
            }
            (*yynode)->string = tokenStream->index() - 1;
            yylex();


# 866 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
            while (yytoken == Token_LBRACKET)
            {
                StringIndexSpecifierAst *__node_83 = nullptr;
                if (!parseStringIndexSpecifier(&__node_83))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StringIndexSpecifierKind, QStringLiteral("stringIndexSpecifier"));
                    }
                    return false;
                }
                (*yynode)->stringIndex = __node_83;

            }
        }
        else if (yytoken == Token_LINE)
        {
            if (yytoken != Token_LINE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LINE, QStringLiteral("__LINE__"));
                }
                return false;
            }
            yylex();


# 867 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeInt;
        }
        else if (yytoken == Token_DIR)
        {
            if (yytoken != Token_DIR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DIR, QStringLiteral("__DIR__"));
                }
                return false;
            }
            yylex();


# 868 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_FILE)
        {
            if (yytoken != Token_FILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FILE, QStringLiteral("__FILE__"));
                }
                return false;
            }
            yylex();


# 869 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_CLASS_C)
        {
            if (yytoken != Token_CLASS_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLASS_C, QStringLiteral("__CLASS__"));
                }
                return false;
            }
            yylex();


# 870 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_TRAIT_C)
        {
            if (yytoken != Token_TRAIT_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_TRAIT_C, QStringLiteral("__TRAIT__"));
                }
                return false;
            }
            yylex();


# 871 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_METHOD_C)
        {
            if (yytoken != Token_METHOD_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_METHOD_C, QStringLiteral("__METHOD__"));
                }
                return false;
            }
            yylex();


# 872 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_FUNC_C)
        {
            if (yytoken != Token_FUNC_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FUNC_C, QStringLiteral("__FUNCTION__"));
                }
                return false;
            }
            yylex();


# 873 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_NAMESPACE_C)
        {
            if (yytoken != Token_NAMESPACE_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_NAMESPACE_C, QStringLiteral("__NAMESPACE__"));
                }
                return false;
            }
            yylex();


# 874 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else if (yytoken == Token_START_NOWDOC)
        {
            if (yytoken != Token_START_NOWDOC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_START_NOWDOC, QStringLiteral("start nowdoc"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_STRING)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STRING, QStringLiteral("string"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_END_NOWDOC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_END_NOWDOC, QStringLiteral("end nowdoc"));
                }
                return false;
            }
            yylex();


# 875 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->scalarType = ScalarTypeString;
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCompoundVariable(CompoundVariableAst **yynode)
{
    *yynode = create<CompoundVariableAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_DOLLAR
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_VARIABLE)
        {
            VariableIdentifierAst *__node_84 = nullptr;
            if (!parseVariableIdentifier(&__node_84))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
                }
                return false;
            }
            (*yynode)->variable = __node_84;

        }
        else if (yytoken == Token_DOLLAR)
        {
            if (yytoken != Token_DOLLAR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOLLAR, QStringLiteral("$"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_85 = nullptr;
            if (!parseExpr(&__node_85))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_85;

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
        if (Token_EOF != yytoken)
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCompoundVariableWithSimpleIndirectReference(CompoundVariableWithSimpleIndirectReferenceAst **yynode)
{
    *yynode = create<CompoundVariableWithSimpleIndirectReferenceAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_DOLLAR
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_DOLLAR)
        {
            if (yytoken != Token_DOLLAR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOLLAR, QStringLiteral("$"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_DOLLAR)
            {
                do
                {
                    if (yytoken != Token_DOLLAR)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_DOLLAR, QStringLiteral("$"));
                        }
                        return false;
                    }
                    yylex();

                }
                while (yytoken == Token_DOLLAR);
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken == Token_VARIABLE)
            {
                VariableIdentifierAst *__node_86 = nullptr;
                if (!parseVariableIdentifier(&__node_86))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
                    }
                    return false;
                }
                (*yynode)->indirectVariable = __node_86;

            }
            else if (yytoken == Token_LBRACE)
            {
                if (yytoken != Token_LBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                    }
                    return false;
                }
                yylex();

                ExprAst *__node_87 = nullptr;
                if (!parseExpr(&__node_87))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->expr = __node_87;

                if (yytoken != Token_RBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_VARIABLE)
        {
            VariableIdentifierAst *__node_88 = nullptr;
            if (!parseVariableIdentifier(&__node_88))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
                }
                return false;
            }
            (*yynode)->variable = __node_88;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseConditionalExpression(ConditionalExpressionAst **yynode)
{
    *yynode = create<ConditionalExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        NullCoalesceExpressionAst *__node_89 = nullptr;
        if (!parseNullCoalesceExpression(&__node_89))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NullCoalesceExpressionKind, QStringLiteral("nullCoalesceExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_89;

        if (yytoken == Token_QUESTION)
        {
            if (yytoken != Token_QUESTION)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_QUESTION, QStringLiteral("?"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                ExprAst *__node_90 = nullptr;
                if (!parseExpr(&__node_90))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->ifExpression = __node_90;

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            ConditionalExpressionAst *__node_91 = nullptr;
            if (!parseConditionalExpression(&__node_91))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ConditionalExpressionKind, QStringLiteral("conditionalExpression"));
                }
                return false;
            }
            (*yynode)->elseExpression = __node_91;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseConstantDeclaration(ConstantDeclarationAst **yynode)
{
    *yynode = create<ConstantDeclarationAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_STRING)
    {
        IdentifierAst *__node_92 = nullptr;
        if (!parseIdentifier(&__node_92))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
            }
            return false;
        }
        (*yynode)->identifier = __node_92;

        if (yytoken != Token_ASSIGN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
            }
            return false;
        }
        yylex();

        ExprAst *__node_93 = nullptr;
        if (!parseExpr(&__node_93))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
            }
            return false;
        }
        (*yynode)->scalar = __node_93;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseConstantOrClassConst(ConstantOrClassConstAst **yynode)
{
    *yynode = create<ConstantOrClassConstAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        NamespacedIdentifierAst *__node_94 = nullptr;
        if (!parseNamespacedIdentifier(&__node_94))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->constant = __node_94;

        if (yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
        {
            if (yytoken != Token_PAAMAYIM_NEKUDOTAYIM)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PAAMAYIM_NEKUDOTAYIM, QStringLiteral("::"));
                }
                return false;
            }
            yylex();

            ClassConstantAst *__node_95 = nullptr;
            if (!parseClassConstant(&__node_95))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassConstantKind, QStringLiteral("classConstant"));
                }
                return false;
            }
            (*yynode)->classConstant = __node_95;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseCtorArguments(CtorArgumentsAst **yynode)
{
    *yynode = create<CtorArgumentsAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LPAREN || yytoken == Token_AND_ASSIGN
        || yytoken == Token_AS
        || yytoken == Token_ASSIGN
        || yytoken == Token_BIT_AND
        || yytoken == Token_BIT_OR
        || yytoken == Token_BIT_XOR
        || yytoken == Token_BOOLEAN_AND
        || yytoken == Token_BOOLEAN_OR
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_COLON
        || yytoken == Token_COMMA
        || yytoken == Token_CONCAT
        || yytoken == Token_CONCAT_ASSIGN
        || yytoken == Token_DEC
        || yytoken == Token_DIV
        || yytoken == Token_DIV_ASSIGN
        || yytoken == Token_DOUBLE_ARROW
        || yytoken == Token_EXP
        || yytoken == Token_EXP_ASSIGN
        || yytoken == Token_INC
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_IS_EQUAL
        || yytoken == Token_IS_GREATER
        || yytoken == Token_IS_GREATER_OR_EQUAL
        || yytoken == Token_IS_IDENTICAL
        || yytoken == Token_IS_NOT_EQUAL
        || yytoken == Token_IS_NOT_IDENTICAL
        || yytoken == Token_IS_SMALLER
        || yytoken == Token_IS_SMALLER_OR_EQUAL
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_MINUS
        || yytoken == Token_MINUS_ASSIGN
        || yytoken == Token_MOD
        || yytoken == Token_MOD_ASSIGN
        || yytoken == Token_MUL
        || yytoken == Token_MUL_ASSIGN
        || yytoken == Token_NULL_COALESCE
        || yytoken == Token_OR_ASSIGN
        || yytoken == Token_PLUS
        || yytoken == Token_PLUS_ASSIGN
        || yytoken == Token_QUESTION
        || yytoken == Token_RBRACE
        || yytoken == Token_RBRACKET
        || yytoken == Token_RPAREN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_SL
        || yytoken == Token_SL_ASSIGN
        || yytoken == Token_SPACESHIP
        || yytoken == Token_SR
        || yytoken == Token_SR_ASSIGN
        || yytoken == Token_XOR_ASSIGN)
    {
        if (yytoken == Token_LPAREN)
        {
            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            FunctionCallParameterListAst *__node_96 = nullptr;
            if (!parseFunctionCallParameterList(&__node_96))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                }
                return false;
            }
            (*yynode)->parameterList = __node_96;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseDeclareItem(DeclareItemAst **yynode)
{
    *yynode = create<DeclareItemAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_STRING)
    {
        if (yytoken != Token_STRING)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_STRING, QStringLiteral("string"));
            }
            return false;
        }
        yylex();

        if (yytoken != Token_ASSIGN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
            }
            return false;
        }
        yylex();

        StaticScalarAst *__node_97 = nullptr;
        if (!parseStaticScalar(&__node_97))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
            }
            return false;
        }
        (*yynode)->scalar = __node_97;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseDeclareStatement(DeclareStatementAst **yynode)
{
    *yynode = create<DeclareStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_COLON
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_BREAK
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CLOSE_TAG
            || yytoken == Token_CONST
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_CONTINUE
            || yytoken == Token_DEC
            || yytoken == Token_DECLARE
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DO
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_ECHO
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FOR
            || yytoken == Token_FOREACH
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_GLOBAL
            || yytoken == Token_GOTO
            || yytoken == Token_IF
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INLINE_HTML
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACE
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_OPEN_TAG
            || yytoken == Token_OPEN_TAG_WITH_ECHO
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_RETURN
            || yytoken == Token_SEMICOLON
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STATIC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_SWITCH
            || yytoken == Token_THROW
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_TRY
            || yytoken == Token_UNSET
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_USE
            || yytoken == Token_VARIABLE
            || yytoken == Token_WHILE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            StatementAst *__node_98 = nullptr;
            if (!parseStatement(&__node_98))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->statement = __node_98;

        }
        else if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            InnerStatementListAst *__node_99 = nullptr;
            if (!parseInnerStatementList(&__node_99))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_99;

            if (yytoken != Token_ENDDECLARE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDDECLARE, QStringLiteral("enddeclare"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_100 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_100))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseDimListItem(DimListItemAst **yynode)
{
    *yynode = create<DimListItemAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET)
    {
        if (yytoken == Token_LBRACKET)
        {
            ArrayIndexSpecifierAst *__node_101 = nullptr;
            if (!parseArrayIndexSpecifier(&__node_101))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ArrayIndexSpecifierKind, QStringLiteral("arrayIndexSpecifier"));
                }
                return false;
            }
            (*yynode)->arrayIndex = __node_101;

        }
        else if (yytoken == Token_LBRACE)
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_102 = nullptr;
            if (!parseExpr(&__node_102))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_102;

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseElseSingle(ElseSingleAst **yynode)
{
    *yynode = create<ElseSingleAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ELSE || yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CASE
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EOF
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_HALT_COMPILER
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INTERFACE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_RBRACE
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_ELSE)
        {
            if (yytoken != Token_ELSE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ELSE, QStringLiteral("else"));
                }
                return false;
            }
            yylex();

            StatementAst *__node_103 = nullptr;
            if (!parseStatement(&__node_103))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->statement = __node_103;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseElseifList(ElseifListAst **yynode)
{
    *yynode = create<ElseifListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ELSEIF || yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CASE
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EOF
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_HALT_COMPILER
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INTERFACE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_RBRACE
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        while (yytoken == Token_ELSEIF)
        {
            ElseifListItemAst *__node_104 = nullptr;
            if (!parseElseifListItem(&__node_104))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ElseifListItemKind, QStringLiteral("elseifListItem"));
                }
                return false;
            }
            (*yynode)->elseifListItemSequence = snoc((*yynode)->elseifListItemSequence, __node_104, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseElseifListItem(ElseifListItemAst **yynode)
{
    *yynode = create<ElseifListItemAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ELSEIF)
    {
        if (yytoken != Token_ELSEIF)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_ELSEIF, QStringLiteral("elseif"));
            }
            return false;
        }
        yylex();

        if (yytoken != Token_LPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
            }
            return false;
        }
        yylex();

        ExprAst *__node_105 = nullptr;
        if (!parseExpr(&__node_105))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
            }
            return false;
        }
        (*yynode)->expr = __node_105;

        if (yytoken != Token_RPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
            }
            return false;
        }
        yylex();

        StatementAst *__node_106 = nullptr;
        if (!parseStatement(&__node_106))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
            }
            return false;
        }
        (*yynode)->statement = __node_106;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseEncaps(EncapsAst **yynode)
{
    *yynode = create<EncapsAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->value = -1;

    if (yytoken == Token_CURLY_OPEN
        || yytoken == Token_DOLLAR_OPEN_CURLY_BRACES
        || yytoken == Token_ENCAPSED_AND_WHITESPACE
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_CURLY_OPEN
            || yytoken == Token_DOLLAR_OPEN_CURLY_BRACES
            || yytoken == Token_VARIABLE)
        {
            EncapsVarAst *__node_107 = nullptr;
            if (!parseEncapsVar(&__node_107))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EncapsVarKind, QStringLiteral("encapsVar"));
                }
                return false;
            }
            (*yynode)->var = __node_107;

        }
        else if (yytoken == Token_ENCAPSED_AND_WHITESPACE)
        {
            if (yytoken != Token_ENCAPSED_AND_WHITESPACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENCAPSED_AND_WHITESPACE, QStringLiteral("encapsed and whitespace"));
                }
                return false;
            }
            (*yynode)->value = tokenStream->index() - 1;
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseEncapsList(EncapsListAst **yynode)
{
    *yynode = create<EncapsListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_CURLY_OPEN
        || yytoken == Token_DOLLAR_OPEN_CURLY_BRACES
        || yytoken == Token_ENCAPSED_AND_WHITESPACE
        || yytoken == Token_VARIABLE || yytoken == Token_BACKTICK
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_END_HEREDOC)
    {
        while (yytoken == Token_CURLY_OPEN
               || yytoken == Token_DOLLAR_OPEN_CURLY_BRACES
               || yytoken == Token_ENCAPSED_AND_WHITESPACE
               || yytoken == Token_VARIABLE)
        {
            EncapsAst *__node_108 = nullptr;
            if (!parseEncaps(&__node_108))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EncapsKind, QStringLiteral("encaps"));
                }
                return false;
            }
            (*yynode)->encapsSequence = snoc((*yynode)->encapsSequence, __node_108, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseEncapsVar(EncapsVarAst **yynode)
{
    *yynode = create<EncapsVarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_CURLY_OPEN
        || yytoken == Token_DOLLAR_OPEN_CURLY_BRACES
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_DOLLAR_OPEN_CURLY_BRACES)
        {
            if (yytoken != Token_DOLLAR_OPEN_CURLY_BRACES)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOLLAR_OPEN_CURLY_BRACES, QStringLiteral("${"));
                }
                return false;
            }
            yylex();

            if ((yytoken == Token_STRING_VARNAME) && (
# 852 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                    LA(2).kind == Token_LBRACKET))
            {
                if (yytoken != Token_STRING_VARNAME)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_STRING_VARNAME, QStringLiteral("string varname"));
                    }
                    return false;
                }
                yylex();

                ArrayIndexSpecifierAst *__node_109 = nullptr;
                if (!parseArrayIndexSpecifier(&__node_109))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ArrayIndexSpecifierKind, QStringLiteral("arrayIndexSpecifier"));
                    }
                    return false;
                }
                (*yynode)->arrayIndex = __node_109;

                if (yytoken != Token_RBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                    }
                    return false;
                }
                yylex();

            }
            else if (yytoken == Token_ARRAY
                     || yytoken == Token_ARRAY_CAST
                     || yytoken == Token_AT
                     || yytoken == Token_BACKSLASH
                     || yytoken == Token_BACKTICK
                     || yytoken == Token_BANG
                     || yytoken == Token_BOOL_CAST
                     || yytoken == Token_CLASS_C
                     || yytoken == Token_CLONE
                     || yytoken == Token_CONSTANT_ENCAPSED_STRING
                     || yytoken == Token_DEC
                     || yytoken == Token_DIR
                     || yytoken == Token_DNUMBER
                     || yytoken == Token_DOLLAR
                     || yytoken == Token_DOUBLE_CAST
                     || yytoken == Token_DOUBLE_QUOTE
                     || yytoken == Token_EMPTY
                     || yytoken == Token_EVAL
                     || yytoken == Token_EXIT
                     || yytoken == Token_FILE
                     || yytoken == Token_FUNCTION
                     || yytoken == Token_FUNC_C
                     || yytoken == Token_INC
                     || yytoken == Token_INCLUDE
                     || yytoken == Token_INCLUDE_ONCE
                     || yytoken == Token_INT_CAST
                     || yytoken == Token_ISSET
                     || yytoken == Token_LBRACKET
                     || yytoken == Token_LINE
                     || yytoken == Token_LIST
                     || yytoken == Token_LNUMBER
                     || yytoken == Token_LPAREN
                     || yytoken == Token_METHOD_C
                     || yytoken == Token_MINUS
                     || yytoken == Token_NAMESPACE_C
                     || yytoken == Token_NEW
                     || yytoken == Token_OBJECT_CAST
                     || yytoken == Token_PLUS
                     || yytoken == Token_PRINT
                     || yytoken == Token_REQUIRE
                     || yytoken == Token_REQUIRE_ONCE
                     || yytoken == Token_START_HEREDOC
                     || yytoken == Token_START_NOWDOC
                     || yytoken == Token_STRING
                     || yytoken == Token_STRING_CAST
                     || yytoken == Token_STRING_VARNAME
                     || yytoken == Token_TILDE
                     || yytoken == Token_TRAIT_C
                     || yytoken == Token_UNSET_CAST
                     || yytoken == Token_VARIABLE
                     || yytoken == Token_YIELD
                     || yytoken == Token_YIELD_FROM)
            {
                ExprAst *__node_110 = nullptr;
                if (!parseExpr(&__node_110))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->expr = __node_110;

                if (yytoken != Token_RBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_VARIABLE)
        {
            VariableIdentifierAst *__node_111 = nullptr;
            if (!parseVariableIdentifier(&__node_111))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
                }
                return false;
            }
            (*yynode)->variable = __node_111;

            if (yytoken == Token_OBJECT_OPERATOR)
            {
                if (yytoken != Token_OBJECT_OPERATOR)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_OBJECT_OPERATOR, QStringLiteral("->"));
                    }
                    return false;
                }
                yylex();

                IdentifierAst *__node_112 = nullptr;
                if (!parseIdentifier(&__node_112))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                    }
                    return false;
                }
                (*yynode)->propertyIdentifier = __node_112;

            }
            else if (yytoken == Token_LBRACKET)
            {
                if (yytoken != Token_LBRACKET)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LBRACKET, QStringLiteral("["));
                    }
                    return false;
                }
                yylex();

                EncapsVarOffsetAst *__node_113 = nullptr;
                if (!parseEncapsVarOffset(&__node_113))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::EncapsVarOffsetKind, QStringLiteral("encapsVarOffset"));
                    }
                    return false;
                }
                (*yynode)->offset = __node_113;

                if (yytoken != Token_RBRACKET)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RBRACKET, QStringLiteral("]"));
                    }
                    return false;
                }
                yylex();

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_CURLY_OPEN)
        {
            if (yytoken != Token_CURLY_OPEN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CURLY_OPEN, QStringLiteral("curly open"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_114 = nullptr;
            if (!parseExpr(&__node_114))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_114;

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseEncapsVarOffset(EncapsVarOffsetAst **yynode)
{
    *yynode = create<EncapsVarOffsetAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_NUM_STRING
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_STRING)
        {
            if (yytoken != Token_STRING)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STRING, QStringLiteral("string"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_NUM_STRING)
        {
            if (yytoken != Token_NUM_STRING)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_NUM_STRING, QStringLiteral("num string"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_VARIABLE)
        {
            VariableIdentifierAst *__node_115 = nullptr;
            if (!parseVariableIdentifier(&__node_115))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseEqualityExpression(EqualityExpressionAst **yynode)
{
    *yynode = create<EqualityExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        RelationalExpressionAst *__node_116 = nullptr;
        if (!parseRelationalExpression(&__node_116))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::RelationalExpressionKind, QStringLiteral("relationalExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_116;

        if (yytoken == Token_IS_EQUAL
            || yytoken == Token_IS_IDENTICAL
            || yytoken == Token_IS_NOT_EQUAL
            || yytoken == Token_IS_NOT_IDENTICAL
            || yytoken == Token_SPACESHIP)
        {
            EqualityExpressionRestAst *__node_117 = nullptr;
            if (!parseEqualityExpressionRest(&__node_117))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EqualityExpressionRestKind, QStringLiteral("equalityExpressionRest"));
                }
                return false;
            }
            (*yynode)->additionalExpression = __node_117;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseEqualityExpressionRest(EqualityExpressionRestAst **yynode)
{
    *yynode = create<EqualityExpressionRestAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_IS_EQUAL
        || yytoken == Token_IS_IDENTICAL
        || yytoken == Token_IS_NOT_EQUAL
        || yytoken == Token_IS_NOT_IDENTICAL
        || yytoken == Token_SPACESHIP)
    {
        if (yytoken == Token_IS_EQUAL)
        {
            if (yytoken != Token_IS_EQUAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_EQUAL, QStringLiteral("=="));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IS_NOT_EQUAL)
        {
            if (yytoken != Token_IS_NOT_EQUAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_NOT_EQUAL, QStringLiteral("!="));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IS_IDENTICAL)
        {
            if (yytoken != Token_IS_IDENTICAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_IDENTICAL, QStringLiteral("==="));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IS_NOT_IDENTICAL)
        {
            if (yytoken != Token_IS_NOT_IDENTICAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_NOT_IDENTICAL, QStringLiteral("!=="));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_SPACESHIP)
        {
            if (yytoken != Token_SPACESHIP)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SPACESHIP, QStringLiteral("<=>"));
                }
                return false;
            }
            yylex();


# 444 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationSpaceship;
        }
        else
        {
            return false;
        }
        RelationalExpressionAst *__node_118 = nullptr;
        if (!parseRelationalExpression(&__node_118))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::RelationalExpressionKind, QStringLiteral("relationalExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_118;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseExpr(ExprAst **yynode)
{
    *yynode = create<ExprAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        LogicalOrExpressionAst *__node_119 = nullptr;
        if (!parseLogicalOrExpression(&__node_119))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::LogicalOrExpressionKind, QStringLiteral("logicalOrExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_119;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseForExpr(ForExprAst **yynode)
{
    *yynode = create<ForExprAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM || yytoken == Token_RPAREN
        || yytoken == Token_SEMICOLON)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_DEC
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_VARIABLE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            ExprAst *__node_120 = nullptr;
            if (!parseExpr(&__node_120))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->exprsSequence = snoc((*yynode)->exprsSequence, __node_120, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                ExprAst *__node_121 = nullptr;
                if (!parseExpr(&__node_121))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->exprsSequence = snoc((*yynode)->exprsSequence, __node_121, memoryPool);

            }
        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseForStatement(ForStatementAst **yynode)
{
    *yynode = create<ForStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_COLON
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_BREAK
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CLOSE_TAG
            || yytoken == Token_CONST
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_CONTINUE
            || yytoken == Token_DEC
            || yytoken == Token_DECLARE
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DO
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_ECHO
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FOR
            || yytoken == Token_FOREACH
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_GLOBAL
            || yytoken == Token_GOTO
            || yytoken == Token_IF
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INLINE_HTML
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACE
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_OPEN_TAG
            || yytoken == Token_OPEN_TAG_WITH_ECHO
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_RETURN
            || yytoken == Token_SEMICOLON
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STATIC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_SWITCH
            || yytoken == Token_THROW
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_TRY
            || yytoken == Token_UNSET
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_USE
            || yytoken == Token_VARIABLE
            || yytoken == Token_WHILE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            StatementAst *__node_122 = nullptr;
            if (!parseStatement(&__node_122))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->statement = __node_122;

        }
        else if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            InnerStatementListAst *__node_123 = nullptr;
            if (!parseInnerStatementList(&__node_123))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_123;

            if (yytoken != Token_ENDFOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDFOR, QStringLiteral("endfor"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_124 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_124))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseForeachStatement(ForeachStatementAst **yynode)
{
    *yynode = create<ForeachStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_COLON
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_BREAK
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CLOSE_TAG
            || yytoken == Token_CONST
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_CONTINUE
            || yytoken == Token_DEC
            || yytoken == Token_DECLARE
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DO
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_ECHO
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FOR
            || yytoken == Token_FOREACH
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_GLOBAL
            || yytoken == Token_GOTO
            || yytoken == Token_IF
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INLINE_HTML
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACE
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_OPEN_TAG
            || yytoken == Token_OPEN_TAG_WITH_ECHO
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_RETURN
            || yytoken == Token_SEMICOLON
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STATIC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_SWITCH
            || yytoken == Token_THROW
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_TRY
            || yytoken == Token_UNSET
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_USE
            || yytoken == Token_VARIABLE
            || yytoken == Token_WHILE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            StatementAst *__node_125 = nullptr;
            if (!parseStatement(&__node_125))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->statement = __node_125;

        }
        else if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            InnerStatementListAst *__node_126 = nullptr;
            if (!parseInnerStatementList(&__node_126))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_126;

            if (yytoken != Token_ENDFOREACH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDFOREACH, QStringLiteral("endforeach"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_127 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_127))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseForeachVariable(ForeachVariableAst **yynode)
{
    *yynode = create<ForeachVariableAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_BIT_AND
        || yytoken == Token_DOLLAR
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        VariableAst *__node_128 = nullptr;
        if (!parseVariable(&__node_128))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
            }
            return false;
        }
        (*yynode)->variable = __node_128;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseFunctionCall(FunctionCallAst **yynode)
{
    *yynode = create<FunctionCallAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_DOLLAR
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_BACKSLASH
            || yytoken == Token_STRING)
        {
            NamespacedIdentifierAst *__node_129 = nullptr;
            if (!parseNamespacedIdentifier(&__node_129))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->stringFunctionNameOrClass = __node_129;

            if (yytoken == Token_LPAREN)
            {
                if (yytoken != Token_LPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                    }
                    return false;
                }
                yylex();

                FunctionCallParameterListAst *__node_130 = nullptr;
                if (!parseFunctionCallParameterList(&__node_130))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                    }
                    return false;
                }
                (*yynode)->stringParameterList = __node_130;

                if (yytoken != Token_RPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                    }
                    return false;
                }
                yylex();

            }
            else if (yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
            {
                if (yytoken != Token_PAAMAYIM_NEKUDOTAYIM)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_PAAMAYIM_NEKUDOTAYIM, QStringLiteral("::"));
                    }
                    return false;
                }
                yylex();

                if (yytoken == Token_ABSTRACT
                    || yytoken == Token_ARRAY
                    || yytoken == Token_AS
                    || yytoken == Token_BREAK
                    || yytoken == Token_CALLABLE
                    || yytoken == Token_CASE
                    || yytoken == Token_CATCH
                    || yytoken == Token_CLASS
                    || yytoken == Token_CLASS_C
                    || yytoken == Token_CLONE
                    || yytoken == Token_CONST
                    || yytoken == Token_CONTINUE
                    || yytoken == Token_DECLARE
                    || yytoken == Token_DEFAULT
                    || yytoken == Token_DIR
                    || yytoken == Token_DO
                    || yytoken == Token_ECHO
                    || yytoken == Token_ELSE
                    || yytoken == Token_ELSEIF
                    || yytoken == Token_EMPTY
                    || yytoken == Token_ENDDECLARE
                    || yytoken == Token_ENDFOR
                    || yytoken == Token_ENDFOREACH
                    || yytoken == Token_ENDIF
                    || yytoken == Token_ENDSWITCH
                    || yytoken == Token_ENDWHILE
                    || yytoken == Token_EVAL
                    || yytoken == Token_EXIT
                    || yytoken == Token_EXTENDS
                    || yytoken == Token_FILE
                    || yytoken == Token_FINAL
                    || yytoken == Token_FINALLY
                    || yytoken == Token_FOR
                    || yytoken == Token_FOREACH
                    || yytoken == Token_FUNCTION
                    || yytoken == Token_FUNC_C
                    || yytoken == Token_GLOBAL
                    || yytoken == Token_GOTO
                    || yytoken == Token_IF
                    || yytoken == Token_IMPLEMENTS
                    || yytoken == Token_INCLUDE
                    || yytoken == Token_INCLUDE_ONCE
                    || yytoken == Token_INSTANCEOF
                    || yytoken == Token_INSTEADOF
                    || yytoken == Token_INTERFACE
                    || yytoken == Token_ISSET
                    || yytoken == Token_LINE
                    || yytoken == Token_LIST
                    || yytoken == Token_LOGICAL_AND
                    || yytoken == Token_LOGICAL_OR
                    || yytoken == Token_LOGICAL_XOR
                    || yytoken == Token_METHOD_C
                    || yytoken == Token_NAMESPACE
                    || yytoken == Token_NAMESPACE_C
                    || yytoken == Token_NEW
                    || yytoken == Token_PRINT
                    || yytoken == Token_PRIVATE
                    || yytoken == Token_PROTECTED
                    || yytoken == Token_PUBLIC
                    || yytoken == Token_REQUIRE
                    || yytoken == Token_REQUIRE_ONCE
                    || yytoken == Token_RETURN
                    || yytoken == Token_STATIC
                    || yytoken == Token_STRING
                    || yytoken == Token_SWITCH
                    || yytoken == Token_THROW
                    || yytoken == Token_TRAIT
                    || yytoken == Token_TRAIT_C
                    || yytoken == Token_TRY
                    || yytoken == Token_UNSET
                    || yytoken == Token_USE
                    || yytoken == Token_VAR
                    || yytoken == Token_WHILE
                    || yytoken == Token_YIELD)
                {
                    SemiReservedIdentifierAst *__node_131 = nullptr;
                    if (!parseSemiReservedIdentifier(&__node_131))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::SemiReservedIdentifierKind, QStringLiteral("semiReservedIdentifier"));
                        }
                        return false;
                    }
                    (*yynode)->stringFunctionName = __node_131;

                    if (yytoken != Token_LPAREN)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                        }
                        return false;
                    }
                    yylex();

                    FunctionCallParameterListAst *__node_132 = nullptr;
                    if (!parseFunctionCallParameterList(&__node_132))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                        }
                        return false;
                    }
                    (*yynode)->stringParameterList = __node_132;

                    if (yytoken != Token_RPAREN)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                        }
                        return false;
                    }
                    yylex();

                }
                else if (yytoken == Token_DOLLAR
                         || yytoken == Token_VARIABLE)
                {
                    VariableWithoutObjectsAst *__node_133 = nullptr;
                    if (!parseVariableWithoutObjects(&__node_133))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::VariableWithoutObjectsKind, QStringLiteral("variableWithoutObjects"));
                        }
                        return false;
                    }
                    (*yynode)->varFunctionName = __node_133;

                    if (yytoken != Token_LPAREN)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                        }
                        return false;
                    }
                    yylex();

                    FunctionCallParameterListAst *__node_134 = nullptr;
                    if (!parseFunctionCallParameterList(&__node_134))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                        }
                        return false;
                    }
                    (*yynode)->stringParameterList = __node_134;

                    if (yytoken != Token_RPAREN)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                        }
                        return false;
                    }
                    yylex();

                }
                else if (yytoken == Token_LBRACE)
                {
                    if (yytoken != Token_LBRACE)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                        }
                        return false;
                    }
                    yylex();

                    ExprAst *__node_135 = nullptr;
                    if (!parseExpr(&__node_135))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                        }
                        return false;
                    }
                    (*yynode)->expr = __node_135;

                    if (yytoken != Token_RBRACE)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                        }
                        return false;
                    }
                    yylex();

                    if (yytoken != Token_LPAREN)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                        }
                        return false;
                    }
                    yylex();

                    FunctionCallParameterListAst *__node_136 = nullptr;
                    if (!parseFunctionCallParameterList(&__node_136))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                        }
                        return false;
                    }
                    (*yynode)->stringParameterList = __node_136;

                    if (yytoken != Token_RPAREN)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                        }
                        return false;
                    }
                    yylex();

                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_DOLLAR
                 || yytoken == Token_VARIABLE)
        {
            VariableWithoutObjectsAst *__node_137 = nullptr;
            if (!parseVariableWithoutObjects(&__node_137))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableWithoutObjectsKind, QStringLiteral("variableWithoutObjects"));
                }
                return false;
            }
            (*yynode)->varFunctionName = __node_137;

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            FunctionCallParameterListAst *__node_138 = nullptr;
            if (!parseFunctionCallParameterList(&__node_138))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                }
                return false;
            }
            (*yynode)->varParameterList = __node_138;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseFunctionCallParameterList(FunctionCallParameterListAst **yynode)
{
    *yynode = create<FunctionCallParameterListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BIT_AND
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ELLIPSIS
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM || yytoken == Token_RPAREN)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BIT_AND
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_DEC
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_ELLIPSIS
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_VARIABLE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            FunctionCallParameterListElementAst *__node_139 = nullptr;
            if (!parseFunctionCallParameterListElement(&__node_139))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::FunctionCallParameterListElementKind, QStringLiteral("functionCallParameterListElement"));
                }
                return false;
            }
            (*yynode)->parametersSequence = snoc((*yynode)->parametersSequence, __node_139, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                FunctionCallParameterListElementAst *__node_140 = nullptr;
                if (!parseFunctionCallParameterListElement(&__node_140))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::FunctionCallParameterListElementKind, QStringLiteral("functionCallParameterListElement"));
                    }
                    return false;
                }
                (*yynode)->parametersSequence = snoc((*yynode)->parametersSequence, __node_140, memoryPool);

            }
        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseFunctionCallParameterListElement(FunctionCallParameterListElementAst **yynode)
{
    *yynode = create<FunctionCallParameterListElementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isVariadic = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BIT_AND
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ELLIPSIS
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            yylex();

            VariableAst *__node_141 = nullptr;
            if (!parseVariable(&__node_141))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->variable = __node_141;

        }
        else if (yytoken == Token_ARRAY
                 || yytoken == Token_ARRAY_CAST
                 || yytoken == Token_AT
                 || yytoken == Token_BACKSLASH
                 || yytoken == Token_BACKTICK
                 || yytoken == Token_BANG
                 || yytoken == Token_BOOL_CAST
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CONSTANT_ENCAPSED_STRING
                 || yytoken == Token_DEC
                 || yytoken == Token_DIR
                 || yytoken == Token_DNUMBER
                 || yytoken == Token_DOLLAR
                 || yytoken == Token_DOUBLE_CAST
                 || yytoken == Token_DOUBLE_QUOTE
                 || yytoken == Token_ELLIPSIS
                 || yytoken == Token_EMPTY
                 || yytoken == Token_EVAL
                 || yytoken == Token_EXIT
                 || yytoken == Token_FILE
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_INC
                 || yytoken == Token_INCLUDE
                 || yytoken == Token_INCLUDE_ONCE
                 || yytoken == Token_INT_CAST
                 || yytoken == Token_ISSET
                 || yytoken == Token_LBRACKET
                 || yytoken == Token_LINE
                 || yytoken == Token_LIST
                 || yytoken == Token_LNUMBER
                 || yytoken == Token_LPAREN
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_MINUS
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_OBJECT_CAST
                 || yytoken == Token_PLUS
                 || yytoken == Token_PRINT
                 || yytoken == Token_REQUIRE
                 || yytoken == Token_REQUIRE_ONCE
                 || yytoken == Token_START_HEREDOC
                 || yytoken == Token_START_NOWDOC
                 || yytoken == Token_STRING
                 || yytoken == Token_STRING_CAST
                 || yytoken == Token_STRING_VARNAME
                 || yytoken == Token_TILDE
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_UNSET_CAST
                 || yytoken == Token_VARIABLE
                 || yytoken == Token_YIELD
                 || yytoken == Token_YIELD_FROM)
        {
            if (yytoken == Token_ELLIPSIS)
            {
                if (yytoken != Token_ELLIPSIS)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_ELLIPSIS, QStringLiteral("..."));
                    }
                    return false;
                }
                (*yynode)->isVariadic = tokenStream->index() - 1;
                yylex();

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            ExprAst *__node_142 = nullptr;
            if (!parseExpr(&__node_142))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_142;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseFunctionDeclarationStatement(FunctionDeclarationStatementAst **yynode)
{
    *yynode = create<FunctionDeclarationStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_FUNCTION)
    {
        if (yytoken != Token_FUNCTION)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_FUNCTION, QStringLiteral("function"));
            }
            return false;
        }
        yylex();

        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        IdentifierAst *__node_143 = nullptr;
        if (!parseIdentifier(&__node_143))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
            }
            return false;
        }
        (*yynode)->functionName = __node_143;

        if (yytoken != Token_LPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
            }
            return false;
        }
        yylex();

        ParameterListAst *__node_144 = nullptr;
        if (!parseParameterList(&__node_144))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ParameterListKind, QStringLiteral("parameterList"));
            }
            return false;
        }
        (*yynode)->parameters = __node_144;

        if (yytoken != Token_RPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
            }
            return false;
        }
        yylex();

        if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            ReturnTypeAst *__node_145 = nullptr;
            if (!parseReturnType(&__node_145))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ReturnTypeKind, QStringLiteral("returnType"));
                }
                return false;
            }
            (*yynode)->returnType = __node_145;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        qint64 try_startToken_5 = tokenStream->index() - 1;
        ParserState *try_startState_5 = copyCurrentState();
        {
            InnerStatementListAst *__node_146 = nullptr;
            if (!parseInnerStatementList(&__node_146))
            {
                goto __catch_5;
            }
            (*yynode)->functionBody = __node_146;

        }
        if (try_startState_5)
            delete try_startState_5;

        if (false) // the only way to enter here is using goto
        {
__catch_5:
            if (try_startState_5)
            {
                restoreState(try_startState_5);
                delete try_startState_5;
            }
            if (try_startToken_5 == tokenStream->index() - 1  && yytoken != Token_EOF)
                yylex();

            while (yytoken != Token_EOF
                   && yytoken != Token_RBRACE)
            {
                yylex();
            }
        }

        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseGenericTypeHint(GenericTypeHintAst **yynode)
{
    *yynode = create<GenericTypeHintAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->arrayType = -1;
    (*yynode)->callableType = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CALLABLE
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_BACKSLASH
            || yytoken == Token_STRING)
        {
            NamespacedIdentifierAst *__node_147 = nullptr;
            if (!parseNamespacedIdentifier(&__node_147))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->genericType = __node_147;

        }
        else if (yytoken == Token_ARRAY)
        {
            if (yytoken != Token_ARRAY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ARRAY, QStringLiteral("array"));
                }
                return false;
            }
            (*yynode)->arrayType = tokenStream->index() - 1;
            yylex();

        }
        else if (yytoken == Token_CALLABLE)
        {
            if (yytoken != Token_CALLABLE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CALLABLE, QStringLiteral("callable"));
                }
                return false;
            }
            (*yynode)->callableType = tokenStream->index() - 1;
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseGlobalVar(GlobalVarAst **yynode)
{
    *yynode = create<GlobalVarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_DOLLAR
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_VARIABLE)
        {
            VariableIdentifierAst *__node_148 = nullptr;
            if (!parseVariableIdentifier(&__node_148))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
                }
                return false;
            }
            (*yynode)->var = __node_148;

        }
        else if (yytoken == Token_DOLLAR)
        {
            if (yytoken != Token_DOLLAR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOLLAR, QStringLiteral("$"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_BACKSLASH
                || yytoken == Token_DOLLAR
                || yytoken == Token_STRING
                || yytoken == Token_VARIABLE)
            {
                VariableAst *__node_149 = nullptr;
                if (!parseVariable(&__node_149))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                    }
                    return false;
                }
                (*yynode)->dollarVar = __node_149;

            }
            else if (yytoken == Token_LBRACE)
            {
                if (yytoken != Token_LBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                    }
                    return false;
                }
                yylex();

                ExprAst *__node_150 = nullptr;
                if (!parseExpr(&__node_150))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->expr = __node_150;

                if (yytoken != Token_RBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                    }
                    return false;
                }
                yylex();

            }
            else
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseIdentifier(IdentifierAst **yynode)
{
    *yynode = create<IdentifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->string = -1;

    if (yytoken == Token_STRING)
    {
        if (yytoken != Token_STRING)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_STRING, QStringLiteral("string"));
            }
            return false;
        }
        (*yynode)->string = tokenStream->index() - 1;
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseIifeSyntax(IifeSyntaxAst **yynode)
{
    *yynode = create<IifeSyntaxAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LPAREN)
    {
        if (yytoken != Token_LPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
            }
            return false;
        }
        yylex();

        bool blockErrors_6 = blockErrors(true);
        qint64 try_startToken_6 = tokenStream->index() - 1;
        ParserState *try_startState_6 = copyCurrentState();
        {
            ClosureAst *__node_151 = nullptr;
            if (!parseClosure(&__node_151))
            {
                goto __catch_6;
            }
            (*yynode)->closure = __node_151;

            if (yytoken != Token_RPAREN)
                goto __catch_6;
            yylex();

            if (yytoken != Token_LPAREN)
                goto __catch_6;
            yylex();

            FunctionCallParameterListAst *__node_152 = nullptr;
            if (!parseFunctionCallParameterList(&__node_152))
            {
                goto __catch_6;
            }
            (*yynode)->parameterList = __node_152;

            if (yytoken != Token_RPAREN)
                goto __catch_6;
            yylex();

        }
        blockErrors(blockErrors_6);
        if (try_startState_6)
            delete try_startState_6;

        if (false) // the only way to enter here is using goto
        {
__catch_6:
            if (try_startState_6)
            {
                restoreState(try_startState_6);
                delete try_startState_6;
            }
            blockErrors(blockErrors_6);
            rewind(try_startToken_6);

            ExprAst *__node_153 = nullptr;
            if (!parseExpr(&__node_153))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expression = __node_153;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseInnerStatementList(InnerStatementListAst **yynode)
{
    *yynode = create<InnerStatementListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_HALT_COMPILER
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INTERFACE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM || yytoken == Token_CASE
        || yytoken == Token_DEFAULT
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_RBRACE)
    {

# 299 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
        bool reported = false;
        while ( true )
        {
            while (yytoken == Token_ABSTRACT
                   || yytoken == Token_ARRAY
                   || yytoken == Token_ARRAY_CAST
                   || yytoken == Token_AT
                   || yytoken == Token_BACKSLASH
                   || yytoken == Token_BACKTICK
                   || yytoken == Token_BANG
                   || yytoken == Token_BOOL_CAST
                   || yytoken == Token_BREAK
                   || yytoken == Token_CLASS
                   || yytoken == Token_CLASS_C
                   || yytoken == Token_CLONE
                   || yytoken == Token_CLOSE_TAG
                   || yytoken == Token_CONST
                   || yytoken == Token_CONSTANT_ENCAPSED_STRING
                   || yytoken == Token_CONTINUE
                   || yytoken == Token_DEC
                   || yytoken == Token_DECLARE
                   || yytoken == Token_DIR
                   || yytoken == Token_DNUMBER
                   || yytoken == Token_DO
                   || yytoken == Token_DOLLAR
                   || yytoken == Token_DOUBLE_CAST
                   || yytoken == Token_DOUBLE_QUOTE
                   || yytoken == Token_ECHO
                   || yytoken == Token_EMPTY
                   || yytoken == Token_EVAL
                   || yytoken == Token_EXIT
                   || yytoken == Token_FILE
                   || yytoken == Token_FINAL
                   || yytoken == Token_FOR
                   || yytoken == Token_FOREACH
                   || yytoken == Token_FUNCTION
                   || yytoken == Token_FUNC_C
                   || yytoken == Token_GLOBAL
                   || yytoken == Token_GOTO
                   || yytoken == Token_HALT_COMPILER
                   || yytoken == Token_IF
                   || yytoken == Token_INC
                   || yytoken == Token_INCLUDE
                   || yytoken == Token_INCLUDE_ONCE
                   || yytoken == Token_INLINE_HTML
                   || yytoken == Token_INTERFACE
                   || yytoken == Token_INT_CAST
                   || yytoken == Token_ISSET
                   || yytoken == Token_LBRACE
                   || yytoken == Token_LBRACKET
                   || yytoken == Token_LINE
                   || yytoken == Token_LIST
                   || yytoken == Token_LNUMBER
                   || yytoken == Token_LPAREN
                   || yytoken == Token_METHOD_C
                   || yytoken == Token_MINUS
                   || yytoken == Token_NAMESPACE_C
                   || yytoken == Token_NEW
                   || yytoken == Token_OBJECT_CAST
                   || yytoken == Token_OPEN_TAG
                   || yytoken == Token_OPEN_TAG_WITH_ECHO
                   || yytoken == Token_PLUS
                   || yytoken == Token_PRINT
                   || yytoken == Token_REQUIRE
                   || yytoken == Token_REQUIRE_ONCE
                   || yytoken == Token_RETURN
                   || yytoken == Token_SEMICOLON
                   || yytoken == Token_START_HEREDOC
                   || yytoken == Token_START_NOWDOC
                   || yytoken == Token_STATIC
                   || yytoken == Token_STRING
                   || yytoken == Token_STRING_CAST
                   || yytoken == Token_STRING_VARNAME
                   || yytoken == Token_SWITCH
                   || yytoken == Token_THROW
                   || yytoken == Token_TILDE
                   || yytoken == Token_TRAIT
                   || yytoken == Token_TRAIT_C
                   || yytoken == Token_TRY
                   || yytoken == Token_UNSET
                   || yytoken == Token_UNSET_CAST
                   || yytoken == Token_USE
                   || yytoken == Token_VARIABLE
                   || yytoken == Token_WHILE
                   || yytoken == Token_YIELD
                   || yytoken == Token_YIELD_FROM)
            {
                qint64 try_startToken_7 = tokenStream->index() - 1;
                ParserState *try_startState_7 = copyCurrentState();
                {
                    TopStatementAst *__node_154 = nullptr;
                    if (!parseTopStatement(&__node_154))
                    {
                        goto __catch_7;
                    }
                    (*yynode)->statementsSequence = snoc((*yynode)->statementsSequence, __node_154, memoryPool);

                }
                if (try_startState_7)
                    delete try_startState_7;

                if (false) // the only way to enter here is using goto
                {
__catch_7:
                    if (try_startState_7)
                    {
                        restoreState(try_startState_7);
                        delete try_startState_7;
                    }
                    if (try_startToken_7 == tokenStream->index() - 1  && yytoken != Token_EOF)
                        yylex();

                    while (yytoken != Token_EOF
                           && yytoken != Token_LBRACKET
                           && yytoken != Token_TILDE
                           && yytoken != Token_TRY
                           && yytoken != Token_CONSTANT_ENCAPSED_STRING
                           && yytoken != Token_FOREACH
                           && yytoken != Token_EMPTY
                           && yytoken != Token_ABSTRACT
                           && yytoken != Token_ISSET
                           && yytoken != Token_OBJECT_CAST
                           && yytoken != Token_ELSE
                           && yytoken != Token_LBRACE
                           && yytoken != Token_FUNCTION
                           && yytoken != Token_EXIT
                           && yytoken != Token_STRING
                           && yytoken != Token_METHOD_C
                           && yytoken != Token_REQUIRE_ONCE
                           && yytoken != Token_YIELD_FROM
                           && yytoken != Token_WHILE
                           && yytoken != Token_VARIABLE
                           && yytoken != Token_ENDFOREACH
                           && yytoken != Token_START_HEREDOC
                           && yytoken != Token_DOLLAR
                           && yytoken != Token_HALT_COMPILER
                           && yytoken != Token_BREAK
                           && yytoken != Token_INC
                           && yytoken != Token_RETURN
                           && yytoken != Token_ELSEIF
                           && yytoken != Token_RBRACE
                           && yytoken != Token_BOOL_CAST
                           && yytoken != Token_STRING_VARNAME
                           && yytoken != Token_USE
                           && yytoken != Token_FUNC_C
                           && yytoken != Token_CONST
                           && yytoken != Token_INTERFACE
                           && yytoken != Token_ECHO
                           && yytoken != Token_DECLARE
                           && yytoken != Token_INT_CAST
                           && yytoken != Token_LPAREN
                           && yytoken != Token_FINAL
                           && yytoken != Token_CASE
                           && yytoken != Token_STATIC
                           && yytoken != Token_INCLUDE
                           && yytoken != Token_DEC
                           && yytoken != Token_ENDIF
                           && yytoken != Token_OPEN_TAG
                           && yytoken != Token_GLOBAL
                           && yytoken != Token_UNSET_CAST
                           && yytoken != Token_CONTINUE
                           && yytoken != Token_NEW
                           && yytoken != Token_LINE
                           && yytoken != Token_PRINT
                           && yytoken != Token_NAMESPACE_C
                           && yytoken != Token_DNUMBER
                           && yytoken != Token_DOUBLE_CAST
                           && yytoken != Token_ENDDECLARE
                           && yytoken != Token_BACKTICK
                           && yytoken != Token_LIST
                           && yytoken != Token_FOR
                           && yytoken != Token_SWITCH
                           && yytoken != Token_INCLUDE_ONCE
                           && yytoken != Token_BANG
                           && yytoken != Token_INLINE_HTML
                           && yytoken != Token_DIR
                           && yytoken != Token_SEMICOLON
                           && yytoken != Token_ENDWHILE
                           && yytoken != Token_AT
                           && yytoken != Token_CLOSE_TAG
                           && yytoken != Token_DEFAULT
                           && yytoken != Token_FILE
                           && yytoken != Token_PLUS
                           && yytoken != Token_GOTO
                           && yytoken != Token_STRING_CAST
                           && yytoken != Token_LNUMBER
                           && yytoken != Token_BACKSLASH
                           && yytoken != Token_ARRAY
                           && yytoken != Token_CLASS
                           && yytoken != Token_TRAIT_C
                           && yytoken != Token_EVAL
                           && yytoken != Token_IF
                           && yytoken != Token_DOUBLE_QUOTE
                           && yytoken != Token_THROW
                           && yytoken != Token_ENDFOR
                           && yytoken != Token_OPEN_TAG_WITH_ECHO
                           && yytoken != Token_UNSET
                           && yytoken != Token_TRAIT
                           && yytoken != Token_ARRAY_CAST
                           && yytoken != Token_DO
                           && yytoken != Token_MINUS
                           && yytoken != Token_CLONE
                           && yytoken != Token_ENDSWITCH
                           && yytoken != Token_START_NOWDOC
                           && yytoken != Token_CLASS_C
                           && yytoken != Token_REQUIRE
                           && yytoken != Token_YIELD)
                    {
                        yylex();
                    }
                }

            }

# 301 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            if (yytoken != Token_RBRACE && yytoken != Token_EOF && yytoken != Token_CLOSE_TAG
                && yytoken != Token_ELSEIF && yytoken != Token_ELSE
                && yytoken != Token_ENDIF && yytoken != Token_ENDFOREACH && yytoken != Token_ENDFOR
                && yytoken != Token_ENDWHILE && yytoken != Token_ENDSWITCH && yytoken != Token_ENDDECLARE
                && yytoken != Token_CASE && yytoken != Token_DEFAULT)
            {
                if (!reported)
                {
                    qint64 index = tokenStream->index() - 1;
                    Token &token = tokenStream->at(index);
                    QString tokenValue = token.kind != 0 ? tokenText(token.begin, token.end) : QStringLiteral("EOF");
                    reportProblem(Error, QStringLiteral("Unexpected token \"%1\".").arg(tokenValue));
                    reported = true;
                }
                yylex();
            }
            else
            {
                break;
            }
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseInstantiationAccess(InstantiationAccessAst **yynode)
{
    *yynode = create<InstantiationAccessAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_OBJECT_OPERATOR)
    {
        if (yytoken != Token_OBJECT_OPERATOR)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_OBJECT_OPERATOR, QStringLiteral("->"));
            }
            return false;
        }
        yylex();

        VariablePropertyAst *__node_155 = nullptr;
        if (!parseVariableProperty(&__node_155))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariablePropertyKind, QStringLiteral("variableProperty"));
            }
            return false;
        }
        (*yynode)->variableProperty = __node_155;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseInterfaceDeclarationStatement(InterfaceDeclarationStatementAst **yynode)
{
    *yynode = create<InterfaceDeclarationStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_INTERFACE)
    {
        if (yytoken != Token_INTERFACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_INTERFACE, QStringLiteral("interface"));
            }
            return false;
        }
        yylex();

        IdentifierAst *__node_156 = nullptr;
        if (!parseIdentifier(&__node_156))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
            }
            return false;
        }
        (*yynode)->interfaceName = __node_156;

        if (yytoken == Token_EXTENDS)
        {
            if (yytoken != Token_EXTENDS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EXTENDS, QStringLiteral("extends"));
                }
                return false;
            }
            yylex();

            ClassImplementsAst *__node_157 = nullptr;
            if (!parseClassImplements(&__node_157))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassImplementsKind, QStringLiteral("classImplements"));
                }
                return false;
            }
            (*yynode)->extends = __node_157;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        qint64 try_startToken_8 = tokenStream->index() - 1;
        ParserState *try_startState_8 = copyCurrentState();
        {
            ClassBodyAst *__node_158 = nullptr;
            if (!parseClassBody(&__node_158))
            {
                goto __catch_8;
            }
            (*yynode)->body = __node_158;

        }
        if (try_startState_8)
            delete try_startState_8;

        if (false) // the only way to enter here is using goto
        {
__catch_8:
            if (try_startState_8)
            {
                restoreState(try_startState_8);
                delete try_startState_8;
            }
            if (try_startToken_8 == tokenStream->index() - 1  && yytoken != Token_EOF)
                yylex();

            while (yytoken != Token_EOF
                   && yytoken != Token_RBRACE)
            {
                yylex();
            }
        }

        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseLexicalVar(LexicalVarAst **yynode)
{
    *yynode = create<LexicalVarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isRef = -1;

    if (yytoken == Token_BIT_AND
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            (*yynode)->isRef = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        VariableIdentifierAst *__node_159 = nullptr;
        if (!parseVariableIdentifier(&__node_159))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
            }
            return false;
        }
        (*yynode)->variable = __node_159;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseLexicalVarList(LexicalVarListAst **yynode)
{
    *yynode = create<LexicalVarListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BIT_AND
        || yytoken == Token_VARIABLE || yytoken == Token_RPAREN)
    {
        if (yytoken == Token_BIT_AND
            || yytoken == Token_VARIABLE)
        {
            LexicalVarAst *__node_160 = nullptr;
            if (!parseLexicalVar(&__node_160))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::LexicalVarKind, QStringLiteral("lexicalVar"));
                }
                return false;
            }
            (*yynode)->lexicalVarsSequence = snoc((*yynode)->lexicalVarsSequence, __node_160, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                LexicalVarAst *__node_161 = nullptr;
                if (!parseLexicalVar(&__node_161))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::LexicalVarKind, QStringLiteral("lexicalVar"));
                    }
                    return false;
                }
                (*yynode)->lexicalVarsSequence = snoc((*yynode)->lexicalVarsSequence, __node_161, memoryPool);

            }
        }
        else if (true /*epsilon*/)
        {

# 587 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            reportProblem(Error, QStringLiteral("Use list of closure must not be empty."));
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseLogicalAndExpression(LogicalAndExpressionAst **yynode)
{
    *yynode = create<LogicalAndExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        PrintExpressionAst *__node_162 = nullptr;
        if (!parsePrintExpression(&__node_162))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::PrintExpressionKind, QStringLiteral("printExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_162, memoryPool);

        while (yytoken == Token_LOGICAL_AND)
        {
            if (yytoken != Token_LOGICAL_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LOGICAL_AND, QStringLiteral("logical and"));
                }
                return false;
            }
            yylex();

            PrintExpressionAst *__node_163 = nullptr;
            if (!parsePrintExpression(&__node_163))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::PrintExpressionKind, QStringLiteral("printExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_163, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseLogicalOrExpression(LogicalOrExpressionAst **yynode)
{
    *yynode = create<LogicalOrExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        LogicalXorExpressionAst *__node_164 = nullptr;
        if (!parseLogicalXorExpression(&__node_164))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::LogicalXorExpressionKind, QStringLiteral("logicalXorExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_164, memoryPool);

        while (yytoken == Token_LOGICAL_OR)
        {
            if (yytoken != Token_LOGICAL_OR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LOGICAL_OR, QStringLiteral("logical or"));
                }
                return false;
            }
            yylex();

            LogicalXorExpressionAst *__node_165 = nullptr;
            if (!parseLogicalXorExpression(&__node_165))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::LogicalXorExpressionKind, QStringLiteral("logicalXorExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_165, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseLogicalXorExpression(LogicalXorExpressionAst **yynode)
{
    *yynode = create<LogicalXorExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        LogicalAndExpressionAst *__node_166 = nullptr;
        if (!parseLogicalAndExpression(&__node_166))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::LogicalAndExpressionKind, QStringLiteral("logicalAndExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_166, memoryPool);

        while (yytoken == Token_LOGICAL_XOR)
        {
            if (yytoken != Token_LOGICAL_XOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LOGICAL_XOR, QStringLiteral("logical xor"));
                }
                return false;
            }
            yylex();

            LogicalAndExpressionAst *__node_167 = nullptr;
            if (!parseLogicalAndExpression(&__node_167))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::LogicalAndExpressionKind, QStringLiteral("logicalAndExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_167, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseMethodBody(MethodBodyAst **yynode)
{
    *yynode = create<MethodBodyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACE
        || yytoken == Token_SEMICOLON)
    {
        if (yytoken == Token_SEMICOLON)
        {
            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LBRACE)
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            qint64 try_startToken_9 = tokenStream->index() - 1;
            ParserState *try_startState_9 = copyCurrentState();
            {
                InnerStatementListAst *__node_168 = nullptr;
                if (!parseInnerStatementList(&__node_168))
                {
                    goto __catch_9;
                }
                (*yynode)->statements = __node_168;

            }
            if (try_startState_9)
                delete try_startState_9;

            if (false) // the only way to enter here is using goto
            {
__catch_9:
                if (try_startState_9)
                {
                    restoreState(try_startState_9);
                    delete try_startState_9;
                }
                if (try_startToken_9 == tokenStream->index() - 1  && yytoken != Token_EOF)
                    yylex();

                while (yytoken != Token_EOF
                       && yytoken != Token_RBRACE)
                {
                    yylex();
                }
            }

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseMultiplicativeExpression(MultiplicativeExpressionAst **yynode)
{
    *yynode = create<MultiplicativeExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        UnaryExpressionAst *__node_169 = nullptr;
        if (!parseUnaryExpression(&__node_169))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_169;

        while (yytoken == Token_DIV
               || yytoken == Token_EXP
               || yytoken == Token_MOD
               || yytoken == Token_MUL)
        {
            MultiplicativeExpressionRestAst *__node_170 = nullptr;
            if (!parseMultiplicativeExpressionRest(&__node_170))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::MultiplicativeExpressionRestKind, QStringLiteral("multiplicativeExpressionRest"));
                }
                return false;
            }
            (*yynode)->additionalExpressionSequence = snoc((*yynode)->additionalExpressionSequence, __node_170, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseMultiplicativeExpressionRest(MultiplicativeExpressionRestAst **yynode)
{
    *yynode = create<MultiplicativeExpressionRestAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_DIV
        || yytoken == Token_EXP
        || yytoken == Token_MOD
        || yytoken == Token_MUL)
    {
        if (yytoken == Token_MUL)
        {
            if (yytoken != Token_MUL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_MUL, QStringLiteral("*"));
                }
                return false;
            }
            yylex();


# 493 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationMul;
        }
        else if (yytoken == Token_DIV)
        {
            if (yytoken != Token_DIV)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DIV, QStringLiteral("/"));
                }
                return false;
            }
            yylex();


# 494 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationDiv;
        }
        else if (yytoken == Token_EXP)
        {
            if (yytoken != Token_EXP)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EXP, QStringLiteral("**"));
                }
                return false;
            }
            yylex();


# 495 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationExp;
        }
        else if (yytoken == Token_MOD)
        {
            if (yytoken != Token_MOD)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_MOD, QStringLiteral("%"));
                }
                return false;
            }
            yylex();


# 496 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->operation = OperationMod;
        }
        else
        {
            return false;
        }
        UnaryExpressionAst *__node_171 = nullptr;
        if (!parseUnaryExpression(&__node_171))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_171;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseNamespaceDeclarationStatement(NamespaceDeclarationStatementAst **yynode)
{
    *yynode = create<NamespaceDeclarationStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_NAMESPACE)
    {
        if (yytoken != Token_NAMESPACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_NAMESPACE, QStringLiteral("namespace"));
            }
            return false;
        }
        yylex();

        while (yytoken == Token_STRING)
        {
            IdentifierAst *__node_172 = nullptr;
            if (!parseIdentifier(&__node_172))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                }
                return false;
            }
            (*yynode)->namespaceNameSequence = snoc((*yynode)->namespaceNameSequence, __node_172, memoryPool);

        }
        while (yytoken == Token_BACKSLASH)
        {
            if (yytoken != Token_BACKSLASH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BACKSLASH, QStringLiteral("\\"));
                }
                return false;
            }
            yylex();

            while (yytoken == Token_STRING)
            {
                IdentifierAst *__node_173 = nullptr;
                if (!parseIdentifier(&__node_173))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                    }
                    return false;
                }
                (*yynode)->namespaceNameSequence = snoc((*yynode)->namespaceNameSequence, __node_173, memoryPool);

            }
        }
        if (yytoken == Token_SEMICOLON)
        {
            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();


# 979 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            if (!(*yynode)->namespaceNameSequence)
            {
                reportProblem(Error, QStringLiteral("Missing namespace identifier."), -2);
            }
        }
        else if (yytoken == Token_LBRACE)
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            qint64 try_startToken_10 = tokenStream->index() - 1;
            ParserState *try_startState_10 = copyCurrentState();
            {
                InnerStatementListAst *__node_174 = nullptr;
                if (!parseInnerStatementList(&__node_174))
                {
                    goto __catch_10;
                }
                (*yynode)->body = __node_174;

            }
            if (try_startState_10)
                delete try_startState_10;

            if (false) // the only way to enter here is using goto
            {
__catch_10:
                if (try_startState_10)
                {
                    restoreState(try_startState_10);
                    delete try_startState_10;
                }
                if (try_startToken_10 == tokenStream->index() - 1  && yytoken != Token_EOF)
                    yylex();

                while (yytoken != Token_EOF
                       && yytoken != Token_RBRACE)
                {
                    yylex();
                }
            }

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseNamespacedIdentifier(NamespacedIdentifierAst **yynode)
{
    *yynode = create<NamespacedIdentifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isGlobal = -1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_BACKSLASH)
        {
            if (yytoken != Token_BACKSLASH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BACKSLASH, QStringLiteral("\\"));
                }
                return false;
            }
            (*yynode)->isGlobal = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        do
        {
            IdentifierAst *__node_175 = nullptr;
            if (!parseIdentifier(&__node_175))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                }
                return false;
            }
            (*yynode)->namespaceNameSequence = snoc((*yynode)->namespaceNameSequence, __node_175, memoryPool);

        }
        while (yytoken == Token_STRING);
        while (yytoken == Token_BACKSLASH)
        {
            if (yytoken != Token_BACKSLASH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BACKSLASH, QStringLiteral("\\"));
                }
                return false;
            }
            yylex();

            do
            {
                IdentifierAst *__node_176 = nullptr;
                if (!parseIdentifier(&__node_176))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                    }
                    return false;
                }
                (*yynode)->namespaceNameSequence = snoc((*yynode)->namespaceNameSequence, __node_176, memoryPool);

            }
            while (yytoken == Token_STRING);
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseNewElseSingle(NewElseSingleAst **yynode)
{
    *yynode = create<NewElseSingleAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ELSE || yytoken == Token_ENDIF)
    {
        if (yytoken == Token_ELSE)
        {
            if (yytoken != Token_ELSE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ELSE, QStringLiteral("else"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            InnerStatementListAst *__node_177 = nullptr;
            if (!parseInnerStatementList(&__node_177))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_177;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseNewElseifList(NewElseifListAst **yynode)
{
    *yynode = create<NewElseifListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ELSEIF || yytoken == Token_ELSE
        || yytoken == Token_ENDIF)
    {
        while (yytoken == Token_ELSEIF)
        {
            NewelseifListItemAst *__node_178 = nullptr;
            if (!parseNewelseifListItem(&__node_178))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NewelseifListItemKind, QStringLiteral("newelseifListItem"));
                }
                return false;
            }
            (*yynode)->newElseifListItemSequence = snoc((*yynode)->newElseifListItemSequence, __node_178, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseNewelseifListItem(NewelseifListItemAst **yynode)
{
    *yynode = create<NewelseifListItemAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ELSEIF)
    {
        if (yytoken != Token_ELSEIF)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_ELSEIF, QStringLiteral("elseif"));
            }
            return false;
        }
        yylex();

        if (yytoken != Token_LPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
            }
            return false;
        }
        yylex();

        ExprAst *__node_179 = nullptr;
        if (!parseExpr(&__node_179))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
            }
            return false;
        }
        (*yynode)->expr = __node_179;

        if (yytoken != Token_RPAREN)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
            }
            return false;
        }
        yylex();

        if (yytoken != Token_COLON)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
            }
            return false;
        }
        yylex();

        InnerStatementListAst *__node_180 = nullptr;
        if (!parseInnerStatementList(&__node_180))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
            }
            return false;
        }
        (*yynode)->statements = __node_180;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseNullCoalesceExpression(NullCoalesceExpressionAst **yynode)
{
    *yynode = create<NullCoalesceExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        BooleanOrExpressionAst *__node_181 = nullptr;
        if (!parseBooleanOrExpression(&__node_181))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::BooleanOrExpressionKind, QStringLiteral("booleanOrExpression"));
            }
            return false;
        }
        (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_181, memoryPool);

        while (yytoken == Token_NULL_COALESCE)
        {
            if (yytoken != Token_NULL_COALESCE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_NULL_COALESCE, QStringLiteral("??"));
                }
                return false;
            }
            yylex();

            BooleanOrExpressionAst *__node_182 = nullptr;
            if (!parseBooleanOrExpression(&__node_182))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::BooleanOrExpressionKind, QStringLiteral("booleanOrExpression"));
                }
                return false;
            }
            (*yynode)->expressionSequence = snoc((*yynode)->expressionSequence, __node_182, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseObjectDimList(ObjectDimListAst **yynode)
{
    *yynode = create<ObjectDimListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACE
        || yytoken == Token_STRING)
    {
        VariableNameAst *__node_183 = nullptr;
        if (!parseVariableName(&__node_183))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableNameKind, QStringLiteral("variableName"));
            }
            return false;
        }
        (*yynode)->variableName = __node_183;

        while (yytoken == Token_LBRACE
               || yytoken == Token_LBRACKET)
        {
            DimListItemAst *__node_184 = nullptr;
            if (!parseDimListItem(&__node_184))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::DimListItemKind, QStringLiteral("dimListItem"));
                }
                return false;
            }
            (*yynode)->offsetItemsSequence = snoc((*yynode)->offsetItemsSequence, __node_184, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseObjectOperator(ObjectOperatorAst **yynode)
{
    *yynode = create<ObjectOperatorAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_OBJECT_OPERATOR
        || yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
    {
        if (yytoken == Token_OBJECT_OPERATOR)
        {
            if (yytoken != Token_OBJECT_OPERATOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_OBJECT_OPERATOR, QStringLiteral("->"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
        {
            if (yytoken != Token_PAAMAYIM_NEKUDOTAYIM)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PAAMAYIM_NEKUDOTAYIM, QStringLiteral("::"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseObjectProperty(ObjectPropertyAst **yynode)
{
    *yynode = create<ObjectPropertyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_DOLLAR
        || yytoken == Token_LBRACE
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_LBRACE
            || yytoken == Token_STRING)
        {
            ObjectDimListAst *__node_185 = nullptr;
            if (!parseObjectDimList(&__node_185))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ObjectDimListKind, QStringLiteral("objectDimList"));
                }
                return false;
            }
            (*yynode)->objectDimList = __node_185;

        }
        else if (yytoken == Token_DOLLAR
                 || yytoken == Token_VARIABLE)
        {
            VariableWithoutObjectsAst *__node_186 = nullptr;
            if (!parseVariableWithoutObjects(&__node_186))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableWithoutObjectsKind, QStringLiteral("variableWithoutObjects"));
                }
                return false;
            }
            (*yynode)->variableWithoutObjects = __node_186;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseOptionalClassModifier(OptionalClassModifierAst **yynode)
{
    *yynode = create<OptionalClassModifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_FINAL || yytoken == Token_CLASS)
    {
        if (yytoken == Token_ABSTRACT)
        {
            if (yytoken != Token_ABSTRACT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ABSTRACT, QStringLiteral("abstract"));
                }
                return false;
            }
            yylex();


# 1092 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifier = AbstractClass;
        }
        else if (yytoken == Token_FINAL)
        {
            if (yytoken != Token_FINAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FINAL, QStringLiteral("final"));
                }
                return false;
            }
            yylex();


# 1093 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifier = FinalClass;
        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseOptionalModifiers(OptionalModifiersAst **yynode)
{
    *yynode = create<OptionalModifiersAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_FINAL
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_STATIC || yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CONST
        || yytoken == Token_FUNCTION
        || yytoken == Token_QUESTION
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        while (yytoken == Token_ABSTRACT
               || yytoken == Token_FINAL
               || yytoken == Token_PRIVATE
               || yytoken == Token_PROTECTED
               || yytoken == Token_PUBLIC
               || yytoken == Token_STATIC)
        {
            if (yytoken == Token_PUBLIC)
            {
                if (yytoken != Token_PUBLIC)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_PUBLIC, QStringLiteral("public"));
                    }
                    return false;
                }
                yylex();


# 1079 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->modifiers |= ModifierPublic;
            }
            else if (yytoken == Token_PROTECTED)
            {
                if (yytoken != Token_PROTECTED)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_PROTECTED, QStringLiteral("protected"));
                    }
                    return false;
                }
                yylex();


# 1080 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->modifiers |= ModifierProtected;
            }
            else if (yytoken == Token_PRIVATE)
            {
                if (yytoken != Token_PRIVATE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_PRIVATE, QStringLiteral("private"));
                    }
                    return false;
                }
                yylex();


# 1081 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->modifiers |= ModifierPrivate;
            }
            else if (yytoken == Token_STATIC)
            {
                if (yytoken != Token_STATIC)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_STATIC, QStringLiteral("static"));
                    }
                    return false;
                }
                yylex();


# 1082 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->modifiers |= ModifierStatic;
            }
            else if (yytoken == Token_ABSTRACT)
            {
                if (yytoken != Token_ABSTRACT)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_ABSTRACT, QStringLiteral("abstract"));
                    }
                    return false;
                }
                yylex();


# 1083 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->modifiers |= ModifierAbstract;
            }
            else if (yytoken == Token_FINAL)
            {
                if (yytoken != Token_FINAL)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_FINAL, QStringLiteral("final"));
                    }
                    return false;
                }
                yylex();


# 1084 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (*yynode)->modifiers |= ModifierFinal;
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseOuterTopStatement(OuterTopStatementAst **yynode)
{
    *yynode = create<OuterTopStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_HALT_COMPILER
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INTERFACE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_NAMESPACE)
        {
            NamespaceDeclarationStatementAst *__node_187 = nullptr;
            if (!parseNamespaceDeclarationStatement(&__node_187))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespaceDeclarationStatementKind, QStringLiteral("namespaceDeclarationStatement"));
                }
                return false;
            }
            (*yynode)->namespaceDeclaration = __node_187;

        }
        else if (yytoken == Token_ABSTRACT
                 || yytoken == Token_ARRAY
                 || yytoken == Token_ARRAY_CAST
                 || yytoken == Token_AT
                 || yytoken == Token_BACKSLASH
                 || yytoken == Token_BACKTICK
                 || yytoken == Token_BANG
                 || yytoken == Token_BOOL_CAST
                 || yytoken == Token_BREAK
                 || yytoken == Token_CLASS
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CLOSE_TAG
                 || yytoken == Token_CONST
                 || yytoken == Token_CONSTANT_ENCAPSED_STRING
                 || yytoken == Token_CONTINUE
                 || yytoken == Token_DEC
                 || yytoken == Token_DECLARE
                 || yytoken == Token_DIR
                 || yytoken == Token_DNUMBER
                 || yytoken == Token_DO
                 || yytoken == Token_DOLLAR
                 || yytoken == Token_DOUBLE_CAST
                 || yytoken == Token_DOUBLE_QUOTE
                 || yytoken == Token_ECHO
                 || yytoken == Token_EMPTY
                 || yytoken == Token_EVAL
                 || yytoken == Token_EXIT
                 || yytoken == Token_FILE
                 || yytoken == Token_FINAL
                 || yytoken == Token_FOR
                 || yytoken == Token_FOREACH
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_GLOBAL
                 || yytoken == Token_GOTO
                 || yytoken == Token_HALT_COMPILER
                 || yytoken == Token_IF
                 || yytoken == Token_INC
                 || yytoken == Token_INCLUDE
                 || yytoken == Token_INCLUDE_ONCE
                 || yytoken == Token_INLINE_HTML
                 || yytoken == Token_INTERFACE
                 || yytoken == Token_INT_CAST
                 || yytoken == Token_ISSET
                 || yytoken == Token_LBRACE
                 || yytoken == Token_LBRACKET
                 || yytoken == Token_LINE
                 || yytoken == Token_LIST
                 || yytoken == Token_LNUMBER
                 || yytoken == Token_LPAREN
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_MINUS
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_OBJECT_CAST
                 || yytoken == Token_OPEN_TAG
                 || yytoken == Token_OPEN_TAG_WITH_ECHO
                 || yytoken == Token_PLUS
                 || yytoken == Token_PRINT
                 || yytoken == Token_REQUIRE
                 || yytoken == Token_REQUIRE_ONCE
                 || yytoken == Token_RETURN
                 || yytoken == Token_SEMICOLON
                 || yytoken == Token_START_HEREDOC
                 || yytoken == Token_START_NOWDOC
                 || yytoken == Token_STATIC
                 || yytoken == Token_STRING
                 || yytoken == Token_STRING_CAST
                 || yytoken == Token_STRING_VARNAME
                 || yytoken == Token_SWITCH
                 || yytoken == Token_THROW
                 || yytoken == Token_TILDE
                 || yytoken == Token_TRAIT
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_TRY
                 || yytoken == Token_UNSET
                 || yytoken == Token_UNSET_CAST
                 || yytoken == Token_USE
                 || yytoken == Token_VARIABLE
                 || yytoken == Token_WHILE
                 || yytoken == Token_YIELD
                 || yytoken == Token_YIELD_FROM)
        {
            TopStatementAst *__node_188 = nullptr;
            if (!parseTopStatement(&__node_188))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::TopStatementKind, QStringLiteral("topStatement"));
                }
                return false;
            }
            (*yynode)->statement = __node_188;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseParameter(ParameterAst **yynode)
{
    *yynode = create<ParameterAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isRef = -1;
    (*yynode)->isVariadic = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BIT_AND
        || yytoken == Token_CALLABLE
        || yytoken == Token_ELLIPSIS
        || yytoken == Token_QUESTION
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_BACKSLASH
            || yytoken == Token_CALLABLE
            || yytoken == Token_QUESTION
            || yytoken == Token_STRING)
        {
            ParameterTypeAst *__node_189 = nullptr;
            if (!parseParameterType(&__node_189))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ParameterTypeKind, QStringLiteral("parameterType"));
                }
                return false;
            }
            (*yynode)->parameterType = __node_189;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken == Token_BIT_AND)
        {
            if (yytoken != Token_BIT_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BIT_AND, QStringLiteral("&"));
                }
                return false;
            }
            (*yynode)->isRef = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken == Token_ELLIPSIS)
        {
            if (yytoken != Token_ELLIPSIS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ELLIPSIS, QStringLiteral("..."));
                }
                return false;
            }
            (*yynode)->isVariadic = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        VariableIdentifierAst *__node_190 = nullptr;
        if (!parseVariableIdentifier(&__node_190))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
            }
            return false;
        }
        (*yynode)->variable = __node_190;

        if (yytoken == Token_ASSIGN)
        {
            if (yytoken != Token_ASSIGN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
                }
                return false;
            }
            yylex();

            ExprAst *__node_191 = nullptr;
            if (!parseExpr(&__node_191))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->defaultValue = __node_191;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseParameterList(ParameterListAst **yynode)
{
    *yynode = create<ParameterListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BIT_AND
        || yytoken == Token_CALLABLE
        || yytoken == Token_ELLIPSIS
        || yytoken == Token_QUESTION
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE || yytoken == Token_RPAREN)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BIT_AND
            || yytoken == Token_CALLABLE
            || yytoken == Token_ELLIPSIS
            || yytoken == Token_QUESTION
            || yytoken == Token_STRING
            || yytoken == Token_VARIABLE)
        {
            ParameterAst *__node_192 = nullptr;
            if (!parseParameter(&__node_192))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ParameterKind, QStringLiteral("parameter"));
                }
                return false;
            }
            (*yynode)->parametersSequence = snoc((*yynode)->parametersSequence, __node_192, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                ParameterAst *__node_193 = nullptr;
                if (!parseParameter(&__node_193))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ParameterKind, QStringLiteral("parameter"));
                    }
                    return false;
                }
                (*yynode)->parametersSequence = snoc((*yynode)->parametersSequence, __node_193, memoryPool);

            }
        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseParameterType(ParameterTypeAst **yynode)
{
    *yynode = create<ParameterTypeAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isNullable = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CALLABLE
        || yytoken == Token_QUESTION
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_QUESTION)
        {
            if (yytoken != Token_QUESTION)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_QUESTION, QStringLiteral("?"));
                }
                return false;
            }
            (*yynode)->isNullable = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        GenericTypeHintAst *__node_194 = nullptr;
        if (!parseGenericTypeHint(&__node_194))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::GenericTypeHintKind, QStringLiteral("genericTypeHint"));
            }
            return false;
        }
        (*yynode)->typehint = __node_194;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parsePostprefixOperator(PostprefixOperatorAst **yynode)
{
    *yynode = create<PostprefixOperatorAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->op = -1;
    (*yynode)->op = -1;

    if (yytoken == Token_DEC
        || yytoken == Token_INC)
    {
        if (yytoken == Token_INC)
        {
            if (yytoken != Token_INC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INC, QStringLiteral("++"));
                }
                return false;
            }
            (*yynode)->op = tokenStream->index() - 1;
            yylex();

        }
        else if (yytoken == Token_DEC)
        {
            if (yytoken != Token_DEC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DEC, QStringLiteral("--"));
                }
                return false;
            }
            (*yynode)->op = tokenStream->index() - 1;
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parsePrintExpression(PrintExpressionAst **yynode)
{
    *yynode = create<PrintExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->print = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_PRINT)
        {
            if (yytoken != Token_PRINT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PRINT, QStringLiteral("print"));
                }
                return false;
            }
            (*yynode)->print = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        AssignmentExpressionAst *__node_195 = nullptr;
        if (!parseAssignmentExpression(&__node_195))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::AssignmentExpressionKind, QStringLiteral("assignmentExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_195;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parsePropertyType(PropertyTypeAst **yynode)
{
    *yynode = create<PropertyTypeAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isNullable = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_QUESTION
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_QUESTION)
        {
            if (yytoken != Token_QUESTION)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_QUESTION, QStringLiteral("?"));
                }
                return false;
            }
            (*yynode)->isNullable = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        PropertyTypeHintAst *__node_196 = nullptr;
        if (!parsePropertyTypeHint(&__node_196))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::PropertyTypeHintKind, QStringLiteral("propertyTypeHint"));
            }
            return false;
        }
        (*yynode)->typehint = __node_196;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parsePropertyTypeHint(PropertyTypeHintAst **yynode)
{
    *yynode = create<PropertyTypeHintAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->arrayType = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_BACKSLASH
            || yytoken == Token_STRING)
        {
            NamespacedIdentifierAst *__node_197 = nullptr;
            if (!parseNamespacedIdentifier(&__node_197))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->genericType = __node_197;

        }
        else if (yytoken == Token_ARRAY)
        {
            if (yytoken != Token_ARRAY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ARRAY, QStringLiteral("array"));
                }
                return false;
            }
            (*yynode)->arrayType = tokenStream->index() - 1;
            yylex();

        }
        else
        {
            return false;
        }

# 1035 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
        (*yynode)->callableType = -1;
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseRelationalExpression(RelationalExpressionAst **yynode)
{
    *yynode = create<RelationalExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        ShiftExpressionAst *__node_198 = nullptr;
        if (!parseShiftExpression(&__node_198))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ShiftExpressionKind, QStringLiteral("shiftExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_198;

        if (yytoken == Token_IS_GREATER
            || yytoken == Token_IS_GREATER_OR_EQUAL
            || yytoken == Token_IS_SMALLER
            || yytoken == Token_IS_SMALLER_OR_EQUAL)
        {
            RelationalExpressionRestAst *__node_199 = nullptr;
            if (!parseRelationalExpressionRest(&__node_199))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::RelationalExpressionRestKind, QStringLiteral("relationalExpressionRest"));
                }
                return false;
            }
            (*yynode)->additionalExpression = __node_199;

        }
        else if (yytoken == Token_INSTANCEOF)
        {
            if (yytoken != Token_INSTANCEOF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INSTANCEOF, QStringLiteral("instanceof"));
                }
                return false;
            }
            yylex();

            ClassNameReferenceAst *__node_200 = nullptr;
            if (!parseClassNameReference(&__node_200))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassNameReferenceKind, QStringLiteral("classNameReference"));
                }
                return false;
            }
            (*yynode)->instanceofType = __node_200;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseRelationalExpressionRest(RelationalExpressionRestAst **yynode)
{
    *yynode = create<RelationalExpressionRestAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_IS_GREATER
        || yytoken == Token_IS_GREATER_OR_EQUAL
        || yytoken == Token_IS_SMALLER
        || yytoken == Token_IS_SMALLER_OR_EQUAL)
    {
        if (yytoken == Token_IS_SMALLER)
        {
            if (yytoken != Token_IS_SMALLER)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_SMALLER, QStringLiteral("<"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IS_GREATER)
        {
            if (yytoken != Token_IS_GREATER)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_GREATER, QStringLiteral(">"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IS_SMALLER_OR_EQUAL)
        {
            if (yytoken != Token_IS_SMALLER_OR_EQUAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_SMALLER_OR_EQUAL, QStringLiteral("<="));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IS_GREATER_OR_EQUAL)
        {
            if (yytoken != Token_IS_GREATER_OR_EQUAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IS_GREATER_OR_EQUAL, QStringLiteral(">="));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
        ShiftExpressionAst *__node_201 = nullptr;
        if (!parseShiftExpression(&__node_201))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ShiftExpressionKind, QStringLiteral("shiftExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_201;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseReservedNonModifierIdentifier(ReservedNonModifierIdentifierAst **yynode)
{
    *yynode = create<ReservedNonModifierIdentifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_AS
        || yytoken == Token_BREAK
        || yytoken == Token_CALLABLE
        || yytoken == Token_CASE
        || yytoken == Token_CATCH
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONST
        || yytoken == Token_CONTINUE
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DO
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_EXTENDS
        || yytoken == Token_FILE
        || yytoken == Token_FINALLY
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_IMPLEMENTS
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_INSTEADOF
        || yytoken == Token_INTERFACE
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_STRING
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD)
    {
        if (yytoken == Token_STRING)
        {
            IdentifierAst *__node_202 = nullptr;
            if (!parseIdentifier(&__node_202))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                }
                return false;
            }

# 960 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1

            qint64 index = tokenStream->index() - 2;
            (*yynode)->string = index;
        }
        else if (yytoken == Token_ARRAY
                 || yytoken == Token_AS
                 || yytoken == Token_BREAK
                 || yytoken == Token_CALLABLE
                 || yytoken == Token_CASE
                 || yytoken == Token_CATCH
                 || yytoken == Token_CLASS
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CONST
                 || yytoken == Token_CONTINUE
                 || yytoken == Token_DECLARE
                 || yytoken == Token_DEFAULT
                 || yytoken == Token_DIR
                 || yytoken == Token_DO
                 || yytoken == Token_ECHO
                 || yytoken == Token_ELSE
                 || yytoken == Token_ELSEIF
                 || yytoken == Token_EMPTY
                 || yytoken == Token_ENDDECLARE
                 || yytoken == Token_ENDFOR
                 || yytoken == Token_ENDFOREACH
                 || yytoken == Token_ENDIF
                 || yytoken == Token_ENDSWITCH
                 || yytoken == Token_ENDWHILE
                 || yytoken == Token_EVAL
                 || yytoken == Token_EXIT
                 || yytoken == Token_EXTENDS
                 || yytoken == Token_FILE
                 || yytoken == Token_FINALLY
                 || yytoken == Token_FOR
                 || yytoken == Token_FOREACH
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_GLOBAL
                 || yytoken == Token_GOTO
                 || yytoken == Token_IF
                 || yytoken == Token_IMPLEMENTS
                 || yytoken == Token_INCLUDE
                 || yytoken == Token_INCLUDE_ONCE
                 || yytoken == Token_INSTANCEOF
                 || yytoken == Token_INSTEADOF
                 || yytoken == Token_INTERFACE
                 || yytoken == Token_ISSET
                 || yytoken == Token_LINE
                 || yytoken == Token_LIST
                 || yytoken == Token_LOGICAL_AND
                 || yytoken == Token_LOGICAL_OR
                 || yytoken == Token_LOGICAL_XOR
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_NAMESPACE
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_PRINT
                 || yytoken == Token_REQUIRE
                 || yytoken == Token_REQUIRE_ONCE
                 || yytoken == Token_RETURN
                 || yytoken == Token_SWITCH
                 || yytoken == Token_THROW
                 || yytoken == Token_TRAIT
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_TRY
                 || yytoken == Token_UNSET
                 || yytoken == Token_USE
                 || yytoken == Token_VAR
                 || yytoken == Token_WHILE
                 || yytoken == Token_YIELD)
        {
            ReservedNonModifiersAst *__node_203 = nullptr;
            if (!parseReservedNonModifiers(&__node_203))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ReservedNonModifiersKind, QStringLiteral("reservedNonModifiers"));
                }
                return false;
            }

# 965 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1

            qint64 index = tokenStream->index() - 2;
            (*yynode)->string = index;
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseReservedNonModifiers(ReservedNonModifiersAst **yynode)
{
    *yynode = create<ReservedNonModifiersAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_AS
        || yytoken == Token_BREAK
        || yytoken == Token_CALLABLE
        || yytoken == Token_CASE
        || yytoken == Token_CATCH
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONST
        || yytoken == Token_CONTINUE
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DO
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_EXTENDS
        || yytoken == Token_FILE
        || yytoken == Token_FINALLY
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_IMPLEMENTS
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_INSTEADOF
        || yytoken == Token_INTERFACE
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD)
    {
        if (yytoken == Token_INCLUDE)
        {
            if (yytoken != Token_INCLUDE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INCLUDE, QStringLiteral("include"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_INCLUDE_ONCE)
        {
            if (yytoken != Token_INCLUDE_ONCE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INCLUDE_ONCE, QStringLiteral("include_once"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_EVAL)
        {
            if (yytoken != Token_EVAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EVAL, QStringLiteral("eval"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_REQUIRE)
        {
            if (yytoken != Token_REQUIRE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_REQUIRE, QStringLiteral("require"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_REQUIRE_ONCE)
        {
            if (yytoken != Token_REQUIRE_ONCE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_REQUIRE_ONCE, QStringLiteral("require_once"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LOGICAL_OR)
        {
            if (yytoken != Token_LOGICAL_OR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LOGICAL_OR, QStringLiteral("logical or"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LOGICAL_XOR)
        {
            if (yytoken != Token_LOGICAL_XOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LOGICAL_XOR, QStringLiteral("logical xor"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LOGICAL_AND)
        {
            if (yytoken != Token_LOGICAL_AND)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LOGICAL_AND, QStringLiteral("logical and"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_INSTANCEOF)
        {
            if (yytoken != Token_INSTANCEOF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INSTANCEOF, QStringLiteral("instanceof"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_NEW)
        {
            if (yytoken != Token_NEW)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_NEW, QStringLiteral("new"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CLONE)
        {
            if (yytoken != Token_CLONE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLONE, QStringLiteral("clone"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_EXIT)
        {
            if (yytoken != Token_EXIT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EXIT, QStringLiteral("exit"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IF)
        {
            if (yytoken != Token_IF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IF, QStringLiteral("if"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ELSEIF)
        {
            if (yytoken != Token_ELSEIF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ELSEIF, QStringLiteral("elseif"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ELSE)
        {
            if (yytoken != Token_ELSE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ELSE, QStringLiteral("else"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ENDIF)
        {
            if (yytoken != Token_ENDIF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDIF, QStringLiteral("endif"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ECHO)
        {
            if (yytoken != Token_ECHO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ECHO, QStringLiteral("echo"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_DO)
        {
            if (yytoken != Token_DO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DO, QStringLiteral("do"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_WHILE)
        {
            if (yytoken != Token_WHILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_WHILE, QStringLiteral("while"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ENDWHILE)
        {
            if (yytoken != Token_ENDWHILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDWHILE, QStringLiteral("endwhile"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FOR)
        {
            if (yytoken != Token_FOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FOR, QStringLiteral("for"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ENDFOR)
        {
            if (yytoken != Token_ENDFOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDFOR, QStringLiteral("endfor"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FOREACH)
        {
            if (yytoken != Token_FOREACH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FOREACH, QStringLiteral("foreach"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ENDFOREACH)
        {
            if (yytoken != Token_ENDFOREACH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDFOREACH, QStringLiteral("endforeach"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_DECLARE)
        {
            if (yytoken != Token_DECLARE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DECLARE, QStringLiteral("declare"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ENDDECLARE)
        {
            if (yytoken != Token_ENDDECLARE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDDECLARE, QStringLiteral("enddeclare"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_AS)
        {
            if (yytoken != Token_AS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_AS, QStringLiteral("as"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_TRY)
        {
            if (yytoken != Token_TRY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_TRY, QStringLiteral("try"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CATCH)
        {
            if (yytoken != Token_CATCH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CATCH, QStringLiteral("catch"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FINALLY)
        {
            if (yytoken != Token_FINALLY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FINALLY, QStringLiteral("finally"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_THROW)
        {
            if (yytoken != Token_THROW)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_THROW, QStringLiteral("throw"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_USE)
        {
            if (yytoken != Token_USE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_USE, QStringLiteral("use"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_INSTEADOF)
        {
            if (yytoken != Token_INSTEADOF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INSTEADOF, QStringLiteral("insteadof"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_GLOBAL)
        {
            if (yytoken != Token_GLOBAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_GLOBAL, QStringLiteral("global"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_VAR)
        {
            if (yytoken != Token_VAR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_VAR, QStringLiteral("var "));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_UNSET)
        {
            if (yytoken != Token_UNSET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_UNSET, QStringLiteral("unset"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ISSET)
        {
            if (yytoken != Token_ISSET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ISSET, QStringLiteral("isset"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_EMPTY)
        {
            if (yytoken != Token_EMPTY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EMPTY, QStringLiteral("empty"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CONTINUE)
        {
            if (yytoken != Token_CONTINUE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONTINUE, QStringLiteral("continue"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_GOTO)
        {
            if (yytoken != Token_GOTO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_GOTO, QStringLiteral("goto"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FUNCTION)
        {
            if (yytoken != Token_FUNCTION)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FUNCTION, QStringLiteral("function"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CONST)
        {
            if (yytoken != Token_CONST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONST, QStringLiteral("const"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_RETURN)
        {
            if (yytoken != Token_RETURN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RETURN, QStringLiteral("return"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_PRINT)
        {
            if (yytoken != Token_PRINT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PRINT, QStringLiteral("print"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_YIELD)
        {
            if (yytoken != Token_YIELD)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_YIELD, QStringLiteral("yield"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LIST)
        {
            if (yytoken != Token_LIST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LIST, QStringLiteral("list"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_SWITCH)
        {
            if (yytoken != Token_SWITCH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SWITCH, QStringLiteral("switch"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ENDSWITCH)
        {
            if (yytoken != Token_ENDSWITCH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDSWITCH, QStringLiteral("endswitch"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CASE)
        {
            if (yytoken != Token_CASE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CASE, QStringLiteral("case"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_DEFAULT)
        {
            if (yytoken != Token_DEFAULT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DEFAULT, QStringLiteral("default"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_BREAK)
        {
            if (yytoken != Token_BREAK)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BREAK, QStringLiteral("break"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ARRAY)
        {
            if (yytoken != Token_ARRAY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ARRAY, QStringLiteral("array"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CALLABLE)
        {
            if (yytoken != Token_CALLABLE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CALLABLE, QStringLiteral("callable"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_EXTENDS)
        {
            if (yytoken != Token_EXTENDS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EXTENDS, QStringLiteral("extends"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IMPLEMENTS)
        {
            if (yytoken != Token_IMPLEMENTS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IMPLEMENTS, QStringLiteral("implements"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_NAMESPACE)
        {
            if (yytoken != Token_NAMESPACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_NAMESPACE, QStringLiteral("namespace"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_TRAIT)
        {
            if (yytoken != Token_TRAIT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_TRAIT, QStringLiteral("trait"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_INTERFACE)
        {
            if (yytoken != Token_INTERFACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INTERFACE, QStringLiteral("interface"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CLASS)
        {
            if (yytoken != Token_CLASS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLASS, QStringLiteral("class"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CLASS_C)
        {
            if (yytoken != Token_CLASS_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLASS_C, QStringLiteral("__CLASS__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_TRAIT_C)
        {
            if (yytoken != Token_TRAIT_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_TRAIT_C, QStringLiteral("__TRAIT__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FUNC_C)
        {
            if (yytoken != Token_FUNC_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FUNC_C, QStringLiteral("__FUNCTION__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_METHOD_C)
        {
            if (yytoken != Token_METHOD_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_METHOD_C, QStringLiteral("__METHOD__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LINE)
        {
            if (yytoken != Token_LINE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LINE, QStringLiteral("__LINE__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FILE)
        {
            if (yytoken != Token_FILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FILE, QStringLiteral("__FILE__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_DIR)
        {
            if (yytoken != Token_DIR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DIR, QStringLiteral("__DIR__"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_NAMESPACE_C)
        {
            if (yytoken != Token_NAMESPACE_C)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_NAMESPACE_C, QStringLiteral("__NAMESPACE__"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseReturnType(ReturnTypeAst **yynode)
{
    *yynode = create<ReturnTypeAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isNullable = -1;
    (*yynode)->voidType = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CALLABLE
        || yytoken == Token_QUESTION
        || yytoken == Token_STRING
        || yytoken == Token_VOID)
    {
        if (yytoken == Token_QUESTION)
        {
            if (yytoken != Token_QUESTION)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_QUESTION, QStringLiteral("?"));
                }
                return false;
            }
            (*yynode)->isNullable = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        if (yytoken == Token_ARRAY
            || yytoken == Token_BACKSLASH
            || yytoken == Token_CALLABLE
            || yytoken == Token_STRING)
        {
            GenericTypeHintAst *__node_204 = nullptr;
            if (!parseGenericTypeHint(&__node_204))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::GenericTypeHintKind, QStringLiteral("genericTypeHint"));
                }
                return false;
            }
            (*yynode)->typehint = __node_204;

        }
        else if (yytoken == Token_VOID)
        {
            if (yytoken != Token_VOID)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_VOID, QStringLiteral("void"));
                }
                return false;
            }
            (*yynode)->voidType = tokenStream->index() - 1;
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseScalar(ScalarAst **yynode)
{
    *yynode = create<ScalarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->varname = -1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_CLASS_C
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_FILE
        || yytoken == Token_FUNC_C
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TRAIT_C)
    {
        if (yytoken == Token_CLASS_C
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_FILE
            || yytoken == Token_FUNC_C
            || yytoken == Token_LINE
            || yytoken == Token_LNUMBER
            || yytoken == Token_METHOD_C
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_TRAIT_C)
        {
            CommonScalarAst *__node_205 = nullptr;
            if (!parseCommonScalar(&__node_205))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::CommonScalarKind, QStringLiteral("commonScalar"));
                }
                return false;
            }
            (*yynode)->commonScalar = __node_205;

        }
        else if (yytoken == Token_BACKSLASH
                 || yytoken == Token_STRING)
        {
            ConstantOrClassConstAst *__node_206 = nullptr;
            if (!parseConstantOrClassConst(&__node_206))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ConstantOrClassConstKind, QStringLiteral("constantOrClassConst"));
                }
                return false;
            }
            (*yynode)->constantOrClassConst = __node_206;

            while (yytoken == Token_LBRACE
                   || yytoken == Token_LBRACKET)
            {
                DimListItemAst *__node_207 = nullptr;
                if (!parseDimListItem(&__node_207))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::DimListItemKind, QStringLiteral("dimListItem"));
                    }
                    return false;
                }
                (*yynode)->offsetItemSequence = snoc((*yynode)->offsetItemSequence, __node_207, memoryPool);

            }
        }
        else if (yytoken == Token_STRING_VARNAME)
        {
            if (yytoken != Token_STRING_VARNAME)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STRING_VARNAME, QStringLiteral("string varname"));
                }
                return false;
            }
            (*yynode)->varname = tokenStream->index() - 1;
            yylex();

        }
        else if (yytoken == Token_DOUBLE_QUOTE)
        {
            if (yytoken != Token_DOUBLE_QUOTE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOUBLE_QUOTE, QStringLiteral("\""));
                }
                return false;
            }
            yylex();

            EncapsListAst *__node_208 = nullptr;
            if (!parseEncapsList(&__node_208))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EncapsListKind, QStringLiteral("encapsList"));
                }
                return false;
            }
            (*yynode)->encapsList = __node_208;

            if (yytoken != Token_DOUBLE_QUOTE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOUBLE_QUOTE, QStringLiteral("\""));
                }
                return false;
            }
            yylex();

            while (yytoken == Token_LBRACKET)
            {
                StringIndexSpecifierAst *__node_209 = nullptr;
                if (!parseStringIndexSpecifier(&__node_209))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StringIndexSpecifierKind, QStringLiteral("stringIndexSpecifier"));
                    }
                    return false;
                }
                (*yynode)->stringIndex = __node_209;

            }
        }
        else if (yytoken == Token_START_HEREDOC)
        {
            if (yytoken != Token_START_HEREDOC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_START_HEREDOC, QStringLiteral("start heredoc"));
                }
                return false;
            }
            yylex();

            EncapsListAst *__node_210 = nullptr;
            if (!parseEncapsList(&__node_210))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EncapsListKind, QStringLiteral("encapsList"));
                }
                return false;
            }
            (*yynode)->encapsList = __node_210;

            if (yytoken != Token_END_HEREDOC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_END_HEREDOC, QStringLiteral("end heredoc"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseSemiReserved(SemiReservedAst **yynode)
{
    *yynode = create<SemiReservedAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_AS
        || yytoken == Token_BREAK
        || yytoken == Token_CALLABLE
        || yytoken == Token_CASE
        || yytoken == Token_CATCH
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONST
        || yytoken == Token_CONTINUE
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DO
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_EXTENDS
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FINALLY
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_IMPLEMENTS
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_INSTEADOF
        || yytoken == Token_INTERFACE
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_STATIC
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_AS
            || yytoken == Token_BREAK
            || yytoken == Token_CALLABLE
            || yytoken == Token_CASE
            || yytoken == Token_CATCH
            || yytoken == Token_CLASS
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CONST
            || yytoken == Token_CONTINUE
            || yytoken == Token_DECLARE
            || yytoken == Token_DEFAULT
            || yytoken == Token_DIR
            || yytoken == Token_DO
            || yytoken == Token_ECHO
            || yytoken == Token_ELSE
            || yytoken == Token_ELSEIF
            || yytoken == Token_EMPTY
            || yytoken == Token_ENDDECLARE
            || yytoken == Token_ENDFOR
            || yytoken == Token_ENDFOREACH
            || yytoken == Token_ENDIF
            || yytoken == Token_ENDSWITCH
            || yytoken == Token_ENDWHILE
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_EXTENDS
            || yytoken == Token_FILE
            || yytoken == Token_FINALLY
            || yytoken == Token_FOR
            || yytoken == Token_FOREACH
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_GLOBAL
            || yytoken == Token_GOTO
            || yytoken == Token_IF
            || yytoken == Token_IMPLEMENTS
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INSTANCEOF
            || yytoken == Token_INSTEADOF
            || yytoken == Token_INTERFACE
            || yytoken == Token_ISSET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LOGICAL_AND
            || yytoken == Token_LOGICAL_OR
            || yytoken == Token_LOGICAL_XOR
            || yytoken == Token_METHOD_C
            || yytoken == Token_NAMESPACE
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_RETURN
            || yytoken == Token_SWITCH
            || yytoken == Token_THROW
            || yytoken == Token_TRAIT
            || yytoken == Token_TRAIT_C
            || yytoken == Token_TRY
            || yytoken == Token_UNSET
            || yytoken == Token_USE
            || yytoken == Token_VAR
            || yytoken == Token_WHILE
            || yytoken == Token_YIELD)
        {
            ReservedNonModifiersAst *__node_211 = nullptr;
            if (!parseReservedNonModifiers(&__node_211))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ReservedNonModifiersKind, QStringLiteral("reservedNonModifiers"));
                }
                return false;
            }
        }
        else if (yytoken == Token_STATIC)
        {
            if (yytoken != Token_STATIC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STATIC, QStringLiteral("static"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_ABSTRACT)
        {
            if (yytoken != Token_ABSTRACT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ABSTRACT, QStringLiteral("abstract"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_FINAL)
        {
            if (yytoken != Token_FINAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FINAL, QStringLiteral("final"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_PRIVATE)
        {
            if (yytoken != Token_PRIVATE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PRIVATE, QStringLiteral("private"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_PROTECTED)
        {
            if (yytoken != Token_PROTECTED)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PROTECTED, QStringLiteral("protected"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_PUBLIC)
        {
            if (yytoken != Token_PUBLIC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PUBLIC, QStringLiteral("public"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseSemiReservedIdentifier(SemiReservedIdentifierAst **yynode)
{
    *yynode = create<SemiReservedIdentifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_AS
        || yytoken == Token_BREAK
        || yytoken == Token_CALLABLE
        || yytoken == Token_CASE
        || yytoken == Token_CATCH
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONST
        || yytoken == Token_CONTINUE
        || yytoken == Token_DECLARE
        || yytoken == Token_DEFAULT
        || yytoken == Token_DIR
        || yytoken == Token_DO
        || yytoken == Token_ECHO
        || yytoken == Token_ELSE
        || yytoken == Token_ELSEIF
        || yytoken == Token_EMPTY
        || yytoken == Token_ENDDECLARE
        || yytoken == Token_ENDFOR
        || yytoken == Token_ENDFOREACH
        || yytoken == Token_ENDIF
        || yytoken == Token_ENDSWITCH
        || yytoken == Token_ENDWHILE
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_EXTENDS
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FINALLY
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_IMPLEMENTS
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INSTANCEOF
        || yytoken == Token_INSTEADOF
        || yytoken == Token_INTERFACE
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LOGICAL_AND
        || yytoken == Token_LOGICAL_OR
        || yytoken == Token_LOGICAL_XOR
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_USE
        || yytoken == Token_VAR
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD)
    {
        if (yytoken == Token_STRING)
        {
            IdentifierAst *__node_212 = nullptr;
            if (!parseIdentifier(&__node_212))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                }
                return false;
            }

# 946 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1

            qint64 index = tokenStream->index() - 2;
            (*yynode)->string = index;
        }
        else if (yytoken == Token_ABSTRACT
                 || yytoken == Token_ARRAY
                 || yytoken == Token_AS
                 || yytoken == Token_BREAK
                 || yytoken == Token_CALLABLE
                 || yytoken == Token_CASE
                 || yytoken == Token_CATCH
                 || yytoken == Token_CLASS
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CONST
                 || yytoken == Token_CONTINUE
                 || yytoken == Token_DECLARE
                 || yytoken == Token_DEFAULT
                 || yytoken == Token_DIR
                 || yytoken == Token_DO
                 || yytoken == Token_ECHO
                 || yytoken == Token_ELSE
                 || yytoken == Token_ELSEIF
                 || yytoken == Token_EMPTY
                 || yytoken == Token_ENDDECLARE
                 || yytoken == Token_ENDFOR
                 || yytoken == Token_ENDFOREACH
                 || yytoken == Token_ENDIF
                 || yytoken == Token_ENDSWITCH
                 || yytoken == Token_ENDWHILE
                 || yytoken == Token_EVAL
                 || yytoken == Token_EXIT
                 || yytoken == Token_EXTENDS
                 || yytoken == Token_FILE
                 || yytoken == Token_FINAL
                 || yytoken == Token_FINALLY
                 || yytoken == Token_FOR
                 || yytoken == Token_FOREACH
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_GLOBAL
                 || yytoken == Token_GOTO
                 || yytoken == Token_IF
                 || yytoken == Token_IMPLEMENTS
                 || yytoken == Token_INCLUDE
                 || yytoken == Token_INCLUDE_ONCE
                 || yytoken == Token_INSTANCEOF
                 || yytoken == Token_INSTEADOF
                 || yytoken == Token_INTERFACE
                 || yytoken == Token_ISSET
                 || yytoken == Token_LINE
                 || yytoken == Token_LIST
                 || yytoken == Token_LOGICAL_AND
                 || yytoken == Token_LOGICAL_OR
                 || yytoken == Token_LOGICAL_XOR
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_NAMESPACE
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_PRINT
                 || yytoken == Token_PRIVATE
                 || yytoken == Token_PROTECTED
                 || yytoken == Token_PUBLIC
                 || yytoken == Token_REQUIRE
                 || yytoken == Token_REQUIRE_ONCE
                 || yytoken == Token_RETURN
                 || yytoken == Token_STATIC
                 || yytoken == Token_SWITCH
                 || yytoken == Token_THROW
                 || yytoken == Token_TRAIT
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_TRY
                 || yytoken == Token_UNSET
                 || yytoken == Token_USE
                 || yytoken == Token_VAR
                 || yytoken == Token_WHILE
                 || yytoken == Token_YIELD)
        {
            SemiReservedAst *__node_213 = nullptr;
            if (!parseSemiReserved(&__node_213))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemiReservedKind, QStringLiteral("semiReserved"));
                }
                return false;
            }

# 951 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1

            qint64 index = tokenStream->index() - 2;
            (*yynode)->string = index;
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseSemicolonOrCloseTag(SemicolonOrCloseTagAst **yynode)
{
    *yynode = create<SemicolonOrCloseTagAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_CLOSE_TAG
        || yytoken == Token_SEMICOLON)
    {
        if (yytoken == Token_SEMICOLON)
        {
            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CLOSE_TAG)
        {
            if (yytoken != Token_CLOSE_TAG)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLOSE_TAG, QStringLiteral("?>"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseShiftExpression(ShiftExpressionAst **yynode)
{
    *yynode = create<ShiftExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        AdditiveExpressionAst *__node_214 = nullptr;
        if (!parseAdditiveExpression(&__node_214))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::AdditiveExpressionKind, QStringLiteral("additiveExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_214;

        while (yytoken == Token_SL
               || yytoken == Token_SR)
        {
            ShiftExpressionRestAst *__node_215 = nullptr;
            if (!parseShiftExpressionRest(&__node_215))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ShiftExpressionRestKind, QStringLiteral("shiftExpressionRest"));
                }
                return false;
            }
            (*yynode)->additionalExpressionSequence = snoc((*yynode)->additionalExpressionSequence, __node_215, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseShiftExpressionRest(ShiftExpressionRestAst **yynode)
{
    *yynode = create<ShiftExpressionRestAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_SL
        || yytoken == Token_SR)
    {
        if (yytoken == Token_SL)
        {
            if (yytoken != Token_SL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SL, QStringLiteral("<<"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_SR)
        {
            if (yytoken != Token_SR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SR, QStringLiteral(">>"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
        AdditiveExpressionAst *__node_216 = nullptr;
        if (!parseAdditiveExpression(&__node_216))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::AdditiveExpressionKind, QStringLiteral("additiveExpression"));
            }
            return false;
        }
        (*yynode)->expression = __node_216;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStart(StartAst **yynode)
{
    *yynode = create<StartAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_HALT_COMPILER
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INTERFACE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM || yytoken == Token_EOF)
    {
        while (yytoken == Token_ABSTRACT
               || yytoken == Token_ARRAY
               || yytoken == Token_ARRAY_CAST
               || yytoken == Token_AT
               || yytoken == Token_BACKSLASH
               || yytoken == Token_BACKTICK
               || yytoken == Token_BANG
               || yytoken == Token_BOOL_CAST
               || yytoken == Token_BREAK
               || yytoken == Token_CLASS
               || yytoken == Token_CLASS_C
               || yytoken == Token_CLONE
               || yytoken == Token_CLOSE_TAG
               || yytoken == Token_CONST
               || yytoken == Token_CONSTANT_ENCAPSED_STRING
               || yytoken == Token_CONTINUE
               || yytoken == Token_DEC
               || yytoken == Token_DECLARE
               || yytoken == Token_DIR
               || yytoken == Token_DNUMBER
               || yytoken == Token_DO
               || yytoken == Token_DOLLAR
               || yytoken == Token_DOUBLE_CAST
               || yytoken == Token_DOUBLE_QUOTE
               || yytoken == Token_ECHO
               || yytoken == Token_EMPTY
               || yytoken == Token_EVAL
               || yytoken == Token_EXIT
               || yytoken == Token_FILE
               || yytoken == Token_FINAL
               || yytoken == Token_FOR
               || yytoken == Token_FOREACH
               || yytoken == Token_FUNCTION
               || yytoken == Token_FUNC_C
               || yytoken == Token_GLOBAL
               || yytoken == Token_GOTO
               || yytoken == Token_HALT_COMPILER
               || yytoken == Token_IF
               || yytoken == Token_INC
               || yytoken == Token_INCLUDE
               || yytoken == Token_INCLUDE_ONCE
               || yytoken == Token_INLINE_HTML
               || yytoken == Token_INTERFACE
               || yytoken == Token_INT_CAST
               || yytoken == Token_ISSET
               || yytoken == Token_LBRACE
               || yytoken == Token_LBRACKET
               || yytoken == Token_LINE
               || yytoken == Token_LIST
               || yytoken == Token_LNUMBER
               || yytoken == Token_LPAREN
               || yytoken == Token_METHOD_C
               || yytoken == Token_MINUS
               || yytoken == Token_NAMESPACE
               || yytoken == Token_NAMESPACE_C
               || yytoken == Token_NEW
               || yytoken == Token_OBJECT_CAST
               || yytoken == Token_OPEN_TAG
               || yytoken == Token_OPEN_TAG_WITH_ECHO
               || yytoken == Token_PLUS
               || yytoken == Token_PRINT
               || yytoken == Token_REQUIRE
               || yytoken == Token_REQUIRE_ONCE
               || yytoken == Token_RETURN
               || yytoken == Token_SEMICOLON
               || yytoken == Token_START_HEREDOC
               || yytoken == Token_START_NOWDOC
               || yytoken == Token_STATIC
               || yytoken == Token_STRING
               || yytoken == Token_STRING_CAST
               || yytoken == Token_STRING_VARNAME
               || yytoken == Token_SWITCH
               || yytoken == Token_THROW
               || yytoken == Token_TILDE
               || yytoken == Token_TRAIT
               || yytoken == Token_TRAIT_C
               || yytoken == Token_TRY
               || yytoken == Token_UNSET
               || yytoken == Token_UNSET_CAST
               || yytoken == Token_USE
               || yytoken == Token_VARIABLE
               || yytoken == Token_WHILE
               || yytoken == Token_YIELD
               || yytoken == Token_YIELD_FROM)
        {
            OuterTopStatementAst *__node_217 = nullptr;
            if (!parseOuterTopStatement(&__node_217))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::OuterTopStatementKind, QStringLiteral("outerTopStatement"));
                }
                return false;
            }
            (*yynode)->statementsSequence = snoc((*yynode)->statementsSequence, __node_217, memoryPool);

        }
        if (Token_EOF != yytoken)
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStatement(StatementAst **yynode)
{
    *yynode = create<StatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->gotoLabel = -1;
    (*yynode)->gotoTarget = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_LBRACE)
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            qint64 try_startToken_11 = tokenStream->index() - 1;
            ParserState *try_startState_11 = copyCurrentState();
            {
                InnerStatementListAst *__node_218 = nullptr;
                if (!parseInnerStatementList(&__node_218))
                {
                    goto __catch_11;
                }
                (*yynode)->statements = __node_218;

            }
            if (try_startState_11)
                delete try_startState_11;

            if (false) // the only way to enter here is using goto
            {
__catch_11:
                if (try_startState_11)
                {
                    restoreState(try_startState_11);
                    delete try_startState_11;
                }
                if (try_startToken_11 == tokenStream->index() - 1  && yytoken != Token_EOF)
                    yylex();

                while (yytoken != Token_EOF
                       && yytoken != Token_RBRACE)
                {
                    yylex();
                }
            }

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_IF)
        {
            if (yytoken != Token_IF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_IF, QStringLiteral("if"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ExprAst *__node_219 = nullptr;
            if (!parseExpr(&__node_219))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->ifExpr = __node_219;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_COLON)
            {
                if (yytoken != Token_COLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                    }
                    return false;
                }
                yylex();

                InnerStatementListAst *__node_220 = nullptr;
                if (!parseInnerStatementList(&__node_220))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                    }
                    return false;
                }
                (*yynode)->statements = __node_220;

                NewElseifListAst *__node_221 = nullptr;
                if (!parseNewElseifList(&__node_221))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::NewElseifListKind, QStringLiteral("newElseifList"));
                    }
                    return false;
                }
                NewElseSingleAst *__node_222 = nullptr;
                if (!parseNewElseSingle(&__node_222))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::NewElseSingleKind, QStringLiteral("newElseSingle"));
                    }
                    return false;
                }
                if (yytoken != Token_ENDIF)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_ENDIF, QStringLiteral("endif"));
                    }
                    return false;
                }
                yylex();

                SemicolonOrCloseTagAst *__node_223 = nullptr;
                if (!parseSemicolonOrCloseTag(&__node_223))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                    }
                    return false;
                }
            }
            else if (yytoken == Token_ARRAY
                     || yytoken == Token_ARRAY_CAST
                     || yytoken == Token_AT
                     || yytoken == Token_BACKSLASH
                     || yytoken == Token_BACKTICK
                     || yytoken == Token_BANG
                     || yytoken == Token_BOOL_CAST
                     || yytoken == Token_BREAK
                     || yytoken == Token_CLASS_C
                     || yytoken == Token_CLONE
                     || yytoken == Token_CLOSE_TAG
                     || yytoken == Token_CONST
                     || yytoken == Token_CONSTANT_ENCAPSED_STRING
                     || yytoken == Token_CONTINUE
                     || yytoken == Token_DEC
                     || yytoken == Token_DECLARE
                     || yytoken == Token_DIR
                     || yytoken == Token_DNUMBER
                     || yytoken == Token_DO
                     || yytoken == Token_DOLLAR
                     || yytoken == Token_DOUBLE_CAST
                     || yytoken == Token_DOUBLE_QUOTE
                     || yytoken == Token_ECHO
                     || yytoken == Token_EMPTY
                     || yytoken == Token_EVAL
                     || yytoken == Token_EXIT
                     || yytoken == Token_FILE
                     || yytoken == Token_FOR
                     || yytoken == Token_FOREACH
                     || yytoken == Token_FUNCTION
                     || yytoken == Token_FUNC_C
                     || yytoken == Token_GLOBAL
                     || yytoken == Token_GOTO
                     || yytoken == Token_IF
                     || yytoken == Token_INC
                     || yytoken == Token_INCLUDE
                     || yytoken == Token_INCLUDE_ONCE
                     || yytoken == Token_INLINE_HTML
                     || yytoken == Token_INT_CAST
                     || yytoken == Token_ISSET
                     || yytoken == Token_LBRACE
                     || yytoken == Token_LBRACKET
                     || yytoken == Token_LINE
                     || yytoken == Token_LIST
                     || yytoken == Token_LNUMBER
                     || yytoken == Token_LPAREN
                     || yytoken == Token_METHOD_C
                     || yytoken == Token_MINUS
                     || yytoken == Token_NAMESPACE_C
                     || yytoken == Token_NEW
                     || yytoken == Token_OBJECT_CAST
                     || yytoken == Token_OPEN_TAG
                     || yytoken == Token_OPEN_TAG_WITH_ECHO
                     || yytoken == Token_PLUS
                     || yytoken == Token_PRINT
                     || yytoken == Token_REQUIRE
                     || yytoken == Token_REQUIRE_ONCE
                     || yytoken == Token_RETURN
                     || yytoken == Token_SEMICOLON
                     || yytoken == Token_START_HEREDOC
                     || yytoken == Token_START_NOWDOC
                     || yytoken == Token_STATIC
                     || yytoken == Token_STRING
                     || yytoken == Token_STRING_CAST
                     || yytoken == Token_STRING_VARNAME
                     || yytoken == Token_SWITCH
                     || yytoken == Token_THROW
                     || yytoken == Token_TILDE
                     || yytoken == Token_TRAIT_C
                     || yytoken == Token_TRY
                     || yytoken == Token_UNSET
                     || yytoken == Token_UNSET_CAST
                     || yytoken == Token_USE
                     || yytoken == Token_VARIABLE
                     || yytoken == Token_WHILE
                     || yytoken == Token_YIELD
                     || yytoken == Token_YIELD_FROM)
            {
                StatementAst *__node_224 = nullptr;
                if (!parseStatement(&__node_224))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                    }
                    return false;
                }
                (*yynode)->ifStatement = __node_224;

                ElseifListAst *__node_225 = nullptr;
                if (!parseElseifList(&__node_225))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ElseifListKind, QStringLiteral("elseifList"));
                    }
                    return false;
                }
                (*yynode)->elseifList = __node_225;

                ElseSingleAst *__node_226 = nullptr;
                if (!parseElseSingle(&__node_226))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ElseSingleKind, QStringLiteral("elseSingle"));
                    }
                    return false;
                }
                (*yynode)->elseSingle = __node_226;

            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_WHILE)
        {
            if (yytoken != Token_WHILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_WHILE, QStringLiteral("while"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ExprAst *__node_227 = nullptr;
            if (!parseExpr(&__node_227))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->whileExpr = __node_227;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            WhileStatementAst *__node_228 = nullptr;
            if (!parseWhileStatement(&__node_228))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::WhileStatementKind, QStringLiteral("whileStatement"));
                }
                return false;
            }
            (*yynode)->whileStatement = __node_228;

        }
        else if (yytoken == Token_FOR)
        {
            if (yytoken != Token_FOR)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FOR, QStringLiteral("for"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ForExprAst *__node_229 = nullptr;
            if (!parseForExpr(&__node_229))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ForExprKind, QStringLiteral("forExpr"));
                }
                return false;
            }
            (*yynode)->forExpr1 = __node_229;

            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

            ForExprAst *__node_230 = nullptr;
            if (!parseForExpr(&__node_230))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ForExprKind, QStringLiteral("forExpr"));
                }
                return false;
            }
            (*yynode)->forExpr2 = __node_230;

            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

            ForExprAst *__node_231 = nullptr;
            if (!parseForExpr(&__node_231))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ForExprKind, QStringLiteral("forExpr"));
                }
                return false;
            }
            (*yynode)->forExpr3 = __node_231;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            ForStatementAst *__node_232 = nullptr;
            if (!parseForStatement(&__node_232))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ForStatementKind, QStringLiteral("forStatement"));
                }
                return false;
            }
            (*yynode)->forStatement = __node_232;

        }
        else if (yytoken == Token_SWITCH)
        {
            if (yytoken != Token_SWITCH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SWITCH, QStringLiteral("switch"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ExprAst *__node_233 = nullptr;
            if (!parseExpr(&__node_233))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->swtichExpr = __node_233;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            SwitchCaseListAst *__node_234 = nullptr;
            if (!parseSwitchCaseList(&__node_234))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SwitchCaseListKind, QStringLiteral("switchCaseList"));
                }
                return false;
            }
            (*yynode)->switchCaseList = __node_234;

        }
        else if (yytoken == Token_FOREACH)
        {
            if (yytoken != Token_FOREACH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FOREACH, QStringLiteral("foreach"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            bool blockErrors_12 = blockErrors(true);
            qint64 try_startToken_12 = tokenStream->index() - 1;
            ParserState *try_startState_12 = copyCurrentState();
            {
                VariableAst *__node_235 = nullptr;
                if (!parseVariable(&__node_235))
                {
                    goto __catch_12;
                }
                (*yynode)->foreachVar = __node_235;

                if (yytoken != Token_AS)
                    goto __catch_12;
                yylex();

                ForeachVariableAst *__node_236 = nullptr;
                if (!parseForeachVariable(&__node_236))
                {
                    goto __catch_12;
                }
                (*yynode)->foreachVarAsVar = __node_236;

            }
            blockErrors(blockErrors_12);
            if (try_startState_12)
                delete try_startState_12;

            if (false) // the only way to enter here is using goto
            {
__catch_12:
                if (try_startState_12)
                {
                    restoreState(try_startState_12);
                    delete try_startState_12;
                }
                blockErrors(blockErrors_12);
                rewind(try_startToken_12);

                ExprAst *__node_237 = nullptr;
                if (!parseExpr(&__node_237))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->foreachExpr = __node_237;

                if (yytoken != Token_AS)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_AS, QStringLiteral("as"));
                    }
                    return false;
                }
                yylex();

                VariableAst *__node_238 = nullptr;
                if (!parseVariable(&__node_238))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                    }
                    return false;
                }
                (*yynode)->foreachExprAsVar = __node_238;

            }

            if (yytoken == Token_DOUBLE_ARROW)
            {
                if (yytoken != Token_DOUBLE_ARROW)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_DOUBLE_ARROW, QStringLiteral("=>"));
                    }
                    return false;
                }
                yylex();

                ForeachVariableAst *__node_239 = nullptr;
                if (!parseForeachVariable(&__node_239))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ForeachVariableKind, QStringLiteral("foreachVariable"));
                    }
                    return false;
                }
                (*yynode)->foreachVariable = __node_239;

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            ForeachStatementAst *__node_240 = nullptr;
            if (!parseForeachStatement(&__node_240))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ForeachStatementKind, QStringLiteral("foreachStatement"));
                }
                return false;
            }
            (*yynode)->foreachStatement = __node_240;

        }
        else if (yytoken == Token_DECLARE)
        {
            if (yytoken != Token_DECLARE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DECLARE, QStringLiteral("declare"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            DeclareItemAst *__node_241 = nullptr;
            if (!parseDeclareItem(&__node_241))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::DeclareItemKind, QStringLiteral("declareItem"));
                }
                return false;
            }
            (*yynode)->declareItem = __node_241;

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                DeclareItemAst *__node_242 = nullptr;
                if (!parseDeclareItem(&__node_242))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::DeclareItemKind, QStringLiteral("declareItem"));
                    }
                    return false;
                }
                (*yynode)->declareItem = __node_242;

            }
            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            DeclareStatementAst *__node_243 = nullptr;
            if (!parseDeclareStatement(&__node_243))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::DeclareStatementKind, QStringLiteral("declareStatement"));
                }
                return false;
            }
        }
        else if (yytoken == Token_SEMICOLON)
        {
            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_TRY)
        {
            if (yytoken != Token_TRY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_TRY, QStringLiteral("try"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            qint64 try_startToken_13 = tokenStream->index() - 1;
            ParserState *try_startState_13 = copyCurrentState();
            {
                InnerStatementListAst *__node_244 = nullptr;
                if (!parseInnerStatementList(&__node_244))
                {
                    goto __catch_13;
                }
                (*yynode)->statements = __node_244;

            }
            if (try_startState_13)
                delete try_startState_13;

            if (false) // the only way to enter here is using goto
            {
__catch_13:
                if (try_startState_13)
                {
                    restoreState(try_startState_13);
                    delete try_startState_13;
                }
                if (try_startToken_13 == tokenStream->index() - 1  && yytoken != Token_EOF)
                    yylex();

                while (yytoken != Token_EOF
                       && yytoken != Token_RBRACE)
                {
                    yylex();
                }
            }

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

            while (yytoken == Token_CATCH)
            {
                CatchItemAst *__node_245 = nullptr;
                if (!parseCatchItem(&__node_245))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::CatchItemKind, QStringLiteral("catchItem"));
                    }
                    return false;
                }
                (*yynode)->catchesSequence = snoc((*yynode)->catchesSequence, __node_245, memoryPool);

            }
            if (yytoken == Token_FINALLY)
            {
                if (yytoken != Token_FINALLY)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_FINALLY, QStringLiteral("finally"));
                    }
                    return false;
                }
                yylex();

                if (yytoken != Token_LBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                    }
                    return false;
                }
                yylex();

                InnerStatementListAst *__node_246 = nullptr;
                if (!parseInnerStatementList(&__node_246))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                    }
                    return false;
                }
                (*yynode)->finallyBody = __node_246;

                if (yytoken != Token_RBRACE)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                    }
                    return false;
                }
                yylex();

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_UNSET)
        {
            if (yytoken != Token_UNSET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_UNSET, QStringLiteral("unset"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            VariableAst *__node_247 = nullptr;
            if (!parseVariable(&__node_247))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->unsetVariablesSequence = snoc((*yynode)->unsetVariablesSequence, __node_247, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                VariableAst *__node_248 = nullptr;
                if (!parseVariable(&__node_248))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                    }
                    return false;
                }
                (*yynode)->unsetVariablesSequence = snoc((*yynode)->unsetVariablesSequence, __node_248, memoryPool);

            }
            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_249 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_249))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if ((yytoken == Token_ARRAY
                  || yytoken == Token_ARRAY_CAST
                  || yytoken == Token_AT
                  || yytoken == Token_BACKSLASH
                  || yytoken == Token_BACKTICK
                  || yytoken == Token_BANG
                  || yytoken == Token_BOOL_CAST
                  || yytoken == Token_CLASS_C
                  || yytoken == Token_CLONE
                  || yytoken == Token_CONSTANT_ENCAPSED_STRING
                  || yytoken == Token_DEC
                  || yytoken == Token_DIR
                  || yytoken == Token_DNUMBER
                  || yytoken == Token_DOLLAR
                  || yytoken == Token_DOUBLE_CAST
                  || yytoken == Token_DOUBLE_QUOTE
                  || yytoken == Token_EMPTY
                  || yytoken == Token_EVAL
                  || yytoken == Token_EXIT
                  || yytoken == Token_FILE
                  || yytoken == Token_FUNCTION
                  || yytoken == Token_FUNC_C
                  || yytoken == Token_INC
                  || yytoken == Token_INCLUDE
                  || yytoken == Token_INCLUDE_ONCE
                  || yytoken == Token_INT_CAST
                  || yytoken == Token_ISSET
                  || yytoken == Token_LBRACKET
                  || yytoken == Token_LINE
                  || yytoken == Token_LIST
                  || yytoken == Token_LNUMBER
                  || yytoken == Token_LPAREN
                  || yytoken == Token_METHOD_C
                  || yytoken == Token_MINUS
                  || yytoken == Token_NAMESPACE_C
                  || yytoken == Token_NEW
                  || yytoken == Token_OBJECT_CAST
                  || yytoken == Token_PLUS
                  || yytoken == Token_PRINT
                  || yytoken == Token_REQUIRE
                  || yytoken == Token_REQUIRE_ONCE
                  || yytoken == Token_START_HEREDOC
                  || yytoken == Token_START_NOWDOC
                  || yytoken == Token_STRING
                  || yytoken == Token_STRING_CAST
                  || yytoken == Token_STRING_VARNAME
                  || yytoken == Token_TILDE
                  || yytoken == Token_TRAIT_C
                  || yytoken == Token_UNSET_CAST
                  || yytoken == Token_VARIABLE
                  || yytoken == Token_YIELD
                  || yytoken == Token_YIELD_FROM) && (
# 697 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                     LA(1).kind != Token_STRING || LA(2).kind != Token_COLON ))
        {
            ExprAst *__node_250 = nullptr;
            if (!parseExpr(&__node_250))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_250;

            SemicolonOrCloseTagAst *__node_251 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_251))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_DO)
        {
            if (yytoken != Token_DO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DO, QStringLiteral("do"));
                }
                return false;
            }
            yylex();

            StatementAst *__node_252 = nullptr;
            if (!parseStatement(&__node_252))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->doStatement = __node_252;

            if (yytoken != Token_WHILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_WHILE, QStringLiteral("while"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ExprAst *__node_253 = nullptr;
            if (!parseExpr(&__node_253))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->whileExpr = __node_253;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_254 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_254))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_BREAK)
        {
            if (yytoken != Token_BREAK)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BREAK, QStringLiteral("break"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                ExprAst *__node_255 = nullptr;
                if (!parseExpr(&__node_255))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->breakExpr = __node_255;

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            SemicolonOrCloseTagAst *__node_256 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_256))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_CONTINUE)
        {
            if (yytoken != Token_CONTINUE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONTINUE, QStringLiteral("continue"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                ExprAst *__node_257 = nullptr;
                if (!parseExpr(&__node_257))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->continueExpr = __node_257;

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            SemicolonOrCloseTagAst *__node_258 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_258))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_RETURN)
        {
            if (yytoken != Token_RETURN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RETURN, QStringLiteral("return"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                ExprAst *__node_259 = nullptr;
                if (!parseExpr(&__node_259))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->returnExpr = __node_259;

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            SemicolonOrCloseTagAst *__node_260 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_260))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_GLOBAL)
        {
            if (yytoken != Token_GLOBAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_GLOBAL, QStringLiteral("global"));
                }
                return false;
            }
            yylex();

            GlobalVarAst *__node_261 = nullptr;
            if (!parseGlobalVar(&__node_261))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::GlobalVarKind, QStringLiteral("globalVar"));
                }
                return false;
            }
            (*yynode)->globalVarsSequence = snoc((*yynode)->globalVarsSequence, __node_261, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                GlobalVarAst *__node_262 = nullptr;
                if (!parseGlobalVar(&__node_262))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::GlobalVarKind, QStringLiteral("globalVar"));
                    }
                    return false;
                }
                (*yynode)->globalVarsSequence = snoc((*yynode)->globalVarsSequence, __node_262, memoryPool);

            }
            SemicolonOrCloseTagAst *__node_263 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_263))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_STATIC)
        {
            if (yytoken != Token_STATIC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STATIC, QStringLiteral("static"));
                }
                return false;
            }
            yylex();

            StaticVarAst *__node_264 = nullptr;
            if (!parseStaticVar(&__node_264))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticVarKind, QStringLiteral("staticVar"));
                }
                return false;
            }
            (*yynode)->staticVarsSequence = snoc((*yynode)->staticVarsSequence, __node_264, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                StaticVarAst *__node_265 = nullptr;
                if (!parseStaticVar(&__node_265))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StaticVarKind, QStringLiteral("staticVar"));
                    }
                    return false;
                }
                (*yynode)->staticVarsSequence = snoc((*yynode)->staticVarsSequence, __node_265, memoryPool);

            }
            SemicolonOrCloseTagAst *__node_266 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_266))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_ECHO)
        {
            if (yytoken != Token_ECHO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ECHO, QStringLiteral("echo"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_267 = nullptr;
            if (!parseExpr(&__node_267))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->echoExprsSequence = snoc((*yynode)->echoExprsSequence, __node_267, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                ExprAst *__node_268 = nullptr;
                if (!parseExpr(&__node_268))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->echoExprsSequence = snoc((*yynode)->echoExprsSequence, __node_268, memoryPool);

            }
            SemicolonOrCloseTagAst *__node_269 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_269))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_THROW)
        {
            if (yytoken != Token_THROW)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_THROW, QStringLiteral("throw"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_270 = nullptr;
            if (!parseExpr(&__node_270))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->throwExpr = __node_270;

            SemicolonOrCloseTagAst *__node_271 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_271))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_CLOSE_TAG)
        {
            if (yytoken != Token_CLOSE_TAG)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLOSE_TAG, QStringLiteral("?>"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_OPEN_TAG)
        {
            if (yytoken != Token_OPEN_TAG)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_OPEN_TAG, QStringLiteral("<?"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_OPEN_TAG_WITH_ECHO)
        {
            if (yytoken != Token_OPEN_TAG_WITH_ECHO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_OPEN_TAG_WITH_ECHO, QStringLiteral("<?="));
                }
                return false;
            }
            yylex();

            ExprAst *__node_272 = nullptr;
            if (!parseExpr(&__node_272))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_272;

            SemicolonOrCloseTagAst *__node_273 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_273))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else if (yytoken == Token_INLINE_HTML)
        {
            if (yytoken != Token_INLINE_HTML)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INLINE_HTML, QStringLiteral("inline html"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_CONST)
        {
            if (yytoken != Token_CONST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONST, QStringLiteral("const"));
                }
                return false;
            }
            yylex();

            ConstantDeclarationAst *__node_274 = nullptr;
            if (!parseConstantDeclaration(&__node_274))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ConstantDeclarationKind, QStringLiteral("constantDeclaration"));
                }
                return false;
            }
            (*yynode)->constsSequence = snoc((*yynode)->constsSequence, __node_274, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                ConstantDeclarationAst *__node_275 = nullptr;
                if (!parseConstantDeclaration(&__node_275))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ConstantDeclarationKind, QStringLiteral("constantDeclaration"));
                    }
                    return false;
                }
                (*yynode)->constsSequence = snoc((*yynode)->constsSequence, __node_275, memoryPool);

            }
            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_USE)
        {
            if (yytoken != Token_USE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_USE, QStringLiteral("use"));
                }
                return false;
            }
            yylex();

            UseStatementAst *__node_276 = nullptr;
            if (!parseUseStatement(&__node_276))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UseStatementKind, QStringLiteral("useStatement"));
                }
                return false;
            }
            (*yynode)->useStatement = __node_276;

        }
        else if (yytoken == Token_GOTO)
        {
            if (yytoken != Token_GOTO)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_GOTO, QStringLiteral("goto"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_STRING)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STRING, QStringLiteral("string"));
                }
                return false;
            }
            (*yynode)->gotoLabel = tokenStream->index() - 1;
            yylex();

            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_STRING)
        {
            if (yytoken != Token_STRING)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STRING, QStringLiteral("string"));
                }
                return false;
            }
            (*yynode)->gotoTarget = tokenStream->index() - 1;
            yylex();

            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStaticArrayPairValue(StaticArrayPairValueAst **yynode)
{
    *yynode = create<StaticArrayPairValueAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CLASS_C
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_FILE
        || yytoken == Token_FUNC_C
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_PLUS
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_TRAIT_C)
    {
        StaticScalarAst *__node_277 = nullptr;
        if (!parseStaticScalar(&__node_277))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
            }
            return false;
        }
        (*yynode)->val1Sequence = snoc((*yynode)->val1Sequence, __node_277, memoryPool);

        if (yytoken == Token_DOUBLE_ARROW)
        {
            if (yytoken != Token_DOUBLE_ARROW)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOUBLE_ARROW, QStringLiteral("=>"));
                }
                return false;
            }
            yylex();

            StaticScalarAst *__node_278 = nullptr;
            if (!parseStaticScalar(&__node_278))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
                }
                return false;
            }
            (*yynode)->val2Sequence = snoc((*yynode)->val2Sequence, __node_278, memoryPool);

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStaticMember(StaticMemberAst **yynode)
{
    *yynode = create<StaticMemberAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        NamespacedIdentifierAst *__node_279 = nullptr;
        if (!parseNamespacedIdentifier(&__node_279))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->className = __node_279;

        StaticPropertyAst *__node_280 = nullptr;
        if (!parseStaticProperty(&__node_280))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::StaticPropertyKind, QStringLiteral("staticProperty"));
            }
            return false;
        }
        (*yynode)->staticProperty = __node_280;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStaticProperty(StaticPropertyAst **yynode)
{
    *yynode = create<StaticPropertyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
    {
        if (yytoken != Token_PAAMAYIM_NEKUDOTAYIM)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_PAAMAYIM_NEKUDOTAYIM, QStringLiteral("::"));
            }
            return false;
        }
        yylex();

        CompoundVariableWithSimpleIndirectReferenceAst *__node_281 = nullptr;
        if (!parseCompoundVariableWithSimpleIndirectReference(&__node_281))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::CompoundVariableWithSimpleIndirectReferenceKind, QStringLiteral("compoundVariableWithSimpleIndirectReference"));
            }
            return false;
        }
        (*yynode)->staticProperty = __node_281;

        while (yytoken == Token_LBRACE
               || yytoken == Token_LBRACKET)
        {
            DimListItemAst *__node_282 = nullptr;
            if (!parseDimListItem(&__node_282))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::DimListItemKind, QStringLiteral("dimListItem"));
                }
                return false;
            }
            (*yynode)->offsetItemsSequence = snoc((*yynode)->offsetItemsSequence, __node_282, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStaticScalar(StaticScalarAst **yynode)
{
    *yynode = create<StaticScalarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->array = -1;
    (*yynode)->array = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_CLASS_C
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_FILE
        || yytoken == Token_FUNC_C
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_PLUS
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_TRAIT_C)
    {
        if (yytoken == Token_CLASS_C
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_FILE
            || yytoken == Token_FUNC_C
            || yytoken == Token_LINE
            || yytoken == Token_LNUMBER
            || yytoken == Token_METHOD_C
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_TRAIT_C)
        {
            CommonScalarAst *__node_283 = nullptr;
            if (!parseCommonScalar(&__node_283))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::CommonScalarKind, QStringLiteral("commonScalar"));
                }
                return false;
            }
            (*yynode)->value = __node_283;

        }
        else if (yytoken == Token_BACKSLASH
                 || yytoken == Token_STRING)
        {
            ConstantOrClassConstAst *__node_284 = nullptr;
            if (!parseConstantOrClassConst(&__node_284))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ConstantOrClassConstKind, QStringLiteral("constantOrClassConst"));
                }
                return false;
            }
            (*yynode)->constantOrClassConst = __node_284;

        }
        else if (yytoken == Token_PLUS)
        {
            if (yytoken != Token_PLUS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PLUS, QStringLiteral("+"));
                }
                return false;
            }
            yylex();

            StaticScalarAst *__node_285 = nullptr;
            if (!parseStaticScalar(&__node_285))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
                }
                return false;
            }
            (*yynode)->plusValue = __node_285;

        }
        else if (yytoken == Token_MINUS)
        {
            if (yytoken != Token_MINUS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_MINUS, QStringLiteral("-"));
                }
                return false;
            }
            yylex();

            StaticScalarAst *__node_286 = nullptr;
            if (!parseStaticScalar(&__node_286))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
                }
                return false;
            }
            (*yynode)->minusValue = __node_286;

        }
        else if (yytoken == Token_ARRAY)
        {
            if (yytoken != Token_ARRAY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ARRAY, QStringLiteral("array"));
                }
                return false;
            }
            (*yynode)->array = tokenStream->index() - 1;
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_BACKSLASH
                || yytoken == Token_CLASS_C
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_FILE
                || yytoken == Token_FUNC_C
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LNUMBER
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_PLUS
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_TRAIT_C)
            {
                StaticArrayPairValueAst *__node_287 = nullptr;
                if (!parseStaticArrayPairValue(&__node_287))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StaticArrayPairValueKind, QStringLiteral("staticArrayPairValue"));
                    }
                    return false;
                }
                (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_287, memoryPool);

                while (yytoken == Token_COMMA)
                {
                    if (yytoken != Token_COMMA)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                        }
                        return false;
                    }
                    yylex();


# 913 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                    if (yytoken == Token_RPAREN)
                    {
                        break;
                    }
                    StaticArrayPairValueAst *__node_288 = nullptr;
                    if (!parseStaticArrayPairValue(&__node_288))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::StaticArrayPairValueKind, QStringLiteral("staticArrayPairValue"));
                        }
                        return false;
                    }
                    (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_288, memoryPool);

                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LBRACKET)
        {
            if (yytoken != Token_LBRACKET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACKET, QStringLiteral("["));
                }
                return false;
            }
            (*yynode)->array = tokenStream->index() - 1;
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_BACKSLASH
                || yytoken == Token_CLASS_C
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_FILE
                || yytoken == Token_FUNC_C
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LNUMBER
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_PLUS
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_TRAIT_C)
            {
                StaticArrayPairValueAst *__node_289 = nullptr;
                if (!parseStaticArrayPairValue(&__node_289))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::StaticArrayPairValueKind, QStringLiteral("staticArrayPairValue"));
                    }
                    return false;
                }
                (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_289, memoryPool);

                while (yytoken == Token_COMMA)
                {
                    if (yytoken != Token_COMMA)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                        }
                        return false;
                    }
                    yylex();


# 918 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                    if (yytoken == Token_RBRACKET)
                    {
                        break;
                    }
                    StaticArrayPairValueAst *__node_290 = nullptr;
                    if (!parseStaticArrayPairValue(&__node_290))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::StaticArrayPairValueKind, QStringLiteral("staticArrayPairValue"));
                        }
                        return false;
                    }
                    (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_290, memoryPool);

                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken != Token_RBRACKET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACKET, QStringLiteral("]"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStaticVar(StaticVarAst **yynode)
{
    *yynode = create<StaticVarAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_VARIABLE)
    {
        VariableIdentifierAst *__node_291 = nullptr;
        if (!parseVariableIdentifier(&__node_291))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariableIdentifierKind, QStringLiteral("variableIdentifier"));
            }
            return false;
        }
        (*yynode)->var = __node_291;

        if (yytoken == Token_ASSIGN)
        {
            if (yytoken != Token_ASSIGN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
                }
                return false;
            }
            yylex();

            StaticScalarAst *__node_292 = nullptr;
            if (!parseStaticScalar(&__node_292))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StaticScalarKind, QStringLiteral("staticScalar"));
                }
                return false;
            }
            (*yynode)->value = __node_292;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseStringIndexSpecifier(StringIndexSpecifierAst **yynode)
{
    *yynode = create<StringIndexSpecifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACKET)
    {
        if (yytoken != Token_LBRACKET)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACKET, QStringLiteral("["));
            }
            return false;
        }
        yylex();

        ExprAst *__node_293 = nullptr;
        if (!parseExpr(&__node_293))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
            }
            return false;
        }
        (*yynode)->expr = __node_293;

        if (yytoken != Token_RBRACKET)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACKET, QStringLiteral("]"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseSwitchCaseList(SwitchCaseListAst **yynode)
{
    *yynode = create<SwitchCaseListAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_COLON
        || yytoken == Token_LBRACE)
    {
        if (yytoken == Token_LBRACE)
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_SEMICOLON)
            {
                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            qint64 try_startToken_14 = tokenStream->index() - 1;
            ParserState *try_startState_14 = copyCurrentState();
            {
                CaseListAst *__node_294 = nullptr;
                if (!parseCaseList(&__node_294))
                {
                    goto __catch_14;
                }
                (*yynode)->caseList = __node_294;

            }
            if (try_startState_14)
                delete try_startState_14;

            if (false) // the only way to enter here is using goto
            {
__catch_14:
                if (try_startState_14)
                {
                    restoreState(try_startState_14);
                    delete try_startState_14;
                }
                if (try_startToken_14 == tokenStream->index() - 1  && yytoken != Token_EOF)
                    yylex();

                while (yytoken != Token_EOF
                       && yytoken != Token_RBRACE)
                {
                    yylex();
                }
            }

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_SEMICOLON)
            {
                if (yytoken != Token_SEMICOLON)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                    }
                    return false;
                }
                yylex();

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            CaseListAst *__node_295 = nullptr;
            if (!parseCaseList(&__node_295))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::CaseListKind, QStringLiteral("caseList"));
                }
                return false;
            }
            (*yynode)->caseList = __node_295;

            if (yytoken != Token_ENDSWITCH)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDSWITCH, QStringLiteral("endswitch"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_296 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_296))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseTopStatement(TopStatementAst **yynode)
{
    *yynode = create<TopStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FINAL
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_HALT_COMPILER
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INTERFACE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if ((yytoken == Token_ARRAY
             || yytoken == Token_ARRAY_CAST
             || yytoken == Token_AT
             || yytoken == Token_BACKSLASH
             || yytoken == Token_BACKTICK
             || yytoken == Token_BANG
             || yytoken == Token_BOOL_CAST
             || yytoken == Token_BREAK
             || yytoken == Token_CLASS_C
             || yytoken == Token_CLONE
             || yytoken == Token_CLOSE_TAG
             || yytoken == Token_CONST
             || yytoken == Token_CONSTANT_ENCAPSED_STRING
             || yytoken == Token_CONTINUE
             || yytoken == Token_DEC
             || yytoken == Token_DECLARE
             || yytoken == Token_DIR
             || yytoken == Token_DNUMBER
             || yytoken == Token_DO
             || yytoken == Token_DOLLAR
             || yytoken == Token_DOUBLE_CAST
             || yytoken == Token_DOUBLE_QUOTE
             || yytoken == Token_ECHO
             || yytoken == Token_EMPTY
             || yytoken == Token_EVAL
             || yytoken == Token_EXIT
             || yytoken == Token_FILE
             || yytoken == Token_FOR
             || yytoken == Token_FOREACH
             || yytoken == Token_FUNCTION
             || yytoken == Token_FUNC_C
             || yytoken == Token_GLOBAL
             || yytoken == Token_GOTO
             || yytoken == Token_IF
             || yytoken == Token_INC
             || yytoken == Token_INCLUDE
             || yytoken == Token_INCLUDE_ONCE
             || yytoken == Token_INLINE_HTML
             || yytoken == Token_INT_CAST
             || yytoken == Token_ISSET
             || yytoken == Token_LBRACE
             || yytoken == Token_LBRACKET
             || yytoken == Token_LINE
             || yytoken == Token_LIST
             || yytoken == Token_LNUMBER
             || yytoken == Token_LPAREN
             || yytoken == Token_METHOD_C
             || yytoken == Token_MINUS
             || yytoken == Token_NAMESPACE_C
             || yytoken == Token_NEW
             || yytoken == Token_OBJECT_CAST
             || yytoken == Token_OPEN_TAG
             || yytoken == Token_OPEN_TAG_WITH_ECHO
             || yytoken == Token_PLUS
             || yytoken == Token_PRINT
             || yytoken == Token_REQUIRE
             || yytoken == Token_REQUIRE_ONCE
             || yytoken == Token_RETURN
             || yytoken == Token_SEMICOLON
             || yytoken == Token_START_HEREDOC
             || yytoken == Token_START_NOWDOC
             || yytoken == Token_STATIC
             || yytoken == Token_STRING
             || yytoken == Token_STRING_CAST
             || yytoken == Token_STRING_VARNAME
             || yytoken == Token_SWITCH
             || yytoken == Token_THROW
             || yytoken == Token_TILDE
             || yytoken == Token_TRAIT_C
             || yytoken == Token_TRY
             || yytoken == Token_UNSET
             || yytoken == Token_UNSET_CAST
             || yytoken == Token_USE
             || yytoken == Token_VARIABLE
             || yytoken == Token_WHILE
             || yytoken == Token_YIELD
             || yytoken == Token_YIELD_FROM) && (
# 288 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                (LA(1).kind == Token_FUNCTION && ((LA(2).kind == Token_BIT_AND && LA(3).kind == Token_LPAREN)
                        || LA(2).kind == Token_LPAREN))
                || LA(1).kind != Token_FUNCTION ))
        {
            StatementAst *__node_297 = nullptr;
            if (!parseStatement(&__node_297))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->statement = __node_297;

        }
        else if (yytoken == Token_FUNCTION)
        {
            FunctionDeclarationStatementAst *__node_298 = nullptr;
            if (!parseFunctionDeclarationStatement(&__node_298))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::FunctionDeclarationStatementKind, QStringLiteral("functionDeclarationStatement"));
                }
                return false;
            }
            (*yynode)->functionDeclaration = __node_298;

        }
        else if (yytoken == Token_ABSTRACT
                 || yytoken == Token_CLASS
                 || yytoken == Token_FINAL)
        {
            ClassDeclarationStatementAst *__node_299 = nullptr;
            if (!parseClassDeclarationStatement(&__node_299))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClassDeclarationStatementKind, QStringLiteral("classDeclarationStatement"));
                }
                return false;
            }
            (*yynode)->classDeclaration = __node_299;

        }
        else if (yytoken == Token_TRAIT)
        {
            TraitDeclarationStatementAst *__node_300 = nullptr;
            if (!parseTraitDeclarationStatement(&__node_300))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::TraitDeclarationStatementKind, QStringLiteral("traitDeclarationStatement"));
                }
                return false;
            }
            (*yynode)->traitDeclaration = __node_300;

        }
        else if (yytoken == Token_INTERFACE)
        {
            InterfaceDeclarationStatementAst *__node_301 = nullptr;
            if (!parseInterfaceDeclarationStatement(&__node_301))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InterfaceDeclarationStatementKind, QStringLiteral("interfaceDeclarationStatement"));
                }
                return false;
            }
            (*yynode)->interfaceDeclaration = __node_301;

        }
        else if (yytoken == Token_HALT_COMPILER)
        {
            if (yytoken != Token_HALT_COMPILER)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_HALT_COMPILER, QStringLiteral("halt compiler"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseTraitAliasDeclaration(TraitAliasDeclarationAst **yynode)
{
    *yynode = create<TraitAliasDeclarationAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACE)
    {
        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        TraitAliasStatementAst *__node_302 = nullptr;
        if (!parseTraitAliasStatement(&__node_302))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::TraitAliasStatementKind, QStringLiteral("traitAliasStatement"));
            }
            return false;
        }
        (*yynode)->statementsSequence = snoc((*yynode)->statementsSequence, __node_302, memoryPool);

        while (yytoken == Token_SEMICOLON)
        {
            if (yytoken != Token_SEMICOLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
                }
                return false;
            }
            yylex();


# 1041 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            if (yytoken == Token_RBRACE)
            {
                break;
            }
            TraitAliasStatementAst *__node_303 = nullptr;
            if (!parseTraitAliasStatement(&__node_303))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::TraitAliasStatementKind, QStringLiteral("traitAliasStatement"));
                }
                return false;
            }
            (*yynode)->statementsSequence = snoc((*yynode)->statementsSequence, __node_303, memoryPool);

        }
        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseTraitAliasIdentifier(TraitAliasIdentifierAst **yynode)
{
    *yynode = create<TraitAliasIdentifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        NamespacedIdentifierAst *__node_304 = nullptr;
        if (!parseNamespacedIdentifier(&__node_304))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->identifier = __node_304;

        if (yytoken != Token_PAAMAYIM_NEKUDOTAYIM)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_PAAMAYIM_NEKUDOTAYIM, QStringLiteral("::"));
            }
            return false;
        }
        yylex();

        SemiReservedIdentifierAst *__node_305 = nullptr;
        if (!parseSemiReservedIdentifier(&__node_305))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::SemiReservedIdentifierKind, QStringLiteral("semiReservedIdentifier"));
            }
            return false;
        }
        (*yynode)->methodIdentifier = __node_305;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseTraitAliasStatement(TraitAliasStatementAst **yynode)
{
    *yynode = create<TraitAliasStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        TraitAliasIdentifierAst *__node_306 = nullptr;
        if (!parseTraitAliasIdentifier(&__node_306))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::TraitAliasIdentifierKind, QStringLiteral("traitAliasIdentifier"));
            }
            return false;
        }
        (*yynode)->importIdentifier = __node_306;

        if (yytoken == Token_AS)
        {
            if (yytoken != Token_AS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_AS, QStringLiteral("as"));
                }
                return false;
            }
            yylex();

            if ((yytoken == Token_ABSTRACT
                 || yytoken == Token_ARRAY
                 || yytoken == Token_AS
                 || yytoken == Token_BREAK
                 || yytoken == Token_CALLABLE
                 || yytoken == Token_CASE
                 || yytoken == Token_CATCH
                 || yytoken == Token_CLASS
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CONST
                 || yytoken == Token_CONTINUE
                 || yytoken == Token_DECLARE
                 || yytoken == Token_DEFAULT
                 || yytoken == Token_DIR
                 || yytoken == Token_DO
                 || yytoken == Token_ECHO
                 || yytoken == Token_ELSE
                 || yytoken == Token_ELSEIF
                 || yytoken == Token_EMPTY
                 || yytoken == Token_ENDDECLARE
                 || yytoken == Token_ENDFOR
                 || yytoken == Token_ENDFOREACH
                 || yytoken == Token_ENDIF
                 || yytoken == Token_ENDSWITCH
                 || yytoken == Token_ENDWHILE
                 || yytoken == Token_EVAL
                 || yytoken == Token_EXIT
                 || yytoken == Token_EXTENDS
                 || yytoken == Token_FILE
                 || yytoken == Token_FINAL
                 || yytoken == Token_FINALLY
                 || yytoken == Token_FOR
                 || yytoken == Token_FOREACH
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_GLOBAL
                 || yytoken == Token_GOTO
                 || yytoken == Token_IF
                 || yytoken == Token_IMPLEMENTS
                 || yytoken == Token_INCLUDE
                 || yytoken == Token_INCLUDE_ONCE
                 || yytoken == Token_INSTANCEOF
                 || yytoken == Token_INSTEADOF
                 || yytoken == Token_INTERFACE
                 || yytoken == Token_ISSET
                 || yytoken == Token_LINE
                 || yytoken == Token_LIST
                 || yytoken == Token_LOGICAL_AND
                 || yytoken == Token_LOGICAL_OR
                 || yytoken == Token_LOGICAL_XOR
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_NAMESPACE
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_PRINT
                 || yytoken == Token_PRIVATE
                 || yytoken == Token_PROTECTED
                 || yytoken == Token_PUBLIC
                 || yytoken == Token_REQUIRE
                 || yytoken == Token_REQUIRE_ONCE
                 || yytoken == Token_RETURN
                 || yytoken == Token_STATIC
                 || yytoken == Token_STRING
                 || yytoken == Token_SWITCH
                 || yytoken == Token_THROW
                 || yytoken == Token_TRAIT
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_TRY
                 || yytoken == Token_UNSET
                 || yytoken == Token_USE
                 || yytoken == Token_VAR
                 || yytoken == Token_WHILE
                 || yytoken == Token_YIELD) && (
# 1047 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                    LA(2).kind == Token_SEMICOLON ))
            {
                if (yytoken == Token_ABSTRACT
                    || yytoken == Token_FINAL
                    || yytoken == Token_PRIVATE
                    || yytoken == Token_PROTECTED
                    || yytoken == Token_PUBLIC
                    || yytoken == Token_STATIC)
                {
                    TraitVisibilityModifiersAst *__node_307 = nullptr;
                    if (!parseTraitVisibilityModifiers(&__node_307))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::TraitVisibilityModifiersKind, QStringLiteral("traitVisibilityModifiers"));
                        }
                        return false;
                    }
                    (*yynode)->modifiers = __node_307;

                }
                else if (yytoken == Token_ARRAY
                         || yytoken == Token_AS
                         || yytoken == Token_BREAK
                         || yytoken == Token_CALLABLE
                         || yytoken == Token_CASE
                         || yytoken == Token_CATCH
                         || yytoken == Token_CLASS
                         || yytoken == Token_CLASS_C
                         || yytoken == Token_CLONE
                         || yytoken == Token_CONST
                         || yytoken == Token_CONTINUE
                         || yytoken == Token_DECLARE
                         || yytoken == Token_DEFAULT
                         || yytoken == Token_DIR
                         || yytoken == Token_DO
                         || yytoken == Token_ECHO
                         || yytoken == Token_ELSE
                         || yytoken == Token_ELSEIF
                         || yytoken == Token_EMPTY
                         || yytoken == Token_ENDDECLARE
                         || yytoken == Token_ENDFOR
                         || yytoken == Token_ENDFOREACH
                         || yytoken == Token_ENDIF
                         || yytoken == Token_ENDSWITCH
                         || yytoken == Token_ENDWHILE
                         || yytoken == Token_EVAL
                         || yytoken == Token_EXIT
                         || yytoken == Token_EXTENDS
                         || yytoken == Token_FILE
                         || yytoken == Token_FINALLY
                         || yytoken == Token_FOR
                         || yytoken == Token_FOREACH
                         || yytoken == Token_FUNCTION
                         || yytoken == Token_FUNC_C
                         || yytoken == Token_GLOBAL
                         || yytoken == Token_GOTO
                         || yytoken == Token_IF
                         || yytoken == Token_IMPLEMENTS
                         || yytoken == Token_INCLUDE
                         || yytoken == Token_INCLUDE_ONCE
                         || yytoken == Token_INSTANCEOF
                         || yytoken == Token_INSTEADOF
                         || yytoken == Token_INTERFACE
                         || yytoken == Token_ISSET
                         || yytoken == Token_LINE
                         || yytoken == Token_LIST
                         || yytoken == Token_LOGICAL_AND
                         || yytoken == Token_LOGICAL_OR
                         || yytoken == Token_LOGICAL_XOR
                         || yytoken == Token_METHOD_C
                         || yytoken == Token_NAMESPACE
                         || yytoken == Token_NAMESPACE_C
                         || yytoken == Token_NEW
                         || yytoken == Token_PRINT
                         || yytoken == Token_REQUIRE
                         || yytoken == Token_REQUIRE_ONCE
                         || yytoken == Token_RETURN
                         || yytoken == Token_STRING
                         || yytoken == Token_SWITCH
                         || yytoken == Token_THROW
                         || yytoken == Token_TRAIT
                         || yytoken == Token_TRAIT_C
                         || yytoken == Token_TRY
                         || yytoken == Token_UNSET
                         || yytoken == Token_USE
                         || yytoken == Token_VAR
                         || yytoken == Token_WHILE
                         || yytoken == Token_YIELD)
                {
                    ReservedNonModifierIdentifierAst *__node_308 = nullptr;
                    if (!parseReservedNonModifierIdentifier(&__node_308))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ReservedNonModifierIdentifierKind, QStringLiteral("reservedNonModifierIdentifier"));
                        }
                        return false;
                    }
                    (*yynode)->aliasNonModifierIdentifier = __node_308;

                }
                else
                {
                    return false;
                }
            }
            else if (yytoken == Token_ABSTRACT
                     || yytoken == Token_FINAL
                     || yytoken == Token_PRIVATE
                     || yytoken == Token_PROTECTED
                     || yytoken == Token_PUBLIC
                     || yytoken == Token_STATIC)
            {
                TraitVisibilityModifiersAst *__node_309 = nullptr;
                if (!parseTraitVisibilityModifiers(&__node_309))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::TraitVisibilityModifiersKind, QStringLiteral("traitVisibilityModifiers"));
                    }
                    return false;
                }
                (*yynode)->modifiers = __node_309;

                SemiReservedIdentifierAst *__node_310 = nullptr;
                if (!parseSemiReservedIdentifier(&__node_310))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::SemiReservedIdentifierKind, QStringLiteral("semiReservedIdentifier"));
                    }
                    return false;
                }
                (*yynode)->aliasIdentifier = __node_310;

            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_INSTEADOF)
        {
            if (yytoken != Token_INSTEADOF)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INSTEADOF, QStringLiteral("insteadof"));
                }
                return false;
            }
            yylex();

            NamespacedIdentifierAst *__node_311 = nullptr;
            if (!parseNamespacedIdentifier(&__node_311))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                }
                return false;
            }
            (*yynode)->conflictIdentifierSequence = snoc((*yynode)->conflictIdentifierSequence, __node_311, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                NamespacedIdentifierAst *__node_312 = nullptr;
                if (!parseNamespacedIdentifier(&__node_312))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
                    }
                    return false;
                }
                (*yynode)->conflictIdentifierSequence = snoc((*yynode)->conflictIdentifierSequence, __node_312, memoryPool);

            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseTraitDeclarationStatement(TraitDeclarationStatementAst **yynode)
{
    *yynode = create<TraitDeclarationStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_TRAIT)
    {
        if (yytoken != Token_TRAIT)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_TRAIT, QStringLiteral("trait"));
            }
            return false;
        }
        yylex();

        IdentifierAst *__node_313 = nullptr;
        if (!parseIdentifier(&__node_313))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
            }
            return false;
        }
        (*yynode)->traitName = __node_313;

        if (yytoken != Token_LBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
            }
            return false;
        }
        yylex();

        ClassBodyAst *__node_314 = nullptr;
        if (!parseClassBody(&__node_314))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ClassBodyKind, QStringLiteral("classBody"));
            }
            return false;
        }
        (*yynode)->body = __node_314;

        if (yytoken != Token_RBRACE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseTraitVisibilityModifiers(TraitVisibilityModifiersAst **yynode)
{
    *yynode = create<TraitVisibilityModifiersAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ABSTRACT
        || yytoken == Token_FINAL
        || yytoken == Token_PRIVATE
        || yytoken == Token_PROTECTED
        || yytoken == Token_PUBLIC
        || yytoken == Token_STATIC)
    {
        if (yytoken == Token_PUBLIC)
        {
            if (yytoken != Token_PUBLIC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PUBLIC, QStringLiteral("public"));
                }
                return false;
            }
            yylex();


# 1068 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifiers |= ModifierPublic;
        }
        else if (yytoken == Token_PROTECTED)
        {
            if (yytoken != Token_PROTECTED)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PROTECTED, QStringLiteral("protected"));
                }
                return false;
            }
            yylex();


# 1069 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifiers |= ModifierProtected;
        }
        else if (yytoken == Token_PRIVATE)
        {
            if (yytoken != Token_PRIVATE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PRIVATE, QStringLiteral("private"));
                }
                return false;
            }
            yylex();


# 1070 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifiers |= ModifierPrivate;
        }
        else if (yytoken == Token_STATIC)
        {
            if (yytoken != Token_STATIC)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STATIC, QStringLiteral("static"));
                }
                return false;
            }
            yylex();


# 1071 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifiers |= ModifierStatic;
        }
        else if (yytoken == Token_ABSTRACT)
        {
            if (yytoken != Token_ABSTRACT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ABSTRACT, QStringLiteral("abstract"));
                }
                return false;
            }
            yylex();


# 1072 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifiers |= ModifierAbstract;
        }
        else if (yytoken == Token_FINAL)
        {
            if (yytoken != Token_FINAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FINAL, QStringLiteral("final"));
                }
                return false;
            }
            yylex();


# 1073 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->modifiers |= ModifierFinal;
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseUnaryExpression(UnaryExpressionAst **yynode)
{
    *yynode = create<UnaryExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_MINUS)
        {
            if (yytoken != Token_MINUS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_MINUS, QStringLiteral("-"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_315 = nullptr;
            if (!parseUnaryExpression(&__node_315))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_315;

        }
        else if (yytoken == Token_PLUS)
        {
            if (yytoken != Token_PLUS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_PLUS, QStringLiteral("+"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_316 = nullptr;
            if (!parseUnaryExpression(&__node_316))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_316;

        }
        else if (yytoken == Token_BANG)
        {
            if (yytoken != Token_BANG)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BANG, QStringLiteral("!"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_317 = nullptr;
            if (!parseUnaryExpression(&__node_317))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_317;

        }
        else if (yytoken == Token_TILDE)
        {
            if (yytoken != Token_TILDE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_TILDE, QStringLiteral("~"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_318 = nullptr;
            if (!parseUnaryExpression(&__node_318))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_318;

        }
        else if (yytoken == Token_INT_CAST)
        {
            if (yytoken != Token_INT_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INT_CAST, QStringLiteral("int cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_319 = nullptr;
            if (!parseUnaryExpression(&__node_319))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_319;


# 508 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastInt;
        }
        else if (yytoken == Token_DOUBLE_CAST)
        {
            if (yytoken != Token_DOUBLE_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_DOUBLE_CAST, QStringLiteral("double cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_320 = nullptr;
            if (!parseUnaryExpression(&__node_320))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_320;


# 509 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastDouble;
        }
        else if (yytoken == Token_STRING_CAST)
        {
            if (yytoken != Token_STRING_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_STRING_CAST, QStringLiteral("string cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_321 = nullptr;
            if (!parseUnaryExpression(&__node_321))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_321;


# 510 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastString;
        }
        else if (yytoken == Token_ARRAY_CAST)
        {
            if (yytoken != Token_ARRAY_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ARRAY_CAST, QStringLiteral("array cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_322 = nullptr;
            if (!parseUnaryExpression(&__node_322))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_322;


# 511 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastArray;
        }
        else if (yytoken == Token_OBJECT_CAST)
        {
            if (yytoken != Token_OBJECT_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_OBJECT_CAST, QStringLiteral("object cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_323 = nullptr;
            if (!parseUnaryExpression(&__node_323))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_323;


# 512 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastObject;
        }
        else if (yytoken == Token_BOOL_CAST)
        {
            if (yytoken != Token_BOOL_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BOOL_CAST, QStringLiteral("bool cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_324 = nullptr;
            if (!parseUnaryExpression(&__node_324))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_324;


# 513 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastBool;
        }
        else if (yytoken == Token_UNSET_CAST)
        {
            if (yytoken != Token_UNSET_CAST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_UNSET_CAST, QStringLiteral("unset cast"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_325 = nullptr;
            if (!parseUnaryExpression(&__node_325))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_325;


# 514 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            (*yynode)->castType = CastUnset;
        }
        else if (yytoken == Token_AT)
        {
            if (yytoken != Token_AT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_AT, QStringLiteral("@"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_326 = nullptr;
            if (!parseUnaryExpression(&__node_326))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_326;

        }
        else if (yytoken == Token_LIST)
        {
            if (yytoken != Token_LIST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LIST, QStringLiteral("list"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            AssignmentListAst *__node_327 = nullptr;
            if (!parseAssignmentList(&__node_327))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentListKind, QStringLiteral("assignmentList"));
                }
                return false;
            }
            (*yynode)->assignmentList = __node_327;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_ASSIGN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ASSIGN, QStringLiteral("="));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_328 = nullptr;
            if (!parseUnaryExpression(&__node_328))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->unaryExpression = __node_328;

        }
        else if (yytoken == Token_EXIT)
        {
            if (yytoken != Token_EXIT)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EXIT, QStringLiteral("exit"));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_LPAREN)
            {
                if (yytoken != Token_LPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                    }
                    return false;
                }
                yylex();

                if (yytoken == Token_ARRAY
                    || yytoken == Token_ARRAY_CAST
                    || yytoken == Token_AT
                    || yytoken == Token_BACKSLASH
                    || yytoken == Token_BACKTICK
                    || yytoken == Token_BANG
                    || yytoken == Token_BOOL_CAST
                    || yytoken == Token_CLASS_C
                    || yytoken == Token_CLONE
                    || yytoken == Token_CONSTANT_ENCAPSED_STRING
                    || yytoken == Token_DEC
                    || yytoken == Token_DIR
                    || yytoken == Token_DNUMBER
                    || yytoken == Token_DOLLAR
                    || yytoken == Token_DOUBLE_CAST
                    || yytoken == Token_DOUBLE_QUOTE
                    || yytoken == Token_EMPTY
                    || yytoken == Token_EVAL
                    || yytoken == Token_EXIT
                    || yytoken == Token_FILE
                    || yytoken == Token_FUNCTION
                    || yytoken == Token_FUNC_C
                    || yytoken == Token_INC
                    || yytoken == Token_INCLUDE
                    || yytoken == Token_INCLUDE_ONCE
                    || yytoken == Token_INT_CAST
                    || yytoken == Token_ISSET
                    || yytoken == Token_LBRACKET
                    || yytoken == Token_LINE
                    || yytoken == Token_LIST
                    || yytoken == Token_LNUMBER
                    || yytoken == Token_LPAREN
                    || yytoken == Token_METHOD_C
                    || yytoken == Token_MINUS
                    || yytoken == Token_NAMESPACE_C
                    || yytoken == Token_NEW
                    || yytoken == Token_OBJECT_CAST
                    || yytoken == Token_PLUS
                    || yytoken == Token_PRINT
                    || yytoken == Token_REQUIRE
                    || yytoken == Token_REQUIRE_ONCE
                    || yytoken == Token_START_HEREDOC
                    || yytoken == Token_START_NOWDOC
                    || yytoken == Token_STRING
                    || yytoken == Token_STRING_CAST
                    || yytoken == Token_STRING_VARNAME
                    || yytoken == Token_TILDE
                    || yytoken == Token_TRAIT_C
                    || yytoken == Token_UNSET_CAST
                    || yytoken == Token_VARIABLE
                    || yytoken == Token_YIELD
                    || yytoken == Token_YIELD_FROM)
                {
                    ExprAst *__node_329 = nullptr;
                    if (!parseExpr(&__node_329))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                        }
                        return false;
                    }
                    (*yynode)->expression = __node_329;

                }
                else if (true /*epsilon*/)
                {
                }
                else
                {
                    return false;
                }
                if (yytoken != Token_RPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                    }
                    return false;
                }
                yylex();

            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_EVAL)
        {
            if (yytoken != Token_EVAL)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EVAL, QStringLiteral("eval"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ExprAst *__node_330 = nullptr;
            if (!parseExpr(&__node_330))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expression = __node_330;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_INCLUDE)
        {
            if (yytoken != Token_INCLUDE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INCLUDE, QStringLiteral("include"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_331 = nullptr;
            if (!parseUnaryExpression(&__node_331))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->includeExpression = __node_331;

        }
        else if (yytoken == Token_INCLUDE_ONCE)
        {
            if (yytoken != Token_INCLUDE_ONCE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_INCLUDE_ONCE, QStringLiteral("include_once"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_332 = nullptr;
            if (!parseUnaryExpression(&__node_332))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->includeExpression = __node_332;

        }
        else if (yytoken == Token_REQUIRE)
        {
            if (yytoken != Token_REQUIRE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_REQUIRE, QStringLiteral("require"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_333 = nullptr;
            if (!parseUnaryExpression(&__node_333))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->includeExpression = __node_333;

        }
        else if (yytoken == Token_REQUIRE_ONCE)
        {
            if (yytoken != Token_REQUIRE_ONCE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_REQUIRE_ONCE, QStringLiteral("require_once"));
                }
                return false;
            }
            yylex();

            UnaryExpressionAst *__node_334 = nullptr;
            if (!parseUnaryExpression(&__node_334))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionKind, QStringLiteral("unaryExpression"));
                }
                return false;
            }
            (*yynode)->includeExpression = __node_334;

        }
        else if (yytoken == Token_ARRAY
                 || yytoken == Token_BACKSLASH
                 || yytoken == Token_BACKTICK
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CONSTANT_ENCAPSED_STRING
                 || yytoken == Token_DEC
                 || yytoken == Token_DIR
                 || yytoken == Token_DNUMBER
                 || yytoken == Token_DOLLAR
                 || yytoken == Token_DOUBLE_QUOTE
                 || yytoken == Token_EMPTY
                 || yytoken == Token_FILE
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_INC
                 || yytoken == Token_ISSET
                 || yytoken == Token_LBRACKET
                 || yytoken == Token_LINE
                 || yytoken == Token_LNUMBER
                 || yytoken == Token_LPAREN
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_PRINT
                 || yytoken == Token_START_HEREDOC
                 || yytoken == Token_START_NOWDOC
                 || yytoken == Token_STRING
                 || yytoken == Token_STRING_VARNAME
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_VARIABLE
                 || yytoken == Token_YIELD
                 || yytoken == Token_YIELD_FROM)
        {
            UnaryExpressionNotPlusminusAst *__node_335 = nullptr;
            if (!parseUnaryExpressionNotPlusminus(&__node_335))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UnaryExpressionNotPlusminusKind, QStringLiteral("unaryExpressionNotPlusminus"));
                }
                return false;
            }
            (*yynode)->unaryExpressionNotPlusminus = __node_335;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseUnaryExpressionNotPlusminus(UnaryExpressionNotPlusminusAst **yynode)
{
    *yynode = create<UnaryExpressionNotPlusminusAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DEC
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_INC
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TRAIT_C
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        while (yytoken == Token_DEC
               || yytoken == Token_INC)
        {
            PostprefixOperatorAst *__node_336 = nullptr;
            if (!parsePostprefixOperator(&__node_336))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::PostprefixOperatorKind, QStringLiteral("postprefixOperator"));
                }
                return false;
            }
            (*yynode)->prefixOperatorSequence = snoc((*yynode)->prefixOperatorSequence, __node_336, memoryPool);

        }
        VarExpressionAst *__node_337 = nullptr;
        if (!parseVarExpression(&__node_337))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VarExpressionKind, QStringLiteral("varExpression"));
            }
            return false;
        }
        (*yynode)->varExpression = __node_337;

        while (yytoken == Token_DEC
               || yytoken == Token_INC)
        {
            PostprefixOperatorAst *__node_338 = nullptr;
            if (!parsePostprefixOperator(&__node_338))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::PostprefixOperatorKind, QStringLiteral("postprefixOperator"));
                }
                return false;
            }
            (*yynode)->postfixOperatorSequence = snoc((*yynode)->postfixOperatorSequence, __node_338, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseUseNamespace(UseNamespaceAst **yynode)
{
    *yynode = create<UseNamespaceAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_STRING)
    {
        NamespacedIdentifierAst *__node_339 = nullptr;
        if (!parseNamespacedIdentifier(&__node_339))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::NamespacedIdentifierKind, QStringLiteral("namespacedIdentifier"));
            }
            return false;
        }
        (*yynode)->identifier = __node_339;

        if (yytoken == Token_AS)
        {
            if (yytoken != Token_AS)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_AS, QStringLiteral("as"));
                }
                return false;
            }
            yylex();

            IdentifierAst *__node_340 = nullptr;
            if (!parseIdentifier(&__node_340))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                }
                return false;
            }
            (*yynode)->aliasIdentifier = __node_340;

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseUseStatement(UseStatementAst **yynode)
{
    *yynode = create<UseStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->useFunction = -1;
    (*yynode)->useConst = -1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_CONST
        || yytoken == Token_FUNCTION
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_FUNCTION)
        {
            if (yytoken != Token_FUNCTION)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_FUNCTION, QStringLiteral("function"));
                }
                return false;
            }
            (*yynode)->useFunction = tokenStream->index() - 1;
            yylex();

        }
        else if (yytoken == Token_CONST)
        {
            if (yytoken != Token_CONST)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CONST, QStringLiteral("const"));
                }
                return false;
            }
            (*yynode)->useConst = tokenStream->index() - 1;
            yylex();

        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
        UseNamespaceAst *__node_341 = nullptr;
        if (!parseUseNamespace(&__node_341))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::UseNamespaceKind, QStringLiteral("useNamespace"));
            }
            return false;
        }
        (*yynode)->useNamespaceSequence = snoc((*yynode)->useNamespaceSequence, __node_341, memoryPool);

        while (yytoken == Token_COMMA)
        {
            if (yytoken != Token_COMMA)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                }
                return false;
            }
            yylex();

            UseNamespaceAst *__node_342 = nullptr;
            if (!parseUseNamespace(&__node_342))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::UseNamespaceKind, QStringLiteral("useNamespace"));
                }
                return false;
            }
            (*yynode)->useNamespaceSequence = snoc((*yynode)->useNamespaceSequence, __node_342, memoryPool);

        }
        if (yytoken != Token_SEMICOLON)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_SEMICOLON, QStringLiteral(";"));
            }
            return false;
        }
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVarExpression(VarExpressionAst **yynode)
{
    *yynode = create<VarExpressionAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->print = -1;
    (*yynode)->isGenerator = -1;
    (*yynode)->isGenerator = -1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_PRINT
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TRAIT_C
        || yytoken == Token_VARIABLE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_PRINT)
        {
            do
            {
                if (yytoken != Token_PRINT)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_PRINT, QStringLiteral("print"));
                    }
                    return false;
                }
                (*yynode)->print = tokenStream->index() - 1;
                yylex();

            }
            while (yytoken == Token_PRINT);
            AssignmentExpressionAst *__node_343 = nullptr;
            if (!parseAssignmentExpression(&__node_343))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::AssignmentExpressionKind, QStringLiteral("assignmentExpression"));
                }
                return false;
            }
            (*yynode)->printExpression = __node_343;

        }
        else if (yytoken == Token_YIELD)
        {
            if (yytoken != Token_YIELD)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_YIELD, QStringLiteral("yield"));
                }
                return false;
            }
            (*yynode)->isGenerator = tokenStream->index() - 1;
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                PrintExpressionAst *__node_344 = nullptr;
                if (!parsePrintExpression(&__node_344))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::PrintExpressionKind, QStringLiteral("printExpression"));
                    }
                    return false;
                }
                (*yynode)->generatorExpression = __node_344;

                if (yytoken == Token_DOUBLE_ARROW)
                {
                    if (yytoken != Token_DOUBLE_ARROW)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_DOUBLE_ARROW, QStringLiteral("=>"));
                        }
                        return false;
                    }
                    yylex();

                    PrintExpressionAst *__node_345 = nullptr;
                    if (!parsePrintExpression(&__node_345))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::PrintExpressionKind, QStringLiteral("printExpression"));
                        }
                        return false;
                    }
                    (*yynode)->generatorValueExpr = __node_345;

                }
                else if (true /*epsilon*/)
                {
                }
                else
                {
                    return false;
                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
        }
        else if (yytoken == Token_YIELD_FROM)
        {
            if (yytoken != Token_YIELD_FROM)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_YIELD_FROM, QStringLiteral("yield from"));
                }
                return false;
            }
            (*yynode)->isGenerator = tokenStream->index() - 1;
            yylex();

            PrintExpressionAst *__node_346 = nullptr;
            if (!parsePrintExpression(&__node_346))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::PrintExpressionKind, QStringLiteral("printExpression"));
                }
                return false;
            }
            (*yynode)->generatorExpression = __node_346;

        }
        else if ((yytoken == Token_BACKSLASH
                  || yytoken == Token_DOLLAR
                  || yytoken == Token_STRING
                  || yytoken == Token_VARIABLE) && (
# 543 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                     m_state.varExpressionState == OnlyVariable ))
        {

# 543 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            m_state.varExpressionState = Normal;
            VariableAst *__node_347 = nullptr;
            if (!parseVariable(&__node_347))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->variable = __node_347;

        }
        else if ((yytoken == Token_NEW) && (
# 544 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                     m_state.varExpressionState == OnlyNewObject ))
        {

# 544 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
            m_state.varExpressionState = Normal;
            VarExpressionNewObjectAst *__node_348 = nullptr;
            if (!parseVarExpressionNewObject(&__node_348))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VarExpressionNewObjectKind, QStringLiteral("varExpressionNewObject"));
                }
                return false;
            }
            (*yynode)->newObject = __node_348;

        }
        else if (yytoken == Token_BACKSLASH
                 || yytoken == Token_BACKTICK
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CLONE
                 || yytoken == Token_CONSTANT_ENCAPSED_STRING
                 || yytoken == Token_DIR
                 || yytoken == Token_DNUMBER
                 || yytoken == Token_DOLLAR
                 || yytoken == Token_DOUBLE_QUOTE
                 || yytoken == Token_EMPTY
                 || yytoken == Token_FILE
                 || yytoken == Token_FUNCTION
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_ISSET
                 || yytoken == Token_LINE
                 || yytoken == Token_LNUMBER
                 || yytoken == Token_LPAREN
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_NEW
                 || yytoken == Token_START_HEREDOC
                 || yytoken == Token_START_NOWDOC
                 || yytoken == Token_STRING
                 || yytoken == Token_STRING_VARNAME
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_VARIABLE)
        {
            VarExpressionNormalAst *__node_349 = nullptr;
            if (!parseVarExpressionNormal(&__node_349))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VarExpressionNormalKind, QStringLiteral("varExpressionNormal"));
                }
                return false;
            }
            (*yynode)->varExpressionNormal = __node_349;

        }
        else if (yytoken == Token_ARRAY
                 || yytoken == Token_LBRACKET)
        {
            VarExpressionArrayAst *__node_350 = nullptr;
            if (!parseVarExpressionArray(&__node_350))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VarExpressionArrayKind, QStringLiteral("varExpressionArray"));
                }
                return false;
            }
            (*yynode)->varExpressionArray = __node_350;

            while (yytoken == Token_LBRACKET)
            {
                ArrayIndexSpecifierAst *__node_351 = nullptr;
                if (!parseArrayIndexSpecifier(&__node_351))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ArrayIndexSpecifierKind, QStringLiteral("arrayIndexSpecifier"));
                    }
                    return false;
                }
                (*yynode)->arrayIndex = __node_351;

            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVarExpressionArray(VarExpressionArrayAst **yynode)
{
    *yynode = create<VarExpressionArrayAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_LBRACKET)
    {
        if (yytoken == Token_ARRAY)
        {
            if (yytoken != Token_ARRAY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ARRAY, QStringLiteral("array"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BIT_AND
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                ArrayPairValueAst *__node_352 = nullptr;
                if (!parseArrayPairValue(&__node_352))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ArrayPairValueKind, QStringLiteral("arrayPairValue"));
                    }
                    return false;
                }
                (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_352, memoryPool);

                while (yytoken == Token_COMMA)
                {
                    if (yytoken != Token_COMMA)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                        }
                        return false;
                    }
                    yylex();


# 567 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                    if (yytoken == Token_RPAREN)
                    {
                        break;
                    }
                    ArrayPairValueAst *__node_353 = nullptr;
                    if (!parseArrayPairValue(&__node_353))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ArrayPairValueKind, QStringLiteral("arrayPairValue"));
                        }
                        return false;
                    }
                    (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_353, memoryPool);

                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_LBRACKET)
        {
            if (yytoken != Token_LBRACKET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACKET, QStringLiteral("["));
                }
                return false;
            }
            yylex();

            if (yytoken == Token_ARRAY
                || yytoken == Token_ARRAY_CAST
                || yytoken == Token_AT
                || yytoken == Token_BACKSLASH
                || yytoken == Token_BACKTICK
                || yytoken == Token_BANG
                || yytoken == Token_BIT_AND
                || yytoken == Token_BOOL_CAST
                || yytoken == Token_CLASS_C
                || yytoken == Token_CLONE
                || yytoken == Token_CONSTANT_ENCAPSED_STRING
                || yytoken == Token_DEC
                || yytoken == Token_DIR
                || yytoken == Token_DNUMBER
                || yytoken == Token_DOLLAR
                || yytoken == Token_DOUBLE_CAST
                || yytoken == Token_DOUBLE_QUOTE
                || yytoken == Token_EMPTY
                || yytoken == Token_EVAL
                || yytoken == Token_EXIT
                || yytoken == Token_FILE
                || yytoken == Token_FUNCTION
                || yytoken == Token_FUNC_C
                || yytoken == Token_INC
                || yytoken == Token_INCLUDE
                || yytoken == Token_INCLUDE_ONCE
                || yytoken == Token_INT_CAST
                || yytoken == Token_ISSET
                || yytoken == Token_LBRACKET
                || yytoken == Token_LINE
                || yytoken == Token_LIST
                || yytoken == Token_LNUMBER
                || yytoken == Token_LPAREN
                || yytoken == Token_METHOD_C
                || yytoken == Token_MINUS
                || yytoken == Token_NAMESPACE_C
                || yytoken == Token_NEW
                || yytoken == Token_OBJECT_CAST
                || yytoken == Token_PLUS
                || yytoken == Token_PRINT
                || yytoken == Token_REQUIRE
                || yytoken == Token_REQUIRE_ONCE
                || yytoken == Token_START_HEREDOC
                || yytoken == Token_START_NOWDOC
                || yytoken == Token_STRING
                || yytoken == Token_STRING_CAST
                || yytoken == Token_STRING_VARNAME
                || yytoken == Token_TILDE
                || yytoken == Token_TRAIT_C
                || yytoken == Token_UNSET_CAST
                || yytoken == Token_VARIABLE
                || yytoken == Token_YIELD
                || yytoken == Token_YIELD_FROM)
            {
                ArrayPairValueAst *__node_354 = nullptr;
                if (!parseArrayPairValue(&__node_354))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ArrayPairValueKind, QStringLiteral("arrayPairValue"));
                    }
                    return false;
                }
                (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_354, memoryPool);

                while (yytoken == Token_COMMA)
                {
                    if (yytoken != Token_COMMA)
                    {
                        if (!mBlockErrors)
                        {
                            expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                        }
                        return false;
                    }
                    yylex();


# 572 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                    if (yytoken == Token_RBRACKET)
                    {
                        break;
                    }
                    ArrayPairValueAst *__node_355 = nullptr;
                    if (!parseArrayPairValue(&__node_355))
                    {
                        if (!mBlockErrors)
                        {
                            expectedSymbol(AstNode::ArrayPairValueKind, QStringLiteral("arrayPairValue"));
                        }
                        return false;
                    }
                    (*yynode)->arrayValuesSequence = snoc((*yynode)->arrayValuesSequence, __node_355, memoryPool);

                }
            }
            else if (true /*epsilon*/)
            {
            }
            else
            {
                return false;
            }
            if (yytoken != Token_RBRACKET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACKET, QStringLiteral("]"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVarExpressionNewObject(VarExpressionNewObjectAst **yynode)
{
    *yynode = create<VarExpressionNewObjectAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_NEW)
    {
        if (yytoken != Token_NEW)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_NEW, QStringLiteral("new"));
            }
            return false;
        }
        yylex();

        ClassNameReferenceAst *__node_356 = nullptr;
        if (!parseClassNameReference(&__node_356))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ClassNameReferenceKind, QStringLiteral("classNameReference"));
            }
            return false;
        }
        (*yynode)->classNameReference = __node_356;

        CtorArgumentsAst *__node_357 = nullptr;
        if (!parseCtorArguments(&__node_357))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::CtorArgumentsKind, QStringLiteral("ctorArguments"));
            }
            return false;
        }
        (*yynode)->ctor = __node_357;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVarExpressionNormal(VarExpressionNormalAst **yynode)
{
    *yynode = create<VarExpressionNormalAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_EMPTY
        || yytoken == Token_FILE
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_ISSET
        || yytoken == Token_LINE
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_TRAIT_C
        || yytoken == Token_VARIABLE)
    {
        if ((yytoken == Token_LPAREN) && (
# 549 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                LA(1).kind == Token_LPAREN && LA(2).kind == Token_FUNCTION && LA(3).kind == Token_LPAREN ))
        {
            IifeSyntaxAst *__node_358 = nullptr;
            if (!parseIifeSyntax(&__node_358))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IifeSyntaxKind, QStringLiteral("iifeSyntax"));
                }
                return false;
            }
            (*yynode)->iife = __node_358;

        }
        else if (yytoken == Token_LPAREN)
        {
            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            bool blockErrors_15 = blockErrors(true);
            qint64 try_startToken_15 = tokenStream->index() - 1;
            ParserState *try_startState_15 = copyCurrentState();
            {
                VarExpressionNewObjectAst *__node_359 = nullptr;
                if (!parseVarExpressionNewObject(&__node_359))
                {
                    goto __catch_15;
                }
                (*yynode)->newObject = __node_359;

                if (yytoken != Token_RPAREN)
                    goto __catch_15;
                yylex();

                while (yytoken == Token_OBJECT_OPERATOR)
                {
                    InstantiationAccessAst *__node_360 = nullptr;
                    if (!parseInstantiationAccess(&__node_360))
                    {
                        goto __catch_15;
                    }
                    (*yynode)->variablePropertiesSequence = snoc((*yynode)->variablePropertiesSequence, __node_360, memoryPool);

                }
            }
            blockErrors(blockErrors_15);
            if (try_startState_15)
                delete try_startState_15;

            if (false) // the only way to enter here is using goto
            {
__catch_15:
                if (try_startState_15)
                {
                    restoreState(try_startState_15);
                    delete try_startState_15;
                }
                blockErrors(blockErrors_15);
                rewind(try_startToken_15);

                ExprAst *__node_361 = nullptr;
                if (!parseExpr(&__node_361))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                    }
                    return false;
                }
                (*yynode)->expression = __node_361;

                if (yytoken != Token_RPAREN)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                    }
                    return false;
                }
                yylex();

            }

        }
        else if (yytoken == Token_BACKTICK)
        {
            if (yytoken != Token_BACKTICK)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BACKTICK, QStringLiteral("`"));
                }
                return false;
            }
            yylex();

            EncapsListAst *__node_362 = nullptr;
            if (!parseEncapsList(&__node_362))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::EncapsListKind, QStringLiteral("encapsList"));
                }
                return false;
            }
            (*yynode)->encapsList = __node_362;

            if (yytoken != Token_BACKTICK)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_BACKTICK, QStringLiteral("`"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_BACKSLASH
                 || yytoken == Token_CLASS_C
                 || yytoken == Token_CONSTANT_ENCAPSED_STRING
                 || yytoken == Token_DIR
                 || yytoken == Token_DNUMBER
                 || yytoken == Token_DOLLAR
                 || yytoken == Token_DOUBLE_QUOTE
                 || yytoken == Token_FILE
                 || yytoken == Token_FUNC_C
                 || yytoken == Token_LINE
                 || yytoken == Token_LNUMBER
                 || yytoken == Token_METHOD_C
                 || yytoken == Token_NAMESPACE_C
                 || yytoken == Token_START_HEREDOC
                 || yytoken == Token_START_NOWDOC
                 || yytoken == Token_STRING
                 || yytoken == Token_STRING_VARNAME
                 || yytoken == Token_TRAIT_C
                 || yytoken == Token_VARIABLE)
        {
            bool blockErrors_16 = blockErrors(true);
            qint64 try_startToken_16 = tokenStream->index() - 1;
            ParserState *try_startState_16 = copyCurrentState();
            {
                VariableAst *__node_363 = nullptr;
                if (!parseVariable(&__node_363))
                {
                    goto __catch_16;
                }
                (*yynode)->variable = __node_363;


# 555 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                m_state.varExpressionIsVariable = true;
            }
            blockErrors(blockErrors_16);
            if (try_startState_16)
                delete try_startState_16;

            if (false) // the only way to enter here is using goto
            {
__catch_16:
                if (try_startState_16)
                {
                    restoreState(try_startState_16);
                    delete try_startState_16;
                }
                blockErrors(blockErrors_16);
                rewind(try_startToken_16);

                ScalarAst *__node_364 = nullptr;
                if (!parseScalar(&__node_364))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ScalarKind, QStringLiteral("scalar"));
                    }
                    return false;
                }
                (*yynode)->scalar = __node_364;

            }

        }
        else if (yytoken == Token_ISSET)
        {
            if (yytoken != Token_ISSET)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ISSET, QStringLiteral("isset"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            VariableAst *__node_365 = nullptr;
            if (!parseVariable(&__node_365))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->issetVariableSequence = snoc((*yynode)->issetVariableSequence, __node_365, memoryPool);

            while (yytoken == Token_COMMA)
            {
                if (yytoken != Token_COMMA)
                {
                    if (!mBlockErrors)
                    {
                        expectedToken(yytoken, Token_COMMA, QStringLiteral(","));
                    }
                    return false;
                }
                yylex();

                VariableAst *__node_366 = nullptr;
                if (!parseVariable(&__node_366))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                    }
                    return false;
                }
                (*yynode)->issetVariableSequence = snoc((*yynode)->issetVariableSequence, __node_366, memoryPool);

            }
            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_EMPTY)
        {
            if (yytoken != Token_EMPTY)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_EMPTY, QStringLiteral("empty"));
                }
                return false;
            }
            yylex();

            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            yylex();

            ExprAst *__node_367 = nullptr;
            if (!parseExpr(&__node_367))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->emptyExpression = __node_367;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_NEW)
        {
            VarExpressionNewObjectAst *__node_368 = nullptr;
            if (!parseVarExpressionNewObject(&__node_368))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VarExpressionNewObjectKind, QStringLiteral("varExpressionNewObject"));
                }
                return false;
            }
            (*yynode)->newObject = __node_368;

        }
        else if (yytoken == Token_CLONE)
        {
            if (yytoken != Token_CLONE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_CLONE, QStringLiteral("clone"));
                }
                return false;
            }
            yylex();

            VarExpressionNormalAst *__node_369 = nullptr;
            if (!parseVarExpressionNormal(&__node_369))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VarExpressionNormalKind, QStringLiteral("varExpressionNormal"));
                }
                return false;
            }
            (*yynode)->cloneCar = __node_369;

        }
        else if (yytoken == Token_FUNCTION)
        {
            ClosureAst *__node_370 = nullptr;
            if (!parseClosure(&__node_370))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ClosureKind, QStringLiteral("closure"));
                }
                return false;
            }
            (*yynode)->closure = __node_370;

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVariable(VariableAst **yynode)
{
    *yynode = create<VariableAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_BACKSLASH
        || yytoken == Token_DOLLAR
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        BaseVariableWithFunctionCallsAst *__node_371 = nullptr;
        if (!parseBaseVariableWithFunctionCalls(&__node_371))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::BaseVariableWithFunctionCallsKind, QStringLiteral("baseVariableWithFunctionCalls"));
            }
            return false;
        }
        (*yynode)->var = __node_371;

        while (yytoken == Token_OBJECT_OPERATOR
               || yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
        {
            VariableObjectPropertyAst *__node_372 = nullptr;
            if (!parseVariableObjectProperty(&__node_372))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableObjectPropertyKind, QStringLiteral("variableObjectProperty"));
                }
                return false;
            }
            (*yynode)->variablePropertiesSequence = snoc((*yynode)->variablePropertiesSequence, __node_372, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVariableIdentifier(VariableIdentifierAst **yynode)
{
    *yynode = create<VariableIdentifierAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->variable = -1;

    if (yytoken == Token_VARIABLE)
    {
        if (yytoken != Token_VARIABLE)
        {
            if (!mBlockErrors)
            {
                expectedToken(yytoken, Token_VARIABLE, QStringLiteral("variable"));
            }
            return false;
        }
        (*yynode)->variable = tokenStream->index() - 1;
        yylex();

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVariableName(VariableNameAst **yynode)
{
    *yynode = create<VariableNameAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_LBRACE
        || yytoken == Token_STRING)
    {
        if (yytoken == Token_STRING)
        {
            IdentifierAst *__node_373 = nullptr;
            if (!parseIdentifier(&__node_373))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::IdentifierKind, QStringLiteral("identifier"));
                }
                return false;
            }
            (*yynode)->name = __node_373;

        }
        else if (yytoken == Token_LBRACE)
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            ExprAst *__node_374 = nullptr;
            if (!parseExpr(&__node_374))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ExprKind, QStringLiteral("expr"));
                }
                return false;
            }
            (*yynode)->expr = __node_374;

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVariableObjectProperty(VariableObjectPropertyAst **yynode)
{
    *yynode = create<VariableObjectPropertyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_OBJECT_OPERATOR
        || yytoken == Token_PAAMAYIM_NEKUDOTAYIM)
    {
        ObjectOperatorAst *__node_375 = nullptr;
        if (!parseObjectOperator(&__node_375))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::ObjectOperatorKind, QStringLiteral("objectOperator"));
            }
            return false;
        }
        VariablePropertyAst *__node_376 = nullptr;
        if (!parseVariableProperty(&__node_376))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::VariablePropertyKind, QStringLiteral("variableProperty"));
            }
            return false;
        }
        (*yynode)->variableProperty = __node_376;

    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVariableProperty(VariablePropertyAst **yynode)
{
    *yynode = create<VariablePropertyAst>();

    (*yynode)->startToken = tokenStream->index() - 1;
    (*yynode)->isFunctionCall = -1;

    if (yytoken == Token_DOLLAR
        || yytoken == Token_LBRACE
        || yytoken == Token_STRING
        || yytoken == Token_VARIABLE)
    {
        if ((yytoken == Token_LBRACE) && (
# 625 "/build/kdevelop-php/src/kdev-php-22.08.0/parser/php.g" 1
                LA(1).kind == Token_DOLLAR))
        {
            if (yytoken != Token_LBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LBRACE, QStringLiteral("{"));
                }
                return false;
            }
            yylex();

            VariableAst *__node_377 = nullptr;
            if (!parseVariable(&__node_377))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::VariableKind, QStringLiteral("variable"));
                }
                return false;
            }
            (*yynode)->variable = __node_377;

            if (yytoken != Token_RBRACE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RBRACE, QStringLiteral("}"));
                }
                return false;
            }
            yylex();

        }
        else if (yytoken == Token_DOLLAR
                 || yytoken == Token_LBRACE
                 || yytoken == Token_STRING
                 || yytoken == Token_VARIABLE)
        {
            ObjectPropertyAst *__node_378 = nullptr;
            if (!parseObjectProperty(&__node_378))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::ObjectPropertyKind, QStringLiteral("objectProperty"));
                }
                return false;
            }
            (*yynode)->objectProperty = __node_378;

        }
        else
        {
            return false;
        }
        if (yytoken == Token_LPAREN)
        {
            if (yytoken != Token_LPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_LPAREN, QStringLiteral("("));
                }
                return false;
            }
            (*yynode)->isFunctionCall = tokenStream->index() - 1;
            yylex();

            FunctionCallParameterListAst *__node_379 = nullptr;
            if (!parseFunctionCallParameterList(&__node_379))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::FunctionCallParameterListKind, QStringLiteral("functionCallParameterList"));
                }
                return false;
            }
            (*yynode)->parameterList = __node_379;

            if (yytoken != Token_RPAREN)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_RPAREN, QStringLiteral(")"));
                }
                return false;
            }
            yylex();

            while (yytoken == Token_LBRACKET)
            {
                ArrayIndexSpecifierAst *__node_380 = nullptr;
                if (!parseArrayIndexSpecifier(&__node_380))
                {
                    if (!mBlockErrors)
                    {
                        expectedSymbol(AstNode::ArrayIndexSpecifierKind, QStringLiteral("arrayIndexSpecifier"));
                    }
                    return false;
                }
                (*yynode)->arrayIndex = __node_380;

            }
        }
        else if (true /*epsilon*/)
        {
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseVariableWithoutObjects(VariableWithoutObjectsAst **yynode)
{
    *yynode = create<VariableWithoutObjectsAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_DOLLAR
        || yytoken == Token_VARIABLE)
    {
        CompoundVariableWithSimpleIndirectReferenceAst *__node_381 = nullptr;
        if (!parseCompoundVariableWithSimpleIndirectReference(&__node_381))
        {
            if (!mBlockErrors)
            {
                expectedSymbol(AstNode::CompoundVariableWithSimpleIndirectReferenceKind, QStringLiteral("compoundVariableWithSimpleIndirectReference"));
            }
            return false;
        }
        (*yynode)->variable = __node_381;

        while (yytoken == Token_LBRACE
               || yytoken == Token_LBRACKET)
        {
            DimListItemAst *__node_382 = nullptr;
            if (!parseDimListItem(&__node_382))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::DimListItemKind, QStringLiteral("dimListItem"));
                }
                return false;
            }
            (*yynode)->offsetItemsSequence = snoc((*yynode)->offsetItemsSequence, __node_382, memoryPool);

        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}

bool Parser::parseWhileStatement(WhileStatementAst **yynode)
{
    *yynode = create<WhileStatementAst>();

    (*yynode)->startToken = tokenStream->index() - 1;

    if (yytoken == Token_ARRAY
        || yytoken == Token_ARRAY_CAST
        || yytoken == Token_AT
        || yytoken == Token_BACKSLASH
        || yytoken == Token_BACKTICK
        || yytoken == Token_BANG
        || yytoken == Token_BOOL_CAST
        || yytoken == Token_BREAK
        || yytoken == Token_CLASS_C
        || yytoken == Token_CLONE
        || yytoken == Token_CLOSE_TAG
        || yytoken == Token_COLON
        || yytoken == Token_CONST
        || yytoken == Token_CONSTANT_ENCAPSED_STRING
        || yytoken == Token_CONTINUE
        || yytoken == Token_DEC
        || yytoken == Token_DECLARE
        || yytoken == Token_DIR
        || yytoken == Token_DNUMBER
        || yytoken == Token_DO
        || yytoken == Token_DOLLAR
        || yytoken == Token_DOUBLE_CAST
        || yytoken == Token_DOUBLE_QUOTE
        || yytoken == Token_ECHO
        || yytoken == Token_EMPTY
        || yytoken == Token_EVAL
        || yytoken == Token_EXIT
        || yytoken == Token_FILE
        || yytoken == Token_FOR
        || yytoken == Token_FOREACH
        || yytoken == Token_FUNCTION
        || yytoken == Token_FUNC_C
        || yytoken == Token_GLOBAL
        || yytoken == Token_GOTO
        || yytoken == Token_IF
        || yytoken == Token_INC
        || yytoken == Token_INCLUDE
        || yytoken == Token_INCLUDE_ONCE
        || yytoken == Token_INLINE_HTML
        || yytoken == Token_INT_CAST
        || yytoken == Token_ISSET
        || yytoken == Token_LBRACE
        || yytoken == Token_LBRACKET
        || yytoken == Token_LINE
        || yytoken == Token_LIST
        || yytoken == Token_LNUMBER
        || yytoken == Token_LPAREN
        || yytoken == Token_METHOD_C
        || yytoken == Token_MINUS
        || yytoken == Token_NAMESPACE_C
        || yytoken == Token_NEW
        || yytoken == Token_OBJECT_CAST
        || yytoken == Token_OPEN_TAG
        || yytoken == Token_OPEN_TAG_WITH_ECHO
        || yytoken == Token_PLUS
        || yytoken == Token_PRINT
        || yytoken == Token_REQUIRE
        || yytoken == Token_REQUIRE_ONCE
        || yytoken == Token_RETURN
        || yytoken == Token_SEMICOLON
        || yytoken == Token_START_HEREDOC
        || yytoken == Token_START_NOWDOC
        || yytoken == Token_STATIC
        || yytoken == Token_STRING
        || yytoken == Token_STRING_CAST
        || yytoken == Token_STRING_VARNAME
        || yytoken == Token_SWITCH
        || yytoken == Token_THROW
        || yytoken == Token_TILDE
        || yytoken == Token_TRAIT_C
        || yytoken == Token_TRY
        || yytoken == Token_UNSET
        || yytoken == Token_UNSET_CAST
        || yytoken == Token_USE
        || yytoken == Token_VARIABLE
        || yytoken == Token_WHILE
        || yytoken == Token_YIELD
        || yytoken == Token_YIELD_FROM)
    {
        if (yytoken == Token_ARRAY
            || yytoken == Token_ARRAY_CAST
            || yytoken == Token_AT
            || yytoken == Token_BACKSLASH
            || yytoken == Token_BACKTICK
            || yytoken == Token_BANG
            || yytoken == Token_BOOL_CAST
            || yytoken == Token_BREAK
            || yytoken == Token_CLASS_C
            || yytoken == Token_CLONE
            || yytoken == Token_CLOSE_TAG
            || yytoken == Token_CONST
            || yytoken == Token_CONSTANT_ENCAPSED_STRING
            || yytoken == Token_CONTINUE
            || yytoken == Token_DEC
            || yytoken == Token_DECLARE
            || yytoken == Token_DIR
            || yytoken == Token_DNUMBER
            || yytoken == Token_DO
            || yytoken == Token_DOLLAR
            || yytoken == Token_DOUBLE_CAST
            || yytoken == Token_DOUBLE_QUOTE
            || yytoken == Token_ECHO
            || yytoken == Token_EMPTY
            || yytoken == Token_EVAL
            || yytoken == Token_EXIT
            || yytoken == Token_FILE
            || yytoken == Token_FOR
            || yytoken == Token_FOREACH
            || yytoken == Token_FUNCTION
            || yytoken == Token_FUNC_C
            || yytoken == Token_GLOBAL
            || yytoken == Token_GOTO
            || yytoken == Token_IF
            || yytoken == Token_INC
            || yytoken == Token_INCLUDE
            || yytoken == Token_INCLUDE_ONCE
            || yytoken == Token_INLINE_HTML
            || yytoken == Token_INT_CAST
            || yytoken == Token_ISSET
            || yytoken == Token_LBRACE
            || yytoken == Token_LBRACKET
            || yytoken == Token_LINE
            || yytoken == Token_LIST
            || yytoken == Token_LNUMBER
            || yytoken == Token_LPAREN
            || yytoken == Token_METHOD_C
            || yytoken == Token_MINUS
            || yytoken == Token_NAMESPACE_C
            || yytoken == Token_NEW
            || yytoken == Token_OBJECT_CAST
            || yytoken == Token_OPEN_TAG
            || yytoken == Token_OPEN_TAG_WITH_ECHO
            || yytoken == Token_PLUS
            || yytoken == Token_PRINT
            || yytoken == Token_REQUIRE
            || yytoken == Token_REQUIRE_ONCE
            || yytoken == Token_RETURN
            || yytoken == Token_SEMICOLON
            || yytoken == Token_START_HEREDOC
            || yytoken == Token_START_NOWDOC
            || yytoken == Token_STATIC
            || yytoken == Token_STRING
            || yytoken == Token_STRING_CAST
            || yytoken == Token_STRING_VARNAME
            || yytoken == Token_SWITCH
            || yytoken == Token_THROW
            || yytoken == Token_TILDE
            || yytoken == Token_TRAIT_C
            || yytoken == Token_TRY
            || yytoken == Token_UNSET
            || yytoken == Token_UNSET_CAST
            || yytoken == Token_USE
            || yytoken == Token_VARIABLE
            || yytoken == Token_WHILE
            || yytoken == Token_YIELD
            || yytoken == Token_YIELD_FROM)
        {
            StatementAst *__node_383 = nullptr;
            if (!parseStatement(&__node_383))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::StatementKind, QStringLiteral("statement"));
                }
                return false;
            }
            (*yynode)->statement = __node_383;

        }
        else if (yytoken == Token_COLON)
        {
            if (yytoken != Token_COLON)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_COLON, QStringLiteral(":"));
                }
                return false;
            }
            yylex();

            InnerStatementListAst *__node_384 = nullptr;
            if (!parseInnerStatementList(&__node_384))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::InnerStatementListKind, QStringLiteral("innerStatementList"));
                }
                return false;
            }
            (*yynode)->statements = __node_384;

            if (yytoken != Token_ENDWHILE)
            {
                if (!mBlockErrors)
                {
                    expectedToken(yytoken, Token_ENDWHILE, QStringLiteral("endwhile"));
                }
                return false;
            }
            yylex();

            SemicolonOrCloseTagAst *__node_385 = nullptr;
            if (!parseSemicolonOrCloseTag(&__node_385))
            {
                if (!mBlockErrors)
                {
                    expectedSymbol(AstNode::SemicolonOrCloseTagKind, QStringLiteral("semicolonOrCloseTag"));
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    else
    {
        return false;
    }

    (*yynode)->endToken = tokenStream->index() - 2;

    return true;
}


} // end of namespace Php

