/* model-utils.c generated by valac 0.56.2, the Vala compiler
 * generated from model-utils.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdarg.h>
#include <glib/gi18n-lib.h>

#define MODEL_UTILS_special_context_id_number ((guint16) 3)
#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#define MODEL_UTILS_folder_context_id ((guint16) 1)
#define MODEL_UTILS_dconf_context_id ((guint16) 2)
#define MODEL_UTILS_undefined_context_id_string "0"
#define MODEL_UTILS_folder_context_id_string "1"
#define MODEL_UTILS_dconf_context_id_string "2"
#define MODEL_UTILS__garbage_ ""
#define MODEL_UTILS__desc_N_ _ ("Signed 16-bit integer")
#define MODEL_UTILS__desc_Q_ _ ("Unsigned 16-bit integer")
#define MODEL_UTILS__desc_I_ _ ("Signed 32-bit integer")
#define MODEL_UTILS__desc_U_ _ ("Unsigned 32-bit integer")
#define MODEL_UTILS__desc_X_ _ ("Signed 64-bit integer")
#define MODEL_UTILS__desc_T_ _ ("Unsigned 64-bit integer")
#define MODEL_UTILS__B_ _ ("Boolean")
#define MODEL_UTILS__S_ _ ("String")
#define MODEL_UTILS__As_ _ ("String array")
#define MODEL_UTILS__Enum_ _ ("Enumeration")
#define MODEL_UTILS__Flags_ _ ("Flags")
#define MODEL_UTILS__D_ _ ("Double")
#define MODEL_UTILS__Integer_ _ ("Integer")
#define MODEL_UTILS__V_ _ ("Variant")
#define MODEL_UTILS__Empty_tuple_ _ ("Empty tuple")
#define MODEL_UTILS__b_ _ ("boolean")
#define MODEL_UTILS__s_ _ ("string")
#define MODEL_UTILS__as_ _ ("string array")
#define MODEL_UTILS__enum_ _ ("enumeration")
#define MODEL_UTILS__flags_ _ ("flags")
#define MODEL_UTILS__d_ _ ("double")
#define MODEL_UTILS__integer_ _ ("integer")
#define MODEL_UTILS__v_ _ ("variant")
#define MODEL_UTILS__empty_tuple_ _ ("empty tuple")
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	RANGE_TYPE_TYPE,
	RANGE_TYPE_ENUM,
	RANGE_TYPE_FLAGS,
	RANGE_TYPE_RANGE,
	RANGE_TYPE_OTHER
} RangeType;

#define TYPE_RANGE_TYPE (range_type_get_type ())
typedef enum  {
	KEY_CONFLICT_NONE,
	KEY_CONFLICT_SOFT,
	KEY_CONFLICT_HARD
} KeyConflict;

#define TYPE_KEY_CONFLICT (key_conflict_get_type ())
typedef enum  {
	PROPERTY_QUERY_HASH = 1 << 0,
	PROPERTY_QUERY_HAS_SCHEMA = 1 << 1,
	PROPERTY_QUERY_KEY_NAME = 1 << 2,
	PROPERTY_QUERY_TYPE_CODE = 1 << 3,
	PROPERTY_QUERY_KEY_VALUE = 1 << 4,
	PROPERTY_QUERY_FIXED_SCHEMA = 1 << 5,
	PROPERTY_QUERY_SCHEMA_ID = 1 << 6,
	PROPERTY_QUERY_SUMMARY = 1 << 7,
	PROPERTY_QUERY_DESCRIPTION = 1 << 8,
	PROPERTY_QUERY_DEFAULT_VALUE = 1 << 9,
	PROPERTY_QUERY_RANGE_TYPE = 1 << 10,
	PROPERTY_QUERY_RANGE_CONTENT = 1 << 11,
	PROPERTY_QUERY_MAXIMUM = 1 << 12,
	PROPERTY_QUERY_MINIMUM = 1 << 13,
	PROPERTY_QUERY_KEY_CONFLICT = 1 << 14,
	PROPERTY_QUERY_IS_DEFAULT = 1 << 15
} PropertyQuery;

#define TYPE_PROPERTY_QUERY (property_query_get_type ())

#define TYPE_REGISTRY_VARIANT_DICT (registry_variant_dict_get_type ())
#define REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict))
#define REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))
#define IS_REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VARIANT_DICT))
#define IS_REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VARIANT_DICT))
#define REGISTRY_VARIANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))

typedef struct _RegistryVariantDict RegistryVariantDict;
typedef struct _RegistryVariantDictClass RegistryVariantDictClass;
typedef struct _RegistryVariantDictPrivate RegistryVariantDictPrivate;
enum  {
	REGISTRY_VARIANT_DICT_0_PROPERTY,
	REGISTRY_VARIANT_DICT_NUM_PROPERTIES
};
static GParamSpec* registry_variant_dict_properties[REGISTRY_VARIANT_DICT_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _Block18Data Block18Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RegistryVariantDict {
	GObject parent_instance;
	RegistryVariantDictPrivate * priv;
};

struct _RegistryVariantDictClass {
	GObjectClass parent_class;
};

struct _RegistryVariantDictPrivate {
	GHashTable* hash_table;
};

struct _Block18Data {
	int _ref_count_;
	RegistryVariantDict* self;
	GVariantBuilder* builder;
};

static gint RegistryVariantDict_private_offset;
static gpointer registry_variant_dict_parent_class = NULL;

VALA_EXTERN GType range_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RangeType range_type_get_from_string (const gchar* str);
VALA_EXTERN GType key_conflict_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType property_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType registry_variant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryVariantDict, g_object_unref)
static guint _registry_variant_dict_hash_table_lambda30_ (guint16 a);
static guint __registry_variant_dict_hash_table_lambda30__ghash_func (gconstpointer key);
static gboolean _registry_variant_dict_hash_table_lambda31_ (guint16 a,
                                                      guint16 b);
static gboolean __registry_variant_dict_hash_table_lambda31__gequal_func (gconstpointer a,
                                                                   gconstpointer b);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new (void);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct (GType object_type);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new_from_aqv (GVariant* variant);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct_from_aqv (GType object_type,
                                                               GVariant* variant);
VALA_EXTERN gboolean registry_variant_dict_lookup (RegistryVariantDict* self,
                                       guint16 key,
                                       const gchar* format_string,
                                       ...);
VALA_EXTERN GVariant* registry_variant_dict_lookup_value (RegistryVariantDict* self,
                                              guint16 key,
                                              const GVariantType* expected_type);
VALA_EXTERN gboolean registry_variant_dict_contains (RegistryVariantDict* self,
                                         guint16 key);
VALA_EXTERN void registry_variant_dict_insert_value (RegistryVariantDict* self,
                                         guint16 key,
                                         GVariant* variant);
VALA_EXTERN gboolean registry_variant_dict_remove (RegistryVariantDict* self,
                                       guint16 key);
VALA_EXTERN void registry_variant_dict_clear (RegistryVariantDict* self);
VALA_EXTERN GVariant* registry_variant_dict_end (RegistryVariantDict* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void __lambda32_ (Block18Data* _data18_,
                  guint16 key,
                  GVariant* variant);
static void ___lambda32__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void registry_variant_dict_finalize (GObject * obj);
static GType registry_variant_dict_get_type_once (void);
VALA_EXTERN gboolean model_utils_is_undefined_context_id (guint16 context_id);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN gboolean model_utils_is_dconf_context_id (guint16 context_id);
VALA_EXTERN gboolean model_utils_is_key_path (const gchar* path);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
VALA_EXTERN gchar* model_utils_get_parent_path (const gchar* path);
VALA_EXTERN gchar* model_utils_get_base_path (const gchar* path);
VALA_EXTERN gchar* model_utils_get_name_or_empty (const gchar* path);
VALA_EXTERN gchar* model_utils_get_name (const gchar* path);
VALA_EXTERN gchar* model_utils_recreate_full_name (const gchar* base_path,
                                       const gchar* name,
                                       gboolean is_folder);
VALA_EXTERN gchar* model_utils_key_to_short_description (const gchar* type);
VALA_EXTERN void model_utils_get_type_non_capitalized_short_description (const gchar* type,
                                                             gchar** untranslated_description,
                                                             gchar** translated_description);
VALA_EXTERN void model_utils_get_type_capitalized_short_description (const gchar* type,
                                                         gchar** untranslated_description,
                                                         gchar** translated_description);
VALA_EXTERN gchar* model_utils_key_to_long_description (const gchar* type);
VALA_EXTERN void model_utils_get_type_capitalized_long_description (const gchar* type,
                                                        gchar** untranslated_description,
                                                        gchar** translated_description);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

RangeType
range_type_get_from_string (const gchar* str)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	RangeType result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("type")))) {
		switch (0) {
			default:
			{
				result = RANGE_TYPE_TYPE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("enum")))) {
		switch (0) {
			default:
			{
				result = RANGE_TYPE_ENUM;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("flags")))) {
		switch (0) {
			default:
			{
				result = RANGE_TYPE_FLAGS;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("range")))) {
		switch (0) {
			default:
			{
				result = RANGE_TYPE_RANGE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = RANGE_TYPE_OTHER;
				return result;
			}
		}
	}
}

static GType
range_type_get_type_once (void)
{
	static const GEnumValue values[] = {{RANGE_TYPE_TYPE, "RANGE_TYPE_TYPE", "type"}, {RANGE_TYPE_ENUM, "RANGE_TYPE_ENUM", "enum"}, {RANGE_TYPE_FLAGS, "RANGE_TYPE_FLAGS", "flags"}, {RANGE_TYPE_RANGE, "RANGE_TYPE_RANGE", "range"}, {RANGE_TYPE_OTHER, "RANGE_TYPE_OTHER", "other"}, {0, NULL, NULL}};
	GType range_type_type_id;
	range_type_type_id = g_enum_register_static ("RangeType", values);
	return range_type_type_id;
}

GType
range_type_get_type (void)
{
	static volatile gsize range_type_type_id__once = 0;
	if (g_once_init_enter (&range_type_type_id__once)) {
		GType range_type_type_id;
		range_type_type_id = range_type_get_type_once ();
		g_once_init_leave (&range_type_type_id__once, range_type_type_id);
	}
	return range_type_type_id__once;
}

static GType
key_conflict_get_type_once (void)
{
	static const GEnumValue values[] = {{KEY_CONFLICT_NONE, "KEY_CONFLICT_NONE", "none"}, {KEY_CONFLICT_SOFT, "KEY_CONFLICT_SOFT", "soft"}, {KEY_CONFLICT_HARD, "KEY_CONFLICT_HARD", "hard"}, {0, NULL, NULL}};
	GType key_conflict_type_id;
	key_conflict_type_id = g_enum_register_static ("KeyConflict", values);
	return key_conflict_type_id;
}

GType
key_conflict_get_type (void)
{
	static volatile gsize key_conflict_type_id__once = 0;
	if (g_once_init_enter (&key_conflict_type_id__once)) {
		GType key_conflict_type_id;
		key_conflict_type_id = key_conflict_get_type_once ();
		g_once_init_leave (&key_conflict_type_id__once, key_conflict_type_id);
	}
	return key_conflict_type_id__once;
}

static GType
property_query_get_type_once (void)
{
	static const GFlagsValue values[] = {{PROPERTY_QUERY_HASH, "PROPERTY_QUERY_HASH", "hash"}, {PROPERTY_QUERY_HAS_SCHEMA, "PROPERTY_QUERY_HAS_SCHEMA", "has-schema"}, {PROPERTY_QUERY_KEY_NAME, "PROPERTY_QUERY_KEY_NAME", "key-name"}, {PROPERTY_QUERY_TYPE_CODE, "PROPERTY_QUERY_TYPE_CODE", "type-code"}, {PROPERTY_QUERY_KEY_VALUE, "PROPERTY_QUERY_KEY_VALUE", "key-value"}, {PROPERTY_QUERY_FIXED_SCHEMA, "PROPERTY_QUERY_FIXED_SCHEMA", "fixed-schema"}, {PROPERTY_QUERY_SCHEMA_ID, "PROPERTY_QUERY_SCHEMA_ID", "schema-id"}, {PROPERTY_QUERY_SUMMARY, "PROPERTY_QUERY_SUMMARY", "summary"}, {PROPERTY_QUERY_DESCRIPTION, "PROPERTY_QUERY_DESCRIPTION", "description"}, {PROPERTY_QUERY_DEFAULT_VALUE, "PROPERTY_QUERY_DEFAULT_VALUE", "default-value"}, {PROPERTY_QUERY_RANGE_TYPE, "PROPERTY_QUERY_RANGE_TYPE", "range-type"}, {PROPERTY_QUERY_RANGE_CONTENT, "PROPERTY_QUERY_RANGE_CONTENT", "range-content"}, {PROPERTY_QUERY_MAXIMUM, "PROPERTY_QUERY_MAXIMUM", "maximum"}, {PROPERTY_QUERY_MINIMUM, "PROPERTY_QUERY_MINIMUM", "minimum"}, {PROPERTY_QUERY_KEY_CONFLICT, "PROPERTY_QUERY_KEY_CONFLICT", "key-conflict"}, {PROPERTY_QUERY_IS_DEFAULT, "PROPERTY_QUERY_IS_DEFAULT", "is-default"}, {0, NULL, NULL}};
	GType property_query_type_id;
	property_query_type_id = g_flags_register_static ("PropertyQuery", values);
	return property_query_type_id;
}

GType
property_query_get_type (void)
{
	static volatile gsize property_query_type_id__once = 0;
	if (g_once_init_enter (&property_query_type_id__once)) {
		GType property_query_type_id;
		property_query_type_id = property_query_get_type_once ();
		g_once_init_leave (&property_query_type_id__once, property_query_type_id);
	}
	return property_query_type_id__once;
}

static inline gpointer
registry_variant_dict_get_instance_private (RegistryVariantDict* self)
{
	return G_STRUCT_MEMBER_P (self, RegistryVariantDict_private_offset);
}

static guint
_registry_variant_dict_hash_table_lambda30_ (guint16 a)
{
	guint result;
	result = (guint) a;
	return result;
}

static guint
__registry_variant_dict_hash_table_lambda30__ghash_func (gconstpointer key)
{
	guint result;
	result = _registry_variant_dict_hash_table_lambda30_ ((guint16) ((guintptr) key));
	return result;
}

static gboolean
_registry_variant_dict_hash_table_lambda31_ (guint16 a,
                                             guint16 b)
{
	gboolean result;
	result = a == b;
	return result;
}

static gboolean
__registry_variant_dict_hash_table_lambda31__gequal_func (gconstpointer a,
                                                          gconstpointer b)
{
	gboolean result;
	result = _registry_variant_dict_hash_table_lambda31_ ((guint16) ((guintptr) a), (guint16) ((guintptr) b));
	return result;
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

RegistryVariantDict*
registry_variant_dict_construct (GType object_type)
{
	RegistryVariantDict * self = NULL;
	self = (RegistryVariantDict*) g_object_new (object_type, NULL);
	return self;
}

RegistryVariantDict*
registry_variant_dict_new (void)
{
	return registry_variant_dict_construct (TYPE_REGISTRY_VARIANT_DICT);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

RegistryVariantDict*
registry_variant_dict_construct_from_aqv (GType object_type,
                                          GVariant* variant)
{
	RegistryVariantDict * self = NULL;
	const gchar* _tmp0_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp1_;
	guint16 key = 0U;
	GVariant* content = NULL;
	g_return_val_if_fail (variant != NULL, NULL);
	self = (RegistryVariantDict*) g_object_new (object_type, NULL);
	_tmp0_ = g_variant_get_type_string (variant);
	if (g_strcmp0 (_tmp0_, "a{qv}") != 0) {
		g_assert_not_reached ();
	}
	_tmp1_ = g_variant_iter_new (variant);
	iter = _tmp1_;
	while (TRUE) {
		GVariantIter* _tmp2_;
		guint16 _tmp3_ = 0U;
		GVariant* _tmp4_ = NULL;
		gboolean _tmp5_;
		GHashTable* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		_tmp2_ = iter;
		_tmp5_ = g_variant_iter_next (_tmp2_, "{qv}", &_tmp3_, &_tmp4_, NULL);
		key = _tmp3_;
		_g_variant_unref0 (content);
		content = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->hash_table;
		_tmp7_ = content;
		_tmp8_ = _g_variant_ref0 (_tmp7_);
		g_hash_table_insert (_tmp6_, (gpointer) ((guintptr) key), _tmp8_);
	}
	_g_variant_unref0 (content);
	_g_variant_iter_free0 (iter);
	return self;
}

RegistryVariantDict*
registry_variant_dict_new_from_aqv (GVariant* variant)
{
	return registry_variant_dict_construct_from_aqv (TYPE_REGISTRY_VARIANT_DICT, variant);
}

gboolean
registry_variant_dict_lookup (RegistryVariantDict* self,
                              guint16 key,
                              const gchar* format_string,
                              ...)
{
	GVariant* variant = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GVariant* _tmp4_;
	va_list list = {0};
	GVariant* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (format_string != NULL, FALSE);
	_tmp0_ = self->priv->hash_table;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) key));
	_tmp2_ = _g_variant_ref0 ((GVariant*) _tmp1_);
	variant = _tmp2_;
	_tmp4_ = variant;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GVariant* _tmp5_;
		_tmp5_ = variant;
		_tmp3_ = !g_variant_check_format_string ((GVariant*) _tmp5_, format_string, FALSE);
	}
	if (_tmp3_) {
		result = FALSE;
		_g_variant_unref0 (variant);
		return result;
	}
	va_start (list, format_string);
	_tmp6_ = variant;
	g_variant_get_va ((GVariant*) _tmp6_, format_string, NULL, &list);
	result = TRUE;
	va_end (list);
	_g_variant_unref0 (variant);
	return result;
}

GVariant*
registry_variant_dict_lookup_value (RegistryVariantDict* self,
                                    guint16 key,
                                    const GVariantType* expected_type)
{
	GVariant* _result_ = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GVariant* _tmp4_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = self->priv->hash_table;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) key));
	_tmp2_ = _g_variant_ref0 ((GVariant*) _tmp1_);
	_result_ = _tmp2_;
	_tmp4_ = _result_;
	if (_tmp4_ == NULL) {
		GVariant* _tmp5_;
		_tmp5_ = _result_;
		_tmp3_ = !g_variant_is_of_type ((GVariant*) _tmp5_, expected_type);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = NULL;
		_g_variant_unref0 (_result_);
		return result;
	}
	_tmp6_ = _result_;
	_tmp7_ = _g_variant_ref0 ((GVariant*) _tmp6_);
	result = _tmp7_;
	_g_variant_unref0 (_result_);
	return result;
}

gboolean
registry_variant_dict_contains (RegistryVariantDict* self,
                                guint16 key)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->hash_table;
	result = g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) key));
	return result;
}

void
registry_variant_dict_insert_value (RegistryVariantDict* self,
                                    guint16 key,
                                    GVariant* variant)
{
	GHashTable* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = self->priv->hash_table;
	_tmp1_ = _g_variant_ref0 (variant);
	g_hash_table_insert (_tmp0_, (gpointer) ((guintptr) key), _tmp1_);
}

gboolean
registry_variant_dict_remove (RegistryVariantDict* self,
                              guint16 key)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->hash_table;
	result = g_hash_table_remove (_tmp0_, (gpointer) ((guintptr) key));
	return result;
}

void
registry_variant_dict_clear (RegistryVariantDict* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hash_table;
	g_hash_table_remove_all (_tmp0_);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		RegistryVariantDict* self;
		self = _data18_->self;
		_g_variant_builder_unref0 (_data18_->builder);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
__lambda32_ (Block18Data* _data18_,
             guint16 key,
             GVariant* variant)
{
	RegistryVariantDict* self;
	self = _data18_->self;
	g_return_if_fail (variant != NULL);
	g_variant_builder_add (_data18_->builder, "{qv}", key, variant, NULL);
}

static void
___lambda32__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda32_ (self, (guint16) ((guintptr) key), (GVariant*) value);
}

GVariant*
registry_variant_dict_end (RegistryVariantDict* self)
{
	Block18Data* _data18_;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GHashTable* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = g_variant_type_new ("a{qv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	_data18_->builder = _tmp3_;
	_tmp4_ = self->priv->hash_table;
	g_hash_table_foreach (_tmp4_, ___lambda32__gh_func, _data18_);
	registry_variant_dict_clear (self);
	_tmp5_ = g_variant_builder_end (_data18_->builder);
	g_variant_ref_sink (_tmp5_);
	result = _tmp5_;
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return result;
}

static void
registry_variant_dict_class_init (RegistryVariantDictClass * klass,
                                  gpointer klass_data)
{
	registry_variant_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RegistryVariantDict_private_offset);
	G_OBJECT_CLASS (klass)->finalize = registry_variant_dict_finalize;
}

static void
registry_variant_dict_instance_init (RegistryVariantDict * self,
                                     gpointer klass)
{
	GHashTable* _tmp0_;
	self->priv = registry_variant_dict_get_instance_private (self);
	_tmp0_ = g_hash_table_new_full (__registry_variant_dict_hash_table_lambda30__ghash_func, __registry_variant_dict_hash_table_lambda31__gequal_func, NULL, _g_variant_unref0_);
	self->priv->hash_table = _tmp0_;
}

static void
registry_variant_dict_finalize (GObject * obj)
{
	RegistryVariantDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict);
	_g_hash_table_unref0 (self->priv->hash_table);
	G_OBJECT_CLASS (registry_variant_dict_parent_class)->finalize (obj);
}

static GType
registry_variant_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RegistryVariantDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) registry_variant_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RegistryVariantDict), 0, (GInstanceInitFunc) registry_variant_dict_instance_init, NULL };
	GType registry_variant_dict_type_id;
	registry_variant_dict_type_id = g_type_register_static (G_TYPE_OBJECT, "RegistryVariantDict", &g_define_type_info, 0);
	RegistryVariantDict_private_offset = g_type_add_instance_private (registry_variant_dict_type_id, sizeof (RegistryVariantDictPrivate));
	return registry_variant_dict_type_id;
}

GType
registry_variant_dict_get_type (void)
{
	static volatile gsize registry_variant_dict_type_id__once = 0;
	if (g_once_init_enter (&registry_variant_dict_type_id__once)) {
		GType registry_variant_dict_type_id;
		registry_variant_dict_type_id = registry_variant_dict_get_type_once ();
		g_once_init_leave (&registry_variant_dict_type_id__once, registry_variant_dict_type_id);
	}
	return registry_variant_dict_type_id__once;
}

inline gboolean
model_utils_is_undefined_context_id (guint16 context_id)
{
	gboolean result;
	result = context_id == MODEL_UTILS_undefined_context_id;
	return result;
}

inline gboolean
model_utils_is_folder_context_id (guint16 context_id)
{
	gboolean result;
	result = context_id == MODEL_UTILS_folder_context_id;
	return result;
}

inline gboolean
model_utils_is_dconf_context_id (guint16 context_id)
{
	gboolean result;
	result = context_id == MODEL_UTILS_dconf_context_id;
	return result;
}

inline gboolean
model_utils_is_key_path (const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	result = !g_str_has_suffix (path, "/");
	return result;
}

inline gboolean
model_utils_is_folder_path (const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	result = g_str_has_suffix (path, "/");
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
model_utils_get_parent_path (const gchar* path)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= 1) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("/");
		result = _tmp2_;
		return result;
	}
	if (model_utils_is_key_path (path)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (path);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = string_slice (path, (glong) 0, (glong) -1);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	_tmp6_ = model_utils_get_base_path (_tmp3_);
	result = _tmp6_;
	_g_free0 (_tmp3_);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
model_utils_get_base_path (const gchar* path)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= 1) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("/");
		result = _tmp2_;
		return result;
	}
	_tmp3_ = string_slice (path, (glong) 0, (glong) (string_last_index_of_char (path, (gunichar) '/', 0) + 1));
	result = _tmp3_;
	return result;
}

gchar*
model_utils_get_name_or_empty (const gchar* path)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_slice (path, (glong) (string_last_index_of_char (path, (gunichar) '/', 0) + 1), (glong) _tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
model_utils_get_name (const gchar* path)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* tmp = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= 1) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("/");
		result = _tmp2_;
		return result;
	}
	if (model_utils_is_key_path (path)) {
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = strlen (path);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_slice (path, (glong) (string_last_index_of_char (path, (gunichar) '/', 0) + 1), (glong) _tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = string_slice (path, (glong) 0, (glong) -1);
	tmp = _tmp6_;
	_tmp7_ = tmp;
	_tmp8_ = tmp;
	_tmp9_ = tmp;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp7_, (glong) (string_last_index_of_char (_tmp8_, (gunichar) '/', 0) + 1), (glong) _tmp11_);
	result = _tmp12_;
	_g_free0 (tmp);
	return result;
}

inline gchar*
model_utils_recreate_full_name (const gchar* base_path,
                                const gchar* name,
                                gboolean is_folder)
{
	gchar* result;
	g_return_val_if_fail (base_path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (is_folder) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_strconcat (base_path, name, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat (_tmp1_, "/", NULL);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strconcat (base_path, name, NULL);
		result = _tmp4_;
		return result;
	}
}

gchar*
model_utils_key_to_short_description (const gchar* type)
{
	gchar* translation = NULL;
	gchar* non_capitalized_untranslated_short_description = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* capitalized_untranslated_short_description = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (type != NULL, NULL);
	model_utils_get_type_non_capitalized_short_description (type, &_tmp0_, &_tmp1_);
	_g_free0 (non_capitalized_untranslated_short_description);
	non_capitalized_untranslated_short_description = _tmp0_;
	_g_free0 (translation);
	translation = _tmp1_;
	_tmp2_ = translation;
	_tmp3_ = non_capitalized_untranslated_short_description;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		result = translation;
		_g_free0 (non_capitalized_untranslated_short_description);
		return result;
	}
	model_utils_get_type_capitalized_short_description (type, &_tmp4_, &_tmp5_);
	_g_free0 (capitalized_untranslated_short_description);
	capitalized_untranslated_short_description = _tmp4_;
	_g_free0 (translation);
	translation = _tmp5_;
	_tmp6_ = translation;
	_tmp7_ = capitalized_untranslated_short_description;
	if (g_strcmp0 (_tmp6_, _tmp7_) != 0) {
		result = translation;
		_g_free0 (capitalized_untranslated_short_description);
		_g_free0 (non_capitalized_untranslated_short_description);
		return result;
	}
	_tmp8_ = non_capitalized_untranslated_short_description;
	if (g_strcmp0 (_tmp8_, MODEL_UTILS__garbage_) != 0) {
		result = non_capitalized_untranslated_short_description;
		_g_free0 (capitalized_untranslated_short_description);
		_g_free0 (translation);
		return result;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = capitalized_untranslated_short_description;
		if (g_strcmp0 (_tmp9_, MODEL_UTILS__garbage_) != 0) {
			g_assert_not_reached ();
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup (type);
			result = _tmp10_;
			_g_free0 (capitalized_untranslated_short_description);
			_g_free0 (non_capitalized_untranslated_short_description);
			_g_free0 (translation);
			return result;
		}
	}
}

gchar*
model_utils_key_to_long_description (const gchar* type)
{
	gchar* translation = NULL;
	gchar* untranslated_long_description = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* capitalized_untranslated_short_description = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* non_capitalized_untranslated_short_description = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (type != NULL, NULL);
	model_utils_get_type_capitalized_long_description (type, &_tmp0_, &_tmp1_);
	_g_free0 (untranslated_long_description);
	untranslated_long_description = _tmp0_;
	_g_free0 (translation);
	translation = _tmp1_;
	_tmp2_ = translation;
	_tmp3_ = untranslated_long_description;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		result = translation;
		_g_free0 (untranslated_long_description);
		return result;
	}
	model_utils_get_type_capitalized_short_description (type, &_tmp4_, &_tmp5_);
	_g_free0 (capitalized_untranslated_short_description);
	capitalized_untranslated_short_description = _tmp4_;
	_g_free0 (translation);
	translation = _tmp5_;
	_tmp6_ = translation;
	_tmp7_ = capitalized_untranslated_short_description;
	if (g_strcmp0 (_tmp6_, _tmp7_) != 0) {
		result = translation;
		_g_free0 (capitalized_untranslated_short_description);
		_g_free0 (untranslated_long_description);
		return result;
	}
	model_utils_get_type_non_capitalized_short_description (type, &_tmp8_, &_tmp9_);
	_g_free0 (non_capitalized_untranslated_short_description);
	non_capitalized_untranslated_short_description = _tmp8_;
	_g_free0 (translation);
	translation = _tmp9_;
	_tmp10_ = translation;
	_tmp11_ = non_capitalized_untranslated_short_description;
	if (g_strcmp0 (_tmp10_, _tmp11_) != 0) {
		result = translation;
		_g_free0 (non_capitalized_untranslated_short_description);
		_g_free0 (capitalized_untranslated_short_description);
		_g_free0 (untranslated_long_description);
		return result;
	}
	_tmp12_ = untranslated_long_description;
	if (g_strcmp0 (_tmp12_, MODEL_UTILS__garbage_) != 0) {
		result = untranslated_long_description;
		_g_free0 (non_capitalized_untranslated_short_description);
		_g_free0 (capitalized_untranslated_short_description);
		_g_free0 (translation);
		return result;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = capitalized_untranslated_short_description;
		if (g_strcmp0 (_tmp13_, MODEL_UTILS__garbage_) != 0) {
			result = capitalized_untranslated_short_description;
			_g_free0 (non_capitalized_untranslated_short_description);
			_g_free0 (untranslated_long_description);
			_g_free0 (translation);
			return result;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = non_capitalized_untranslated_short_description;
			if (g_strcmp0 (_tmp14_, MODEL_UTILS__garbage_) != 0) {
				g_assert_not_reached ();
			} else {
				gchar* _tmp15_;
				_tmp15_ = g_strdup (type);
				result = _tmp15_;
				_g_free0 (non_capitalized_untranslated_short_description);
				_g_free0 (capitalized_untranslated_short_description);
				_g_free0 (untranslated_long_description);
				_g_free0 (translation);
				return result;
			}
		}
	}
}

void
model_utils_get_type_capitalized_long_description (const gchar* type,
                                                   gchar** untranslated_description,
                                                   gchar** translated_description)
{
	gchar* _vala_untranslated_description = NULL;
	gchar* _vala_translated_description = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("n")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup ("Signed 16-bit integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp3_;
				_tmp4_ = g_strdup (MODEL_UTILS__desc_N_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp4_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("q")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup ("Unsigned 16-bit integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp5_;
				_tmp6_ = g_strdup (MODEL_UTILS__desc_Q_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp6_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("Signed 32-bit integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp7_;
				_tmp8_ = g_strdup (MODEL_UTILS__desc_I_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp8_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("u")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup ("Unsigned 32-bit integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp9_;
				_tmp10_ = g_strdup (MODEL_UTILS__desc_U_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp10_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("x")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_strdup ("Signed 64-bit integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp11_;
				_tmp12_ = g_strdup (MODEL_UTILS__desc_X_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp12_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("t")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strdup ("Unsigned 64-bit integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp13_;
				_tmp14_ = g_strdup (MODEL_UTILS__desc_T_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp14_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup (MODEL_UTILS__garbage_);
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp15_;
				_tmp16_ = g_strdup (MODEL_UTILS__garbage_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp16_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	}
}

void
model_utils_get_type_capitalized_short_description (const gchar* type,
                                                    gchar** untranslated_description,
                                                    gchar** translated_description)
{
	gchar* _vala_untranslated_description = NULL;
	gchar* _vala_translated_description = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	static GQuark _tmp1_label18 = 0;
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup ("Boolean");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp3_;
				_tmp4_ = g_strdup (MODEL_UTILS__B_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp4_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("s")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup ("String");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp5_;
				_tmp6_ = g_strdup (MODEL_UTILS__S_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp6_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("as")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("String array");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp7_;
				_tmp8_ = g_strdup (MODEL_UTILS__As_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp8_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("<enum>")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup ("Enumeration");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp9_;
				_tmp10_ = g_strdup (MODEL_UTILS__Enum_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp10_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("<flags>")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_strdup ("Flags");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp11_;
				_tmp12_ = g_strdup (MODEL_UTILS__Flags_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp12_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strdup ("Double");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp13_;
				_tmp14_ = g_strdup (MODEL_UTILS__D_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp14_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("h")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup (C_ ("capitalized", "D-Bus handle type"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp15_;
				_tmp16_ = g_strdup ("D-Bus handle type");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp16_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("o")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = g_strdup (C_ ("capitalized", "D-Bus object path"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp17_;
				_tmp18_ = g_strdup ("D-Bus object path");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp18_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("ao")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = g_strdup (C_ ("capitalized", "D-Bus object path array"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp19_;
				_tmp20_ = g_strdup ("D-Bus object path array");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp20_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("g")))) {
		switch (0) {
			default:
			{
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp21_ = g_strdup (C_ ("capitalized", "D-Bus signature"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp21_;
				_tmp22_ = g_strdup ("D-Bus signature");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp22_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (((((((_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("y")))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("n"))))) || (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("q"))))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("i"))))) || (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("u"))))) || (_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("x"))))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("t"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp23_ = g_strdup ("Integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp23_;
				_tmp24_ = g_strdup (MODEL_UTILS__Integer_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp24_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("v")))) {
		switch (0) {
			default:
			{
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = g_strdup ("Variant");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp25_;
				_tmp26_ = g_strdup (MODEL_UTILS__V_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp26_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("()")))) {
		switch (0) {
			default:
			{
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp27_ = g_strdup ("Empty tuple");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp27_;
				_tmp28_ = g_strdup (MODEL_UTILS__Empty_tuple_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp28_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp29_ = g_strdup (MODEL_UTILS__garbage_);
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp29_;
				_tmp30_ = g_strdup (MODEL_UTILS__garbage_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp30_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	}
}

void
model_utils_get_type_non_capitalized_short_description (const gchar* type,
                                                        gchar** untranslated_description,
                                                        gchar** translated_description)
{
	gchar* _vala_untranslated_description = NULL;
	gchar* _vala_translated_description = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	static GQuark _tmp1_label18 = 0;
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup ("boolean");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp3_;
				_tmp4_ = g_strdup (MODEL_UTILS__b_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp4_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("s")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup ("string");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp5_;
				_tmp6_ = g_strdup (MODEL_UTILS__s_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp6_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("as")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("string array");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp7_;
				_tmp8_ = g_strdup (MODEL_UTILS__as_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp8_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("<enum>")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup ("enumeration");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp9_;
				_tmp10_ = g_strdup (MODEL_UTILS__enum_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp10_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("<flags>")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_strdup ("flags");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp11_;
				_tmp12_ = g_strdup (MODEL_UTILS__flags_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp12_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strdup ("double");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp13_;
				_tmp14_ = g_strdup (MODEL_UTILS__d_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp14_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("h")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup (C_ ("non-capitalized", "D-Bus handle type"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp15_;
				_tmp16_ = g_strdup ("D-Bus handle type");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp16_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("o")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = g_strdup (C_ ("non-capitalized", "D-Bus object path"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp17_;
				_tmp18_ = g_strdup ("D-Bus object path");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp18_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("ao")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = g_strdup (C_ ("non-capitalized", "D-Bus object path array"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp19_;
				_tmp20_ = g_strdup ("D-Bus object path array");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp20_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("g")))) {
		switch (0) {
			default:
			{
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp21_ = g_strdup (C_ ("non-capitalized", "D-Bus signature"));
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp21_;
				_tmp22_ = g_strdup ("D-Bus signature");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp22_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (((((((_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("y")))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("n"))))) || (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("q"))))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("i"))))) || (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("u"))))) || (_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("x"))))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("t"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp23_ = g_strdup ("integer");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp23_;
				_tmp24_ = g_strdup (MODEL_UTILS__integer_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp24_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("v")))) {
		switch (0) {
			default:
			{
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = g_strdup ("variant");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp25_;
				_tmp26_ = g_strdup (MODEL_UTILS__v_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp26_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("()")))) {
		switch (0) {
			default:
			{
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp27_ = g_strdup ("empty tuple");
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp27_;
				_tmp28_ = g_strdup (MODEL_UTILS__empty_tuple_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp28_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp29_ = g_strdup (MODEL_UTILS__garbage_);
				_g_free0 (_vala_untranslated_description);
				_vala_untranslated_description = _tmp29_;
				_tmp30_ = g_strdup (MODEL_UTILS__garbage_);
				_g_free0 (_vala_translated_description);
				_vala_translated_description = _tmp30_;
				if (untranslated_description) {
					*untranslated_description = _vala_untranslated_description;
				} else {
					_g_free0 (_vala_untranslated_description);
				}
				if (translated_description) {
					*translated_description = _vala_translated_description;
				} else {
					_g_free0 (_vala_translated_description);
				}
				return;
			}
		}
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

