/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.xy.synchronous;

import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartItemChange;
import org.graalvm.visualvm.lib.charts.ItemsModel;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;

public class SynchronousXYItemsModel
extends ItemsModel.Abstract {
    private final ArrayList<SynchronousXYItem> items = new ArrayList();
    private final Timeline timeline;

    public SynchronousXYItemsModel(Timeline timeline) {
        this.timeline = timeline;
    }

    public SynchronousXYItemsModel(Timeline timeline, SynchronousXYItem[] items) {
        this(timeline);
        if (items == null) {
            throw new IllegalArgumentException("Items cannot be null");
        }
        if (items.length == 0) {
            throw new IllegalArgumentException("Items cannot be empty");
        }
        this.addItems(items);
    }

    public void addItems(SynchronousXYItem[] addedItems) {
        for (int i = 0; i < addedItems.length; ++i) {
            addedItems[i].setTimeline(this.timeline);
            this.items.add(addedItems[i]);
        }
        this.fireItemsAdded(Arrays.asList((ChartItem[])addedItems));
        if (this.timeline.getTimestampsCount() > 0) {
            this.valuesAdded();
        }
    }

    public void removeItems(SynchronousXYItem[] removedItems) {
        for (SynchronousXYItem item : removedItems) {
            this.items.remove(item);
        }
        this.fireItemsRemoved(Arrays.asList((ChartItem[])removedItems));
    }

    public final void valuesAdded() {
        long previousTimestamp;
        ArrayList<ChartItemChange> itemChanges = new ArrayList<ChartItemChange>(this.items.size());
        for (SynchronousXYItem item : this.items) {
            itemChanges.add(item.valuesChanged());
        }
        this.fireItemsChanged(itemChanges);
        int valueIndex = this.timeline.getTimestampsCount() - 1;
        long timestamp = this.timeline.getTimestamp(valueIndex);
        long l = previousTimestamp = valueIndex == 0 ? -1L : this.timeline.getTimestamp(valueIndex - 1);
        if (previousTimestamp != -1L && previousTimestamp >= timestamp) {
            System.err.println("WARNING [" + SynchronousXYItemsModel.class.getName() + "]: ProfilerXYItemsModel: new timestamp " + timestamp + " not greater than previous " + previousTimestamp + ", skipping the values.");
        }
    }

    public final void valuesReset() {
        ArrayList<ChartItemChange> itemChanges = new ArrayList<ChartItemChange>(this.items.size());
        for (SynchronousXYItem item : this.items) {
            itemChanges.add(item.valuesChanged());
        }
        this.fireItemsChanged(itemChanges);
    }

    public final Timeline getTimeline() {
        return this.timeline;
    }

    @Override
    public final int getItemsCount() {
        return this.items.size();
    }

    @Override
    public final SynchronousXYItem getItem(int index) {
        return this.items.get(index);
    }
}

