export declare type BaseType = {
    size: () => number;
    empty: () => boolean;
    clear: () => void;
};
export declare type ContainerType<T> = {
    front: () => T | undefined;
    back: () => T | undefined;
    forEach: (callback: (element: T, index: number) => void) => void;
    find: (element: T) => boolean;
    getElementByPos: (pos: number) => T;
    eraseElementByPos: (pos: number) => void;
    eraseElementByValue: (value: T) => void;
    [Symbol.iterator]: () => Generator<T, void, undefined>;
} & BaseType;
export declare type SequentialContainerType<T> = {
    forEach: (callback: (element: T, index: number) => void) => void;
    pushBack: (element: T) => void;
    popBack: () => void;
    setElementByPos: (pos: number, element: T) => void;
    insert: (pos: number, element: T, num?: number) => void;
    reverse: () => void;
    unique: () => void;
    sort: (cmp?: (x: T, y: T) => number) => void;
} & ContainerType<T>;
export declare type Pair<T, K> = {
    key: T;
    value: K;
};
