"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPlugin = NotificationsPlugin;

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function NotificationsPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.notifications = components.clientAction.namespaceFactory();
  const notifications = Client.prototype.notifications.prototype;
  notifications.getConfigs = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    method: 'GET'
  });
  notifications.createConfig = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    method: 'POST',
    needBody: true
  });
  notifications.getConfigById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.CONFIGS}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.deleteConfigs = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    params: {
      config_id_list: {
        type: 'list',
        required: true
      }
    },
    method: 'DELETE'
  });
  notifications.updateConfigById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.CONFIGS}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });
  notifications.getEventById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.EVENTS}/<%=eventId%>`,
      req: {
        eventId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.sendTestMessage = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.TEST_MESSAGE}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.getServerFeatures = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.FEATURES
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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