"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventRoutes = eventRoutes;

var _configSchema = require("@osd/config-schema");

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function eventRoutes(router) {
  router.get({
    path: `${_common.NODE_API.GET_EVENT}/{eventId}`,
    validate: {
      params: _configSchema.schema.object({
        eventId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.notificationsContext.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_common.NODE_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: {
      params: _configSchema.schema.object({
        configId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.notificationsContext.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.sendTestMessage', {
        configId: request.params.configId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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