// generated by Fast Light User Interface Designer (fluid) version 1.0308

#include "EffUI.h"
// EffUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2016-2022, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original


#include "Misc/NumericFuncs.h"
    using func::power;
using std::to_string;

EQGraph::EQGraph(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  eff = NULL;
          maxdB = 30;
}

void EQGraph::init(EffectMgr *eff_) {
  synth = eff_->getSynthEngine();
  eff = eff_;
          oldx = -1;
          khzval = -1;
}

void EQGraph::draw_freq_line(float freq, int type) {
  fl_color(FL_GRAY);
          float freqx = getfreqpos(freq);
  
          if (type == 0)
          {
              if (active_r())
                  fl_color(FL_WHITE);
              else
                  fl_color(205, 205, 205);
          }
  
          if (freqx > 0.0 && freqx < 1.0)
          fl_line(x() + (int) (freqx * w()), y(),
              x() + (int) (freqx * w()), y() + h());
}

void EQGraph::draw() {
  //
          int ox = x(), oy = y(), lx = w(), ly = h(), i, iy, oiy;
          float freqx;
          fl_line_style(0, int(1 * lx / 190.0f));
          if (active_r())
              fl_color(0, 70, 150);
          else
              fl_color(80, 120, 160);
          fl_rectf(ox, oy, lx, ly);
  
          // draw the lines
          fl_color(FL_GRAY);
          fl_line(ox + 2, oy + ly / 2, ox + lx - 2, oy + ly / 2);
  
          freqx = getfreqpos(1000.0);
          if (freqx > 0.0 && freqx < 1.0)
              fl_line(ox + (int) (freqx * lx), oy,
                      ox + (int) (freqx * lx), oy + ly);
  
          for (i = 1; i < 10; ++i)
          {
              if (i == 1)
              {
                  draw_freq_line(i * 100.0,0);
                  draw_freq_line(i * 1000.0,0);
              }
              else
                  if (i == 5)
                  {
                      draw_freq_line(i * 10.0, 1);
                      draw_freq_line(i * 100.0, 1);
                      draw_freq_line(i * 1000.0, 1);
                  }
                  else
                  {
                      draw_freq_line(i * 10.0, 1);
                      draw_freq_line(i * 100.0, 1);
                      draw_freq_line(i * 1000.0, 1);
                  }
          }
          draw_freq_line(10000.0, 0);
          draw_freq_line(20000.0, 1);
  
          int GY = 6;
          if (ly < GY * 3)
              GY = -1;
          for (i = 1; i < GY; ++i)
          {
              int tmp = (int)(ly / (float)GY * i);
              fl_line(ox + 2, oy + tmp, ox + lx - 2, oy + tmp);
          }
  
          fl_line_style(0, int(2 * lx / 190.0f));
          // draw the frequency response
          if (active_r())
              fl_color(FL_YELLOW);
          else
              fl_color(200, 200, 80);
          oiy = getresponse(ly, getfreqx(0.0));
          float half_samplerate_f = synth->samplerate_f * 0.5f;
          int oix = 0;
          for (i = 1; i < lx; ++i)
          {
              float frq = getfreqx(i / (float)lx);
              if (frq > half_samplerate_f)
                  break;
              iy = getresponse(ly, frq);
              if (oiy >= 0 && oiy < ly && iy >= 0 && iy < ly)
                  fl_line(ox + oix, oy + ly - oiy, ox + i, oy + ly - oiy);
              oix = i;
              oiy = iy;
          }
          fl_line_style(0, 1);
}

int EQGraph::getresponse(int maxy,float freq) {
  float dbresp = eff->getEQfreqresponse(freq);
          int idbresp = (int) ((dbresp / maxdB + 1.0) * maxy / 2.0);
  
          // fprintf(stderr,"%.5f\n",(dbresp/maxdB+1.0)*maxy/2.0);
  
          return idbresp;
}

float EQGraph::getfreqx(float x) {
  if (x > 1.0)
              x = 1.0;
          return 20.0 * power<1000>(x);
}

float EQGraph::getfreqpos(float freq) {
  if (freq < 0.00001)
              freq = 0.00001;
          return logf(freq / 20.0) / logf(1000.0);
}

void EffUI::cb_revp_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp_i(o,v);
}

void EffUI::cb_revp10_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 10, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp10(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp10_i(o,v);
}

void EffUI::cb_revp0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp0_i(o,v);
}

void EffUI::cb_revp1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp1_i(o,v);
}

void EffUI::cb_revp2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp2_i(o,v);
}

void EffUI::cb_revp3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp3_i(o,v);
}

void EffUI::cb_revp4_i(WidgetPDial* o, void*) {
  //
        int butt = 4;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp4(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp4_i(o,v);
}

void EffUI::cb_revp12_i(WidgetPDial* o, void*) {
  //
        int butt = 12;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp12(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp12_i(o,v);
}

void EffUI::cb_revp6_i(WidgetPDial* o, void*) {
  //
        int butt = 6;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp6_i(o,v);
}

void EffUI::cb_revp7_i(WidgetPDial* o, void*) {
  //
        int butt = 7;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp7_i(o,v);
}

void EffUI::cb_revp8_i(WidgetPDial* o, void*) {
  //
        int butt = 8;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp8(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp8_i(o,v);
}

void EffUI::cb_revp9_i(WidgetPDial* o, void*) {
  //
        int butt = 9;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp9_i(o,v);
}

void EffUI::cb_revp11_i(WidgetPDial* o, void*) {
  //
        int butt = 11;
        send_data(0, butt, o->value(), (EFFECT::type::reverb), TOPLEVEL::type::Integer);
}
void EffUI::cb_revp11(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp11_i(o,v);
}

void EffUI::cb_echop_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop_i(o,v);
}

void EffUI::cb_echop0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop0_i(o,v);
}

void EffUI::cb_echop1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop1_i(o,v);
}

void EffUI::cb_echop2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop2_i(o,v);
}

void EffUI::cb_echop3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop3_i(o,v);
}

void EffUI::cb_echop4_i(WidgetPDial* o, void*) {
  //
        int butt = 4;
        send_data(0, butt, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop4(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop4_i(o,v);
}

void EffUI::cb_echop5_i(WidgetPDial* o, void*) {
  //
        int butt = 5;
        send_data(0, butt, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop5_i(o,v);
}

void EffUI::cb_echop6_i(WidgetPDial* o, void*) {
  //
        int butt = 6;
        send_data(0, butt, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop6_i(o,v);
}

void EffUI::cb_echop17_i(Fl_Check_Button* o, void*) {
  //
        send_data(0, EFFECT::control::bpm, o->value(), (EFFECT::type::echo), TOPLEVEL::type::Integer);
}
void EffUI::cb_echop17(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop17_i(o,v);
}

void EffUI::cb_chorusp_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp_i(o,v);
}

void EffUI::cb_chorusp4_i(Fl_Choice* o, void*) {
  //
        send_data(0, 4, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp4_i(o,v);
}

void EffUI::cb_chorusp0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp0_i(o,v);
}

void EffUI::cb_chorusp1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp1_i(o,v);
}

void EffUI::cb_chorusp2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp2_i(o,v);
}

void EffUI::cb_chorusp18_i(WidgetPDial* o, void*) {
  //
        send_data(0, EFFECT::control::bpmStart, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp18(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp18_i(o,v);
}

void EffUI::cb_chorusp3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp3_i(o,v);
}

void EffUI::cb_chorusp5_i(WidgetPDial* o, void*) {
  //
        int butt = 5;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp5_i(o,v);
}

void EffUI::cb_chorusp6_i(WidgetPDial* o, void*) {
  //
        int butt = 6;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp6_i(o,v);
}

void EffUI::cb_chorusp7_i(WidgetPDial* o, void*) {
  //
        int butt = 7;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp7_i(o,v);
}

void EffUI::cb_chorusp8_i(WidgetPDial* o, void*) {
  //
        int butt =8;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp8(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp8_i(o,v);
}

void EffUI::cb_chorusp9_i(WidgetPDial* o, void*) {
  //
        int butt = 9;
        send_data(0, butt, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp9_i(o,v);
}

void EffUI::cb_chorusflange_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 10, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusflange(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusflange_i(o,v);
}

void EffUI::cb_chorusp11_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 11, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp11(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp11_i(o,v);
}

void EffUI::cb_chorusp17_i(Fl_Check_Button* o, void*) {
  //
        send_data(0, EFFECT::control::bpm, o->value(), (EFFECT::type::chorus), TOPLEVEL::type::Integer);
}
void EffUI::cb_chorusp17(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp17_i(o,v);
}

void EffUI::cb_phaserp_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp_i(o,v);
}

void EffUI::cb_phaserp4_i(Fl_Choice* o, void*) {
  //
        send_data(0, 4, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp4_i(o,v);
}

void EffUI::cb_phaserp0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp0_i(o,v);
}

void EffUI::cb_phaserp1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp1_i(o,v);
}

void EffUI::cb_phaserp2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp2_i(o,v);
}

void EffUI::cb_phaserp18_i(WidgetPDial* o, void*) {
  //
        send_data(0, EFFECT::control::bpmStart, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp18(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp18_i(o,v);
}

void EffUI::cb_phaserp3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp3_i(o,v);
}

void EffUI::cb_phaserp17_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, EFFECT::control::bpm, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp17(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp17_i(o,v);
}

void EffUI::cb_phaserp5_i(WidgetPDial* o, void*) {
  //
        int butt = 5;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp5_i(o,v);
}

void EffUI::cb_phaserp6_i(WidgetPDial* o, void*) {
  //
        int butt = 6;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp6_i(o,v);
}

void EffUI::cb_phaserp7_i(WidgetPDial* o, void*) {
  //
        int butt = 7;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp7_i(o,v);
}

void EffUI::cb_phaserp8_i(Fl_Counter* o, void*) {
  //
        send_data(0, 8, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp8(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp8_i(o,v);
}

void EffUI::cb_phaserp9_i(WidgetPDial* o, void*) {
  //
        int butt = 9;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp9_i(o,v);
}

void EffUI::cb_phaserp10_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 10, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp10(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp10_i(o,v);
}

void EffUI::cb_phaserp11_i(WidgetPDial* o, void*) {
  //
        int butt = 11;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp11(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp11_i(o,v);
}

void EffUI::cb_phaserp12_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 12, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp12(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp12_i(o,v);
}

void EffUI::cb_phaserp13_i(WidgetPDial* o, void*) {
  //
        int butt = 13;
        send_data(0, butt, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp13(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp13_i(o,v);
}

void EffUI::cb_phaserp14_i(Fl_Check_Button2* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 14, o->value(), (EFFECT::type::phaser), TOPLEVEL::type::Integer);
}
void EffUI::cb_phaserp14(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp14_i(o,v);
}

void EffUI::cb_awp_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp_i(o,v);
}

void EffUI::cb_awp4_i(Fl_Choice* o, void*) {
  //
        send_data(0, 4, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp4_i(o,v);
}

void EffUI::cb_awp0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp0_i(o,v);
}

void EffUI::cb_awp1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp1_i(o,v);
}

void EffUI::cb_awp2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp2_i(o,v);
}

void EffUI::cb_awp3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp3_i(o,v);
}

void EffUI::cb_awp18_i(WidgetPDial* o, void*) {
  //
        send_data(0, EFFECT::control::bpmStart, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp18(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp18_i(o,v);
}

void EffUI::cb_awp5_i(WidgetPDial* o, void*) {
  //
        int butt = 5;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp5_i(o,v);
}

void EffUI::cb_awp6_i(WidgetPDial* o, void*) {
  //
        int butt = 6;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp6_i(o,v);
}

void EffUI::cb_awp7_i(WidgetPDial* o, void*) {
  //
        int butt = 7;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp7_i(o,v);
}

void EffUI::cb_awp9_i(WidgetPDial* o, void*) {
  //
        int butt = 9;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp9_i(o,v);
}

void EffUI::cb_awp10_i(WidgetPDial* o, void*) {
  //
        int butt = 10;
        send_data(0, butt, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp10(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp10_i(o,v);
}

void EffUI::cb_awp8_i(Fl_Counter* o, void*) {
  //
        send_data(0, 8, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp8(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp8_i(o,v);
}

void EffUI::cb_awp17_i(Fl_Check_Button* o, void*) {
  //
        send_data(0, EFFECT::control::bpm, o->value(), (EFFECT::type::alienWah), TOPLEVEL::type::Integer);
}
void EffUI::cb_awp17(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp17_i(o,v);
}

void EffUI::cb_distp_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp_i(o,v);
}

void EffUI::cb_distp5_i(Fl_Choice* o, void*) {
  //
        send_data(0, 5, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp5(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp5_i(o,v);
}

void EffUI::cb_distp0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp0_i(o,v);
}

void EffUI::cb_distp1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp1_i(o,v);
}

void EffUI::cb_distp2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp2_i(o,v);
}

void EffUI::cb_distp3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp3_i(o,v);
}

void EffUI::cb_distp4_i(WidgetPDial* o, void*) {
  //
        int butt = 4;
        send_data(0, butt, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp4(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp4_i(o,v);
}

void EffUI::cb_distp7_i(WidgetPDial* o, void*) {
  //
        int butt = 7;
        send_data(0, butt, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp7_i(o,v);
}

void EffUI::cb_distp8_i(WidgetPDial* o, void*) {
  //
        int butt = 8;
        send_data(0, butt, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp8(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp8_i(o,v);
}

void EffUI::cb_distp6_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 6, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp6(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp6_i(o,v);
}

void EffUI::cb_distp9_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 9, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp9(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp9_i(o,v);
}

void EffUI::cb_distp10_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 10, o->value(), (EFFECT::type::distortion), TOPLEVEL::type::Integer);
}
void EffUI::cb_distp10(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp10_i(o,v);
}

void EffUI::cb_eqp0_i(WidgetPDial* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 0, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_eqp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_eqp0_i(o,v);
}

void EffUI::cb_bandcounter_i(Fl_Counter* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 1, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_bandcounter(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_bandcounter_i(o,v);
}

void EffUI::cb_freqdial_i(WidgetPDial* o, void*) {
  //;
          send_data(TOPLEVEL::action::forceUpdate, 11, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_freqdial(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_freqdial_i(o,v);
}

void EffUI::cb_gaindial_i(WidgetPDial* o, void*) {
  //
          send_data(TOPLEVEL::action::forceUpdate, 12, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_gaindial(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_gaindial_i(o,v);
}

void EffUI::cb_qdial_i(WidgetPDial* o, void*) {
  //
          send_data(TOPLEVEL::action::forceUpdate, 13, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_qdial(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_qdial_i(o,v);
}

void EffUI::cb_stagescounter_i(Fl_Counter* o, void*) {
  //
          send_data(TOPLEVEL::action::forceUpdate, 14, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_stagescounter(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_stagescounter_i(o,v);
}

void EffUI::cb_typechoice_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 10, o->value(), (EFFECT::type::eq), TOPLEVEL::type::Integer);
}
void EffUI::cb_typechoice(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_typechoice_i(o,v);
}

void EffUI::cb_dfp_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, 16, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp_i(o,v);
}

void EffUI::cb_dfp4_i(Fl_Choice* o, void*) {
  //
        send_data(0, 4, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp4_i(o,v);
}

void EffUI::cb_dfp0_i(WidgetPDial* o, void*) {
  //
        send_data(0, 0, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp0_i(o,v);
}

void EffUI::cb_dfp1_i(WidgetPDial* o, void*) {
  //
        int butt = 1;
        send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp1_i(o,v);
}

void EffUI::cb_dfp2_i(WidgetPDial* o, void*) {
  //
        int butt = 2;
        send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp2_i(o,v);
}

void EffUI::cb_dfp3_i(WidgetPDial* o, void*) {
  //
        int butt = 3;
        send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp3_i(o,v);
}

void EffUI::cb_dfp18_i(WidgetPDial* o, void*) {
  //
        send_data(0, EFFECT::control::bpmStart, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp18(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp18_i(o,v);
}

void EffUI::cb_dfp5_i(WidgetPDial* o, void*) {
  int butt = 5;
        send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp5_i(o,v);
}

void EffUI::cb_dfp6_i(WidgetPDial* o, void*) {
  int butt = 6;
        send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp6_i(o,v);
}

void EffUI::cb_filter_i(Fl_Button*, void*) {
  Showfilt();
}
void EffUI::cb_filter(Fl_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_filter_i(o,v);
}

void EffUI::cb_dfp7_i(WidgetPDial* o, void*) {
  int butt = 7;
          send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_dfp7_i(o,v);
}

void EffUI::cb_dfp9_i(WidgetPDial* o, void*) {
  int butt = 9;
          send_data(0, butt, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_dfp9_i(o,v);
}

void EffUI::cb_dfp8_i(Fl_Check_Button2* o, void*) {
  //
          send_data(0, 8, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp8(Fl_Check_Button2* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_dfp8_i(o,v);
}

void EffUI::cb_dfp17_i(Fl_Check_Button* o, void*) {
  //
        send_data(0, EFFECT::control::bpm, o->value(), (EFFECT::type::dynFilter), TOPLEVEL::type::Integer);
}
void EffUI::cb_dfp17(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp17_i(o,v);
}

void EffUI::cb_filterwindow_i(Fl_Double_Window*, void*) {
  //
    filterclose->do_callback();
}
void EffUI::cb_filterwindow(Fl_Double_Window* o, void* v) {
  ((EffUI*)(o->user_data()))->cb_filterwindow_i(o,v);
}

void EffUI::cb_filterclose_i(Fl_Button*, void*) {
  //
    saveWin(synth, filterwindow->w(), filterwindow->h(), filterwindow->x(), filterwindow->y(), false, "xFilter-dynamic " + to_string(npart));
    filterwindow->hide();
}
void EffUI::cb_filterclose(Fl_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_filterclose_i(o,v);
}

EffUI::EffUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  //
      eff = NULL;
      filterwindow = NULL;
      fwin_filterui = NULL;
      lastfiltW = 0;
}

EffUI::~EffUI() {
  //
          effnullwindow->hide();        // delete (effnullwindow);
          effreverbwindow->hide();        // delete (effreverbwindow);
          effechowindow->hide();          // delete (effechowindow);
          effchoruswindow->hide();        // delete (effchoruswindow);
          effphaserwindow->hide();        // delete (effphaserwindow);
          effalienwahwindow->hide();      // delete (effalienwahwindow);
          effdistorsionwindow->hide();    // delete (effdistorsionwindow);
          effeqwindow->hide();            // delete (effeqwindow);
          effdynamicfilterwindow->hide(); // delete (effdynamicfilterwindow);
  
          if (filterwindow != NULL)
          {
              if (filterwindow->visible())
                  saveWin(synth, filterwindow->w(), filterwindow->h(), filterwindow->x(), filterwindow->y(), true, "xFilter-dynamic " + to_string(npart));
              filterwindow->hide();
              delete(filterwindow);
          }
}

Fl_Group* EffUI::make_null_window() {
  { effnullwindow = new Fl_Group(0, 0, 380, 95);
    effnullwindow->box(FL_PLASTIC_THIN_UP_BOX);
    effnullwindow->color((Fl_Color)221);
    effnullwindow->selection_color(FL_BACKGROUND_COLOR);
    effnullwindow->labeltype(FL_NO_LABEL);
    effnullwindow->labelfont(0);
    effnullwindow->labelsize(14);
    effnullwindow->labelcolor(FL_FOREGROUND_COLOR);
    effnullwindow->user_data((void*)(this));
    effnullwindow->align(Fl_Align(FL_ALIGN_TOP));
    effnullwindow->when(FL_WHEN_RELEASE);
    { noeffect = new Fl_Text_Display(120, 35, 10, 20, "No Effects Applied");
      noeffect->box(FL_NO_BOX);
      noeffect->labelfont(1);
      noeffect->labelcolor((Fl_Color)37);
      noeffect->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* noeffect
    effnullwindow->end();
  } // Fl_Group* effnullwindow
  return effnullwindow;
}

Fl_Group* EffUI::make_reverb_window() {
  { effreverbwindow = new Fl_Group(0, 0, 380, 95);
    effreverbwindow->box(FL_PLASTIC_UP_BOX);
    effreverbwindow->color((Fl_Color)221);
    effreverbwindow->selection_color(FL_BACKGROUND_COLOR);
    effreverbwindow->labeltype(FL_NO_LABEL);
    effreverbwindow->labelfont(0);
    effreverbwindow->labelsize(12);
    effreverbwindow->labelcolor(FL_FOREGROUND_COLOR);
    effreverbwindow->user_data((void*)(this));
    effreverbwindow->align(Fl_Align(33));
    effreverbwindow->when(FL_WHEN_RELEASE);
    { revname = new Fl_Text_Display(10, 10, 0, 20, "Reverb ");
      revname->box(FL_NO_BOX);
      revname->labelfont(1);
      revname->labelsize(12);
      revname->labelcolor((Fl_Color)36);
      revname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* revname
    { Fl_Choice* o = revp = new Fl_Choice(115, 13, 90, 15, "Preset");
      revp->down_box(FL_BORDER_BOX);
      revp->color((Fl_Color)14);
      revp->selection_color(FL_FOREGROUND_COLOR);
      revp->labelsize(11);
      revp->textfont(1);
      revp->textsize(10);
      revp->textcolor(FL_BACKGROUND2_COLOR);
      revp->callback((Fl_Callback*)cb_revp);
      o->add("Cathedral 1");o->add("Cathedral 2");o->add("Cathedral 3");o->add("Hall 1");o->add("Hall 2");o->add("Room 1");o->add("Room 2");o->add("Basement");o->add("Tunnel");o->add("Echoed 1");o->add("Echoed 2");o->add("Very Long 1");o->add("Very Long 2");
    } // Fl_Choice* revp
    { Fl_Choice* o = revp10 = new Fl_Choice(240, 13, 75, 15, "Type");
      revp10->down_box(FL_BORDER_BOX);
      revp10->color((Fl_Color)14);
      revp10->labelsize(11);
      revp10->textfont(1);
      revp10->textsize(10);
      revp10->textcolor(FL_BACKGROUND2_COLOR);
      revp10->callback((Fl_Callback*)cb_revp10);
      o->add("Random");o->add("Freeverb");o->add("Bandwidth");
    } // Fl_Choice* revp10
    { WidgetPDial* o = revp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      revp0->tooltip("Effect volume");
      revp0->box(FL_ROUND_UP_BOX);
      revp0->color(FL_BACKGROUND_COLOR);
      revp0->selection_color(FL_INACTIVE_COLOR);
      revp0->labeltype(FL_NORMAL_LABEL);
      revp0->labelfont(0);
      revp0->labelsize(11);
      revp0->labelcolor(FL_FOREGROUND_COLOR);
      revp0->maximum(127);
      revp0->callback((Fl_Callback*)cb_revp0);
      revp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp0->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXReverbVol);
    } // WidgetPDial* revp0
    { WidgetPDial* o = revp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      revp1->box(FL_ROUND_UP_BOX);
      revp1->color(FL_BACKGROUND_COLOR);
      revp1->selection_color(FL_INACTIVE_COLOR);
      revp1->labeltype(FL_NORMAL_LABEL);
      revp1->labelfont(0);
      revp1->labelsize(11);
      revp1->labelcolor(FL_FOREGROUND_COLOR);
      revp1->maximum(127);
      revp1->callback((Fl_Callback*)cb_revp1);
      revp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp1->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PanningStd);
    } // WidgetPDial* revp1
    { WidgetPDial* o = revp2 = new WidgetPDial(80, 40, 30, 30, "Time");
      revp2->tooltip("Duration of effect");
      revp2->box(FL_ROUND_UP_BOX);
      revp2->color(FL_BACKGROUND_COLOR);
      revp2->selection_color(FL_INACTIVE_COLOR);
      revp2->labeltype(FL_NORMAL_LABEL);
      revp2->labelfont(0);
      revp2->labelsize(11);
      revp2->labelcolor(FL_FOREGROUND_COLOR);
      revp2->maximum(127);
      revp2->callback((Fl_Callback*)cb_revp2);
      revp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp2->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXReverbTime);
    } // WidgetPDial* revp2
    { WidgetPDial* o = revp3 = new WidgetPDial(120, 40, 30, 30, "I.del");
      revp3->tooltip("Initial delay");
      revp3->box(FL_ROUND_UP_BOX);
      revp3->color(FL_BACKGROUND_COLOR);
      revp3->selection_color(FL_INACTIVE_COLOR);
      revp3->labeltype(FL_NORMAL_LABEL);
      revp3->labelfont(0);
      revp3->labelsize(11);
      revp3->labelcolor(FL_FOREGROUND_COLOR);
      revp3->maximum(127);
      revp3->callback((Fl_Callback*)cb_revp3);
      revp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_FXReverbIDelay);
    } // WidgetPDial* revp3
    { WidgetPDial* o = revp4 = new WidgetPDial(155, 40, 30, 30, "I.delfb");
      revp4->tooltip("Initial delay feedback");
      revp4->box(FL_ROUND_UP_BOX);
      revp4->color(FL_BACKGROUND_COLOR);
      revp4->selection_color(FL_INACTIVE_COLOR);
      revp4->labeltype(FL_NORMAL_LABEL);
      revp4->labelfont(0);
      revp4->labelsize(11);
      revp4->labelcolor(FL_FOREGROUND_COLOR);
      revp4->maximum(127);
      revp4->callback((Fl_Callback*)cb_revp4);
      revp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp4->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent128);
    } // WidgetPDial* revp4
    { WidgetPDial* o = revp12 = new WidgetPDial(200, 40, 30, 30, "BW");
      revp12->box(FL_ROUND_UP_BOX);
      revp12->color(FL_BACKGROUND_COLOR);
      revp12->selection_color(FL_INACTIVE_COLOR);
      revp12->labeltype(FL_NORMAL_LABEL);
      revp12->labelfont(0);
      revp12->labelsize(11);
      revp12->labelcolor(FL_FOREGROUND_COLOR);
      revp12->maximum(127);
      revp12->callback((Fl_Callback*)cb_revp12);
      revp12->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp12->when(FL_WHEN_RELEASE);
      revp12->deactivate();
      if (eff->geteffectpar(10)==2) o->activate();
      o->setValueType(VC_FXReverbBandwidth);
    } // WidgetPDial* revp12
    { revp6 = new WidgetPDial(235, 40, 30, 30, "E/R");
      revp6->box(FL_ROUND_UP_BOX);
      revp6->color(FL_BACKGROUND_COLOR);
      revp6->selection_color(FL_INACTIVE_COLOR);
      revp6->labeltype(FL_NORMAL_LABEL);
      revp6->labelfont(0);
      revp6->labelsize(11);
      revp6->labelcolor(FL_FOREGROUND_COLOR);
      revp6->maximum(127);
      revp6->callback((Fl_Callback*)cb_revp6);
      revp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp6->when(FL_WHEN_CHANGED);
      revp6->deactivate();
    } // WidgetPDial* revp6
    { WidgetPDial* o = revp7 = new WidgetPDial(270, 40, 30, 30, "LPF");
      revp7->tooltip("Low pass filter");
      revp7->box(FL_ROUND_UP_BOX);
      revp7->color(FL_BACKGROUND_COLOR);
      revp7->selection_color(FL_INACTIVE_COLOR);
      revp7->labeltype(FL_NORMAL_LABEL);
      revp7->labelfont(0);
      revp7->labelsize(11);
      revp7->labelcolor(FL_FOREGROUND_COLOR);
      revp7->maximum(127);
      revp7->callback((Fl_Callback*)cb_revp7);
      revp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp7->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXReverbLowPass);
    } // WidgetPDial* revp7
    { WidgetPDial* o = revp8 = new WidgetPDial(305, 40, 30, 30, "HPF");
      revp8->tooltip("High pass filter");
      revp8->box(FL_ROUND_UP_BOX);
      revp8->color(FL_BACKGROUND_COLOR);
      revp8->selection_color(FL_INACTIVE_COLOR);
      revp8->labeltype(FL_NORMAL_LABEL);
      revp8->labelfont(0);
      revp8->labelsize(11);
      revp8->labelcolor(FL_FOREGROUND_COLOR);
      revp8->maximum(127);
      revp8->callback((Fl_Callback*)cb_revp8);
      revp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp8->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXReverbHighPass);
    } // WidgetPDial* revp8
    { WidgetPDial* o = revp9 = new WidgetPDial(340, 40, 30, 30, "Damp");
      revp9->tooltip("Dampening");
      revp9->box(FL_ROUND_UP_BOX);
      revp9->color(FL_BACKGROUND_COLOR);
      revp9->selection_color(FL_INACTIVE_COLOR);
      revp9->labeltype(FL_NORMAL_LABEL);
      revp9->labelfont(0);
      revp9->labelsize(11);
      revp9->labelcolor(FL_FOREGROUND_COLOR);
      revp9->minimum(64);
      revp9->maximum(127);
      revp9->step(1);
      revp9->callback((Fl_Callback*)cb_revp9);
      revp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp9->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent64_127);
    } // WidgetPDial* revp9
    { WidgetPDial* o = revp11 = new WidgetPDial(342, 8, 25, 25, "R.S.");
      revp11->tooltip("RoomSize");
      revp11->box(FL_ROUND_UP_BOX);
      revp11->color(FL_BACKGROUND_COLOR);
      revp11->selection_color(FL_INACTIVE_COLOR);
      revp11->labeltype(FL_NORMAL_LABEL);
      revp11->labelfont(0);
      revp11->labelsize(10);
      revp11->labelcolor(FL_FOREGROUND_COLOR);
      revp11->minimum(1);
      revp11->maximum(127);
      revp11->step(1);
      revp11->callback((Fl_Callback*)cb_revp11);
      revp11->align(Fl_Align(FL_ALIGN_LEFT));
      revp11->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* revp11
    effreverbwindow->end();
  } // Fl_Group* effreverbwindow
  return effreverbwindow;
}

Fl_Group* EffUI::make_echo_window() {
  { effechowindow = new Fl_Group(0, 0, 380, 95);
    effechowindow->box(FL_PLASTIC_UP_BOX);
    effechowindow->color((Fl_Color)221);
    effechowindow->selection_color(FL_BACKGROUND_COLOR);
    effechowindow->labeltype(FL_NO_LABEL);
    effechowindow->labelfont(1);
    effechowindow->labelsize(12);
    effechowindow->labelcolor(FL_FOREGROUND_COLOR);
    effechowindow->user_data((void*)(this));
    effechowindow->align(Fl_Align(FL_ALIGN_TOP));
    effechowindow->when(FL_WHEN_RELEASE);
    { echoname = new Fl_Text_Display(10, 10, 0, 20, "Echo");
      echoname->box(FL_NO_BOX);
      echoname->labelfont(1);
      echoname->labelsize(12);
      echoname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* echoname
    { Fl_Choice* o = echop = new Fl_Choice(102, 13, 96, 15, "Preset");
      echop->down_box(FL_BORDER_BOX);
      echop->color((Fl_Color)14);
      echop->selection_color(FL_FOREGROUND_COLOR);
      echop->labelsize(11);
      echop->textfont(1);
      echop->textsize(10);
      echop->textcolor(FL_BACKGROUND2_COLOR);
      echop->callback((Fl_Callback*)cb_echop);
      o->add("Echo 1");o->add("Echo 2");o->add("Echo 3");o->add("Echo 4");o->add("Simple Echo");o->add("Canyon");o->add("Panning Echo 1");o->add("Panning Echo 2");o->add("Feedback Echo 3");
    } // Fl_Choice* echop
    { WidgetPDial* o = echop0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      echop0->tooltip("Effect volume");
      echop0->box(FL_ROUND_UP_BOX);
      echop0->color(FL_BACKGROUND_COLOR);
      echop0->selection_color(FL_INACTIVE_COLOR);
      echop0->labeltype(FL_NORMAL_LABEL);
      echop0->labelfont(0);
      echop0->labelsize(11);
      echop0->labelcolor(FL_FOREGROUND_COLOR);
      echop0->maximum(127);
      echop0->callback((Fl_Callback*)cb_echop0);
      echop0->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop0->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXEchoVol);
    } // WidgetPDial* echop0
    { WidgetPDial* o = echop1 = new WidgetPDial(64, 40, 30, 30, "Pan");
      echop1->box(FL_ROUND_UP_BOX);
      echop1->color(FL_BACKGROUND_COLOR);
      echop1->selection_color(FL_INACTIVE_COLOR);
      echop1->labeltype(FL_NORMAL_LABEL);
      echop1->labelfont(0);
      echop1->labelsize(11);
      echop1->labelcolor(FL_FOREGROUND_COLOR);
      echop1->maximum(127);
      echop1->callback((Fl_Callback*)cb_echop1);
      echop1->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop1->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PanningStd);
    } // WidgetPDial* echop1
    { WidgetPDial* o = echop2 = new WidgetPDial(118, 40, 30, 30, "Delay");
      echop2->box(FL_ROUND_UP_BOX);
      echop2->color(FL_BACKGROUND_COLOR);
      echop2->selection_color(FL_INACTIVE_COLOR);
      echop2->labeltype(FL_NORMAL_LABEL);
      echop2->labelfont(0);
      echop2->labelsize(11);
      echop2->labelcolor(FL_FOREGROUND_COLOR);
      echop2->maximum(127);
      echop2->callback((Fl_Callback*)cb_echop2);
      echop2->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop2->when(FL_WHEN_RELEASE);
      o->setValueType(eff->geteffectpar(EFFECT::control::bpm) ? VC_FXlfofreqBPM : VC_FXEchoDelay);
    } // WidgetPDial* echop2
    { WidgetPDial* o = echop3 = new WidgetPDial(172, 40, 30, 30, "LRdl.");
      echop3->tooltip("Delay between L/R");
      echop3->box(FL_ROUND_UP_BOX);
      echop3->color(FL_BACKGROUND_COLOR);
      echop3->selection_color(FL_INACTIVE_COLOR);
      echop3->labeltype(FL_NORMAL_LABEL);
      echop3->labelfont(0);
      echop3->labelsize(11);
      echop3->labelcolor(FL_FOREGROUND_COLOR);
      echop3->maximum(127);
      echop3->callback((Fl_Callback*)cb_echop3);
      echop3->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_FXEchoLRdel);
    } // WidgetPDial* echop3
    { WidgetPDial* o = echop4 = new WidgetPDial(226, 40, 30, 30, "LRc.");
      echop4->tooltip("L/R crossover");
      echop4->box(FL_ROUND_UP_BOX);
      echop4->color(FL_BACKGROUND_COLOR);
      echop4->selection_color(FL_INACTIVE_COLOR);
      echop4->labeltype(FL_NORMAL_LABEL);
      echop4->labelfont(0);
      echop4->labelsize(11);
      echop4->labelcolor(FL_FOREGROUND_COLOR);
      echop4->maximum(127);
      echop4->callback((Fl_Callback*)cb_echop4);
      echop4->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop4->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* echop4
    { WidgetPDial* o = echop5 = new WidgetPDial(280, 40, 30, 30, "Fb.");
      echop5->tooltip("Feedback");
      echop5->box(FL_ROUND_UP_BOX);
      echop5->color(FL_BACKGROUND_COLOR);
      echop5->selection_color(FL_INACTIVE_COLOR);
      echop5->labeltype(FL_NORMAL_LABEL);
      echop5->labelfont(0);
      echop5->labelsize(11);
      echop5->labelcolor(FL_FOREGROUND_COLOR);
      echop5->maximum(127);
      echop5->callback((Fl_Callback*)cb_echop5);
      echop5->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop5->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* echop5
    { WidgetPDial* o = echop6 = new WidgetPDial(334, 40, 30, 30, "Damp");
      echop6->tooltip("Dampening");
      echop6->box(FL_ROUND_UP_BOX);
      echop6->color(FL_BACKGROUND_COLOR);
      echop6->selection_color(FL_INACTIVE_COLOR);
      echop6->labeltype(FL_NORMAL_LABEL);
      echop6->labelfont(0);
      echop6->labelsize(11);
      echop6->labelcolor(FL_FOREGROUND_COLOR);
      echop6->maximum(127);
      echop6->callback((Fl_Callback*)cb_echop6);
      echop6->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop6->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* echop6
    { echop17 = new Fl_Check_Button(325, 10, 45, 15, "BPM");
      echop17->tooltip("Synchronize the frequency to a multiple of the BPM. Note that the delay is ca\
pped at 5 seconds, even if the tempo is slower than this.");
      echop17->down_box(FL_DOWN_BOX);
      echop17->labelsize(11);
      echop17->callback((Fl_Callback*)cb_echop17);
    } // Fl_Check_Button* echop17
    effechowindow->end();
  } // Fl_Group* effechowindow
  return effechowindow;
}

Fl_Group* EffUI::make_chorus_window() {
  { effchoruswindow = new Fl_Group(0, 0, 380, 95);
    effchoruswindow->box(FL_PLASTIC_UP_BOX);
    effchoruswindow->color((Fl_Color)221);
    effchoruswindow->selection_color(FL_BACKGROUND_COLOR);
    effchoruswindow->labeltype(FL_NO_LABEL);
    effchoruswindow->labelfont(1);
    effchoruswindow->labelsize(14);
    effchoruswindow->labelcolor(FL_FOREGROUND_COLOR);
    effchoruswindow->user_data((void*)(this));
    effchoruswindow->align(Fl_Align(FL_ALIGN_TOP));
    effchoruswindow->when(FL_WHEN_RELEASE);
    { chorusname = new Fl_Text_Display(10, 10, 0, 20, "Chorus");
      chorusname->box(FL_NO_BOX);
      chorusname->labelfont(1);
      chorusname->labelsize(12);
      chorusname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* chorusname
    { Fl_Choice* o = chorusp = new Fl_Choice(121, 13, 96, 16, "Preset");
      chorusp->down_box(FL_BORDER_BOX);
      chorusp->color((Fl_Color)14);
      chorusp->selection_color(FL_FOREGROUND_COLOR);
      chorusp->labelsize(11);
      chorusp->textfont(1);
      chorusp->textsize(10);
      chorusp->textcolor(FL_BACKGROUND2_COLOR);
      chorusp->callback((Fl_Callback*)cb_chorusp);
      o->add("Chorus 1");o->add("Chorus 2");o->add("Chorus 3");o->add("Celeste 1");o->add("Celeste 2");o->add("Flange 1");o->add("Flange 2");o->add("Flange 3");o->add("Flange 4");o->add("Flange 5");
    } // Fl_Choice* chorusp
    { Fl_Choice* o = chorusp4 = new Fl_Choice(189, 65, 43, 15, "LFO type");
      chorusp4->tooltip("LFO function");
      chorusp4->down_box(FL_BORDER_BOX);
      chorusp4->labelsize(10);
      chorusp4->textfont(1);
      chorusp4->textsize(9);
      chorusp4->callback((Fl_Callback*)cb_chorusp4);
      chorusp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Sine");o->add("Tri");
    } // Fl_Choice* chorusp4
    { WidgetPDial* o = chorusp0 = new WidgetPDial(10, 49, 30, 30, "Vol");
      chorusp0->box(FL_ROUND_UP_BOX);
      chorusp0->color(FL_BACKGROUND_COLOR);
      chorusp0->selection_color(FL_INACTIVE_COLOR);
      chorusp0->labeltype(FL_NORMAL_LABEL);
      chorusp0->labelfont(0);
      chorusp0->labelsize(11);
      chorusp0->labelcolor(FL_FOREGROUND_COLOR);
      chorusp0->maximum(127);
      chorusp0->callback((Fl_Callback*)cb_chorusp0);
      chorusp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp0->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXdefaultVol);
    } // WidgetPDial* chorusp0
    { WidgetPDial* o = chorusp1 = new WidgetPDial(45, 49, 30, 30, "Pan");
      chorusp1->box(FL_ROUND_UP_BOX);
      chorusp1->color(FL_BACKGROUND_COLOR);
      chorusp1->selection_color(FL_INACTIVE_COLOR);
      chorusp1->labeltype(FL_NORMAL_LABEL);
      chorusp1->labelfont(0);
      chorusp1->labelsize(11);
      chorusp1->labelcolor(FL_FOREGROUND_COLOR);
      chorusp1->maximum(127);
      chorusp1->callback((Fl_Callback*)cb_chorusp1);
      chorusp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp1->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PanningStd);
    } // WidgetPDial* chorusp1
    { WidgetPDial* o = chorusp2 = new WidgetPDial(85, 49, 30, 30, "Freq");
      chorusp2->tooltip("LFO frequency");
      chorusp2->box(FL_ROUND_UP_BOX);
      chorusp2->color(FL_BACKGROUND_COLOR);
      chorusp2->selection_color(FL_INACTIVE_COLOR);
      chorusp2->labeltype(FL_NORMAL_LABEL);
      chorusp2->labelfont(0);
      chorusp2->labelsize(11);
      chorusp2->labelcolor(FL_FOREGROUND_COLOR);
      chorusp2->maximum(127);
      chorusp2->callback((Fl_Callback*)cb_chorusp2);
      chorusp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp2->when(FL_WHEN_CHANGED);
      o->setValueType(eff->geteffectpar(EFFECT::control::bpm) ? VC_FXlfofreqBPM : VC_FXlfofreq);
    } // WidgetPDial* chorusp2
    { WidgetPDial* o = chorusp18 = new WidgetPDial(120, 50, 30, 30, "Start");
      chorusp18->tooltip("Start of LFO phase relative to start of beat. This has no effect unless you a\
re syncing to a song position, using MIDI or a plugin host.");
      chorusp18->box(FL_ROUND_UP_BOX);
      chorusp18->color(FL_BACKGROUND_COLOR);
      chorusp18->selection_color(FL_INACTIVE_COLOR);
      chorusp18->labeltype(FL_NORMAL_LABEL);
      chorusp18->labelfont(0);
      chorusp18->labelsize(11);
      chorusp18->labelcolor(FL_FOREGROUND_COLOR);
      chorusp18->maximum(127);
      chorusp18->callback((Fl_Callback*)cb_chorusp18);
      chorusp18->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp18->when(FL_WHEN_RELEASE);
      o->setValueType(VC_PhaseOffset);
      if (eff->geteffectpar(EFFECT::control::bpm)) o->activate(); else o->deactivate();
    } // WidgetPDial* chorusp18
    { WidgetPDial* o = chorusp3 = new WidgetPDial(155, 49, 30, 30, "Rnd");
      chorusp3->tooltip("LFO randomness");
      chorusp3->box(FL_ROUND_UP_BOX);
      chorusp3->color(FL_BACKGROUND_COLOR);
      chorusp3->selection_color(FL_INACTIVE_COLOR);
      chorusp3->labeltype(FL_NORMAL_LABEL);
      chorusp3->labelfont(0);
      chorusp3->labelsize(11);
      chorusp3->labelcolor(FL_FOREGROUND_COLOR);
      chorusp3->maximum(127);
      chorusp3->callback((Fl_Callback*)cb_chorusp3);
      chorusp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_percent127);
    } // WidgetPDial* chorusp3
    { WidgetPDial* o = chorusp5 = new WidgetPDial(237, 49, 30, 30, "St.df");
      chorusp5->tooltip("L/R phase shift");
      chorusp5->box(FL_ROUND_UP_BOX);
      chorusp5->color(FL_BACKGROUND_COLOR);
      chorusp5->selection_color(FL_INACTIVE_COLOR);
      chorusp5->labeltype(FL_NORMAL_LABEL);
      chorusp5->labelfont(0);
      chorusp5->labelsize(11);
      chorusp5->labelcolor(FL_FOREGROUND_COLOR);
      chorusp5->maximum(127);
      chorusp5->callback((Fl_Callback*)cb_chorusp5);
      chorusp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp5->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXlfoStereo);
    } // WidgetPDial* chorusp5
    { WidgetPDial* o = chorusp6 = new WidgetPDial(272, 49, 30, 30, "Dpth");
      chorusp6->tooltip("LFO depth");
      chorusp6->box(FL_ROUND_UP_BOX);
      chorusp6->color(FL_BACKGROUND_COLOR);
      chorusp6->selection_color(FL_INACTIVE_COLOR);
      chorusp6->labeltype(FL_NORMAL_LABEL);
      chorusp6->labelfont(0);
      chorusp6->labelsize(11);
      chorusp6->labelcolor(FL_FOREGROUND_COLOR);
      chorusp6->maximum(127);
      chorusp6->callback((Fl_Callback*)cb_chorusp6);
      chorusp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp6->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXChorusDepth);
    } // WidgetPDial* chorusp6
    { WidgetPDial* o = chorusp7 = new WidgetPDial(307, 49, 30, 30, "Delay");
      chorusp7->box(FL_ROUND_UP_BOX);
      chorusp7->color(FL_BACKGROUND_COLOR);
      chorusp7->selection_color(FL_INACTIVE_COLOR);
      chorusp7->labeltype(FL_NORMAL_LABEL);
      chorusp7->labelfont(0);
      chorusp7->labelsize(11);
      chorusp7->labelcolor(FL_FOREGROUND_COLOR);
      chorusp7->maximum(127);
      chorusp7->callback((Fl_Callback*)cb_chorusp7);
      chorusp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp7->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXChorusDelay);
    } // WidgetPDial* chorusp7
    { WidgetPDial* o = chorusp8 = new WidgetPDial(342, 49, 30, 30, "Fb");
      chorusp8->tooltip("Feedback");
      chorusp8->box(FL_ROUND_UP_BOX);
      chorusp8->color(FL_BACKGROUND_COLOR);
      chorusp8->selection_color(FL_INACTIVE_COLOR);
      chorusp8->labeltype(FL_NORMAL_LABEL);
      chorusp8->labelfont(0);
      chorusp8->labelsize(11);
      chorusp8->labelcolor(FL_FOREGROUND_COLOR);
      chorusp8->maximum(127);
      chorusp8->callback((Fl_Callback*)cb_chorusp8);
      chorusp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp8->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXdefaultFb);
    } // WidgetPDial* chorusp8
    { WidgetPDial* o = chorusp9 = new WidgetPDial(254, 15, 30, 30, "L/R");
      chorusp9->tooltip("Channel routing");
      chorusp9->box(FL_ROUND_UP_BOX);
      chorusp9->color(FL_BACKGROUND_COLOR);
      chorusp9->selection_color(FL_INACTIVE_COLOR);
      chorusp9->labeltype(FL_NORMAL_LABEL);
      chorusp9->labelfont(0);
      chorusp9->labelsize(11);
      chorusp9->labelcolor(FL_FOREGROUND_COLOR);
      chorusp9->maximum(127);
      chorusp9->callback((Fl_Callback*)cb_chorusp9);
      chorusp9->align(Fl_Align(FL_ALIGN_TOP));
      chorusp9->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* chorusp9
    { Fl_Check_Button2* o = chorusflange = new Fl_Check_Button2(120, 10, 55, 20, "Flange");
      chorusflange->box(FL_THIN_UP_BOX);
      chorusflange->down_box(FL_DOWN_BOX);
      chorusflange->color((Fl_Color)230);
      chorusflange->selection_color(FL_FOREGROUND_COLOR);
      chorusflange->labeltype(FL_NORMAL_LABEL);
      chorusflange->labelfont(1);
      chorusflange->labelsize(10);
      chorusflange->labelcolor(FL_FOREGROUND_COLOR);
      chorusflange->callback((Fl_Callback*)cb_chorusflange);
      chorusflange->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      chorusflange->when(FL_WHEN_RELEASE);
      chorusflange->hide();
      chorusflange->deactivate();
      o->value(eff->geteffectpar(10));
    } // Fl_Check_Button2* chorusflange
    { chorusp11 = new Fl_Check_Button2(300, 19, 70, 16, "Subtract");
      chorusp11->tooltip("Inverts the output");
      chorusp11->box(FL_NO_BOX);
      chorusp11->down_box(FL_DOWN_BOX);
      chorusp11->color((Fl_Color)230);
      chorusp11->selection_color(FL_FOREGROUND_COLOR);
      chorusp11->labeltype(FL_NORMAL_LABEL);
      chorusp11->labelfont(0);
      chorusp11->labelsize(11);
      chorusp11->labelcolor(FL_FOREGROUND_COLOR);
      chorusp11->callback((Fl_Callback*)cb_chorusp11);
      chorusp11->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      chorusp11->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* chorusp11
    { chorusp17 = new Fl_Check_Button(190, 45, 50, 15, "BPM");
      chorusp17->tooltip("Synchronize the frequency to a multiple of the BPM.");
      chorusp17->down_box(FL_DOWN_BOX);
      chorusp17->labelsize(11);
      chorusp17->callback((Fl_Callback*)cb_chorusp17);
    } // Fl_Check_Button* chorusp17
    effchoruswindow->end();
  } // Fl_Group* effchoruswindow
  return effchoruswindow;
}

Fl_Group* EffUI::make_phaser_window() {
  { effphaserwindow = new Fl_Group(0, 0, 380, 95);
    effphaserwindow->box(FL_PLASTIC_UP_BOX);
    effphaserwindow->color((Fl_Color)221);
    effphaserwindow->selection_color(FL_BACKGROUND_COLOR);
    effphaserwindow->labeltype(FL_NO_LABEL);
    effphaserwindow->labelfont(0);
    effphaserwindow->labelsize(11);
    effphaserwindow->labelcolor(FL_FOREGROUND_COLOR);
    effphaserwindow->user_data((void*)(this));
    effphaserwindow->align(Fl_Align(FL_ALIGN_TOP));
    effphaserwindow->when(FL_WHEN_RELEASE);
    { phasername = new Fl_Text_Display(10, 10, 0, 20, "Phaser");
      phasername->box(FL_NO_BOX);
      phasername->labelfont(1);
      phasername->labelsize(12);
      phasername->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* phasername
    { Fl_Choice* o = phaserp = new Fl_Choice(65, 21, 82, 15, "Preset");
      phaserp->box(FL_UP_BOX);
      phaserp->down_box(FL_BORDER_BOX);
      phaserp->color((Fl_Color)14);
      phaserp->selection_color(FL_FOREGROUND_COLOR);
      phaserp->labelsize(11);
      phaserp->textfont(1);
      phaserp->textsize(10);
      phaserp->textcolor(FL_BACKGROUND2_COLOR);
      phaserp->callback((Fl_Callback*)cb_phaserp);
      phaserp->align(Fl_Align(FL_ALIGN_TOP));
      o->add("Phaser 1");o->add("Phaser 2");o->add("Phaser 3");o->add("Phaser 4");o->add("Phaser 5");o->add("Phaser 6");o->add("APhaser 1");o->add("APhaser 2");o->add("APhaser 3");o->add("APhaser 4");o->add("APhaser 5");o->add("APhaser 6");
    } // Fl_Choice* phaserp
    { Fl_Choice* o = phaserp4 = new Fl_Choice(199, 65, 43, 15, "LFO Type");
      phaserp4->tooltip("LFO function");
      phaserp4->down_box(FL_BORDER_BOX);
      phaserp4->labelsize(10);
      phaserp4->textfont(1);
      phaserp4->textsize(9);
      phaserp4->callback((Fl_Callback*)cb_phaserp4);
      phaserp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Sine");o->add("Tri");
    } // Fl_Choice* phaserp4
    { WidgetPDial* o = phaserp0 = new WidgetPDial(8, 50, 30, 30, "Vol");
      phaserp0->tooltip("Effect volume");
      phaserp0->box(FL_ROUND_UP_BOX);
      phaserp0->color(FL_BACKGROUND_COLOR);
      phaserp0->selection_color(FL_INACTIVE_COLOR);
      phaserp0->labeltype(FL_NORMAL_LABEL);
      phaserp0->labelfont(0);
      phaserp0->labelsize(11);
      phaserp0->labelcolor(FL_FOREGROUND_COLOR);
      phaserp0->maximum(127);
      phaserp0->callback((Fl_Callback*)cb_phaserp0);
      phaserp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp0->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXdefaultVol);
    } // WidgetPDial* phaserp0
    { WidgetPDial* o = phaserp1 = new WidgetPDial(46, 50, 30, 30, "Pan");
      phaserp1->box(FL_ROUND_UP_BOX);
      phaserp1->color(FL_BACKGROUND_COLOR);
      phaserp1->selection_color(FL_INACTIVE_COLOR);
      phaserp1->labeltype(FL_NORMAL_LABEL);
      phaserp1->labelfont(0);
      phaserp1->labelsize(11);
      phaserp1->labelcolor(FL_FOREGROUND_COLOR);
      phaserp1->maximum(127);
      phaserp1->callback((Fl_Callback*)cb_phaserp1);
      phaserp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp1->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PanningStd);
    } // WidgetPDial* phaserp1
    { WidgetPDial* o = phaserp2 = new WidgetPDial(84, 50, 30, 30, "Freq");
      phaserp2->tooltip("LFO frequency");
      phaserp2->box(FL_ROUND_UP_BOX);
      phaserp2->color(FL_BACKGROUND_COLOR);
      phaserp2->selection_color(FL_INACTIVE_COLOR);
      phaserp2->labeltype(FL_NORMAL_LABEL);
      phaserp2->labelfont(0);
      phaserp2->labelsize(11);
      phaserp2->labelcolor(FL_FOREGROUND_COLOR);
      phaserp2->maximum(127);
      phaserp2->callback((Fl_Callback*)cb_phaserp2);
      phaserp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp2->when(FL_WHEN_CHANGED);
      o->setValueType(eff->geteffectpar(EFFECT::control::bpm) ? VC_FXlfofreqBPM : VC_FXlfofreq);
    } // WidgetPDial* phaserp2
    { WidgetPDial* o = phaserp18 = new WidgetPDial(125, 50, 30, 30, "Start");
      phaserp18->tooltip("Start of LFO phase relative to start of beat. This has no effect unless you a\
re syncing to a song position, using MIDI or a plugin host.");
      phaserp18->box(FL_ROUND_UP_BOX);
      phaserp18->color(FL_BACKGROUND_COLOR);
      phaserp18->selection_color(FL_INACTIVE_COLOR);
      phaserp18->labeltype(FL_NORMAL_LABEL);
      phaserp18->labelfont(0);
      phaserp18->labelsize(11);
      phaserp18->labelcolor(FL_FOREGROUND_COLOR);
      phaserp18->maximum(127);
      phaserp18->callback((Fl_Callback*)cb_phaserp18);
      phaserp18->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp18->when(FL_WHEN_RELEASE);
      o->setValueType(VC_PhaseOffset);
      if (eff->geteffectpar(EFFECT::control::bpm)) o->activate(); else o->deactivate();
    } // WidgetPDial* phaserp18
    { WidgetPDial* o = phaserp3 = new WidgetPDial(165, 50, 30, 30, "Rnd");
      phaserp3->tooltip("LFO randomness");
      phaserp3->box(FL_ROUND_UP_BOX);
      phaserp3->color(FL_BACKGROUND_COLOR);
      phaserp3->selection_color(FL_INACTIVE_COLOR);
      phaserp3->labeltype(FL_NORMAL_LABEL);
      phaserp3->labelfont(0);
      phaserp3->labelsize(11);
      phaserp3->labelcolor(FL_FOREGROUND_COLOR);
      phaserp3->maximum(127);
      phaserp3->callback((Fl_Callback*)cb_phaserp3);
      phaserp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_percent127);
    } // WidgetPDial* phaserp3
    { Fl_Check_Button2* o = phaserp17 = new Fl_Check_Button2(200, 47, 17, 15, "BPM");
      phaserp17->tooltip("Synchronize the frequency to a multiple of the BPM.");
      phaserp17->box(FL_NO_BOX);
      phaserp17->down_box(FL_DOWN_BOX);
      phaserp17->color(FL_BACKGROUND_COLOR);
      phaserp17->selection_color(FL_FOREGROUND_COLOR);
      phaserp17->labeltype(FL_NORMAL_LABEL);
      phaserp17->labelfont(0);
      phaserp17->labelsize(11);
      phaserp17->labelcolor(FL_FOREGROUND_COLOR);
      phaserp17->callback((Fl_Callback*)cb_phaserp17);
      phaserp17->align(Fl_Align(FL_ALIGN_RIGHT));
      phaserp17->when(FL_WHEN_RELEASE);
      o->value(eff->geteffectpar(EFFECT::control::bpm));
    } // Fl_Check_Button2* phaserp17
    { WidgetPDial* o = phaserp5 = new WidgetPDial(248, 50, 30, 30, "St.df");
      phaserp5->tooltip("Left/Right channel phase shift");
      phaserp5->box(FL_ROUND_UP_BOX);
      phaserp5->color(FL_BACKGROUND_COLOR);
      phaserp5->selection_color(FL_INACTIVE_COLOR);
      phaserp5->labeltype(FL_NORMAL_LABEL);
      phaserp5->labelfont(0);
      phaserp5->labelsize(11);
      phaserp5->labelcolor(FL_FOREGROUND_COLOR);
      phaserp5->maximum(127);
      phaserp5->callback((Fl_Callback*)cb_phaserp5);
      phaserp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp5->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXlfoStereo);
    } // WidgetPDial* phaserp5
    { WidgetPDial* o = phaserp6 = new WidgetPDial(191, 15, 30, 30, "Depth");
      phaserp6->tooltip("LFO depth");
      phaserp6->box(FL_ROUND_UP_BOX);
      phaserp6->color(FL_BACKGROUND_COLOR);
      phaserp6->selection_color(FL_INACTIVE_COLOR);
      phaserp6->labeltype(FL_NORMAL_LABEL);
      phaserp6->labelfont(0);
      phaserp6->labelsize(11);
      phaserp6->labelcolor(FL_FOREGROUND_COLOR);
      phaserp6->maximum(127);
      phaserp6->callback((Fl_Callback*)cb_phaserp6);
      phaserp6->align(Fl_Align(FL_ALIGN_TOP));
      phaserp6->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* phaserp6
    { WidgetPDial* o = phaserp7 = new WidgetPDial(286, 50, 30, 30, "Fb");
      phaserp7->tooltip("Feedback");
      phaserp7->box(FL_ROUND_UP_BOX);
      phaserp7->color(FL_BACKGROUND_COLOR);
      phaserp7->selection_color(FL_INACTIVE_COLOR);
      phaserp7->labeltype(FL_NORMAL_LABEL);
      phaserp7->labelfont(0);
      phaserp7->labelsize(11);
      phaserp7->labelcolor(FL_FOREGROUND_COLOR);
      phaserp7->maximum(127);
      phaserp7->callback((Fl_Callback*)cb_phaserp7);
      phaserp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp7->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXdefaultFb);
    } // WidgetPDial* phaserp7
    { phaserp8 = new Fl_Counter(326, 63, 45, 15, "Stages");
      phaserp8->type(1);
      phaserp8->labelsize(11);
      phaserp8->minimum(1);
      phaserp8->maximum(12);
      phaserp8->step(1);
      phaserp8->textfont(1);
      phaserp8->textsize(11);
      phaserp8->callback((Fl_Callback*)cb_phaserp8);
    } // Fl_Counter* phaserp8
    { WidgetPDial* o = phaserp9 = new WidgetPDial(229, 15, 30, 30, "L/R");
      phaserp9->tooltip("Channel routing");
      phaserp9->box(FL_ROUND_UP_BOX);
      phaserp9->color(FL_BACKGROUND_COLOR);
      phaserp9->selection_color(FL_INACTIVE_COLOR);
      phaserp9->labeltype(FL_NORMAL_LABEL);
      phaserp9->labelfont(0);
      phaserp9->labelsize(11);
      phaserp9->labelcolor(FL_FOREGROUND_COLOR);
      phaserp9->maximum(127);
      phaserp9->callback((Fl_Callback*)cb_phaserp9);
      phaserp9->align(Fl_Align(FL_ALIGN_TOP));
      phaserp9->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* phaserp9
    { phaserp10 = new Fl_Check_Button2(356, 42, 17, 16, "Sub.");
      phaserp10->tooltip("Inverts the output");
      phaserp10->box(FL_NO_BOX);
      phaserp10->down_box(FL_DOWN_BOX);
      phaserp10->color((Fl_Color)230);
      phaserp10->selection_color(FL_FOREGROUND_COLOR);
      phaserp10->labeltype(FL_NORMAL_LABEL);
      phaserp10->labelfont(0);
      phaserp10->labelsize(11);
      phaserp10->labelcolor(FL_FOREGROUND_COLOR);
      phaserp10->callback((Fl_Callback*)cb_phaserp10);
      phaserp10->align(Fl_Align(FL_ALIGN_LEFT));
      phaserp10->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* phaserp10
    { WidgetPDial* o = phaserp11 = new WidgetPDial(150, 15, 30, 30, "Phase");
      phaserp11->box(FL_ROUND_UP_BOX);
      phaserp11->color(FL_BACKGROUND_COLOR);
      phaserp11->selection_color(FL_INACTIVE_COLOR);
      phaserp11->labeltype(FL_NORMAL_LABEL);
      phaserp11->labelfont(0);
      phaserp11->labelsize(11);
      phaserp11->labelcolor(FL_FOREGROUND_COLOR);
      phaserp11->maximum(127);
      phaserp11->callback((Fl_Callback*)cb_phaserp11);
      phaserp11->align(Fl_Align(FL_ALIGN_TOP));
      phaserp11->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* phaserp11
    { phaserp12 = new Fl_Check_Button2(356, 26, 17, 15, "Hyper");
      phaserp12->tooltip("Hyper-sine");
      phaserp12->box(FL_NO_BOX);
      phaserp12->down_box(FL_DOWN_BOX);
      phaserp12->color(FL_BACKGROUND_COLOR);
      phaserp12->selection_color(FL_FOREGROUND_COLOR);
      phaserp12->labeltype(FL_NORMAL_LABEL);
      phaserp12->labelfont(0);
      phaserp12->labelsize(11);
      phaserp12->labelcolor(FL_FOREGROUND_COLOR);
      phaserp12->callback((Fl_Callback*)cb_phaserp12);
      phaserp12->align(Fl_Align(FL_ALIGN_LEFT));
      phaserp12->when(FL_WHEN_RELEASE);
      phaserp12->deactivate();
    } // Fl_Check_Button2* phaserp12
    { WidgetPDial* o = phaserp13 = new WidgetPDial(267, 15, 30, 30, "Dist");
      phaserp13->tooltip("Distortion");
      phaserp13->box(FL_ROUND_UP_BOX);
      phaserp13->color(FL_BACKGROUND_COLOR);
      phaserp13->selection_color(FL_INACTIVE_COLOR);
      phaserp13->labeltype(FL_NORMAL_LABEL);
      phaserp13->labelfont(0);
      phaserp13->labelsize(11);
      phaserp13->labelcolor(FL_FOREGROUND_COLOR);
      phaserp13->maximum(127);
      phaserp13->callback((Fl_Callback*)cb_phaserp13);
      phaserp13->align(Fl_Align(FL_ALIGN_TOP));
      phaserp13->when(FL_WHEN_CHANGED);
      phaserp13->deactivate();
      o->setValueType(VC_percent127);
    } // WidgetPDial* phaserp13
    { phaserp14 = new Fl_Check_Button2(356, 10, 17, 15, "Analog");
      phaserp14->tooltip("Emulates FET");
      phaserp14->box(FL_NO_BOX);
      phaserp14->down_box(FL_DOWN_BOX);
      phaserp14->color(FL_BACKGROUND_COLOR);
      phaserp14->selection_color(FL_FOREGROUND_COLOR);
      phaserp14->labeltype(FL_NORMAL_LABEL);
      phaserp14->labelfont(0);
      phaserp14->labelsize(11);
      phaserp14->labelcolor(FL_FOREGROUND_COLOR);
      phaserp14->callback((Fl_Callback*)cb_phaserp14);
      phaserp14->align(Fl_Align(FL_ALIGN_LEFT));
      phaserp14->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* phaserp14
    effphaserwindow->end();
  } // Fl_Group* effphaserwindow
  return effphaserwindow;
}

Fl_Group* EffUI::make_alienwah_window() {
  { effalienwahwindow = new Fl_Group(0, 0, 380, 95);
    effalienwahwindow->box(FL_PLASTIC_UP_BOX);
    effalienwahwindow->color((Fl_Color)221);
    effalienwahwindow->selection_color(FL_BACKGROUND_COLOR);
    effalienwahwindow->labeltype(FL_NO_LABEL);
    effalienwahwindow->labelfont(1);
    effalienwahwindow->labelsize(14);
    effalienwahwindow->labelcolor(FL_FOREGROUND_COLOR);
    effalienwahwindow->user_data((void*)(this));
    effalienwahwindow->align(Fl_Align(FL_ALIGN_TOP));
    effalienwahwindow->when(FL_WHEN_RELEASE);
    { alienname = new Fl_Text_Display(10, 10, 0, 20, "AlienWah");
      alienname->box(FL_NO_BOX);
      alienname->labelfont(1);
      alienname->labelsize(12);
      alienname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* alienname
    { Fl_Choice* o = awp = new Fl_Choice(135, 13, 96, 15, "Preset");
      awp->down_box(FL_BORDER_BOX);
      awp->color((Fl_Color)14);
      awp->selection_color(FL_FOREGROUND_COLOR);
      awp->labelsize(11);
      awp->textfont(1);
      awp->textsize(10);
      awp->textcolor(FL_BACKGROUND2_COLOR);
      awp->callback((Fl_Callback*)cb_awp);
      o->add("Alienwah 1");o->add("Alienwah 2");o->add("Alienwah 3");o->add("Alienwah 4");
    } // Fl_Choice* awp
    { Fl_Choice* o = awp4 = new Fl_Choice(185, 65, 43, 15, "LFO type");
      awp4->tooltip("LFO function");
      awp4->down_box(FL_BORDER_BOX);
      awp4->labelsize(10);
      awp4->textfont(1);
      awp4->textsize(9);
      awp4->callback((Fl_Callback*)cb_awp4);
      awp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Sine");o->add("Tri");
    } // Fl_Choice* awp4
    { awp0 = new WidgetPDial(5, 49, 30, 30, "Vol");
      awp0->tooltip("Effect volume");
      awp0->box(FL_ROUND_UP_BOX);
      awp0->color(FL_BACKGROUND_COLOR);
      awp0->selection_color(FL_INACTIVE_COLOR);
      awp0->labeltype(FL_NORMAL_LABEL);
      awp0->labelfont(0);
      awp0->labelsize(11);
      awp0->labelcolor(FL_FOREGROUND_COLOR);
      awp0->maximum(127);
      awp0->callback((Fl_Callback*)cb_awp0);
      awp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp0
    { awp1 = new WidgetPDial(40, 49, 30, 30, "Pan");
      awp1->box(FL_ROUND_UP_BOX);
      awp1->color(FL_BACKGROUND_COLOR);
      awp1->selection_color(FL_INACTIVE_COLOR);
      awp1->labeltype(FL_NORMAL_LABEL);
      awp1->labelfont(0);
      awp1->labelsize(11);
      awp1->labelcolor(FL_FOREGROUND_COLOR);
      awp1->maximum(127);
      awp1->callback((Fl_Callback*)cb_awp1);
      awp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp1
    { WidgetPDial* o = awp2 = new WidgetPDial(80, 49, 30, 30, "Freq");
      awp2->tooltip("LFO frequency");
      awp2->box(FL_ROUND_UP_BOX);
      awp2->color(FL_BACKGROUND_COLOR);
      awp2->selection_color(FL_INACTIVE_COLOR);
      awp2->labeltype(FL_NORMAL_LABEL);
      awp2->labelfont(0);
      awp2->labelsize(11);
      awp2->labelcolor(FL_FOREGROUND_COLOR);
      awp2->maximum(127);
      awp2->callback((Fl_Callback*)cb_awp2);
      awp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp2->when(FL_WHEN_CHANGED);
      o->setValueType(eff->geteffectpar(EFFECT::control::bpm) ? VC_FXlfofreqBPM : VC_FXlfofreq);
    } // WidgetPDial* awp2
    { WidgetPDial* o = awp3 = new WidgetPDial(150, 50, 30, 30, "Rnd");
      awp3->tooltip("LFO randomness");
      awp3->box(FL_ROUND_UP_BOX);
      awp3->color(FL_BACKGROUND_COLOR);
      awp3->selection_color(FL_INACTIVE_COLOR);
      awp3->labeltype(FL_NORMAL_LABEL);
      awp3->labelfont(0);
      awp3->labelsize(11);
      awp3->labelcolor(FL_FOREGROUND_COLOR);
      awp3->maximum(127);
      awp3->callback((Fl_Callback*)cb_awp3);
      awp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_percent127);
    } // WidgetPDial* awp3
    { WidgetPDial* o = awp18 = new WidgetPDial(115, 50, 30, 30, "Start");
      awp18->tooltip("Start of LFO phase relative to start of beat. This has no effect unless you a\
re syncing to a song position, using MIDI or a plugin host.");
      awp18->box(FL_ROUND_UP_BOX);
      awp18->color(FL_BACKGROUND_COLOR);
      awp18->selection_color(FL_INACTIVE_COLOR);
      awp18->labeltype(FL_NORMAL_LABEL);
      awp18->labelfont(0);
      awp18->labelsize(11);
      awp18->labelcolor(FL_FOREGROUND_COLOR);
      awp18->maximum(127);
      awp18->callback((Fl_Callback*)cb_awp18);
      awp18->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp18->when(FL_WHEN_RELEASE);
      o->setValueType(VC_PhaseOffset);
      if (eff->geteffectpar(EFFECT::control::bpm)) o->activate(); else o->deactivate();
    } // WidgetPDial* awp18
    { awp5 = new WidgetPDial(231, 49, 30, 30, "St.df");
      awp5->tooltip("Left/Right channel phase shift");
      awp5->box(FL_ROUND_UP_BOX);
      awp5->color(FL_BACKGROUND_COLOR);
      awp5->selection_color(FL_INACTIVE_COLOR);
      awp5->labeltype(FL_NORMAL_LABEL);
      awp5->labelfont(0);
      awp5->labelsize(11);
      awp5->labelcolor(FL_FOREGROUND_COLOR);
      awp5->maximum(127);
      awp5->callback((Fl_Callback*)cb_awp5);
      awp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp5
    { awp6 = new WidgetPDial(266, 49, 30, 30, "Dpth");
      awp6->tooltip("Depth");
      awp6->box(FL_ROUND_UP_BOX);
      awp6->color(FL_BACKGROUND_COLOR);
      awp6->selection_color(FL_INACTIVE_COLOR);
      awp6->labeltype(FL_NORMAL_LABEL);
      awp6->labelfont(0);
      awp6->labelsize(11);
      awp6->labelcolor(FL_FOREGROUND_COLOR);
      awp6->maximum(127);
      awp6->callback((Fl_Callback*)cb_awp6);
      awp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp6
    { awp7 = new WidgetPDial(301, 49, 30, 30, "Fb");
      awp7->tooltip("Feedback");
      awp7->box(FL_ROUND_UP_BOX);
      awp7->color(FL_BACKGROUND_COLOR);
      awp7->selection_color(FL_INACTIVE_COLOR);
      awp7->labeltype(FL_NORMAL_LABEL);
      awp7->labelfont(0);
      awp7->labelsize(11);
      awp7->labelcolor(FL_FOREGROUND_COLOR);
      awp7->maximum(127);
      awp7->callback((Fl_Callback*)cb_awp7);
      awp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp7
    { awp9 = new WidgetPDial(285, 15, 30, 30, "L/R");
      awp9->box(FL_ROUND_UP_BOX);
      awp9->color(FL_BACKGROUND_COLOR);
      awp9->selection_color(FL_INACTIVE_COLOR);
      awp9->labeltype(FL_NORMAL_LABEL);
      awp9->labelfont(0);
      awp9->labelsize(11);
      awp9->labelcolor(FL_FOREGROUND_COLOR);
      awp9->maximum(127);
      awp9->callback((Fl_Callback*)cb_awp9);
      awp9->align(Fl_Align(FL_ALIGN_TOP));
      awp9->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp9
    { awp10 = new WidgetPDial(245, 15, 30, 30, "Phase");
      awp10->box(FL_ROUND_UP_BOX);
      awp10->color(FL_BACKGROUND_COLOR);
      awp10->selection_color(FL_INACTIVE_COLOR);
      awp10->labeltype(FL_NORMAL_LABEL);
      awp10->labelfont(0);
      awp10->labelsize(11);
      awp10->labelcolor(FL_FOREGROUND_COLOR);
      awp10->maximum(127);
      awp10->callback((Fl_Callback*)cb_awp10);
      awp10->align(Fl_Align(FL_ALIGN_TOP));
      awp10->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp10
    { awp8 = new Fl_Counter(338, 64, 35, 15, "Delay");
      awp8->type(1);
      awp8->labelsize(11);
      awp8->minimum(0);
      awp8->maximum(100);
      awp8->step(1);
      awp8->textsize(11);
      awp8->callback((Fl_Callback*)cb_awp8);
    } // Fl_Counter* awp8
    { Fl_Check_Button* o = awp17 = new Fl_Check_Button(185, 45, 45, 15, "BPM");
      awp17->tooltip("Synchronize the frequency to a multiple of the BPM.");
      awp17->down_box(FL_DOWN_BOX);
      awp17->labelsize(11);
      awp17->callback((Fl_Callback*)cb_awp17);
      o->value(eff->geteffectpar(EFFECT::control::bpm));
    } // Fl_Check_Button* awp17
    effalienwahwindow->end();
  } // Fl_Group* effalienwahwindow
  return effalienwahwindow;
}

Fl_Group* EffUI::make_distorsion_window() {
  { effdistorsionwindow = new Fl_Group(0, 0, 380, 95);
    effdistorsionwindow->box(FL_PLASTIC_UP_BOX);
    effdistorsionwindow->color((Fl_Color)221);
    effdistorsionwindow->selection_color(FL_BACKGROUND_COLOR);
    effdistorsionwindow->labeltype(FL_NO_LABEL);
    effdistorsionwindow->labelfont(1);
    effdistorsionwindow->labelsize(14);
    effdistorsionwindow->labelcolor(FL_FOREGROUND_COLOR);
    effdistorsionwindow->user_data((void*)(this));
    effdistorsionwindow->align(Fl_Align(FL_ALIGN_TOP));
    effdistorsionwindow->when(FL_WHEN_RELEASE);
    { distname = new Fl_Text_Display(10, 10, 0, 20, "Distortion");
      distname->box(FL_NO_BOX);
      distname->labelfont(1);
      distname->labelsize(12);
      distname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* distname
    { Fl_Choice* o = distp = new Fl_Choice(139, 13, 96, 16, "Preset");
      distp->down_box(FL_BORDER_BOX);
      distp->color((Fl_Color)14);
      distp->selection_color(FL_FOREGROUND_COLOR);
      distp->labelsize(11);
      distp->textfont(1);
      distp->textsize(10);
      distp->textcolor(FL_BACKGROUND2_COLOR);
      distp->callback((Fl_Callback*)cb_distp);
      o->add("Overdrive 1");o->add("Overdrive 2");o->add("Exciter 1");o->add("Exciter 2");o->add("Guitar Amp");o->add("Quantize");
    } // Fl_Choice* distp
    { Fl_Choice* o = distp5 = new Fl_Choice(192, 56, 60, 15, "Type");
      distp5->box(FL_UP_BOX);
      distp5->down_box(FL_BORDER_BOX);
      distp5->labelsize(10);
      distp5->textfont(1);
      distp5->textsize(9);
      distp5->callback((Fl_Callback*)cb_distp5);
      distp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Atan");o->add("Asym 1");o->add("Power1");o->add("Sine");o->add("Quants");o->add("Zigzag");o->add("Limit");o->add("LimtiU");o->add("LimitL");o->add("ILimit");o->add("Clip");o->add("Asym 2");o->add("Power2");o->add("Sigm");
    } // Fl_Choice* distp5
    { WidgetPDial* o = distp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      distp0->tooltip("Effect volume");
      distp0->box(FL_ROUND_UP_BOX);
      distp0->color(FL_BACKGROUND_COLOR);
      distp0->selection_color(FL_INACTIVE_COLOR);
      distp0->labeltype(FL_NORMAL_LABEL);
      distp0->labelfont(0);
      distp0->labelsize(11);
      distp0->labelcolor(FL_FOREGROUND_COLOR);
      distp0->maximum(127);
      distp0->callback((Fl_Callback*)cb_distp0);
      distp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp0->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXDistVol);
    } // WidgetPDial* distp0
    { WidgetPDial* o = distp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      distp1->box(FL_ROUND_UP_BOX);
      distp1->color(FL_BACKGROUND_COLOR);
      distp1->selection_color(FL_INACTIVE_COLOR);
      distp1->labeltype(FL_NORMAL_LABEL);
      distp1->labelfont(0);
      distp1->labelsize(11);
      distp1->labelcolor(FL_FOREGROUND_COLOR);
      distp1->maximum(127);
      distp1->callback((Fl_Callback*)cb_distp1);
      distp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp1->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PanningStd);
    } // WidgetPDial* distp1
    { WidgetPDial* o = distp2 = new WidgetPDial(80, 40, 30, 30, "LRc.");
      distp2->tooltip("L/R mix");
      distp2->box(FL_ROUND_UP_BOX);
      distp2->color(FL_BACKGROUND_COLOR);
      distp2->selection_color(FL_INACTIVE_COLOR);
      distp2->labeltype(FL_NORMAL_LABEL);
      distp2->labelfont(0);
      distp2->labelsize(11);
      distp2->labelcolor(FL_FOREGROUND_COLOR);
      distp2->maximum(127);
      distp2->callback((Fl_Callback*)cb_distp2);
      distp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp2->when(FL_WHEN_RELEASE);
      o->setValueType(VC_percent127);
    } // WidgetPDial* distp2
    { WidgetPDial* o = distp3 = new WidgetPDial(120, 40, 30, 30, "Drive");
      distp3->tooltip("Input amplification");
      distp3->box(FL_ROUND_UP_BOX);
      distp3->color(FL_BACKGROUND_COLOR);
      distp3->selection_color(FL_INACTIVE_COLOR);
      distp3->labeltype(FL_NORMAL_LABEL);
      distp3->labelfont(0);
      distp3->labelsize(11);
      distp3->labelcolor(FL_FOREGROUND_COLOR);
      distp3->maximum(127);
      distp3->callback((Fl_Callback*)cb_distp3);
      distp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_percent127);
    } // WidgetPDial* distp3
    { WidgetPDial* o = distp4 = new WidgetPDial(155, 40, 30, 30, "Level");
      distp4->tooltip("Output amplification");
      distp4->box(FL_ROUND_UP_BOX);
      distp4->color(FL_BACKGROUND_COLOR);
      distp4->selection_color(FL_INACTIVE_COLOR);
      distp4->labeltype(FL_NORMAL_LABEL);
      distp4->labelfont(0);
      distp4->labelsize(11);
      distp4->labelcolor(FL_FOREGROUND_COLOR);
      distp4->maximum(127);
      distp4->callback((Fl_Callback*)cb_distp4);
      distp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp4->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXDistLevel);
    } // WidgetPDial* distp4
    { WidgetPDial* o = distp7 = new WidgetPDial(285, 40, 30, 30, "LPF");
      distp7->tooltip("Low pass filter");
      distp7->box(FL_ROUND_UP_BOX);
      distp7->color(FL_BACKGROUND_COLOR);
      distp7->selection_color(FL_INACTIVE_COLOR);
      distp7->labeltype(FL_NORMAL_LABEL);
      distp7->labelfont(0);
      distp7->labelsize(11);
      distp7->labelcolor(FL_FOREGROUND_COLOR);
      distp7->maximum(127);
      distp7->callback((Fl_Callback*)cb_distp7);
      distp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp7->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXDistLowPass);
    } // WidgetPDial* distp7
    { WidgetPDial* o = distp8 = new WidgetPDial(320, 40, 30, 30, "HPF");
      distp8->tooltip("High pass filter");
      distp8->box(FL_ROUND_UP_BOX);
      distp8->color(FL_BACKGROUND_COLOR);
      distp8->selection_color(FL_INACTIVE_COLOR);
      distp8->labeltype(FL_NORMAL_LABEL);
      distp8->labelfont(0);
      distp8->labelsize(11);
      distp8->labelcolor(FL_FOREGROUND_COLOR);
      distp8->maximum(127);
      distp8->callback((Fl_Callback*)cb_distp8);
      distp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp8->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXDistHighPass);
    } // WidgetPDial* distp8
    { distp6 = new Fl_Check_Button2(260, 55, 15, 15, "Neg.");
      distp6->box(FL_NO_BOX);
      distp6->down_box(FL_DOWN_BOX);
      distp6->color(FL_BACKGROUND_COLOR);
      distp6->selection_color(FL_FOREGROUND_COLOR);
      distp6->labeltype(FL_NORMAL_LABEL);
      distp6->labelfont(0);
      distp6->labelsize(11);
      distp6->labelcolor(FL_FOREGROUND_COLOR);
      distp6->callback((Fl_Callback*)cb_distp6);
      distp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp6->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* distp6
    { distp9 = new Fl_Check_Button2(357, 55, 15, 15, "St.");
      distp9->tooltip("Stereo");
      distp9->box(FL_NO_BOX);
      distp9->down_box(FL_DOWN_BOX);
      distp9->color(FL_BACKGROUND_COLOR);
      distp9->selection_color(FL_FOREGROUND_COLOR);
      distp9->labeltype(FL_NORMAL_LABEL);
      distp9->labelfont(0);
      distp9->labelsize(11);
      distp9->labelcolor(FL_FOREGROUND_COLOR);
      distp9->callback((Fl_Callback*)cb_distp9);
      distp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp9->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* distp9
    { distp10 = new Fl_Check_Button2(357, 38, 15, 15, "PF");
      distp10->tooltip("Applies the filters(before or after) the distortion");
      distp10->box(FL_NO_BOX);
      distp10->down_box(FL_DOWN_BOX);
      distp10->color(FL_BACKGROUND_COLOR);
      distp10->selection_color(FL_FOREGROUND_COLOR);
      distp10->labeltype(FL_NORMAL_LABEL);
      distp10->labelfont(0);
      distp10->labelsize(11);
      distp10->labelcolor(FL_FOREGROUND_COLOR);
      distp10->callback((Fl_Callback*)cb_distp10);
      distp10->align(Fl_Align(FL_ALIGN_TOP));
      distp10->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* distp10
    effdistorsionwindow->end();
  } // Fl_Group* effdistorsionwindow
  return effdistorsionwindow;
}

Fl_Group* EffUI::make_eq_window() {
  { effeqwindow = new Fl_Group(0, 0, 380, 95);
    effeqwindow->box(FL_PLASTIC_UP_BOX);
    effeqwindow->color((Fl_Color)221);
    effeqwindow->selection_color(FL_BACKGROUND_COLOR);
    effeqwindow->labeltype(FL_NO_LABEL);
    effeqwindow->labelfont(1);
    effeqwindow->labelsize(14);
    effeqwindow->labelcolor(FL_FOREGROUND_COLOR);
    effeqwindow->user_data((void*)(this));
    effeqwindow->align(Fl_Align(FL_ALIGN_TOP));
    effeqwindow->when(FL_WHEN_RELEASE);
    { eqname = new Fl_Text_Display(10, 10, 0, 20, "EQ");
      eqname->box(FL_NO_BOX);
      eqname->labelfont(1);
      eqname->labelsize(12);
      eqname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* eqname
    { WidgetPDial* o = eqp0 = new WidgetPDial(10, 41, 30, 30, "Gain");
      eqp0->box(FL_ROUND_UP_BOX);
      eqp0->color(FL_BACKGROUND_COLOR);
      eqp0->selection_color(FL_INACTIVE_COLOR);
      eqp0->labeltype(FL_NORMAL_LABEL);
      eqp0->labelfont(0);
      eqp0->labelsize(11);
      eqp0->labelcolor(FL_FOREGROUND_COLOR);
      eqp0->maximum(127);
      eqp0->callback((Fl_Callback*)cb_eqp0);
      eqp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      eqp0->when(FL_WHEN_CHANGED);
      o->setValueType(VC_FXEQgain);
    } // WidgetPDial* eqp0
    { Fl_Counter* o = bandcounter = new Fl_Counter(263, 20, 45, 15, "Band");
      bandcounter->tooltip("Band no.");
      bandcounter->type(1);
      bandcounter->labelsize(11);
      bandcounter->minimum(0);
      bandcounter->maximum(1);
      bandcounter->step(1);
      bandcounter->textsize(11);
      bandcounter->callback((Fl_Callback*)cb_bandcounter);
      bandcounter->align(Fl_Align(FL_ALIGN_TOP));
      o->bounds(0,MAX_EQ_BANDS-1);
    } // Fl_Counter* bandcounter
    { bandgroup = new Fl_Group(241, 40, 134, 50);
      bandgroup->box(FL_ENGRAVED_FRAME);
      { WidgetPDial* o = freqdial = new WidgetPDial(247, 50, 25, 25, "Freq");
        freqdial->box(FL_ROUND_UP_BOX);
        freqdial->color(FL_BACKGROUND_COLOR);
        freqdial->selection_color(FL_INACTIVE_COLOR);
        freqdial->labeltype(FL_NORMAL_LABEL);
        freqdial->labelfont(0);
        freqdial->labelsize(10);
        freqdial->labelcolor(FL_FOREGROUND_COLOR);
        freqdial->maximum(127);
        freqdial->callback((Fl_Callback*)cb_freqdial);
        freqdial->align(Fl_Align(FL_ALIGN_BOTTOM));
        freqdial->when(3);
        o->setValueType(VC_FXEQfreq);
      } // WidgetPDial* freqdial
      { WidgetPDial* o = gaindial = new WidgetPDial(277, 50, 25, 25, "Gain");
        gaindial->box(FL_ROUND_UP_BOX);
        gaindial->color(FL_BACKGROUND_COLOR);
        gaindial->selection_color(FL_INACTIVE_COLOR);
        gaindial->labeltype(FL_NORMAL_LABEL);
        gaindial->labelfont(0);
        gaindial->labelsize(10);
        gaindial->labelcolor(FL_FOREGROUND_COLOR);
        gaindial->maximum(127);
        gaindial->step(1);
        gaindial->callback((Fl_Callback*)cb_gaindial);
        gaindial->align(Fl_Align(FL_ALIGN_BOTTOM));
        gaindial->when(3);
        o->setValueType(VC_FXEQfilterGain);
      } // WidgetPDial* gaindial
      { WidgetPDial* o = qdial = new WidgetPDial(307, 50, 25, 25, "Q");
        qdial->tooltip("Resonance/Bandwidth");
        qdial->box(FL_ROUND_UP_BOX);
        qdial->color(FL_BACKGROUND_COLOR);
        qdial->selection_color(FL_INACTIVE_COLOR);
        qdial->labeltype(FL_NORMAL_LABEL);
        qdial->labelfont(0);
        qdial->labelsize(10);
        qdial->labelcolor(FL_FOREGROUND_COLOR);
        qdial->maximum(127);
        qdial->callback((Fl_Callback*)cb_qdial);
        qdial->align(Fl_Align(FL_ALIGN_BOTTOM));
        qdial->when(3);
        o->setValueType(VC_FXEQq);
      } // WidgetPDial* qdial
      { Fl_Counter* o = stagescounter = new Fl_Counter(337, 60, 30, 15, "Stages");
        stagescounter->tooltip("Additional filter stages");
        stagescounter->type(1);
        stagescounter->labelsize(10);
        stagescounter->minimum(1);
        stagescounter->maximum(127);
        stagescounter->step(1);
        stagescounter->textfont(1);
        stagescounter->textsize(11);
        stagescounter->callback((Fl_Callback*)cb_stagescounter);
        o->bounds(0,MAX_FILTER_STAGES-1);
      } // Fl_Counter* stagescounter
      bandgroup->end();
    } // Fl_Group* bandgroup
    { Fl_Choice* o = typechoice = new Fl_Choice(323, 20, 40, 15, "Type");
      typechoice->tooltip("Type");
      typechoice->down_box(FL_BORDER_BOX);
      typechoice->labelsize(11);
      typechoice->textfont(1);
      typechoice->textsize(9);
      typechoice->callback((Fl_Callback*)cb_typechoice);
      typechoice->align(Fl_Align(FL_ALIGN_TOP));
      typechoice->when(FL_WHEN_RELEASE_ALWAYS);
      o->add("Off");o->add("Lp1");o->add("Hp1");o->add("Lp2");o->add("Hp2");o->add("Bp2");o->add("N2");o->add("Pk");o->add("LSh");o->add("HSh");
    } // Fl_Choice* typechoice
    { eqgraph = new EQGraph(45, 10, 190, 75);
      eqgraph->box(FL_BORDER_BOX);
      eqgraph->color((Fl_Color)178);
      eqgraph->selection_color(FL_BACKGROUND_COLOR);
      eqgraph->labeltype(FL_NORMAL_LABEL);
      eqgraph->labelfont(0);
      eqgraph->labelsize(14);
      eqgraph->labelcolor(FL_FOREGROUND_COLOR);
      eqgraph->align(Fl_Align(FL_ALIGN_CENTER));
      eqgraph->when(FL_WHEN_RELEASE);
    } // EQGraph* eqgraph
    effeqwindow->end();
  } // Fl_Group* effeqwindow
  return effeqwindow;
}

Fl_Group* EffUI::make_dynamicfilter_window() {
  { effdynamicfilterwindow = new Fl_Group(0, 0, 380, 95);
    effdynamicfilterwindow->box(FL_PLASTIC_UP_BOX);
    effdynamicfilterwindow->color((Fl_Color)221);
    effdynamicfilterwindow->selection_color(FL_BACKGROUND_COLOR);
    effdynamicfilterwindow->labeltype(FL_NO_LABEL);
    effdynamicfilterwindow->labelfont(1);
    effdynamicfilterwindow->labelsize(14);
    effdynamicfilterwindow->labelcolor(FL_FOREGROUND_COLOR);
    effdynamicfilterwindow->user_data((void*)(this));
    effdynamicfilterwindow->align(Fl_Align(FL_ALIGN_TOP));
    effdynamicfilterwindow->when(FL_WHEN_RELEASE);
    { dfname = new Fl_Text_Display(10, 10, 0, 20, "DynFilter");
      dfname->box(FL_NO_BOX);
      dfname->labelfont(1);
      dfname->labelsize(12);
      dfname->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* dfname
    { Fl_Choice* o = dfp = new Fl_Choice(132, 13, 90, 16, "Preset");
      dfp->down_box(FL_BORDER_BOX);
      dfp->color((Fl_Color)14);
      dfp->selection_color(FL_FOREGROUND_COLOR);
      dfp->labelsize(11);
      dfp->textfont(1);
      dfp->textsize(10);
      dfp->textcolor(FL_BACKGROUND2_COLOR);
      dfp->callback((Fl_Callback*)cb_dfp);
      o->add("WahWah");o->add("AutoWah");o->add("Sweep");o->add("VocalMorph1");o->add("VocalMorph2");
    } // Fl_Choice* dfp
    { Fl_Choice* o = dfp4 = new Fl_Choice(190, 60, 43, 15, "LFO type");
      dfp4->tooltip("LFO function");
      dfp4->down_box(FL_BORDER_BOX);
      dfp4->labelsize(10);
      dfp4->textfont(1);
      dfp4->textsize(9);
      dfp4->callback((Fl_Callback*)cb_dfp4);
      dfp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Sine");o->add("Tri");
    } // Fl_Choice* dfp4
    { dfp0 = new WidgetPDial(6, 44, 30, 30, "Vol");
      dfp0->tooltip("Effect volume");
      dfp0->box(FL_ROUND_UP_BOX);
      dfp0->color(FL_BACKGROUND_COLOR);
      dfp0->selection_color(FL_INACTIVE_COLOR);
      dfp0->labeltype(FL_NORMAL_LABEL);
      dfp0->labelfont(0);
      dfp0->labelsize(11);
      dfp0->labelcolor(FL_FOREGROUND_COLOR);
      dfp0->maximum(127);
      dfp0->callback((Fl_Callback*)cb_dfp0);
      dfp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp0
    { dfp1 = new WidgetPDial(42, 44, 30, 30, "Pan");
      dfp1->box(FL_ROUND_UP_BOX);
      dfp1->color(FL_BACKGROUND_COLOR);
      dfp1->selection_color(FL_INACTIVE_COLOR);
      dfp1->labeltype(FL_NORMAL_LABEL);
      dfp1->labelfont(0);
      dfp1->labelsize(11);
      dfp1->labelcolor(FL_FOREGROUND_COLOR);
      dfp1->maximum(127);
      dfp1->callback((Fl_Callback*)cb_dfp1);
      dfp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp1
    { WidgetPDial* o = dfp2 = new WidgetPDial(80, 44, 30, 30, "Freq");
      dfp2->tooltip("LFO frequency");
      dfp2->box(FL_ROUND_UP_BOX);
      dfp2->color(FL_BACKGROUND_COLOR);
      dfp2->selection_color(FL_INACTIVE_COLOR);
      dfp2->labeltype(FL_NORMAL_LABEL);
      dfp2->labelfont(0);
      dfp2->labelsize(11);
      dfp2->labelcolor(FL_FOREGROUND_COLOR);
      dfp2->maximum(127);
      dfp2->callback((Fl_Callback*)cb_dfp2);
      dfp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp2->when(FL_WHEN_CHANGED);
      o->setValueType(eff->geteffectpar(EFFECT::control::bpm) ? VC_FXlfofreqBPM : VC_FXlfofreq);
    } // WidgetPDial* dfp2
    { WidgetPDial* o = dfp3 = new WidgetPDial(155, 44, 30, 30, "Rnd");
      dfp3->tooltip("LFO randomness");
      dfp3->box(FL_ROUND_UP_BOX);
      dfp3->color(FL_BACKGROUND_COLOR);
      dfp3->selection_color(FL_INACTIVE_COLOR);
      dfp3->labeltype(FL_NORMAL_LABEL);
      dfp3->labelfont(0);
      dfp3->labelsize(11);
      dfp3->labelcolor(FL_FOREGROUND_COLOR);
      dfp3->maximum(127);
      dfp3->callback((Fl_Callback*)cb_dfp3);
      dfp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp3->when(FL_WHEN_RELEASE);
      o->setValueType(VC_percent127);
    } // WidgetPDial* dfp3
    { WidgetPDial* o = dfp18 = new WidgetPDial(118, 44, 30, 30, "Start");
      dfp18->tooltip("Start of LFO phase relative to start of beat. This has no effect unless you a\
re syncing to a song position, using MIDI or a plugin host.");
      dfp18->box(FL_ROUND_UP_BOX);
      dfp18->color(FL_BACKGROUND_COLOR);
      dfp18->selection_color(FL_INACTIVE_COLOR);
      dfp18->labeltype(FL_NORMAL_LABEL);
      dfp18->labelfont(0);
      dfp18->labelsize(11);
      dfp18->labelcolor(FL_FOREGROUND_COLOR);
      dfp18->maximum(127);
      dfp18->callback((Fl_Callback*)cb_dfp18);
      dfp18->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp18->when(FL_WHEN_RELEASE);
      o->setValueType(VC_PhaseOffset);
      if (eff->geteffectpar(EFFECT::control::bpm)) o->activate(); else o->deactivate();
    } // WidgetPDial* dfp18
    { dfp5 = new WidgetPDial(240, 49, 30, 30, "St.df");
      dfp5->tooltip("Left/Right channel phase shift");
      dfp5->box(FL_ROUND_UP_BOX);
      dfp5->color(FL_BACKGROUND_COLOR);
      dfp5->selection_color(FL_INACTIVE_COLOR);
      dfp5->labeltype(FL_NORMAL_LABEL);
      dfp5->labelfont(0);
      dfp5->labelsize(11);
      dfp5->labelcolor(FL_FOREGROUND_COLOR);
      dfp5->maximum(127);
      dfp5->callback((Fl_Callback*)cb_dfp5);
      dfp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp5
    { dfp6 = new WidgetPDial(240, 8, 30, 30, "LfoD");
      dfp6->tooltip("LFO depth");
      dfp6->box(FL_ROUND_UP_BOX);
      dfp6->color(FL_BACKGROUND_COLOR);
      dfp6->selection_color(FL_INACTIVE_COLOR);
      dfp6->labeltype(FL_NORMAL_LABEL);
      dfp6->labelfont(0);
      dfp6->labelsize(11);
      dfp6->labelcolor(FL_FOREGROUND_COLOR);
      dfp6->maximum(127);
      dfp6->callback((Fl_Callback*)cb_dfp6);
      dfp6->align(Fl_Align(FL_ALIGN_RIGHT));
      dfp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp6
    { filter = new Fl_Button(325, 12, 37, 16, "Filter");
      filter->box(FL_PLASTIC_THIN_UP_BOX);
      filter->labelsize(11);
      filter->callback((Fl_Callback*)cb_filter);
    } // Fl_Button* filter
    { Fl_Group* o = new Fl_Group(277, 37, 99, 53);
      o->box(FL_EMBOSSED_BOX);
      o->color((Fl_Color)181);
      { dfp7 = new WidgetPDial(282, 44, 30, 30, "A.S.");
        dfp7->tooltip("Filter vs amplitude");
        dfp7->box(FL_ROUND_UP_BOX);
        dfp7->color(FL_BACKGROUND_COLOR);
        dfp7->selection_color(FL_INACTIVE_COLOR);
        dfp7->labeltype(FL_NORMAL_LABEL);
        dfp7->labelfont(0);
        dfp7->labelsize(11);
        dfp7->labelcolor(FL_FOREGROUND_COLOR);
        dfp7->maximum(127);
        dfp7->callback((Fl_Callback*)cb_dfp7);
        dfp7->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp7->when(FL_WHEN_CHANGED);
      } // WidgetPDial* dfp7
      { dfp9 = new WidgetPDial(318, 44, 30, 30, "A.M");
        dfp9->tooltip("Rate that  amplitude changes the filter");
        dfp9->box(FL_ROUND_UP_BOX);
        dfp9->color(FL_BACKGROUND_COLOR);
        dfp9->selection_color(FL_INACTIVE_COLOR);
        dfp9->labeltype(FL_NORMAL_LABEL);
        dfp9->labelfont(0);
        dfp9->labelsize(11);
        dfp9->labelcolor(FL_FOREGROUND_COLOR);
        dfp9->maximum(127);
        dfp9->callback((Fl_Callback*)cb_dfp9);
        dfp9->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp9->when(FL_WHEN_CHANGED);
      } // WidgetPDial* dfp9
      { dfp8 = new Fl_Check_Button2(353, 58, 15, 15, "Inv.");
        dfp8->tooltip("Enable for filter frequency to lower with higher input amplitude");
        dfp8->box(FL_NO_BOX);
        dfp8->down_box(FL_DOWN_BOX);
        dfp8->color(FL_BACKGROUND_COLOR);
        dfp8->selection_color(FL_FOREGROUND_COLOR);
        dfp8->labeltype(FL_NORMAL_LABEL);
        dfp8->labelfont(0);
        dfp8->labelsize(11);
        dfp8->labelcolor(FL_FOREGROUND_COLOR);
        dfp8->callback((Fl_Callback*)cb_dfp8);
        dfp8->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp8->when(FL_WHEN_RELEASE);
      } // Fl_Check_Button2* dfp8
      o->end();
    } // Fl_Group* o
    { Fl_Check_Button* o = dfp17 = new Fl_Check_Button(191, 41, 45, 15, "BPM");
      dfp17->tooltip("Synchronize the frequency to a multiple of the BPM.");
      dfp17->down_box(FL_DOWN_BOX);
      dfp17->labelsize(11);
      dfp17->callback((Fl_Callback*)cb_dfp17);
      o->value(eff->geteffectpar(EFFECT::control::bpm));
    } // Fl_Check_Button* dfp17
    effdynamicfilterwindow->end();
  } // Fl_Group* effdynamicfilterwindow
  return effdynamicfilterwindow;
}

Fl_Double_Window* EffUI::make_filter_window() {
  { Fl_Double_Window* o = filterwindow = new Fl_Double_Window(285, 110, "Filter Parameters for DynFilter Eff.");
    filterwindow->callback((Fl_Callback*)cb_filterwindow, (void*)(this));
    { FilterUI* o = fwin_filterui = new FilterUI(5, 5, 275, 75, "DynFilter effect  - Filter");
      fwin_filterui->box(FL_FLAT_BOX);
      fwin_filterui->color(FL_LIGHT1);
      fwin_filterui->selection_color(FL_BACKGROUND_COLOR);
      fwin_filterui->labeltype(FL_NORMAL_LABEL);
      fwin_filterui->labelfont(0);
      fwin_filterui->labelsize(12);
      fwin_filterui->labelcolor(FL_FOREGROUND_COLOR);
      fwin_filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
      fwin_filterui->when(FL_WHEN_RELEASE);
      o->init(eff->filterpars,NULL,NULL, npart, (EFFECT::type::dynFilter), neff);
      fwin_filterui->end();
    } // FilterUI* fwin_filterui
    { filterclose = new Fl_Button(124, 86, 46, 20, "Close");
      filterclose->box(FL_THIN_UP_BOX);
      filterclose->labelsize(12);
      filterclose->callback((Fl_Callback*)cb_filterclose);
    } // Fl_Button* filterclose
    filtDW = o->w(); filtDH = o->h();
    o->size_range(filtDW, filtDH, 0, 0, 0, 0, 1);
    filterwindow->end();
    filterwindow->resizable(filterwindow);
  } // Fl_Double_Window* filterwindow
  return filterwindow;
}

void EffUI::send_data(int action, int control, float value, int group, int type) {
  //
      type |= TOPLEVEL::type::Write;
      collect_data(synth, value, action, type, control, npart, group, neff);
}

float EffUI::fetchData(float value, int control, int part, int kititem , int engine , int insert , int parameter , int offset , int miscmsg , int request ) {
  //
          return collect_readData(synth, value, control, part, kititem, engine, insert, parameter, offset, miscmsg, request);
}

void EffUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      int value_int = int(value + 0.5f);
      unsigned char control = getData->data.control;
      unsigned char efftype = getData->data.kit;
      unsigned char effnum = getData->data.engine;
      bool isdynfilter = (effnum == (EFFECT::type::dynFilter));
      unsigned char secondary = getData->data.offset;
  
      int textCol = 14;
      if (fetchData(0, EFFECT::control::changed, getData->data.part, efftype, effnum) != 0)
          textCol = FL_BLUE;
      //cout << "colour " << textCol << endl;
      switch(efftype)
      {
          case EFFECT::type::none:
              break;
  
          case EFFECT::type::reverb:
              switch (control)
              {
                  case EFFECT::control::level:
                      revp0->value(value);
                      break;
                  case EFFECT::control::panning:
                      revp1->value(value);
                      break;
                  case EFFECT::control::frequency: // time here
                      revp2->value(value);
                      break;
                  case 3:
                      revp3->value(value);
                      break;
                  case 4:
                      revp4->value(value);
                      break;
                  case 6:
                      revp6->value(value);
                      break;
                  case 7:
                      revp7->value(value);
                      break;
                  case 8:
                      revp8->value(value);
                      break;
                  case 9:
                      revp9->value(value);
                      break;
                  case 10:
                      revp10->value(value_int);
                      if (value_int == 2)
                      {
                          revp12->activate();
                          revp12->value(secondary);
                      }
                      else
                          revp12->deactivate();
                      break;
                  case 11:
                      revp11->value(value);
                      break;
                  case 12:
                      revp12->value(value);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              revp->color(textCol);
              revp->redraw();
              break;
  
          case EFFECT::type::echo:
              switch (control)
              {
                  case EFFECT::control::level:
                      echop0->value(value);
                      break;
                  case EFFECT::control::panning:
                      echop1->value(value);
                      break;
                  case EFFECT::control::frequency: // delay here
                      echop2->value(value);
                      break;
                  case 3:
                      echop3->value(value);
                      break;
                  case 4:
                      echop4->value(value);
                      break;
                  case 5:
                      echop5->value(value);
                      break;
                  case 6:
                      echop6->value(value);
                      break;
                  case EFFECT::control::bpm:
                      echop17->value(value);
                      if (value)
                          echop2->setValueType(VC_FXlfofreqBPM);
                      else
                          echop2->setValueType(VC_FXEchoDelay);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              echop->color(textCol);
              echop->redraw();
              break;
  
          case EFFECT::type::chorus:
              switch (control)
              {
                  case EFFECT::control::level:
                      chorusp0->value(value);
                      break;
                  case EFFECT::control::panning:
                      chorusp1->value(value);
                      break;
                  case EFFECT::control::frequency:
                      chorusp2->value(value);
                      break;
                  case 3:
                      chorusp3->value(value);
                      break;
                  case 5:
                      chorusp5->value(value);
                      break;
                  case 6:
                      chorusp6->value(value_int);
                      break;
                  case 7:
                      chorusp7->value(value);
                      break;
                  case 8:
                      chorusp8->value(value);
                      break;
                  case 9:
                      chorusp9->value(value);
                      break;
                  case 11:
                      chorusp11->value(value_int);
                      break;
                  case EFFECT::control::bpm:
                      chorusp17->value(value);
                      if (value)
                      {
                          chorusp2->setValueType(VC_FXlfofreqBPM);
                          chorusp18->activate();
                      }
                      else
                      {
                          chorusp2->setValueType(VC_FXlfofreq);
                          chorusp18->deactivate();
                      }
                      break;
                  case EFFECT::control::bpmStart:
                      chorusp18->value(value);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              chorusp->color(textCol);
              chorusp->redraw();
              break;
  
          case EFFECT::type::phaser:
              switch (control)
              {
                  case EFFECT::control::level:
                      phaserp0->value(value);
                      break;
                  case EFFECT::control::panning:
                      phaserp1->value(value);
                      break;
                  case EFFECT::control::frequency:
                      phaserp2->value(value);
                      break;
                  case 3:
                      phaserp3->value(value);
                      break;
                  case 4:
                      phaserp4->value(value_int);
                      break;
                  case 5:
                      phaserp5->value(value);
                      break;
                  case 6:
                      phaserp6->value(value);
                      break;
                  case 7:
                     phaserp7->value(value);
                      break;
                  case 8:
                      phaserp8->value(value_int);
                      break;
                  case 9:
                      phaserp9->value(value);
                      break;
                  case 10:
                      phaserp10->value(value_int);
                      break;
                  case 11:
                      phaserp11->value(value);
                      break;
                  case 12:
                      phaserp12->value(value_int);
                      break;
                  case 13:
                      phaserp13->value(value);
                      break;
                  case 14:
                      phaserp14->value(value_int);
                      if (value_int != 0)
                      {
                          phaserp9->deactivate();
                          phaserp7->deactivate();
                          phaserp12->activate();
                          phaserp13->activate();
                      }
                      else
                      {
                          phaserp9->activate();
                          phaserp7->activate();
                          phaserp12->deactivate();
                          phaserp13->deactivate();
                      }
                      break;
                  case EFFECT::control::bpm:
                      phaserp17->value(value);
                      if (value)
                      {
                          phaserp2->setValueType(VC_FXlfofreqBPM);
                          phaserp18->activate();
                      }
                      else
                      {
                          phaserp2->setValueType(VC_FXlfofreq);
                          phaserp18->deactivate();
                      }
                      break;
                  case EFFECT::control::bpmStart:
                      phaserp18->value(value);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              phaserp->color(textCol);
              phaserp->redraw();
              break;
  
          case EFFECT::type::alienWah:
              switch (control)
              {
                  case EFFECT::control::level:
                      awp0->value(value);
                      break;
                  case EFFECT::control::panning:
                      awp1->value(value);
                      break;
                  case EFFECT::control::frequency:
                      awp2->value(value);
                      break;
                  case 3:
                      awp3->value(value);
                      break;
                  case 4:
                      awp4->value(value_int);
                      break;
                  case 5:
                      awp5->value(value);
                      break;
                  case 6:
                      awp6->value(value);
                      break;
                  case 7:
                      awp7->value(value);
                      break;
                  case 8:
                      awp8->value(value_int);
                      break;
                  case 9:
                      awp9->value(value);
                      break;
                  case 10:
                      awp10->value(value);
                      break;
                  case EFFECT::control::bpm:
                      awp17->value(value);
                      if (value)
                      {
                          awp2->setValueType(VC_FXlfofreqBPM);
                          awp18->activate();
                      }
                      else
                      {
                          awp2->setValueType(VC_FXlfofreq);
                          awp18->deactivate();
                      }
                      break;
                  case EFFECT::control::bpmStart:
                      awp18->value(value);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              awp->color(textCol);
              awp->redraw();
              break;
  
          case EFFECT::type::distortion:
              switch (control)
              {
                  case EFFECT::control::level:
                      distp0->value(value);
                      break;
                  case EFFECT::control::panning:
                      distp1->value(value);
                      break;
                  case EFFECT::control::frequency: // LR-mix here
                      distp2->value(value);
                      break;
                  case 3:
                      distp3->value(value);
                      break;
                  case 4:
                      distp4->value(value);
                      break;
                  case 5:
                      distp5->value(value_int);
                      break;
                  case 6:
                      distp6->value(value_int);
                      break;
                  case 7:
                      distp7->value(value);
                      break;
                  case 8:
                      distp8->value(value);
                      break;
                  case 9:
                      distp9->value(value_int);
                      break;
                  case 10:
                      distp10->value(value_int);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              distp->color(textCol);
              distp->redraw();
              break;
  
          case EFFECT::type::eq:
              //synth->getRuntime().Log("EQ " + to_string(value_int) + "  " + to_string(int(control)));
              if (control == EFFECT::control::level)
              {
                  eqp0->value(value);
              }
              else if (control == EFFECT::control::panning) // band numnber here!
              {
                  eqband = value_int;
                  EQbandUpdate();
              }
              else
              {
                  switch (control)
                  {
                  case 10:
                      typechoice->value(value_int);
                      if (value_int == 0)
                          bandgroup->deactivate();
                      else
                          bandgroup->activate();
                      if (value_int > 2)
                          qdial->activate();
                      else
                          qdial->deactivate();
                      if (value_int > 6)
                          gaindial->activate();
                      else
                          gaindial->deactivate();
                      break;
                  case 11:
                      freqdial->value(value);
                      break;
                  case 12:
                      gaindial->value(value);
                      break;
                  case 13:
                      qdial->value(value);
                      break;
                  case 14:
                      stagescounter->value(value_int);
                  }
              }
              effeqwindow->redraw();
              break;
  
          case EFFECT::type::dynFilter:
              if (isdynfilter)
              { // shouldn't get here
                  //cout << "DyneFilter" << endl;
                  return;
              }
              switch (control)
              {
                  case EFFECT::control::level:
                      dfp0->value(value);
                      break;
                  case EFFECT::control::panning:
                      dfp1->value(value);
                      break;
                  case EFFECT::control::frequency:
                      dfp2->value(value);
                      break;
                  case 3:
                      dfp3->value(value);
                      break;
                  case 4:
                      dfp4->value(value_int);
                      break;
                  case 5:
                      dfp5->value(value);
                      break;
                  case 6:
                      dfp6->value(value);
                      break;
                  case 7:
                      dfp7->value(value);
                      break;
                  case 8:
                      dfp8->value(value_int);
                      break;
                  case 9:
                      dfp9->value(value);
                      break;
                  case EFFECT::control::bpm:
                      dfp17->value(value);
                      if (value)
                      {
                          dfp2->setValueType(VC_FXlfofreqBPM);
                          dfp18->activate();
                      }
                      else
                      {
                          dfp2->setValueType(VC_FXlfofreq);
                          dfp18->deactivate();
                      }
                      break;
                  case EFFECT::control::bpmStart:
                      dfp18->value(value);
                      break;
                  case EFFECT::control::preset:
                      refresh();
                      break;
              }
              dfp->color(textCol);
              dfp->redraw();
              break;
      }
}

void EffUI::init(EffectMgr *eff_, int npart_, int neff_) {
  //
      eff=eff_;
      npart = npart_;
      neff = neff_;
      synth = eff->getSynthEngine();
  
      make_null_window();
      make_reverb_window();
      make_echo_window();
      make_chorus_window();
      make_phaser_window();
      make_alienwah_window();
      make_distorsion_window();
      make_eq_window();
      make_dynamicfilter_window();
  
      int px=this->parent()->x();
      int py=this->parent()->y();
  
      effnullwindow->position(px,py);
      effreverbwindow->position(px,py);
      effechowindow->position(px,py);
      effchoruswindow->position(px,py);
      effphaserwindow->position(px,py);
      effalienwahwindow->position(px,py);
      effdistorsionwindow->position(px,py);
      effeqwindow->position(px,py);
      effdynamicfilterwindow->position(px,py);
      refresh(eff, npart, neff);
}

void EffUI::refresh(EffectMgr *eff_, int npart_, int neff_) {
  //
      eff = eff_;
      npart = npart_;
      neff = neff_;
      this->hide();
      effnullwindow->hide();
      effreverbwindow->hide();
      effechowindow->hide();
      effchoruswindow->hide();
      effphaserwindow->hide();
      effalienwahwindow->hide();
      effdistorsionwindow->hide();
      effeqwindow->hide();
      effdynamicfilterwindow->hide();
      eqband=0;
      if (filterwindow != NULL)
      {
          filterwindow->hide();
          delete(filterwindow);
          filterwindow=NULL;
      }
      switch(eff->geteffect() + EFFECT::type::none) // get effect not yet converted
      {
          case EFFECT::type::reverb:
              revp->value(eff->getpreset());
              revp0->value(eff->geteffectpar(0));
              if (eff->insertion != 0)
              {
                  revp0->label("D/W");
                  revp0->setValueType(VC_FXReverbDW);
              }
              revp1->value(eff->geteffectpar(1));
              revp2->value(eff->geteffectpar(2));
              revp3->value(eff->geteffectpar(3));
              revp4->value(eff->geteffectpar(4));
              revp6->value(eff->geteffectpar(6));
              revp7->value(eff->geteffectpar(7));
              revp8->value(eff->geteffectpar(8));
              revp9->value(eff->geteffectpar(9));
              revp10->value(eff->geteffectpar(10));
              revp11->value(eff->geteffectpar(11));
              revp12->value(eff->geteffectpar(12));
              effreverbwindow->show();
              break;
          case EFFECT::type::echo:
              echop->value(eff->getpreset());
              echop0->value(eff->geteffectpar(0));
              if (eff->insertion != 0)
              {
                  echop0->label("D/W");
                  echop0->setValueType(VC_FXEchoDW);
              }
              echop1->value(eff->geteffectpar(1));
              echop2->value(eff->geteffectpar(2));
              echop3->value(eff->geteffectpar(3));
              echop4->value(eff->geteffectpar(4));
              echop5->value(eff->geteffectpar(5));
              echop6->value(eff->geteffectpar(6));
              echop17->value(eff->geteffectpar(17));
              effechowindow->show();
              break;
          case EFFECT::type::chorus:
              chorusp->value(eff->getpreset());
              chorusp0->value(eff->geteffectpar(0));
              if (eff->insertion != 0)
              {
                  chorusp0->label("D/W");
                  chorusp0->setValueType(VC_FXdefaultDW);
              }
              chorusp1->value(eff->geteffectpar(1));
              chorusp2->value(eff->geteffectpar(2));
              chorusp3->value(eff->geteffectpar(3));
              chorusp4->value(eff->geteffectpar(4));
              chorusp5->value(eff->geteffectpar(5));
              chorusp6->value(eff->geteffectpar(6));
              chorusp7->value(eff->geteffectpar(7));
              chorusp8->value(eff->geteffectpar(8));
              chorusp9->value(eff->geteffectpar(9));
              chorusp11->value(eff->geteffectpar(11));
              chorusp17->value(eff->geteffectpar(17));
              if (chorusp17->value())
              {
                  chorusp2->setValueType(VC_FXlfofreqBPM);
                  chorusp18->activate();
              }
              else
              {
                  chorusp2->setValueType(VC_FXlfofreq);
                  chorusp18->deactivate();
              }
              chorusp18->value(eff->geteffectpar(18));
              effchoruswindow->show();
              break;
          case EFFECT::type::phaser:
              phaserp->value(eff->getpreset());
              phaserp0->value(eff->geteffectpar(0));
              if (eff->insertion != 0)
              {
                  phaserp0->label("D/W");
                  phaserp0->setValueType(VC_FXdefaultDW);
              }
              phaserp1->value(eff->geteffectpar(1));
              phaserp2->value(eff->geteffectpar(2));
              phaserp3->value(eff->geteffectpar(3));
              phaserp4->value(eff->geteffectpar(4));
              phaserp5->value(eff->geteffectpar(5));
              phaserp6->value(eff->geteffectpar(6));
              phaserp7->value(eff->geteffectpar(7));
              phaserp8->value(eff->geteffectpar(8));
              phaserp9->value(eff->geteffectpar(9));
              phaserp10->value(eff->geteffectpar(10));
              phaserp11->value(eff->geteffectpar(11));
              phaserp12->value(eff->geteffectpar(12));
              phaserp13->value(eff->geteffectpar(13));
              phaserp14->value(eff->geteffectpar(14));
              if (phaserp14->value() != 0)
              {
                  phaserp9->deactivate();
                  //phaserp11->deactivate();
                  phaserp12->activate();
                  phaserp13->activate();
              }
              else
              {
                  phaserp9->activate();
                  //phaserp11->activate();
                  phaserp12->deactivate();
                  phaserp13->deactivate();
              }
              phaserp17->value(eff->geteffectpar(17));
              if (phaserp17->value())
              {
                  phaserp2->setValueType(VC_FXlfofreqBPM);
                  phaserp18->activate();
              }
              else
              {
                  phaserp2->setValueType(VC_FXlfofreq);
                  phaserp18->deactivate();
              }
              phaserp18->value(eff->geteffectpar(18));
  
              effphaserwindow->show();
              break;
          case EFFECT::type::alienWah:
              awp->value(eff->getpreset());
              awp0->value(eff->geteffectpar(0));
              if (eff->insertion != 0)
                  awp0->label("D/W");
              awp1->value(eff->geteffectpar(1));
              awp2->value(eff->geteffectpar(2));
              awp3->value(eff->geteffectpar(3));
              awp4->value(eff->geteffectpar(4));
              awp5->value(eff->geteffectpar(5));
              awp6->value(eff->geteffectpar(6));
              awp7->value(eff->geteffectpar(7));
              awp8->value(eff->geteffectpar(8));
              awp9->value(eff->geteffectpar(9));
              awp10->value(eff->geteffectpar(10));
              awp17->value(eff->geteffectpar(17));
              if (awp17->value())
              {
                  awp2->setValueType(VC_FXlfofreqBPM);
                  awp18->activate();
              }
              else
              {
                  awp2->setValueType(VC_FXlfofreq);
                  awp18->deactivate();
              }
              awp18->value(eff->geteffectpar(18));
              effalienwahwindow->show();
              break;
          case EFFECT::type::distortion:
              distp->value(eff->getpreset());
              distp0->value(eff->geteffectpar(0));
              if (eff->insertion != 0)
              {
                  distp0->label("D/W");
                  distp0->setValueType(VC_FXdefaultDW);
              }
              distp1->value(eff->geteffectpar(1));
              distp2->value(eff->geteffectpar(2));
              distp3->value(eff->geteffectpar(3));
              distp4->value(eff->geteffectpar(4));
              distp5->value(eff->geteffectpar(5));
              distp6->value(eff->geteffectpar(6));
              distp7->value(eff->geteffectpar(7));
              distp8->value(eff->geteffectpar(8));
              distp9->value(eff->geteffectpar(9));
              distp10->value(eff->geteffectpar(10));
              effdistorsionwindow->show();
              break;
          case EFFECT::type::eq:
          {
              eqband = 0;
              int type = eff->geteffectpar(10);
              eqp0->value(eff->geteffectpar(0));
              bandcounter->value(eqband);
              typechoice->value(type);
              freqdial->value(eff->geteffectpar(11));
              gaindial->value(eff->geteffectpar(12));
              qdial->value(eff->geteffectpar(13));
              if (type < 3)
                  qdial->deactivate();
              if (type < 6)
                  gaindial->deactivate();
              stagescounter->value(eff->geteffectpar(14));
              eqgraph->init(eff);
              eqgraph->damage(1);
              eqgraph->redraw();
              effeqwindow->show();
              break;
          }
          case EFFECT::type::dynFilter:
              make_filter_window();
              dfp->value(eff->getpreset());
              dfp0->value(eff->geteffectpar(0));
              if (eff->insertion!=0)
                  dfp0->label("D/W");
              dfp1->value(eff->geteffectpar(1));
              dfp2->value(eff->geteffectpar(2));
              dfp3->value(eff->geteffectpar(3));
              dfp4->value(eff->geteffectpar(4));
              dfp5->value(eff->geteffectpar(5));
              dfp6->value(eff->geteffectpar(6));
              dfp7->value(eff->geteffectpar(7));
              dfp8->value(eff->geteffectpar(8));
              dfp9->value(eff->geteffectpar(9));
              dfp17->value(eff->geteffectpar(17));
              if (dfp17->value())
              {
                  dfp2->setValueType(VC_FXlfofreqBPM);
                  dfp18->activate();
              }
              else
              {
                  dfp2->setValueType(VC_FXlfofreq);
                  dfp18->deactivate();
              }
              dfp18->value(eff->geteffectpar(18));
              effdynamicfilterwindow->show();
              break;
          default:
              effnullwindow->show();
              break;
      }
      this->show();
}

void EffUI::refresh() {
  refresh(eff, npart, neff);
}

void EffUI::UpdatePresetColour(int changed, int efftype) {
  //
      int textCol = 14;
      if (changed)
           textCol = FL_BLUE;
      switch (efftype + EFFECT::type::none)
      {
          case EFFECT::type::reverb:
              revp->color(textCol);
              revp->redraw();
              break;
          case EFFECT::type::echo:
              echop->color(textCol);
              echop->redraw();
              break;
          case EFFECT::type::chorus:
              chorusp->color(textCol);
              chorusp->redraw();
              break;
          case EFFECT::type::phaser:
              phaserp->color(textCol);
              phaserp->redraw();
              break;
          case EFFECT::type::alienWah:
              awp->color(textCol);
              awp->redraw();
              break;
          case EFFECT::type::distortion:
              distp->color(textCol);
              distp->redraw();
              break;
          case EFFECT::type::eq:
              break;
          case EFFECT::type::dynFilter:
              dfp->color(textCol);
              dfp->redraw();
              break;
      }
      //cout << "Col " << textCol << "  eff " << efftype << endl;
}

void EffUI::effRtext(float dScale, int efftype) {
  //
          //std::cout << "scale " << dScale << "  type " << efftype << std::endl;
          int size9 = int(9 * dScale);
          int size = int(10 * dScale);
          int size11 = int(11 * dScale);
          int size12 = int(12 * dScale);
  
          switch (efftype)
          {
              case 0:
                  noeffect->labelsize(14 * dScale);
                  break;
              case 1: // reverb
                  revname->labelsize(size12);
                  revp->labelsize(size11);
                      revp->textsize(size);
                  revp10->labelsize(size11);
                      revp10->textsize(size);
  
                  revp0->labelsize(size11);
                  revp1->labelsize(size11);
                  revp2->labelsize(size11);
                  revp3->labelsize(size11);
                  revp4->labelsize(size11);
                  revp12->labelsize(size11);
                  revp6->labelsize(size11);
                  revp7->labelsize(size11);
                  revp8->labelsize(size11);
                  revp9->labelsize(size11);
                  revp11->labelsize(size11);
                  break;
              case 2: // echo
                  echoname->labelsize(size12);
                  echop->labelsize(size11);
                      echop->textsize(size);
  
                  echop0->labelsize(size11);
                  echop1->labelsize(size11);
                  echop2->labelsize(size11);
                  echop3->labelsize(size11);
                  echop4->labelsize(size11);
                  echop5->labelsize(size11);
                  echop6->labelsize(size11);
                  echop17->labelsize(size11);
              	break;
              case 3: // chorus
                  chorusname->labelsize(size12);
                  chorusp->labelsize(size11);
                      chorusp->textsize(size);
                  chorusp4->labelsize(size);
                      chorusp4->textsize(size9);
  
                  chorusp0->labelsize(size11);
                  chorusp1->labelsize(size11);
                  chorusp2->labelsize(size11);
                  chorusp3->labelsize(size11);
                  chorusp5->labelsize(size11);
                  chorusp6->labelsize(size11);
                  chorusp7->labelsize(size11);
                  chorusp8->labelsize(size11);
                  chorusp9->labelsize(size11);
                  chorusflange->labelsize(size);
                  chorusp11->labelsize(size11);
                  chorusp17->labelsize(size11);
                  chorusp18->labelsize(size11);
                  break;
              case 4: // phaser
                  phasername->labelsize(size12);
                  phaserp->labelsize(size11);
                      phaserp->textsize(size);
                  phaserp4->labelsize(size);
                      phaserp4->textsize(size9);
  
                  phaserp0->labelsize(size11);
                  phaserp1->labelsize(size11);
                  phaserp2->labelsize(size11);
                  phaserp3->labelsize(size11);
                  phaserp5->labelsize(size11);
                  phaserp6->labelsize(size11);
                  phaserp7->labelsize(size11);
                  phaserp8->labelsize(size11);
                      phaserp8->textsize(size11);
                  phaserp9->labelsize(size11);
                  phaserp10->labelsize(size11);
                  phaserp11->labelsize(size11);
                  phaserp12->labelsize(size11);
                  phaserp13->labelsize(size11);
                  phaserp14->labelsize(size11);
                  phaserp17->labelsize(size11);
                  phaserp18->labelsize(size11);
                  break;
              case 5: // alienwah
                  alienname->labelsize(size12);
                  awp->labelsize(size11);
                      awp->textsize(size);
                  awp4->labelsize(size);
                      awp4->textsize(size9);
  
                  awp0->labelsize(size11);
                  awp1->labelsize(size11);
                  awp2->labelsize(size11);
                  awp3->labelsize(size11);
                  awp5->labelsize(size11);
                  awp6->labelsize(size11);
                  awp7->labelsize(size11);
                  awp9->labelsize(size11);
  
                  awp10->labelsize(size11);
                  awp8->labelsize(size11);
                      awp8->textsize(size11);
                  awp17->labelsize(size11);
                  awp18->labelsize(size11);
                  break;
              case 6: // distortion
                  distname->labelsize(size12);
                  distp->labelsize(size11);
                      distp->textsize(size);
                  distp5->labelsize(size);
                      distp5->textsize(size9);
  
                  distp0->labelsize(size11);
                  distp1->labelsize(size11);
                  distp2->labelsize(size11);
                  distp3->labelsize(size11);
                  distp4->labelsize(size11);
                  distp7->labelsize(size11);
                  distp8->labelsize(size11);
  
                  distp6->labelsize(size11);
                  distp9->labelsize(size11);
                  distp10->labelsize(size11);
                  break;
              case 7: // EQ
                  eqname->labelsize(size12);
                  eqp0->labelsize(size11);
                  bandcounter->labelsize(size11);
                      bandcounter->textsize(size11);
  
                  freqdial->labelsize(size11);
                  gaindial->labelsize(size11);
                  qdial->labelsize(size11);
                  stagescounter->labelsize(size);
                      stagescounter->textsize(size11);
  
                  typechoice->labelsize(size11);
                      typechoice->textsize(size9);
                  break;
              case 8: // dynfilter
                  dfname->labelsize(size12);
                  dfp->labelsize(size11);
                      dfp->textsize(size);
                  dfp4->labelsize(size);
                      dfp4->textsize(size9);
  
                  dfp0->labelsize(size11);
                  dfp1->labelsize(size11);
                  dfp2->labelsize(size11);
                  dfp3->labelsize(size11);
                  dfp5->labelsize(size11);
                  dfp6->labelsize(size11);
  
                  filter->labelsize(size11);
                  dfp7->labelsize(size11);
                  dfp8->labelsize(size11);
                  dfp9->labelsize(size11);
                  dfp17->labelsize(size11);
                  dfp18->labelsize(size11);
  
                  filterclose->labelsize(size12);
                  break;
              default:
                  break;
          }
}

void EffUI::Showfilt() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "xFilter-dynamic " + to_string(npart));
  
      if (fetchW < filtDW || fetchH < filtDH)
      {
          fetchW = filtDW;
          fetchH = filtDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, filtDW, filtDH);
      filterwindow->resize(fetchX, fetchY, fetchW, fetchH);
      filterwindow->show();
      lastfiltW = 0;
}

void EffUI::filtRtext() {
  //
      if (lastfiltW == filterwindow->w())
          return;
      lastfiltW = filterwindow->w();
  
      float dScale = filterwindow->w() / filtDW;
      if (dScale < 1.0f)
          dScale = 1.0f;
  
      filterclose->labelsize(12 * dScale);
  
      fwin_filterui->filterRtext(dScale);
  
      filterwindow->redraw();
}

void EffUI::EQbandUpdate() {
  //
      int npb = eqband * 5 + 10;
  
      int type = eff->geteffectpar(npb);
      typechoice->value(type);
  
      if (type == 0)
          bandgroup->deactivate();
      else
          bandgroup->activate();
  
      if (type > 2)
          qdial->activate();
      else
          qdial->deactivate();
  
      if (type > 6)
          gaindial->activate();
      else
          gaindial->deactivate();
  
      int freq = eff->geteffectpar(npb + 1);
      freqdial->value(freq);
  
      int gain = eff->geteffectpar(npb + 2);
      gaindial->value(gain);
  
      int q = eff->geteffectpar(npb + 3);
      qdial->value(q);
  
      int dbl = eff->geteffectpar(npb + 4);
      stagescounter->value(dbl);
}
