/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DefaultSSLContextSpi
extends ProvSSLContextSpi {
    static ProvSSLContextSpi getDefaultInstance() throws Exception {
        if (null != LazyInstance.initException) {
            throw LazyInstance.initException;
        }
        return LazyInstance.instance;
    }

    DefaultSSLContextSpi(boolean bl, JcaTlsCryptoProvider jcaTlsCryptoProvider) throws KeyManagementException {
        super(bl, jcaTlsCryptoProvider, null);
        if (null != LazyManagers.initException) {
            throw new KeyManagementException("Default key/trust managers unavailable", LazyManagers.initException);
        }
        super.engineInit(LazyManagers.keyManagers, LazyManagers.trustManagers, null);
    }

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        throw new KeyManagementException("Default SSLContext is initialized automatically");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class LazyInstance {
        private static final Exception initException;
        private static final DefaultSSLContextSpi instance;

        private LazyInstance() {
        }

        static {
            Exception exception = LazyManagers.initException;
            DefaultSSLContextSpi defaultSSLContextSpi = null;
            if (null == exception) {
                try {
                    defaultSSLContextSpi = new DefaultSSLContextSpi(false, new JcaTlsCryptoProvider());
                }
                catch (Exception exception2) {
                    exception = exception2;
                    defaultSSLContextSpi = null;
                }
            }
            initException = exception;
            instance = defaultSSLContextSpi;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class LazyManagers {
        private static final Exception initException;
        private static final KeyManager[] keyManagers;
        private static final TrustManager[] trustManagers;

        private LazyManagers() {
        }

        static {
            TrustManager[] trustManagerArray;
            KeyManager[] keyManagerArray;
            Exception exception = null;
            try {
                keyManagerArray = ProvSSLContextSpi.getDefaultKeyManagers();
                trustManagerArray = ProvSSLContextSpi.getDefaultTrustManagers();
            }
            catch (Exception exception2) {
                exception = exception2;
                keyManagerArray = null;
                trustManagerArray = null;
            }
            initException = exception;
            keyManagers = keyManagerArray;
            trustManagers = trustManagerArray;
        }
    }
}

