/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.security.SFile;

public class BaseFile {
    private final String basename;
    private final SFile basedir;

    public BaseFile(SFile file) {
        if (file == null) {
            this.basedir = null;
            this.basename = null;
        } else {
            this.basedir = file.getParentFile();
            this.basename = BaseFile.extractBasename(file.getName());
        }
    }

    private static String extractBasename(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return name;
        }
        return name.substring(0, idx);
    }

    public String toString() {
        if (this.basedir == null || this.basename == null) {
            return "(DEFAULT)";
        }
        return this.basedir + " " + this.basename;
    }

    public String getBasename() {
        return this.basename;
    }

    public SFile getBasedir() {
        return this.basedir;
    }

    public SFile getTraceFile(String tail) {
        if (this.basedir == null || this.basename == null) {
            return new SFile(tail);
        }
        return this.basedir.file(this.basename + "_" + tail);
    }
}

