/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ComponentStyle;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.PaddingParam;
import net.sourceforge.plantuml.SplitParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Padder;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.sprite.SpriteImage;
import net.sourceforge.plantuml.style.FromSkinparamToStyle;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleLoader;
import net.sourceforge.plantuml.svek.ConditionEndStyle;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svg.LengthAdjust;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperForceDark;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperLightnessInverse;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperReverse;
import net.sourceforge.plantuml.ugraphic.color.ColorOrder;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class SkinParam
implements ISkinParam {
    public static final String DEFAULT_PRESERVE_ASPECT_RATIO = "none";
    private String skin = "plantuml.skin";
    private StyleBuilder styleBuilder;
    private final ThemeStyle themeStyle;
    private static final String stereoPatternString = "\\<\\<(.*?)\\>\\>";
    private static final Pattern2 stereoPattern = MyPattern.cmpile("\\<\\<(.*?)\\>\\>");
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<String, String> paramsPendingForStyleMigration = new LinkedHashMap<String, String>();
    private final Map<String, String> svgCharSizes = new HashMap<String, String>();
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private final UmlDiagramType type;
    private boolean useVizJs;
    private final Map<String, List<String>> cacheCleanForKey = new HashMap<String, List<String>>();
    private final Map<String, Sprite> sprites = new HashMap<String, Sprite>();
    private final HColorSet htmlColorSet = HColorSet.instance();

    private SkinParam(UmlDiagramType type, ThemeStyle style) {
        this.themeStyle = style;
        this.type = type;
    }

    @Override
    public StyleBuilder getCurrentStyleBuilder() {
        if (this.styleBuilder == null) {
            try {
                this.styleBuilder = this.getCurrentStyleBuilderInternal();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.styleBuilder;
    }

    @Override
    public void muteStyle(Style modifiedStyle) {
        this.styleBuilder = this.getCurrentStyleBuilder().muteStyle(modifiedStyle);
    }

    @Override
    public String getDefaultSkin() {
        return this.skin;
    }

    @Override
    public void setDefaultSkin(String newSkin) {
        this.skin = newSkin;
    }

    public StyleBuilder getCurrentStyleBuilderInternal() throws IOException {
        StyleLoader tmp = new StyleLoader(this);
        StyleBuilder result = tmp.loadSkin(this.getDefaultSkin());
        if (result == null) {
            result = tmp.loadSkin("plantuml.skin");
        }
        return result;
    }

    public static int zeroMargin(int defaultValue) {
        return defaultValue;
    }

    @Override
    public void copyAllFrom(ISkinSimple other) {
        this.params.putAll(other.values());
    }

    @Override
    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.params);
    }

    public void setParam(String key, String value) {
        for (String key2 : this.cleanForKey(key)) {
            this.params.put(key2, StringUtils.trin(value));
            this.applyPendingStyleMigration();
            FromSkinparamToStyle convertor = new FromSkinparamToStyle(key2);
            convertor.convertNow(value, this.getCurrentStyleBuilder());
            for (Style style : convertor.getStyles()) {
                this.muteStyle(style);
            }
        }
        if ("style".equalsIgnoreCase(key) && "strictuml".equalsIgnoreCase(value)) {
            InputStream internalIs = StyleLoader.class.getResourceAsStream("/skin/strictuml.skin");
            StyleBuilder styleBuilder = this.getCurrentStyleBuilder();
            try {
                BlocLines lines = BlocLines.load(internalIs, null);
                for (Style modifiedStyle : StyleLoader.getDeclaredStyles(lines, styleBuilder)) {
                    this.muteStyle(modifiedStyle);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void applyPendingStyleMigration() {
        for (Map.Entry<String, String> ent : this.paramsPendingForStyleMigration.entrySet()) {
            FromSkinparamToStyle convertor = new FromSkinparamToStyle(ent.getKey());
            convertor.convertNow(ent.getValue(), this.getCurrentStyleBuilder());
            for (Style style : convertor.getStyles()) {
                this.muteStyle(style);
            }
        }
        this.paramsPendingForStyleMigration.clear();
    }

    public static SkinParam create(UmlDiagramType type, ThemeStyle style) {
        return new SkinParam(type, style);
    }

    public static SkinParam noShadowing(UmlDiagramType type, ThemeStyle style) {
        SkinParam result = new SkinParam(type, style);
        result.setParam("shadowing", "false");
        return result;
    }

    List<String> cleanForKey(String key) {
        List<String> result = this.cacheCleanForKey.get(key);
        if (result == null) {
            result = this.cleanForKeySlow(key);
            this.cacheCleanForKey.put(key, result);
        }
        return result;
    }

    List<String> cleanForKeySlow(String key) {
        key = StringUtils.trin(StringUtils.goLowerCase(key));
        key = key.replaceAll("_|\\.", "");
        key = SkinParam.replaceSmart(key, "sequenceparticipant", "participant");
        key = SkinParam.replaceSmart(key, "sequenceactor", "actor");
        key = key.replaceAll("activityarrow", "arrow");
        key = key.replaceAll("objectarrow", "arrow");
        key = key.replaceAll("classarrow", "arrow");
        key = key.replaceAll("componentarrow", "arrow");
        key = key.replaceAll("statearrow", "arrow");
        key = key.replaceAll("usecasearrow", "arrow");
        key = key.replaceAll("sequencearrow", "arrow");
        key = key.replaceAll("align$", "alignment");
        Matcher2 mm = stereoPattern.matcher(key);
        ArrayList<String> result = new ArrayList<String>();
        while (mm.find()) {
            String s = mm.group(1);
            result.add(key.replaceAll(stereoPatternString, "") + "<<" + s + ">>");
        }
        if (result.size() == 0) {
            result.add(key);
        }
        return Collections.unmodifiableList(result);
    }

    private static String replaceSmart(String s, String src, String target) {
        if (!s.contains(src)) {
            return s;
        }
        return s.replaceAll(src, target);
    }

    @Override
    public HColor getHyperlinkColor() {
        HColor result = this.getHtmlColor(ColorParam.hyperlink, null, false);
        if (result == null) {
            return HColorUtils.BLUE;
        }
        return result;
    }

    @Override
    public HColor getBackgroundColor() {
        HColor result = this.getHtmlColor(ColorParam.background, null, false);
        return result != null ? result : HColorUtils.WHITE;
    }

    @Override
    public String getValue(String key) {
        this.applyPendingStyleMigration();
        for (String key2 : this.cleanForKey(key)) {
            String result = this.params.get(key2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getValue(String key, String defaultValue) {
        String result = this.getValue(key);
        return result == null ? defaultValue : result;
    }

    private boolean valueIs(String key, String expected) {
        return expected.equalsIgnoreCase(this.getValue(key));
    }

    private boolean isTrue(String key) {
        return this.valueIs(key, "true");
    }

    static String humanName(String key) {
        StringBuilder sb = new StringBuilder();
        boolean upper = true;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '_') {
                upper = true;
                continue;
            }
            sb.append(upper ? StringUtils.goUpperCase(c) : StringUtils.goLowerCase(c));
            upper = false;
        }
        return sb.toString();
    }

    @Override
    public HColor getHtmlColor(ColorParam param, Stereotype stereotype, boolean clickable) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            for (String s : stereotype.getMultipleLabels()) {
                String value2 = this.getValue(param.name() + "color<<" + s + ">>");
                if (value2 == null || this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, value2) == null) continue;
                return this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, value2);
            }
        }
        if ((value = this.getValue(this.getParamName(param, clickable))) == null) {
            return null;
        }
        if ((param == ColorParam.background || param == ColorParam.arrowHead) && (value.equalsIgnoreCase("transparent") || value.equalsIgnoreCase(DEFAULT_PRESERVE_ASPECT_RATIO))) {
            return HColorUtils.transparent();
        }
        if (param == ColorParam.background) {
            return this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, value);
        }
        assert (param != ColorParam.background);
        return this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, value, this.getBackgroundColor());
    }

    @Override
    public char getCircledCharacter(Stereotype stereotype) {
        String value2 = this.getValue("spotchar" + Objects.requireNonNull(stereotype).getLabel(Guillemet.DOUBLE_COMPARATOR));
        if (value2 != null && value2.length() > 0) {
            return value2.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public Colors getColors(ColorParam param, Stereotype stereotype) throws NoSuchColorException {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue(param.name() + "color" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
            if (value2 != null) {
                return new Colors(this.themeStyle, value2, this.getIHtmlColorSet(), param.getColorType());
            }
        }
        if ((value = this.getValue(this.getParamName(param, false))) == null) {
            return Colors.empty();
        }
        return new Colors(this.themeStyle, value, this.getIHtmlColorSet(), param.getColorType());
    }

    private String getParamName(ColorParam param, boolean clickable) {
        String n = param.name();
        if (clickable && n.endsWith("Background")) {
            n = n.replaceAll("Background", "ClickableBackground");
        } else if (clickable && n.endsWith("Border")) {
            n = n.replaceAll("Border", "ClickableBorder");
        }
        return n + "color";
    }

    private void checkStereotype(Stereotype stereotype) {
    }

    private int getFontSize(Stereotype stereotype, FontParam ... param) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getFirstValueNonNullWithSuffix("fontsize" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR), param);
            if (value2 != null && value2.matches("\\d+")) {
                return Integer.parseInt(value2);
            }
        }
        if ((value = this.getFirstValueNonNullWithSuffix("fontsize", param)) == null || !value.matches("\\d+")) {
            value = this.getValue("defaultfontsize");
        }
        if (value == null || !value.matches("\\d+")) {
            return param[0].getDefaultSize(this);
        }
        return Integer.parseInt(value);
    }

    private String getFontFamily(Stereotype stereotype, FontParam ... param) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getFirstValueNonNullWithSuffix("fontname" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR), param);
            if (value2 != null) {
                return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value2);
            }
        }
        if ((value = this.getFirstValueNonNullWithSuffix("fontname", param)) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value);
        }
        if (param[0] != FontParam.CIRCLED_CHARACTER && (value = this.getValue("defaultfontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value);
        }
        return param[0].getDefaultFamily();
    }

    @Override
    public HColor getFontHtmlColor(Stereotype stereotype, FontParam ... param) {
        String value = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value = this.getFirstValueNonNullWithSuffix("fontcolor" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR), param);
        }
        if (value == null) {
            value = this.getFirstValueNonNullWithSuffix("fontcolor", param);
        }
        if (value == null) {
            value = this.getValue("defaultfontcolor");
        }
        if (value == null) {
            value = param[0].getDefaultColor();
        }
        if (value == null) {
            return null;
        }
        return this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, value);
    }

    private String getFirstValueNonNullWithSuffix(String suffix, FontParam ... param) {
        for (FontParam p : param) {
            String v = this.getValue(p.name() + suffix);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private int getFontStyle(Stereotype stereotype, boolean inPackageTitle, FontParam ... param) {
        String value = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value = this.getFirstValueNonNullWithSuffix("fontstyle" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR), param);
        }
        if (value == null) {
            value = this.getFirstValueNonNullWithSuffix("fontstyle", param);
        }
        if (value == null) {
            value = this.getValue("defaultfontstyle");
        }
        if (value == null) {
            return param[0].getDefaultFontStyle(this, inPackageTitle);
        }
        int result = 0;
        if (StringUtils.goLowerCase(value).contains("bold")) {
            result |= 1;
        }
        if (StringUtils.goLowerCase(value).contains("italic")) {
            result |= 2;
        }
        return result;
    }

    @Override
    public UFont getFont(Stereotype stereotype, boolean inPackageTitle, FontParam ... fontParam) {
        if (stereotype != null) {
            this.checkStereotype(stereotype);
        }
        String fontFamily = this.getFontFamily(stereotype, fontParam);
        int fontStyle = this.getFontStyle(stereotype, inPackageTitle, fontParam);
        int fontSize = this.getFontSize(stereotype, fontParam);
        return new UFont(fontFamily, fontStyle, fontSize);
    }

    @Override
    public int getCircledCharacterRadius() {
        int value = this.getAsInt("circledCharacterRadius", -1);
        return value == -1 ? this.getFontSize(null, FontParam.CIRCLED_CHARACTER) / 3 + 6 : value;
    }

    @Override
    public int classAttributeIconSize() {
        return this.getAsInt("classAttributeIconSize", 10);
    }

    public static Collection<String> getPossibleValues() {
        String h;
        TreeSet<String> result = new TreeSet<String>();
        result.add("Monochrome");
        result.add("CircledCharacterRadius");
        result.add("ClassAttributeIconSize");
        result.add("DefaultFontName");
        result.add("DefaultFontStyle");
        result.add("DefaultFontSize");
        result.add("DefaultFontColor");
        result.add("MinClassWidth");
        result.add("MinClassWidth");
        result.add("Dpi");
        result.add("DefaultTextAlignment");
        result.add("Shadowing");
        result.add("NoteShadowing");
        result.add("Handwritten");
        result.add("CircledCharacterRadius");
        result.add("ClassAttributeIconSize");
        result.add("Linetype");
        result.add("PackageStyle");
        result.add("ComponentStyle");
        result.add("StereotypePosition");
        result.add("Nodesep");
        result.add("Ranksep");
        result.add("RoundCorner");
        result.add("TitleBorderRoundCorner");
        result.add("MaxMessageSize");
        result.add("Style");
        result.add("SequenceParticipant");
        result.add("ConditionStyle");
        result.add("ConditionEndStyle");
        result.add("SameClassWidth");
        result.add("HyperlinkUnderline");
        result.add("Padding");
        result.add("BoxPadding");
        result.add("ParticipantPadding");
        result.add("Guillemet");
        result.add("SvglinkTarget");
        result.add("DefaultMonospacedFontName");
        result.add("TabSize");
        result.add("MaxAsciiMessageLength");
        result.add("ColorArrowSeparationSpace");
        result.add("ResponseMessageBelowArrow");
        result.add("GenericDisplay");
        result.add("PathHoverColor");
        result.add("SwimlaneWidth");
        result.add("PageBorderColor");
        result.add("PageExternalColor");
        result.add("PageMargin");
        result.add("WrapWidth");
        result.add("SwimlaneWidth");
        result.add("SwimlaneWrapTitleWidth");
        result.add("FixCircleLabelOverlapping");
        result.add("LifelineStrategy");
        for (FontParam fontParam : EnumSet.allOf(FontParam.class)) {
            h = SkinParam.humanName(fontParam.name());
            result.add(h + "FontStyle");
            result.add(h + "FontName");
            result.add(h + "FontSize");
            result.add(h + "FontColor");
        }
        for (ColorParam colorParam : EnumSet.allOf(ColorParam.class)) {
            h = SkinParam.capitalize(colorParam.name());
            result.add(h + "Color");
        }
        for (LineParam lineParam : EnumSet.allOf(LineParam.class)) {
            h = SkinParam.capitalize(lineParam.name());
            result.add(h + "Thickness");
        }
        for (AlignmentParam alignmentParam : EnumSet.allOf(AlignmentParam.class)) {
            h = SkinParam.capitalize(alignmentParam.name());
            result.add(h);
        }
        return Collections.unmodifiableSet(result);
    }

    private static String capitalize(String name) {
        return StringUtils.goUpperCase(name.substring(0, 1)) + name.substring(1);
    }

    @Override
    public int getDpi() {
        int defaultValue = 96;
        int dpi = this.getAsInt("dpi", 96);
        if (dpi <= 0) {
            return 96;
        }
        return dpi;
    }

    @Override
    public DotSplines getDotSplines() {
        String value = this.getValue("linetype");
        if ("polyline".equalsIgnoreCase(value)) {
            return DotSplines.POLYLINE;
        }
        if ("ortho".equalsIgnoreCase(value)) {
            return DotSplines.ORTHO;
        }
        return DotSplines.SPLINES;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment(AlignmentParam param, ArrowDirection arrowDirection, boolean isReverseDefine, HorizontalAlignment overrideDefault) {
        HorizontalAlignment result;
        String value;
        switch (param) {
            case sequenceMessageAlignment: {
                value = this.getArg(this.getValue(AlignmentParam.sequenceMessageAlignment.name()), 0);
                break;
            }
            case sequenceMessageTextAlignment: {
                value = this.getArg(this.getValue(AlignmentParam.sequenceMessageAlignment.name()), 1);
                break;
            }
            default: {
                value = this.getValue(param.name());
            }
        }
        if ("first".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                if (isReverseDefine) {
                    return HorizontalAlignment.LEFT;
                }
                return HorizontalAlignment.RIGHT;
            }
            if (isReverseDefine) {
                return HorizontalAlignment.RIGHT;
            }
            return HorizontalAlignment.LEFT;
        }
        if ("direction".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                return HorizontalAlignment.LEFT;
            }
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                return HorizontalAlignment.RIGHT;
            }
            if (arrowDirection == ArrowDirection.BOTH_DIRECTION) {
                return HorizontalAlignment.CENTER;
            }
        }
        if ("reversedirection".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                return HorizontalAlignment.RIGHT;
            }
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                return HorizontalAlignment.LEFT;
            }
            if (arrowDirection == ArrowDirection.BOTH_DIRECTION) {
                return HorizontalAlignment.CENTER;
            }
        }
        if ((result = HorizontalAlignment.fromString(value)) == null && param == AlignmentParam.noteTextAlignment) {
            return this.getDefaultTextAlignment(overrideDefault == null ? HorizontalAlignment.LEFT : overrideDefault);
        }
        if (result == null && param == AlignmentParam.stateMessageAlignment) {
            return this.getDefaultTextAlignment(HorizontalAlignment.CENTER);
        }
        if (result == null) {
            return param.getDefaultValue();
        }
        return result;
    }

    @Override
    public HorizontalAlignment getDefaultTextAlignment(HorizontalAlignment defaultValue) {
        String value = this.getValue("defaulttextalignment");
        HorizontalAlignment result = HorizontalAlignment.fromString(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Override
    public HorizontalAlignment getStereotypeAlignment() {
        String value = this.getValue("stereotypealignment");
        HorizontalAlignment result = HorizontalAlignment.fromString(value);
        if (result == null) {
            return HorizontalAlignment.CENTER;
        }
        return result;
    }

    private String getArg(String value, int i) {
        if (value == null) {
            return null;
        }
        String[] split = value.split(":");
        if (i >= split.length) {
            return split[0];
        }
        return split[i];
    }

    @Override
    public ColorMapper getColorMapper() {
        if (this.themeStyle == ThemeStyle.DARK) {
            return new ColorMapperForceDark();
        }
        String monochrome = this.getValue("monochrome");
        if ("true".equals(monochrome)) {
            return new ColorMapperMonochrome(false);
        }
        if ("reverse".equals(monochrome)) {
            return new ColorMapperMonochrome(true);
        }
        String value = this.getValue("reversecolor");
        if (value == null) {
            return new ColorMapperIdentity();
        }
        if ("dark".equalsIgnoreCase(value)) {
            return new ColorMapperLightnessInverse();
        }
        ColorOrder order = ColorOrder.fromString(value);
        if (order == null) {
            return new ColorMapperIdentity();
        }
        return new ColorMapperReverse(order);
    }

    @Override
    public boolean shadowing(Stereotype stereotype) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue("shadowing" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
            if (value2 != null) {
                return value2.equalsIgnoreCase("true");
            }
        }
        if ("false".equalsIgnoreCase(value = this.getValue("shadowing"))) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public boolean shadowingForNote(Stereotype stereotype) {
        String value2;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value2 = this.getValue("noteshadowing" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
            if (value2 != null) {
                return value2.equalsIgnoreCase("true");
            }
        }
        if ((value2 = this.getValue("noteshadowing")) != null) {
            return value2.equalsIgnoreCase("true");
        }
        return this.shadowing(stereotype);
    }

    @Override
    public Collection<String> getAllSpriteNames() {
        return Collections.unmodifiableCollection(new TreeSet<String>(this.sprites.keySet()));
    }

    public void addSprite(String name, Sprite sprite) {
        this.sprites.put(name, sprite);
    }

    @Override
    public Sprite getSprite(String name) {
        Sprite result = this.sprites.get(name);
        if (result == null) {
            result = SpriteImage.fromInternal(name);
        }
        return result;
    }

    @Override
    public PackageStyle packageStyle() {
        String value = this.getValue("packageStyle");
        PackageStyle p = PackageStyle.fromString(value);
        if (p == null) {
            return PackageStyle.FOLDER;
        }
        return p;
    }

    @Override
    public ComponentStyle componentStyle() {
        if (this.strictUmlStyle()) {
            return ComponentStyle.UML2;
        }
        String value = this.getValue("componentstyle");
        if ("uml1".equalsIgnoreCase(value)) {
            return ComponentStyle.UML1;
        }
        if ("uml2".equalsIgnoreCase(value)) {
            return ComponentStyle.UML2;
        }
        if ("rectangle".equalsIgnoreCase(value)) {
            return ComponentStyle.RECTANGLE;
        }
        return ComponentStyle.UML2;
    }

    @Override
    public boolean stereotypePositionTop() {
        return !this.valueIs("stereotypePosition", "bottom");
    }

    @Override
    public boolean useSwimlanes(UmlDiagramType type) {
        if (type != UmlDiagramType.ACTIVITY) {
            return false;
        }
        return this.swimlanes();
    }

    public boolean swimlanes() {
        return this.isTrue("swimlane") || this.isTrue("swimlanes");
    }

    @Override
    public double getNodesep() {
        return this.getAsInt("nodesep", 0);
    }

    @Override
    public double getRanksep() {
        return this.getAsInt("ranksep", 0);
    }

    @Override
    public double getDiagonalCorner(CornerParam param, Stereotype stereotype) {
        String key = param.getDiagonalKey();
        Double result = this.getCornerInternal(key, param, stereotype);
        if (result != null) {
            return result;
        }
        result = this.getCornerInternal(key, param, null);
        if (result != null) {
            return result;
        }
        if (param == CornerParam.DEFAULT) {
            return 0.0;
        }
        return this.getDiagonalCorner(CornerParam.DEFAULT, stereotype);
    }

    @Override
    public double getRoundCorner(CornerParam param, Stereotype stereotype) {
        String key = param.getRoundKey();
        Double result = this.getCornerInternal(key, param, stereotype);
        if (result != null) {
            return result;
        }
        result = this.getCornerInternal(key, param, null);
        if (result != null) {
            return result;
        }
        if (param == CornerParam.DEFAULT) {
            return 0.0;
        }
        return this.getRoundCorner(CornerParam.DEFAULT, stereotype);
    }

    private Double getCornerInternal(String key, CornerParam param, Stereotype stereotype) {
        String value;
        if (stereotype != null) {
            key = key + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR);
        }
        if ((value = this.getValue(key)) != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return null;
    }

    @Override
    public UStroke getThickness(LineParam param, Stereotype stereotype) {
        String styleValue;
        String value;
        LinkStyle style = null;
        if (stereotype != null) {
            String value2;
            this.checkStereotype(stereotype);
            String styleValue2 = this.getValue(param.name() + "style" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
            if (styleValue2 != null) {
                style = LinkStyle.fromString2(styleValue2);
            }
            if ((value2 = this.getValue(param.name() + "thickness" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR))) != null && value2.matches("[\\d.]+")) {
                if (style == null) {
                    style = LinkStyle.NORMAL();
                }
                return style.goThickness(Double.parseDouble(value2)).getStroke3();
            }
        }
        if ((value = this.getValue(param.name() + "thickness")) != null && value.matches("[\\d.]+")) {
            if (style == null) {
                style = LinkStyle.NORMAL();
            }
            return style.goThickness(Double.parseDouble(value)).getStroke3();
        }
        if (style == null && (styleValue = this.getValue(param.name() + "style")) != null) {
            style = LinkStyle.fromString2(styleValue);
        }
        if (style != null && !style.isNormal()) {
            return style.getStroke3();
        }
        return null;
    }

    @Override
    public LineBreakStrategy maxMessageSize() {
        String value = this.getValue("wrapmessagewidth");
        if (value == null) {
            value = this.getValue("maxmessagesize");
        }
        return new LineBreakStrategy(value);
    }

    @Override
    public LineBreakStrategy wrapWidth() {
        String value = this.getValue("wrapwidth");
        return new LineBreakStrategy(value);
    }

    @Override
    public LineBreakStrategy swimlaneWrapTitleWidth() {
        String value = this.getValue("swimlanewraptitlewidth");
        return new LineBreakStrategy(value);
    }

    @Override
    public boolean strictUmlStyle() {
        return this.valueIs("style", "strictuml");
    }

    @Override
    public boolean forceSequenceParticipantUnderlined() {
        return this.valueIs("sequenceParticipant", "underline");
    }

    @Override
    public ConditionStyle getConditionStyle() {
        String value = this.getValue("conditionStyle");
        ConditionStyle p = ConditionStyle.fromString(value);
        if (p == null) {
            return ConditionStyle.INSIDE_HEXAGON;
        }
        return p;
    }

    @Override
    public ConditionEndStyle getConditionEndStyle() {
        String value = this.getValue("conditionEndStyle");
        ConditionEndStyle p = ConditionEndStyle.fromString(value);
        if (p == null) {
            return ConditionEndStyle.DIAMOND;
        }
        return p;
    }

    @Override
    public double minClassWidth() {
        return this.getAsInt("minclasswidth", 0);
    }

    @Override
    public boolean sameClassWidth() {
        return this.isTrue("sameclasswidth");
    }

    @Override
    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    public boolean useOctagonForActivity(Stereotype stereotype) {
        String value = this.getValue("activityshape");
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue("activityshape" + stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
            if (value2 != null) {
                value = value2;
            }
        }
        if ("roundedbox".equalsIgnoreCase(value)) {
            return false;
        }
        return "octagon".equalsIgnoreCase(value);
    }

    @Override
    public HColorSet getIHtmlColorSet() {
        return this.htmlColorSet;
    }

    @Override
    public boolean useUnderlineForHyperlink() {
        return !this.valueIs("hyperlinkunderline", "false");
    }

    @Override
    public int groupInheritance() {
        int value = this.getAsInt("groupinheritance", Integer.MAX_VALUE);
        return value <= 1 ? Integer.MAX_VALUE : value;
    }

    @Override
    public Guillemet guillemet() {
        String value = this.getValue("guillemet");
        return Guillemet.GUILLEMET.fromDescription(value);
    }

    @Override
    public boolean handwritten() {
        return this.isTrue("handwritten");
    }

    @Override
    public String getSvgLinkTarget() {
        return this.getValue("svglinktarget", "_top");
    }

    @Override
    public String getPreserveAspectRatio() {
        return this.getValue("preserveaspectratio", DEFAULT_PRESERVE_ASPECT_RATIO);
    }

    @Override
    public String getMonospacedFamily() {
        return this.getValue("defaultMonospacedFontName", "monospaced");
    }

    @Override
    public int getTabSize() {
        return this.getAsInt("tabsize", 8);
    }

    @Override
    public int maxAsciiMessageLength() {
        return this.getAsInt("maxasciimessagelength", -1);
    }

    @Override
    public int colorArrowSeparationSpace() {
        return this.getAsInt("colorarrowseparationspace", 0);
    }

    @Override
    public SplitParam getSplitParam() {
        String border = this.getValue("pageBorderColor");
        String external = this.getValue("pageExternalColor");
        HColor borderColor = border == null ? null : this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, border);
        HColor externalColor = external == null ? null : this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, external);
        int margin = this.getAsInt("pageMargin", 0);
        return new SplitParam(borderColor, externalColor, margin);
    }

    @Override
    public int swimlaneWidth() {
        String value = this.getValue("swimlanewidth");
        if ("same".equalsIgnoreCase(value)) {
            return -1;
        }
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return this.type;
    }

    @Override
    public HColor hoverPathColor() {
        String value = this.getValue("pathhovercolor");
        if (value == null) {
            return null;
        }
        return this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, value, null);
    }

    @Override
    public double getPadding() {
        String name = "padding";
        return this.getAsDouble("padding");
    }

    @Override
    public double getPadding(PaddingParam param) {
        String name = param.getSkinName();
        return this.getAsDouble(name);
    }

    private double getAsDouble(String name) {
        String value = this.getValue(name);
        if (value != null && value.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    private int getAsInt(String key, int defaultValue) {
        String value = this.getValue(key);
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    @Override
    public boolean useRankSame() {
        return false;
    }

    @Override
    public boolean displayGenericWithOldFashion() {
        return this.valueIs("genericDisplay", "old");
    }

    @Override
    public boolean responseMessageBelowArrow() {
        return this.isTrue("responsemessagebelowarrow");
    }

    @Override
    public TikzFontDistortion getTikzFontDistortion() {
        String value = this.getValue("tikzFont");
        return TikzFontDistortion.fromValue(value);
    }

    @Override
    public boolean svgDimensionStyle() {
        return !this.valueIs("svgdimensionstyle", "false");
    }

    @Override
    public boolean fixCircleLabelOverlapping() {
        return this.isTrue("fixcirclelabeloverlapping");
    }

    @Override
    public void setUseVizJs(boolean useVizJs) {
        this.useVizJs = useVizJs;
    }

    @Override
    public boolean isUseVizJs() {
        return this.useVizJs;
    }

    @Override
    public Padder sequenceDiagramPadder() {
        double padding = this.getAsDouble("SequenceMessagePadding");
        double margin = this.getAsDouble("SequenceMessageMargin");
        String borderColor = this.getValue("SequenceMessageBorderColor");
        String backgroundColor = this.getValue("SequenceMessageBackGroundColor");
        if (padding == 0.0 && margin == 0.0 && borderColor == null && backgroundColor == null) {
            return Padder.NONE;
        }
        HColor border = borderColor == null ? null : this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, borderColor);
        HColor background = backgroundColor == null ? null : this.getIHtmlColorSet().getColorOrWhite(this.themeStyle, backgroundColor);
        double roundCorner = this.getRoundCorner(CornerParam.DEFAULT, null);
        return Padder.NONE.withMargin(margin).withPadding(padding).withBackgroundColor(background).withBorderColor(border).withRoundCorner(roundCorner);
    }

    @Override
    public ActorStyle actorStyle() {
        String value = this.getValue("actorstyle");
        if ("awesome".equalsIgnoreCase(value)) {
            return ActorStyle.AWESOME;
        }
        if ("hollow".equalsIgnoreCase(value)) {
            return ActorStyle.HOLLOW;
        }
        return ActorStyle.STICKMAN;
    }

    @Override
    public void setSvgSize(String origin, String sizeToUse) {
        this.svgCharSizes.put(StringUtils.manageUnicodeNotationUplus(origin), StringUtils.manageUnicodeNotationUplus(sizeToUse));
    }

    @Override
    public String transformStringForSizeHack(String s) {
        for (Map.Entry<String, String> ent : this.svgCharSizes.entrySet()) {
            s = s.replace(ent.getKey(), ent.getValue());
        }
        return s;
    }

    @Override
    public LengthAdjust getlengthAdjust() {
        String value = this.getValue("lengthAdjust");
        if ("spacingAndGlyphs".equalsIgnoreCase(value)) {
            return LengthAdjust.SPACING_AND_GLYPHS;
        }
        if ("spacing".equalsIgnoreCase(value)) {
            return LengthAdjust.SPACING;
        }
        if (DEFAULT_PRESERVE_ASPECT_RATIO.equalsIgnoreCase(value)) {
            return LengthAdjust.NONE;
        }
        return LengthAdjust.defaultValue();
    }

    @Override
    public ThemeStyle getThemeStyle() {
        return this.themeStyle;
    }
}

