/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamDelegator;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SkinParamBackcolored
extends SkinParamDelegator {
    private final HColor backColorElement;
    private final HColor backColorGeneral;
    private final boolean forceClickage;
    private final Map<ColorParam, HColor> forced = new EnumMap<ColorParam, HColor>(ColorParam.class);

    public SkinParamBackcolored(ISkinParam skinParam, HColor backColorElement) {
        this(skinParam, backColorElement, null, false);
    }

    public SkinParamBackcolored(ISkinParam skinParam, HColor backColorElement, boolean forceClickage) {
        this(skinParam, backColorElement, null, forceClickage);
    }

    public SkinParamBackcolored(ISkinParam skinParam, HColor backColorElement, HColor backColorGeneral) {
        this(skinParam, backColorElement, backColorGeneral, false);
    }

    public String toString() {
        return super.toString() + " " + this.backColorElement + " " + this.backColorGeneral;
    }

    public SkinParamBackcolored(ISkinParam skinParam, HColor backColorElement, HColor backColorGeneral, boolean forceClickage) {
        super(skinParam);
        this.forceClickage = forceClickage;
        this.backColorElement = backColorElement;
        this.backColorGeneral = backColorGeneral;
    }

    @Override
    public HColor getBackgroundColor() {
        if (this.backColorGeneral != null) {
            return this.backColorGeneral;
        }
        return super.getBackgroundColor();
    }

    @Override
    public HColor getHtmlColor(ColorParam param, Stereotype stereotype, boolean clickable) {
        HColor c1;
        if (param.isBackground() && this.backColorElement != null) {
            return this.backColorElement;
        }
        if (this.forceClickage && (c1 = super.getHtmlColor(param, stereotype, true)) != null) {
            return c1;
        }
        HColor forcedColor = this.forced.get((Object)param);
        if (forcedColor != null) {
            return forcedColor;
        }
        return super.getHtmlColor(param, stereotype, clickable);
    }

    public void forceColor(ColorParam param, HColor color) {
        this.forced.put(param, color);
    }
}

