/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Padder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class AbstractComponentRoseArrow
extends AbstractTextualComponent
implements ArrowComponent {
    private final int arrowDeltaX = 10;
    private final int arrowDeltaY = 4;
    private final HColor foregroundColor;
    private final ArrowConfiguration arrowConfiguration;

    public AbstractComponentRoseArrow(Style style, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        super(style, maxMessageSize, 7, 7, 1, spriteContainer, stringsToDisplay, false);
        this.foregroundColor = style.value(PName.LineColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        this.arrowConfiguration = arrowConfiguration.withThickness(stroke.getThickness());
    }

    @Override
    protected final TextBlock getTextBlock() {
        Padder padder = this.getISkinSimple() instanceof ISkinParam ? ((ISkinParam)this.getISkinSimple()).sequenceDiagramPadder() : Padder.NONE;
        return padder.apply(super.getTextBlock());
    }

    @Override
    public abstract double getYPoint(StringBounder var1);

    protected final HColor getForegroundColor() {
        return this.foregroundColor;
    }

    protected final int getArrowDeltaX() {
        return 10;
    }

    protected final int getArrowDeltaY() {
        return 4;
    }

    @Override
    public final double getPaddingY() {
        return 4.0;
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }
}

