/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class WildcardBinding
extends ReferenceBinding {
    public ReferenceBinding genericType;
    public int rank;
    public TypeBinding bound;
    public TypeBinding[] otherBounds;
    char[] genericSignature;
    public int boundKind;
    ReferenceBinding superclass;
    ReferenceBinding[] superInterfaces;
    TypeVariableBinding typeVariable;
    LookupEnvironment environment;
    boolean inRecursiveFunction = false;

    public WildcardBinding(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, LookupEnvironment lookupEnvironment) {
        this.rank = n;
        this.boundKind = n2;
        this.modifiers = 0x40000001;
        this.environment = lookupEnvironment;
        this.initialize(referenceBinding, typeBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
        }
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        }
        this.tagBits |= 0x1000000L;
        this.typeBits = 0x8000000;
    }

    @Override
    TypeBinding bound() {
        return this.bound;
    }

    @Override
    int boundKind() {
        return this.boundKind;
    }

    public TypeBinding allBounds() {
        if (this.otherBounds == null || this.otherBounds.length == 0) {
            return this.bound;
        }
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[this.otherBounds.length + 1];
        try {
            referenceBindingArray[0] = (ReferenceBinding)this.bound;
            System.arraycopy(this.otherBounds, 0, referenceBindingArray, 1, this.otherBounds.length);
        }
        catch (ArrayStoreException | ClassCastException runtimeException) {
            return this.bound;
        }
        return this.environment.createIntersectionType18(referenceBindingArray);
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.tagBits |= 0x200000L;
        if (annotationBindingArray != null && annotationBindingArray.length != 0) {
            this.typeAnnotations = annotationBindingArray;
        }
        if (bl) {
            this.evaluateNullAnnotations(null, null);
        }
    }

    public void evaluateNullAnnotations(Scope scope, Wildcard wildcard) {
        long l;
        TypeVariableBinding typeVariableBinding;
        long l2 = this.determineNullBitsFromDeclaration(scope, wildcard);
        if (l2 == 0L && (typeVariableBinding = this.typeVariable()) != null && (l = typeVariableBinding.tagBits & 0x180000000000000L) != 0L) {
            l2 = l;
        }
        if (l2 != 0L) {
            this.tagBits = this.tagBits & 0xFE7FFFFFFFFFFFFFL | l2 | 0x100000L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long determineNullBitsFromDeclaration(Scope scope, Wildcard wildcard) {
        long l;
        block16: {
            long l2;
            Object object;
            block17: {
                block18: {
                    l = 0L;
                    AnnotationBinding[] annotationBindingArray = this.typeAnnotations;
                    if (annotationBindingArray != null) {
                        for (AnnotationBinding object22 : annotationBindingArray) {
                            if (object22 == null) continue;
                            if (object22.type.hasNullBit(64)) {
                                if ((l & 0x100000000000000L) == 0L) {
                                    l |= 0x80000000000000L;
                                    continue;
                                }
                                if (wildcard == null || (object = wildcard.findAnnotation(0x80000000000000L)) == null) continue;
                                scope.problemReporter().contradictoryNullAnnotations((Annotation)object);
                                continue;
                            }
                            if (!object22.type.hasNullBit(32)) continue;
                            if ((l & 0x80000000000000L) == 0L) {
                                l |= 0x100000000000000L;
                                continue;
                            }
                            if (wildcard == null || (object = wildcard.findAnnotation(0x100000000000000L)) == null) continue;
                            scope.problemReporter().contradictoryNullAnnotations((Annotation)object);
                        }
                    }
                    if (this.bound == null || !this.bound.isValidBinding() || (l2 = this.bound.tagBits & 0x180000000000000L) == 0L) break block16;
                    if (this.boundKind != 2) break block17;
                    if ((l2 & 0x80000000000000L) == 0L) break block16;
                    if (l != 0L) break block18;
                    l = 0x80000000000000L;
                    break block16;
                }
                if (wildcard == null || (l & 0x100000000000000L) == 0L) break block16;
                Annotation i = wildcard.bound.findAnnotation(l2);
                if (i == null) {
                    this.bound = object = this.bound.withoutToplevelNullAnnotation();
                    wildcard.bound.resolvedType = object;
                } else {
                    scope.problemReporter().contradictoryNullAnnotationsOnBounds(i, l);
                }
                break block16;
            }
            if ((l2 & 0x100000000000000L) != 0L) {
                if (l == 0L) {
                    l = 0x100000000000000L;
                } else if (wildcard != null && (l & 0x80000000000000L) != 0L) {
                    Annotation annotation = wildcard.bound.findAnnotation(l2);
                    if (annotation == null) {
                        this.bound = object = this.bound.withoutToplevelNullAnnotation();
                        wildcard.bound.resolvedType = object;
                    } else {
                        scope.problemReporter().contradictoryNullAnnotationsOnBounds(annotation, l);
                    }
                }
            }
            if (l == 0L && this.otherBounds != null) {
                void var8_13;
                boolean bl = false;
                int n = this.otherBounds.length;
                while (var8_13 < n) {
                    if ((this.otherBounds[var8_13].tagBits & 0x100000000000000L) != 0L) {
                        l = 0x100000000000000L;
                        break;
                    }
                    ++var8_13;
                }
            }
        }
        return l;
    }

    @Override
    public ReferenceBinding actualType() {
        return this.genericType;
    }

    @Override
    TypeBinding[] additionalBounds() {
        return this.otherBounds;
    }

    @Override
    public int kind() {
        return this.otherBounds == null ? 516 : 8196;
    }

    public boolean boundCheck(TypeBinding typeBinding) {
        switch (this.boundKind) {
            case 0: {
                return true;
            }
            case 1: {
                int n;
                if (!typeBinding.isCompatibleWith(this.bound)) {
                    return false;
                }
                int n2 = n = this.otherBounds == null ? 0 : this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    if (typeBinding.isCompatibleWith(this.otherBounds[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return typeBinding.isCompatibleWith(this.bound);
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public List<TypeBinding> collectMissingTypes(List<TypeBinding> list) {
        if ((this.tagBits & 0x80L) != 0L) {
            list = this.bound.collectMissingTypes(list);
        }
        return list;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        block82: {
            ReferenceBinding referenceBinding;
            if ((this.tagBits & 0x20000000L) == 0L) {
                return;
            }
            if (typeBinding == TypeBinding.NULL || typeBinding.kind() == 65540) {
                return;
            }
            if (typeBinding.isCapture()) {
                referenceBinding = (CaptureBinding)typeBinding;
                typeBinding = referenceBinding.wildcard;
            }
            block0 : switch (n) {
                case 1: {
                    block5 : switch (this.boundKind) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            block10 : switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block10;
                                        }
                                        case 1: {
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 1);
                                            break block10;
                                        }
                                    }
                                    break;
                                }
                                case 8196: {
                                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 1);
                                    int n2 = wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n2; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], inferenceContext, 1);
                                    }
                                    break block0;
                                }
                                default: {
                                    this.bound.collectSubstitutes(scope, typeBinding, inferenceContext, 1);
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block5;
                                        }
                                        case 1: {
                                            break block5;
                                        }
                                        case 2: {
                                            int n3;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 2);
                                            int n4 = n3 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n3; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 2);
                                            }
                                            break;
                                        }
                                    }
                                    break block5;
                                }
                                case 8196: {
                                    break block5;
                                }
                            }
                            this.bound.collectSubstitutes(scope, typeBinding, inferenceContext, 2);
                        }
                    }
                    break;
                }
                case 0: {
                    block27 : switch (this.boundKind) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            int n5;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 0);
                                            int n6 = n5 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n5; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 0);
                                            }
                                            break block0;
                                        }
                                    }
                                    break block0;
                                }
                                case 8196: {
                                    int n7;
                                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 0);
                                    int n8 = n7 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n7; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], inferenceContext, 0);
                                    }
                                    break block0;
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block27;
                                        }
                                        case 1: {
                                            break block27;
                                        }
                                        case 2: {
                                            int n9;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 0);
                                            int n10 = n9 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n9; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 0);
                                            }
                                            break;
                                        }
                                    }
                                    break block27;
                                }
                                case 8196: {
                                    break block27;
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.boundKind) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            int n11;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 2);
                                            int n12 = n11 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n11; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 2);
                                            }
                                            break block82;
                                        }
                                    }
                                    break block82;
                                }
                                case 8196: {
                                    int n13;
                                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                                    int n14 = n13 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n13; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], inferenceContext, 2);
                                    }
                                    break block82;
                                }
                            }
                            break block82;
                        }
                        case 2: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block0;
                                        }
                                        case 1: {
                                            break block0;
                                        }
                                        case 2: {
                                            int n15;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 2);
                                            int n16 = n15 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n15; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 2);
                                            }
                                            break;
                                        }
                                    }
                                    break block0;
                                }
                                case 8196: {
                                    break block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        char[] cArray2 = this.genericType.computeUniqueKey(false);
        char[] cArray3 = ("{" + String.valueOf(this.rank) + "}").toCharArray();
        switch (this.boundKind) {
            case 0: {
                cArray = TypeConstants.WILDCARD_STAR;
                break;
            }
            case 1: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.computeUniqueKey(false));
                break;
            }
            default: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.computeUniqueKey(false));
            }
        }
        return CharOperation.concat(cArray2, cArray3, cArray);
    }

    @Override
    public char[] constantPoolName() {
        return this.erasure().constantPoolName();
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new WildcardBinding(this.genericType, this.rank, this.bound, this.otherBounds, this.boundKind, this.environment);
    }

    @Override
    public String annotatedDebugName() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder(16);
        AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
        int n3 = n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(annotationBindingArray[n]);
            stringBuilder.append(' ');
        }
        switch (this.boundKind) {
            case 0: {
                return stringBuilder.append(TypeConstants.WILDCARD_NAME).toString();
            }
            case 1: {
                if (this.otherBounds == null) {
                    return stringBuilder.append(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.annotatedDebugName().toCharArray())).toString();
                }
                stringBuilder.append(this.bound.annotatedDebugName());
                n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append(" & ").append(this.otherBounds[n].annotatedDebugName());
                }
                return stringBuilder.toString();
            }
        }
        return stringBuilder.append(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.annotatedDebugName().toCharArray())).toString();
    }

    @Override
    public String debugName() {
        return this.toString();
    }

    @Override
    public TypeBinding erasure() {
        if (this.otherBounds == null) {
            if (this.boundKind == 1) {
                return this.bound.erasure();
            }
            TypeVariableBinding typeVariableBinding = this.typeVariable();
            if (typeVariableBinding != null) {
                return typeVariableBinding.erasure();
            }
            return this.genericType;
        }
        return this.bound.id == 1 ? this.otherBounds[0].erasure() : this.bound.erasure();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericSignature == null) {
            switch (this.boundKind) {
                case 0: {
                    this.genericSignature = TypeConstants.WILDCARD_STAR;
                    break;
                }
                case 1: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.genericTypeSignature());
                    break;
                }
                default: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.genericTypeSignature());
                }
            }
        }
        return this.genericSignature;
    }

    @Override
    public int hashCode() {
        return this.genericType.hashCode();
    }

    @Override
    public boolean hasTypeBit(int n) {
        if (this.typeBits == 0x8000000) {
            this.typeBits = 0;
            if (this.superclass != null && this.superclass.hasTypeBit(-134217729)) {
                this.typeBits |= this.superclass.typeBits & 0x713;
            }
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                for (int i = 0; i < n2; ++i) {
                    if (!this.superInterfaces[i].hasTypeBit(-134217729)) continue;
                    this.typeBits |= this.superInterfaces[i].typeBits & 0x713;
                }
            }
        }
        return (this.typeBits & n) != 0;
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding typeBinding, TypeBinding[] typeBindingArray) {
        this.genericType = referenceBinding;
        this.bound = typeBinding;
        this.otherBounds = typeBindingArray;
        if (referenceBinding != null) {
            this.fPackage = referenceBinding.getPackage();
        }
        if (typeBinding != null) {
            this.tagBits |= typeBinding.tagBits & 0x2000000020100880L;
        }
        if (typeBindingArray != null) {
            for (TypeBinding typeBinding2 : typeBindingArray) {
                this.tagBits |= typeBinding2.tagBits & 0x2000000000100800L;
            }
        }
    }

    @Override
    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        if (this.boundKind == 2) {
            if (this.bound instanceof ReferenceBinding) {
                return ((ReferenceBinding)this.bound).isSuperclassOf(referenceBinding);
            }
            return referenceBinding.id == 1;
        }
        return false;
    }

    @Override
    public boolean isIntersectionType() {
        return this.otherBounds != null;
    }

    @Override
    public ReferenceBinding[] getIntersectingTypes() {
        if (this.isIntersectionType()) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[this.otherBounds.length + 1];
            try {
                referenceBindingArray[0] = (ReferenceBinding)this.bound;
                System.arraycopy(this.otherBounds, 0, referenceBindingArray, 1, this.otherBounds.length);
            }
            catch (ArrayStoreException | ClassCastException runtimeException) {
                return null;
            }
            return referenceBindingArray;
        }
        return null;
    }

    @Override
    public boolean isHierarchyConnected() {
        return this.superclass != null && this.superInterfaces != null;
    }

    @Override
    public boolean enterRecursiveFunction() {
        if (this.inRecursiveFunction) {
            return false;
        }
        this.inRecursiveFunction = true;
        return true;
    }

    @Override
    public void exitRecursiveFunction() {
        this.inRecursiveFunction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProperType(boolean bl) {
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            int n;
            if (this.bound != null && !this.bound.isProperType(bl)) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.superclass != null && !this.superclass.isProperType(bl)) {
                boolean bl3 = false;
                return bl3;
            }
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                for (n = 0; n < n2; ++n) {
                    if (this.superInterfaces[n].isProperType(bl)) continue;
                    boolean bl4 = false;
                    return bl4;
                }
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        boolean bl = false;
        TypeBinding typeBinding2 = this.bound;
        if (typeBinding2 != null) {
            typeBinding2 = typeBinding2.substituteInferenceVariable(inferenceVariable, typeBinding);
            bl |= TypeBinding.notEquals(typeBinding2, this.bound);
        }
        TypeBinding[] typeBindingArray = null;
        if (this.otherBounds != null) {
            int n = this.otherBounds.length;
            if (bl) {
                typeBindingArray = new ReferenceBinding[n];
                System.arraycopy(this.otherBounds, 0, typeBindingArray, 0, n);
            }
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding3 = this.otherBounds[i];
                if (typeBinding3 == null || !TypeBinding.notEquals(typeBinding3 = typeBinding3.substituteInferenceVariable(inferenceVariable, typeBinding), this.otherBounds[i])) continue;
                if (typeBindingArray == null) {
                    typeBindingArray = new ReferenceBinding[n];
                    System.arraycopy(this.otherBounds, 0, typeBindingArray, 0, n);
                }
                typeBindingArray[i] = typeBinding3;
            }
        }
        if (bl |= typeBindingArray != null) {
            return this.environment.createWildcard(this.genericType, this.rank, typeBinding2, typeBindingArray, this.boundKind);
        }
        return this;
    }

    @Override
    public boolean isUnboundWildcard() {
        return this.boundKind == 0;
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    @Override
    int rank() {
        return this.rank;
    }

    @Override
    public char[] readableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                int n;
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.readableName());
                }
                StringBuilder stringBuilder = new StringBuilder(10);
                stringBuilder.append(this.bound.readableName());
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append('&').append(this.otherBounds[n].readableName());
                }
                n = stringBuilder.length();
                char[] cArray = new char[n];
                stringBuilder.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.readableName());
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        this.appendNullAnnotation(stringBuffer, compilerOptions);
        switch (this.boundKind) {
            case 0: {
                stringBuffer.append(TypeConstants.WILDCARD_NAME);
                break;
            }
            case 1: {
                if (this.otherBounds == null) {
                    stringBuffer.append(TypeConstants.WILDCARD_NAME).append(TypeConstants.WILDCARD_EXTENDS);
                    stringBuffer.append(this.bound.nullAnnotatedReadableName(compilerOptions, bl));
                    break;
                }
                stringBuffer.append(this.bound.nullAnnotatedReadableName(compilerOptions, bl));
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('&').append(this.otherBounds[n].nullAnnotatedReadableName(compilerOptions, bl));
                }
                break;
            }
            default: {
                stringBuffer.append(TypeConstants.WILDCARD_NAME).append(TypeConstants.WILDCARD_SUPER).append(this.bound.nullAnnotatedReadableName(compilerOptions, bl));
            }
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        BinaryTypeBinding.resolveType(this.genericType, this.environment, false);
        switch (this.boundKind) {
            case 1: {
                int n;
                TypeBinding typeBinding;
                this.bound = typeBinding = BinaryTypeBinding.resolveType(this.bound, this.environment, true);
                this.tagBits |= typeBinding.tagBits & 0x800L | 0x2000000000000000L;
                int n2 = n = this.otherBounds == null ? 0 : this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    this.otherBounds[i] = typeBinding = BinaryTypeBinding.resolveType(this.otherBounds[i], this.environment, true);
                    this.tagBits |= typeBinding.tagBits & 0x800L | 0x2000000000000000L;
                }
                break;
            }
            case 2: {
                TypeBinding typeBinding;
                this.bound = typeBinding = BinaryTypeBinding.resolveType(this.bound, this.environment, true);
                this.tagBits |= typeBinding.tagBits & 0x800L | 0x2000000000000000L;
                break;
            }
        }
        if (this.environment.usesNullTypeAnnotations()) {
            this.evaluateNullAnnotations(null, null);
        }
        return this;
    }

    @Override
    public char[] shortReadableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                int n;
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.shortReadableName());
                }
                StringBuilder stringBuilder = new StringBuilder(10);
                stringBuilder.append(this.bound.shortReadableName());
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append('&').append(this.otherBounds[n].shortReadableName());
                }
                n = stringBuilder.length();
                char[] cArray = new char[n];
                stringBuilder.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.shortReadableName());
    }

    @Override
    public char[] signature() {
        if (this.signature == null) {
            switch (this.boundKind) {
                case 1: {
                    return this.bound.signature();
                }
            }
            return this.typeVariable().signature();
        }
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.sourceName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.sourceName());
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            TypeBinding typeBinding = null;
            if (this.boundKind == 1 && !this.bound.isInterface()) {
                typeBinding = this.bound;
            } else {
                TypeVariableBinding typeVariableBinding = this.typeVariable();
                if (typeVariableBinding != null) {
                    typeBinding = typeVariableBinding.firstBound;
                }
            }
            this.superclass = typeBinding instanceof ReferenceBinding && !typeBinding.isInterface() ? (ReferenceBinding)typeBinding : this.environment.getResolvedJavaBaseType(TypeConstants.JAVA_LANG_OBJECT, null);
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            this.superInterfaces = this.typeVariable() != null ? this.typeVariable.superInterfaces() : Binding.NO_SUPERINTERFACES;
            if (this.boundKind == 1) {
                int n;
                if (this.bound.isInterface()) {
                    n = this.superInterfaces.length;
                    this.superInterfaces = new ReferenceBinding[n + 1];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 1, n);
                    this.superInterfaces[0] = (ReferenceBinding)this.bound;
                }
                if (this.otherBounds != null) {
                    n = this.superInterfaces.length;
                    int n2 = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[n + n2];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 0, n);
                    for (int i = 0; i < n2; ++i) {
                        this.superInterfaces[n + i] = (ReferenceBinding)this.otherBounds[i];
                    }
                }
            }
        }
        return this.superInterfaces;
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.genericType == unresolvedReferenceBinding) {
            this.genericType = referenceBinding;
            bl = true;
        }
        if (this.bound == unresolvedReferenceBinding) {
            this.bound = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            bl = true;
        }
        if (this.otherBounds != null) {
            int n = this.otherBounds.length;
            for (int i = 0; i < n; ++i) {
                if (this.otherBounds[i] != unresolvedReferenceBinding) continue;
                this.otherBounds[i] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                bl = true;
            }
        }
        if (bl) {
            this.initialize(this.genericType, this.bound, this.otherBounds);
        }
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        switch (this.boundKind) {
            case 0: {
                return new String(TypeConstants.WILDCARD_NAME);
            }
            case 1: {
                if (this.otherBounds == null) {
                    return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.debugName().toCharArray()));
                }
                StringBuilder stringBuilder = new StringBuilder(this.bound.debugName());
                int n = this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append('&').append(this.otherBounds[i].debugName());
                }
                return stringBuilder.toString();
            }
        }
        return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.debugName().toCharArray()));
    }

    public TypeVariableBinding typeVariable() {
        TypeVariableBinding[] typeVariableBindingArray;
        if (this.typeVariable == null && this.rank < (typeVariableBindingArray = this.genericType.typeVariables()).length) {
            this.typeVariable = typeVariableBindingArray[this.rank];
        }
        return this.typeVariable;
    }

    @Override
    public TypeBinding unannotated() {
        return this.hasTypeAnnotations() ? this.environment.getUnannotatedType(this) : this;
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.getTypeAnnotations());
        return this.environment.createWildcard(this.genericType, this.rank, this.bound, this.otherBounds, this.boundKind, annotationBindingArray);
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        TypeBinding[] typeBindingArray;
        if ((this.tagBits & 0x2000000000000000L) == 0L) {
            return this;
        }
        TypeBinding typeBinding = this.bound != null ? this.bound.uncapture(scope) : null;
        int n = 0;
        if (this.otherBounds == null) {
            typeBindingArray = null;
        } else {
            n = this.otherBounds.length;
            typeBindingArray = new TypeBinding[n];
        }
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        for (int i = 0; i < n; ++i) {
            typeBindingArray2[i] = this.otherBounds[i] == null ? null : this.otherBounds[i].uncapture(scope);
        }
        return scope.environment().createWildcard(this.genericType, this.rank, typeBinding, typeBindingArray2, this.boundKind, this.getTypeAnnotations());
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        if (this.bound != null) {
            this.bound.collectInferenceVariables(set);
        }
        if (this.otherBounds != null) {
            int n = this.otherBounds.length;
            for (int i = 0; i < n; ++i) {
                this.otherBounds[i].collectInferenceVariables(set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (this.inRecursiveFunction) {
            return false;
        }
        this.inRecursiveFunction = true;
        try {
            if (super.mentionsAny(typeBindingArray, n)) {
                boolean bl = true;
                return bl;
            }
            if (this.bound != null && this.bound.mentionsAny(typeBindingArray, -1)) {
                boolean bl = true;
                return bl;
            }
            if (this.otherBounds != null) {
                int n2 = this.otherBounds.length;
                for (int i = 0; i < n2; ++i) {
                    if (!this.otherBounds[i].mentionsAny(typeBindingArray, -1)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.inRecursiveFunction = false;
        }
        return false;
    }

    @Override
    public boolean acceptsNonNullDefault() {
        return false;
    }

    @Override
    public long updateTagBits() {
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.bound != null) {
                    this.tagBits |= this.bound.updateTagBits();
                }
                if (this.otherBounds != null) {
                    int n = this.otherBounds.length;
                    for (int i = 0; i < n; ++i) {
                        this.tagBits |= this.otherBounds[i].updateTagBits();
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        return super.updateTagBits();
    }
}

