// Generated from libavfilter/opencl/colorkey.cl
const char *ff_opencl_source_colorkey =
"#line 1 \"libavfilter/opencl/colorkey.cl\"\n"
"/*\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE |\n"
"                          CLK_FILTER_NEAREST;\n"
"\n"
"__kernel void colorkey_blend(\n"
"    __read_only  image2d_t src,\n"
"    __write_only image2d_t dst,\n"
"    float4 colorkey_rgba,\n"
"    float similarity,\n"
"    float blend\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    float4 pixel = read_imagef(src, sampler, loc);\n"
"    float diff = distance(pixel.xyz, colorkey_rgba.xyz);\n"
"\n"
"    pixel.s3 = clamp((diff - similarity) / blend, 0.0f, 1.0f);\n"
"    write_imagef(dst, loc, pixel);\n"
"}\n"
"\n"
"__kernel void colorkey(\n"
"    __read_only  image2d_t src,\n"
"    __write_only image2d_t dst,\n"
"    float4 colorkey_rgba,\n"
"    float similarity\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    float4 pixel = read_imagef(src, sampler, loc);\n"
"    float diff = distance(pixel.xyz, colorkey_rgba.xyz);\n"
"\n"
"    pixel.s3 = (diff > similarity) ? 1.0f : 0.0f;\n"
"    write_imagef(dst, loc, pixel);\n"
"}\n"
;
