/* currency-provider.c generated by valac 0.56.1, the Vala compiler
 * generated from currency-provider.vala, do not modify */

#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <sys/stat.h>
#include <time.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

enum  {
	CURRENCY_PROVIDER_UPDATED_SIGNAL,
	CURRENCY_PROVIDER_NUM_SIGNALS
};
static guint currency_provider_signals[CURRENCY_PROVIDER_NUM_SIGNALS] = {0};
enum  {
	ABSTRACT_CURRENCY_PROVIDER_0_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AbstractCurrencyProviderDownloadFileAsyncData AbstractCurrencyProviderDownloadFileAsyncData;
enum  {
	IMF_CURRENCY_PROVIDER_0_PROPERTY,
	IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	IMF_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	OFFLINE_IMF_CURRENCY_PROVIDER_0_PROPERTY,
	OFFLINE_IMF_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* offline_imf_currency_provider_properties[OFFLINE_IMF_CURRENCY_PROVIDER_NUM_PROPERTIES];
typedef struct _OfflineImfCurrencyProviderDownloadFileAsyncData OfflineImfCurrencyProviderDownloadFileAsyncData;
enum  {
	ECB_CURRENCY_PROVIDER_0_PROPERTY,
	ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	ECB_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

struct _AbstractCurrencyProviderPrivate {
	gint _refresh_interval;
	CurrencyManager* _currency_manager;
};

struct _AbstractCurrencyProviderDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AbstractCurrencyProvider* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest;
	GFile* _tmp2_;
	SoupSession* session;
	SoupSession* _tmp3_;
	SoupMessage* message;
	SoupMessage* _tmp4_;
	GInputStream* bodyinput;
	SoupSession* _tmp5_;
	SoupMessage* _tmp6_;
	GInputStream* _tmp7_;
	GFileOutputStream* output;
	GFile* _tmp8_;
	GFileOutputStream* _tmp9_;
	GFileOutputStream* _tmp10_;
	GInputStream* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _OfflineImfCurrencyProviderPrivate {
	gchar* source_file;
};

struct _OfflineImfCurrencyProviderDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OfflineImfCurrencyProvider* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest;
	GFile* _tmp2_;
	GFile* source_file;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFileInputStream* bodyinput;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_;
	GFileOutputStream* output;
	GFile* _tmp7_;
	GFileOutputStream* _tmp8_;
	GFileOutputStream* _tmp9_;
	GFileInputStream* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

static gint AbstractCurrencyProvider_private_offset;
static gpointer abstract_currency_provider_parent_class = NULL;
static CurrencyProviderIface * abstract_currency_provider_currency_provider_parent_iface = NULL;
static gpointer imf_currency_provider_parent_class = NULL;
static gint OfflineImfCurrencyProvider_private_offset;
static gpointer offline_imf_currency_provider_parent_class = NULL;
static gpointer ecb_currency_provider_parent_class = NULL;

static GType currency_provider_get_type_once (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void abstract_currency_provider_real_set_refresh_interval (CurrencyProvider* base,
                                                           gint interval,
                                                           gboolean asyncLoad);
static void abstract_currency_provider_set_refresh_interval (AbstractCurrencyProvider* self,
                                                      gint value);
static gboolean abstract_currency_provider_real_is_loaded (CurrencyProvider* base);
static void abstract_currency_provider_real_clear (CurrencyProvider* base);
static void abstract_currency_provider_real_update_rates (CurrencyProvider* base,
                                                   gboolean asyncLoad);
static gboolean abstract_currency_provider_file_needs_update (AbstractCurrencyProvider* self,
                                                       const gchar* filename,
                                                       gdouble max_age);
static void abstract_currency_provider_real_do_load_rates (AbstractCurrencyProvider* self);
static void abstract_currency_provider_real_download_file_sync (AbstractCurrencyProvider* self,
                                                         const gchar* uri,
                                                         const gchar* filename,
                                                         const gchar* source);
static void abstract_currency_provider_real_download_file_async_data_free (gpointer _data);
static void abstract_currency_provider_real_download_file_async (AbstractCurrencyProvider* self,
                                                          const gchar* uri,
                                                          const gchar* filename,
                                                          const gchar* source,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean abstract_currency_provider_real_download_file_async_co (AbstractCurrencyProviderDownloadFileAsyncData* _data_);
static void abstract_currency_provider_download_file_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void abstract_currency_provider_finalize (GObject * obj);
static GType abstract_currency_provider_get_type_once (void);
static void _vala_abstract_currency_provider_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_abstract_currency_provider_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static GHashTable* imf_currency_provider_get_name_map (ImfCurrencyProvider* self);
static void _g_free0_ (gpointer var);
static void imf_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static GType imf_currency_provider_get_type_once (void);
static void _vala_imf_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void offline_imf_currency_provider_real_download_file_sync (AbstractCurrencyProvider* base,
                                                            const gchar* uri,
                                                            const gchar* filename,
                                                            const gchar* source);
static void offline_imf_currency_provider_real_download_file_async_data_free (gpointer _data);
static void offline_imf_currency_provider_real_download_file_async (AbstractCurrencyProvider* base,
                                                             const gchar* uri,
                                                             const gchar* filename,
                                                             const gchar* source,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean offline_imf_currency_provider_real_download_file_async_co (OfflineImfCurrencyProviderDownloadFileAsyncData* _data_);
static void offline_imf_currency_provider_download_file_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void offline_imf_currency_provider_finalize (GObject * obj);
static GType offline_imf_currency_provider_get_type_once (void);
static void ecb_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static void ecb_currency_provider_set_ecb_fixed_rate (EcbCurrencyProvider* self,
                                               const gchar* name,
                                               const gchar* value,
                                               Currency* eur_rate);
static void ecb_currency_provider_set_ecb_rate (EcbCurrencyProvider* self,
                                         xmlNode* node,
                                         Currency* eur_rate);
static GType ecb_currency_provider_get_type_once (void);
static void _vala_ecb_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
currency_provider_update_rates (CurrencyProvider* self,
                                gboolean asyncLoad)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->update_rates) {
		_iface_->update_rates (self, asyncLoad);
	}
}

void
currency_provider_set_refresh_interval (CurrencyProvider* self,
                                        gint interval,
                                        gboolean asyncLoad)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->set_refresh_interval) {
		_iface_->set_refresh_interval (self, interval, asyncLoad);
	}
}

void
currency_provider_clear (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->clear) {
		_iface_->clear (self);
	}
}

gboolean
currency_provider_is_loaded (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->is_loaded) {
		return _iface_->is_loaded (self);
	}
	return FALSE;
}

static void
currency_provider_default_init (CurrencyProviderIface * iface,
                                gpointer iface_data)
{
	currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL] = g_signal_new ("updated", TYPE_CURRENCY_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType currency_provider_type_id;
	currency_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "CurrencyProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (currency_provider_type_id, G_TYPE_OBJECT);
	return currency_provider_type_id;
}

GType
currency_provider_get_type (void)
{
	static volatile gsize currency_provider_type_id__once = 0;
	if (g_once_init_enter (&currency_provider_type_id__once)) {
		GType currency_provider_type_id;
		currency_provider_type_id = currency_provider_get_type_once ();
		g_once_init_leave (&currency_provider_type_id__once, currency_provider_type_id);
	}
	return currency_provider_type_id__once;
}

static inline gpointer
abstract_currency_provider_get_instance_private (AbstractCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, AbstractCurrencyProvider_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
abstract_currency_provider_real_set_refresh_interval (CurrencyProvider* base,
                                                      gint interval,
                                                      gboolean asyncLoad)
{
	AbstractCurrencyProvider * self;
	self = (AbstractCurrencyProvider*) base;
	self->loaded = FALSE;
	g_signal_emit ((CurrencyProvider*) self, currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL], 0);
	abstract_currency_provider_set_refresh_interval (self, interval);
	currency_provider_update_rates ((CurrencyProvider*) self, asyncLoad);
}

static gboolean
abstract_currency_provider_real_is_loaded (CurrencyProvider* base)
{
	AbstractCurrencyProvider * self;
	gboolean result;
	self = (AbstractCurrencyProvider*) base;
	result = self->loaded;
	return result;
}

static void
abstract_currency_provider_real_clear (CurrencyProvider* base)
{
	AbstractCurrencyProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (AbstractCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_rate_filepath (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Currency*
abstract_currency_provider_register_currency (AbstractCurrencyProvider* self,
                                              const gchar* symbol,
                                              const gchar* source)
{
	Currency* currency = NULL;
	CurrencyManager* _tmp0_;
	Currency* _tmp1_;
	Currency* _tmp2_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	_tmp1_ = currency_manager_add_currency (_tmp0_, symbol, source);
	currency = _tmp1_;
	_tmp2_ = _g_object_ref0 (currency);
	self->currencies = g_list_append (self->currencies, _tmp2_);
	result = currency;
	return result;
}

static void
abstract_currency_provider_real_update_rates (CurrencyProvider* base,
                                              gboolean asyncLoad)
{
	AbstractCurrencyProvider * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	self = (AbstractCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_source_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("Updating %s rates ", _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("currency-provider.vala:52: %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (self->loading) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = self->loaded;
	}
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->_refresh_interval;
	if (_tmp5_ == 0) {
		return;
	}
	_tmp6_ = abstract_currency_provider_get_source_name (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("Checking %s rates ", _tmp7_);
	_tmp9_ = _tmp8_;
	g_debug ("currency-provider.vala:58: %s", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = abstract_currency_provider_get_rate_filepath (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_refresh_interval;
	_tmp14_ = !abstract_currency_provider_file_needs_update (self, _tmp12_, (gdouble) _tmp13_);
	_g_free0 (_tmp12_);
	if (_tmp14_) {
		abstract_currency_provider_do_load_rates (self);
		return;
	}
	_tmp15_ = abstract_currency_provider_get_source_name (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf ("Loading %s rates ", _tmp16_);
	_tmp18_ = _tmp17_;
	g_debug ("currency-provider.vala:65: %s", _tmp18_);
	_g_free0 (_tmp18_);
	self->loading = TRUE;
	if (asyncLoad) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp19_ = abstract_currency_provider_get_source_name (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf ("Downloading %s rates async", _tmp20_);
		_tmp22_ = _tmp21_;
		g_debug ("currency-provider.vala:70: %s", _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = abstract_currency_provider_get_source_name (self);
		_tmp29_ = _tmp28_;
		abstract_currency_provider_download_file_async (self, _tmp24_, _tmp27_, _tmp29_, NULL, NULL);
		_g_free0 (_tmp27_);
	} else {
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp30_ = abstract_currency_provider_get_source_name (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("Downloading %s rates sync", _tmp31_);
		_tmp33_ = _tmp32_;
		g_debug ("currency-provider.vala:73: %s", _tmp33_);
		_g_free0 (_tmp33_);
		_tmp34_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_;
		_tmp39_ = abstract_currency_provider_get_source_name (self);
		_tmp40_ = _tmp39_;
		abstract_currency_provider_download_file_sync (self, _tmp35_, _tmp38_, _tmp40_);
		_g_free0 (_tmp38_);
		abstract_currency_provider_do_load_rates (self);
	}
}

Currency*
abstract_currency_provider_get_currency (AbstractCurrencyProvider* self,
                                         const gchar* name)
{
	CurrencyManager* _tmp0_;
	Currency* _tmp1_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	_tmp1_ = currency_manager_get_currency (_tmp0_, name);
	result = _tmp1_;
	return result;
}

static void
abstract_currency_provider_real_do_load_rates (AbstractCurrencyProvider* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = abstract_currency_provider_get_source_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("Loaded %s rates ", _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("currency-provider.vala:87: %s", _tmp3_);
	_g_free0 (_tmp3_);
	self->loaded = TRUE;
	g_signal_emit ((CurrencyProvider*) self, currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL], 0);
}

void
abstract_currency_provider_do_load_rates (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->do_load_rates) {
		_klass_->do_load_rates (self);
	}
}

static gboolean
abstract_currency_provider_file_needs_update (AbstractCurrencyProvider* self,
                                              const gchar* filename,
                                              gdouble max_age)
{
	struct stat buf = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	time_t modify_time = 0;
	struct stat _tmp2_;
	time_t now = 0;
	time_t _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (max_age == ((gdouble) 0)) {
		result = FALSE;
		return result;
	}
	if (!g_file_test (filename, G_FILE_TEST_IS_REGULAR)) {
		result = TRUE;
		return result;
	}
	memset (&buf, 0, sizeof (struct stat));
	_tmp1_ = stat (filename, &_tmp0_);
	buf = _tmp0_;
	if (_tmp1_ == -1) {
		result = TRUE;
		return result;
	}
	_tmp2_ = buf;
	modify_time = _tmp2_.st_mtime;
	_tmp3_ = time (NULL);
	now = _tmp3_;
	if (((gdouble) (now - modify_time)) > max_age) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
abstract_currency_provider_real_download_file_sync (AbstractCurrencyProvider* self,
                                                    const gchar* uri,
                                                    const gchar* filename,
                                                    const gchar* source)
{
	gchar* directory = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest = NULL;
	GFile* _tmp2_;
	SoupSession* session = NULL;
	SoupSession* _tmp3_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = g_path_get_dirname (filename);
	directory = _tmp0_;
	_tmp1_ = directory;
	g_mkdir_with_parents (_tmp1_, 0755);
	_tmp2_ = g_file_new_for_path (filename);
	dest = _tmp2_;
	_tmp3_ = soup_session_new ();
	session = _tmp3_;
	_tmp4_ = soup_message_new ("GET", uri);
	message = _tmp4_;
	{
		GInputStream* bodyinput = NULL;
		SoupSession* _tmp5_;
		SoupMessage* _tmp6_;
		GInputStream* _tmp7_;
		GFileOutputStream* output = NULL;
		GFile* _tmp8_;
		GFileOutputStream* _tmp9_;
		GFileOutputStream* _tmp10_;
		GInputStream* _tmp11_;
		_tmp5_ = session;
		_tmp6_ = message;
		_tmp7_ = soup_session_send (_tmp5_, _tmp6_, NULL, &_inner_error0_);
		bodyinput = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = dest;
		_tmp9_ = g_file_replace (_tmp8_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		output = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		_tmp10_ = output;
		_tmp11_ = bodyinput;
		g_output_stream_splice ((GOutputStream*) _tmp10_, _tmp11_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (output);
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		self->loading = FALSE;
		abstract_currency_provider_do_load_rates (self);
		g_debug ("currency-provider.vala:131: %s rates updated", source);
		_g_object_unref0 (output);
		_g_object_unref0 (bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("currency-provider.vala:135: Couldn't download %s currency rate file: %" \
"s", source, _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_object_unref0 (dest);
		_g_free0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_object_unref0 (dest);
	_g_free0 (directory);
}

void
abstract_currency_provider_download_file_sync (AbstractCurrencyProvider* self,
                                               const gchar* uri,
                                               const gchar* filename,
                                               const gchar* source)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_sync) {
		_klass_->download_file_sync (self, uri, filename, source);
	}
}

static void
abstract_currency_provider_real_download_file_async_data_free (gpointer _data)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (AbstractCurrencyProviderDownloadFileAsyncData, _data_);
}

static void
abstract_currency_provider_real_download_file_async (AbstractCurrencyProvider* self,
                                                     const gchar* uri,
                                                     const gchar* filename,
                                                     const gchar* source,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	AbstractCurrencyProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (AbstractCurrencyProviderDownloadFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, abstract_currency_provider_real_download_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = g_strdup (source);
	_g_free0 (_data_->source);
	_data_->source = _tmp3_;
	abstract_currency_provider_real_download_file_async_co (_data_);
}

static void
abstract_currency_provider_real_download_file_finish (AbstractCurrencyProvider* self,
                                                      GAsyncResult* _res_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
abstract_currency_provider_download_file_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	abstract_currency_provider_real_download_file_async_co (_data_);
}

static gboolean
abstract_currency_provider_real_download_file_async_co (AbstractCurrencyProviderDownloadFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_path_get_dirname (_data_->filename);
	_data_->directory = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	_data_->_tmp2_ = g_file_new_for_path (_data_->filename);
	_data_->dest = _data_->_tmp2_;
	_data_->_tmp3_ = soup_session_new ();
	_data_->session = _data_->_tmp3_;
	_data_->_tmp4_ = soup_message_new ("GET", _data_->uri);
	_data_->message = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->session;
		_data_->_tmp6_ = _data_->message;
		_data_->_state_ = 1;
		soup_session_send_async (_data_->_tmp5_, _data_->_tmp6_, NULL, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = soup_session_send_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->bodyinput = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->dest;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp8_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp9_ = g_file_replace_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
		_data_->output = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _data_->output;
		_data_->_tmp11_ = _data_->bodyinput;
		_data_->_state_ = 3;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp10_, _data_->_tmp11_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, NULL, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		_data_->self->loading = FALSE;
		abstract_currency_provider_do_load_rates (_data_->self);
		g_debug ("currency-provider.vala:157: %s rates updated", _data_->source);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("currency-provider.vala:161: Couldn't download %s currency rate file: %" \
"s", _data_->source, _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->dest);
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->dest);
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
abstract_currency_provider_download_file_async (AbstractCurrencyProvider* self,
                                                const gchar* uri,
                                                const gchar* filename,
                                                const gchar* source,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	AbstractCurrencyProviderClass* _klass_;
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_async) {
		_klass_->download_file_async (self, uri, filename, source, _callback_, _user_data_);
	}
}

void
abstract_currency_provider_download_file_finish (AbstractCurrencyProvider* self,
                                                 GAsyncResult* _res_)
{
	AbstractCurrencyProviderClass* _klass_;
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_finish) {
		_klass_->download_file_finish (self, _res_);
	}
}

AbstractCurrencyProvider*
abstract_currency_provider_construct (GType object_type)
{
	AbstractCurrencyProvider * self = NULL;
	self = (AbstractCurrencyProvider*) g_object_new (object_type, NULL);
	return self;
}

gchar*
abstract_currency_provider_get_rate_filepath (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_rate_filepath) {
		return _klass_->get_rate_filepath (self);
	}
	return NULL;
}

const gchar*
abstract_currency_provider_get_rate_source_url (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_rate_source_url) {
		return _klass_->get_rate_source_url (self);
	}
	return NULL;
}

const gchar*
abstract_currency_provider_get_source_name (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_source_name) {
		return _klass_->get_source_name (self);
	}
	return NULL;
}

gint
abstract_currency_provider_get_refresh_interval (AbstractCurrencyProvider* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_refresh_interval;
	return result;
}

static void
abstract_currency_provider_set_refresh_interval (AbstractCurrencyProvider* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = abstract_currency_provider_get_refresh_interval (self);
	if (old_value != value) {
		self->priv->_refresh_interval = value;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY]);
	}
}

CurrencyManager*
abstract_currency_provider_get_currency_manager (AbstractCurrencyProvider* self)
{
	CurrencyManager* result;
	CurrencyManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	result = _tmp0_;
	return result;
}

static void
abstract_currency_provider_set_currency_manager (AbstractCurrencyProvider* self,
                                                 CurrencyManager* value)
{
	CurrencyManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = abstract_currency_provider_get_currency_manager (self);
	if (old_value != value) {
		CurrencyManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_currency_manager);
		self->priv->_currency_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY]);
	}
}

static void
abstract_currency_provider_class_init (AbstractCurrencyProviderClass * klass,
                                       gpointer klass_data)
{
	abstract_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AbstractCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) abstract_currency_provider_real_do_load_rates;
	((AbstractCurrencyProviderClass *) klass)->download_file_sync = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*)) abstract_currency_provider_real_download_file_sync;
	((AbstractCurrencyProviderClass *) klass)->download_file_async = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) abstract_currency_provider_real_download_file_async;
	((AbstractCurrencyProviderClass *) klass)->download_file_finish = (void (*) (AbstractCurrencyProvider*, GAsyncResult*)) abstract_currency_provider_real_download_file_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_abstract_currency_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_abstract_currency_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = abstract_currency_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY] = g_param_spec_int ("refresh-interval", "refresh-interval", "refresh-interval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY] = g_param_spec_object ("currency-manager", "currency-manager", "currency-manager", TYPE_CURRENCY_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
abstract_currency_provider_currency_provider_interface_init (CurrencyProviderIface * iface,
                                                             gpointer iface_data)
{
	abstract_currency_provider_currency_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_refresh_interval = (void (*) (CurrencyProvider*, gint, gboolean)) abstract_currency_provider_real_set_refresh_interval;
	iface->is_loaded = (gboolean (*) (CurrencyProvider*)) abstract_currency_provider_real_is_loaded;
	iface->clear = (void (*) (CurrencyProvider*)) abstract_currency_provider_real_clear;
	iface->update_rates = (void (*) (CurrencyProvider*, gboolean)) abstract_currency_provider_real_update_rates;
}

static void
abstract_currency_provider_instance_init (AbstractCurrencyProvider * self,
                                          gpointer klass)
{
	self->priv = abstract_currency_provider_get_instance_private (self);
}

static void
abstract_currency_provider_finalize (GObject * obj)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	(self->currencies == NULL) ? NULL : (self->currencies = (_g_list_free__g_object_unref0_ (self->currencies), NULL));
	_g_object_unref0 (self->priv->_currency_manager);
	G_OBJECT_CLASS (abstract_currency_provider_parent_class)->finalize (obj);
}

static GType
abstract_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AbstractCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) abstract_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbstractCurrencyProvider), 0, (GInstanceInitFunc) abstract_currency_provider_instance_init, NULL };
	static const GInterfaceInfo currency_provider_info = { (GInterfaceInitFunc) abstract_currency_provider_currency_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType abstract_currency_provider_type_id;
	abstract_currency_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "AbstractCurrencyProvider", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (abstract_currency_provider_type_id, TYPE_CURRENCY_PROVIDER, &currency_provider_info);
	AbstractCurrencyProvider_private_offset = g_type_add_instance_private (abstract_currency_provider_type_id, sizeof (AbstractCurrencyProviderPrivate));
	return abstract_currency_provider_type_id;
}

GType
abstract_currency_provider_get_type (void)
{
	static volatile gsize abstract_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&abstract_currency_provider_type_id__once)) {
		GType abstract_currency_provider_type_id;
		abstract_currency_provider_type_id = abstract_currency_provider_get_type_once ();
		g_once_init_leave (&abstract_currency_provider_type_id__once, abstract_currency_provider_type_id);
	}
	return abstract_currency_provider_type_id__once;
}

static void
_vala_abstract_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	switch (property_id) {
		case ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY:
		g_value_set_int (value, abstract_currency_provider_get_refresh_interval (self));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY:
		g_value_set_object (value, abstract_currency_provider_get_currency_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_abstract_currency_provider_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	switch (property_id) {
		case ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY:
		abstract_currency_provider_set_refresh_interval (self, g_value_get_int (value));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY:
		abstract_currency_provider_set_currency_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
imf_currency_provider_get_name_map (ImfCurrencyProvider* self)
{
	GHashTable* name_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = g_strdup ("Euro");
	_tmp4_ = g_strdup ("EUR");
	g_hash_table_insert (name_map, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Japanese yen");
	_tmp6_ = g_strdup ("JPY");
	g_hash_table_insert (name_map, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("U.K. pound");
	_tmp8_ = g_strdup ("GBP");
	g_hash_table_insert (name_map, _tmp7_, _tmp8_);
	_tmp9_ = g_strdup ("U.S. dollar");
	_tmp10_ = g_strdup ("USD");
	g_hash_table_insert (name_map, _tmp9_, _tmp10_);
	_tmp11_ = g_strdup ("Algerian dinar");
	_tmp12_ = g_strdup ("DZD");
	g_hash_table_insert (name_map, _tmp11_, _tmp12_);
	_tmp13_ = g_strdup ("Australian dollar");
	_tmp14_ = g_strdup ("AUD");
	g_hash_table_insert (name_map, _tmp13_, _tmp14_);
	_tmp15_ = g_strdup ("Bahrain dinar");
	_tmp16_ = g_strdup ("BHD");
	g_hash_table_insert (name_map, _tmp15_, _tmp16_);
	_tmp17_ = g_strdup ("Bangladeshi taka");
	_tmp18_ = g_strdup ("BDT");
	g_hash_table_insert (name_map, _tmp17_, _tmp18_);
	_tmp19_ = g_strdup ("Botswana pula");
	_tmp20_ = g_strdup ("BWP");
	g_hash_table_insert (name_map, _tmp19_, _tmp20_);
	_tmp21_ = g_strdup ("Brazilian real");
	_tmp22_ = g_strdup ("BRL");
	g_hash_table_insert (name_map, _tmp21_, _tmp22_);
	_tmp23_ = g_strdup ("Brunei dollar");
	_tmp24_ = g_strdup ("BND");
	g_hash_table_insert (name_map, _tmp23_, _tmp24_);
	_tmp25_ = g_strdup ("Canadian dollar");
	_tmp26_ = g_strdup ("CAD");
	g_hash_table_insert (name_map, _tmp25_, _tmp26_);
	_tmp27_ = g_strdup ("Chilean peso");
	_tmp28_ = g_strdup ("CLP");
	g_hash_table_insert (name_map, _tmp27_, _tmp28_);
	_tmp29_ = g_strdup ("Chinese yuan");
	_tmp30_ = g_strdup ("CNY");
	g_hash_table_insert (name_map, _tmp29_, _tmp30_);
	_tmp31_ = g_strdup ("Colombian peso");
	_tmp32_ = g_strdup ("COP");
	g_hash_table_insert (name_map, _tmp31_, _tmp32_);
	_tmp33_ = g_strdup ("Czech koruna");
	_tmp34_ = g_strdup ("CZK");
	g_hash_table_insert (name_map, _tmp33_, _tmp34_);
	_tmp35_ = g_strdup ("Danish krone");
	_tmp36_ = g_strdup ("DKK");
	g_hash_table_insert (name_map, _tmp35_, _tmp36_);
	_tmp37_ = g_strdup ("Hungarian forint");
	_tmp38_ = g_strdup ("HUF");
	g_hash_table_insert (name_map, _tmp37_, _tmp38_);
	_tmp39_ = g_strdup ("Icelandic krona");
	_tmp40_ = g_strdup ("ISK");
	g_hash_table_insert (name_map, _tmp39_, _tmp40_);
	_tmp41_ = g_strdup ("Indian rupee");
	_tmp42_ = g_strdup ("INR");
	g_hash_table_insert (name_map, _tmp41_, _tmp42_);
	_tmp43_ = g_strdup ("Indonesian rupiah");
	_tmp44_ = g_strdup ("IDR");
	g_hash_table_insert (name_map, _tmp43_, _tmp44_);
	_tmp45_ = g_strdup ("Iranian rial");
	_tmp46_ = g_strdup ("IRR");
	g_hash_table_insert (name_map, _tmp45_, _tmp46_);
	_tmp47_ = g_strdup ("Israeli New Shekel");
	_tmp48_ = g_strdup ("ILS");
	g_hash_table_insert (name_map, _tmp47_, _tmp48_);
	_tmp49_ = g_strdup ("Kazakhstani tenge");
	_tmp50_ = g_strdup ("KZT");
	g_hash_table_insert (name_map, _tmp49_, _tmp50_);
	_tmp51_ = g_strdup ("Korean won");
	_tmp52_ = g_strdup ("KRW");
	g_hash_table_insert (name_map, _tmp51_, _tmp52_);
	_tmp53_ = g_strdup ("Kuwaiti dinar");
	_tmp54_ = g_strdup ("KWD");
	g_hash_table_insert (name_map, _tmp53_, _tmp54_);
	_tmp55_ = g_strdup ("Libyan dinar");
	_tmp56_ = g_strdup ("LYD");
	g_hash_table_insert (name_map, _tmp55_, _tmp56_);
	_tmp57_ = g_strdup ("Malaysian ringgit");
	_tmp58_ = g_strdup ("MYR");
	g_hash_table_insert (name_map, _tmp57_, _tmp58_);
	_tmp59_ = g_strdup ("Mauritian rupee");
	_tmp60_ = g_strdup ("MUR");
	g_hash_table_insert (name_map, _tmp59_, _tmp60_);
	_tmp61_ = g_strdup ("Mexican peso");
	_tmp62_ = g_strdup ("MXN");
	g_hash_table_insert (name_map, _tmp61_, _tmp62_);
	_tmp63_ = g_strdup ("Nepalese rupee");
	_tmp64_ = g_strdup ("NPR");
	g_hash_table_insert (name_map, _tmp63_, _tmp64_);
	_tmp65_ = g_strdup ("New Zealand dollar");
	_tmp66_ = g_strdup ("NZD");
	g_hash_table_insert (name_map, _tmp65_, _tmp66_);
	_tmp67_ = g_strdup ("Norwegian krone");
	_tmp68_ = g_strdup ("NOK");
	g_hash_table_insert (name_map, _tmp67_, _tmp68_);
	_tmp69_ = g_strdup ("Omani rial");
	_tmp70_ = g_strdup ("OMR");
	g_hash_table_insert (name_map, _tmp69_, _tmp70_);
	_tmp71_ = g_strdup ("Pakistani rupee");
	_tmp72_ = g_strdup ("PKR");
	g_hash_table_insert (name_map, _tmp71_, _tmp72_);
	_tmp73_ = g_strdup ("Peruvian sol");
	_tmp74_ = g_strdup ("PEN");
	g_hash_table_insert (name_map, _tmp73_, _tmp74_);
	_tmp75_ = g_strdup ("Philippine peso");
	_tmp76_ = g_strdup ("PHP");
	g_hash_table_insert (name_map, _tmp75_, _tmp76_);
	_tmp77_ = g_strdup ("Polish zloty");
	_tmp78_ = g_strdup ("PLN");
	g_hash_table_insert (name_map, _tmp77_, _tmp78_);
	_tmp79_ = g_strdup ("Qatari riyal");
	_tmp80_ = g_strdup ("QAR");
	g_hash_table_insert (name_map, _tmp79_, _tmp80_);
	_tmp81_ = g_strdup ("Russian ruble");
	_tmp82_ = g_strdup ("RUB");
	g_hash_table_insert (name_map, _tmp81_, _tmp82_);
	_tmp83_ = g_strdup ("Saudi Arabian riyal");
	_tmp84_ = g_strdup ("SAR");
	g_hash_table_insert (name_map, _tmp83_, _tmp84_);
	_tmp85_ = g_strdup ("Singapore dollar");
	_tmp86_ = g_strdup ("SGD");
	g_hash_table_insert (name_map, _tmp85_, _tmp86_);
	_tmp87_ = g_strdup ("South African rand");
	_tmp88_ = g_strdup ("ZAR");
	g_hash_table_insert (name_map, _tmp87_, _tmp88_);
	_tmp89_ = g_strdup ("Sri Lankan rupee");
	_tmp90_ = g_strdup ("LKR");
	g_hash_table_insert (name_map, _tmp89_, _tmp90_);
	_tmp91_ = g_strdup ("Swedish krona");
	_tmp92_ = g_strdup ("SEK");
	g_hash_table_insert (name_map, _tmp91_, _tmp92_);
	_tmp93_ = g_strdup ("Swiss franc");
	_tmp94_ = g_strdup ("CHF");
	g_hash_table_insert (name_map, _tmp93_, _tmp94_);
	_tmp95_ = g_strdup ("Thai baht");
	_tmp96_ = g_strdup ("THB");
	g_hash_table_insert (name_map, _tmp95_, _tmp96_);
	_tmp97_ = g_strdup ("Trinidadian dollar");
	_tmp98_ = g_strdup ("TTD");
	g_hash_table_insert (name_map, _tmp97_, _tmp98_);
	_tmp99_ = g_strdup ("Tunisian dinar");
	_tmp100_ = g_strdup ("TND");
	g_hash_table_insert (name_map, _tmp99_, _tmp100_);
	_tmp101_ = g_strdup ("U.A.E. dirham");
	_tmp102_ = g_strdup ("AED");
	g_hash_table_insert (name_map, _tmp101_, _tmp102_);
	_tmp103_ = g_strdup ("Uruguayan peso");
	_tmp104_ = g_strdup ("UYU");
	g_hash_table_insert (name_map, _tmp103_, _tmp104_);
	_tmp105_ = g_strdup ("Bolivar Fuerte");
	_tmp106_ = g_strdup ("VEF");
	g_hash_table_insert (name_map, _tmp105_, _tmp106_);
	result = name_map;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
imf_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	ImfCurrencyProvider * self;
	GHashTable* name_map = NULL;
	GHashTable* _tmp0_;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = imf_currency_provider_get_name_map (self);
	name_map = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp1_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp4_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("currency-provider.vala:244: Failed to read exchange rates: %s", _tmp6_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_hash_table_unref0 (name_map);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (data);
		_g_hash_table_unref0 (name_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = data;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\n", 0);
	lines = _tmp9_;
	lines_length1 = _vala_array_length (_tmp8_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp10_ = lines;
	_tmp10__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp10_;
		line_collection_length1 = _tmp10__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp11_;
			gchar* line = NULL;
			_tmp11_ = g_strdup (line_collection[line_it]);
			line = _tmp11_;
			{
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar** tokens = NULL;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				_tmp12_ = line;
				_tmp13_ = string_chug (_tmp12_);
				_g_free0 (line);
				line = _tmp13_;
				_tmp14_ = line;
				if (g_strcmp0 (_tmp14_, "") == 0) {
					if (!in_data) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				if (!in_data) {
					_g_free0 (line);
					continue;
				}
				_tmp15_ = line;
				_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "\t", 0);
				tokens = _tmp17_;
				tokens_length1 = _vala_array_length (_tmp16_);
				_tokens_size_ = tokens_length1;
				_tmp18_ = tokens;
				_tmp18__length1 = tokens_length1;
				_tmp19_ = _tmp18_[0];
				if (g_strcmp0 (_tmp19_, "Currency") != 0) {
					gint value_index = 0;
					gchar** _tmp27_;
					gint _tmp27__length1;
					{
						gboolean _tmp20_ = FALSE;
						value_index = 1;
						_tmp20_ = TRUE;
						while (TRUE) {
							gchar** _tmp22_;
							gint _tmp22__length1;
							gchar* value = NULL;
							gchar** _tmp23_;
							gint _tmp23__length1;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							const gchar* _tmp26_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = value_index;
								value_index = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = tokens;
							_tmp22__length1 = tokens_length1;
							if (!(value_index < _tmp22__length1)) {
								break;
							}
							_tmp23_ = tokens;
							_tmp23__length1 = tokens_length1;
							_tmp24_ = _tmp23_[value_index];
							_tmp25_ = string_chug (_tmp24_);
							value = _tmp25_;
							_tmp26_ = value;
							if (g_strcmp0 (_tmp26_, "") != 0) {
								_g_free0 (value);
								break;
							}
							_g_free0 (value);
						}
					}
					_tmp27_ = tokens;
					_tmp27__length1 = tokens_length1;
					if (value_index < _tmp27__length1) {
						gchar* symbol = NULL;
						GHashTable* _tmp28_;
						gchar** _tmp29_;
						gint _tmp29__length1;
						const gchar* _tmp30_;
						gconstpointer _tmp31_;
						gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp28_ = name_map;
						_tmp29_ = tokens;
						_tmp29__length1 = tokens_length1;
						_tmp30_ = _tmp29_[0];
						_tmp31_ = g_hash_table_lookup (_tmp28_, _tmp30_);
						_tmp32_ = g_strdup ((const gchar*) _tmp31_);
						symbol = _tmp32_;
						_tmp33_ = symbol;
						if (_tmp33_ != NULL) {
							Currency* c = NULL;
							const gchar* _tmp34_;
							Currency* _tmp35_;
							Number* value = NULL;
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							Number* _tmp38_;
							gboolean _tmp39_ = FALSE;
							Currency* _tmp40_;
							_tmp34_ = symbol;
							_tmp35_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp34_);
							c = _tmp35_;
							_tmp36_ = tokens;
							_tmp36__length1 = tokens_length1;
							_tmp37_ = _tmp36_[value_index];
							_tmp38_ = mp_set_from_string (_tmp37_, 10);
							value = _tmp38_;
							_tmp40_ = c;
							if (_tmp40_ == NULL) {
								Number* _tmp41_;
								_tmp41_ = value;
								_tmp39_ = _tmp41_ != NULL;
							} else {
								_tmp39_ = FALSE;
							}
							if (_tmp39_) {
								gchar** _tmp42_;
								gint _tmp42__length1;
								const gchar* _tmp43_;
								const gchar* _tmp44_;
								const gchar* _tmp45_;
								const gchar* _tmp46_;
								const gchar* _tmp47_;
								Currency* _tmp48_;
								Number* _tmp49_;
								Number* _tmp50_;
								Currency* _tmp51_;
								_tmp42_ = tokens;
								_tmp42__length1 = tokens_length1;
								_tmp43_ = _tmp42_[value_index];
								_tmp44_ = symbol;
								g_debug ("currency-provider.vala:290: Using IMF rate of %s for %s", _tmp43_, _tmp44_);
								_tmp45_ = symbol;
								_tmp46_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
								_tmp47_ = _tmp46_;
								_tmp48_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp45_, _tmp47_);
								_g_object_unref0 (c);
								c = _tmp48_;
								_tmp49_ = value;
								_tmp50_ = number_reciprocal (_tmp49_);
								_g_object_unref0 (value);
								value = _tmp50_;
								_tmp51_ = c;
								if (_tmp51_ != NULL) {
									Currency* _tmp52_;
									Number* _tmp53_;
									_tmp52_ = c;
									_tmp53_ = value;
									currency_set_value (_tmp52_, _tmp53_);
								}
							}
							_g_object_unref0 (value);
							_g_object_unref0 (c);
						} else {
							gchar** _tmp54_;
							gint _tmp54__length1;
							const gchar* _tmp55_;
							_tmp54_ = tokens;
							_tmp54__length1 = tokens_length1;
							_tmp55_ = _tmp54_[0];
							g_warning ("currency-provider.vala:298: Unknown currency '%s'", _tmp55_);
						}
						_g_free0 (symbol);
					}
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	ABSTRACT_CURRENCY_PROVIDER_CLASS (imf_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_hash_table_unref0 (name_map);
}

ImfCurrencyProvider*
imf_currency_provider_construct (GType object_type,
                                 CurrencyManager* _currency_manager)
{
	ImfCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (ImfCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

ImfCurrencyProvider*
imf_currency_provider_new (CurrencyManager* _currency_manager)
{
	return imf_currency_provider_construct (TYPE_IMF_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
imf_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "rms_five.xls", NULL);
	result = _tmp1_;
	return result;
}

static const gchar*
imf_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	const gchar* result;
	ImfCurrencyProvider* self;
	self = (ImfCurrencyProvider*) base;
	result = "https://www.imf.org/external/np/fin/data/rms_five.aspx?tsvflag=Y";
	return result;
}

static const gchar*
imf_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	ImfCurrencyProvider* self;
	self = (ImfCurrencyProvider*) base;
	result = "IMF";
	return result;
}

static void
imf_currency_provider_class_init (ImfCurrencyProviderClass * klass,
                                  gpointer klass_data)
{
	imf_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = imf_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = imf_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = imf_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_imf_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
imf_currency_provider_instance_init (ImfCurrencyProvider * self,
                                     gpointer klass)
{
}

static GType
imf_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImfCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) imf_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImfCurrencyProvider), 0, (GInstanceInitFunc) imf_currency_provider_instance_init, NULL };
	GType imf_currency_provider_type_id;
	imf_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "ImfCurrencyProvider", &g_define_type_info, 0);
	return imf_currency_provider_type_id;
}

GType
imf_currency_provider_get_type (void)
{
	static volatile gsize imf_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&imf_currency_provider_type_id__once)) {
		GType imf_currency_provider_type_id;
		imf_currency_provider_type_id = imf_currency_provider_get_type_once ();
		g_once_init_leave (&imf_currency_provider_type_id__once, imf_currency_provider_type_id);
	}
	return imf_currency_provider_type_id__once;
}

static void
_vala_imf_currency_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ImfCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IMF_CURRENCY_PROVIDER, ImfCurrencyProvider);
	switch (property_id) {
		case IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
offline_imf_currency_provider_get_instance_private (OfflineImfCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, OfflineImfCurrencyProvider_private_offset);
}

OfflineImfCurrencyProvider*
offline_imf_currency_provider_construct (GType object_type,
                                         CurrencyManager* _currency_manager,
                                         const gchar* source_file)
{
	OfflineImfCurrencyProvider * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (OfflineImfCurrencyProvider*) imf_currency_provider_construct (object_type, _currency_manager);
	_tmp0_ = g_strdup (source_file);
	_g_free0 (self->priv->source_file);
	self->priv->source_file = _tmp0_;
	return self;
}

OfflineImfCurrencyProvider*
offline_imf_currency_provider_new (CurrencyManager* _currency_manager,
                                   const gchar* source_file)
{
	return offline_imf_currency_provider_construct (TYPE_OFFLINE_IMF_CURRENCY_PROVIDER, _currency_manager, source_file);
}

static void
offline_imf_currency_provider_real_download_file_sync (AbstractCurrencyProvider* base,
                                                       const gchar* uri,
                                                       const gchar* filename,
                                                       const gchar* source)
{
	OfflineImfCurrencyProvider * self;
	gchar* directory = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest = NULL;
	GFile* _tmp2_;
	GFile* source_file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (OfflineImfCurrencyProvider*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = g_path_get_dirname (filename);
	directory = _tmp0_;
	_tmp1_ = directory;
	g_mkdir_with_parents (_tmp1_, 0755);
	_tmp2_ = g_file_new_for_path (filename);
	dest = _tmp2_;
	_tmp3_ = self->priv->source_file;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	source_file = _tmp4_;
	{
		GFileInputStream* bodyinput = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GFileOutputStream* output = NULL;
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_;
		GFileOutputStream* _tmp9_;
		GFileInputStream* _tmp10_;
		_tmp5_ = source_file;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		bodyinput = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = dest;
		_tmp8_ = g_file_replace (_tmp7_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		output = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		_tmp9_ = output;
		_tmp10_ = bodyinput;
		g_output_stream_splice ((GOutputStream*) _tmp9_, (GInputStream*) _tmp10_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (output);
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		((AbstractCurrencyProvider*) self)->loading = FALSE;
		abstract_currency_provider_do_load_rates ((AbstractCurrencyProvider*) self);
		g_debug ("currency-provider.vala:337: %s rates updated", source);
		_g_object_unref0 (output);
		_g_object_unref0 (bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("currency-provider.vala:341: Couldn't download %s currency rate file: %" \
"s", source, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (source_file);
		_g_object_unref0 (dest);
		_g_free0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (source_file);
	_g_object_unref0 (dest);
	_g_free0 (directory);
}

static void
offline_imf_currency_provider_real_download_file_async_data_free (gpointer _data)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (OfflineImfCurrencyProviderDownloadFileAsyncData, _data_);
}

static void
offline_imf_currency_provider_real_download_file_async (AbstractCurrencyProvider* base,
                                                        const gchar* uri,
                                                        const gchar* filename,
                                                        const gchar* source,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	OfflineImfCurrencyProvider * self;
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	OfflineImfCurrencyProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	self = (OfflineImfCurrencyProvider*) base;
	_data_ = g_slice_new0 (OfflineImfCurrencyProviderDownloadFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, offline_imf_currency_provider_real_download_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = g_strdup (source);
	_g_free0 (_data_->source);
	_data_->source = _tmp3_;
	offline_imf_currency_provider_real_download_file_async_co (_data_);
}

static void
offline_imf_currency_provider_download_file_finish (AbstractCurrencyProvider* base,
                                                    GAsyncResult* _res_)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
offline_imf_currency_provider_download_file_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	offline_imf_currency_provider_real_download_file_async_co (_data_);
}

static gboolean
offline_imf_currency_provider_real_download_file_async_co (OfflineImfCurrencyProviderDownloadFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_path_get_dirname (_data_->filename);
	_data_->directory = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	_data_->_tmp2_ = g_file_new_for_path (_data_->filename);
	_data_->dest = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->source_file;
	_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
	_data_->source_file = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->source_file;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = g_file_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->bodyinput = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->dest;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp7_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = g_file_replace_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_data_->output = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->output;
		_data_->_tmp10_ = _data_->bodyinput;
		_data_->_state_ = 3;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp9_, (GInputStream*) _data_->_tmp10_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		((AbstractCurrencyProvider*) _data_->self)->loading = FALSE;
		abstract_currency_provider_do_load_rates ((AbstractCurrencyProvider*) _data_->self);
		g_debug ("currency-provider.vala:362: %s rates updated", _data_->source);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("currency-provider.vala:366: Couldn't download %s currency rate file: %" \
"s", _data_->source, _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->source_file);
		_g_object_unref0 (_data_->dest);
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->source_file);
	_g_object_unref0 (_data_->dest);
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
offline_imf_currency_provider_class_init (OfflineImfCurrencyProviderClass * klass,
                                          gpointer klass_data)
{
	offline_imf_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OfflineImfCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->download_file_sync = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*)) offline_imf_currency_provider_real_download_file_sync;
	((AbstractCurrencyProviderClass *) klass)->download_file_async = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) offline_imf_currency_provider_real_download_file_async;
	((AbstractCurrencyProviderClass *) klass)->download_file_finish = (void (*) (AbstractCurrencyProvider*, GAsyncResult*)) offline_imf_currency_provider_download_file_finish;
	G_OBJECT_CLASS (klass)->finalize = offline_imf_currency_provider_finalize;
}

static void
offline_imf_currency_provider_instance_init (OfflineImfCurrencyProvider * self,
                                             gpointer klass)
{
	self->priv = offline_imf_currency_provider_get_instance_private (self);
}

static void
offline_imf_currency_provider_finalize (GObject * obj)
{
	OfflineImfCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OFFLINE_IMF_CURRENCY_PROVIDER, OfflineImfCurrencyProvider);
	_g_free0 (self->priv->source_file);
	G_OBJECT_CLASS (offline_imf_currency_provider_parent_class)->finalize (obj);
}

static GType
offline_imf_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OfflineImfCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) offline_imf_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OfflineImfCurrencyProvider), 0, (GInstanceInitFunc) offline_imf_currency_provider_instance_init, NULL };
	GType offline_imf_currency_provider_type_id;
	offline_imf_currency_provider_type_id = g_type_register_static (TYPE_IMF_CURRENCY_PROVIDER, "OfflineImfCurrencyProvider", &g_define_type_info, 0);
	OfflineImfCurrencyProvider_private_offset = g_type_add_instance_private (offline_imf_currency_provider_type_id, sizeof (OfflineImfCurrencyProviderPrivate));
	return offline_imf_currency_provider_type_id;
}

GType
offline_imf_currency_provider_get_type (void)
{
	static volatile gsize offline_imf_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&offline_imf_currency_provider_type_id__once)) {
		GType offline_imf_currency_provider_type_id;
		offline_imf_currency_provider_type_id = offline_imf_currency_provider_get_type_once ();
		g_once_init_leave (&offline_imf_currency_provider_type_id__once, offline_imf_currency_provider_type_id);
	}
	return offline_imf_currency_provider_type_id__once;
}

static void
ecb_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	EcbCurrencyProvider * self;
	Currency* eur_rate = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	Currency* _tmp2_;
	Currency* _tmp3_;
	Currency* _tmp4_;
	Currency* _tmp5_;
	xmlDoc* document = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	xmlDoc* _tmp9_;
	xmlDoc* _tmp10_;
	xmlDoc* _tmp11_;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp15_;
	xmlXPathContext* _tmp16_;
	xmlXPathContext* _tmp17_;
	xmlXPathContext* _tmp18_;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp19_;
	xmlXPathObject* _tmp20_;
	xmlXPathObject* _tmp21_;
	gint _tmp22_ = 0;
	xmlXPathObject* _tmp23_;
	xmlNodeSet* _tmp24_;
	gint len = 0;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, "EUR");
	eur_rate = _tmp0_;
	_tmp1_ = eur_rate;
	if (_tmp1_ == NULL) {
		g_warning ("currency-provider.vala:386: Cannot use ECB rates as don't have EUR rat" \
"e");
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp2_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "BDT", "0.0099", _tmp2_);
	_tmp3_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "RSD", "0.0085", _tmp3_);
	_tmp4_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "EEK", "0.06391", _tmp4_);
	_tmp5_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "CFA", "0.00152449", _tmp5_);
	xmlInitParser ();
	_tmp6_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = xmlReadFile (_tmp8_, NULL, 0);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	document = _tmp10_;
	_tmp11_ = document;
	if (_tmp11_ == NULL) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		g_warning ("currency-provider.vala:400: Couldn't parse ECB rate file %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp15_ = document;
	_tmp16_ = xmlXPathNewContext (_tmp15_);
	xpath_ctx = _tmp16_;
	_tmp17_ = xpath_ctx;
	if (_tmp17_ == NULL) {
		g_warning ("currency-provider.vala:407: Couldn't create XPath context");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp18_ = xpath_ctx;
	xmlXPathRegisterNs (_tmp18_, (xmlChar*) "xref", (xmlChar*) "http://www.ecb.int/vocabulary/2002-08-01/eurofxref");
	_tmp19_ = xpath_ctx;
	_tmp20_ = xmlXPathEvalExpression ((xmlChar*) "//xref:Cube[@currency][@rate]", _tmp19_);
	xpath_obj = _tmp20_;
	_tmp21_ = xpath_obj;
	if (_tmp21_ == NULL) {
		g_warning ("currency-provider.vala:415: Couldn't create XPath object");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp23_ = xpath_obj;
	_tmp24_ = _tmp23_->nodesetval;
	if (_tmp24_ != NULL) {
		xmlXPathObject* _tmp25_;
		xmlNodeSet* _tmp26_;
		_tmp25_ = xpath_obj;
		_tmp26_ = _tmp25_->nodesetval;
		_tmp22_ = xmlXPathNodeSetGetLength (_tmp26_);
	} else {
		_tmp22_ = 0;
	}
	len = _tmp22_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				xmlNode* node = NULL;
				xmlXPathObject* _tmp29_;
				xmlNodeSet* _tmp30_;
				xmlNode* _tmp31_;
				xmlNode* _tmp32_;
				xmlNode* _tmp35_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp29_ = xpath_obj;
				_tmp30_ = _tmp29_->nodesetval;
				_tmp31_ = xmlXPathNodeSetItem (_tmp30_, i);
				node = _tmp31_;
				_tmp32_ = node;
				if (_tmp32_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp33_;
					Currency* _tmp34_;
					_tmp33_ = node;
					_tmp34_ = eur_rate;
					ecb_currency_provider_set_ecb_rate (self, _tmp33_, _tmp34_);
				}
				_tmp35_ = node;
				if (_tmp35_->type != XML_NAMESPACE_DECL) {
					node = NULL;
				}
			}
		}
	}
	ABSTRACT_CURRENCY_PROVIDER_CLASS (ecb_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_object_unref0 (eur_rate);
}

static void
ecb_currency_provider_set_ecb_rate (EcbCurrencyProvider* self,
                                    xmlNode* node,
                                    Currency* eur_rate)
{
	gchar* name = NULL;
	gchar* value = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (eur_rate != NULL);
	name = NULL;
	value = NULL;
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = node->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				xmlNode* n = NULL;
				xmlAttr* _tmp5_;
				xmlAttr* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				n = (xmlNode*) _tmp5_;
				_tmp6_ = attribute;
				_tmp7_ = _tmp6_->name;
				if (g_strcmp0 (_tmp7_, "currency") == 0) {
					xmlNode* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = n;
					_tmp9_ = (gchar*) xmlNodeGetContent (_tmp8_);
					_g_free0 (name);
					name = _tmp9_;
				} else {
					xmlAttr* _tmp10_;
					const gchar* _tmp11_;
					_tmp10_ = attribute;
					_tmp11_ = _tmp10_->name;
					if (g_strcmp0 (_tmp11_, "rate") == 0) {
						xmlNode* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = n;
						_tmp13_ = (gchar*) xmlNodeGetContent (_tmp12_);
						_g_free0 (value);
						value = _tmp13_;
					}
				}
			}
		}
	}
	_tmp16_ = name;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = value;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		Currency* _tmp19_;
		Currency* _tmp20_;
		_tmp18_ = name;
		_tmp19_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = _tmp20_ == NULL;
		_g_object_unref0 (_tmp20_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		Currency* c = NULL;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		Currency* _tmp26_;
		Number* r = NULL;
		const gchar* _tmp27_;
		Number* _tmp28_;
		Number* v = NULL;
		Number* _tmp29_;
		Number* _tmp30_;
		Number* _tmp31_;
		Number* _tmp32_;
		Currency* _tmp33_;
		Number* _tmp34_;
		_tmp21_ = value;
		_tmp22_ = name;
		g_debug ("currency-provider.vala:450: Using ECB rate of %s for %s", _tmp21_, _tmp22_);
		_tmp23_ = name;
		_tmp24_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp23_, _tmp25_);
		c = _tmp26_;
		_tmp27_ = value;
		_tmp28_ = mp_set_from_string (_tmp27_, 10);
		r = _tmp28_;
		_tmp29_ = currency_get_value (eur_rate);
		v = _tmp29_;
		_tmp30_ = v;
		_tmp31_ = r;
		_tmp32_ = number_multiply (_tmp30_, _tmp31_);
		_g_object_unref0 (v);
		v = _tmp32_;
		_tmp33_ = c;
		_tmp34_ = v;
		currency_set_value (_tmp33_, _tmp34_);
		_g_object_unref0 (v);
		_g_object_unref0 (r);
		_g_object_unref0 (c);
	}
	_g_free0 (value);
	_g_free0 (name);
}

static void
ecb_currency_provider_set_ecb_fixed_rate (EcbCurrencyProvider* self,
                                          const gchar* name,
                                          const gchar* value,
                                          Currency* eur_rate)
{
	Currency* c = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	Currency* _tmp4_;
	Currency* _tmp5_;
	Number* r = NULL;
	Number* _tmp6_;
	Number* v = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (eur_rate != NULL);
	g_debug ("currency-provider.vala:461: Using ECB fixed rate of %s for %s", value, name);
	_tmp0_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "#fixed", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, name, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	c = _tmp5_;
	_tmp6_ = mp_set_from_string (value, 10);
	r = _tmp6_;
	_tmp7_ = currency_get_value (eur_rate);
	v = _tmp7_;
	_tmp8_ = v;
	_tmp9_ = number_divide (_tmp8_, r);
	_g_object_unref0 (v);
	v = _tmp9_;
	_tmp10_ = v;
	currency_set_value (c, _tmp10_);
	_g_object_unref0 (v);
	_g_object_unref0 (r);
	_g_object_unref0 (c);
}

EcbCurrencyProvider*
ecb_currency_provider_construct (GType object_type,
                                 CurrencyManager* _currency_manager)
{
	EcbCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (EcbCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

EcbCurrencyProvider*
ecb_currency_provider_new (CurrencyManager* _currency_manager)
{
	return ecb_currency_provider_construct (TYPE_ECB_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
ecb_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "eurofxref-daily.xml", NULL);
	result = _tmp1_;
	return result;
}

static const gchar*
ecb_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	const gchar* result;
	EcbCurrencyProvider* self;
	self = (EcbCurrencyProvider*) base;
	result = "https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml";
	return result;
}

static const gchar*
ecb_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	EcbCurrencyProvider* self;
	self = (EcbCurrencyProvider*) base;
	result = "ECB";
	return result;
}

static void
ecb_currency_provider_class_init (EcbCurrencyProviderClass * klass,
                                  gpointer klass_data)
{
	ecb_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = ecb_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = ecb_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = ecb_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_ecb_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
ecb_currency_provider_instance_init (EcbCurrencyProvider * self,
                                     gpointer klass)
{
}

static GType
ecb_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EcbCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ecb_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EcbCurrencyProvider), 0, (GInstanceInitFunc) ecb_currency_provider_instance_init, NULL };
	GType ecb_currency_provider_type_id;
	ecb_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "EcbCurrencyProvider", &g_define_type_info, 0);
	return ecb_currency_provider_type_id;
}

GType
ecb_currency_provider_get_type (void)
{
	static volatile gsize ecb_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&ecb_currency_provider_type_id__once)) {
		GType ecb_currency_provider_type_id;
		ecb_currency_provider_type_id = ecb_currency_provider_get_type_once ();
		g_once_init_leave (&ecb_currency_provider_type_id__once, ecb_currency_provider_type_id);
	}
	return ecb_currency_provider_type_id__once;
}

static void
_vala_ecb_currency_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	EcbCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ECB_CURRENCY_PROVIDER, EcbCurrencyProvider);
	switch (property_id) {
		case ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

