/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "nautilus-freedesktop-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.FileManager1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NautilusFreedesktopFileManager1
 * @title: NautilusFreedesktopFileManager1
 * @short_description: Generated C code for the org.freedesktop.FileManager1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.FileManager1 ---- */

static const _ExtendedGDBusArgInfo _nautilus_freedesktop_file_manager1_method_info_show_folders_IN_ARG_URIs =
{
  {
    -1,
    (gchar *) "URIs",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nautilus_freedesktop_file_manager1_method_info_show_folders_IN_ARG_StartupId =
{
  {
    -1,
    (gchar *) "StartupId",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nautilus_freedesktop_file_manager1_method_info_show_folders_IN_ARG_pointers[] =
{
  &_nautilus_freedesktop_file_manager1_method_info_show_folders_IN_ARG_URIs.parent_struct,
  &_nautilus_freedesktop_file_manager1_method_info_show_folders_IN_ARG_StartupId.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nautilus_freedesktop_file_manager1_method_info_show_folders =
{
  {
    -1,
    (gchar *) "ShowFolders",
    (GDBusArgInfo **) &_nautilus_freedesktop_file_manager1_method_info_show_folders_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-folders",
  FALSE
};

static const _ExtendedGDBusArgInfo _nautilus_freedesktop_file_manager1_method_info_show_items_IN_ARG_URIs =
{
  {
    -1,
    (gchar *) "URIs",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nautilus_freedesktop_file_manager1_method_info_show_items_IN_ARG_StartupId =
{
  {
    -1,
    (gchar *) "StartupId",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nautilus_freedesktop_file_manager1_method_info_show_items_IN_ARG_pointers[] =
{
  &_nautilus_freedesktop_file_manager1_method_info_show_items_IN_ARG_URIs.parent_struct,
  &_nautilus_freedesktop_file_manager1_method_info_show_items_IN_ARG_StartupId.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nautilus_freedesktop_file_manager1_method_info_show_items =
{
  {
    -1,
    (gchar *) "ShowItems",
    (GDBusArgInfo **) &_nautilus_freedesktop_file_manager1_method_info_show_items_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-items",
  FALSE
};

static const _ExtendedGDBusArgInfo _nautilus_freedesktop_file_manager1_method_info_show_item_properties_IN_ARG_URIs =
{
  {
    -1,
    (gchar *) "URIs",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nautilus_freedesktop_file_manager1_method_info_show_item_properties_IN_ARG_StartupId =
{
  {
    -1,
    (gchar *) "StartupId",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nautilus_freedesktop_file_manager1_method_info_show_item_properties_IN_ARG_pointers[] =
{
  &_nautilus_freedesktop_file_manager1_method_info_show_item_properties_IN_ARG_URIs.parent_struct,
  &_nautilus_freedesktop_file_manager1_method_info_show_item_properties_IN_ARG_StartupId.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nautilus_freedesktop_file_manager1_method_info_show_item_properties =
{
  {
    -1,
    (gchar *) "ShowItemProperties",
    (GDBusArgInfo **) &_nautilus_freedesktop_file_manager1_method_info_show_item_properties_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-item-properties",
  FALSE
};

static const GDBusMethodInfo * const _nautilus_freedesktop_file_manager1_method_info_pointers[] =
{
  &_nautilus_freedesktop_file_manager1_method_info_show_folders.parent_struct,
  &_nautilus_freedesktop_file_manager1_method_info_show_items.parent_struct,
  &_nautilus_freedesktop_file_manager1_method_info_show_item_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nautilus_freedesktop_file_manager1_property_info_open_locations =
{
  {
    -1,
    (gchar *) "OpenLocations",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "open-locations",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nautilus_freedesktop_file_manager1_property_info_open_windows_with_locations =
{
  {
    -1,
    (gchar *) "OpenWindowsWithLocations",
    (gchar *) "a{sas}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "open-windows-with-locations",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nautilus_freedesktop_file_manager1_property_info_pointers[] =
{
  &_nautilus_freedesktop_file_manager1_property_info_open_locations.parent_struct,
  &_nautilus_freedesktop_file_manager1_property_info_open_windows_with_locations.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nautilus_freedesktop_file_manager1_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.FileManager1",
    (GDBusMethodInfo **) &_nautilus_freedesktop_file_manager1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_nautilus_freedesktop_file_manager1_property_info_pointers,
    NULL
  },
  "file-manager1",
};


/**
 * nautilus_freedesktop_file_manager1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nautilus_freedesktop_file_manager1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nautilus_freedesktop_file_manager1_interface_info.parent_struct;
}

/**
 * nautilus_freedesktop_file_manager1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NautilusFreedesktopFileManager1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nautilus_freedesktop_file_manager1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "open-locations");
  g_object_class_override_property (klass, property_id_begin++, "open-windows-with-locations");
  return property_id_begin - 1;
}



/**
 * NautilusFreedesktopFileManager1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link>.
 */

/**
 * NautilusFreedesktopFileManager1Iface:
 * @parent_iface: The parent interface.
 * @handle_show_folders: Handler for the #NautilusFreedesktopFileManager1::handle-show-folders signal.
 * @handle_show_item_properties: Handler for the #NautilusFreedesktopFileManager1::handle-show-item-properties signal.
 * @handle_show_items: Handler for the #NautilusFreedesktopFileManager1::handle-show-items signal.
 * @get_open_locations: Getter for the #NautilusFreedesktopFileManager1:open-locations property.
 * @get_open_windows_with_locations: Getter for the #NautilusFreedesktopFileManager1:open-windows-with-locations property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link>.
 */

typedef NautilusFreedesktopFileManager1Iface NautilusFreedesktopFileManager1Interface;
G_DEFINE_INTERFACE (NautilusFreedesktopFileManager1, nautilus_freedesktop_file_manager1, G_TYPE_OBJECT)

static void
nautilus_freedesktop_file_manager1_default_init (NautilusFreedesktopFileManager1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NautilusFreedesktopFileManager1::handle-show-folders:
   * @object: A #NautilusFreedesktopFileManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_URIs: Argument passed by remote caller.
   * @arg_StartupId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowFolders">ShowFolders()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nautilus_freedesktop_file_manager1_complete_show_folders() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-folders",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NautilusFreedesktopFileManager1Iface, handle_show_folders),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING);

  /**
   * NautilusFreedesktopFileManager1::handle-show-items:
   * @object: A #NautilusFreedesktopFileManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_URIs: Argument passed by remote caller.
   * @arg_StartupId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItems">ShowItems()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nautilus_freedesktop_file_manager1_complete_show_items() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-items",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NautilusFreedesktopFileManager1Iface, handle_show_items),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING);

  /**
   * NautilusFreedesktopFileManager1::handle-show-item-properties:
   * @object: A #NautilusFreedesktopFileManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_URIs: Argument passed by remote caller.
   * @arg_StartupId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItemProperties">ShowItemProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nautilus_freedesktop_file_manager1_complete_show_item_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-item-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NautilusFreedesktopFileManager1Iface, handle_show_item_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * NautilusFreedesktopFileManager1:open-locations:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenLocations">"OpenLocations"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("open-locations", "OpenLocations", "OpenLocations", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NautilusFreedesktopFileManager1:open-windows-with-locations:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenWindowsWithLocations">"OpenWindowsWithLocations"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("open-windows-with-locations", "OpenWindowsWithLocations", "OpenWindowsWithLocations", G_VARIANT_TYPE ("a{sas}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nautilus_freedesktop_file_manager1_get_open_locations: (skip)
 * @object: A #NautilusFreedesktopFileManager1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenLocations">"OpenLocations"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nautilus_freedesktop_file_manager1_dup_open_locations() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nautilus_freedesktop_file_manager1_get_open_locations (NautilusFreedesktopFileManager1 *object)
{
  return NAUTILUS_FREEDESKTOP_FILE_MANAGER1_GET_IFACE (object)->get_open_locations (object);
}

/**
 * nautilus_freedesktop_file_manager1_dup_open_locations: (skip)
 * @object: A #NautilusFreedesktopFileManager1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenLocations">"OpenLocations"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nautilus_freedesktop_file_manager1_dup_open_locations (NautilusFreedesktopFileManager1 *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "open-locations", &value, NULL);
  return value;
}

/**
 * nautilus_freedesktop_file_manager1_set_open_locations: (skip)
 * @object: A #NautilusFreedesktopFileManager1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenLocations">"OpenLocations"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nautilus_freedesktop_file_manager1_set_open_locations (NautilusFreedesktopFileManager1 *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "open-locations", value, NULL);
}

/**
 * nautilus_freedesktop_file_manager1_get_open_windows_with_locations: (skip)
 * @object: A #NautilusFreedesktopFileManager1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenWindowsWithLocations">"OpenWindowsWithLocations"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nautilus_freedesktop_file_manager1_dup_open_windows_with_locations() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nautilus_freedesktop_file_manager1_get_open_windows_with_locations (NautilusFreedesktopFileManager1 *object)
{
  return NAUTILUS_FREEDESKTOP_FILE_MANAGER1_GET_IFACE (object)->get_open_windows_with_locations (object);
}

/**
 * nautilus_freedesktop_file_manager1_dup_open_windows_with_locations: (skip)
 * @object: A #NautilusFreedesktopFileManager1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenWindowsWithLocations">"OpenWindowsWithLocations"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nautilus_freedesktop_file_manager1_dup_open_windows_with_locations (NautilusFreedesktopFileManager1 *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "open-windows-with-locations", &value, NULL);
  return value;
}

/**
 * nautilus_freedesktop_file_manager1_set_open_windows_with_locations: (skip)
 * @object: A #NautilusFreedesktopFileManager1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-FileManager1.OpenWindowsWithLocations">"OpenWindowsWithLocations"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nautilus_freedesktop_file_manager1_set_open_windows_with_locations (NautilusFreedesktopFileManager1 *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "open-windows-with-locations", value, NULL);
}

/**
 * nautilus_freedesktop_file_manager1_call_show_folders:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @arg_URIs: Argument to pass with the method invocation.
 * @arg_StartupId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowFolders">ShowFolders()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nautilus_freedesktop_file_manager1_call_show_folders_finish() to get the result of the operation.
 *
 * See nautilus_freedesktop_file_manager1_call_show_folders_sync() for the synchronous, blocking version of this method.
 */
void
nautilus_freedesktop_file_manager1_call_show_folders (
    NautilusFreedesktopFileManager1 *proxy,
    const gchar *const *arg_URIs,
    const gchar *arg_StartupId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowFolders",
    g_variant_new ("(^ass)",
                   arg_URIs,
                   arg_StartupId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nautilus_freedesktop_file_manager1_call_show_folders_finish:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nautilus_freedesktop_file_manager1_call_show_folders().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nautilus_freedesktop_file_manager1_call_show_folders().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nautilus_freedesktop_file_manager1_call_show_folders_finish (
    NautilusFreedesktopFileManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nautilus_freedesktop_file_manager1_call_show_folders_sync:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @arg_URIs: Argument to pass with the method invocation.
 * @arg_StartupId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowFolders">ShowFolders()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nautilus_freedesktop_file_manager1_call_show_folders() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nautilus_freedesktop_file_manager1_call_show_folders_sync (
    NautilusFreedesktopFileManager1 *proxy,
    const gchar *const *arg_URIs,
    const gchar *arg_StartupId,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowFolders",
    g_variant_new ("(^ass)",
                   arg_URIs,
                   arg_StartupId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nautilus_freedesktop_file_manager1_call_show_items:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @arg_URIs: Argument to pass with the method invocation.
 * @arg_StartupId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItems">ShowItems()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nautilus_freedesktop_file_manager1_call_show_items_finish() to get the result of the operation.
 *
 * See nautilus_freedesktop_file_manager1_call_show_items_sync() for the synchronous, blocking version of this method.
 */
void
nautilus_freedesktop_file_manager1_call_show_items (
    NautilusFreedesktopFileManager1 *proxy,
    const gchar *const *arg_URIs,
    const gchar *arg_StartupId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowItems",
    g_variant_new ("(^ass)",
                   arg_URIs,
                   arg_StartupId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nautilus_freedesktop_file_manager1_call_show_items_finish:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nautilus_freedesktop_file_manager1_call_show_items().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nautilus_freedesktop_file_manager1_call_show_items().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nautilus_freedesktop_file_manager1_call_show_items_finish (
    NautilusFreedesktopFileManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nautilus_freedesktop_file_manager1_call_show_items_sync:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @arg_URIs: Argument to pass with the method invocation.
 * @arg_StartupId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItems">ShowItems()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nautilus_freedesktop_file_manager1_call_show_items() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nautilus_freedesktop_file_manager1_call_show_items_sync (
    NautilusFreedesktopFileManager1 *proxy,
    const gchar *const *arg_URIs,
    const gchar *arg_StartupId,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowItems",
    g_variant_new ("(^ass)",
                   arg_URIs,
                   arg_StartupId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nautilus_freedesktop_file_manager1_call_show_item_properties:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @arg_URIs: Argument to pass with the method invocation.
 * @arg_StartupId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItemProperties">ShowItemProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nautilus_freedesktop_file_manager1_call_show_item_properties_finish() to get the result of the operation.
 *
 * See nautilus_freedesktop_file_manager1_call_show_item_properties_sync() for the synchronous, blocking version of this method.
 */
void
nautilus_freedesktop_file_manager1_call_show_item_properties (
    NautilusFreedesktopFileManager1 *proxy,
    const gchar *const *arg_URIs,
    const gchar *arg_StartupId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowItemProperties",
    g_variant_new ("(^ass)",
                   arg_URIs,
                   arg_StartupId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nautilus_freedesktop_file_manager1_call_show_item_properties_finish:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nautilus_freedesktop_file_manager1_call_show_item_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nautilus_freedesktop_file_manager1_call_show_item_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nautilus_freedesktop_file_manager1_call_show_item_properties_finish (
    NautilusFreedesktopFileManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nautilus_freedesktop_file_manager1_call_show_item_properties_sync:
 * @proxy: A #NautilusFreedesktopFileManager1Proxy.
 * @arg_URIs: Argument to pass with the method invocation.
 * @arg_StartupId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItemProperties">ShowItemProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nautilus_freedesktop_file_manager1_call_show_item_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nautilus_freedesktop_file_manager1_call_show_item_properties_sync (
    NautilusFreedesktopFileManager1 *proxy,
    const gchar *const *arg_URIs,
    const gchar *arg_StartupId,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowItemProperties",
    g_variant_new ("(^ass)",
                   arg_URIs,
                   arg_StartupId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nautilus_freedesktop_file_manager1_complete_show_folders:
 * @object: A #NautilusFreedesktopFileManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowFolders">ShowFolders()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nautilus_freedesktop_file_manager1_complete_show_folders (
    NautilusFreedesktopFileManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nautilus_freedesktop_file_manager1_complete_show_items:
 * @object: A #NautilusFreedesktopFileManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItems">ShowItems()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nautilus_freedesktop_file_manager1_complete_show_items (
    NautilusFreedesktopFileManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nautilus_freedesktop_file_manager1_complete_show_item_properties:
 * @object: A #NautilusFreedesktopFileManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-FileManager1.ShowItemProperties">ShowItemProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nautilus_freedesktop_file_manager1_complete_show_item_properties (
    NautilusFreedesktopFileManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NautilusFreedesktopFileManager1Proxy:
 *
 * The #NautilusFreedesktopFileManager1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NautilusFreedesktopFileManager1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NautilusFreedesktopFileManager1Proxy.
 */

struct _NautilusFreedesktopFileManager1ProxyPrivate
{
  GData *qdata;
};

static void nautilus_freedesktop_file_manager1_proxy_iface_init (NautilusFreedesktopFileManager1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NautilusFreedesktopFileManager1Proxy, nautilus_freedesktop_file_manager1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NautilusFreedesktopFileManager1Proxy)
                         G_IMPLEMENT_INTERFACE (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1, nautilus_freedesktop_file_manager1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NautilusFreedesktopFileManager1Proxy, nautilus_freedesktop_file_manager1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1, nautilus_freedesktop_file_manager1_proxy_iface_init))

#endif
static void
nautilus_freedesktop_file_manager1_proxy_finalize (GObject *object)
{
  NautilusFreedesktopFileManager1Proxy *proxy = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nautilus_freedesktop_file_manager1_proxy_parent_class)->finalize (object);
}

static void
nautilus_freedesktop_file_manager1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _nautilus_freedesktop_file_manager1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nautilus_freedesktop_file_manager1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.FileManager1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nautilus_freedesktop_file_manager1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _nautilus_freedesktop_file_manager1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.FileManager1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nautilus_freedesktop_file_manager1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nautilus_freedesktop_file_manager1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nautilus_freedesktop_file_manager1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nautilus_freedesktop_file_manager1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NautilusFreedesktopFileManager1Proxy *proxy = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nautilus_freedesktop_file_manager1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nautilus_freedesktop_file_manager1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
nautilus_freedesktop_file_manager1_proxy_get_open_locations (NautilusFreedesktopFileManager1 *object)
{
  NautilusFreedesktopFileManager1Proxy *proxy = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "OpenLocations");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpenLocations");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "OpenLocations", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
nautilus_freedesktop_file_manager1_proxy_get_open_windows_with_locations (NautilusFreedesktopFileManager1 *object)
{
  NautilusFreedesktopFileManager1Proxy *proxy = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpenWindowsWithLocations");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
nautilus_freedesktop_file_manager1_proxy_init (NautilusFreedesktopFileManager1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nautilus_freedesktop_file_manager1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_PROXY, NautilusFreedesktopFileManager1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nautilus_freedesktop_file_manager1_interface_info ());
}

static void
nautilus_freedesktop_file_manager1_proxy_class_init (NautilusFreedesktopFileManager1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nautilus_freedesktop_file_manager1_proxy_finalize;
  gobject_class->get_property = nautilus_freedesktop_file_manager1_proxy_get_property;
  gobject_class->set_property = nautilus_freedesktop_file_manager1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nautilus_freedesktop_file_manager1_proxy_g_signal;
  proxy_class->g_properties_changed = nautilus_freedesktop_file_manager1_proxy_g_properties_changed;

  nautilus_freedesktop_file_manager1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NautilusFreedesktopFileManager1ProxyPrivate));
#endif
}

static void
nautilus_freedesktop_file_manager1_proxy_iface_init (NautilusFreedesktopFileManager1Iface *iface)
{
  iface->get_open_locations = nautilus_freedesktop_file_manager1_proxy_get_open_locations;
  iface->get_open_windows_with_locations = nautilus_freedesktop_file_manager1_proxy_get_open_windows_with_locations;
}

/**
 * nautilus_freedesktop_file_manager1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nautilus_freedesktop_file_manager1_proxy_new_finish() to get the result of the operation.
 *
 * See nautilus_freedesktop_file_manager1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nautilus_freedesktop_file_manager1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.FileManager1", NULL);
}

/**
 * nautilus_freedesktop_file_manager1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nautilus_freedesktop_file_manager1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nautilus_freedesktop_file_manager1_proxy_new().
 *
 * Returns: (transfer full) (type NautilusFreedesktopFileManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
NautilusFreedesktopFileManager1 *
nautilus_freedesktop_file_manager1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NAUTILUS_FREEDESKTOP_FILE_MANAGER1 (ret);
  else
    return NULL;
}

/**
 * nautilus_freedesktop_file_manager1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nautilus_freedesktop_file_manager1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NautilusFreedesktopFileManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
NautilusFreedesktopFileManager1 *
nautilus_freedesktop_file_manager1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.FileManager1", NULL);
  if (ret != NULL)
    return NAUTILUS_FREEDESKTOP_FILE_MANAGER1 (ret);
  else
    return NULL;
}


/**
 * nautilus_freedesktop_file_manager1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nautilus_freedesktop_file_manager1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nautilus_freedesktop_file_manager1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nautilus_freedesktop_file_manager1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nautilus_freedesktop_file_manager1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.FileManager1", NULL);
}

/**
 * nautilus_freedesktop_file_manager1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nautilus_freedesktop_file_manager1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nautilus_freedesktop_file_manager1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NautilusFreedesktopFileManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
NautilusFreedesktopFileManager1 *
nautilus_freedesktop_file_manager1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NAUTILUS_FREEDESKTOP_FILE_MANAGER1 (ret);
  else
    return NULL;
}

/**
 * nautilus_freedesktop_file_manager1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nautilus_freedesktop_file_manager1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nautilus_freedesktop_file_manager1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NautilusFreedesktopFileManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
NautilusFreedesktopFileManager1 *
nautilus_freedesktop_file_manager1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.FileManager1", NULL);
  if (ret != NULL)
    return NAUTILUS_FREEDESKTOP_FILE_MANAGER1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NautilusFreedesktopFileManager1Skeleton:
 *
 * The #NautilusFreedesktopFileManager1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NautilusFreedesktopFileManager1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NautilusFreedesktopFileManager1Skeleton.
 */

struct _NautilusFreedesktopFileManager1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nautilus_freedesktop_file_manager1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nautilus_freedesktop_file_manager1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nautilus_freedesktop_file_manager1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nautilus_freedesktop_file_manager1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nautilus_freedesktop_file_manager1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nautilus_freedesktop_file_manager1_skeleton_vtable =
{
  _nautilus_freedesktop_file_manager1_skeleton_handle_method_call,
  _nautilus_freedesktop_file_manager1_skeleton_handle_get_property,
  _nautilus_freedesktop_file_manager1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nautilus_freedesktop_file_manager1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nautilus_freedesktop_file_manager1_interface_info ();
}

static GDBusInterfaceVTable *
nautilus_freedesktop_file_manager1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nautilus_freedesktop_file_manager1_skeleton_vtable;
}

static GVariant *
nautilus_freedesktop_file_manager1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nautilus_freedesktop_file_manager1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nautilus_freedesktop_file_manager1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nautilus_freedesktop_file_manager1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nautilus_freedesktop_file_manager1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.FileManager1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nautilus_freedesktop_file_manager1_emit_changed (gpointer user_data);

static void
nautilus_freedesktop_file_manager1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nautilus_freedesktop_file_manager1_emit_changed (skeleton);
}

static void nautilus_freedesktop_file_manager1_skeleton_iface_init (NautilusFreedesktopFileManager1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NautilusFreedesktopFileManager1Skeleton, nautilus_freedesktop_file_manager1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NautilusFreedesktopFileManager1Skeleton)
                         G_IMPLEMENT_INTERFACE (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1, nautilus_freedesktop_file_manager1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NautilusFreedesktopFileManager1Skeleton, nautilus_freedesktop_file_manager1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1, nautilus_freedesktop_file_manager1_skeleton_iface_init))

#endif
static void
nautilus_freedesktop_file_manager1_skeleton_finalize (GObject *object)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nautilus_freedesktop_file_manager1_skeleton_parent_class)->finalize (object);
}

static void
nautilus_freedesktop_file_manager1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nautilus_freedesktop_file_manager1_emit_changed (gpointer user_data)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.FileManager1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nautilus_freedesktop_file_manager1_schedule_emit_changed (NautilusFreedesktopFileManager1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nautilus_freedesktop_file_manager1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nautilus_freedesktop_file_manager1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nautilus_freedesktop_file_manager1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nautilus_freedesktop_file_manager1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _nautilus_freedesktop_file_manager1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nautilus_freedesktop_file_manager1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nautilus_freedesktop_file_manager1_skeleton_init (NautilusFreedesktopFileManager1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nautilus_freedesktop_file_manager1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_SKELETON, NautilusFreedesktopFileManager1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
}

static const gchar *const *
nautilus_freedesktop_file_manager1_skeleton_get_open_locations (NautilusFreedesktopFileManager1 *object)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nautilus_freedesktop_file_manager1_skeleton_get_open_windows_with_locations (NautilusFreedesktopFileManager1 *object)
{
  NautilusFreedesktopFileManager1Skeleton *skeleton = NAUTILUS_FREEDESKTOP_FILE_MANAGER1_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nautilus_freedesktop_file_manager1_skeleton_class_init (NautilusFreedesktopFileManager1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nautilus_freedesktop_file_manager1_skeleton_finalize;
  gobject_class->get_property = nautilus_freedesktop_file_manager1_skeleton_get_property;
  gobject_class->set_property = nautilus_freedesktop_file_manager1_skeleton_set_property;
  gobject_class->notify       = nautilus_freedesktop_file_manager1_skeleton_notify;


  nautilus_freedesktop_file_manager1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nautilus_freedesktop_file_manager1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nautilus_freedesktop_file_manager1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nautilus_freedesktop_file_manager1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nautilus_freedesktop_file_manager1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NautilusFreedesktopFileManager1SkeletonPrivate));
#endif
}

static void
nautilus_freedesktop_file_manager1_skeleton_iface_init (NautilusFreedesktopFileManager1Iface *iface)
{
  iface->get_open_locations = nautilus_freedesktop_file_manager1_skeleton_get_open_locations;
  iface->get_open_windows_with_locations = nautilus_freedesktop_file_manager1_skeleton_get_open_windows_with_locations;
}

/**
 * nautilus_freedesktop_file_manager1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-FileManager1.top_of_page">org.freedesktop.FileManager1</link>.
 *
 * Returns: (transfer full) (type NautilusFreedesktopFileManager1Skeleton): The skeleton object.
 */
NautilusFreedesktopFileManager1 *
nautilus_freedesktop_file_manager1_skeleton_new (void)
{
  return NAUTILUS_FREEDESKTOP_FILE_MANAGER1 (g_object_new (NAUTILUS_FREEDESKTOP_TYPE_FILE_MANAGER1_SKELETON, NULL));
}

