/*
 * Copyright (c) 2018-2020 Cisco Systems, Inc.  All rights reserved
 * Copyright (c) 2019-2020 Intel, Inc.  All rights reserved.
 * Copyright (c) 2021      Nanook Consulting.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#include "prte_config.h"

#include <assert.h>

#include "src/util/string_copy.h"

void prte_string_copy(char *dest, const char *src, size_t dest_len)
{
    size_t i;
    char *new_dest = dest;

    // PRTE does not do *giant* string copies.  Hence, we use the
    // hueristic: if "dest_len" is too large, this is a programmer
    // error.  We pseudo-arbitrarily pick a large value to be the max
    // allowable dest_len: 128K.  If we ever need to increase this
    // value someday (because something has a legit reason to
    // prte_string_copy() more than 128K), the core dumps that are
    // generated by the assert() failure should make this fairly
    // obvious.
    assert(dest_len <= PRTE_MAX_SIZE_ALLOWED_BY_PMIX_STRING_COPY);

    for (i = 0; i < dest_len; ++i, ++src, ++new_dest) {
        *new_dest = *src;
        if ('\0' == *src) {
            return;
        }
    }

    dest[i - 1] = '\0';
}
