/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.FeatureInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsIntrospectionSource.class);
    private Registry registry;
    private String type;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private static final Hashtable<String, String> specialMethods = new Hashtable();
    private static final Class<?>[] supportedTypes;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String string, Object object) throws Exception {
        this.setRegistry(registry);
        this.setType(string);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            ManagedBean managedBean = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managedBean == null) {
                return;
            }
            managedBean.setName(this.type);
            this.registry.addManagedBean(managedBean);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("modules.readDescriptorsError"), (Throwable)exception);
        }
    }

    private boolean supportedType(Class<?> clazz) {
        for (Class<?> clazz2 : supportedTypes) {
            if (clazz != clazz2) continue;
            return true;
        }
        return this.isBeanCompatible(clazz);
    }

    private boolean isBeanCompatible(Class<?> clazz) {
        if (clazz.isArray() || clazz.isPrimitive()) {
            return false;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        return clazz2 == null || clazz2 == Object.class || clazz2 == Exception.class || clazz2 == Throwable.class || this.isBeanCompatible(clazz2);
    }

    private void initMethods(Class<?> clazz, Method[] methodArray, Hashtable<String, Method> hashtable, Hashtable<String, Method> hashtable2, Hashtable<String, Method> hashtable3, Hashtable<String, Method> hashtable4) {
        for (Method method : methodArray) {
            String string = method.getName();
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Not public " + method));
                continue;
            }
            if (method.getDeclaringClass() == Object.class) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (string.startsWith("get") && classArray.length == 0) {
                Class<?> clazz2 = method.getReturnType();
                if (!this.supportedType(clazz2)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unsupported type " + method));
                    continue;
                }
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                hashtable2.put(string, method);
                hashtable.put(string, method);
                continue;
            }
            if (string.startsWith("is") && classArray.length == 0) {
                Class<?> clazz3 = method.getReturnType();
                if (Boolean.TYPE != clazz3) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unsupported type " + method + " " + clazz3));
                    continue;
                }
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(2));
                hashtable2.put(string, method);
                hashtable.put(string, method);
                continue;
            }
            if (string.startsWith("set") && classArray.length == 1) {
                if (!this.supportedType(classArray[0])) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unsupported type " + method + " " + classArray[0]));
                    continue;
                }
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                hashtable3.put(string, method);
                hashtable.put(string, method);
                continue;
            }
            if (classArray.length == 0) {
                if (specialMethods.get(method.getName()) != null) continue;
                hashtable4.put(string, method);
                continue;
            }
            boolean bl = true;
            for (Class<?> clazz4 : classArray) {
                if (this.supportedType(clazz4)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hashtable4.put(string, method);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String string, Class<?> clazz, String string2) {
        ManagedBean managedBean = new ManagedBean();
        Method[] methodArray = null;
        Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
        Hashtable<String, Method> hashtable2 = new Hashtable<String, Method>();
        Hashtable<String, Method> hashtable3 = new Hashtable<String, Method>();
        Hashtable<String, Method> hashtable4 = new Hashtable<String, Method>();
        methodArray = clazz.getMethods();
        this.initMethods(clazz, methodArray, hashtable, hashtable2, hashtable3, hashtable4);
        try {
            Serializable serializable;
            GenericDeclaration genericDeclaration;
            Object object;
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                AttributeInfo object2 = new AttributeInfo();
                object2.setName(string3);
                object = hashtable2.get(string3);
                if (object != null) {
                    object2.setGetMethod(((Method)object).getName());
                    genericDeclaration = ((Method)object).getReturnType();
                    if (genericDeclaration != null) {
                        object2.setType(((Class)genericDeclaration).getName());
                    }
                }
                if ((genericDeclaration = hashtable3.get(string3)) != null) {
                    serializable = ((Method)genericDeclaration).getParameterTypes()[0];
                    if (serializable != null) {
                        object2.setType(((Class)serializable).getName());
                    }
                    object2.setSetMethod(((Method)genericDeclaration).getName());
                }
                object2.setDescription("Introspected attribute " + (String)string3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Introspected attribute " + (String)string3 + " " + object + " " + genericDeclaration));
                }
                if (object == null) {
                    object2.setReadable(false);
                }
                if (genericDeclaration == null) {
                    object2.setWriteable(false);
                }
                if (genericDeclaration == null && object == null) continue;
                managedBean.addAttribute(object2);
            }
            for (Map.Entry entry : hashtable4.entrySet()) {
                object = (String)entry.getKey();
                genericDeclaration = (Method)entry.getValue();
                serializable = new OperationInfo();
                ((FeatureInfo)serializable).setName((String)object);
                ((OperationInfo)serializable).setReturnType(((Method)genericDeclaration).getReturnType().getName());
                ((FeatureInfo)serializable).setDescription("Introspected operation " + (String)object);
                Class<?>[] classArray = ((Method)genericDeclaration).getParameterTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    ParameterInfo parameterInfo = new ParameterInfo();
                    parameterInfo.setType(classArray[i].getName());
                    parameterInfo.setName(("param" + i).intern());
                    parameterInfo.setDescription(("Introspected parameter param" + i).intern());
                    ((OperationInfo)serializable).addParameter(parameterInfo);
                }
                managedBean.addOperation((OperationInfo)serializable);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting name: " + string2));
            }
            managedBean.setName(string2);
            return managedBean;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, String[].class, BigDecimal.class, BigInteger.class, ObjectName.class, Object[].class, File.class};
    }
}

