/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.GzipInterceptorMBean;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GzipInterceptor
extends ChannelInterceptorBase
implements GzipInterceptorMBean {
    private static final Log log = LogFactory.getLog(GzipInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(GzipInterceptor.class);
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_OPTION_COMPRESSION_ENABLE = 256;
    private int compressionMinSize = 0;
    private volatile boolean statsEnabled = false;
    private int interval = 0;
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicInteger countCompressedTX = new AtomicInteger();
    private final AtomicInteger countUncompressedTX = new AtomicInteger();
    private final AtomicInteger countCompressedRX = new AtomicInteger();
    private final AtomicInteger countUncompressedRX = new AtomicInteger();
    private final AtomicLong sizeTX = new AtomicLong();
    private final AtomicLong compressedSizeTX = new AtomicLong();
    private final AtomicLong uncompressedSizeTX = new AtomicLong();
    private final AtomicLong sizeRX = new AtomicLong();
    private final AtomicLong compressedSizeRX = new AtomicLong();
    private final AtomicLong uncompressedSizeRX = new AtomicLong();

    public GzipInterceptor() {
        this.setOptionFlag(256);
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        try {
            byte[] byArray = channelMessage.getMessage().getBytes();
            if (this.statsEnabled) {
                this.sizeTX.addAndGet(byArray.length);
            }
            if (byArray.length > this.compressionMinSize) {
                byArray = GzipInterceptor.compress(byArray);
                channelMessage.setOptions(channelMessage.getOptions() | this.getOptionFlag());
                if (this.statsEnabled) {
                    this.countCompressedTX.incrementAndGet();
                    this.compressedSizeTX.addAndGet(byArray.length);
                }
            } else if (this.statsEnabled) {
                this.countUncompressedTX.incrementAndGet();
                this.uncompressedSizeTX.addAndGet(byArray.length);
            }
            channelMessage.getMessage().trim(channelMessage.getMessage().getLength());
            channelMessage.getMessage().append(byArray, 0, byArray.length);
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
            int n = this.count.incrementAndGet();
            if (this.statsEnabled && this.interval > 0 && n % this.interval == 0) {
                this.report();
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("gzipInterceptor.compress.failed"));
            throw new ChannelException(iOException);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        try {
            byte[] byArray = channelMessage.getMessage().getBytes();
            if ((channelMessage.getOptions() & this.getOptionFlag()) > 0) {
                if (this.statsEnabled) {
                    this.countCompressedRX.incrementAndGet();
                    this.compressedSizeRX.addAndGet(byArray.length);
                }
                byArray = GzipInterceptor.decompress(byArray);
            } else if (this.statsEnabled) {
                this.countUncompressedRX.incrementAndGet();
                this.uncompressedSizeRX.addAndGet(byArray.length);
            }
            if (this.statsEnabled) {
                this.sizeRX.addAndGet(byArray.length);
            }
            channelMessage.getMessage().trim(channelMessage.getMessage().getLength());
            channelMessage.getMessage().append(byArray, 0, byArray.length);
            super.messageReceived(channelMessage);
            int n = this.count.incrementAndGet();
            if (this.statsEnabled && this.interval > 0 && n % this.interval == 0) {
                this.report();
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("gzipInterceptor.decompress.failed"), (Throwable)iOException);
        }
    }

    public static byte[] compress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.flush();
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decompress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[2048];
        int n = gZIPInputStream.read(byArray2);
        while (n > -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = gZIPInputStream.read(byArray2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void report() {
        log.info((Object)sm.getString("gzipInterceptor.report", this.getCount(), this.getCountCompressedTX(), this.getCountUncompressedTX(), this.getCountCompressedRX(), this.getCountUncompressedRX(), this.getSizeTX(), this.getCompressedSizeTX(), this.getUncompressedSizeTX(), this.getSizeRX(), this.getCompressedSizeRX(), this.getUncompressedSizeRX()));
    }

    @Override
    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    @Override
    public void setCompressionMinSize(int n) {
        this.compressionMinSize = n;
    }

    @Override
    public boolean getStatsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public void setStatsEnabled(boolean bl) {
        this.statsEnabled = bl;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(int n) {
        this.interval = n;
    }

    @Override
    public int getCount() {
        return this.count.get();
    }

    @Override
    public int getCountCompressedTX() {
        return this.countCompressedTX.get();
    }

    @Override
    public int getCountUncompressedTX() {
        return this.countUncompressedTX.get();
    }

    @Override
    public int getCountCompressedRX() {
        return this.countCompressedRX.get();
    }

    @Override
    public int getCountUncompressedRX() {
        return this.countUncompressedRX.get();
    }

    @Override
    public long getSizeTX() {
        return this.sizeTX.get();
    }

    @Override
    public long getCompressedSizeTX() {
        return this.compressedSizeTX.get();
    }

    @Override
    public long getUncompressedSizeTX() {
        return this.uncompressedSizeTX.get();
    }

    @Override
    public long getSizeRX() {
        return this.sizeRX.get();
    }

    @Override
    public long getCompressedSizeRX() {
        return this.compressedSizeRX.get();
    }

    @Override
    public long getUncompressedSizeRX() {
        return this.uncompressedSizeRX.get();
    }

    @Override
    public void reset() {
        this.count.set(0);
        this.countCompressedTX.set(0);
        this.countUncompressedTX.set(0);
        this.countCompressedRX.set(0);
        this.countUncompressedRX.set(0);
        this.sizeTX.set(0L);
        this.compressedSizeTX.set(0L);
        this.uncompressedSizeTX.set(0L);
        this.sizeRX.set(0L);
        this.compressedSizeRX.set(0L);
        this.uncompressedSizeRX.set(0L);
    }
}

