/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.graph;

import org.openjdk.jmc.flightrecorder.stacktrace.graph.AggregatableFrame;

public final class Node {
    private final Integer nodeId;
    private final AggregatableFrame frame;
    int count;
    int cumulativeCount;
    double weight;
    double cumulativeWeight;

    public Node(Integer nodeId, AggregatableFrame frame) {
        this.nodeId = nodeId;
        this.frame = frame;
        if (frame == null) {
            throw new NullPointerException("Frame cannot be null!");
        }
    }

    public int getCount() {
        return this.count;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getCumulativeCount() {
        return this.cumulativeCount;
    }

    public AggregatableFrame getFrame() {
        return this.frame;
    }

    public int hashCode() {
        return this.frame.getMethod().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.frame == null && other.frame != null) {
            return false;
        }
        return this.frame.equals(other.frame);
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return String.format("%s counts:%d(%d),weights:%.2f(%.2f)", this.frame.toString(), this.count, this.cumulativeCount, this.weight, this.cumulativeWeight);
    }
}

