/* tracker-bus-fd-cursor.c generated by valac 0.56.2, the Vala compiler
 * generated from tracker-bus-fd-cursor.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "libtracker-sparql/tracker-sparql.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "tracker-bus.h"

#define TRACKER_BUS_TYPE_FD_CURSOR (tracker_bus_fd_cursor_get_type ())
#define TRACKER_BUS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursor))
#define TRACKER_BUS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))
#define TRACKER_BUS_IS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_IS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_FD_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))

typedef struct _TrackerBusFDCursor TrackerBusFDCursor;
typedef struct _TrackerBusFDCursorClass TrackerBusFDCursorClass;
typedef struct _TrackerBusFDCursorPrivate TrackerBusFDCursorPrivate;
enum  {
	TRACKER_BUS_FD_CURSOR_0_PROPERTY,
	TRACKER_BUS_FD_CURSOR_N_COLUMNS_PROPERTY,
	TRACKER_BUS_FD_CURSOR_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_fd_cursor_properties[TRACKER_BUS_FD_CURSOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerBusFdCursorNextAsyncData TrackerBusFdCursorNextAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerBusFDCursor {
	TrackerSparqlCursor parent_instance;
	TrackerBusFDCursorPrivate * priv;
	gchar* buffer;
	gulong buffer_index;
	gulong buffer_size;
	gint _n_columns;
	gint* offsets;
	gint* types;
	gchar* data;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
	gboolean cursor_finished;
};

struct _TrackerBusFDCursorClass {
	TrackerSparqlCursorClass parent_class;
};

struct _TrackerBusFdCursorNextAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusFDCursor* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

static gpointer tracker_bus_fd_cursor_parent_class = NULL;

VALA_EXTERN GType tracker_bus_fd_cursor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TrackerBusFDCursor* tracker_bus_fd_cursor_new (gchar* buffer,
                                               gulong buffer_size,
                                               gchar** variable_names,
                                               gint variable_names_length1);
VALA_EXTERN TrackerBusFDCursor* tracker_bus_fd_cursor_construct (GType object_type,
                                                     gchar* buffer,
                                                     gulong buffer_size,
                                                     gchar** variable_names,
                                                     gint variable_names_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static inline gint tracker_bus_fd_cursor_buffer_read_int (TrackerBusFDCursor* self);
static TrackerSparqlValueType tracker_bus_fd_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                                                  gint column);
static const gchar* tracker_bus_fd_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                           gint column);
static const gchar* tracker_bus_fd_cursor_real_get_string (TrackerSparqlCursor* base,
                                                    gint column,
                                                    glong* length);
static gboolean tracker_bus_fd_cursor_real_next (TrackerSparqlCursor* base,
                                          GCancellable* cancellable,
                                          GError** error);
static void tracker_bus_fd_cursor_real_next_async_data_free (gpointer _data);
static void tracker_bus_fd_cursor_real_next_async (TrackerSparqlCursor* base,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean tracker_bus_fd_cursor_real_next_async_co (TrackerBusFdCursorNextAsyncData* _data_);
static void tracker_bus_fd_cursor_real_rewind (TrackerSparqlCursor* base);
static void tracker_bus_fd_cursor_real_close (TrackerSparqlCursor* base);
static void tracker_bus_fd_cursor_finalize (GObject * obj);
static GType tracker_bus_fd_cursor_get_type_once (void);
static void _vala_tracker_bus_fd_cursor_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (length >= 0) {
#line 139 "tracker-bus-fd-cursor.c"
		gchar** result;
		gssize i;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		result = g_new0 (gchar*, length + 1);
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		for (i = 0; i < length; i++) {
#line 146 "tracker-bus-fd-cursor.c"
			gchar* _tmp0_;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
			_tmp0_ = g_strdup (self[i]);
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
			result[i] = _tmp0_;
#line 152 "tracker-bus-fd-cursor.c"
		}
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return result;
#line 156 "tracker-bus-fd-cursor.c"
	}
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return NULL;
#line 160 "tracker-bus-fd-cursor.c"
}

TrackerBusFDCursor*
tracker_bus_fd_cursor_construct (GType object_type,
                                 gchar* buffer,
                                 gulong buffer_size,
                                 gchar** variable_names,
                                 gint variable_names_length1)
{
	TrackerBusFDCursor * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 33 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) g_object_new (object_type, NULL);
#line 34 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer = buffer;
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer_size = buffer_size;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = (variable_names != NULL) ? _vala_array_dup1 (variable_names, variable_names_length1) : variable_names;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0__length1 = variable_names_length1;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->variable_names = (_vala_array_free (self->variable_names, self->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->variable_names = _tmp0_;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->variable_names_length1 = _tmp0__length1;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->_variable_names_size_ = self->variable_names_length1;
#line 37 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->cursor_finished = TRUE;
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->_n_columns = variable_names_length1;
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return self;
#line 197 "tracker-bus-fd-cursor.c"
}

TrackerBusFDCursor*
tracker_bus_fd_cursor_new (gchar* buffer,
                           gulong buffer_size,
                           gchar** variable_names,
                           gint variable_names_length1)
{
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return tracker_bus_fd_cursor_construct (TRACKER_BUS_TYPE_FD_CURSOR, buffer, buffer_size, variable_names, variable_names_length1);
#line 208 "tracker-bus-fd-cursor.c"
}

static inline gint
tracker_bus_fd_cursor_buffer_read_int (TrackerBusFDCursor* self)
{
	gint v = 0;
	gchar* _tmp0_;
	gint result;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = self->buffer;
#line 46 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	v = *((gint*) (_tmp0_ + self->buffer_index));
#line 48 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer_index = self->buffer_index + 4;
#line 50 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = v;
#line 50 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 229 "tracker-bus-fd-cursor.c"
}

static TrackerSparqlValueType
tracker_bus_fd_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                           gint column)
{
	TrackerBusFDCursor * self;
	gint* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint* _tmp3_;
	gint _tmp4_;
	TrackerSparqlValueType result;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = self->types;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_vala_return_val_if_fail (_tmp0_ != NULL, "types != null", 0);
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp1_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self);
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp2_ = _tmp1_;
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (column >= _tmp2_) {
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		result = TRACKER_SPARQL_VALUE_TYPE_UNBOUND;
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return result;
#line 259 "tracker-bus-fd-cursor.c"
	}
#line 64 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp3_ = self->types;
#line 64 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp4_ = _tmp3_[column];
#line 64 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = (TrackerSparqlValueType) _tmp4_;
#line 64 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 269 "tracker-bus-fd-cursor.c"
}

static const gchar*
tracker_bus_fd_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                              gint column)
{
	TrackerBusFDCursor * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	const gchar* result;
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = self->variable_names;
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0__length1 = self->variable_names_length1;
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_vala_return_val_if_fail (_tmp0_ != NULL, "variable_names != null", NULL);
#line 69 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp1_ = self->variable_names;
#line 69 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp1__length1 = self->variable_names_length1;
#line 69 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp2_ = _tmp1_[column];
#line 69 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = _tmp2_;
#line 69 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 301 "tracker-bus-fd-cursor.c"
}

static const gchar*
tracker_bus_fd_cursor_real_get_string (TrackerSparqlCursor* base,
                                       gint column,
                                       glong* length)
{
	TrackerBusFDCursor * self;
	glong _vala_length = 0L;
	const gchar* str = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp3_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	const gchar* _tmp11_;
	const gchar* result;
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_vala_return_val_if_fail (self->cursor_finished == FALSE, "cursor_finished == false", NULL);
#line 74 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	str = NULL;
#line 76 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self);
#line 76 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp1_ = _tmp0_;
#line 76 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (column >= _tmp1_) {
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_vala_length = (glong) 0;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		result = NULL;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		if (length) {
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
			*length = _vala_length;
#line 341 "tracker-bus-fd-cursor.c"
		}
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return result;
#line 345 "tracker-bus-fd-cursor.c"
	}
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp2_ = self->types;
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp3_ = _tmp2_[column];
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (_tmp3_ == ((gint) TRACKER_SPARQL_VALUE_TYPE_UNBOUND)) {
#line 83 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_vala_length = (glong) 0;
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		result = NULL;
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		if (length) {
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
			*length = _vala_length;
#line 361 "tracker-bus-fd-cursor.c"
		}
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return result;
#line 365 "tracker-bus-fd-cursor.c"
	}
#line 87 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (column == 0) {
#line 369 "tracker-bus-fd-cursor.c"
		gchar* _tmp4_;
#line 88 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp4_ = self->data;
#line 88 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		str = (const gchar*) _tmp4_;
#line 375 "tracker-bus-fd-cursor.c"
	} else {
		gchar* _tmp5_;
		gint* _tmp6_;
		gint _tmp7_;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp5_ = self->data;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp6_ = self->offsets;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp7_ = _tmp6_[column - 1];
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		str = (const gchar*) ((_tmp5_ + _tmp7_) + 1);
#line 388 "tracker-bus-fd-cursor.c"
	}
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp8_ = str;
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp9_ = strlen (_tmp8_);
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp10_ = _tmp9_;
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_vala_length = (glong) _tmp10_;
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp11_ = str;
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = _tmp11_;
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (length) {
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		*length = _vala_length;
#line 406 "tracker-bus-fd-cursor.c"
	}
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 410 "tracker-bus-fd-cursor.c"
}

static gboolean
tracker_bus_fd_cursor_real_next (TrackerSparqlCursor* base,
                                 GCancellable* cancellable,
                                 GError** error)
{
	TrackerBusFDCursor * self;
	gint last_offset = 0;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 101 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (cancellable != NULL) {
#line 101 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp0_ = g_cancellable_is_cancelled (cancellable);
#line 436 "tracker-bus-fd-cursor.c"
	} else {
#line 101 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp0_ = FALSE;
#line 440 "tracker-bus-fd-cursor.c"
	}
#line 101 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (_tmp0_) {
#line 444 "tracker-bus-fd-cursor.c"
		GError* _tmp1_;
		gboolean _tmp2_ = FALSE;
#line 102 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 102 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		_inner_error0_ = _tmp1_;
#line 102 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		g_propagate_error (error, _inner_error0_);
#line 102 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return _tmp2_;
#line 455 "tracker-bus-fd-cursor.c"
	}
#line 105 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (self->buffer_index >= self->buffer_size) {
#line 106 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		self->cursor_finished = TRUE;
#line 107 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		self->data = NULL;
#line 108 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		result = FALSE;
#line 108 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return result;
#line 467 "tracker-bus-fd-cursor.c"
	}
#line 118 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->_n_columns = tracker_bus_fd_cursor_buffer_read_int (self);
#line 122 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp3_ = self->buffer;
#line 122 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->types = (gint*) (_tmp3_ + self->buffer_index);
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp4_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self);
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp5_ = _tmp4_;
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer_index = self->buffer_index + (sizeof (gint) * _tmp5_);
#line 125 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp6_ = self->buffer;
#line 125 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->offsets = (gint*) (_tmp6_ + self->buffer_index);
#line 126 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp7_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self);
#line 126 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp8_ = _tmp7_;
#line 126 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer_index = self->buffer_index + (sizeof (gint) * (_tmp8_ - 1));
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	last_offset = tracker_bus_fd_cursor_buffer_read_int (self);
#line 129 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp9_ = self->buffer;
#line 129 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->data = _tmp9_ + self->buffer_index;
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->cursor_finished = FALSE;
#line 132 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer_index = self->buffer_index + (last_offset + 1);
#line 134 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = TRUE;
#line 134 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 505 "tracker-bus-fd-cursor.c"
}

static void
tracker_bus_fd_cursor_real_next_async_data_free (gpointer _data)
{
	TrackerBusFdCursorNextAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_slice_free (TrackerBusFdCursorNextAsyncData, _data_);
#line 519 "tracker-bus-fd-cursor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return self ? g_object_ref (self) : NULL;
#line 527 "tracker-bus-fd-cursor.c"
}

static void
tracker_bus_fd_cursor_real_next_async (TrackerSparqlCursor* base,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TrackerBusFDCursor * self;
	TrackerBusFdCursorNextAsyncData* _data_;
	TrackerBusFDCursor* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_ = g_slice_new0 (TrackerBusFdCursorNextAsyncData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_fd_cursor_real_next_async_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_->cancellable = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	tracker_bus_fd_cursor_real_next_async_co (_data_);
#line 560 "tracker-bus-fd-cursor.c"
}

static gboolean
tracker_bus_fd_cursor_next_finish (TrackerSparqlCursor* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	gboolean result;
	TrackerBusFdCursorNextAsyncData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (NULL == _data_) {
#line 574 "tracker-bus-fd-cursor.c"
		gboolean _tmp0_ = FALSE;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return _tmp0_;
#line 578 "tracker-bus-fd-cursor.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 584 "tracker-bus-fd-cursor.c"
}

static gboolean
tracker_bus_fd_cursor_real_next_async_co (TrackerBusFdCursorNextAsyncData* _data_)
{
#line 137 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	switch (_data_->_state_) {
#line 137 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		case 0:
#line 594 "tracker-bus-fd-cursor.c"
		goto _state_0;
		default:
#line 137 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		g_assert_not_reached ();
#line 599 "tracker-bus-fd-cursor.c"
	}
	_state_0:
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_->_tmp0_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _data_->self, _data_->cancellable, &_data_->_inner_error0_);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		g_object_unref (_data_->_async_result);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		return FALSE;
#line 612 "tracker-bus-fd-cursor.c"
	}
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_data_->result = _data_->_tmp0_;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	if (_data_->_state_ != 0) {
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 624 "tracker-bus-fd-cursor.c"
		}
	}
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_object_unref (_data_->_async_result);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return FALSE;
#line 631 "tracker-bus-fd-cursor.c"
}

static void
tracker_bus_fd_cursor_real_rewind (TrackerSparqlCursor* base)
{
	TrackerBusFDCursor * self;
	gchar* _tmp0_;
#line 142 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 143 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->buffer_index = (gulong) 0;
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = self->buffer;
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->data = _tmp0_;
#line 145 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->cursor_finished = FALSE;
#line 649 "tracker-bus-fd-cursor.c"
}

static void
tracker_bus_fd_cursor_real_close (TrackerSparqlCursor* base)
{
	TrackerBusFDCursor * self;
#line 148 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 658 "tracker-bus-fd-cursor.c"
}

static gint
tracker_bus_fd_cursor_real_get_n_columns (TrackerSparqlCursor* base)
{
	gint result;
	TrackerBusFDCursor* self;
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = (TrackerBusFDCursor*) base;
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	result = self->_n_columns;
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	return result;
#line 672 "tracker-bus-fd-cursor.c"
}

static void
tracker_bus_fd_cursor_class_init (TrackerBusFDCursorClass * klass,
                                  gpointer klass_data)
{
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	tracker_bus_fd_cursor_parent_class = g_type_class_peek_parent (klass);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_value_type = (TrackerSparqlValueType (*) (TrackerSparqlCursor*, gint)) tracker_bus_fd_cursor_real_get_value_type;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_variable_name = (const gchar* (*) (TrackerSparqlCursor*, gint)) tracker_bus_fd_cursor_real_get_variable_name;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_string = (const gchar* (*) (TrackerSparqlCursor*, gint, glong*)) tracker_bus_fd_cursor_real_get_string;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next = (gboolean (*) (TrackerSparqlCursor*, GCancellable*, GError**)) tracker_bus_fd_cursor_real_next;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_async = (void (*) (TrackerSparqlCursor*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_fd_cursor_real_next_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_finish = (gboolean (*) (TrackerSparqlCursor*, GAsyncResult*, GError**)) tracker_bus_fd_cursor_next_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->rewind = (void (*) (TrackerSparqlCursor*)) tracker_bus_fd_cursor_real_rewind;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->close = (void (*) (TrackerSparqlCursor*)) tracker_bus_fd_cursor_real_close;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	TRACKER_SPARQL_CURSOR_CLASS (klass)->get_n_columns = tracker_bus_fd_cursor_real_get_n_columns;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_bus_fd_cursor_get_property;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_fd_cursor_finalize;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_BUS_FD_CURSOR_N_COLUMNS_PROPERTY, tracker_bus_fd_cursor_properties[TRACKER_BUS_FD_CURSOR_N_COLUMNS_PROPERTY] = g_param_spec_int ("n-columns", "n-columns", "n-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 705 "tracker-bus-fd-cursor.c"
}

static void
tracker_bus_fd_cursor_instance_init (TrackerBusFDCursor * self,
                                     gpointer klass)
{
}

static void
tracker_bus_fd_cursor_finalize (GObject * obj)
{
	TrackerBusFDCursor * self;
	gchar* _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursor);
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	_tmp0_ = self->buffer;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	g_free (_tmp0_);
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	self->variable_names = (_vala_array_free (self->variable_names, self->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	G_OBJECT_CLASS (tracker_bus_fd_cursor_parent_class)->finalize (obj);
#line 729 "tracker-bus-fd-cursor.c"
}

static GType
tracker_bus_fd_cursor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerBusFDCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_fd_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusFDCursor), 0, (GInstanceInitFunc) tracker_bus_fd_cursor_instance_init, NULL };
	GType tracker_bus_fd_cursor_type_id;
	tracker_bus_fd_cursor_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CURSOR, "TrackerBusFDCursor", &g_define_type_info, 0);
	return tracker_bus_fd_cursor_type_id;
}

GType
tracker_bus_fd_cursor_get_type (void)
{
	static volatile gsize tracker_bus_fd_cursor_type_id__once = 0;
	if (g_once_init_enter (&tracker_bus_fd_cursor_type_id__once)) {
		GType tracker_bus_fd_cursor_type_id;
		tracker_bus_fd_cursor_type_id = tracker_bus_fd_cursor_get_type_once ();
		g_once_init_leave (&tracker_bus_fd_cursor_type_id__once, tracker_bus_fd_cursor_type_id);
	}
	return tracker_bus_fd_cursor_type_id__once;
}

static void
_vala_tracker_bus_fd_cursor_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	TrackerBusFDCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursor);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
	switch (property_id) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		case TRACKER_BUS_FD_CURSOR_N_COLUMNS_PROPERTY:
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		g_value_set_int (value, tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self));
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		break;
#line 769 "tracker-bus-fd-cursor.c"
		default:
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus-fd-cursor.vala"
		break;
#line 775 "tracker-bus-fd-cursor.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 786 "tracker-bus-fd-cursor.c"
		gssize i;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				destroy_func (((gpointer*) array)[i]);
#line 794 "tracker-bus-fd-cursor.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_free (array);
#line 809 "tracker-bus-fd-cursor.c"
}

