/* rygel-media-export-media-cache.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2013 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <mail@jensge.org>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-media-export.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-db.h"
#include <gee.h>
#include "rygel-core.h"
#include <gio/gio.h>
#include "rygel-server.h"
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "18"

typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_media_cache_properties[RYGEL_MEDIA_EXPORT_MEDIA_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_IGNORELIST_TABLE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_IGNORELIST_INDEX,
	RYGEL_MEDIA_EXPORT_SQL_STRING_ADD_TO_IGNORELIST,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHECK_IGNORELIST
} RygelMediaExportSQLString;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID
} RygelMediaExportDetailColumn;

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
	gchar* content_type;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelDatabaseDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};

static gint RygelMediaExportMediaCache_private_offset;
static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

VALA_EXTERN GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
VALA_EXTERN void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
VALA_EXTERN void rygel_media_export_exists_cache_entry_copy (const RygelMediaExportExistsCacheEntry* self,
                                                 RygelMediaExportExistsCacheEntry* dest);
VALA_EXTERN void rygel_media_export_exists_cache_entry_destroy (RygelMediaExportExistsCacheEntry* self);
VALA_EXTERN GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST ;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type,
                                                                      GError** error);
VALA_EXTERN RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
VALA_EXTERN RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self,
                                             const gchar* name,
                                             GError** error);
VALA_EXTERN RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
VALA_EXTERN RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
VALA_EXTERN GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self,
                                                  RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self,
                                                             RygelMediaContainer* container,
                                                             GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self,
                                                   RygelMediaObject* object,
                                                   gboolean override_guarded,
                                                   GError** error);
static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self,
                                                        RygelMediaFileItem* item,
                                                        GError** error);
static RygelDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self,
                                                                 RygelMediaExportSQLString id,
                                                                 GValue* values,
                                                                 gint values_length1,
                                                                 GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self,
                                                                            RygelMediaContainer* parent,
                                                                            sqlite3_stmt* statement);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self,
                                                 RygelMediaExportSQLString id,
                                                 GValue* values,
                                                 gint values_length1,
                                                 GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria,
                                                               gchar** extra_columns,
                                                               gint* column_count);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression,
                                                                   GValueArray* args,
                                                                   const gchar* prefix,
                                                                   GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self,
                                                   guint max_count);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
VALA_EXTERN GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelNullContainer* rygel_null_container_new_root (void);
VALA_EXTERN RygelNullContainer* rygel_null_container_construct_root (GType object_type);
VALA_EXTERN GType rygel_null_container_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelNullContainer* rygel_null_container_new (const gchar* id,
                                              RygelMediaContainer* parent,
                                              const gchar* title);
VALA_EXTERN RygelNullContainer* rygel_null_container_construct (GType object_type,
                                                    const gchar* id,
                                                    RygelMediaContainer* parent,
                                                    const gchar* title);
static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand,
                                                             gchar** collate,
                                                             gboolean for_sort,
                                                             GError** error);
static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self,
                                                           const gchar* id);
VALA_EXTERN gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
VALA_EXTERN GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags);
VALA_EXTERN void rygel_media_export_value_set_media_cache_upgrader (GValue* value,
                                                        gpointer v_object);
VALA_EXTERN void rygel_media_export_value_take_media_cache_upgrader (GValue* value,
                                                         gpointer v_object);
VALA_EXTERN gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
VALA_EXTERN GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelDatabaseDatabase* database,
                                                                                 RygelMediaExportSQLFactory* sql);
VALA_EXTERN RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type,
                                                                                       RygelDatabaseDatabase* database,
                                                                                       RygelMediaExportSQLFactory* sql);
VALA_EXTERN gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                                gint* current_version,
                                                                GError** error);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                      gint old_version);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self,
                                                         GError** error);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
VALA_EXTERN GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST ;
static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self,
                                                           RygelMediaObject* object,
                                                           GError** error);
static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self,
                                                          RygelMediaObject* object,
                                                          gboolean is_guarded,
                                                          GError** error);
VALA_EXTERN RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self,
                                                                      const gchar* id,
                                                                      const gchar* title,
                                                                      guint child_count,
                                                                      const gchar* uri);
VALA_EXTERN RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self,
                                                                RygelMediaContainer* parent,
                                                                const gchar* id,
                                                                const gchar* title,
                                                                const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self,
                                               sqlite3_stmt* statement,
                                               RygelMediaFileItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression,
                                                                GValueArray* args,
                                                                GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression,
                                                                 GValueArray* args,
                                                                 GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp,
                                                                    GValueArray* args,
                                                                    GError** error);
static void rygel_media_export_media_cache_finalize (GObject * obj);
static GType rygel_media_export_media_cache_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
rygel_media_export_media_cache_error_quark (void)
{
	return g_quark_from_static_string ("rygel-media-export-media-cache-error-quark");
}

static GType
rygel_media_export_media_cache_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR, "RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR", "sqlite-error"}, {RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR", "general-error"}, {RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE", "invalid-type"}, {RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, "RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH", "unsupported-search"}, {0, NULL, NULL}};
	GType rygel_media_export_media_cache_error_type_id;
	rygel_media_export_media_cache_error_type_id = g_enum_register_static ("RygelMediaExportMediaCacheError", values);
	return rygel_media_export_media_cache_error_type_id;
}

GType
rygel_media_export_media_cache_error_get_type (void)
{
	static volatile gsize rygel_media_export_media_cache_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_error_type_id__once)) {
		GType rygel_media_export_media_cache_error_type_id;
		rygel_media_export_media_cache_error_type_id = rygel_media_export_media_cache_error_get_type_once ();
		g_once_init_leave (&rygel_media_export_media_cache_error_type_id__once, rygel_media_export_media_cache_error_type_id);
	}
	return rygel_media_export_media_cache_error_type_id__once;
}

static GType
rygel_media_export_object_type_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
	GType rygel_media_export_object_type_type_id;
	rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
	return rygel_media_export_object_type_type_id;
}

GType
rygel_media_export_object_type_get_type (void)
{
	static volatile gsize rygel_media_export_object_type_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__once)) {
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = rygel_media_export_object_type_get_type_once ();
		g_once_init_leave (&rygel_media_export_object_type_type_id__once, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__once;
}

void
rygel_media_export_exists_cache_entry_copy (const RygelMediaExportExistsCacheEntry* self,
                                            RygelMediaExportExistsCacheEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).mtime = (*self).mtime;
	(*dest).size = (*self).size;
	_tmp0_ = (*self).content_type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).content_type);
	(*dest).content_type = _tmp1_;
}

void
rygel_media_export_exists_cache_entry_destroy (RygelMediaExportExistsCacheEntry* self)
{
	_g_free0 ((*self).content_type);
}

RygelMediaExportExistsCacheEntry*
rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self)
{
	RygelMediaExportExistsCacheEntry* dup;
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
	rygel_media_export_exists_cache_entry_copy (self, dup);
	return dup;
}

void
rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self)
{
	rygel_media_export_exists_cache_entry_destroy (self);
	g_free (self);
}

static GType
rygel_media_export_exists_cache_entry_get_type_once (void)
{
	GType rygel_media_export_exists_cache_entry_type_id;
	rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
	return rygel_media_export_exists_cache_entry_type_id;
}

GType
rygel_media_export_exists_cache_entry_get_type (void)
{
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__once)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = rygel_media_export_exists_cache_entry_get_type_once ();
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__once, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__once;
}

static inline gpointer
rygel_media_export_media_cache_get_instance_private (RygelMediaExportMediaCache* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportMediaCache_private_offset);
}

static RygelMediaExportMediaCache*
rygel_media_export_media_cache_construct (GType object_type,
                                          GError** error)
{
	RygelMediaExportMediaCache * self = NULL;
	gchar* db_name = NULL;
	gchar* _tmp0_;
	RygelMediaExportSQLFactory* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaExportObjectFactory* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("media-export");
	db_name = _tmp0_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = rygel_meta_config_get_default ();
		config = _tmp1_;
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "use-temp-db", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		if (_tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (":memory:");
			_g_free0 (db_name);
			db_name = _tmp3_;
		}
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp4_ = rygel_media_export_sql_factory_new ();
	_g_object_unref0 (self->priv->sql);
	self->priv->sql = _tmp4_;
	_tmp5_ = db_name;
	rygel_media_export_media_cache_open_db (self, _tmp5_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = rygel_media_export_object_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp6_;
	_g_free0 (db_name);
	return self;
}

static RygelMediaExportMediaCache*
rygel_media_export_media_cache_new (GError** error)
{
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
}

gchar*
rygel_media_export_media_cache_get_id (GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
rygel_media_export_media_cache_ensure_exists (GError** error)
{
	RygelMediaExportMediaCache* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_instance;
	if (_tmp0_ == NULL) {
		RygelMediaExportMediaCache* _tmp1_ = NULL;
		RygelMediaExportMediaCache* _tmp2_;
		RygelMediaExportMediaCache* _tmp3_;
		_tmp2_ = rygel_media_export_media_cache_new (&_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (rygel_media_export_media_cache_instance);
		rygel_media_export_media_cache_instance = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMediaExportMediaCache*
rygel_media_export_media_cache_get_default (void)
{
	RygelMediaExportMediaCache* _tmp0_;
	RygelMediaExportMediaCache* _tmp1_;
	RygelMediaExportMediaCache* result;
	_tmp0_ = rygel_media_export_media_cache_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

void
rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self,
                                             const gchar* id,
                                             GError** error)
{
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp2_;
	RygelMediaExportSQLFactory* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp2_ = self->priv->db;
	_tmp3_ = self->priv->sql;
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp3_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
	rygel_database_database_exec (_tmp2_, _tmp4_, values, (gint) values_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}

void
rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self,
                                              RygelMediaObject* object,
                                              GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_object_get_id (object);
	_tmp1_ = _tmp0_;
	rygel_media_export_media_cache_remove_by_id (self, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) || (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
     * Add the container to the cache, in a database transcation,
     * rolling back the transaction if necessary.
     */
static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self,
                                               RygelMediaContainer* container,
                                               GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		_tmp0_ = self->priv->db;
		rygel_database_database_begin (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		rygel_media_export_media_cache_save_container_metadata (self, container, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			goto __finally0;
		}
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) container, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			goto __finally0;
		}
		_tmp1_ = self->priv->db;
		rygel_database_database_commit (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->db;
		rygel_database_database_rollback (_tmp2_);
		_tmp3_ = _error_;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_inner_error0_ = _tmp4_;
		_g_error_free0 (_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Add the item to the cache.
     */
void
rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self,
                                          RygelMediaFileItem* item,
                                          gboolean override_guarded,
                                          GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		_tmp0_ = self->priv->db;
		rygel_database_database_begin (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		rygel_media_export_media_cache_save_item_metadata (self, item, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			goto __finally0;
		}
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) item, override_guarded, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			goto __finally0;
		}
		_tmp1_ = self->priv->db;
		rygel_database_database_commit (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		RygelDatabaseDatabase* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) item);
		_tmp3_ = _tmp2_;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning (_ ("Failed to add item with ID %s: %s"), _tmp3_, _tmp5_);
		_tmp6_ = self->priv->db;
		rygel_database_database_rollback (_tmp6_);
		_tmp7_ = _error_;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error0_ = _tmp8_;
		_g_error_free0 (_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Create a new container or item instance based on the ID.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     */
RygelMediaObject*
rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self,
                                           const gchar* object_id,
                                           GError** error)
{
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* parent = NULL;
	RygelDatabaseCursor* cursor = NULL;
	GValue* _tmp2_;
	gint _tmp2__length1;
	RygelDatabaseCursor* _tmp3_;
	GError* _inner_error0_ = NULL;
	RygelMediaObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, object_id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	parent = NULL;
	_tmp2_ = values;
	_tmp2__length1 = values_length1;
	_tmp3_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp2_, (gint) _tmp2__length1, &_inner_error0_);
	cursor = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return NULL;
		} else {
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp4_;
		RygelDatabaseCursorIterator* _tmp5_;
		_tmp4_ = cursor;
		_tmp5_ = rygel_database_cursor_iterator (_tmp4_);
		_statement_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			RygelDatabaseCursorIterator* _tmp7_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp8_;
			sqlite3_stmt* _tmp9_;
			RygelMediaContainer* parent_container = NULL;
			RygelMediaObject* _tmp10_;
			RygelMediaContainer* _tmp11_;
			RygelMediaObject* object = NULL;
			RygelMediaContainer* _tmp12_;
			sqlite3_stmt* _tmp13_;
			RygelMediaObject* _tmp14_;
			RygelMediaObject* _tmp15_;
			RygelMediaContainer* _tmp16_;
			RygelMediaObject* _tmp17_;
			RygelMediaObject* _tmp18_;
			_tmp7_ = _statement_it;
			_tmp6_ = rygel_database_cursor_iterator_next (_tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			if (!_tmp6_) {
				break;
			}
			_tmp8_ = _statement_it;
			_tmp9_ = rygel_database_cursor_iterator_get (_tmp8_, &_inner_error0_);
			statement = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp10_ = parent;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp10_) : NULL);
			parent_container = _tmp11_;
			_tmp12_ = parent_container;
			_tmp13_ = statement;
			_tmp14_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp12_, _tmp13_);
			object = _tmp14_;
			_tmp15_ = object;
			_tmp16_ = parent_container;
			rygel_media_object_set_parent_ref (_tmp15_, _tmp16_);
			_tmp17_ = object;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (parent);
			parent = _tmp18_;
			_g_object_unref0 (object);
			_g_object_unref0 (parent_container);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = parent;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}

RygelMediaContainer*
rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self,
                                              const gchar* container_id,
                                              GError** error)
{
	RygelMediaObject* object = NULL;
	RygelMediaObject* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp5_;
	RygelMediaContainer* _tmp6_;
	GError* _inner_error0_ = NULL;
	RygelMediaContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error0_);
	object = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) || (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = object;
	if (_tmp2_ != NULL) {
		RygelMediaObject* _tmp3_;
		_tmp3_ = object;
		_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_MEDIA_CONTAINER);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", container_id);
		_inner_error0_ = _tmp4_;
		if ((_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) || (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (object);
			return NULL;
		} else {
			_g_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = object;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp5_) : NULL);
	result = _tmp6_;
	_g_object_unref0 (object);
	return result;
}

gint
rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self,
                                                const gchar* container_id,
                                                GError** error)
{
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	gint _tmp2_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (container_id != NULL, 0);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, container_id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp2_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, (gint) values_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gint _tmp3_ = -1;
			g_propagate_error (error, _inner_error0_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return _tmp3_;
		} else {
			gint _tmp4_ = -1;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	result = _tmp2_;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}

guint32
rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self)
{
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	{
		gint _tmp0_ = 0;
		_tmp0_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = (guint32) _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_debug ("rygel-media-export-media-cache.vala:190: Failed to query max update id" \
": %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint32 _tmp3_ = 0U;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = (guint32) 0;
	return result;
}

void
rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self,
                                                     const gchar* id,
                                                     guint32* object_update_id,
                                                     guint32* container_update_id,
                                                     guint32* total_deleted_child_count)
{
	guint32 _vala_object_update_id = 0U;
	guint32 _vala_container_update_id = 0U;
	guint32 _vala_total_deleted_child_count = 0U;
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_vala_object_update_id = (guint32) 0;
	_vala_container_update_id = (guint32) 0;
	_vala_total_deleted_child_count = (guint32) 0;
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseDatabase* _tmp2_;
		GValue* _tmp3_;
		gint _tmp3__length1;
		RygelDatabaseCursor* _tmp4_;
		sqlite3_stmt* statement = NULL;
		RygelDatabaseCursor* _tmp5_;
		sqlite3_stmt* _tmp6_;
		sqlite3_stmt* _tmp7_;
		sqlite3_stmt* _tmp8_;
		sqlite3_stmt* _tmp9_;
		_tmp2_ = self->priv->db;
		_tmp3_ = values;
		_tmp3__length1 = values_length1;
		_tmp4_ = rygel_database_database_exec_cursor (_tmp2_, "SELECT object_update_id, " "container_update_id, " "deleted_child_count " "FROM Object WHERE upnp_id = ?", _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		cursor = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = cursor;
		_tmp6_ = rygel_database_cursor_next (_tmp5_, &_inner_error0_);
		statement = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cursor);
			goto __catch0_g_error;
		}
		_tmp7_ = statement;
		_vala_object_update_id = (guint32) sqlite3_column_int64 (_tmp7_, 0);
		_tmp8_ = statement;
		_vala_container_update_id = (guint32) sqlite3_column_int64 (_tmp8_, 1);
		_tmp9_ = statement;
		_vala_total_deleted_child_count = (guint32) sqlite3_column_int64 (_tmp9_, 2);
		_g_object_unref0 (cursor);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to get update IDs: %s"), _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	if (object_update_id) {
		*object_update_id = _vala_object_update_id;
	}
	if (container_update_id) {
		*container_update_id = _vala_container_update_id;
	}
	if (total_deleted_child_count) {
		*total_deleted_child_count = _vala_total_deleted_child_count;
	}
}

gboolean
rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self,
                                       GFile* file,
                                       gint64* timestamp,
                                       gint64* size,
                                       gchar** mime_type,
                                       GError** error)
{
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gchar* _vala_mime_type = NULL;
	gchar* uri = NULL;
	gchar* _tmp0_;
	GValue* values = NULL;
	const gchar* _tmp1_;
	GValue _tmp2_ = {0};
	GValue* _tmp3_;
	gint values_length1;
	gint _values_size_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	RygelDatabaseCursor* cursor = NULL;
	GValue* _tmp16_;
	gint _tmp16__length1;
	RygelDatabaseCursor* _tmp17_;
	sqlite3_stmt* statement = NULL;
	RygelDatabaseCursor* _tmp20_;
	sqlite3_stmt* _tmp21_;
	sqlite3_stmt* _tmp24_;
	sqlite3_stmt* _tmp25_;
	sqlite3_stmt* _tmp26_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue, 1);
	_tmp3_[0] = _tmp2_;
	values = _tmp3_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_g_free0 (_vala_mime_type);
	_vala_mime_type = NULL;
	_tmp4_ = self->priv->exists_cache;
	_tmp5_ = uri;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_)) {
		RygelMediaExportExistsCacheEntry* entry = NULL;
		GeeHashMap* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_;
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		RygelMediaExportExistsCacheEntry* _tmp11_;
		RygelMediaExportExistsCacheEntry* _tmp12_;
		RygelMediaExportExistsCacheEntry* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = self->priv->exists_cache;
		_tmp7_ = uri;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
		entry = (RygelMediaExportExistsCacheEntry*) _tmp8_;
		_tmp9_ = self->priv->exists_cache;
		_tmp10_ = uri;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
		_tmp11_ = entry;
		_vala_timestamp = (*_tmp11_).mtime;
		_tmp12_ = entry;
		_vala_size = (*_tmp12_).size;
		_tmp13_ = entry;
		_tmp14_ = (*_tmp13_).content_type;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (_vala_mime_type);
		_vala_mime_type = _tmp15_;
		result = TRUE;
		_rygel_media_export_exists_cache_entry_free0 (entry);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (uri);
		if (timestamp) {
			*timestamp = _vala_timestamp;
		}
		if (size) {
			*size = _vala_size;
		}
		if (mime_type) {
			*mime_type = _vala_mime_type;
		} else {
			_g_free0 (_vala_mime_type);
		}
		return result;
	}
	_tmp16_ = values;
	_tmp16__length1 = values_length1;
	_tmp17_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp16_, (gint) _tmp16__length1, &_inner_error0_);
	cursor = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			_g_free0 (_vala_mime_type);
			return _tmp18_;
		} else {
			gboolean _tmp19_ = FALSE;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			_g_free0 (_vala_mime_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp19_;
		}
	}
	_tmp20_ = cursor;
	_tmp21_ = rygel_database_cursor_next (_tmp20_, &_inner_error0_);
	statement = _tmp21_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp22_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			_g_free0 (_vala_mime_type);
			return _tmp22_;
		} else {
			gboolean _tmp23_ = FALSE;
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			_g_free0 (_vala_mime_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp23_;
		}
	}
	_tmp24_ = statement;
	_vala_timestamp = sqlite3_column_int64 (_tmp24_, 1);
	if (_vala_timestamp == G_MAXINT64) {
		_vala_timestamp = (gint64) 0;
	}
	_tmp25_ = statement;
	_vala_size = sqlite3_column_int64 (_tmp25_, 2);
	_tmp26_ = statement;
	result = sqlite3_column_int (_tmp26_, 0) == 1;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (uri);
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	if (size) {
		*size = _vala_size;
	}
	if (mime_type) {
		*mime_type = _vala_mime_type;
	} else {
		_g_free0 (_vala_mime_type);
	}
	return result;
}

RygelMediaObjects*
rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self,
                                             RygelMediaContainer* container,
                                             const gchar* sort_criteria,
                                             glong offset,
                                             glong max_count,
                                             GError** error)
{
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_;
	GValue* values = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	GValue* _tmp6_;
	gint values_length1;
	gint _values_size_;
	gchar* sql = NULL;
	RygelMediaExportSQLFactory* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* sort_order = NULL;
	gchar* _tmp10_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseDatabase* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GValue* _tmp16_;
	gint _tmp16__length1;
	RygelDatabaseCursor* _tmp17_;
	RygelDatabaseCursor* _tmp18_;
	GError* _inner_error0_ = NULL;
	RygelMediaObjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) container);
	_tmp2_ = _tmp1_;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_set_string (&_tmp3_, _tmp2_);
	g_value_init (&_tmp4_, G_TYPE_LONG);
	g_value_set_long (&_tmp4_, offset);
	g_value_init (&_tmp5_, G_TYPE_LONG);
	g_value_set_long (&_tmp5_, max_count);
	_tmp6_ = g_new0 (GValue, 3);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	values = _tmp6_;
	values_length1 = 3;
	_values_size_ = values_length1;
	_tmp7_ = self->priv->sql;
	_tmp8_ = rygel_media_export_sql_factory_make (_tmp7_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
	_tmp9_ = g_strdup (_tmp8_);
	sql = _tmp9_;
	_tmp10_ = rygel_media_export_media_cache_translate_sort_criteria (sort_criteria, NULL, NULL);
	sort_order = _tmp10_;
	_tmp11_ = self->priv->db;
	_tmp12_ = sql;
	_tmp13_ = sort_order;
	_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = values;
	_tmp16__length1 = values_length1;
	_tmp17_ = rygel_database_database_exec_cursor (_tmp11_, _tmp15_, _tmp16_, (gint) _tmp16__length1, &_inner_error0_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	cursor = _tmp18_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (sort_order);
		_g_free0 (sql);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp19_;
		RygelDatabaseCursorIterator* _tmp20_;
		_tmp19_ = cursor;
		_tmp20_ = rygel_database_cursor_iterator (_tmp19_);
		_statement_it = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_ = FALSE;
			RygelDatabaseCursorIterator* _tmp22_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp23_;
			sqlite3_stmt* _tmp24_;
			RygelMediaObjects* _tmp25_;
			sqlite3_stmt* _tmp26_;
			RygelMediaObject* _tmp27_;
			RygelMediaObject* _tmp28_;
			RygelMediaObjects* _tmp29_;
			gpointer _tmp30_;
			RygelMediaObject* _tmp31_;
			_tmp22_ = _statement_it;
			_tmp21_ = rygel_database_cursor_iterator_next (_tmp22_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp21_) {
				break;
			}
			_tmp23_ = _statement_it;
			_tmp24_ = rygel_database_cursor_iterator_get (_tmp23_, &_inner_error0_);
			statement = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp25_ = children;
			_tmp26_ = statement;
			_tmp27_ = rygel_media_export_media_cache_get_object_from_statement (self, container, _tmp26_);
			_tmp28_ = _tmp27_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
			_g_object_unref0 (_tmp28_);
			_tmp29_ = children;
			_tmp30_ = gee_list_last ((GeeList*) _tmp29_);
			_tmp31_ = (RygelMediaObject*) _tmp30_;
			rygel_media_object_set_parent_ref (_tmp31_, container);
			_g_object_unref0 (_tmp31_);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_free0 (sql);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}

RygelMediaObjects*
rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self,
                                                                 RygelSearchExpression* expression,
                                                                 const gchar* container_id,
                                                                 const gchar* sort_criteria,
                                                                 guint offset,
                                                                 guint max_count,
                                                                 guint* total_matches,
                                                                 GError** error)
{
	guint _vala_total_matches = 0U;
	GValueArray* args = NULL;
	GValueArray* _tmp0_;
	gchar* filter = NULL;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	guint max_objects = 0U;
	glong _tmp6_ = 0L;
	const gchar* _tmp7_;
	GValueArray* _tmp8_;
	RygelMediaObjects* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GValueArray* _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* _tmp13_;
	GError* _inner_error0_ = NULL;
	RygelMediaObjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = args;
	_tmp2_ = rygel_media_export_media_cache_translate_search_expression (expression, _tmp1_, "WHERE", &_inner_error0_);
	filter = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_value_array_free0 (args);
		return NULL;
	}
	if (expression != NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = rygel_search_expression_to_string (expression);
		_tmp4_ = _tmp3_;
		g_debug ("rygel-media-export-media-cache.vala:288: Original search: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:289: Parsed search expression: %s", _tmp5_);
	}
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
	_tmp7_ = filter;
	_tmp8_ = args;
	_tmp6_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp7_, _tmp8_, container_id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_vala_total_matches = (guint) _tmp6_;
	_tmp10_ = filter;
	_tmp11_ = args;
	_tmp12_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp10_, _tmp11_, container_id, sort_criteria, (glong) offset, (glong) max_objects, &_inner_error0_);
	_tmp9_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp13_ = _tmp9_;
	_tmp9_ = NULL;
	result = _tmp13_;
	_g_object_unref0 (_tmp9_);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	if (total_matches) {
		*total_matches = _vala_total_matches;
	}
	return result;
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

glong
rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self,
                                                                      RygelSearchExpression* expression,
                                                                      const gchar* container_id,
                                                                      GError** error)
{
	GValueArray* args = NULL;
	GValueArray* _tmp0_;
	gchar* filter = NULL;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	glong _tmp19_ = 0L;
	const gchar* _tmp20_;
	GValueArray* _tmp21_;
	GError* _inner_error0_ = NULL;
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = args;
	_tmp2_ = rygel_media_export_media_cache_translate_search_expression (expression, _tmp1_, "WHERE", &_inner_error0_);
	filter = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		glong _tmp3_ = -1L;
		g_propagate_error (error, _inner_error0_);
		_g_value_array_free0 (args);
		return _tmp3_;
	}
	if (expression != NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = rygel_search_expression_to_string (expression);
		_tmp5_ = _tmp4_;
		g_debug ("rygel-media-export-media-cache.vala:313: Original search: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:314: Parsed search expression: %s", _tmp6_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GValueArray* _tmp9_;
				GValue* arg = NULL;
				GValueArray* _tmp10_;
				GValue* _tmp11_;
				gchar* _tmp12_ = NULL;
				GValue* _tmp13_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = args;
				if (!(((guint) i) < _tmp9_->n_values)) {
					break;
				}
				_tmp10_ = args;
				_tmp11_ = __g_value_dup0 (g_value_array_get_nth (_tmp10_, (guint) i));
				arg = _tmp11_;
				_tmp13_ = arg;
				if (G_VALUE_HOLDS (_tmp13_, G_TYPE_STRING)) {
					GValue* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = arg;
					_tmp15_ = g_value_get_string (_tmp14_);
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (_tmp12_);
					_tmp12_ = _tmp16_;
				} else {
					GValue* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = arg;
					_tmp18_ = g_strdup_value_contents (_tmp17_);
					_g_free0 (_tmp12_);
					_tmp12_ = _tmp18_;
				}
				g_debug ("rygel-media-export-media-cache.vala:319: Arg %d: %s", i, _tmp12_);
				_g_free0 (_tmp12_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	_tmp20_ = filter;
	_tmp21_ = args;
	_tmp19_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp20_, _tmp21_, container_id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		glong _tmp22_ = -1L;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return _tmp22_;
	}
	result = _tmp19_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}

glong
rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self,
                                                           const gchar* filter,
                                                           GValueArray* args,
                                                           const gchar* container_id,
                                                           GError** error)
{
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	RygelMediaExportSQLFactory* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	RygelDatabaseDatabase* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GError* _inner_error0_ = NULL;
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (filter != NULL, 0L);
	g_return_val_if_fail (args != NULL, 0L);
	if (container_id != NULL) {
		GValue v = {0};
		GValue _tmp0_ = {0};
		GValue _tmp1_;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		g_value_set_string (&_tmp0_, container_id);
		v = _tmp0_;
		_tmp1_ = v;
		g_value_array_prepend (args, &_tmp1_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	g_debug ("rygel-media-export-media-cache.vala:339: Parameters to bind: %u", args->n_values);
	if (container_id != NULL) {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
	} else {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
	}
	_tmp2_ = self->priv->sql;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, string_id);
	pattern = _tmp3_;
	_tmp5_ = self->priv->db;
	_tmp6_ = g_strdup_printf (pattern, filter);
	_tmp7_ = _tmp6_;
	_tmp8_ = args->values;
	_tmp8__length1 = args->n_values;
	_tmp9_ = rygel_database_database_query_value (_tmp5_, _tmp7_, _tmp8_, (gint) _tmp8__length1, &_inner_error0_);
	_g_free0 (_tmp7_);
	_tmp4_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		glong _tmp10_ = -1L;
		g_propagate_error (error, _inner_error0_);
		return _tmp10_;
	}
	result = (glong) _tmp4_;
	return result;
}

RygelMediaObjects*
rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self,
                                                      const gchar* filter,
                                                      GValueArray* args,
                                                      const gchar* container_id,
                                                      const gchar* sort_criteria,
                                                      glong offset,
                                                      glong max_count,
                                                      GError** error)
{
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_;
	GValue v = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	RygelMediaContainer* parent = NULL;
	const gchar* sql = NULL;
	gchar* sort_order = NULL;
	gchar* _tmp19_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseDatabase* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GValue* _tmp25_;
	gint _tmp25__length1;
	RygelDatabaseCursor* _tmp26_;
	RygelDatabaseCursor* _tmp27_;
	GError* _inner_error0_ = NULL;
	RygelMediaObjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_LONG);
	g_value_set_long (&_tmp1_, offset);
	v = _tmp1_;
	_tmp2_ = v;
	g_value_array_append (args, &_tmp2_);
	g_value_init (&_tmp3_, G_TYPE_LONG);
	g_value_set_long (&_tmp3_, max_count);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp3_;
	_tmp4_ = v;
	g_value_array_append (args, &_tmp4_);
	parent = NULL;
	g_debug ("rygel-media-export-media-cache.vala:366: Parameters to bind: %u", args->n_values);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GValue* arg = NULL;
				GValue* _tmp7_;
				gchar* _tmp8_ = NULL;
				GValue* _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(((guint) i) < args->n_values)) {
					break;
				}
				_tmp7_ = __g_value_dup0 (g_value_array_get_nth (args, (guint) i));
				arg = _tmp7_;
				_tmp9_ = arg;
				if (G_VALUE_HOLDS (_tmp9_, G_TYPE_STRING)) {
					GValue* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = arg;
					_tmp11_ = g_value_get_string (_tmp10_);
					_tmp12_ = g_strdup (_tmp11_);
					_g_free0 (_tmp8_);
					_tmp8_ = _tmp12_;
				} else {
					GValue* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = arg;
					_tmp14_ = g_strdup_value_contents (_tmp13_);
					_g_free0 (_tmp8_);
					_tmp8_ = _tmp14_;
				}
				g_debug ("rygel-media-export-media-cache.vala:369: Arg %d: %s", i, _tmp8_);
				_g_free0 (_tmp8_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	if (container_id != NULL) {
		RygelMediaExportSQLFactory* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = self->priv->sql;
		_tmp16_ = rygel_media_export_sql_factory_make (_tmp15_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
		sql = _tmp16_;
	} else {
		RygelMediaExportSQLFactory* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->sql;
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
		sql = _tmp18_;
	}
	_tmp19_ = rygel_media_export_media_cache_translate_sort_criteria (sort_criteria, NULL, NULL);
	sort_order = _tmp19_;
	_tmp20_ = self->priv->db;
	_tmp21_ = sql;
	_tmp22_ = sort_order;
	_tmp23_ = g_strdup_printf (_tmp21_, filter, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = args->values;
	_tmp25__length1 = args->n_values;
	_tmp26_ = rygel_database_database_exec_cursor (_tmp20_, _tmp24_, _tmp25_, (gint) _tmp25__length1, &_inner_error0_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp24_);
	cursor = _tmp27_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (sort_order);
		_g_object_unref0 (parent);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp28_;
		RygelDatabaseCursorIterator* _tmp29_;
		_tmp28_ = cursor;
		_tmp29_ = rygel_database_cursor_iterator (_tmp28_);
		_statement_it = _tmp29_;
		while (TRUE) {
			gboolean _tmp30_ = FALSE;
			RygelDatabaseCursorIterator* _tmp31_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp32_;
			sqlite3_stmt* _tmp33_;
			const gchar* parent_id = NULL;
			sqlite3_stmt* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
			RygelMediaContainer* _tmp37_;
			RygelMediaContainer* _tmp46_;
			_tmp31_ = _statement_it;
			_tmp30_ = rygel_database_cursor_iterator_next (_tmp31_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp30_) {
				break;
			}
			_tmp32_ = _statement_it;
			_tmp33_ = rygel_database_cursor_iterator_get (_tmp32_, &_inner_error0_);
			statement = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp34_ = statement;
			_tmp35_ = (const gchar*) sqlite3_column_text (_tmp34_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
			parent_id = _tmp35_;
			_tmp37_ = parent;
			if (_tmp37_ == NULL) {
				_tmp36_ = TRUE;
			} else {
				const gchar* _tmp38_;
				RygelMediaContainer* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp38_ = parent_id;
				_tmp39_ = parent;
				_tmp40_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp36_ = g_strcmp0 (_tmp38_, _tmp41_) != 0;
			}
			if (_tmp36_) {
				const gchar* _tmp42_;
				_tmp42_ = parent_id;
				if (_tmp42_ == NULL) {
					RygelNullContainer* _tmp43_;
					_tmp43_ = rygel_null_container_new_root ();
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp43_;
				} else {
					const gchar* _tmp44_;
					RygelNullContainer* _tmp45_;
					_tmp44_ = parent_id;
					_tmp45_ = rygel_null_container_new (_tmp44_, NULL, "MediaExport");
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp45_;
				}
			}
			_tmp46_ = parent;
			if (_tmp46_ != NULL) {
				RygelMediaObjects* _tmp47_;
				RygelMediaContainer* _tmp48_;
				sqlite3_stmt* _tmp49_;
				RygelMediaObject* _tmp50_;
				RygelMediaObject* _tmp51_;
				RygelMediaObjects* _tmp52_;
				gpointer _tmp53_;
				RygelMediaObject* _tmp54_;
				RygelMediaContainer* _tmp55_;
				_tmp47_ = children;
				_tmp48_ = parent;
				_tmp49_ = statement;
				_tmp50_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp48_, _tmp49_);
				_tmp51_ = _tmp50_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp51_);
				_g_object_unref0 (_tmp51_);
				_tmp52_ = children;
				_tmp53_ = gee_list_last ((GeeList*) _tmp52_);
				_tmp54_ = (RygelMediaObject*) _tmp53_;
				_tmp55_ = parent;
				rygel_media_object_set_parent_ref (_tmp54_, _tmp55_);
				_g_object_unref0 (_tmp54_);
			} else {
				sqlite3_stmt* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				_tmp56_ = statement;
				_tmp57_ = (const gchar*) sqlite3_column_text (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
				_tmp58_ = parent_id;
				g_warning (_ ("Inconsistent database: item %s does not have parent %s"), _tmp57_, _tmp58_);
			}
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_object_unref0 (parent);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}

void
rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseCursor* _tmp0_;
		g_debug ("rygel-media-export-media-cache.vala:411: Database statistics:");
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, (gint) 0, &_inner_error0_);
		cursor = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			RygelDatabaseCursorIterator* _statement_it = NULL;
			RygelDatabaseCursor* _tmp1_;
			RygelDatabaseCursorIterator* _tmp2_;
			_tmp1_ = cursor;
			_tmp2_ = rygel_database_cursor_iterator (_tmp1_);
			_statement_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				RygelDatabaseCursorIterator* _tmp4_;
				sqlite3_stmt* statement = NULL;
				RygelDatabaseCursorIterator* _tmp5_;
				sqlite3_stmt* _tmp6_;
				sqlite3_stmt* _tmp7_;
				const gchar* _tmp8_;
				sqlite3_stmt* _tmp9_;
				_tmp4_ = _statement_it;
				_tmp3_ = rygel_database_cursor_iterator_next (_tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch0_g_error;
				}
				if (!_tmp3_) {
					break;
				}
				_tmp5_ = _statement_it;
				_tmp6_ = rygel_database_cursor_iterator_get (_tmp5_, &_inner_error0_);
				statement = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch0_g_error;
				}
				_tmp7_ = statement;
				_tmp8_ = (const gchar*) sqlite3_column_text (_tmp7_, 0);
				_tmp9_ = statement;
				g_debug ("rygel-media-export-media-cache.vala:414: %s: %d", _tmp8_, sqlite3_column_int (_tmp9_, 1));
			}
			_rygel_database_cursor_iterator_unref0 (_statement_it);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_debug ("rygel-media-export-media-cache.vala:419: Failed to get database statis" \
"tics: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GeeArrayList*
rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self,
                                              const gchar* container_id,
                                              GError** error)
{
	GeeArrayList* children = NULL;
	GeeArrayList* _tmp0_;
	GValue* values = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseCursor* cursor = NULL;
	GValue* _tmp3_;
	gint _tmp3__length1;
	RygelDatabaseCursor* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, container_id);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp3_ = values;
	_tmp3__length1 = values_length1;
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
	cursor = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp5_;
		RygelDatabaseCursorIterator* _tmp6_;
		_tmp5_ = cursor;
		_tmp6_ = rygel_database_cursor_iterator (_tmp5_);
		_statement_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			RygelDatabaseCursorIterator* _tmp8_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp9_;
			sqlite3_stmt* _tmp10_;
			GeeArrayList* _tmp11_;
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			_tmp8_ = _statement_it;
			_tmp7_ = rygel_database_cursor_iterator_next (_tmp8_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			if (!_tmp7_) {
				break;
			}
			_tmp9_ = _statement_it;
			_tmp10_ = rygel_database_cursor_iterator_get (_tmp9_, &_inner_error0_);
			statement = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp11_ = children;
			_tmp12_ = statement;
			_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp13_);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GeeList*
rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self,
                                                               const gchar* column,
                                                               const gchar* filter,
                                                               GValueArray* args,
                                                               glong offset,
                                                               const gchar* sort_criteria,
                                                               glong max_count,
                                                               gboolean add_all_container,
                                                               GError** error)
{
	GValue v = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	gchar* extra_columns = NULL;
	gint column_count = 0;
	GString* builder = NULL;
	GString* _tmp4_;
	GeeArrayList* data = NULL;
	GeeArrayList* _tmp5_;
	gchar* sql_sort_order = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GString* _tmp18_;
	RygelMediaExportSQLFactory* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseDatabase* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	GValue* _tmp26_;
	gint _tmp26__length1;
	RygelDatabaseCursor* _tmp27_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	g_value_init (&_tmp0_, G_TYPE_LONG);
	g_value_set_long (&_tmp0_, offset);
	v = _tmp0_;
	_tmp1_ = v;
	g_value_array_append (args, &_tmp1_);
	g_value_init (&_tmp2_, G_TYPE_LONG);
	g_value_set_long (&_tmp2_, max_count);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp2_;
	_tmp3_ = v;
	g_value_array_append (args, &_tmp3_);
	_tmp4_ = g_string_new ("");
	builder = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	data = _tmp5_;
	_tmp8_ = rygel_media_export_media_cache_translate_sort_criteria (sort_criteria, &_tmp6_, &_tmp7_);
	_g_free0 (extra_columns);
	extra_columns = _tmp6_;
	column_count = _tmp7_;
	sql_sort_order = _tmp8_;
	_tmp9_ = sql_sort_order;
	_tmp10_ = string_replace (_tmp9_, "o.title", "_column");
	_g_free0 (sql_sort_order);
	sql_sort_order = _tmp10_;
	_tmp11_ = extra_columns;
	_tmp12_ = string_replace (_tmp11_, "o.title", "1");
	_g_free0 (extra_columns);
	extra_columns = _tmp12_;
	if (add_all_container) {
		GString* _tmp13_;
		GString* _tmp17_;
		_tmp13_ = builder;
		g_string_append (_tmp13_, "SELECT 'all_place_holder' AS _column ");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					GString* _tmp16_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					if (!(i < column_count)) {
						break;
					}
					_tmp16_ = builder;
					g_string_append (_tmp16_, ", 1 ");
				}
			}
		}
		_tmp17_ = builder;
		g_string_append (_tmp17_, "UNION ");
	}
	_tmp18_ = builder;
	_tmp19_ = self->priv->sql;
	_tmp20_ = rygel_media_export_sql_factory_make (_tmp19_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
	_tmp21_ = extra_columns;
	_tmp22_ = sql_sort_order;
	g_string_append_printf (_tmp18_, _tmp20_, column, _tmp21_, filter, _tmp22_);
	_tmp23_ = self->priv->db;
	_tmp24_ = builder;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = args->values;
	_tmp26__length1 = args->n_values;
	_tmp27_ = rygel_database_database_exec_cursor (_tmp23_, _tmp25_, _tmp26_, (gint) _tmp26__length1, &_inner_error0_);
	cursor = _tmp27_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (sql_sort_order);
		_g_object_unref0 (data);
		_g_string_free0 (builder);
		_g_free0 (extra_columns);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return NULL;
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp28_;
		RygelDatabaseCursorIterator* _tmp29_;
		_tmp28_ = cursor;
		_tmp29_ = rygel_database_cursor_iterator (_tmp28_);
		_statement_it = _tmp29_;
		while (TRUE) {
			gboolean _tmp30_ = FALSE;
			RygelDatabaseCursorIterator* _tmp31_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp32_;
			sqlite3_stmt* _tmp33_;
			GeeArrayList* _tmp34_;
			sqlite3_stmt* _tmp35_;
			const gchar* _tmp36_;
			_tmp31_ = _statement_it;
			_tmp30_ = rygel_database_cursor_iterator_next (_tmp31_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sql_sort_order);
				_g_object_unref0 (data);
				_g_string_free0 (builder);
				_g_free0 (extra_columns);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			if (!_tmp30_) {
				break;
			}
			_tmp32_ = _statement_it;
			_tmp33_ = rygel_database_cursor_iterator_get (_tmp32_, &_inner_error0_);
			statement = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sql_sort_order);
				_g_object_unref0 (data);
				_g_string_free0 (builder);
				_g_free0 (extra_columns);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			_tmp34_ = data;
			_tmp35_ = statement;
			_tmp36_ = (const gchar*) sqlite3_column_text (_tmp35_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp36_);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = (GeeList*) data;
	_g_object_unref0 (cursor);
	_g_free0 (sql_sort_order);
	_g_string_free0 (builder);
	_g_free0 (extra_columns);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}

/**
     * TODO
     */
GeeList*
rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self,
                                                                          const gchar* attribute,
                                                                          RygelSearchExpression* expression,
                                                                          const gchar* sort_criteria,
                                                                          glong offset,
                                                                          guint max_count,
                                                                          gboolean add_all_container,
                                                                          GError** error)
{
	GValueArray* args = NULL;
	GValueArray* _tmp0_;
	gchar* filter = NULL;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* column = NULL;
	gchar* _tmp4_;
	guint max_objects = 0U;
	GeeList* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GValueArray* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = args;
	_tmp2_ = rygel_media_export_media_cache_translate_search_expression (expression, _tmp1_, "AND", &_inner_error0_);
	filter = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp3_ = filter;
	g_debug ("rygel-media-export-media-cache.vala:504: Parsed filter: %s", _tmp3_);
	_tmp4_ = rygel_media_export_media_cache_map_operand_to_column (attribute, NULL, FALSE, &_inner_error0_);
	column = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
	_tmp6_ = column;
	_tmp7_ = filter;
	_tmp8_ = args;
	_tmp9_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp6_, _tmp7_, _tmp8_, offset, sort_criteria, (glong) max_objects, add_all_container, &_inner_error0_);
	_tmp5_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (column);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp10_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp10_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (column);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}

gchar*
rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseCursor* _tmp0_;
		sqlite3_stmt* statement = NULL;
		RygelDatabaseCursor* _tmp1_;
		sqlite3_stmt* _tmp2_;
		sqlite3_stmt* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN, NULL, (gint) 0, &_inner_error0_);
		cursor = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp1_ = cursor;
		_tmp2_ = rygel_database_cursor_next (_tmp1_, &_inner_error0_);
		statement = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cursor);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = statement;
		_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (cursor);
		return result;
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		g_warning ("rygel-media-export-media-cache.vala:525: %s", _ ("Failed to get reset token"));
		_tmp6_ = gupnp_get_uuid ();
		result = _tmp6_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self,
                                                 const gchar* token)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	{
		GValue* args = NULL;
		GValue _tmp0_ = {0};
		GValue* _tmp1_;
		gint args_length1;
		gint _args_size_;
		RygelDatabaseDatabase* _tmp2_;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		g_value_set_string (&_tmp0_, token);
		_tmp1_ = g_new0 (GValue, 1);
		_tmp1_[0] = _tmp0_;
		args = _tmp1_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp2_ = self->priv->db;
		rygel_database_database_exec (_tmp2_, "UPDATE schema_info SET reset_token = ?", args, (gint) args_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning (_ ("Failed to persist ServiceResetToken: %s"), _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		_tmp0_ = self->priv->db;
		rygel_database_database_exec (_tmp0_, "DELETE FROM object WHERE " "upnp_id LIKE 'virtual-parent:%'", NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning (_ ("Failed to remove virtual folders: %s"), _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self,
                                                    RygelMediaObject* object,
                                                    gboolean guarded)
{
	gint _tmp0_ = 0;
	gint guarded_val = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	if (guarded) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	guarded_val = _tmp0_;
	{
		GValue* values = NULL;
		GValue _tmp1_ = {0};
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GValue _tmp4_ = {0};
		GValue* _tmp5_;
		gint values_length1;
		gint _values_size_;
		RygelDatabaseDatabase* _tmp6_;
		RygelMediaExportSQLFactory* _tmp7_;
		const gchar* _tmp8_;
		g_value_init (&_tmp1_, G_TYPE_INT);
		g_value_set_int (&_tmp1_, guarded_val);
		_tmp2_ = rygel_media_object_get_id (object);
		_tmp3_ = _tmp2_;
		g_value_init (&_tmp4_, G_TYPE_STRING);
		g_value_set_string (&_tmp4_, _tmp3_);
		_tmp5_ = g_new0 (GValue, 2);
		_tmp5_[0] = _tmp1_;
		_tmp5_[1] = _tmp4_;
		values = _tmp5_;
		values_length1 = 2;
		_values_size_ = values_length1;
		_tmp6_ = self->priv->db;
		_tmp7_ = self->priv->sql;
		_tmp8_ = rygel_media_export_sql_factory_make (_tmp7_, RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED);
		rygel_database_database_exec (_tmp6_, _tmp8_, values, (gint) values_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		values = (_vala_GValue_array_free (values, values_length1), NULL);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = rygel_media_object_get_id (object);
		_tmp10_ = _tmp9_;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning (_ ("Failed to mark item %s as guarded (%d): %s"), _tmp10_, guarded_val, _tmp12_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self,
                                                 RygelMediaObject* object,
                                                 RygelMediaContainer* parent,
                                                 GError** error)
{
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		gchar* msg = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp0_ = g_strdup (_ ("Cannot create references to containers"));
		msg = _tmp0_;
		_tmp1_ = msg;
		_tmp2_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, _tmp1_);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		return NULL;
	}
	rygel_media_object_set_parent (object, parent);
	_tmp3_ = rygel_media_object_get_ref_id (object);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = rygel_media_object_get_id (object);
		_tmp6_ = _tmp5_;
		rygel_media_object_set_ref_id (object, _tmp6_);
	}
	_tmp7_ = gupnp_get_uuid ();
	_tmp8_ = _tmp7_;
	rygel_media_object_set_id (object, _tmp8_);
	_g_free0 (_tmp8_);
	rygel_media_export_media_cache_save_item (self, G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) object) : NULL, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = rygel_media_object_get_id (object);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	return result;
}

void
rygel_media_export_media_cache_ignore (RygelMediaExportMediaCache* self,
                                       GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GValue* values = NULL;
		gchar* _tmp0_;
		GValue _tmp1_ = {0};
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		GValue _tmp4_ = {0};
		GValue* _tmp5_;
		GValue* _tmp6_;
		gint _tmp6__length1;
		gint values_length1;
		gint _values_size_;
		RygelDatabaseDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_;
		_tmp0_ = g_file_get_uri (file);
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_take_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_date_time_new_now_utc ();
		_tmp3_ = _tmp2_;
		g_value_init (&_tmp4_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp4_, g_date_time_to_unix (_tmp3_));
		_tmp5_ = g_new0 (GValue, 2);
		_tmp5_[0] = _tmp1_;
		_tmp5_[1] = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 2;
		_g_date_time_unref0 (_tmp3_);
		values = _tmp6_;
		values_length1 = _tmp6__length1;
		_values_size_ = values_length1;
		_tmp7_ = self->priv->db;
		_tmp8_ = self->priv->sql;
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_ADD_TO_IGNORELIST);
		rygel_database_database_exec (_tmp7_, _tmp9_, values, (gint) values_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		values = (_vala_GValue_array_free (values, values_length1), NULL);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = g_file_get_uri (file);
		_tmp11_ = _tmp10_;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning (_ ("Failed to add %s to ignored files: %s"), _tmp11_, _tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
rygel_media_export_media_cache_is_ignored (RygelMediaExportMediaCache* self,
                                           GFile* file)
{
	gboolean _tmp9_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GValue* values = NULL;
		gchar* _tmp0_;
		GValue _tmp1_ = {0};
		GValue* _tmp2_;
		gint values_length1;
		gint _values_size_;
		gint _tmp3_ = 0;
		_tmp0_ = g_file_get_uri (file);
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_take_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_new0 (GValue, 1);
		_tmp2_[0] = _tmp1_;
		values = _tmp2_;
		values_length1 = 1;
		_values_size_ = values_length1;
		_tmp3_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHECK_IGNORELIST, values, (gint) values_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp3_ == 1;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return result;
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = g_file_get_uri (file);
		_tmp6_ = _tmp5_;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning (_ ("Failed to get whether URI %s is ignored: %s"), _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

static gboolean
rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self,
                                                  const gchar* id)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	{
		GValue* id_value = NULL;
		GValue _tmp0_ = {0};
		GValue* _tmp1_;
		gint id_value_length1;
		gint _id_value_size_;
		gint _tmp2_ = 0;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		g_value_set_string (&_tmp0_, id);
		_tmp1_ = g_new0 (GValue, 1);
		_tmp1_[0] = _tmp0_;
		id_value = _tmp1_;
		id_value_length1 = 1;
		_id_value_size_ = id_value_length1;
		_tmp2_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED, id_value, (gint) id_value_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		result = _tmp2_ == 1;
		id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
		return result;
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning (_ ("Failed to get whether item %s is guarded: %s"), id, _tmp5_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

void
rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self,
                                                     GError** error)
{
	GeeHashMap* _tmp0_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseCursor* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GDestroyNotify) rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exists_cache);
	self->priv->exists_cache = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, (gint) 0, &_inner_error0_);
	cursor = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp2_;
		RygelDatabaseCursorIterator* _tmp3_;
		_tmp2_ = cursor;
		_tmp3_ = rygel_database_cursor_iterator (_tmp2_);
		_statement_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			RygelDatabaseCursorIterator* _tmp5_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp6_;
			sqlite3_stmt* _tmp7_;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp8_;
			sqlite3_stmt* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GeeHashMap* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			RygelMediaExportExistsCacheEntry _tmp16_;
			_tmp5_ = _statement_it;
			_tmp4_ = rygel_database_cursor_iterator_next (_tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			if (!_tmp4_) {
				break;
			}
			_tmp6_ = _statement_it;
			_tmp7_ = rygel_database_cursor_iterator_get (_tmp6_, &_inner_error0_);
			statement = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
			_tmp8_ = statement;
			entry.mtime = sqlite3_column_int64 (_tmp8_, 1);
			_tmp9_ = statement;
			entry.size = sqlite3_column_int64 (_tmp9_, 0);
			_tmp10_ = statement;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 2);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (entry.content_type);
			entry.content_type = _tmp12_;
			_tmp13_ = self->priv->exists_cache;
			_tmp14_ = statement;
			_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 3);
			_tmp16_ = entry;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, &_tmp16_);
			rygel_media_export_exists_cache_entry_destroy (&entry);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	_g_object_unref0 (cursor);
}

static guint
rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self,
                                             guint max_count)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (max_count == ((guint) 0)) {
		result = (guint) -1;
		return result;
	} else {
		result = max_count;
		return result;
	}
}

static void
rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self,
                                        const gchar* name,
                                        GError** error)
{
	RygelDatabaseDatabase* _tmp0_ = NULL;
	RygelDatabaseDatabase* _tmp1_;
	RygelDatabaseDatabase* _tmp2_;
	gint old_version = 0;
	gint current_version = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = rygel_database_database_new (name, RYGEL_DATABASE_FLAVOR_CACHE, RYGEL_DATABASE_FLAGS_READ_WRITE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp2_;
	old_version = -1;
	current_version = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	{
		RygelMediaExportMediaCacheUpgrader* upgrader = NULL;
		RygelDatabaseDatabase* _tmp3_;
		RygelMediaExportSQLFactory* _tmp4_;
		RygelMediaExportMediaCacheUpgrader* _tmp5_;
		gboolean _tmp6_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp7_;
		gint _tmp8_ = 0;
		gboolean _tmp9_;
		RygelMediaExportMediaCacheUpgrader* _tmp13_;
		_tmp3_ = self->priv->db;
		_tmp4_ = self->priv->sql;
		_tmp5_ = rygel_media_export_media_cache_upgrader_new (_tmp3_, _tmp4_);
		upgrader = _tmp5_;
		_tmp7_ = upgrader;
		_tmp9_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp7_, &_tmp8_, &_inner_error0_);
		old_version = _tmp8_;
		_tmp6_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			goto __finally0;
		}
		if (_tmp6_) {
			RygelMediaExportMediaCacheUpgrader* _tmp10_;
			_tmp10_ = upgrader;
			rygel_media_export_media_cache_upgrader_upgrade (_tmp10_, old_version);
		} else {
			if (old_version == current_version) {
				RygelMediaExportMediaCacheUpgrader* _tmp11_;
				_tmp11_ = upgrader;
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp11_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch0_rygel_database_database_error;
					}
					goto __finally0;
				}
			} else {
				GError* _tmp12_;
				g_warning (_ ("The version “%d” of the detected database is newer than our supported " \
"version “%d”"), old_version, current_version);
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_tmp12_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
				_inner_error0_ = _tmp12_;
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch0_rygel_database_database_error;
				}
				goto __finally0;
			}
		}
		_tmp13_ = upgrader;
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp13_);
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		g_clear_error (&_inner_error0_);
		g_debug ("rygel-media-export-media-cache.vala:676: %s", "Could not find schema version;" " checking for empty database...");
		{
			gboolean _tmp14_ = FALSE;
			RygelDatabaseDatabase* _tmp15_;
			_tmp15_ = self->priv->db;
			_tmp14_ = rygel_database_database_is_empty (_tmp15_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch1_rygel_database_database_error;
				}
				_g_object_unref0 (_tmp0_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (_tmp14_) {
				g_debug ("rygel-media-export-media-cache.vala:680: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
				if (!rygel_media_export_media_cache_create_schema (self)) {
					_g_object_unref0 (self->priv->db);
					self->priv->db = NULL;
					_g_object_unref0 (_tmp0_);
					return;
				}
			} else {
				g_warning ("rygel-media-export-media-cache.vala:688: %s", _ ("Incompatible schema… cannot proceed"));
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_g_object_unref0 (_tmp0_);
				return;
			}
		}
		goto __finally1;
		__catch1_rygel_database_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			GError* _tmp18_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = _error_;
			_tmp17_ = _tmp16_->message;
			g_warning (_ ("Invalid database, cannot query sqlite_master table: %s"), _tmp17_);
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
			_inner_error0_ = _tmp18_;
			_g_error_free0 (_error_);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_g_object_unref0 (_tmp0_);
}

static void
rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self,
                                                        RygelMediaContainer* container,
                                                        GError** error)
{
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue* _tmp24_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp25_;
	RygelMediaExportSQLFactory* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_value_init (&_tmp0_, G_TYPE_INT);
	g_value_set_int (&_tmp0_, 0);
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, "inode/directory");
	g_value_init (&_tmp2_, G_TYPE_INT);
	g_value_set_int (&_tmp2_, -1);
	g_value_init (&_tmp3_, G_TYPE_INT);
	g_value_set_int (&_tmp3_, -1);
	_tmp4_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) container);
	_tmp5_ = _tmp4_;
	g_value_init (&_tmp6_, G_TYPE_STRING);
	g_value_set_string (&_tmp6_, _tmp5_);
	rygel_database_null (&_tmp7_);
	rygel_database_null (&_tmp8_);
	rygel_database_null (&_tmp9_);
	g_value_init (&_tmp10_, G_TYPE_INT);
	g_value_set_int (&_tmp10_, -1);
	g_value_init (&_tmp11_, G_TYPE_INT);
	g_value_set_int (&_tmp11_, -1);
	g_value_init (&_tmp12_, G_TYPE_INT);
	g_value_set_int (&_tmp12_, -1);
	g_value_init (&_tmp13_, G_TYPE_INT);
	g_value_set_int (&_tmp13_, -1);
	g_value_init (&_tmp14_, G_TYPE_INT);
	g_value_set_int (&_tmp14_, -1);
	g_value_init (&_tmp15_, G_TYPE_INT);
	g_value_set_int (&_tmp15_, -1);
	g_value_init (&_tmp16_, G_TYPE_INT);
	g_value_set_int (&_tmp16_, -1);
	_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) container);
	_tmp18_ = _tmp17_;
	g_value_init (&_tmp19_, G_TYPE_STRING);
	g_value_set_string (&_tmp19_, _tmp18_);
	rygel_database_null (&_tmp20_);
	rygel_database_null (&_tmp21_);
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, -1);
	rygel_database_null (&_tmp23_);
	_tmp24_ = g_new0 (GValue, 20);
	_tmp24_[0] = _tmp0_;
	_tmp24_[1] = _tmp1_;
	_tmp24_[2] = _tmp2_;
	_tmp24_[3] = _tmp3_;
	_tmp24_[4] = _tmp6_;
	_tmp24_[5] = _tmp7_;
	_tmp24_[6] = _tmp8_;
	_tmp24_[7] = _tmp9_;
	_tmp24_[8] = _tmp10_;
	_tmp24_[9] = _tmp11_;
	_tmp24_[10] = _tmp12_;
	_tmp24_[11] = _tmp13_;
	_tmp24_[12] = _tmp14_;
	_tmp24_[13] = _tmp15_;
	_tmp24_[14] = _tmp16_;
	_tmp24_[15] = _tmp19_;
	_tmp24_[16] = _tmp20_;
	_tmp24_[17] = _tmp21_;
	_tmp24_[18] = _tmp22_;
	_tmp24_[19] = _tmp23_;
	values = _tmp24_;
	values_length1 = 20;
	_values_size_ = values_length1;
	_tmp25_ = self->priv->db;
	_tmp26_ = self->priv->sql;
	_tmp27_ = rygel_media_export_sql_factory_make (_tmp26_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	rygel_database_database_exec (_tmp25_, _tmp27_, values, (gint) values_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}

static void
rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self,
                                                   RygelMediaFileItem* item,
                                                   GError** error)
{
	GValue* values = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	GValue _tmp2_ = {0};
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GValue _tmp25_ = {0};
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GValue _tmp28_ = {0};
	GValue _tmp29_ = {0};
	GValue _tmp30_ = {0};
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GValue _tmp33_ = {0};
	GValue* _tmp34_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp113_;
	RygelMediaExportSQLFactory* _tmp114_;
	const gchar* _tmp115_;
	GValue* _tmp116_;
	gint _tmp116__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = rygel_media_file_item_get_size (item);
	_tmp1_ = _tmp0_;
	g_value_init (&_tmp2_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp2_, _tmp1_);
	_tmp3_ = rygel_media_file_item_get_mime_type (item);
	_tmp4_ = _tmp3_;
	g_value_init (&_tmp5_, G_TYPE_STRING);
	g_value_set_string (&_tmp5_, _tmp4_);
	g_value_init (&_tmp6_, G_TYPE_INT);
	g_value_set_int (&_tmp6_, -1);
	g_value_init (&_tmp7_, G_TYPE_INT);
	g_value_set_int (&_tmp7_, -1);
	_tmp8_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) item);
	_tmp9_ = _tmp8_;
	g_value_init (&_tmp10_, G_TYPE_STRING);
	g_value_set_string (&_tmp10_, _tmp9_);
	rygel_database_null (&_tmp11_);
	rygel_database_null (&_tmp12_);
	_tmp13_ = rygel_media_object_get_date ((RygelMediaObject*) item);
	_tmp14_ = _tmp13_;
	g_value_init (&_tmp15_, G_TYPE_STRING);
	g_value_set_string (&_tmp15_, _tmp14_);
	g_value_init (&_tmp16_, G_TYPE_INT);
	g_value_set_int (&_tmp16_, -1);
	g_value_init (&_tmp17_, G_TYPE_INT);
	g_value_set_int (&_tmp17_, -1);
	g_value_init (&_tmp18_, G_TYPE_INT);
	g_value_set_int (&_tmp18_, -1);
	g_value_init (&_tmp19_, G_TYPE_INT);
	g_value_set_int (&_tmp19_, -1);
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, -1);
	g_value_init (&_tmp21_, G_TYPE_INT);
	g_value_set_int (&_tmp21_, -1);
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, -1);
	_tmp23_ = rygel_media_object_get_id ((RygelMediaObject*) item);
	_tmp24_ = _tmp23_;
	g_value_init (&_tmp25_, G_TYPE_STRING);
	g_value_set_string (&_tmp25_, _tmp24_);
	_tmp26_ = rygel_media_file_item_get_dlna_profile (item);
	_tmp27_ = _tmp26_;
	g_value_init (&_tmp28_, G_TYPE_STRING);
	g_value_set_string (&_tmp28_, _tmp27_);
	rygel_database_null (&_tmp29_);
	g_value_init (&_tmp30_, G_TYPE_INT);
	g_value_set_int (&_tmp30_, -1);
	_tmp31_ = rygel_media_object_get_creator ((RygelMediaObject*) item);
	_tmp32_ = _tmp31_;
	g_value_init (&_tmp33_, G_TYPE_STRING);
	g_value_set_string (&_tmp33_, _tmp32_);
	_tmp34_ = g_new0 (GValue, 20);
	_tmp34_[0] = _tmp2_;
	_tmp34_[1] = _tmp5_;
	_tmp34_[2] = _tmp6_;
	_tmp34_[3] = _tmp7_;
	_tmp34_[4] = _tmp10_;
	_tmp34_[5] = _tmp11_;
	_tmp34_[6] = _tmp12_;
	_tmp34_[7] = _tmp15_;
	_tmp34_[8] = _tmp16_;
	_tmp34_[9] = _tmp17_;
	_tmp34_[10] = _tmp18_;
	_tmp34_[11] = _tmp19_;
	_tmp34_[12] = _tmp20_;
	_tmp34_[13] = _tmp21_;
	_tmp34_[14] = _tmp22_;
	_tmp34_[15] = _tmp25_;
	_tmp34_[16] = _tmp28_;
	_tmp34_[17] = _tmp29_;
	_tmp34_[18] = _tmp30_;
	_tmp34_[19] = _tmp33_;
	values = _tmp34_;
	values_length1 = 20;
	_values_size_ = values_length1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelAudioItem* _tmp35_;
		GValue* _tmp36_;
		gint _tmp36__length1;
		RygelAudioItem* _tmp37_;
		glong _tmp38_;
		glong _tmp39_;
		GValue _tmp40_ = {0};
		GValue* _tmp41_;
		gint _tmp41__length1;
		RygelAudioItem* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		GValue _tmp45_ = {0};
		GValue* _tmp46_;
		gint _tmp46__length1;
		RygelAudioItem* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		GValue _tmp50_ = {0};
		GValue* _tmp51_;
		gint _tmp51__length1;
		RygelAudioItem* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		GValue _tmp55_ = {0};
		GValue* _tmp56_;
		gint _tmp56__length1;
		RygelAudioItem* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		GValue _tmp60_ = {0};
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
		audio_item = _tmp35_;
		_tmp36_ = values;
		_tmp36__length1 = values_length1;
		_tmp37_ = audio_item;
		_tmp38_ = rygel_audio_item_get_duration (_tmp37_);
		_tmp39_ = _tmp38_;
		g_value_init (&_tmp40_, G_TYPE_LONG);
		g_value_set_long (&_tmp40_, _tmp39_);
		G_IS_VALUE (&_tmp36_[14]) ? (g_value_unset (&_tmp36_[14]), NULL) : NULL;
		_tmp36_[14] = _tmp40_;
		_tmp41_ = values;
		_tmp41__length1 = values_length1;
		_tmp42_ = audio_item;
		_tmp43_ = rygel_audio_item_get_bitrate (_tmp42_);
		_tmp44_ = _tmp43_;
		g_value_init (&_tmp45_, G_TYPE_INT);
		g_value_set_int (&_tmp45_, _tmp44_);
		G_IS_VALUE (&_tmp41_[8]) ? (g_value_unset (&_tmp41_[8]), NULL) : NULL;
		_tmp41_[8] = _tmp45_;
		_tmp46_ = values;
		_tmp46__length1 = values_length1;
		_tmp47_ = audio_item;
		_tmp48_ = rygel_audio_item_get_sample_freq (_tmp47_);
		_tmp49_ = _tmp48_;
		g_value_init (&_tmp50_, G_TYPE_INT);
		g_value_set_int (&_tmp50_, _tmp49_);
		G_IS_VALUE (&_tmp46_[9]) ? (g_value_unset (&_tmp46_[9]), NULL) : NULL;
		_tmp46_[9] = _tmp50_;
		_tmp51_ = values;
		_tmp51__length1 = values_length1;
		_tmp52_ = audio_item;
		_tmp53_ = rygel_audio_item_get_bits_per_sample (_tmp52_);
		_tmp54_ = _tmp53_;
		g_value_init (&_tmp55_, G_TYPE_INT);
		g_value_set_int (&_tmp55_, _tmp54_);
		G_IS_VALUE (&_tmp51_[10]) ? (g_value_unset (&_tmp51_[10]), NULL) : NULL;
		_tmp51_[10] = _tmp55_;
		_tmp56_ = values;
		_tmp56__length1 = values_length1;
		_tmp57_ = audio_item;
		_tmp58_ = rygel_audio_item_get_channels (_tmp57_);
		_tmp59_ = _tmp58_;
		g_value_init (&_tmp60_, G_TYPE_INT);
		g_value_set_int (&_tmp60_, _tmp59_);
		G_IS_VALUE (&_tmp56_[11]) ? (g_value_unset (&_tmp56_[11]), NULL) : NULL;
		_tmp56_[11] = _tmp60_;
		if (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (item)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaExportMusicItem* _tmp61_;
			GValue* _tmp62_;
			gint _tmp62__length1;
			RygelMediaExportMusicItem* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			GValue _tmp66_ = {0};
			GValue* _tmp67_;
			gint _tmp67__length1;
			RygelMediaExportMusicItem* _tmp68_;
			const gchar* _tmp69_;
			const gchar* _tmp70_;
			GValue _tmp71_ = {0};
			GValue* _tmp72_;
			gint _tmp72__length1;
			RygelMediaExportMusicItem* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			GValue _tmp76_ = {0};
			GValue* _tmp77_;
			gint _tmp77__length1;
			RygelMediaExportMusicItem* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			GValue _tmp81_ = {0};
			GValue* _tmp82_;
			gint _tmp82__length1;
			RygelMediaExportMusicItem* _tmp83_;
			GValue _tmp84_ = {0};
			_tmp61_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (item) ? ((RygelMediaExportMusicItem*) item) : NULL);
			music_item = _tmp61_;
			_tmp62_ = values;
			_tmp62__length1 = values_length1;
			_tmp63_ = music_item;
			_tmp64_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp63_);
			_tmp65_ = _tmp64_;
			g_value_init (&_tmp66_, G_TYPE_STRING);
			g_value_set_string (&_tmp66_, _tmp65_);
			G_IS_VALUE (&_tmp62_[5]) ? (g_value_unset (&_tmp62_[5]), NULL) : NULL;
			_tmp62_[5] = _tmp66_;
			_tmp67_ = values;
			_tmp67__length1 = values_length1;
			_tmp68_ = music_item;
			_tmp69_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp68_);
			_tmp70_ = _tmp69_;
			g_value_init (&_tmp71_, G_TYPE_STRING);
			g_value_set_string (&_tmp71_, _tmp70_);
			G_IS_VALUE (&_tmp67_[6]) ? (g_value_unset (&_tmp67_[6]), NULL) : NULL;
			_tmp67_[6] = _tmp71_;
			_tmp72_ = values;
			_tmp72__length1 = values_length1;
			_tmp73_ = music_item;
			_tmp74_ = rygel_media_object_get_genre ((RygelMediaObject*) _tmp73_);
			_tmp75_ = _tmp74_;
			g_value_init (&_tmp76_, G_TYPE_STRING);
			g_value_set_string (&_tmp76_, _tmp75_);
			G_IS_VALUE (&_tmp72_[17]) ? (g_value_unset (&_tmp72_[17]), NULL) : NULL;
			_tmp72_[17] = _tmp76_;
			_tmp77_ = values;
			_tmp77__length1 = values_length1;
			_tmp78_ = music_item;
			_tmp79_ = rygel_music_item_get_track_number ((RygelMusicItem*) _tmp78_);
			_tmp80_ = _tmp79_;
			g_value_init (&_tmp81_, G_TYPE_INT);
			g_value_set_int (&_tmp81_, _tmp80_);
			G_IS_VALUE (&_tmp77_[12]) ? (g_value_unset (&_tmp77_[12]), NULL) : NULL;
			_tmp77_[12] = _tmp81_;
			_tmp82_ = values;
			_tmp82__length1 = values_length1;
			_tmp83_ = music_item;
			g_value_init (&_tmp84_, G_TYPE_INT);
			g_value_set_int (&_tmp84_, _tmp83_->disc);
			G_IS_VALUE (&_tmp82_[18]) ? (g_value_unset (&_tmp82_[18]), NULL) : NULL;
			_tmp82_[18] = _tmp84_;
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelVisualItem* _tmp85_;
		GValue* _tmp86_;
		gint _tmp86__length1;
		RygelVisualItem* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		GValue _tmp90_ = {0};
		GValue* _tmp91_;
		gint _tmp91__length1;
		RygelVisualItem* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		GValue _tmp95_ = {0};
		GValue* _tmp96_;
		gint _tmp96__length1;
		RygelVisualItem* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		GValue _tmp100_ = {0};
		_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) item) : NULL);
		visual_item = _tmp85_;
		_tmp86_ = values;
		_tmp86__length1 = values_length1;
		_tmp87_ = visual_item;
		_tmp88_ = rygel_visual_item_get_width (_tmp87_);
		_tmp89_ = _tmp88_;
		g_value_init (&_tmp90_, G_TYPE_INT);
		g_value_set_int (&_tmp90_, _tmp89_);
		G_IS_VALUE (&_tmp86_[2]) ? (g_value_unset (&_tmp86_[2]), NULL) : NULL;
		_tmp86_[2] = _tmp90_;
		_tmp91_ = values;
		_tmp91__length1 = values_length1;
		_tmp92_ = visual_item;
		_tmp93_ = rygel_visual_item_get_height (_tmp92_);
		_tmp94_ = _tmp93_;
		g_value_init (&_tmp95_, G_TYPE_INT);
		g_value_set_int (&_tmp95_, _tmp94_);
		G_IS_VALUE (&_tmp91_[3]) ? (g_value_unset (&_tmp91_[3]), NULL) : NULL;
		_tmp91_[3] = _tmp95_;
		_tmp96_ = values;
		_tmp96__length1 = values_length1;
		_tmp97_ = visual_item;
		_tmp98_ = rygel_visual_item_get_color_depth (_tmp97_);
		_tmp99_ = _tmp98_;
		g_value_init (&_tmp100_, G_TYPE_INT);
		g_value_set_int (&_tmp100_, _tmp99_);
		G_IS_VALUE (&_tmp96_[13]) ? (g_value_unset (&_tmp96_[13]), NULL) : NULL;
		_tmp96_[13] = _tmp100_;
		if (RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM (item)) {
			RygelMediaExportVideoItem* video_item = NULL;
			RygelMediaExportVideoItem* _tmp101_;
			GValue* _tmp102_;
			gint _tmp102__length1;
			RygelMediaExportVideoItem* _tmp103_;
			const gchar* _tmp104_;
			const gchar* _tmp105_;
			GValue _tmp106_ = {0};
			_tmp101_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM (item) ? ((RygelMediaExportVideoItem*) item) : NULL);
			video_item = _tmp101_;
			_tmp102_ = values;
			_tmp102__length1 = values_length1;
			_tmp103_ = video_item;
			_tmp104_ = rygel_video_item_get_author ((RygelVideoItem*) _tmp103_);
			_tmp105_ = _tmp104_;
			g_value_init (&_tmp106_, G_TYPE_STRING);
			g_value_set_string (&_tmp106_, _tmp105_);
			G_IS_VALUE (&_tmp102_[5]) ? (g_value_unset (&_tmp102_[5]), NULL) : NULL;
			_tmp102_[5] = _tmp106_;
			_g_object_unref0 (video_item);
		}
		_g_object_unref0 (visual_item);
	}
	if (RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM (item)) {
		RygelMediaExportPlaylistItem* playlist_item = NULL;
		RygelMediaExportPlaylistItem* _tmp107_;
		GValue* _tmp108_;
		gint _tmp108__length1;
		RygelMediaExportPlaylistItem* _tmp109_;
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		GValue _tmp112_ = {0};
		_tmp107_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM (item) ? ((RygelMediaExportPlaylistItem*) item) : NULL);
		playlist_item = _tmp107_;
		_tmp108_ = values;
		_tmp108__length1 = values_length1;
		_tmp109_ = playlist_item;
		_tmp110_ = rygel_media_object_get_creator ((RygelMediaObject*) _tmp109_);
		_tmp111_ = _tmp110_;
		g_value_init (&_tmp112_, G_TYPE_STRING);
		g_value_set_string (&_tmp112_, _tmp111_);
		G_IS_VALUE (&_tmp108_[5]) ? (g_value_unset (&_tmp108_[5]), NULL) : NULL;
		_tmp108_[5] = _tmp112_;
		_g_object_unref0 (playlist_item);
	}
	_tmp113_ = self->priv->db;
	_tmp114_ = self->priv->sql;
	_tmp115_ = rygel_media_export_sql_factory_make (_tmp114_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	_tmp116_ = values;
	_tmp116__length1 = values_length1;
	rygel_database_database_exec (_tmp113_, _tmp115_, _tmp116_, (gint) _tmp116__length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}

static void
rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self,
                                                      RygelMediaObject* object,
                                                      GError** error)
{
	gint type = 0;
	GValue parent = {0};
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GValue* values = NULL;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GValue _tmp10_;
	GValue _tmp11_ = {0};
	guint64 _tmp12_;
	guint64 _tmp13_;
	GValue _tmp14_ = {0};
	gchar* _tmp15_;
	GValue _tmp16_ = {0};
	guint _tmp17_;
	guint _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GValue _tmp24_ = {0};
	GValue* _tmp25_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp33_;
	RygelMediaExportSQLFactory* _tmp34_;
	const gchar* _tmp35_;
	GValue* _tmp36_;
	gint _tmp36__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp0_ = rygel_media_object_get_parent (object);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		GValue _tmp2_ = {0};
		rygel_database_null (&_tmp2_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp2_;
	} else {
		RygelMediaContainer* _tmp3_;
		RygelMediaContainer* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
		_tmp3_ = rygel_media_object_get_parent (object);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp7_;
	}
	g_value_init (&_tmp8_, G_TYPE_INT);
	g_value_set_int (&_tmp8_, type);
	_tmp9_ = parent;
	_tmp10_ = _tmp9_;
	if (G_IS_VALUE (&_tmp10_)) {
		g_value_init (&_tmp11_, G_VALUE_TYPE (&_tmp10_));
		g_value_copy (&_tmp10_, &_tmp11_);
	} else {
		_tmp11_ = _tmp10_;
	}
	_tmp12_ = rygel_media_object_get_modified (object);
	_tmp13_ = _tmp12_;
	g_value_init (&_tmp14_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp14_, _tmp13_);
	_tmp15_ = rygel_media_object_get_primary_uri (object);
	g_value_init (&_tmp16_, G_TYPE_STRING);
	g_value_take_string (&_tmp16_, _tmp15_);
	_tmp17_ = rygel_media_object_get_object_update_id (object);
	_tmp18_ = _tmp17_;
	g_value_init (&_tmp19_, G_TYPE_UINT);
	g_value_set_uint (&_tmp19_, _tmp18_);
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, -1);
	g_value_init (&_tmp21_, G_TYPE_INT);
	g_value_set_int (&_tmp21_, -1);
	_tmp22_ = rygel_media_object_get_id (object);
	_tmp23_ = _tmp22_;
	g_value_init (&_tmp24_, G_TYPE_STRING);
	g_value_set_string (&_tmp24_, _tmp23_);
	_tmp25_ = g_new0 (GValue, 8);
	_tmp25_[0] = _tmp8_;
	_tmp25_[1] = _tmp11_;
	_tmp25_[2] = _tmp14_;
	_tmp25_[3] = _tmp16_;
	_tmp25_[4] = _tmp19_;
	_tmp25_[5] = _tmp20_;
	_tmp25_[6] = _tmp21_;
	_tmp25_[7] = _tmp24_;
	values = _tmp25_;
	values_length1 = 8;
	_values_size_ = values_length1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaContainer* container = NULL;
		RygelMediaContainer* _tmp26_;
		GValue* _tmp27_;
		gint _tmp27__length1;
		RygelMediaContainer* _tmp28_;
		GValue _tmp29_ = {0};
		GValue* _tmp30_;
		gint _tmp30__length1;
		RygelMediaContainer* _tmp31_;
		GValue _tmp32_ = {0};
		_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) object) : NULL);
		container = _tmp26_;
		_tmp27_ = values;
		_tmp27__length1 = values_length1;
		_tmp28_ = container;
		g_value_init (&_tmp29_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp29_, _tmp28_->total_deleted_child_count);
		G_IS_VALUE (&_tmp27_[6]) ? (g_value_unset (&_tmp27_[6]), NULL) : NULL;
		_tmp27_[6] = _tmp29_;
		_tmp30_ = values;
		_tmp30__length1 = values_length1;
		_tmp31_ = container;
		g_value_init (&_tmp32_, G_TYPE_UINT);
		g_value_set_uint (&_tmp32_, _tmp31_->update_id);
		G_IS_VALUE (&_tmp30_[7]) ? (g_value_unset (&_tmp30_[7]), NULL) : NULL;
		_tmp30_[7] = _tmp32_;
		_g_object_unref0 (container);
	}
	_tmp33_ = self->priv->db;
	_tmp34_ = self->priv->sql;
	_tmp35_ = rygel_media_export_sql_factory_make (_tmp34_, RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT);
	_tmp36_ = values;
	_tmp36__length1 = values_length1;
	rygel_database_database_exec (_tmp33_, _tmp35_, _tmp36_, (gint) _tmp36__length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}

static void
rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self,
                                                     RygelMediaObject* object,
                                                     gboolean is_guarded,
                                                     GError** error)
{
	gint type = 0;
	GValue parent = {0};
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GValue* values = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GValue _tmp14_ = {0};
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	GValue _tmp19_;
	GValue _tmp20_;
	GValue _tmp21_ = {0};
	guint64 _tmp22_;
	guint64 _tmp23_;
	GValue _tmp24_ = {0};
	gchar* _tmp25_;
	GValue _tmp26_ = {0};
	guint _tmp27_;
	guint _tmp28_;
	GValue _tmp29_ = {0};
	GValue _tmp30_ = {0};
	GValue _tmp31_ = {0};
	GValue _tmp32_ = {0};
	GValue _tmp33_ = {0};
	GValue* _tmp34_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp42_;
	RygelMediaExportSQLFactory* _tmp43_;
	const gchar* _tmp44_;
	GValue* _tmp45_;
	gint _tmp45__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp0_ = rygel_media_object_get_parent (object);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		GValue _tmp2_ = {0};
		rygel_database_null (&_tmp2_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp2_;
	} else {
		RygelMediaContainer* _tmp3_;
		RygelMediaContainer* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
		_tmp3_ = rygel_media_object_get_parent (object);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp7_;
	}
	if (is_guarded) {
		_tmp8_ = 1;
	} else {
		_tmp8_ = 0;
	}
	_tmp10_ = rygel_media_object_get_ref_id (object);
	_tmp11_ = _tmp10_;
	_tmp9_ = _tmp11_;
	if (_tmp9_ == NULL) {
		_tmp9_ = NULL;
	}
	_tmp12_ = rygel_media_object_get_id (object);
	_tmp13_ = _tmp12_;
	g_value_init (&_tmp14_, G_TYPE_STRING);
	g_value_set_string (&_tmp14_, _tmp13_);
	_tmp15_ = rygel_media_object_get_title (object);
	_tmp16_ = _tmp15_;
	g_value_init (&_tmp17_, G_TYPE_STRING);
	g_value_set_string (&_tmp17_, _tmp16_);
	g_value_init (&_tmp18_, G_TYPE_INT);
	g_value_set_int (&_tmp18_, type);
	_tmp19_ = parent;
	_tmp20_ = _tmp19_;
	if (G_IS_VALUE (&_tmp20_)) {
		g_value_init (&_tmp21_, G_VALUE_TYPE (&_tmp20_));
		g_value_copy (&_tmp20_, &_tmp21_);
	} else {
		_tmp21_ = _tmp20_;
	}
	_tmp22_ = rygel_media_object_get_modified (object);
	_tmp23_ = _tmp22_;
	g_value_init (&_tmp24_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp24_, _tmp23_);
	_tmp25_ = rygel_media_object_get_primary_uri (object);
	g_value_init (&_tmp26_, G_TYPE_STRING);
	g_value_take_string (&_tmp26_, _tmp25_);
	_tmp27_ = rygel_media_object_get_object_update_id (object);
	_tmp28_ = _tmp27_;
	g_value_init (&_tmp29_, G_TYPE_UINT);
	g_value_set_uint (&_tmp29_, _tmp28_);
	g_value_init (&_tmp30_, G_TYPE_INT);
	g_value_set_int (&_tmp30_, -1);
	g_value_init (&_tmp31_, G_TYPE_INT);
	g_value_set_int (&_tmp31_, -1);
	g_value_init (&_tmp32_, G_TYPE_INT);
	g_value_set_int (&_tmp32_, _tmp8_);
	g_value_init (&_tmp33_, G_TYPE_STRING);
	g_value_set_string (&_tmp33_, _tmp9_);
	_tmp34_ = g_new0 (GValue, 11);
	_tmp34_[0] = _tmp14_;
	_tmp34_[1] = _tmp17_;
	_tmp34_[2] = _tmp18_;
	_tmp34_[3] = _tmp21_;
	_tmp34_[4] = _tmp24_;
	_tmp34_[5] = _tmp26_;
	_tmp34_[6] = _tmp29_;
	_tmp34_[7] = _tmp30_;
	_tmp34_[8] = _tmp31_;
	_tmp34_[9] = _tmp32_;
	_tmp34_[10] = _tmp33_;
	values = _tmp34_;
	values_length1 = 11;
	_values_size_ = values_length1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaContainer* container = NULL;
		RygelMediaContainer* _tmp35_;
		GValue* _tmp36_;
		gint _tmp36__length1;
		RygelMediaContainer* _tmp37_;
		GValue _tmp38_ = {0};
		GValue* _tmp39_;
		gint _tmp39__length1;
		RygelMediaContainer* _tmp40_;
		GValue _tmp41_ = {0};
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) object) : NULL);
		container = _tmp35_;
		_tmp36_ = values;
		_tmp36__length1 = values_length1;
		_tmp37_ = container;
		g_value_init (&_tmp38_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp38_, _tmp37_->total_deleted_child_count);
		G_IS_VALUE (&_tmp36_[7]) ? (g_value_unset (&_tmp36_[7]), NULL) : NULL;
		_tmp36_[7] = _tmp38_;
		_tmp39_ = values;
		_tmp39__length1 = values_length1;
		_tmp40_ = container;
		g_value_init (&_tmp41_, G_TYPE_UINT);
		g_value_set_uint (&_tmp41_, _tmp40_->update_id);
		G_IS_VALUE (&_tmp39_[8]) ? (g_value_unset (&_tmp39_[8]), NULL) : NULL;
		_tmp39_[8] = _tmp41_;
		_g_object_unref0 (container);
	}
	_tmp42_ = self->priv->db;
	_tmp43_ = self->priv->sql;
	_tmp44_ = rygel_media_export_sql_factory_make (_tmp43_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
	_tmp45_ = values;
	_tmp45__length1 = values_length1;
	rygel_database_database_exec (_tmp42_, _tmp44_, _tmp45_, (gint) _tmp45__length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}

/**
     * Add the container or item to the cache.
     */
static void
rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self,
                                              RygelMediaObject* object,
                                              gboolean override_guarded,
                                              GError** error)
{
	gboolean is_guarded = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_object_get_id (object);
	_tmp1_ = _tmp0_;
	is_guarded = rygel_media_export_media_cache_is_object_guarded (self, _tmp1_);
	if (!override_guarded) {
		_tmp2_ = is_guarded;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		rygel_media_export_media_cache_update_guarded_object (self, object, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		if (is_guarded) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = override_guarded;
		}
		rygel_media_export_media_cache_create_normal_object (self, object, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean
rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		RygelMediaExportSQLFactory* _tmp2_;
		const gchar* _tmp3_;
		RygelDatabaseDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_;
		RygelDatabaseDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_;
		RygelDatabaseDatabase* _tmp10_;
		RygelMediaExportSQLFactory* _tmp11_;
		const gchar* _tmp12_;
		RygelDatabaseDatabase* _tmp13_;
		RygelMediaExportSQLFactory* _tmp14_;
		const gchar* _tmp15_;
		RygelDatabaseDatabase* _tmp16_;
		RygelMediaExportSQLFactory* _tmp17_;
		const gchar* _tmp18_;
		RygelDatabaseDatabase* _tmp19_;
		RygelDatabaseDatabase* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp0_ = self->priv->db;
		rygel_database_database_begin (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->db;
		_tmp2_ = self->priv->sql;
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
		rygel_database_database_exec (_tmp1_, _tmp3_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->db;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_database_database_exec (_tmp4_, _tmp6_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->db;
		_tmp8_ = self->priv->sql;
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_database_database_exec (_tmp7_, _tmp9_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->db;
		_tmp11_ = self->priv->sql;
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp10_, _tmp12_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = self->priv->db;
		_tmp14_ = self->priv->sql;
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp13_, _tmp15_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = self->priv->db;
		_tmp17_ = self->priv->sql;
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
		rygel_database_database_exec (_tmp16_, _tmp18_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = self->priv->db;
		rygel_database_database_commit (_tmp19_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp20_ = self->priv->db;
		rygel_database_database_analyze (_tmp20_);
		_tmp21_ = gupnp_get_uuid ();
		_tmp22_ = _tmp21_;
		rygel_media_export_media_cache_save_reset_token (self, _tmp22_);
		_g_free0 (_tmp22_);
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		RygelDatabaseDatabase* _tmp25_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning (_ ("Failed to create database schema: %s"), _tmp24_);
		_tmp25_ = self->priv->db;
		rygel_database_database_rollback (_tmp25_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp26_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp26_;
	}
	result = FALSE;
	return result;
}

/**
     * Create a new container or item based on a SQL result.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     *
     * @param parent The object's parent container.
     * @param statement a SQLite result indicating the container's details.
     */
static RygelMediaObject*
rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self,
                                                          RygelMediaContainer* parent,
                                                          sqlite3_stmt* statement)
{
	RygelMediaObject* object = NULL;
	const gchar* title = NULL;
	const gchar* _tmp0_;
	const gchar* object_id = NULL;
	const gchar* _tmp1_;
	const gchar* uri = NULL;
	const gchar* _tmp2_;
	RygelMediaObject* _tmp28_;
	RygelMediaObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	object = NULL;
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
	title = _tmp0_;
	_tmp1_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	object_id = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
	uri = _tmp2_;
	switch (sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE)) {
		case 0:
		{
			RygelMediaExportObjectFactory* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			RygelMediaContainer* _tmp7_;
			RygelMediaContainer* container = NULL;
			RygelMediaObject* _tmp8_;
			RygelMediaContainer* _tmp9_;
			const gchar* _tmp10_;
			RygelMediaContainer* _tmp13_;
			RygelMediaContainer* _tmp14_;
			_tmp3_ = self->priv->factory;
			_tmp4_ = object_id;
			_tmp5_ = title;
			_tmp6_ = uri;
			_tmp7_ = rygel_media_export_object_factory_get_container (_tmp3_, _tmp4_, _tmp5_, (guint) 0, _tmp6_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp8_) : NULL);
			container = _tmp9_;
			_tmp10_ = uri;
			if (_tmp10_ != NULL) {
				RygelMediaContainer* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = container;
				_tmp12_ = uri;
				rygel_media_object_add_uri ((RygelMediaObject*) _tmp11_, _tmp12_);
			}
			_tmp13_ = container;
			_tmp13_->total_deleted_child_count = (gint64) ((guint32) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT));
			_tmp14_ = container;
			_tmp14_->update_id = (guint32) ((guint) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID));
			_g_object_unref0 (container);
			break;
		}
		case 1:
		{
			const gchar* upnp_class = NULL;
			const gchar* _tmp15_;
			RygelMediaExportObjectFactory* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			RygelMediaFileItem* _tmp20_;
			RygelMediaFileItem* item = NULL;
			RygelMediaObject* _tmp21_;
			RygelMediaFileItem* _tmp22_;
			RygelMediaFileItem* _tmp23_;
			const gchar* _tmp24_;
			RygelMediaFileItem* _tmp27_;
			_tmp15_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
			upnp_class = _tmp15_;
			_tmp16_ = self->priv->factory;
			_tmp17_ = object_id;
			_tmp18_ = title;
			_tmp19_ = upnp_class;
			_tmp20_ = rygel_media_export_object_factory_get_item (_tmp16_, parent, _tmp17_, _tmp18_, _tmp19_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp20_;
			_tmp21_ = object;
			_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp21_) : NULL);
			item = _tmp22_;
			_tmp23_ = item;
			rygel_media_export_media_cache_fill_item (self, statement, _tmp23_);
			_tmp24_ = uri;
			if (_tmp24_ != NULL) {
				RygelMediaFileItem* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = item;
				_tmp26_ = uri;
				rygel_media_object_add_uri ((RygelMediaObject*) _tmp25_, _tmp26_);
			}
			_tmp27_ = item;
			rygel_media_file_item_add_engine_resources (_tmp27_, NULL, NULL);
			_g_object_unref0 (item);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp28_ = object;
	if (_tmp28_ != NULL) {
		RygelMediaObject* _tmp29_;
		RygelMediaFileItem* item = NULL;
		RygelMediaObject* _tmp30_;
		RygelMediaFileItem* _tmp31_;
		gboolean _tmp32_ = FALSE;
		RygelMediaObject* _tmp33_;
		guint64 _tmp34_;
		guint64 _tmp35_;
		RygelMediaObject* _tmp39_;
		RygelMediaObject* _tmp40_;
		const gchar* _tmp41_;
		_tmp29_ = object;
		rygel_media_object_set_modified (_tmp29_, (guint64) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP));
		_tmp30_ = object;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp30_) : NULL);
		item = _tmp31_;
		_tmp33_ = object;
		_tmp34_ = rygel_media_object_get_modified (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == ((guint64) G_MAXINT64)) {
			RygelMediaFileItem* _tmp36_;
			_tmp36_ = item;
			_tmp32_ = _tmp36_ != NULL;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			RygelMediaObject* _tmp37_;
			RygelMediaFileItem* _tmp38_;
			_tmp37_ = object;
			rygel_media_object_set_modified (_tmp37_, (guint64) 0);
			_tmp38_ = item;
			rygel_media_file_item_set_place_holder (_tmp38_, TRUE);
		}
		_tmp39_ = object;
		rygel_media_object_set_object_update_id (_tmp39_, (guint) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID));
		_tmp40_ = object;
		_tmp41_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID);
		rygel_media_object_set_ref_id (_tmp40_, _tmp41_);
		_g_object_unref0 (item);
	}
	result = object;
	return result;
}

static void
rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self,
                                          sqlite3_stmt* statement,
                                          RygelMediaFileItem* item)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
	rygel_media_object_set_date ((RygelMediaObject*) item, _tmp0_);
	_tmp1_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
	rygel_media_file_item_set_mime_type (item, _tmp1_);
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
	rygel_media_file_item_set_dlna_profile (item, _tmp2_);
	rygel_media_file_item_set_size (item, sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE));
	_tmp3_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR);
	rygel_media_object_set_creator ((RygelMediaObject*) item, _tmp3_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelAudioItem* _tmp4_;
		RygelAudioItem* _tmp5_;
		RygelAudioItem* _tmp6_;
		RygelAudioItem* _tmp7_;
		RygelAudioItem* _tmp8_;
		RygelAudioItem* _tmp9_;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
		audio_item = _tmp4_;
		_tmp5_ = audio_item;
		rygel_audio_item_set_duration (_tmp5_, (glong) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION));
		_tmp6_ = audio_item;
		rygel_audio_item_set_bitrate (_tmp6_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE));
		_tmp7_ = audio_item;
		rygel_audio_item_set_sample_freq (_tmp7_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ));
		_tmp8_ = audio_item;
		rygel_audio_item_set_bits_per_sample (_tmp8_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE));
		_tmp9_ = audio_item;
		rygel_audio_item_set_channels (_tmp9_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS));
		if (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (item)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaExportMusicItem* _tmp10_;
			RygelMediaExportMusicItem* _tmp11_;
			const gchar* _tmp12_;
			RygelMediaExportMusicItem* _tmp13_;
			const gchar* _tmp14_;
			RygelMediaExportMusicItem* _tmp15_;
			const gchar* _tmp16_;
			RygelMediaExportMusicItem* _tmp17_;
			RygelMediaExportMusicItem* _tmp18_;
			_tmp10_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (item) ? ((RygelMediaExportMusicItem*) item) : NULL);
			music_item = _tmp10_;
			_tmp11_ = music_item;
			_tmp12_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
			rygel_media_object_set_artist ((RygelMediaObject*) _tmp11_, _tmp12_);
			_tmp13_ = music_item;
			_tmp14_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
			rygel_audio_item_set_album ((RygelAudioItem*) _tmp13_, _tmp14_);
			_tmp15_ = music_item;
			_tmp16_ = (const gchar*) sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
			rygel_media_object_set_genre ((RygelMediaObject*) _tmp15_, _tmp16_);
			_tmp17_ = music_item;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp17_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK));
			_tmp18_ = music_item;
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp18_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelVisualItem* _tmp19_;
		RygelVisualItem* _tmp20_;
		RygelVisualItem* _tmp21_;
		RygelVisualItem* _tmp22_;
		_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) item) : NULL);
		visual_item = _tmp19_;
		_tmp20_ = visual_item;
		rygel_visual_item_set_width (_tmp20_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH));
		_tmp21_ = visual_item;
		rygel_visual_item_set_height (_tmp21_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT));
		_tmp22_ = visual_item;
		rygel_visual_item_set_color_depth (_tmp22_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH));
		_g_object_unref0 (visual_item);
	}
}

static gchar*
rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression,
                                                            GValueArray* args,
                                                            const gchar* prefix,
                                                            GError** error)
{
	gchar* filter = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = rygel_media_export_media_cache_search_expression_to_sql (expression, args, &_inner_error0_);
	filter = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = filter;
	_tmp3_ = g_strdup_printf (" %s %s", prefix, _tmp2_);
	result = _tmp3_;
	_g_free0 (filter);
	return result;
}

static gchar*
rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression,
                                                         GValueArray* args,
                                                         GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (args != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = rygel_media_export_media_cache_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) expression) : NULL, args, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp1_);
		return result;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = rygel_media_export_media_cache_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) expression) : NULL, args, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		result = _tmp6_;
		_g_free0 (_tmp4_);
		return result;
	}
}

static gchar*
rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression,
                                                          GValueArray* args,
                                                          GError** error)
{
	gchar* left_sql_string = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	gchar* right_sql_string = NULL;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* operator_sql_string = NULL;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = ((RygelSearchExpression*) expression)->operand1;
	_tmp1_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp0_, args, &_inner_error0_);
	left_sql_string = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = ((RygelSearchExpression*) expression)->operand2;
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp2_, args, &_inner_error0_);
	right_sql_string = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	operator_sql_string = "OR";
	_tmp4_ = ((RygelSearchExpression*) expression)->op;
	if (((RygelLogicalOperator) ((gintptr) _tmp4_)) == RYGEL_LOGICAL_OPERATOR_AND) {
		operator_sql_string = "AND";
	}
	_tmp5_ = left_sql_string;
	_tmp6_ = operator_sql_string;
	_tmp7_ = right_sql_string;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp5_, _tmp6_, _tmp7_);
	result = _tmp8_;
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}

static gchar*
rygel_media_export_media_cache_map_operand_to_column (const gchar* operand,
                                                      gchar** collate,
                                                      gboolean for_sort,
                                                      GError** error)
{
	gchar* _vala_collate = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("res")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("o.uri");
				_g_free0 (column);
				column = _tmp3_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("res@duration")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("m.duration");
				_g_free0 (column);
				column = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("o.upnp_id");
				_g_free0 (column);
				column = _tmp5_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("o.parent");
				_g_free0 (column);
				column = _tmp6_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("m.class");
				_g_free0 (column);
				column = _tmp7_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("o.title");
				_g_free0 (column);
				column = _tmp8_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("upnp:artist")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("upnp:author"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("m.author");
				_g_free0 (column);
				column = _tmp9_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("m.creator");
				_g_free0 (column);
				column = _tmp10_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				if (for_sort) {
					gchar* _tmp11_;
					_tmp11_ = g_strdup ("m.date");
					_g_free0 (column);
					column = _tmp11_;
				} else {
					gchar* _tmp12_;
					_tmp12_ = g_strdup ("strftime(\"%Y\", m.date)");
					_g_free0 (column);
					column = _tmp12_;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				_tmp13_ = g_strdup ("m.album");
				_g_free0 (column);
				column = _tmp13_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("dc:genre"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("m.genre");
				_g_free0 (column);
				column = _tmp14_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("m.track");
				_g_free0 (column);
				column = _tmp15_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup ("m.disc");
				_g_free0 (column);
				column = _tmp16_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("o.object_update_id");
				_g_free0 (column);
				column = _tmp17_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				_tmp18_ = g_strdup ("o.container_update_id");
				_g_free0 (column);
				column = _tmp18_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* message = NULL;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				GError* _tmp21_;
				_tmp19_ = g_strdup_printf ("Unsupported column %s", operand);
				message = _tmp19_;
				_tmp20_ = message;
				_tmp21_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp20_);
				_inner_error0_ = _tmp21_;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (message);
				_g_free0 (column);
				_g_free0 (_vala_collate);
				return NULL;
			}
		}
	}
	if (use_collation) {
		gchar* _tmp22_;
		_tmp22_ = g_strdup ("COLLATE CASEFOLD");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp22_;
	} else {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp23_;
	}
	result = column;
	if (collate) {
		*collate = _vala_collate;
	} else {
		_g_free0 (_vala_collate);
	}
	return result;
}

static gchar*
rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp,
                                                             GValueArray* args,
                                                             GError** error)
{
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	RygelDatabaseSqlOperator* operator = NULL;
	gconstpointer _tmp3_;
	GValue* _tmp31_;
	RygelDatabaseSqlOperator* _tmp34_;
	gchar* _tmp35_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp0_ = ((RygelSearchExpression*) exp)->operand1;
	_tmp2_ = rygel_media_export_media_cache_map_operand_to_column ((const gchar*) _tmp0_, &_tmp1_, FALSE, &_inner_error0_);
	_g_free0 (collate);
	collate = _tmp1_;
	column = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	_tmp3_ = ((RygelSearchExpression*) exp)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp3_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			gconstpointer _tmp4_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = ((RygelSearchExpression*) exp)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp4_, "true") == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp5_;
			} else {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp6_;
			}
			_tmp7_ = sql_function;
			_tmp8_ = column;
			_tmp9_ = column;
			_tmp10_ = g_strdup_printf (_tmp7_, _tmp8_, _tmp9_);
			result = _tmp10_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			gconstpointer _tmp11_;
			GValue* _tmp12_ = NULL;
			gconstpointer _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			RygelDatabaseSqlOperator* _tmp16_;
			_tmp11_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp12_ = g_new0 (GValue, 1);
			g_value_init (_tmp12_, G_TYPE_STRING);
			g_value_set_string (_tmp12_, (const gchar*) _tmp11_);
			__vala_GValue_free0 (v);
			v = _tmp12_;
			_tmp13_ = ((RygelSearchExpression*) exp)->op;
			_tmp14_ = column;
			_tmp15_ = collate;
			_tmp16_ = rygel_database_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp13_), _tmp14_, _tmp15_);
			_g_object_unref0 (operator);
			operator = _tmp16_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp17_;
			RygelDatabaseSqlFunction* _tmp18_;
			gconstpointer _tmp19_;
			GValue* _tmp20_ = NULL;
			_tmp17_ = column;
			_tmp18_ = rygel_database_sql_function_new ("contains", _tmp17_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp18_;
			_tmp19_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp20_ = g_new0 (GValue, 1);
			g_value_init (_tmp20_, G_TYPE_STRING);
			g_value_set_string (_tmp20_, (const gchar*) _tmp19_);
			__vala_GValue_free0 (v);
			v = _tmp20_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			const gchar* _tmp21_;
			RygelDatabaseSqlFunction* _tmp22_;
			gconstpointer _tmp23_;
			GValue* _tmp24_ = NULL;
			_tmp21_ = column;
			_tmp22_ = rygel_database_sql_function_new ("NOT contains", _tmp21_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp22_;
			_tmp23_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp24_ = g_new0 (GValue, 1);
			g_value_init (_tmp24_, G_TYPE_STRING);
			g_value_set_string (_tmp24_, (const gchar*) _tmp23_);
			__vala_GValue_free0 (v);
			v = _tmp24_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp25_;
			RygelDatabaseSqlOperator* _tmp26_;
			gconstpointer _tmp27_;
			gchar* _tmp28_;
			GValue* _tmp29_ = NULL;
			_tmp25_ = column;
			_tmp26_ = rygel_database_sql_operator_new ("LIKE", _tmp25_, "");
			_g_object_unref0 (operator);
			operator = _tmp26_;
			_tmp27_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp28_ = g_strdup_printf ("%s%%", (const gchar*) _tmp27_);
			_tmp29_ = g_new0 (GValue, 1);
			g_value_init (_tmp29_, G_TYPE_STRING);
			g_value_take_string (_tmp29_, _tmp28_);
			__vala_GValue_free0 (v);
			v = _tmp29_;
			break;
		}
		default:
		{
			gconstpointer _tmp30_;
			_tmp30_ = ((RygelSearchExpression*) exp)->op;
			g_debug ("rygel-media-export-media-cache.vala:1183: Unsupported search criteria " \
"op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp30_)));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	_tmp31_ = v;
	if (((gpointer) _tmp31_) != NULL) {
		GValue* _tmp32_;
		GValue _tmp33_;
		_tmp32_ = v;
		_tmp33_ = *_tmp32_;
		g_value_array_append (args, &_tmp33_);
	}
	_tmp34_ = operator;
	_tmp35_ = rygel_database_sql_operator_to_string (_tmp34_);
	result = _tmp35_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}

static RygelDatabaseCursor*
rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self,
                                            RygelMediaExportSQLString id,
                                            GValue* values,
                                            gint values_length1,
                                            GError** error)
{
	RygelDatabaseCursor* _tmp0_ = NULL;
	RygelDatabaseDatabase* _tmp1_;
	RygelMediaExportSQLFactory* _tmp2_;
	const gchar* _tmp3_;
	RygelDatabaseCursor* _tmp4_;
	RygelDatabaseCursor* _tmp5_;
	GError* _inner_error0_ = NULL;
	RygelDatabaseCursor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->db;
	_tmp2_ = self->priv->sql;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, id);
	_tmp4_ = rygel_database_database_exec_cursor (_tmp1_, _tmp3_, values, (gint) values_length1, &_inner_error0_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gint
rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self,
                                            RygelMediaExportSQLString id,
                                            GValue* values,
                                            gint values_length1,
                                            GError** error)
{
	gint _tmp0_ = 0;
	RygelDatabaseDatabase* _tmp1_;
	RygelMediaExportSQLFactory* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->db;
	_tmp2_ = self->priv->sql;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, id);
	_tmp0_ = rygel_database_database_query_value (_tmp1_, _tmp3_, values, (gint) values_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gint _tmp4_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gint _tmp5_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria,
                                                        gchar** extra_columns,
                                                        gint* column_count)
{
	gchar* _vala_extra_columns = NULL;
	gint _vala_column_count = 0;
	gchar* collate = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* column_builder = NULL;
	GString* _tmp1_;
	gchar** fields = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_string_new ("ORDER BY ");
	builder = _tmp0_;
	_tmp1_ = g_string_new ("");
	column_builder = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (sort_criteria, ",", 0);
	fields = _tmp3_;
	fields_length1 = _vala_array_length (_tmp2_);
	_fields_size_ = fields_length1;
	_tmp4_ = fields;
	_tmp4__length1 = fields_length1;
	_vala_column_count = _tmp4__length1;
	_tmp5_ = fields;
	_tmp5__length1 = fields_length1;
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp5_;
		field_collection_length1 = _tmp5__length1;
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			const gchar* field = NULL;
			field = field_collection[field_it];
			{
				{
					gchar* column = NULL;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					const gchar* _tmp17_;
					GString* _tmp19_;
					const gchar* _tmp20_ = NULL;
					const gchar* _tmp21_;
					GString* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					GString* _tmp25_;
					const gchar* _tmp26_;
					_tmp6_ = field;
					_tmp7_ = field;
					_tmp8_ = strlen (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp13_ = rygel_media_export_media_cache_map_operand_to_column (_tmp11_, &_tmp12_, TRUE, &_inner_error0_);
					_g_free0 (collate);
					collate = _tmp12_;
					_tmp14_ = _tmp13_;
					_g_free0 (_tmp11_);
					column = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp15_ = field;
					_tmp16_ = fields;
					_tmp16__length1 = fields_length1;
					_tmp17_ = _tmp16_[0];
					if (g_strcmp0 (_tmp15_, _tmp17_) != 0) {
						GString* _tmp18_;
						_tmp18_ = builder;
						g_string_append (_tmp18_, ",");
					}
					_tmp19_ = column_builder;
					g_string_append (_tmp19_, ",");
					_tmp21_ = field;
					if (string_get (_tmp21_, (glong) 0) == '-') {
						_tmp20_ = "DESC";
					} else {
						_tmp20_ = "ASC";
					}
					_tmp22_ = builder;
					_tmp23_ = column;
					_tmp24_ = collate;
					g_string_append_printf (_tmp22_, "%s %s %s ", _tmp23_, _tmp24_, _tmp20_);
					_tmp25_ = column_builder;
					_tmp26_ = column;
					g_string_append (_tmp25_, _tmp26_);
					_g_free0 (column);
				}
				goto __finally0;
				__catch0_g_error:
				{
					const gchar* _tmp27_;
					g_clear_error (&_inner_error0_);
					_tmp27_ = field;
					g_warning (_ ("Skipping unsupported sort field: %s"), _tmp27_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (column_builder);
					_g_string_free0 (builder);
					_g_free0 (collate);
					_g_free0 (_vala_extra_columns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp28_ = column_builder;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	_g_free0 (_vala_extra_columns);
	_vala_extra_columns = _tmp30_;
	_tmp31_ = builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (column_builder);
	_g_string_free0 (builder);
	_g_free0 (collate);
	if (extra_columns) {
		*extra_columns = _vala_extra_columns;
	} else {
		_g_free0 (_vala_extra_columns);
	}
	if (column_count) {
		*column_count = _vala_column_count;
	}
	return result;
}

static void
rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass,
                                           gpointer klass_data)
{
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportMediaCache_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}

static void
rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self,
                                              gpointer klass)
{
	self->priv = rygel_media_export_media_cache_get_instance_private (self);
}

static void
rygel_media_export_media_cache_finalize (GObject * obj)
{
	RygelMediaExportMediaCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->sql);
	_g_object_unref0 (self->priv->exists_cache);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}

/**
 * Persistent storage of media objects.
 *
 * MediaExportDB is a sqlite3 backed persistent storage of media objects.
 */
static GType
rygel_media_export_media_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
	GType rygel_media_export_media_cache_type_id;
	rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
	RygelMediaExportMediaCache_private_offset = g_type_add_instance_private (rygel_media_export_media_cache_type_id, sizeof (RygelMediaExportMediaCachePrivate));
	return rygel_media_export_media_cache_type_id;
}

GType
rygel_media_export_media_cache_get_type (void)
{
	static volatile gsize rygel_media_export_media_cache_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__once)) {
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = rygel_media_export_media_cache_get_type_once ();
		g_once_init_leave (&rygel_media_export_media_cache_type_id__once, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

