/* headerwidget.c generated by valac 0.56.2, the Vala compiler
 * generated from headerwidget.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

enum  {
	BUDGIE_HEADER_EXPANDER_0_PROPERTY,
	BUDGIE_HEADER_EXPANDER_EXPANDED_PROPERTY,
	BUDGIE_HEADER_EXPANDER_NUM_PROPERTIES
};
static GParamSpec* budgie_header_expander_properties[BUDGIE_HEADER_EXPANDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BUDGIE_HEADER_WIDGET_0_PROPERTY,
	BUDGIE_HEADER_WIDGET_TEXT_PROPERTY,
	BUDGIE_HEADER_WIDGET_ICON_NAME_PROPERTY,
	BUDGIE_HEADER_WIDGET_CAN_CLOSE_PROPERTY,
	BUDGIE_HEADER_WIDGET_EXPANDED_PROPERTY,
	BUDGIE_HEADER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_HEADER_WIDGET_CLOSED_SIGNAL,
	BUDGIE_HEADER_WIDGET_NUM_SIGNALS
};
static guint budgie_header_widget_signals[BUDGIE_HEADER_WIDGET_NUM_SIGNALS] = {0};
enum  {
	BUDGIE_RAVEN_EXPANDER_0_PROPERTY,
	BUDGIE_RAVEN_EXPANDER_EXPANDED_PROPERTY,
	BUDGIE_RAVEN_EXPANDER_NUM_PROPERTIES
};
static GParamSpec* budgie_raven_expander_properties[BUDGIE_RAVEN_EXPANDER_NUM_PROPERTIES];

struct _BudgieHeaderExpanderPrivate {
	GtkImage* image;
	gboolean _expanded;
	BudgieHeaderWidget* owner;
};

struct _BudgieHeaderWidgetPrivate {
	GtkImage* image;
	GtkLabel* label;
	GtkButton* close_button;
	GtkBox* header_box;
	gboolean _expanded;
};

struct _BudgieRavenExpanderPrivate {
	BudgieHeaderWidget* header;
	gboolean track_animations;
};

static gint BudgieHeaderExpander_private_offset;
static gpointer budgie_header_expander_parent_class = NULL;
static gint BudgieHeaderWidget_private_offset;
static gpointer budgie_header_widget_parent_class = NULL;
static gint BudgieRavenExpander_private_offset;
static gpointer budgie_raven_expander_parent_class = NULL;

static void budgie_header_expander_real_clicked (GtkButton* base);
static void budgie_header_expander_finalize (GObject * obj);
static GType budgie_header_expander_get_type_once (void);
static void _vala_budgie_header_expander_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_budgie_header_expander_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void __lambda4_ (BudgieHeaderWidget* self);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void budgie_header_widget_finalize (GObject * obj);
static GType budgie_header_widget_get_type_once (void);
static void _vala_budgie_header_widget_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_budgie_header_widget_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void __lambda5_ (BudgieRavenExpander* self);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda6_ (BudgieRavenExpander* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (BudgieRavenExpander* self);
static void budgie_raven_expander_after_paint (BudgieRavenExpander* self,
                                        GdkFrameClock* clock);
static void _budgie_raven_expander_after_paint_gdk_frame_clock_after_paint (GdkFrameClock* _sender,
                                                                     gpointer self);
static void ___lambda7__gtk_widget_map (GtkWidget* _sender,
                                 gpointer self);
static void budgie_raven_expander_real_add (GtkContainer* base,
                                     GtkWidget* widget);
static void budgie_raven_expander_finalize (GObject * obj);
static GType budgie_raven_expander_get_type_once (void);
static void _vala_budgie_raven_expander_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_budgie_raven_expander_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
budgie_header_expander_get_instance_private (BudgieHeaderExpander* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieHeaderExpander_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieHeaderExpander*
budgie_header_expander_construct (GType object_type,
                                  BudgieHeaderWidget* owner)
{
	BudgieHeaderExpander * self = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkStyleContext* st = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	self = (BudgieHeaderExpander*) g_object_new (object_type, NULL);
	self->priv->owner = owner;
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp0_;
	_tmp1_ = self->priv->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	st = _tmp3_;
	gtk_style_context_add_class (st, "flat");
	gtk_style_context_add_class (st, "expander-button");
	_g_object_unref0 (st);
	return self;
}

BudgieHeaderExpander*
budgie_header_expander_new (BudgieHeaderWidget* owner)
{
	return budgie_header_expander_construct (BUDGIE_TYPE_HEADER_EXPANDER, owner);
}

static void
budgie_header_expander_real_clicked (GtkButton* base)
{
	BudgieHeaderExpander * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	BudgieHeaderWidget* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	self = (BudgieHeaderExpander*) base;
	_tmp0_ = budgie_header_expander_get_expanded (self);
	_tmp1_ = _tmp0_;
	budgie_header_expander_set_expanded (self, !_tmp1_);
	_tmp2_ = self->priv->owner;
	_tmp3_ = budgie_header_expander_get_expanded (self);
	_tmp4_ = _tmp3_;
	budgie_header_widget_set_expanded (_tmp2_, _tmp4_);
}

gboolean
budgie_header_expander_get_expanded (BudgieHeaderExpander* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expanded;
	return result;
}

void
budgie_header_expander_set_expanded (BudgieHeaderExpander* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_expanded = value;
	if (self->priv->_expanded) {
		GtkImage* _tmp0_;
		_tmp0_ = self->priv->image;
		g_object_set (_tmp0_, "icon-name", "pan-down-symbolic", NULL);
	} else {
		GtkImage* _tmp1_;
		_tmp1_ = self->priv->image;
		g_object_set (_tmp1_, "icon-name", "pan-end-symbolic", NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, budgie_header_expander_properties[BUDGIE_HEADER_EXPANDER_EXPANDED_PROPERTY]);
}

static void
budgie_header_expander_class_init (BudgieHeaderExpanderClass * klass,
                                   gpointer klass_data)
{
	budgie_header_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieHeaderExpander_private_offset);
	((GtkButtonClass *) klass)->clicked = (void (*) (GtkButton*)) budgie_header_expander_real_clicked;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_header_expander_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_header_expander_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_header_expander_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_EXPANDER_EXPANDED_PROPERTY, budgie_header_expander_properties[BUDGIE_HEADER_EXPANDER_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_header_expander_instance_init (BudgieHeaderExpander * self,
                                      gpointer klass)
{
	self->priv = budgie_header_expander_get_instance_private (self);
	self->priv->_expanded = FALSE;
	self->priv->owner = NULL;
}

static void
budgie_header_expander_finalize (GObject * obj)
{
	BudgieHeaderExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (budgie_header_expander_parent_class)->finalize (obj);
}

/**
* Simple expander button for the header widget
*/
static GType
budgie_header_expander_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieHeaderExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_header_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieHeaderExpander), 0, (GInstanceInitFunc) budgie_header_expander_instance_init, NULL };
	GType budgie_header_expander_type_id;
	budgie_header_expander_type_id = g_type_register_static (gtk_button_get_type (), "BudgieHeaderExpander", &g_define_type_info, 0);
	BudgieHeaderExpander_private_offset = g_type_add_instance_private (budgie_header_expander_type_id, sizeof (BudgieHeaderExpanderPrivate));
	return budgie_header_expander_type_id;
}

GType
budgie_header_expander_get_type (void)
{
	static volatile gsize budgie_header_expander_type_id__once = 0;
	if (g_once_init_enter (&budgie_header_expander_type_id__once)) {
		GType budgie_header_expander_type_id;
		budgie_header_expander_type_id = budgie_header_expander_get_type_once ();
		g_once_init_leave (&budgie_header_expander_type_id__once, budgie_header_expander_type_id);
	}
	return budgie_header_expander_type_id__once;
}

static void
_vala_budgie_header_expander_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	BudgieHeaderExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander);
	switch (property_id) {
		case BUDGIE_HEADER_EXPANDER_EXPANDED_PROPERTY:
		g_value_set_boolean (value, budgie_header_expander_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_header_expander_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	BudgieHeaderExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander);
	switch (property_id) {
		case BUDGIE_HEADER_EXPANDER_EXPANDED_PROPERTY:
		budgie_header_expander_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_header_widget_get_instance_private (BudgieHeaderWidget* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieHeaderWidget_private_offset);
}

static void
__lambda4_ (BudgieHeaderWidget* self)
{
	g_signal_emit (self, budgie_header_widget_signals[BUDGIE_HEADER_WIDGET_CLOSED_SIGNAL], 0);
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ ((BudgieHeaderWidget*) self);
}

BudgieHeaderWidget*
budgie_header_widget_construct (GType object_type,
                                const gchar* text,
                                const gchar* icon_name,
                                gboolean can_close,
                                GtkWidget* custom_widget,
                                GtkWidget* end_widget)
{
	BudgieHeaderWidget * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkBox* _tmp8_;
	GtkImage* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkWidget* _tmp29_;
	GtkBox* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	self = (BudgieHeaderWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) self, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "raven-header");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->header_box);
	self->priv->header_box = _tmp1_;
	_tmp2_ = self->priv->header_box;
	g_object_set ((GtkWidget*) _tmp2_, "margin", 3, NULL);
	_tmp3_ = self->priv->header_box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp4_;
	_tmp5_ = self->priv->image;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 8);
	_tmp7_ = self->priv->image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp7_, 8);
	_tmp8_ = self->priv->header_box;
	_tmp9_ = self->priv->image;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
	_tmp10_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp10_;
	_tmp11_ = self->priv->label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->label;
	gtk_label_set_line_wrap (_tmp12_, TRUE);
	_tmp13_ = self->priv->label;
	gtk_label_set_line_wrap_mode (_tmp13_, PANGO_WRAP_WORD);
	_tmp14_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	if (custom_widget != NULL) {
		GtkBox* _tmp15_;
		_tmp15_ = self->priv->header_box;
		gtk_box_pack_start (_tmp15_, custom_widget, TRUE, TRUE, (guint) 0);
	} else {
		GtkBox* _tmp16_;
		GtkLabel* _tmp17_;
		_tmp16_ = self->priv->header_box;
		_tmp17_ = self->priv->label;
		gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, TRUE, TRUE, (guint) 0);
	}
	if (end_widget == NULL) {
		BudgieHeaderExpander* _tmp18_;
		GtkBox* _tmp19_;
		BudgieHeaderExpander* _tmp20_;
		_tmp18_ = budgie_header_expander_new (self);
		g_object_ref_sink (_tmp18_);
		_g_object_unref0 (self->expander_btn);
		self->expander_btn = _tmp18_;
		_tmp19_ = self->priv->header_box;
		_tmp20_ = self->expander_btn;
		gtk_box_pack_end (_tmp19_, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	} else {
		GtkBox* _tmp21_;
		_tmp21_ = self->priv->header_box;
		gtk_box_pack_end (_tmp21_, end_widget, FALSE, FALSE, (guint) 0);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp22_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp22_;
	_tmp23_ = self->priv->close_button;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, "flat");
	_tmp25_ = self->priv->close_button;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "primary-control");
	_tmp27_ = self->priv->close_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp27_, TRUE);
	_tmp28_ = self->priv->close_button;
	_tmp29_ = gtk_bin_get_child ((GtkBin*) _tmp28_);
	gtk_widget_show (_tmp29_);
	_tmp30_ = self->priv->header_box;
	_tmp31_ = self->priv->close_button;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
	_tmp32_ = self->priv->close_button;
	g_signal_connect_object (_tmp32_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, self, 0);
	budgie_header_widget_set_text (self, text);
	budgie_header_widget_set_icon_name (self, icon_name);
	budgie_header_widget_set_can_close (self, can_close);
	return self;
}

BudgieHeaderWidget*
budgie_header_widget_new (const gchar* text,
                          const gchar* icon_name,
                          gboolean can_close,
                          GtkWidget* custom_widget,
                          GtkWidget* end_widget)
{
	return budgie_header_widget_construct (BUDGIE_TYPE_HEADER_WIDGET, text, icon_name, can_close, custom_widget, end_widget);
}

void
budgie_header_widget_notify_expanded_change (BudgieHeaderWidget* self,
                                             gboolean value)
{
	BudgieHeaderExpander* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->expander_btn;
	if (_tmp0_ != NULL) {
		BudgieHeaderExpander* _tmp1_;
		_tmp1_ = self->expander_btn;
		budgie_header_expander_set_expanded (_tmp1_, value);
		budgie_header_widget_set_expanded (self, value);
	}
}

const gchar*
budgie_header_widget_get_text (BudgieHeaderWidget* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	result = _tmp1_;
	return result;
}

void
budgie_header_widget_set_text (BudgieHeaderWidget* self,
                               const gchar* value)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	t = _tmp0_;
	_tmp1_ = t;
	if (_tmp1_ != NULL) {
		GtkLabel* _tmp2_;
		GtkLabel* _tmp3_;
		_tmp2_ = self->priv->label;
		gtk_label_set_label (_tmp2_, value);
		_tmp3_ = self->priv->label;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		GtkLabel* _tmp4_;
		_tmp4_ = self->priv->label;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	}
	_g_free0 (t);
	g_object_notify_by_pspec ((GObject *) self, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_TEXT_PROPERTY]);
}

gchar*
budgie_header_widget_get_icon_name (BudgieHeaderWidget* self)
{
	gchar* result;
	GtkImage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->image;
	g_object_get (_tmp0_, "icon-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
budgie_header_widget_set_icon_name (BudgieHeaderWidget* self,
                                    const gchar* value)
{
	gchar* iname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	iname = _tmp0_;
	_tmp1_ = iname;
	if (_tmp1_ == NULL) {
		GtkImage* _tmp2_;
		GtkLabel* _tmp3_;
		_tmp2_ = self->priv->image;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 8);
	} else {
		GtkImage* _tmp4_;
		const gchar* _tmp5_;
		GtkImage* _tmp6_;
		GtkLabel* _tmp7_;
		_tmp4_ = self->priv->image;
		_tmp5_ = iname;
		gtk_image_set_from_icon_name (_tmp4_, _tmp5_, (GtkIconSize) GTK_ICON_SIZE_MENU);
		_tmp6_ = self->priv->image;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 0);
	}
	_g_free0 (iname);
	g_object_notify_by_pspec ((GObject *) self, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_ICON_NAME_PROPERTY]);
}

gboolean
budgie_header_widget_get_can_close (BudgieHeaderWidget* self)
{
	gboolean result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->close_button;
	result = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	return result;
}

void
budgie_header_widget_set_can_close (BudgieHeaderWidget* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->close_button;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->close_button;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	g_object_notify_by_pspec ((GObject *) self, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_CAN_CLOSE_PROPERTY]);
}

gboolean
budgie_header_widget_get_expanded (BudgieHeaderWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expanded;
	return result;
}

void
budgie_header_widget_set_expanded (BudgieHeaderWidget* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_header_widget_get_expanded (self);
	if (old_value != value) {
		self->priv->_expanded = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_EXPANDED_PROPERTY]);
	}
}

static void
budgie_header_widget_class_init (BudgieHeaderWidgetClass * klass,
                                 gpointer klass_data)
{
	budgie_header_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieHeaderWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_header_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_header_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_header_widget_finalize;
	/** Display text */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_TEXT_PROPERTY, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Icon to show, if any */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_ICON_NAME_PROPERTY, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Whether this headerwidget shows a close button
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_CAN_CLOSE_PROPERTY, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_CAN_CLOSE_PROPERTY] = g_param_spec_boolean ("can-close", "can-close", "can-close", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Manage the expanded state of this expanding header widget
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_EXPANDED_PROPERTY, budgie_header_widget_properties[BUDGIE_HEADER_WIDGET_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Emitted when this widget has been closed
	*/
	budgie_header_widget_signals[BUDGIE_HEADER_WIDGET_CLOSED_SIGNAL] = g_signal_new ("closed", BUDGIE_TYPE_HEADER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_header_widget_instance_init (BudgieHeaderWidget * self,
                                    gpointer klass)
{
	self->priv = budgie_header_widget_get_instance_private (self);
	self->priv->image = NULL;
	self->priv->label = NULL;
	self->priv->close_button = NULL;
	self->priv->header_box = NULL;
	self->expander_btn = NULL;
}

static void
budgie_header_widget_finalize (GObject * obj)
{
	BudgieHeaderWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->header_box);
	_g_object_unref0 (self->expander_btn);
	G_OBJECT_CLASS (budgie_header_widget_parent_class)->finalize (obj);
}

/**
* Headered expander widget for use in groups within the Raven UI
*/
static GType
budgie_header_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieHeaderWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_header_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieHeaderWidget), 0, (GInstanceInitFunc) budgie_header_widget_instance_init, NULL };
	GType budgie_header_widget_type_id;
	budgie_header_widget_type_id = g_type_register_static (gtk_box_get_type (), "BudgieHeaderWidget", &g_define_type_info, 0);
	BudgieHeaderWidget_private_offset = g_type_add_instance_private (budgie_header_widget_type_id, sizeof (BudgieHeaderWidgetPrivate));
	return budgie_header_widget_type_id;
}

GType
budgie_header_widget_get_type (void)
{
	static volatile gsize budgie_header_widget_type_id__once = 0;
	if (g_once_init_enter (&budgie_header_widget_type_id__once)) {
		GType budgie_header_widget_type_id;
		budgie_header_widget_type_id = budgie_header_widget_get_type_once ();
		g_once_init_leave (&budgie_header_widget_type_id__once, budgie_header_widget_type_id);
	}
	return budgie_header_widget_type_id__once;
}

static void
_vala_budgie_header_widget_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BudgieHeaderWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget);
	switch (property_id) {
		case BUDGIE_HEADER_WIDGET_TEXT_PROPERTY:
		g_value_set_string (value, budgie_header_widget_get_text (self));
		break;
		case BUDGIE_HEADER_WIDGET_ICON_NAME_PROPERTY:
		g_value_take_string (value, budgie_header_widget_get_icon_name (self));
		break;
		case BUDGIE_HEADER_WIDGET_CAN_CLOSE_PROPERTY:
		g_value_set_boolean (value, budgie_header_widget_get_can_close (self));
		break;
		case BUDGIE_HEADER_WIDGET_EXPANDED_PROPERTY:
		g_value_set_boolean (value, budgie_header_widget_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_header_widget_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BudgieHeaderWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget);
	switch (property_id) {
		case BUDGIE_HEADER_WIDGET_TEXT_PROPERTY:
		budgie_header_widget_set_text (self, g_value_get_string (value));
		break;
		case BUDGIE_HEADER_WIDGET_ICON_NAME_PROPERTY:
		budgie_header_widget_set_icon_name (self, g_value_get_string (value));
		break;
		case BUDGIE_HEADER_WIDGET_CAN_CLOSE_PROPERTY:
		budgie_header_widget_set_can_close (self, g_value_get_boolean (value));
		break;
		case BUDGIE_HEADER_WIDGET_EXPANDED_PROPERTY:
		budgie_header_widget_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_raven_expander_get_instance_private (BudgieRavenExpander* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenExpander_private_offset);
}

static void
__lambda5_ (BudgieRavenExpander* self)
{
	GtkWidget* _tmp0_;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_queue_draw (_tmp0_);
	self->priv->track_animations = FALSE;
}

static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda5_ ((BudgieRavenExpander*) self);
}

static void
__lambda6_ (BudgieRavenExpander* self)
{
	self->priv->track_animations = TRUE;
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((BudgieRavenExpander*) self);
}

static void
_budgie_raven_expander_after_paint_gdk_frame_clock_after_paint (GdkFrameClock* _sender,
                                                                gpointer self)
{
	budgie_raven_expander_after_paint ((BudgieRavenExpander*) self, _sender);
}

static void
__lambda7_ (BudgieRavenExpander* self)
{
	GdkFrameClock* clock = NULL;
	GtkRevealer* _tmp0_;
	GdkFrameClock* _tmp1_;
	GdkFrameClock* _tmp2_;
	_tmp0_ = self->content;
	_tmp1_ = gtk_widget_get_frame_clock ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clock = _tmp2_;
	g_signal_connect_object (clock, "after-paint", (GCallback) _budgie_raven_expander_after_paint_gdk_frame_clock_after_paint, self, 0);
	_g_object_unref0 (clock);
}

static void
___lambda7__gtk_widget_map (GtkWidget* _sender,
                            gpointer self)
{
	__lambda7_ ((BudgieRavenExpander*) self);
}

BudgieRavenExpander*
budgie_raven_expander_construct (GType object_type,
                                 BudgieHeaderWidget* header)
{
	BudgieRavenExpander * self = NULL;
	BudgieHeaderWidget* _tmp0_;
	BudgieHeaderWidget* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkRevealer* _tmp3_;
	BudgieHeaderWidget* _tmp4_;
	GtkRevealer* _tmp5_;
	GtkRevealer* _tmp6_;
	GtkRevealer* _tmp7_;
	self = (BudgieRavenExpander*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "margin-top", 8, NULL);
	_tmp0_ = _g_object_ref0 (header);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp0_;
	_tmp1_ = self->priv->header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 0);
	_tmp2_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->content);
	self->content = _tmp2_;
	_tmp3_ = self->content;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = self->priv->header;
	g_object_bind_property_with_closures ((GObject*) _tmp4_, "expanded", (GObject*) self, "expanded", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->content;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::child-revealed", (GCallback) ___lambda5__g_object_notify, self, G_CONNECT_AFTER);
	_tmp6_ = self->content;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::reveal-child", (GCallback) ___lambda6__g_object_notify, self, 0);
	_tmp7_ = self->content;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "map", (GCallback) ___lambda7__gtk_widget_map, self, G_CONNECT_AFTER);
	return self;
}

BudgieRavenExpander*
budgie_raven_expander_new (BudgieHeaderWidget* header)
{
	return budgie_raven_expander_construct (BUDGIE_TYPE_RAVEN_EXPANDER, header);
}

/**
* Repaint to address limitations in drawing model whereby animations
* cause artifacts in the revealer animation
*/
static void
budgie_raven_expander_after_paint (BudgieRavenExpander* self,
                                   GdkFrameClock* clock)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	if (!self->priv->track_animations) {
		return;
	}
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_queue_draw (_tmp0_);
}

static void
budgie_raven_expander_real_add (GtkContainer* base,
                                GtkWidget* widget)
{
	BudgieRavenExpander * self;
	GtkRevealer* _tmp0_;
	self = (BudgieRavenExpander*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->content;
	gtk_container_add ((GtkContainer*) _tmp0_, widget);
}

gboolean
budgie_raven_expander_get_expanded (BudgieRavenExpander* self)
{
	gboolean result;
	GtkRevealer* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->content;
	result = gtk_revealer_get_reveal_child (_tmp0_);
	return result;
}

void
budgie_raven_expander_set_expanded (BudgieRavenExpander* self,
                                    gboolean value)
{
	GtkRevealer* _tmp0_;
	BudgieHeaderWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->content;
	gtk_revealer_set_reveal_child (_tmp0_, value);
	_tmp1_ = self->priv->header;
	budgie_header_widget_notify_expanded_change (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, budgie_raven_expander_properties[BUDGIE_RAVEN_EXPANDER_EXPANDED_PROPERTY]);
}

static void
budgie_raven_expander_class_init (BudgieRavenExpanderClass * klass,
                                  gpointer klass_data)
{
	budgie_raven_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRavenExpander_private_offset);
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer*, GtkWidget*)) budgie_raven_expander_real_add;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_raven_expander_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_raven_expander_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_raven_expander_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_RAVEN_EXPANDER_EXPANDED_PROPERTY, budgie_raven_expander_properties[BUDGIE_RAVEN_EXPANDER_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_raven_expander_instance_init (BudgieRavenExpander * self,
                                     gpointer klass)
{
	self->priv = budgie_raven_expander_get_instance_private (self);
	self->priv->header = NULL;
	self->priv->track_animations = FALSE;
}

static void
budgie_raven_expander_finalize (GObject * obj)
{
	BudgieRavenExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander);
	_g_object_unref0 (self->content);
	_g_object_unref0 (self->priv->header);
	G_OBJECT_CLASS (budgie_raven_expander_parent_class)->finalize (obj);
}

/**
* Simplify use of the header and expansion logic by rolling them both
* into a custom widget
*/
static GType
budgie_raven_expander_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenExpander), 0, (GInstanceInitFunc) budgie_raven_expander_instance_init, NULL };
	GType budgie_raven_expander_type_id;
	budgie_raven_expander_type_id = g_type_register_static (gtk_box_get_type (), "BudgieRavenExpander", &g_define_type_info, 0);
	BudgieRavenExpander_private_offset = g_type_add_instance_private (budgie_raven_expander_type_id, sizeof (BudgieRavenExpanderPrivate));
	return budgie_raven_expander_type_id;
}

GType
budgie_raven_expander_get_type (void)
{
	static volatile gsize budgie_raven_expander_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_expander_type_id__once)) {
		GType budgie_raven_expander_type_id;
		budgie_raven_expander_type_id = budgie_raven_expander_get_type_once ();
		g_once_init_leave (&budgie_raven_expander_type_id__once, budgie_raven_expander_type_id);
	}
	return budgie_raven_expander_type_id__once;
}

static void
_vala_budgie_raven_expander_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BudgieRavenExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander);
	switch (property_id) {
		case BUDGIE_RAVEN_EXPANDER_EXPANDED_PROPERTY:
		g_value_set_boolean (value, budgie_raven_expander_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_raven_expander_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BudgieRavenExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander);
	switch (property_id) {
		case BUDGIE_RAVEN_EXPANDER_EXPANDED_PROPERTY:
		budgie_raven_expander_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

