# This file has been autogenerated by the pywayland scanner

# Copyright © 2012, 2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlOutput


class ZwpInputPanelSurfaceV1(Interface):
    name = "zwp_input_panel_surface_v1"
    version = 1

    class position(enum.IntEnum):
        center_bottom = 0


class ZwpInputPanelSurfaceV1Proxy(Proxy[ZwpInputPanelSurfaceV1]):
    interface = ZwpInputPanelSurfaceV1

    @ZwpInputPanelSurfaceV1.request(
        Argument(ArgumentType.Object, interface=WlOutput),
        Argument(ArgumentType.Uint),
    )
    def set_toplevel(self, output: WlOutput, position: int) -> None:
        """Set the surface type as a keyboard

        Set the input_panel_surface type to keyboard.

        A keyboard surface is only shown when a text input is active.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        :param position:
        :type position:
            `ArgumentType.Uint`
        """
        self._marshal(0, output, position)

    @ZwpInputPanelSurfaceV1.request()
    def set_overlay_panel(self) -> None:
        """Set the surface type as an overlay panel

        Set the input_panel_surface to be an overlay panel.

        This is shown near the input cursor above the application window when a
        text input is active.
        """
        self._marshal(1)


class ZwpInputPanelSurfaceV1Resource(Resource):
    interface = ZwpInputPanelSurfaceV1


class ZwpInputPanelSurfaceV1Global(Global):
    interface = ZwpInputPanelSurfaceV1


ZwpInputPanelSurfaceV1._gen_c()
ZwpInputPanelSurfaceV1.proxy_class = ZwpInputPanelSurfaceV1Proxy
ZwpInputPanelSurfaceV1.resource_class = ZwpInputPanelSurfaceV1Resource
ZwpInputPanelSurfaceV1.global_class = ZwpInputPanelSurfaceV1Global
