/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "DrawingArea.h"

#if PLATFORM(COCOA)
#include "ArgumentCoders.h"
#endif
#if PLATFORM(COCOA)
#include "CallbackID.h"
#endif
#include "Decoder.h"
#include "DrawingAreaMessages.h"
#include "HandleMessage.h"
#if PLATFORM(COCOA) || PLATFORM(COCOA) || PLATFORM(GTK) || USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER) || USE(GRAPHICS_LAYER_WC)
#include "WebCoreArgumentCoders.h"
#endif
#if PLATFORM(COCOA)
#include <WebCore/ColorSpace.h>
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
#include <WebCore/FloatPoint.h>
#endif
#if PLATFORM(COCOA)
#include <WebCore/FloatRect.h>
#endif
#if PLATFORM(COCOA) || USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER) || USE(GRAPHICS_LAYER_WC)
#include <WebCore/IntSize.h>
#endif
#if PLATFORM(COCOA)
#include <optional>
#endif
#if PLATFORM(COCOA)
#include <wtf/MachSendRight.h>
#endif
#if PLATFORM(COCOA)
#include <wtf/MonotonicTime.h>
#endif
#if PLATFORM(COCOA)
#include <wtf/text/WTFString.h>
#endif

namespace WebKit {

void DrawingArea::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (decoder.messageName() == Messages::DrawingArea::UpdateBackingStoreState::name())
        return IPC::handleMessage<Messages::DrawingArea::UpdateBackingStoreState>(connection, decoder, this, &DrawingArea::updateBackingStoreState);
#endif
    if (decoder.messageName() == Messages::DrawingArea::DidUpdate::name())
        return IPC::handleMessage<Messages::DrawingArea::DidUpdate>(connection, decoder, this, &DrawingArea::didUpdate);
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::UpdateGeometry::name())
        return IPC::handleMessage<Messages::DrawingArea::UpdateGeometry>(connection, decoder, this, &DrawingArea::updateGeometry);
#endif
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::SetDeviceScaleFactor::name())
        return IPC::handleMessage<Messages::DrawingArea::SetDeviceScaleFactor>(connection, decoder, this, &DrawingArea::setDeviceScaleFactor);
#endif
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::SetColorSpace::name())
        return IPC::handleMessage<Messages::DrawingArea::SetColorSpace>(connection, decoder, this, &DrawingArea::setColorSpace);
#endif
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::SetViewExposedRect::name())
        return IPC::handleMessage<Messages::DrawingArea::SetViewExposedRect>(connection, decoder, this, &DrawingArea::setViewExposedRect);
#endif
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::AcceleratedAnimationDidStart::name())
        return IPC::handleMessage<Messages::DrawingArea::AcceleratedAnimationDidStart>(connection, decoder, this, &DrawingArea::acceleratedAnimationDidStart);
#endif
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::AcceleratedAnimationDidEnd::name())
        return IPC::handleMessage<Messages::DrawingArea::AcceleratedAnimationDidEnd>(connection, decoder, this, &DrawingArea::acceleratedAnimationDidEnd);
#endif
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingArea::AddTransactionCallbackID::name())
        return IPC::handleMessage<Messages::DrawingArea::AddTransactionCallbackID>(connection, decoder, this, &DrawingArea::addTransactionCallbackID);
#endif
#if USE(GRAPHICS_LAYER_WC)
    if (decoder.messageName() == Messages::DrawingArea::UpdateGeometry::name())
        return IPC::handleMessage<Messages::DrawingArea::UpdateGeometry>(connection, decoder, this, &DrawingArea::updateGeometry);
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    if (decoder.messageName() == Messages::DrawingArea::AdjustTransientZoom::name())
        return IPC::handleMessage<Messages::DrawingArea::AdjustTransientZoom>(connection, decoder, this, &DrawingArea::adjustTransientZoom);
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    if (decoder.messageName() == Messages::DrawingArea::CommitTransientZoom::name())
        return IPC::handleMessage<Messages::DrawingArea::CommitTransientZoom>(connection, decoder, this, &DrawingArea::commitTransientZoom);
#endif
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit
