/* CaffeineWindow.c generated by valac 0.56.2, the Vala compiler
 * generated from CaffeineWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2018-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "caffeineapplet.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

enum  {
	CAFFEINE_CAFFEINE_WINDOW_0_PROPERTY,
	CAFFEINE_CAFFEINE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* caffeine_caffeine_window_properties[CAFFEINE_CAFFEINE_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CaffeineCaffeineWindowPrivate {
	GtkSwitch* mode;
	GtkSpinButton* timer;
	gulong mode_id;
	gulong timer_id;
	GSettings* settings;
};

static gint CaffeineCaffeineWindow_private_offset;
static gpointer caffeine_caffeine_window_parent_class = NULL;
static GType caffeine_caffeine_window_type_id = 0;

static void __lambda4_ (CaffeineCaffeineWindow* self);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda5_ (CaffeineCaffeineWindow* self);
static void ___lambda5__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda6_ (CaffeineCaffeineWindow* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void _caffeine_caffeine_window_update_timer_value_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                                 gpointer self);
static void caffeine_caffeine_window_finalize (GObject * obj);

static inline gpointer
caffeine_caffeine_window_get_instance_private (CaffeineCaffeineWindow* self)
{
	return G_STRUCT_MEMBER_P (self, CaffeineCaffeineWindow_private_offset);
}

static void
__lambda4_ (CaffeineCaffeineWindow* self)
{
	caffeine_caffeine_window_update_ux_state (self);
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda4_ ((CaffeineCaffeineWindow*) self);
}

static void
__lambda5_ (CaffeineCaffeineWindow* self)
{
	GtkSpinButton* _tmp0_;
	GtkSpinButton* _tmp1_;
	_tmp0_ = self->priv->timer;
	g_signal_handler_block (_tmp0_, self->priv->timer_id);
	caffeine_caffeine_window_update_ux_state (self);
	_tmp1_ = self->priv->timer;
	g_signal_handler_unblock (_tmp1_, self->priv->timer_id);
}

static void
___lambda5__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda5_ ((CaffeineCaffeineWindow*) self);
}

static void
__lambda6_ (CaffeineCaffeineWindow* self)
{
	GtkSwitch* _tmp0_;
	GtkSpinButton* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GSettings* _tmp5_;
	GtkSwitch* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GtkSwitch* _tmp9_;
	_tmp0_ = self->priv->mode;
	g_signal_handler_block (_tmp0_, self->priv->mode_id);
	_tmp1_ = self->priv->timer;
	_tmp2_ = self->priv->mode;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->mode;
	_tmp7_ = gtk_switch_get_active (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_boolean (_tmp5_, "caffeine-mode", _tmp8_);
	_tmp9_ = self->priv->mode;
	g_signal_handler_unblock (_tmp9_, self->priv->mode_id);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((CaffeineCaffeineWindow*) self);
}

static void
_caffeine_caffeine_window_update_timer_value_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                            gpointer self)
{
	caffeine_caffeine_window_update_timer_value ((CaffeineCaffeineWindow*) self);
}

CaffeineCaffeineWindow*
caffeine_caffeine_window_construct (GType object_type,
                                    GtkWidget* c_parent,
                                    GSettings* c_settings)
{
	CaffeineCaffeineWindow * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkBox* container = NULL;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp3_;
	GtkLabel* caffeine_mode_label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* timer_label = NULL;
	GtkLabel* _tmp5_;
	GtkSwitch* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp8_;
	GtkSpinButton* _tmp9_;
	GtkSpinButton* _tmp10_;
	GtkSwitch* _tmp11_;
	GtkSpinButton* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GtkSwitch* _tmp15_;
	gulong _tmp16_;
	GtkSpinButton* _tmp17_;
	gulong _tmp18_;
	self = (CaffeineCaffeineWindow*) g_object_new (object_type, "relative-to", c_parent, NULL);
	self->priv->settings = c_settings;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "caffeine-popover");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	container = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) container);
	gtk_style_context_add_class (_tmp2_, "container");
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	grid = _tmp3_;
	gtk_grid_set_row_spacing (grid, (guint) 6);
	gtk_grid_set_column_spacing (grid, (guint) 12);
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Caffeine Mode"));
	g_object_ref_sink (_tmp4_);
	caffeine_mode_label = _tmp4_;
	gtk_widget_set_halign ((GtkWidget*) caffeine_mode_label, GTK_ALIGN_START);
	_tmp5_ = (GtkLabel*) gtk_label_new (_ ("Timer (minutes)"));
	g_object_ref_sink (_tmp5_);
	timer_label = _tmp5_;
	gtk_widget_set_halign ((GtkWidget*) timer_label, GTK_ALIGN_START);
	_tmp6_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->mode);
	self->priv->mode = _tmp6_;
	_tmp7_ = self->priv->mode;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_END);
	_tmp8_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 1440, (gdouble) 1, (gdouble) 10, (gdouble) 0);
	g_object_ref_sink (_tmp8_);
	adjustment = _tmp8_;
	_tmp9_ = (GtkSpinButton*) gtk_spin_button_new (adjustment, (gdouble) 0, (guint) 0);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->timer);
	self->priv->timer = _tmp9_;
	_tmp10_ = self->priv->timer;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_END);
	gtk_grid_attach (grid, (GtkWidget*) caffeine_mode_label, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) timer_label, 0, 1, 1, 1);
	_tmp11_ = self->priv->mode;
	gtk_grid_attach (grid, (GtkWidget*) _tmp11_, 1, 0, 1, 1);
	_tmp12_ = self->priv->timer;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 1, 1, 1, 1);
	gtk_container_add ((GtkContainer*) container, (GtkWidget*) grid);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) container);
	caffeine_caffeine_window_update_ux_state (self);
	_tmp13_ = self->priv->settings;
	g_signal_connect_object (_tmp13_, "changed::caffeine-mode", (GCallback) ___lambda4__g_settings_changed, self, 0);
	_tmp14_ = self->priv->settings;
	g_signal_connect_object (_tmp14_, "changed::caffeine-mode-timer", (GCallback) ___lambda5__g_settings_changed, self, 0);
	_tmp15_ = self->priv->mode;
	_tmp16_ = g_signal_connect_object ((GObject*) _tmp15_, "notify::active", (GCallback) ___lambda6__g_object_notify, self, 0);
	self->priv->mode_id = _tmp16_;
	_tmp17_ = self->priv->timer;
	_tmp18_ = g_signal_connect_object (_tmp17_, "value-changed", (GCallback) _caffeine_caffeine_window_update_timer_value_gtk_spin_button_value_changed, self, 0);
	self->priv->timer_id = _tmp18_;
	_g_object_unref0 (adjustment);
	_g_object_unref0 (timer_label);
	_g_object_unref0 (caffeine_mode_label);
	_g_object_unref0 (grid);
	_g_object_unref0 (container);
	return self;
}

CaffeineCaffeineWindow*
caffeine_caffeine_window_new (GtkWidget* c_parent,
                              GSettings* c_settings)
{
	return caffeine_caffeine_window_construct (CAFFEINE_TYPE_CAFFEINE_WINDOW, c_parent, c_settings);
}

/**
* update_ux_state will set our switch active state to the current Caffeine Mode value and toggle timer
*/
void
caffeine_caffeine_window_update_ux_state (CaffeineCaffeineWindow* self)
{
	GtkSwitch* _tmp0_;
	GSettings* _tmp1_;
	GtkSpinButton* _tmp2_;
	GtkSwitch* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkSpinButton* _tmp6_;
	GSettings* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	_tmp1_ = self->priv->settings;
	gtk_switch_set_active (_tmp0_, g_settings_get_boolean (_tmp1_, "caffeine-mode"));
	_tmp2_ = self->priv->timer;
	_tmp3_ = self->priv->mode;
	_tmp4_ = gtk_switch_get_active (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, !_tmp5_);
	_tmp6_ = self->priv->timer;
	_tmp7_ = self->priv->settings;
	gtk_spin_button_set_value (_tmp6_, (gdouble) g_settings_get_int (_tmp7_, "caffeine-mode-timer"));
}

void
caffeine_caffeine_window_toggle_applet (CaffeineCaffeineWindow* self)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	_tmp1_ = self->priv->mode;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_switch_set_active (_tmp0_, !_tmp3_);
}

/**
* update_timer_value will update our settings timer value based on our SpinButton change
*/
void
caffeine_caffeine_window_update_timer_value (CaffeineCaffeineWindow* self)
{
	gint time = 0;
	GtkSpinButton* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	time = gtk_spin_button_get_value_as_int (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "caffeine-mode-timer", time);
}

static void
caffeine_caffeine_window_class_init (CaffeineCaffeineWindowClass * klass,
                                     gpointer klass_data)
{
	caffeine_caffeine_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CaffeineCaffeineWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = caffeine_caffeine_window_finalize;
}

static void
caffeine_caffeine_window_instance_init (CaffeineCaffeineWindow * self,
                                        gpointer klass)
{
	self->priv = caffeine_caffeine_window_get_instance_private (self);
	self->priv->mode = NULL;
	self->priv->timer = NULL;
}

static void
caffeine_caffeine_window_finalize (GObject * obj)
{
	CaffeineCaffeineWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAFFEINE_TYPE_CAFFEINE_WINDOW, CaffeineCaffeineWindow);
	_g_object_unref0 (self->priv->mode);
	_g_object_unref0 (self->priv->timer);
	G_OBJECT_CLASS (caffeine_caffeine_window_parent_class)->finalize (obj);
}

GType
caffeine_caffeine_window_get_type (void)
{
	return caffeine_caffeine_window_type_id;
}

GType
caffeine_caffeine_window_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaffeineCaffeineWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) caffeine_caffeine_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaffeineCaffeineWindow), 0, (GInstanceInitFunc) caffeine_caffeine_window_instance_init, NULL };
	caffeine_caffeine_window_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "CaffeineCaffeineWindow", &g_define_type_info, 0);
	CaffeineCaffeineWindow_private_offset = sizeof (CaffeineCaffeineWindowPrivate);
	return caffeine_caffeine_window_type_id;
}

