/* manager.c generated by valac 0.56.2, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2016-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <theme-manager.h>
#include "session.h"
#include <gio/gio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SERVICE_MANAGER (budgie_service_manager_get_type ())
#define BUDGIE_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager))
#define BUDGIE_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))
#define BUDGIE_IS_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_IS_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))

typedef struct _BudgieServiceManager BudgieServiceManager;
typedef struct _BudgieServiceManagerClass BudgieServiceManagerClass;
typedef struct _BudgieServiceManagerPrivate BudgieServiceManagerPrivate;

#define BUDGIE_TYPE_OSD_MANAGER (budgie_osd_manager_get_type ())
#define BUDGIE_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager))
#define BUDGIE_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))
#define BUDGIE_IS_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_IS_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_OSD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))

typedef struct _BudgieOSDManager BudgieOSDManager;
typedef struct _BudgieOSDManagerClass BudgieOSDManagerClass;

#define BUDGIE_NOTIFICATIONS_TYPE_SERVER (budgie_notifications_server_get_type ())
#define BUDGIE_NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer))
#define BUDGIE_NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))
#define BUDGIE_NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))

typedef struct _BudgieNotificationsServer BudgieNotificationsServer;
typedef struct _BudgieNotificationsServerClass BudgieNotificationsServerClass;

#define BUDGIE_TYPE_MENU_MANAGER (budgie_menu_manager_get_type ())
#define BUDGIE_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManager))
#define BUDGIE_MENU_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManagerClass))
#define BUDGIE_IS_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_MENU_MANAGER))
#define BUDGIE_IS_MENU_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_MENU_MANAGER))
#define BUDGIE_MENU_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManagerClass))

typedef struct _BudgieMenuManager BudgieMenuManager;
typedef struct _BudgieMenuManagerClass BudgieMenuManagerClass;

#define BUDGIE_TYPE_TAB_SWITCHER (budgie_tab_switcher_get_type ())
#define BUDGIE_TAB_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcher))
#define BUDGIE_TAB_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcherClass))
#define BUDGIE_IS_TAB_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER))
#define BUDGIE_IS_TAB_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER))
#define BUDGIE_TAB_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcherClass))

typedef struct _BudgieTabSwitcher BudgieTabSwitcher;
typedef struct _BudgieTabSwitcherClass BudgieTabSwitcherClass;
enum  {
	BUDGIE_SERVICE_MANAGER_0_PROPERTY,
	BUDGIE_SERVICE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_service_manager_properties[BUDGIE_SERVICE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _budgie_osd_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_osd_manager_unref (var), NULL)))
#define _budgie_menu_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_menu_manager_unref (var), NULL)))
typedef struct _BudgieServiceManagerRegisterWithSessionData BudgieServiceManagerRegisterWithSessionData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieServiceManager {
	GObject parent_instance;
	BudgieServiceManagerPrivate * priv;
};

struct _BudgieServiceManagerClass {
	GObjectClass parent_class;
};

struct _BudgieServiceManagerPrivate {
	BudgieThemeManager* theme_manager;
	LibSessionSessionClient* sclient;
	BudgieOSDManager* osd;
	BudgieNotificationsServer* notifications;
	BudgieMenuManager* menus;
	BudgieTabSwitcher* switcher;
};

struct _BudgieServiceManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieServiceManager* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	LibSessionSessionClient* _tmp4_;
};

static gint BudgieServiceManager_private_offset;
static gpointer budgie_service_manager_parent_class = NULL;

VALA_EXTERN GType budgie_service_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieServiceManager, g_object_unref)
VALA_EXTERN gpointer budgie_osd_manager_ref (gpointer instance);
VALA_EXTERN void budgie_osd_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_osd_manager (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void budgie_value_set_osd_manager (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void budgie_value_take_osd_manager (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_osd_manager (const GValue* value);
VALA_EXTERN GType budgie_osd_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDManager, budgie_osd_manager_unref)
VALA_EXTERN guint budgie_osd_manager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType budgie_notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsServer, g_object_unref)
VALA_EXTERN guint budgie_notifications_server_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN gpointer budgie_menu_manager_ref (gpointer instance);
VALA_EXTERN void budgie_menu_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_menu_manager (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void budgie_value_set_menu_manager (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void budgie_value_take_menu_manager (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_menu_manager (const GValue* value);
VALA_EXTERN GType budgie_menu_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieMenuManager, budgie_menu_manager_unref)
VALA_EXTERN guint budgie_menu_manager_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType budgie_tab_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcher, g_object_unref)
VALA_EXTERN guint budgie_tab_switcher_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_new (gboolean replace);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_construct (GType object_type,
                                                        gboolean replace);
static void budgie_service_manager_register_with_session (BudgieServiceManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean budgie_service_manager_register_with_session_finish (BudgieServiceManager* self,
                                                              GAsyncResult* _res_);
static void __lambda25_ (BudgieServiceManager* self,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda25__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_new (void);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_construct (GType object_type);
VALA_EXTERN void budgie_osd_manager_setup_dbus (BudgieOSDManager* self,
                                    gboolean replace);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_new (void);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_construct (GType object_type);
VALA_EXTERN BudgieMenuManager* budgie_menu_manager_new (void);
VALA_EXTERN BudgieMenuManager* budgie_menu_manager_construct (GType object_type);
VALA_EXTERN void budgie_menu_manager_setup_dbus (BudgieMenuManager* self,
                                     gboolean replace);
VALA_EXTERN BudgieTabSwitcher* budgie_tab_switcher_new (void);
VALA_EXTERN BudgieTabSwitcher* budgie_tab_switcher_construct (GType object_type);
VALA_EXTERN void budgie_tab_switcher_setup_dbus (BudgieTabSwitcher* self,
                                     gboolean replace);
static void budgie_service_manager_register_with_session_data_free (gpointer _data);
static gboolean budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_);
static void budgie_service_manager_register_with_session_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void __lambda22_ (BudgieServiceManager* self);
static void budgie_service_manager_end_session (BudgieServiceManager* self,
                                         gboolean quit);
static void ___lambda22__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                                guint flags,
                                                                gpointer self);
static void __lambda23_ (BudgieServiceManager* self);
static void ___lambda23__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                          guint flags,
                                                          gpointer self);
static void __lambda24_ (BudgieServiceManager* self);
static void ___lambda24__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                                   gpointer self);
static void budgie_service_manager_finalize (GObject * obj);
static GType budgie_service_manager_get_type_once (void);

static inline gpointer
budgie_service_manager_get_instance_private (BudgieServiceManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieServiceManager_private_offset);
}

/**
* Construct a new ServiceManager and initialiase appropriately
*/
static void
__lambda25_ (BudgieServiceManager* self,
             GObject* o,
             GAsyncResult* res)
{
	gboolean success = FALSE;
	g_return_if_fail (res != NULL);
	success = budgie_service_manager_register_with_session_finish (self, res);
	if (!success) {
		g_message ("manager.vala:35: Failed to register with Session manager");
	}
}

static void
___lambda25__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda25_ ((BudgieServiceManager*) self, source_object, res);
	g_object_unref (self);
}

BudgieServiceManager*
budgie_service_manager_construct (GType object_type,
                                  gboolean replace)
{
	BudgieServiceManager * self = NULL;
	BudgieThemeManager* _tmp0_;
	BudgieOSDManager* _tmp1_;
	BudgieOSDManager* _tmp2_;
	BudgieNotificationsServer* _tmp3_;
	BudgieMenuManager* _tmp4_;
	BudgieMenuManager* _tmp5_;
	BudgieTabSwitcher* _tmp6_;
	BudgieTabSwitcher* _tmp7_;
	self = (BudgieServiceManager*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp0_;
	budgie_service_manager_register_with_session (self, ___lambda25__gasync_ready_callback, g_object_ref (self));
	_tmp1_ = budgie_osd_manager_new ();
	_budgie_osd_manager_unref0 (self->priv->osd);
	self->priv->osd = _tmp1_;
	_tmp2_ = self->priv->osd;
	budgie_osd_manager_setup_dbus (_tmp2_, replace);
	_tmp3_ = budgie_notifications_server_new ();
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp3_;
	_tmp4_ = budgie_menu_manager_new ();
	_budgie_menu_manager_unref0 (self->priv->menus);
	self->priv->menus = _tmp4_;
	_tmp5_ = self->priv->menus;
	budgie_menu_manager_setup_dbus (_tmp5_, replace);
	_tmp6_ = budgie_tab_switcher_new ();
	_g_object_unref0 (self->priv->switcher);
	self->priv->switcher = _tmp6_;
	_tmp7_ = self->priv->switcher;
	budgie_tab_switcher_setup_dbus (_tmp7_, replace);
	return self;
}

BudgieServiceManager*
budgie_service_manager_new (gboolean replace)
{
	return budgie_service_manager_construct (BUDGIE_TYPE_SERVICE_MANAGER, replace);
}

static void
budgie_service_manager_register_with_session_data_free (gpointer _data)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieServiceManagerRegisterWithSessionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_service_manager_register_with_session (BudgieServiceManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	BudgieServiceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieServiceManagerRegisterWithSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_service_manager_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_service_manager_register_with_session_co (_data_);
}

static gboolean
budgie_service_manager_register_with_session_finish (BudgieServiceManager* self,
                                                     GAsyncResult* _res_)
{
	gboolean result;
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/**
* Attempt registration with the Session Manager
*/
static void
budgie_service_manager_register_with_session_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_service_manager_register_with_session_co (_data_);
}

static void
__lambda22_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, FALSE);
}

static void
___lambda22__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                           guint flags,
                                                           gpointer self)
{
	__lambda22_ ((BudgieServiceManager*) self);
}

static void
__lambda23_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, FALSE);
}

static void
___lambda23__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                     guint flags,
                                                     gpointer self)
{
	__lambda23_ ((BudgieServiceManager*) self);
}

static void
__lambda24_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, TRUE);
}

static void
___lambda24__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                              gpointer self)
{
	__lambda24_ ((BudgieServiceManager*) self);
}

static gboolean
budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	lib_session_register_with_session ("budgie-daemon", budgie_service_manager_register_with_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
	_g_object_unref0 (_data_->self->priv->sclient);
	_data_->self->priv->sclient = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "query-end-session", (GCallback) ___lambda22__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "end-session", (GCallback) ___lambda23__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp4_, "stop", (GCallback) ___lambda24__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
* Properly shutdown when asked to
*/
static void
budgie_service_manager_end_session (BudgieServiceManager* self,
                                    gboolean quit)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (quit) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp0_;
		_tmp0_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp0_, TRUE, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("manager.vala:80: Unable to respond to session manager! %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_service_manager_class_init (BudgieServiceManagerClass * klass,
                                   gpointer klass_data)
{
	budgie_service_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieServiceManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_service_manager_finalize;
}

static void
budgie_service_manager_instance_init (BudgieServiceManager * self,
                                      gpointer klass)
{
	self->priv = budgie_service_manager_get_instance_private (self);
}

static void
budgie_service_manager_finalize (GObject * obj)
{
	BudgieServiceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->sclient);
	_budgie_osd_manager_unref0 (self->priv->osd);
	_g_object_unref0 (self->priv->notifications);
	_budgie_menu_manager_unref0 (self->priv->menus);
	_g_object_unref0 (self->priv->switcher);
	G_OBJECT_CLASS (budgie_service_manager_parent_class)->finalize (obj);
}

/**
* Main lifecycle management, handle all the various session and GTK+ bits
*/
static GType
budgie_service_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieServiceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_service_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieServiceManager), 0, (GInstanceInitFunc) budgie_service_manager_instance_init, NULL };
	GType budgie_service_manager_type_id;
	budgie_service_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieServiceManager", &g_define_type_info, 0);
	BudgieServiceManager_private_offset = g_type_add_instance_private (budgie_service_manager_type_id, sizeof (BudgieServiceManagerPrivate));
	return budgie_service_manager_type_id;
}

GType
budgie_service_manager_get_type (void)
{
	static volatile gsize budgie_service_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_service_manager_type_id__once)) {
		GType budgie_service_manager_type_id;
		budgie_service_manager_type_id = budgie_service_manager_get_type_once ();
		g_once_init_leave (&budgie_service_manager_type_id__once, budgie_service_manager_type_id);
	}
	return budgie_service_manager_type_id__once;
}

