/* dbus.c generated by valac 0.56.2, the Vala compiler
 * generated from dbus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2018-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "budgie-private.h"
#include <gtk/gtk.h>
#include <budgie-config.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>

#define BUDGIE_NOTIFICATIONS_NOTIFICATION_DBUS_NAME "org.budgie_desktop.Notifications"
#define BUDGIE_NOTIFICATIONS_NOTIFICATION_DBUS_OBJECT_PATH "/org/budgie_desktop/Notifications"
#define BUDGIE_NOTIFICATIONS_MINIMUM_EXPIRY ((gint32) 6000)
#define BUDGIE_NOTIFICATIONS_MAXIMUM_EXPIRY ((gint32) 12000)
#define BUDGIE_NOTIFICATIONS_SERVER_BUDGIE_PANEL_SCHEMA "com.solus-project.budgie-panel"
#define BUDGIE_NOTIFICATIONS_SERVER_APPLICATION_SCHEMA "org.gnome.desktop.notifications.application"
#define BUDGIE_NOTIFICATIONS_SERVER_APPLICATION_PREFIX "/org/gnome/desktop/notifications/application"
#define BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE 10
#define BUDGIE_NOTIFICATIONS_SERVER_INITIAL_BUFFER_ZONE 45
#define BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH 400
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER (budgie_notifications_dispatcher_get_type ())
#define BUDGIE_NOTIFICATIONS_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcher))
#define BUDGIE_NOTIFICATIONS_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcherClass))
#define BUDGIE_NOTIFICATIONS_IS_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER))
#define BUDGIE_NOTIFICATIONS_IS_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER))
#define BUDGIE_NOTIFICATIONS_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcherClass))

typedef struct _BudgieNotificationsDispatcher BudgieNotificationsDispatcher;
typedef struct _BudgieNotificationsDispatcherClass BudgieNotificationsDispatcherClass;
typedef struct _BudgieNotificationsDispatcherPrivate BudgieNotificationsDispatcherPrivate;
enum  {
	BUDGIE_NOTIFICATIONS_DISPATCHER_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATIONS_PAUSED_PROPERTY,
	BUDGIE_NOTIFICATIONS_DISPATCHER_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_dispatcher_properties[BUDGIE_NOTIFICATIONS_DISPATCHER_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_NOTIFICATIONS_DISPATCHER_DO_NOT_DISTURB_CHANGED_SIGNAL,
	BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATION_ADDED_SIGNAL,
	BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATION_CLOSED_SIGNAL,
	BUDGIE_NOTIFICATIONS_DISPATCHER_NUM_SIGNALS
};
static guint budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_NUM_SIGNALS] = {0};

#define BUDGIE_NOTIFICATIONS_TYPE_SERVER (budgie_notifications_server_get_type ())
#define BUDGIE_NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer))
#define BUDGIE_NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))
#define BUDGIE_NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))

typedef struct _BudgieNotificationsServer BudgieNotificationsServer;
typedef struct _BudgieNotificationsServerClass BudgieNotificationsServerClass;
typedef struct _BudgieNotificationsServerPrivate BudgieNotificationsServerPrivate;

#define BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE (budgie_notifications_popup_base_get_type ())
#define BUDGIE_NOTIFICATIONS_POPUP_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBase))
#define BUDGIE_NOTIFICATIONS_POPUP_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBaseClass))
#define BUDGIE_NOTIFICATIONS_IS_POPUP_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE))
#define BUDGIE_NOTIFICATIONS_IS_POPUP_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE))
#define BUDGIE_NOTIFICATIONS_POPUP_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBaseClass))

typedef struct _BudgieNotificationsPopupBase BudgieNotificationsPopupBase;
typedef struct _BudgieNotificationsPopupBaseClass BudgieNotificationsPopupBaseClass;

#define BUDGIE_NOTIFICATIONS_TYPE_POPUP (budgie_notifications_popup_get_type ())
#define BUDGIE_NOTIFICATIONS_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopup))
#define BUDGIE_NOTIFICATIONS_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopupClass))
#define BUDGIE_NOTIFICATIONS_IS_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP))
#define BUDGIE_NOTIFICATIONS_IS_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP))
#define BUDGIE_NOTIFICATIONS_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopupClass))

typedef struct _BudgieNotificationsPopup BudgieNotificationsPopup;
typedef struct _BudgieNotificationsPopupClass BudgieNotificationsPopupClass;
enum  {
	BUDGIE_NOTIFICATIONS_SERVER_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_SERVER_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_server_properties[BUDGIE_NOTIFICATIONS_SERVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
enum  {
	BUDGIE_NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL,
	BUDGIE_NOTIFICATIONS_SERVER_ACTIVATION_TOKEN_SIGNAL,
	BUDGIE_NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL,
	BUDGIE_NOTIFICATIONS_SERVER_NUM_SIGNALS
};
static guint budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_NUM_SIGNALS] = {0};

struct _BudgieNotificationsDispatcher {
	GObject parent_instance;
	BudgieNotificationsDispatcherPrivate * priv;
};

struct _BudgieNotificationsDispatcherClass {
	GObjectClass parent_class;
};

struct _BudgieNotificationsDispatcherPrivate {
	gboolean _dnd;
	gboolean _notifications_paused;
};

struct _BudgieNotificationsServer {
	GObject parent_instance;
	BudgieNotificationsServerPrivate * priv;
};

struct _BudgieNotificationsServerClass {
	GObjectClass parent_class;
};

struct _BudgieNotificationsServerPrivate {
	guint32 notif_id;
	BudgieNotificationsDispatcher* _dispatcher;
	GHashTable* popups;
	GSettings* _panel_settings;
	guint32 _latest_popup_id;
};

struct _Block1Data {
	int _ref_count_;
	BudgieNotificationsServer* self;
	guint32 id;
	gchar* app_name;
};

struct _Block2Data {
	int _ref_count_;
	BudgieNotificationsServer* self;
	GdkRectangle mon_rect;
	gulong handler_id;
	BudgieNotificationsPopup* popup;
};

static gint BudgieNotificationsDispatcher_private_offset;
static gpointer budgie_notifications_dispatcher_parent_class = NULL;
static gint BudgieNotificationsServer_private_offset;
static gpointer budgie_notifications_server_parent_class = NULL;

VALA_EXTERN GType budgie_notifications_dispatcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsDispatcher, g_object_unref)
VALA_EXTERN guint budgie_notifications_dispatcher_register_object (void* object,
                                                       GDBusConnection* connection,
                                                       const gchar* path,
                                                       GError** error);
static void budgie_notifications_dispatcher_on_dbus_acquired (BudgieNotificationsDispatcher* self,
                                                       GDBusConnection* conn);
VALA_EXTERN gboolean budgie_notifications_dispatcher_get_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                             GError** error);
static gboolean budgie_notifications_dispatcher_get_dnd (BudgieNotificationsDispatcher* self);
VALA_EXTERN void budgie_notifications_dispatcher_toggle_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                            GError** error);
static void budgie_notifications_dispatcher_set_dnd (BudgieNotificationsDispatcher* self,
                                              gboolean value);
VALA_EXTERN BudgieNotificationsDispatcher* budgie_notifications_dispatcher_new (void);
VALA_EXTERN BudgieNotificationsDispatcher* budgie_notifications_dispatcher_construct (GType object_type);
VALA_EXTERN gboolean budgie_notifications_dispatcher_get_notifications_paused (BudgieNotificationsDispatcher* self);
VALA_EXTERN void budgie_notifications_dispatcher_set_notifications_paused (BudgieNotificationsDispatcher* self,
                                                               gboolean value);
static void g_cclosure_user_marshal_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT (GClosure * closure,
                                                                                         GValue * return_value,
                                                                                         guint n_param_values,
                                                                                         const GValue * param_values,
                                                                                         gpointer invocation_hint,
                                                                                         gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_STRING_ENUM (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static GObject * budgie_notifications_dispatcher_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _budgie_notifications_dispatcher_on_dbus_acquired_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                                    const gchar* name,
                                                                                    gpointer self);
static void budgie_notifications_dispatcher_finalize (GObject * obj);
static GType budgie_notifications_dispatcher_get_type_once (void);
static void _vala_budgie_notifications_dispatcher_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_budgie_notifications_dispatcher_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _dbus_budgie_notifications_dispatcher_get_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_dispatcher_toggle_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void budgie_notifications_dispatcher_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data);
static GVariant* budgie_notifications_dispatcher_dbus_interface_get_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GError** error,
                                                                       gpointer user_data);
static GVariant* _dbus_budgie_notifications_dispatcher_get_notifications_paused (BudgieNotificationsDispatcher* self);
static gboolean budgie_notifications_dispatcher_dbus_interface_set_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GVariant* value,
                                                                      GError** error,
                                                                      gpointer user_data);
static void _dbus_budgie_notifications_dispatcher_set_notifications_paused (BudgieNotificationsDispatcher* self,
                                                                     GVariant* _value);
static void _dbus_budgie_notifications_dispatcher_do_not_disturb_changed (GObject* _sender,
                                                                   gboolean value,
                                                                   gpointer* _data);
static void _dbus_budgie_notifications_dispatcher_notification_added (GObject* _sender,
                                                               const gchar* app_name,
                                                               guint32 id,
                                                               const gchar* app_icon,
                                                               const gchar* summary,
                                                               const gchar* body,
                                                               gchar** actions,
                                                               gint actions_length1,
                                                               GHashTable* hints,
                                                               gint32 expire_timeout,
                                                               gpointer* _data);
static void _dbus_budgie_notifications_dispatcher_notification_closed (GObject* _sender,
                                                                guint32 id,
                                                                const gchar* app_name,
                                                                BudgieNotificationCloseReason reason,
                                                                gpointer* _data);
static void _budgie_notifications_dispatcher_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsServer, g_object_unref)
VALA_EXTERN guint budgie_notifications_server_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType budgie_notifications_popup_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsPopupBase, g_object_unref)
VALA_EXTERN GType budgie_notifications_popup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsPopup, g_object_unref)
static void budgie_notifications_server_on_bus_acquired (BudgieNotificationsServer* self,
                                                  GDBusConnection* conn);
VALA_EXTERN gchar** budgie_notifications_server_GetCapabilities (BudgieNotificationsServer* self,
                                                     gint* result_length1,
                                                     GError** error);
VALA_EXTERN void budgie_notifications_server_GetServerInformation (BudgieNotificationsServer* self,
                                                       gchar** name,
                                                       gchar** vendor,
                                                       gchar** version,
                                                       gchar** spec_version,
                                                       GError** error);
VALA_EXTERN guint32 budgie_notifications_server_Notify (BudgieNotificationsServer* self,
                                            const gchar* app_name,
                                            guint32 replaces_id,
                                            const gchar* app_icon,
                                            const gchar* summary,
                                            const gchar* body,
                                            gchar** actions,
                                            gint actions_length1,
                                            GHashTable* hints,
                                            gint32 expire_timeout,
                                            GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static BudgieNotificationsDispatcher* budgie_notifications_server_get_dispatcher (BudgieNotificationsServer* self);
VALA_EXTERN void budgie_notifications_popup_replace (BudgieNotificationsPopup* self,
                                         BudgieNotification* new_notif);
VALA_EXTERN BudgieNotificationsPopup* budgie_notifications_popup_new (BudgieNotificationsServer* owner,
                                                          BudgieNotification* notification);
VALA_EXTERN BudgieNotificationsPopup* budgie_notifications_popup_construct (GType object_type,
                                                                BudgieNotificationsServer* owner,
                                                                BudgieNotification* notification);
static void budgie_notifications_server_configure_window (BudgieNotificationsServer* self,
                                                   BudgieNotificationsPopup* popup);
static void budgie_notifications_server_set_latest_popup_id (BudgieNotificationsServer* self,
                                                      guint32 value);
VALA_EXTERN void budgie_notifications_popup_base_begin_decay (BudgieNotificationsPopupBase* self,
                                                  guint timeout);
static void ___lambda16_ (Block1Data* _data1_,
                   const gchar* action_key);
static void ____lambda16__budgie_notifications_popup_action_invoked (BudgieNotificationsPopup* _sender,
                                                              const gchar* action_key,
                                                              gpointer self);
static void ___lambda17_ (Block1Data* _data1_,
                   BudgieNotificationCloseReason reason);
static guint32 budgie_notifications_server_get_latest_popup_id (BudgieNotificationsServer* self);
static void ____lambda17__budgie_notifications_popup_base_closed (BudgieNotificationsPopupBase* _sender,
                                                           BudgieNotificationCloseReason reason,
                                                           gpointer self);
VALA_EXTERN void budgie_notifications_server_CloseNotification (BudgieNotificationsServer* self,
                                                    guint32 id,
                                                    GError** error);
VALA_EXTERN void budgie_notifications_popup_base_dismiss (BudgieNotificationsPopupBase* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda15_ (Block2Data* _data2_,
                  GtkAllocation* alloc);
static void budgie_notifications_server_calculate_position (BudgieNotificationsServer* self,
                                                     BudgieNotificationsPopup* window,
                                                     GdkRectangle* rect,
                                                     gint* x,
                                                     gint* y);
static void ___lambda15__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
static GSettings* budgie_notifications_server_get_panel_settings (BudgieNotificationsServer* self);
VALA_EXTERN gboolean budgie_notifications_popup_base_get_destroying (BudgieNotificationsPopupBase* self);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_new (void);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_construct (GType object_type);
static void budgie_notifications_server_set_dispatcher (BudgieNotificationsServer* self,
                                                 BudgieNotificationsDispatcher* value);
static void budgie_notifications_server_set_panel_settings (BudgieNotificationsServer* self,
                                                     GSettings* value);
static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GObject * budgie_notifications_server_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _budgie_notifications_server_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                          const gchar* name,
                                                                          gpointer self);
static void _g_object_unref0_ (gpointer var);
static void budgie_notifications_server_finalize (GObject * obj);
static GType budgie_notifications_server_get_type_once (void);
static void _vala_budgie_notifications_server_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_budgie_notifications_server_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _dbus_budgie_notifications_server_GetCapabilities (BudgieNotificationsServer* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_server_GetServerInformation (BudgieNotificationsServer* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_server_Notify (BudgieNotificationsServer* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_server_CloseNotification (BudgieNotificationsServer* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void budgie_notifications_server_dbus_interface_method_call (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* method_name,
                                                             GVariant* parameters,
                                                             GDBusMethodInvocation* invocation,
                                                             gpointer user_data);
static GVariant* budgie_notifications_server_dbus_interface_get_property (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* property_name,
                                                                   GError** error,
                                                                   gpointer user_data);
static gboolean budgie_notifications_server_dbus_interface_set_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GVariant* value,
                                                                  GError** error,
                                                                  gpointer user_data);
static void _dbus_budgie_notifications_server_action_invoked (GObject* _sender,
                                                       guint32 id,
                                                       const gchar* action_key,
                                                       gpointer* _data);
static void _dbus_budgie_notifications_server_activation_token (GObject* _sender,
                                                         guint32 id,
                                                         const gchar* activation_token,
                                                         gpointer* _data);
static void _dbus_budgie_notifications_server_notification_closed (GObject* _sender,
                                                            guint32 id,
                                                            guint32 reason,
                                                            gpointer* _data);
static void _budgie_notifications_server_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_get_do_not_disturb_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_get_do_not_disturb_in[] = {NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_get_do_not_disturb_out[] = {&_budgie_notifications_dispatcher_dbus_arg_info_get_do_not_disturb_result, NULL};
static const GDBusMethodInfo _budgie_notifications_dispatcher_dbus_method_info_get_do_not_disturb = {-1, "GetDoNotDisturb", (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_get_do_not_disturb_in), (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_get_do_not_disturb_out), NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_toggle_do_not_disturb_in[] = {NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_toggle_do_not_disturb_out[] = {NULL};
static const GDBusMethodInfo _budgie_notifications_dispatcher_dbus_method_info_toggle_do_not_disturb = {-1, "ToggleDoNotDisturb", (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_toggle_do_not_disturb_in), (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_toggle_do_not_disturb_out), NULL};
static const GDBusMethodInfo * const _budgie_notifications_dispatcher_dbus_method_info[] = {&_budgie_notifications_dispatcher_dbus_method_info_get_do_not_disturb, &_budgie_notifications_dispatcher_dbus_method_info_toggle_do_not_disturb, NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_do_not_disturb_changed_value = {-1, "value", "b", NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_do_not_disturb_changed[] = {&_budgie_notifications_dispatcher_dbus_arg_info_do_not_disturb_changed_value, NULL};
static const GDBusSignalInfo _budgie_notifications_dispatcher_dbus_signal_info_do_not_disturb_changed = {-1, "DoNotDisturbChanged", (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_do_not_disturb_changed), NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_app_icon = {-1, "app_icon", "s", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_summary = {-1, "summary", "s", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_body = {-1, "body", "s", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_actions = {-1, "actions", "as", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_hints = {-1, "hints", "a{sv}", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_added_expire_timeout = {-1, "expire_timeout", "i", NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_notification_added[] = {&_budgie_notifications_dispatcher_dbus_arg_info_notification_added_app_name, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_id, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_app_icon, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_summary, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_body, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_actions, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_hints, &_budgie_notifications_dispatcher_dbus_arg_info_notification_added_expire_timeout, NULL};
static const GDBusSignalInfo _budgie_notifications_dispatcher_dbus_signal_info_notification_added = {-1, "NotificationAdded", (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_notification_added), NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_closed_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_closed_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _budgie_notifications_dispatcher_dbus_arg_info_notification_closed_reason = {-1, "reason", "i", NULL};
static const GDBusArgInfo * const _budgie_notifications_dispatcher_dbus_arg_info_notification_closed[] = {&_budgie_notifications_dispatcher_dbus_arg_info_notification_closed_id, &_budgie_notifications_dispatcher_dbus_arg_info_notification_closed_app_name, &_budgie_notifications_dispatcher_dbus_arg_info_notification_closed_reason, NULL};
static const GDBusSignalInfo _budgie_notifications_dispatcher_dbus_signal_info_notification_closed = {-1, "NotificationClosed", (GDBusArgInfo **) (&_budgie_notifications_dispatcher_dbus_arg_info_notification_closed), NULL};
static const GDBusSignalInfo * const _budgie_notifications_dispatcher_dbus_signal_info[] = {&_budgie_notifications_dispatcher_dbus_signal_info_do_not_disturb_changed, &_budgie_notifications_dispatcher_dbus_signal_info_notification_added, &_budgie_notifications_dispatcher_dbus_signal_info_notification_closed, NULL};
static const GDBusPropertyInfo _budgie_notifications_dispatcher_dbus_property_info_notifications_paused = {-1, "NotificationsPaused", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _budgie_notifications_dispatcher_dbus_property_info[] = {&_budgie_notifications_dispatcher_dbus_property_info_notifications_paused, NULL};
static const GDBusInterfaceInfo _budgie_notifications_dispatcher_dbus_interface_info = {-1, "org.buddiesofbudgie.budgie.Dispatcher", (GDBusMethodInfo **) (&_budgie_notifications_dispatcher_dbus_method_info), (GDBusSignalInfo **) (&_budgie_notifications_dispatcher_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_notifications_dispatcher_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_notifications_dispatcher_dbus_interface_vtable = {budgie_notifications_dispatcher_dbus_interface_method_call, budgie_notifications_dispatcher_dbus_interface_get_property, budgie_notifications_dispatcher_dbus_interface_set_property};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_GetCapabilities_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_GetCapabilities_in[] = {NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_GetCapabilities_out[] = {&_budgie_notifications_server_dbus_arg_info_GetCapabilities_result, NULL};
static const GDBusMethodInfo _budgie_notifications_server_dbus_method_info_GetCapabilities = {-1, "GetCapabilities", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_GetCapabilities_in), (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_GetCapabilities_out), NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_GetServerInformation_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_GetServerInformation_vendor = {-1, "vendor", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_GetServerInformation_version = {-1, "version", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_GetServerInformation_spec_version = {-1, "spec_version", "s", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_GetServerInformation_in[] = {NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_GetServerInformation_out[] = {&_budgie_notifications_server_dbus_arg_info_GetServerInformation_name, &_budgie_notifications_server_dbus_arg_info_GetServerInformation_vendor, &_budgie_notifications_server_dbus_arg_info_GetServerInformation_version, &_budgie_notifications_server_dbus_arg_info_GetServerInformation_spec_version, NULL};
static const GDBusMethodInfo _budgie_notifications_server_dbus_method_info_GetServerInformation = {-1, "GetServerInformation", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_GetServerInformation_in), (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_GetServerInformation_out), NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_replaces_id = {-1, "replaces_id", "u", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_app_icon = {-1, "app_icon", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_summary = {-1, "summary", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_body = {-1, "body", "s", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_actions = {-1, "actions", "as", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_hints = {-1, "hints", "a{sv}", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_expire_timeout = {-1, "expire_timeout", "i", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_Notify_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_Notify_in[] = {&_budgie_notifications_server_dbus_arg_info_Notify_app_name, &_budgie_notifications_server_dbus_arg_info_Notify_replaces_id, &_budgie_notifications_server_dbus_arg_info_Notify_app_icon, &_budgie_notifications_server_dbus_arg_info_Notify_summary, &_budgie_notifications_server_dbus_arg_info_Notify_body, &_budgie_notifications_server_dbus_arg_info_Notify_actions, &_budgie_notifications_server_dbus_arg_info_Notify_hints, &_budgie_notifications_server_dbus_arg_info_Notify_expire_timeout, NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_Notify_out[] = {&_budgie_notifications_server_dbus_arg_info_Notify_result, NULL};
static const GDBusMethodInfo _budgie_notifications_server_dbus_method_info_Notify = {-1, "Notify", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_Notify_in), (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_Notify_out), NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_CloseNotification_id = {-1, "id", "u", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_CloseNotification_in[] = {&_budgie_notifications_server_dbus_arg_info_CloseNotification_id, NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_CloseNotification_out[] = {NULL};
static const GDBusMethodInfo _budgie_notifications_server_dbus_method_info_CloseNotification = {-1, "CloseNotification", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_CloseNotification_in), (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_CloseNotification_out), NULL};
static const GDBusMethodInfo * const _budgie_notifications_server_dbus_method_info[] = {&_budgie_notifications_server_dbus_method_info_GetCapabilities, &_budgie_notifications_server_dbus_method_info_GetServerInformation, &_budgie_notifications_server_dbus_method_info_Notify, &_budgie_notifications_server_dbus_method_info_CloseNotification, NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_action_invoked_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_action_invoked_action_key = {-1, "action_key", "s", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_action_invoked[] = {&_budgie_notifications_server_dbus_arg_info_action_invoked_id, &_budgie_notifications_server_dbus_arg_info_action_invoked_action_key, NULL};
static const GDBusSignalInfo _budgie_notifications_server_dbus_signal_info_action_invoked = {-1, "ActionInvoked", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_action_invoked), NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_activation_token_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_activation_token_activation_token = {-1, "activation_token", "s", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_activation_token[] = {&_budgie_notifications_server_dbus_arg_info_activation_token_id, &_budgie_notifications_server_dbus_arg_info_activation_token_activation_token, NULL};
static const GDBusSignalInfo _budgie_notifications_server_dbus_signal_info_activation_token = {-1, "ActivationToken", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_activation_token), NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_notification_closed_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_notifications_server_dbus_arg_info_notification_closed_reason = {-1, "reason", "u", NULL};
static const GDBusArgInfo * const _budgie_notifications_server_dbus_arg_info_notification_closed[] = {&_budgie_notifications_server_dbus_arg_info_notification_closed_id, &_budgie_notifications_server_dbus_arg_info_notification_closed_reason, NULL};
static const GDBusSignalInfo _budgie_notifications_server_dbus_signal_info_notification_closed = {-1, "NotificationClosed", (GDBusArgInfo **) (&_budgie_notifications_server_dbus_arg_info_notification_closed), NULL};
static const GDBusSignalInfo * const _budgie_notifications_server_dbus_signal_info[] = {&_budgie_notifications_server_dbus_signal_info_action_invoked, &_budgie_notifications_server_dbus_signal_info_activation_token, &_budgie_notifications_server_dbus_signal_info_notification_closed, NULL};
static const GDBusPropertyInfo * const _budgie_notifications_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_notifications_server_dbus_interface_info = {-1, "org.freedesktop.Notifications", (GDBusMethodInfo **) (&_budgie_notifications_server_dbus_method_info), (GDBusSignalInfo **) (&_budgie_notifications_server_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_notifications_server_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_notifications_server_dbus_interface_vtable = {budgie_notifications_server_dbus_interface_method_call, budgie_notifications_server_dbus_interface_get_property, budgie_notifications_server_dbus_interface_set_property};

static inline gpointer
budgie_notifications_dispatcher_get_instance_private (BudgieNotificationsDispatcher* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsDispatcher_private_offset);
}

static void
budgie_notifications_dispatcher_on_dbus_acquired (BudgieNotificationsDispatcher* self,
                                                  GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_notifications_dispatcher_register_object (self, conn, BUDGIE_NOTIFICATIONS_NOTIFICATION_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("dbus.vala:46: Unable to register notification dispatcher: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * Returns if Do Not Disturb mode is enabled or not.
 */
gboolean
budgie_notifications_dispatcher_get_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                    GError** error)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dnd;
	result = _tmp0_;
	return result;
}

/**
 * Toggles if Do Not Disturb mode is enabled or not.
 */
void
budgie_notifications_dispatcher_toggle_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                       GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dnd;
	budgie_notifications_dispatcher_set_dnd (self, !_tmp0_);
	_tmp1_ = self->priv->_dnd;
	g_signal_emit (self, budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_DO_NOT_DISTURB_CHANGED_SIGNAL], 0, _tmp1_);
}

BudgieNotificationsDispatcher*
budgie_notifications_dispatcher_construct (GType object_type)
{
	BudgieNotificationsDispatcher * self = NULL;
	self = (BudgieNotificationsDispatcher*) g_object_new (object_type, NULL);
	return self;
}

BudgieNotificationsDispatcher*
budgie_notifications_dispatcher_new (void)
{
	return budgie_notifications_dispatcher_construct (BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER);
}

static gboolean
budgie_notifications_dispatcher_get_dnd (BudgieNotificationsDispatcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dnd;
	return result;
}

static void
budgie_notifications_dispatcher_set_dnd (BudgieNotificationsDispatcher* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_dnd = value;
}

gboolean
budgie_notifications_dispatcher_get_notifications_paused (BudgieNotificationsDispatcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_notifications_paused;
	return result;
}

void
budgie_notifications_dispatcher_set_notifications_paused (BudgieNotificationsDispatcher* self,
                                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_dispatcher_get_notifications_paused (self);
	if (old_value != value) {
		self->priv->_notifications_paused = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_dispatcher_properties[BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATIONS_PAUSED_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT (GClosure * closure,
                                                                                    GValue * return_value,
                                                                                    guint n_param_values,
                                                                                    const GValue * param_values,
                                                                                    gpointer invocation_hint,
                                                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT) (gpointer data1, const char* arg_1, guint32 arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gpointer arg_6, gint arg_7, gpointer arg_8, gint32 arg_9, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 10);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boxed (param_values + 6), g_value_get_int (param_values + 7), g_value_get_boxed (param_values + 8), g_value_get_int (param_values + 9), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_STRING_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_STRING_ENUM) (gpointer data1, guint32 arg_1, const char* arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), g_value_get_enum (param_values + 3), data2);
}

static void
_budgie_notifications_dispatcher_on_dbus_acquired_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                               const gchar* name,
                                                                               gpointer self)
{
	budgie_notifications_dispatcher_on_dbus_acquired ((BudgieNotificationsDispatcher*) self, connection);
}

static GObject *
budgie_notifications_dispatcher_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsDispatcher * self;
	parent_class = G_OBJECT_CLASS (budgie_notifications_dispatcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcher);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_NOTIFICATIONS_NOTIFICATION_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((_budgie_notifications_dispatcher_on_dbus_acquired_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_notifications_dispatcher_on_dbus_acquired_gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
budgie_notifications_dispatcher_class_init (BudgieNotificationsDispatcherClass * klass,
                                            gpointer klass_data)
{
	budgie_notifications_dispatcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsDispatcher_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_dispatcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_dispatcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_dispatcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_dispatcher_finalize;
	/**
	 * Get or set whether or not notifications should be paused, e.g. when an app enters fullscreen
	 * and Budgie is configured to not show notifications when there is a fullscreen app open.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATIONS_PAUSED_PROPERTY, budgie_notifications_dispatcher_properties[BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATIONS_PAUSED_PROPERTY] = g_param_spec_boolean ("notifications-paused", "notifications-paused", "notifications-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Signal emitted when Do Not Disturb is toggled.
	 */
	budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_DO_NOT_DISTURB_CHANGED_SIGNAL] = g_signal_new ("do-not-disturb-changed", BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	/**
	 * Signal emitted when a new notification comes in.
	 *
	 * The id might be a replacement id. It is up to the client to check for this
	 * if they are keeping track of notifications.
	 */
	budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATION_ADDED_SIGNAL] = g_signal_new ("notification-added", BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT, G_TYPE_NONE, 9, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT, G_TYPE_HASH_TABLE, G_TYPE_INT);
	/**
	 * Signal emitted when a notification is closed.
	 */
	budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATION_CLOSED_SIGNAL] = g_signal_new ("notification-closed", BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING_ENUM, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_STRING, BUDGIE_TYPE_NOTIFICATION_CLOSE_REASON);
}

static void
budgie_notifications_dispatcher_instance_init (BudgieNotificationsDispatcher * self,
                                               gpointer klass)
{
	self->priv = budgie_notifications_dispatcher_get_instance_private (self);
	self->priv->_dnd = FALSE;
	self->priv->_notifications_paused = FALSE;
}

static void
budgie_notifications_dispatcher_finalize (GObject * obj)
{
	BudgieNotificationsDispatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcher);
	G_OBJECT_CLASS (budgie_notifications_dispatcher_parent_class)->finalize (obj);
}

static GType
budgie_notifications_dispatcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsDispatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_dispatcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsDispatcher), 0, (GInstanceInitFunc) budgie_notifications_dispatcher_instance_init, NULL };
	GType budgie_notifications_dispatcher_type_id;
	budgie_notifications_dispatcher_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieNotificationsDispatcher", &g_define_type_info, 0);
	g_type_set_qdata (budgie_notifications_dispatcher_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_notifications_dispatcher_register_object);
	BudgieNotificationsDispatcher_private_offset = g_type_add_instance_private (budgie_notifications_dispatcher_type_id, sizeof (BudgieNotificationsDispatcherPrivate));
	return budgie_notifications_dispatcher_type_id;
}

GType
budgie_notifications_dispatcher_get_type (void)
{
	static volatile gsize budgie_notifications_dispatcher_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_dispatcher_type_id__once)) {
		GType budgie_notifications_dispatcher_type_id;
		budgie_notifications_dispatcher_type_id = budgie_notifications_dispatcher_get_type_once ();
		g_once_init_leave (&budgie_notifications_dispatcher_type_id__once, budgie_notifications_dispatcher_type_id);
	}
	return budgie_notifications_dispatcher_type_id__once;
}

static void
_vala_budgie_notifications_dispatcher_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	BudgieNotificationsDispatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcher);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATIONS_PAUSED_PROPERTY:
		g_value_set_boolean (value, budgie_notifications_dispatcher_get_notifications_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_dispatcher_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	BudgieNotificationsDispatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_DISPATCHER, BudgieNotificationsDispatcher);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATIONS_PAUSED_PROPERTY:
		budgie_notifications_dispatcher_set_notifications_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_budgie_notifications_dispatcher_get_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_notifications_dispatcher_get_do_not_disturb (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_notifications_dispatcher_toggle_do_not_disturb (BudgieNotificationsDispatcher* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_notifications_dispatcher_toggle_do_not_disturb (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_notifications_dispatcher_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetDoNotDisturb") == 0) {
		_dbus_budgie_notifications_dispatcher_get_do_not_disturb (object, parameters, invocation);
	} else if (strcmp (method_name, "ToggleDoNotDisturb") == 0) {
		_dbus_budgie_notifications_dispatcher_toggle_do_not_disturb (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_budgie_notifications_dispatcher_get_notifications_paused (BudgieNotificationsDispatcher* self)
{
	gboolean result;
	GVariant* _reply;
	result = budgie_notifications_dispatcher_get_notifications_paused (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
budgie_notifications_dispatcher_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NotificationsPaused") == 0) {
		return _dbus_budgie_notifications_dispatcher_get_notifications_paused (object);
	}
	return NULL;
}

static void
_dbus_budgie_notifications_dispatcher_set_notifications_paused (BudgieNotificationsDispatcher* self,
                                                                GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	budgie_notifications_dispatcher_set_notifications_paused (self, value);
}

static gboolean
budgie_notifications_dispatcher_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NotificationsPaused") == 0) {
		_dbus_budgie_notifications_dispatcher_set_notifications_paused (object, value);
		return TRUE;
	}
	return FALSE;
}

static void
_dbus_budgie_notifications_dispatcher_do_not_disturb_changed (GObject* _sender,
                                                              gboolean value,
                                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.budgie.Dispatcher", "DoNotDisturbChanged", _arguments, NULL);
}

static void
_dbus_budgie_notifications_dispatcher_notification_added (GObject* _sender,
                                                          const gchar* app_name,
                                                          guint32 id,
                                                          const gchar* app_icon,
                                                          const gchar* summary,
                                                          const gchar* body,
                                                          gchar** actions,
                                                          gint actions_length1,
                                                          GHashTable* hints,
                                                          gint32 expire_timeout,
                                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp9_;
	GVariantBuilder _tmp10_;
	gint _tmp11_;
	GVariantBuilder _tmp12_;
	GHashTableIter _tmp13_;
	gpointer _tmp14_;
	gpointer _tmp15_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_icon));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (summary));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (body));
	_tmp9_ = actions;
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("as"));
	for (_tmp11_ = 0; _tmp11_ < actions_length1; _tmp11_++) {
		g_variant_builder_add_value (&_tmp10_, g_variant_new_string (*_tmp9_));
		_tmp9_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp10_));
	g_hash_table_iter_init (&_tmp13_, hints);
	g_variant_builder_init (&_tmp12_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp13_, &_tmp14_, &_tmp15_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp14_;
		_value = (GVariant*) _tmp15_;
		g_variant_builder_add (&_tmp12_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp12_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (expire_timeout));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.budgie.Dispatcher", "NotificationAdded", _arguments, NULL);
}

static void
_dbus_budgie_notifications_dispatcher_notification_closed (GObject* _sender,
                                                           guint32 id,
                                                           const gchar* app_name,
                                                           BudgieNotificationCloseReason reason,
                                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.budgie.Dispatcher", "NotificationClosed", _arguments, NULL);
}

guint
budgie_notifications_dispatcher_register_object (gpointer object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_notifications_dispatcher_dbus_interface_info), &_budgie_notifications_dispatcher_dbus_interface_vtable, data, _budgie_notifications_dispatcher_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "do-not-disturb-changed", (GCallback) _dbus_budgie_notifications_dispatcher_do_not_disturb_changed, data);
	g_signal_connect (object, "notification-added", (GCallback) _dbus_budgie_notifications_dispatcher_notification_added, data);
	g_signal_connect (object, "notification-closed", (GCallback) _dbus_budgie_notifications_dispatcher_notification_closed, data);
	return result;
}

static void
_budgie_notifications_dispatcher_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_dispatcher_do_not_disturb_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_dispatcher_notification_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_dispatcher_notification_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_notifications_server_get_instance_private (BudgieNotificationsServer* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsServer_private_offset);
}

static void
budgie_notifications_server_on_bus_acquired (BudgieNotificationsServer* self,
                                             GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_notifications_server_register_object (self, conn, "/org/freedesktop/Notifications", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("dbus.vala:134: Unable to register notification DBus: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * Returns the capabilities of this DBus Notification server.
 */
gchar**
budgie_notifications_server_GetCapabilities (BudgieNotificationsServer* self,
                                             gint* result_length1,
                                             GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("action-icons");
	_tmp1_ = g_strdup ("actions");
	_tmp2_ = g_strdup ("body");
	_tmp3_ = g_strdup ("body-markup");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 4;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

/**
 * Returns the information for this DBus Notification server.
 */
void
budgie_notifications_server_GetServerInformation (BudgieNotificationsServer* self,
                                                  gchar** name,
                                                  gchar** vendor,
                                                  gchar** version,
                                                  gchar** spec_version,
                                                  GError** error)
{
	gchar* _vala_name = NULL;
	gchar* _vala_vendor = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_spec_version = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Budgie Notification Server");
	_g_free0 (_vala_name);
	_vala_name = _tmp0_;
	_tmp1_ = g_strdup ("Budgie Desktop Developers");
	_g_free0 (_vala_vendor);
	_vala_vendor = _tmp1_;
	_tmp2_ = g_strdup (BUDGIE_VERSION);
	_g_free0 (_vala_version);
	_vala_version = _tmp2_;
	_tmp3_ = g_strdup ("1.2");
	_g_free0 (_vala_spec_version);
	_vala_spec_version = _tmp3_;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	if (vendor) {
		*vendor = _vala_vendor;
	} else {
		_g_free0 (_vala_vendor);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (spec_version) {
		*spec_version = _vala_spec_version;
	} else {
		_g_free0 (_vala_spec_version);
	}
}

/**
 * Handles a notification from DBus.
 *
 * If replaces_id is 0, the return value is a UINT32 that represent the notification.
 * It is unique, and will not be reused unless a MAXINT number of notifications have been generated.
 * An acceptable implementation may just use an incrementing counter for the ID. The returned ID is
 * always greater than zero. Servers must make sure not to return zero as an ID.
 *
 * If replaces_id is not 0, the returned value is the same value as replaces_id.
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieNotificationsServer* self;
		self = _data1_->self;
		_g_free0 (_data1_->app_name);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
___lambda16_ (Block1Data* _data1_,
              const gchar* action_key)
{
	BudgieNotificationsServer* self;
	self = _data1_->self;
	g_return_if_fail (action_key != NULL);
	g_signal_emit (self, budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL], 0, _data1_->id, action_key);
}

static void
____lambda16__budgie_notifications_popup_action_invoked (BudgieNotificationsPopup* _sender,
                                                         const gchar* action_key,
                                                         gpointer self)
{
	___lambda16_ (self, action_key);
}

static void
___lambda17_ (Block1Data* _data1_,
              BudgieNotificationCloseReason reason)
{
	BudgieNotificationsServer* self;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GHashTable* _tmp5_;
	BudgieNotificationsDispatcher* _tmp6_;
	self = _data1_->self;
	_tmp1_ = self->priv->popups;
	_tmp2_ = g_hash_table_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint) 1)) {
		guint32 _tmp4_;
		_tmp4_ = self->priv->_latest_popup_id;
		_tmp0_ = _tmp4_ == _data1_->id;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		budgie_notifications_server_set_latest_popup_id (self, (guint32) 0);
	}
	_tmp5_ = self->priv->popups;
	g_hash_table_remove (_tmp5_, (gpointer) ((guintptr) _data1_->id));
	_tmp6_ = self->priv->_dispatcher;
	g_signal_emit (_tmp6_, budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATION_CLOSED_SIGNAL], 0, _data1_->id, _data1_->app_name, reason);
	g_signal_emit (self, budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL], 0, _data1_->id, (guint32) reason);
}

static void
____lambda17__budgie_notifications_popup_base_closed (BudgieNotificationsPopupBase* _sender,
                                                      BudgieNotificationCloseReason reason,
                                                      gpointer self)
{
	___lambda17_ (self, reason);
}

guint32
budgie_notifications_server_Notify (BudgieNotificationsServer* self,
                                    const gchar* app_name,
                                    guint32 replaces_id,
                                    const gchar* app_icon,
                                    const gchar* summary,
                                    const gchar* body,
                                    gchar** actions,
                                    gint actions_length1,
                                    GHashTable* hints,
                                    gint32 expire_timeout,
                                    GError** error)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	guint32 _tmp1_ = 0U;
	gint32 expires = 0;
	BudgieNotification* notification = NULL;
	BudgieNotification* _tmp3_;
	gchar* settings_app_name = NULL;
	gchar* _tmp4_;
	gboolean should_show = FALSE;
	GSettings* app_notification_settings = NULL;
	GSettingsSchemaSource* _tmp10_;
	GSettingsSchema* _tmp11_;
	GSettingsSchema* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	BudgieNotificationsDispatcher* _tmp20_;
	gboolean should_notify = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GHashTable* _tmp34_;
	BudgieNotificationsDispatcher* _tmp54_;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (app_name != NULL, 0U);
	g_return_val_if_fail (app_icon != NULL, 0U);
	g_return_val_if_fail (summary != NULL, 0U);
	g_return_val_if_fail (body != NULL, 0U);
	g_return_val_if_fail (hints != NULL, 0U);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (app_name);
	_g_free0 (_data1_->app_name);
	_data1_->app_name = _tmp0_;
	if (replaces_id != ((guint32) 0)) {
		_tmp1_ = replaces_id;
	} else {
		guint32 _tmp2_;
		self->priv->notif_id = self->priv->notif_id + 1;
		_tmp2_ = self->priv->notif_id;
		_tmp1_ = _tmp2_;
	}
	_data1_->id = _tmp1_;
	expires = CLAMP (expire_timeout, BUDGIE_NOTIFICATIONS_MINIMUM_EXPIRY, BUDGIE_NOTIFICATIONS_MAXIMUM_EXPIRY);
	_tmp3_ = budgie_notification_new (_data1_->id, _data1_->app_name, app_icon, summary, body, actions, actions_length1, hints, (guint) expires);
	notification = _tmp3_;
	_tmp4_ = g_strdup (_data1_->app_name);
	settings_app_name = _tmp4_;
	should_show = TRUE;
	if (g_hash_table_contains (hints, "desktop-entry")) {
		gconstpointer _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = g_hash_table_lookup (hints, "desktop-entry");
		_tmp6_ = g_variant_get_string ((GVariant*) _tmp5_, NULL);
		_tmp7_ = string_replace (_tmp6_, ".", "-");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
		_g_free0 (settings_app_name);
		settings_app_name = _tmp9_;
		_g_free0 (_tmp8_);
	}
	_tmp10_ = g_settings_schema_source_get_default ();
	_tmp11_ = g_settings_schema_source_lookup (_tmp10_, BUDGIE_NOTIFICATIONS_SERVER_APPLICATION_SCHEMA, TRUE);
	_tmp12_ = _tmp11_;
	_tmp13_ = settings_app_name;
	_tmp14_ = g_strdup_printf ("%s/%s/", BUDGIE_NOTIFICATIONS_SERVER_APPLICATION_PREFIX, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_settings_new_full (_tmp12_, NULL, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_settings_schema_unref0 (_tmp12_);
	app_notification_settings = _tmp17_;
	_tmp20_ = self->priv->_dispatcher;
	_tmp19_ = budgie_notifications_dispatcher_get_do_not_disturb (_tmp20_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			guint32 _tmp21_ = 0U;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (app_notification_settings);
			_g_free0 (settings_app_name);
			_g_object_unref0 (notification);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return _tmp21_;
		} else {
			guint32 _tmp22_ = 0U;
			_g_object_unref0 (app_notification_settings);
			_g_free0 (settings_app_name);
			_g_object_unref0 (notification);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp22_;
		}
	}
	if (!_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		BudgieNotification* _tmp23_;
		BudgieNotificationUrgency _tmp24_;
		BudgieNotificationUrgency _tmp25_;
		_tmp23_ = notification;
		_tmp24_ = budgie_notification_get_urgency (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp18_ = _tmp25_ == BUDGIE_NOTIFICATION_URGENCY_CRITICAL;
	}
	should_notify = _tmp18_;
	if (g_settings_get_boolean (app_notification_settings, "enable")) {
		_tmp27_ = g_settings_get_boolean (app_notification_settings, "show-banners");
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		BudgieNotificationsDispatcher* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp28_ = self->priv->_dispatcher;
		_tmp29_ = budgie_notifications_dispatcher_get_notifications_paused (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp26_ = !_tmp30_;
	} else {
		_tmp26_ = FALSE;
	}
	should_show = _tmp26_;
	if (!should_notify) {
		_tmp31_ = TRUE;
	} else {
		_tmp31_ = !should_show;
	}
	if (_tmp31_) {
		BudgieNotification* _tmp32_;
		_tmp32_ = notification;
		budgie_notification_set_expire_timeout (_tmp32_, (guint) 0);
	}
	_tmp34_ = self->priv->popups;
	if (g_hash_table_contains (_tmp34_, (gpointer) ((guintptr) _data1_->id))) {
		GHashTable* _tmp35_;
		gconstpointer _tmp36_;
		_tmp35_ = self->priv->popups;
		_tmp36_ = g_hash_table_lookup (_tmp35_, (gpointer) ((guintptr) _data1_->id));
		_tmp33_ = ((BudgieNotificationsPopup*) _tmp36_) != NULL;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		GHashTable* _tmp37_;
		gconstpointer _tmp38_;
		BudgieNotification* _tmp39_;
		_tmp37_ = self->priv->popups;
		_tmp38_ = g_hash_table_lookup (_tmp37_, (gpointer) ((guintptr) _data1_->id));
		_tmp39_ = notification;
		budgie_notifications_popup_replace ((BudgieNotificationsPopup*) _tmp38_, _tmp39_);
	} else {
		GHashTable* _tmp40_;
		BudgieNotification* _tmp41_;
		BudgieNotificationsPopup* _tmp42_;
		GHashTable* _tmp43_;
		gconstpointer _tmp44_;
		GHashTable* _tmp45_;
		gconstpointer _tmp46_;
		BudgieNotification* _tmp47_;
		guint _tmp48_;
		guint _tmp49_;
		GHashTable* _tmp50_;
		gconstpointer _tmp51_;
		GHashTable* _tmp52_;
		gconstpointer _tmp53_;
		_tmp40_ = self->priv->popups;
		_tmp41_ = notification;
		_tmp42_ = budgie_notifications_popup_new (self, _tmp41_);
		g_object_ref_sink (_tmp42_);
		g_hash_table_insert (_tmp40_, (gpointer) ((guintptr) _data1_->id), _tmp42_);
		_tmp43_ = self->priv->popups;
		_tmp44_ = g_hash_table_lookup (_tmp43_, (gpointer) ((guintptr) _data1_->id));
		budgie_notifications_server_configure_window (self, (BudgieNotificationsPopup*) _tmp44_);
		budgie_notifications_server_set_latest_popup_id (self, _data1_->id);
		_tmp45_ = self->priv->popups;
		_tmp46_ = g_hash_table_lookup (_tmp45_, (gpointer) ((guintptr) _data1_->id));
		_tmp47_ = notification;
		_tmp48_ = budgie_notification_get_expire_timeout (_tmp47_);
		_tmp49_ = _tmp48_;
		budgie_notifications_popup_base_begin_decay ((BudgieNotificationsPopupBase*) ((BudgieNotificationsPopup*) _tmp46_), _tmp49_);
		_tmp50_ = self->priv->popups;
		_tmp51_ = g_hash_table_lookup (_tmp50_, (gpointer) ((guintptr) _data1_->id));
		g_signal_connect_data ((BudgieNotificationsPopup*) _tmp51_, "action-invoked", (GCallback) ____lambda16__budgie_notifications_popup_action_invoked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp52_ = self->priv->popups;
		_tmp53_ = g_hash_table_lookup (_tmp52_, (gpointer) ((guintptr) _data1_->id));
		g_signal_connect_data ((BudgieNotificationsPopupBase*) ((BudgieNotificationsPopup*) _tmp53_), "closed", (GCallback) ____lambda17__budgie_notifications_popup_base_closed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	}
	_tmp54_ = self->priv->_dispatcher;
	g_signal_emit (_tmp54_, budgie_notifications_dispatcher_signals[BUDGIE_NOTIFICATIONS_DISPATCHER_NOTIFICATION_ADDED_SIGNAL], 0, _data1_->app_name, _data1_->id, app_icon, summary, body, actions, (gint) actions_length1, hints, expire_timeout);
	result = _data1_->id;
	_g_object_unref0 (app_notification_settings);
	_g_free0 (settings_app_name);
	_g_object_unref0 (notification);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

/**
 * Causes a notification to be forcefully closed and removed from the user's view.
 * It can be used, for example, in the event that what the notification pertains to is no longer relevant,
 * or to cancel a notification with no expiration time.
 *
 * Per the spec, a blank DBusError should be thrown if the notification doesn't exist when this is called.
 * However, this can break notifications from some applications, and other desktop environments don't
 * follow that part of the spec, either. So, return to avoid breaking things.
 */
void
budgie_notifications_server_CloseNotification (BudgieNotificationsServer* self,
                                               guint32 id,
                                               GError** error)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popups;
	if (!g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		return;
	}
	_tmp1_ = self->priv->popups;
	_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) id));
	budgie_notifications_popup_base_dismiss ((BudgieNotificationsPopupBase*) ((BudgieNotificationsPopup*) _tmp2_));
	_tmp3_ = self->priv->popups;
	g_hash_table_remove (_tmp3_, (gpointer) ((guintptr) id));
	g_signal_emit (self, budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL], 0, id, (guint32) BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED);
}

/**
 * Configures the location of a notification popup and makes it visible on the screen.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieNotificationsServer* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->popup);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda15_ (Block2Data* _data2_,
             GtkAllocation* alloc)
{
	BudgieNotificationsServer* self;
	GtkWidget* _tmp0_;
	gint x = 0;
	gint y = 0;
	GdkRectangle _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data2_->self;
	g_return_if_fail (alloc != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) _data2_->popup);
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data2_->handler_id);
	_data2_->handler_id = (gulong) 0;
	x = 0;
	y = 0;
	_tmp1_ = _data2_->mon_rect;
	budgie_notifications_server_calculate_position (self, _data2_->popup, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp2_;
	y = _tmp3_;
	gtk_window_move ((GtkWindow*) _data2_->popup, x, y);
}

static void
___lambda15__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda15_ (self, allocation);
}

static void
budgie_notifications_server_configure_window (BudgieNotificationsServer* self,
                                              BudgieNotificationsPopup* popup)
{
	Block2Data* _data2_;
	BudgieNotificationsPopup* _tmp0_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GdkMonitor* mon = NULL;
	GdkDisplay* _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	GtkWidget* _tmp7_;
	gulong _tmp8_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (popup);
	_g_object_unref0 (_data2_->popup);
	_data2_->popup = _tmp0_;
	_tmp1_ = gdk_screen_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	_tmp3_ = gdk_screen_get_display (screen);
	_tmp4_ = gdk_display_get_primary_monitor (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	mon = _tmp5_;
	gdk_monitor_get_geometry (mon, &_tmp6_);
	_data2_->mon_rect = _tmp6_;
	_data2_->handler_id = (gulong) 0;
	_tmp7_ = gtk_bin_get_child ((GtkBin*) _data2_->popup);
	_tmp8_ = g_signal_connect_data (_tmp7_, "size-allocate", (GCallback) ___lambda15__gtk_widget_size_allocate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->handler_id = _tmp8_;
	gtk_widget_show_all ((GtkWidget*) _data2_->popup);
	_g_object_unref0 (mon);
	_g_object_unref0 (screen);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

/**
* Calculate the (x, y) position of a notification popup based on the setting for where on
* the screen notifications should appear.
*/
static void
budgie_notifications_server_calculate_position (BudgieNotificationsServer* self,
                                                BudgieNotificationsPopup* window,
                                                GdkRectangle* rect,
                                                gint* x,
                                                gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	BudgieNotificationPosition pos = 0;
	GSettings* _tmp0_;
	BudgieNotificationsPopup* latest = NULL;
	GHashTable* _tmp1_;
	guint32 _tmp2_;
	gconstpointer _tmp3_;
	BudgieNotificationsPopup* _tmp4_;
	gboolean _tmp5_ = FALSE;
	BudgieNotificationsPopup* _tmp6_;
	gboolean latest_exists = FALSE;
	gint existing_height = 0;
	gint existing_x = 0;
	gint existing_y = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = self->priv->_panel_settings;
	pos = (BudgieNotificationPosition) g_settings_get_enum (_tmp0_, "notification-position");
	_tmp1_ = self->priv->popups;
	_tmp2_ = self->priv->_latest_popup_id;
	_tmp3_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) _tmp2_));
	_tmp4_ = _g_object_ref0 ((BudgieNotificationsPopup*) _tmp3_);
	latest = _tmp4_;
	_tmp6_ = latest;
	if (_tmp6_ != NULL) {
		BudgieNotificationsPopup* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = latest;
		_tmp8_ = budgie_notifications_popup_base_get_destroying ((BudgieNotificationsPopupBase*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = !_tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	latest_exists = _tmp5_;
	existing_height = 0;
	existing_x = 0;
	existing_y = 0;
	if (latest_exists) {
		BudgieNotificationsPopup* _tmp10_;
		GtkWidget* _tmp11_;
		BudgieNotificationsPopup* _tmp12_;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp10_ = latest;
		_tmp11_ = gtk_bin_get_child ((GtkBin*) _tmp10_);
		existing_height = gtk_widget_get_allocated_height (_tmp11_);
		_tmp12_ = latest;
		gtk_window_get_position ((GtkWindow*) _tmp12_, &_tmp13_, &_tmp14_);
		existing_x = _tmp13_;
		existing_y = _tmp14_;
	}
	switch (pos) {
		case BUDGIE_NOTIFICATION_POSITION_TOP_LEFT:
		{
			if (latest_exists) {
				_vala_x = existing_x;
				_vala_y = (existing_y + existing_height) + BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
			} else {
				GdkRectangle _tmp15_;
				GdkRectangle _tmp16_;
				_tmp15_ = *rect;
				_vala_x = _tmp15_.x + BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
				_tmp16_ = *rect;
				_vala_y = _tmp16_.y + BUDGIE_NOTIFICATIONS_SERVER_INITIAL_BUFFER_ZONE;
			}
			break;
		}
		case BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT:
		{
			if (latest_exists) {
				_vala_x = existing_x;
				_vala_y = (existing_y - existing_height) - BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
			} else {
				GdkRectangle _tmp17_;
				GdkRectangle _tmp18_;
				GdkRectangle _tmp19_;
				_tmp17_ = *rect;
				_vala_x = _tmp17_.x + BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
				_tmp18_ = *rect;
				_tmp19_ = *rect;
				_vala_y = ((_tmp18_.y + _tmp19_.height) - gtk_widget_get_allocated_height ((GtkWidget*) window)) - BUDGIE_NOTIFICATIONS_SERVER_INITIAL_BUFFER_ZONE;
			}
			break;
		}
		case BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT:
		{
			if (latest_exists) {
				_vala_x = existing_x;
				_vala_y = (existing_y - existing_height) - BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
			} else {
				GdkRectangle _tmp20_;
				GdkRectangle _tmp21_;
				GdkRectangle _tmp22_;
				GdkRectangle _tmp23_;
				_tmp20_ = *rect;
				_tmp21_ = *rect;
				_vala_x = (_tmp20_.x + _tmp21_.width) - BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH;
				_vala_x = _vala_x - BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
				_tmp22_ = *rect;
				_tmp23_ = *rect;
				_vala_y = ((_tmp22_.y + _tmp23_.height) - gtk_widget_get_allocated_height ((GtkWidget*) window)) - BUDGIE_NOTIFICATIONS_SERVER_INITIAL_BUFFER_ZONE;
			}
			break;
		}
		default:
		case BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT:
		{
			if (latest_exists) {
				_vala_x = existing_x;
				_vala_y = (existing_y + existing_height) + BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
			} else {
				GdkRectangle _tmp24_;
				GdkRectangle _tmp25_;
				GdkRectangle _tmp26_;
				_tmp24_ = *rect;
				_tmp25_ = *rect;
				_vala_x = (_tmp24_.x + _tmp25_.width) - BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH;
				_vala_x = _vala_x - BUDGIE_NOTIFICATIONS_SERVER_BUFFER_ZONE;
				_tmp26_ = *rect;
				_vala_y = _tmp26_.y + BUDGIE_NOTIFICATIONS_SERVER_INITIAL_BUFFER_ZONE;
			}
			break;
		}
	}
	_g_object_unref0 (latest);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

BudgieNotificationsServer*
budgie_notifications_server_construct (GType object_type)
{
	BudgieNotificationsServer * self = NULL;
	self = (BudgieNotificationsServer*) g_object_new (object_type, NULL);
	return self;
}

BudgieNotificationsServer*
budgie_notifications_server_new (void)
{
	return budgie_notifications_server_construct (BUDGIE_NOTIFICATIONS_TYPE_SERVER);
}

static BudgieNotificationsDispatcher*
budgie_notifications_server_get_dispatcher (BudgieNotificationsServer* self)
{
	BudgieNotificationsDispatcher* result;
	BudgieNotificationsDispatcher* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dispatcher;
	result = _tmp0_;
	return result;
}

static void
budgie_notifications_server_set_dispatcher (BudgieNotificationsServer* self,
                                            BudgieNotificationsDispatcher* value)
{
	BudgieNotificationsDispatcher* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_dispatcher);
	self->priv->_dispatcher = _tmp0_;
}

static GSettings*
budgie_notifications_server_get_panel_settings (BudgieNotificationsServer* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_panel_settings;
	result = _tmp0_;
	return result;
}

static void
budgie_notifications_server_set_panel_settings (BudgieNotificationsServer* self,
                                                GSettings* value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_panel_settings);
	self->priv->_panel_settings = _tmp0_;
}

static guint32
budgie_notifications_server_get_latest_popup_id (BudgieNotificationsServer* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_latest_popup_id;
	return result;
}

static void
budgie_notifications_server_set_latest_popup_id (BudgieNotificationsServer* self,
                                                 guint32 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_latest_popup_id = value;
}

static void
g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_STRING) (gpointer data1, guint32 arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
_budgie_notifications_server_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                     const gchar* name,
                                                                     gpointer self)
{
	budgie_notifications_server_on_bus_acquired ((BudgieNotificationsServer*) self, connection);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
budgie_notifications_server_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsServer * self;
	BudgieNotificationsDispatcher* _tmp0_;
	BudgieNotificationsDispatcher* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	parent_class = G_OBJECT_CLASS (budgie_notifications_server_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.freedesktop.Notifications", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_budgie_notifications_server_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_notifications_server_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp0_ = budgie_notifications_dispatcher_new ();
	_tmp1_ = _tmp0_;
	budgie_notifications_server_set_dispatcher (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->popups);
	self->priv->popups = _tmp4_;
	_tmp5_ = g_settings_new (BUDGIE_NOTIFICATIONS_SERVER_BUDGIE_PANEL_SCHEMA);
	_tmp6_ = _tmp5_;
	budgie_notifications_server_set_panel_settings (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	return obj;
}

static void
budgie_notifications_server_class_init (BudgieNotificationsServerClass * klass,
                                        gpointer klass_data)
{
	budgie_notifications_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsServer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_server_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_server_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_server_finalize;
	/**
	 * Signal emitted when one of the following occurs:
	 *   - When the user performs some global "invoking" action upon a notification.
	 * 	   For instance, clicking somewhere on the notification itself.
	 *   - The user invokes a specific action as specified in the original Notify request.
	 *     For example, clicking on an action button.
	 */
	budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL] = g_signal_new ("action-invoked", BUDGIE_NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_STRING);
	/**
	 * This signal can be emitted before a ActionInvoked signal.
	 * It carries an activation token that can be used to activate a toplevel.
	 */
	budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_ACTIVATION_TOKEN_SIGNAL] = g_signal_new ("activation-token", BUDGIE_NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_STRING);
	/**
	 * Signal emitted when a notification is closed.
	 */
	budgie_notifications_server_signals[BUDGIE_NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL] = g_signal_new ("notification-closed", BUDGIE_NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
}

static void
budgie_notifications_server_instance_init (BudgieNotificationsServer * self,
                                           gpointer klass)
{
	self->priv = budgie_notifications_server_get_instance_private (self);
	self->priv->notif_id = (guint32) 0;
	self->priv->_dispatcher = NULL;
	self->priv->_panel_settings = NULL;
	self->priv->_latest_popup_id = (guint32) 0;
}

static void
budgie_notifications_server_finalize (GObject * obj)
{
	BudgieNotificationsServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer);
	_g_object_unref0 (self->priv->_dispatcher);
	_g_hash_table_unref0 (self->priv->popups);
	_g_object_unref0 (self->priv->_panel_settings);
	G_OBJECT_CLASS (budgie_notifications_server_parent_class)->finalize (obj);
}

/**
 * This is our implementation of the FreeDesktop Notification spec.
 */
static GType
budgie_notifications_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsServer), 0, (GInstanceInitFunc) budgie_notifications_server_instance_init, NULL };
	GType budgie_notifications_server_type_id;
	budgie_notifications_server_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieNotificationsServer", &g_define_type_info, 0);
	g_type_set_qdata (budgie_notifications_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_notifications_server_register_object);
	BudgieNotificationsServer_private_offset = g_type_add_instance_private (budgie_notifications_server_type_id, sizeof (BudgieNotificationsServerPrivate));
	return budgie_notifications_server_type_id;
}

GType
budgie_notifications_server_get_type (void)
{
	static volatile gsize budgie_notifications_server_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_server_type_id__once)) {
		GType budgie_notifications_server_type_id;
		budgie_notifications_server_type_id = budgie_notifications_server_get_type_once ();
		g_once_init_leave (&budgie_notifications_server_type_id__once, budgie_notifications_server_type_id);
	}
	return budgie_notifications_server_type_id__once;
}

static void
_vala_budgie_notifications_server_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	BudgieNotificationsServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_server_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	BudgieNotificationsServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_budgie_notifications_server_GetCapabilities (BudgieNotificationsServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp16_;
	GVariantBuilder _tmp17_;
	gint _tmp18_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_notifications_server_GetCapabilities (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp16_ = result;
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE ("as"));
	for (_tmp18_ = 0; _tmp18_ < result_length1; _tmp18_++) {
		g_variant_builder_add_value (&_tmp17_, g_variant_new_string (*_tmp16_));
		_tmp16_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp17_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_notifications_server_GetServerInformation (BudgieNotificationsServer* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gchar* vendor = NULL;
	gchar* version = NULL;
	gchar* spec_version = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_notifications_server_GetServerInformation (self, &name, &vendor, &version, &spec_version, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (vendor));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (version));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (spec_version));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (name);
	_g_free0 (vendor);
	_g_free0 (version);
	_g_free0 (spec_version);
}

static void
_dbus_budgie_notifications_server_Notify (BudgieNotificationsServer* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_name = NULL;
	GVariant* _tmp19_;
	guint32 replaces_id = 0U;
	GVariant* _tmp20_;
	gchar* app_icon = NULL;
	GVariant* _tmp21_;
	gchar* summary = NULL;
	GVariant* _tmp22_;
	gchar* body = NULL;
	GVariant* _tmp23_;
	gchar** actions = NULL;
	gint actions_length1 = 0;
	GVariant* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length;
	gint _tmp25__size;
	gint _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	GHashTable* hints = NULL;
	GVariant* _tmp28_;
	GHashTable* _tmp29_;
	GVariantIter _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	gint32 expire_timeout = 0;
	GVariant* _tmp33_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	app_name = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	replaces_id = g_variant_get_uint32 (_tmp20_);
	g_variant_unref (_tmp20_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	app_icon = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	summary = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	body = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp25_ = g_new (gchar*, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _tmp24_);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (gchar*, _tmp25_, _tmp25__size + 1);
		}
		_tmp25_[_tmp25__length++] = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
	}
	actions_length1 = _tmp25__length1;
	_tmp25_[_tmp25__length] = NULL;
	actions = _tmp25_;
	g_variant_unref (_tmp24_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp29_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp30_, _tmp28_);
	while (g_variant_iter_loop (&_tmp30_, "{?*}", &_tmp31_, &_tmp32_)) {
		g_hash_table_insert (_tmp29_, g_variant_dup_string (_tmp31_, NULL), g_variant_get_variant (_tmp32_));
	}
	hints = _tmp29_;
	g_variant_unref (_tmp28_);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	expire_timeout = g_variant_get_int32 (_tmp33_);
	g_variant_unref (_tmp33_);
	result = budgie_notifications_server_Notify (self, app_name, replaces_id, app_icon, summary, body, actions, actions_length1, hints, expire_timeout, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (app_name);
	_g_free0 (app_icon);
	_g_free0 (summary);
	_g_free0 (body);
	actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (hints);
	;
}

static void
_dbus_budgie_notifications_server_CloseNotification (BudgieNotificationsServer* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 id = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	budgie_notifications_server_CloseNotification (self, id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_notifications_server_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetCapabilities") == 0) {
		_dbus_budgie_notifications_server_GetCapabilities (object, parameters, invocation);
	} else if (strcmp (method_name, "GetServerInformation") == 0) {
		_dbus_budgie_notifications_server_GetServerInformation (object, parameters, invocation);
	} else if (strcmp (method_name, "Notify") == 0) {
		_dbus_budgie_notifications_server_Notify (object, parameters, invocation);
	} else if (strcmp (method_name, "CloseNotification") == 0) {
		_dbus_budgie_notifications_server_CloseNotification (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_notifications_server_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_notifications_server_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_budgie_notifications_server_action_invoked (GObject* _sender,
                                                  guint32 id,
                                                  const gchar* action_key,
                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action_key));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "ActionInvoked", _arguments, NULL);
}

static void
_dbus_budgie_notifications_server_activation_token (GObject* _sender,
                                                    guint32 id,
                                                    const gchar* activation_token,
                                                    gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (activation_token));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "ActivationToken", _arguments, NULL);
}

static void
_dbus_budgie_notifications_server_notification_closed (GObject* _sender,
                                                       guint32 id,
                                                       guint32 reason,
                                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "NotificationClosed", _arguments, NULL);
}

guint
budgie_notifications_server_register_object (gpointer object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_notifications_server_dbus_interface_info), &_budgie_notifications_server_dbus_interface_vtable, data, _budgie_notifications_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "action-invoked", (GCallback) _dbus_budgie_notifications_server_action_invoked, data);
	g_signal_connect (object, "activation-token", (GCallback) _dbus_budgie_notifications_server_activation_token, data);
	g_signal_connect (object, "notification-closed", (GCallback) _dbus_budgie_notifications_server_notification_closed, data);
	return result;
}

static void
_budgie_notifications_server_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_server_action_invoked, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_server_activation_token, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_server_notification_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

