/* main_view.c generated by valac 0.56.2, the Vala compiler
 * generated from main_view.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

enum  {
	BUDGIE_MAIN_VIEW_0_PROPERTY,
	BUDGIE_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* budgie_main_view_properties[BUDGIE_MAIN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL,
	BUDGIE_MAIN_VIEW_NUM_SIGNALS
};
static guint budgie_main_view_signals[BUDGIE_MAIN_VIEW_NUM_SIGNALS] = {0};

struct _BudgieMainViewPrivate {
	GtkBox* box;
	MprisWidget* mpris;
	CalendarWidget* cal;
	BudgieSoundWidget* audio_input_widget;
	BudgieSoundWidget* audio_output_widget;
	GSettings* raven_settings;
	GtkStack* main_stack;
	GtkStackSwitcher* switcher;
	gchar* SHOW_SOUND_OUTPUT_WIDGET;
	gchar* SHOW_MIC_INPUT_WIDGET;
};

static gint BudgieMainView_private_offset;
static gpointer budgie_main_view_parent_class = NULL;

static void budgie_main_view_on_raven_settings_changed (BudgieMainView* self,
                                                 const gchar* key);
static void _budgie_main_view_on_raven_settings_changed_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static void budgie_main_view_on_name_change (BudgieMainView* self);
static void _budgie_main_view_on_name_change_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void budgie_main_view_set_sound_widget_events (BudgieMainView* self);
static void __lambda45_ (BudgieMainView* self);
static void ___lambda45__budgie_sound_widget_devices_state_changed (BudgieSoundWidget* _sender,
                                                             gpointer self);
static void __lambda46_ (BudgieMainView* self);
static void ___lambda46__budgie_sound_widget_devices_state_changed (BudgieSoundWidget* _sender,
                                                             gpointer self);
static void budgie_main_view_finalize (GObject * obj);
static GType budgie_main_view_get_type_once (void);

static inline gpointer
budgie_main_view_get_instance_private (BudgieMainView* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMainView_private_offset);
}

void
budgie_main_view_expose_notification (BudgieMainView* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "notifications");
}

static void
_budgie_main_view_on_raven_settings_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	budgie_main_view_on_raven_settings_changed ((BudgieMainView*) self, key);
}

static void
_budgie_main_view_on_name_change_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	budgie_main_view_on_name_change ((BudgieMainView*) self);
}

BudgieMainView*
budgie_main_view_construct (GType object_type)
{
	BudgieMainView * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkBox* header = NULL;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStack* _tmp5_;
	GtkStack* _tmp6_;
	GtkStackSwitcher* _tmp7_;
	GtkStackSwitcher* _tmp8_;
	GtkStackSwitcher* _tmp9_;
	GtkStackSwitcher* _tmp10_;
	GtkStackSwitcher* _tmp11_;
	GtkStackSwitcher* _tmp12_;
	GtkStack* _tmp13_;
	GtkStackSwitcher* _tmp14_;
	GtkStack* _tmp15_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp16_;
	GtkStack* _tmp17_;
	BudgieNotificationsView* not = NULL;
	BudgieNotificationsView* _tmp18_;
	GtkStack* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GSettings* _tmp22_;
	CalendarWidget* _tmp23_;
	GtkBox* _tmp24_;
	CalendarWidget* _tmp25_;
	BudgieSoundWidget* _tmp26_;
	GtkBox* _tmp27_;
	BudgieSoundWidget* _tmp28_;
	BudgieSoundWidget* _tmp29_;
	GtkBox* _tmp30_;
	BudgieSoundWidget* _tmp31_;
	MprisWidget* _tmp32_;
	GtkBox* _tmp33_;
	MprisWidget* _tmp34_;
	GtkStack* _tmp35_;
	self = (BudgieMainView*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_tmp0_ = g_settings_new ("com.solus-project.budgie-raven");
	_g_object_unref0 (self->priv->raven_settings);
	self->priv->raven_settings = _tmp0_;
	_tmp1_ = self->priv->raven_settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _budgie_main_view_on_raven_settings_changed_g_settings_changed, self, 0);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	header = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_add_class (_tmp3_, "raven-header");
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_add_class (_tmp4_, "top");
	_tmp5_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp5_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) header, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp7_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->switcher);
	self->priv->switcher = _tmp7_;
	_tmp8_ = self->priv->switcher;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = self->priv->switcher;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp9_, 4);
	_tmp10_ = self->priv->switcher;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, 4);
	_tmp11_ = self->priv->switcher;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = self->priv->switcher;
	_tmp13_ = self->priv->main_stack;
	gtk_stack_switcher_set_stack (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->switcher;
	gtk_box_pack_start (header, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	_tmp15_ = self->priv->main_stack;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
	_tmp16_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp16_);
	scroll = _tmp16_;
	_tmp17_ = self->priv->main_stack;
	gtk_stack_add_titled (_tmp17_, (GtkWidget*) scroll, "applets", _ ("Applets"));
	_tmp18_ = budgie_notifications_view_new ();
	g_object_ref_sink (_tmp18_);
	not = _tmp18_;
	_tmp19_ = self->priv->main_stack;
	gtk_stack_add_titled (_tmp19_, (GtkWidget*) not, "notifications", _ ("Notifications"));
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp20_;
	_tmp21_ = self->priv->box;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->raven_settings;
	_tmp23_ = calendar_widget_new (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->cal);
	self->priv->cal = _tmp23_;
	_tmp24_ = self->priv->box;
	_tmp25_ = self->priv->cal;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	_tmp26_ = budgie_sound_widget_new ("output");
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->audio_output_widget);
	self->priv->audio_output_widget = _tmp26_;
	_tmp27_ = self->priv->box;
	_tmp28_ = self->priv->audio_output_widget;
	gtk_box_pack_start (_tmp27_, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
	_tmp29_ = budgie_sound_widget_new ("input");
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->audio_input_widget);
	self->priv->audio_input_widget = _tmp29_;
	_tmp30_ = self->priv->box;
	_tmp31_ = self->priv->audio_input_widget;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
	_tmp32_ = mpris_widget_new ();
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->mpris);
	self->priv->mpris = _tmp32_;
	_tmp33_ = self->priv->box;
	_tmp34_ = self->priv->mpris;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) scroll);
	_tmp35_ = self->priv->main_stack;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::visible-child-name", (GCallback) _budgie_main_view_on_name_change_g_object_notify, self, 0);
	budgie_main_view_set_clean (self);
	budgie_main_view_set_sound_widget_events (self);
	_g_object_unref0 (not);
	_g_object_unref0 (scroll);
	_g_object_unref0 (header);
	return self;
}

BudgieMainView*
budgie_main_view_new (void)
{
	return budgie_main_view_construct (BUDGIE_TYPE_MAIN_VIEW);
}

static void
__lambda45_ (BudgieMainView* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->SHOW_SOUND_OUTPUT_WIDGET;
	budgie_main_view_on_raven_settings_changed (self, _tmp0_);
}

static void
___lambda45__budgie_sound_widget_devices_state_changed (BudgieSoundWidget* _sender,
                                                        gpointer self)
{
	__lambda45_ ((BudgieMainView*) self);
}

static void
__lambda46_ (BudgieMainView* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->SHOW_MIC_INPUT_WIDGET;
	budgie_main_view_on_raven_settings_changed (self, _tmp0_);
}

static void
___lambda46__budgie_sound_widget_devices_state_changed (BudgieSoundWidget* _sender,
                                                        gpointer self)
{
	__lambda46_ ((BudgieMainView*) self);
}

static void
budgie_main_view_set_sound_widget_events (BudgieMainView* self)
{
	BudgieSoundWidget* _tmp0_;
	BudgieSoundWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->audio_output_widget;
	g_signal_connect_object (_tmp0_, "devices-state-changed", (GCallback) ___lambda45__budgie_sound_widget_devices_state_changed, self, 0);
	_tmp1_ = self->priv->audio_input_widget;
	g_signal_connect_object (_tmp1_, "devices-state-changed", (GCallback) ___lambda46__budgie_sound_widget_devices_state_changed, self, 0);
}

static void
budgie_main_view_on_name_change (BudgieMainView* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "notifications") == 0) {
		BudgieRaven* _tmp2_;
		_tmp2_ = budgie_raven_get_instance ();
		budgie_raven_ReadNotifications (_tmp2_);
	}
}

/**
* on_raven_settings_changed will handle when the settings for Raven widgets have changed
*/
static void
budgie_main_view_on_raven_settings_changed (BudgieMainView* self,
                                            const gchar* key)
{
	gboolean show_widget = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "raven-position") == 0) {
		return;
	}
	_tmp0_ = self->priv->raven_settings;
	show_widget = g_settings_get_boolean (_tmp0_, key);
	if (g_strcmp0 (key, "show-calendar-widget") == 0) {
		CalendarWidget* _tmp1_;
		_tmp1_ = self->priv->cal;
		raven_widget_set_show ((RavenWidget*) _tmp1_, show_widget);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->SHOW_SOUND_OUTPUT_WIDGET;
		if (g_strcmp0 (key, _tmp2_) == 0) {
			BudgieSoundWidget* _tmp3_;
			_tmp3_ = self->priv->audio_output_widget;
			if (budgie_sound_widget_has_devices (_tmp3_)) {
				BudgieSoundWidget* _tmp4_;
				_tmp4_ = self->priv->audio_output_widget;
				raven_widget_set_show ((RavenWidget*) _tmp4_, show_widget);
			} else {
				BudgieSoundWidget* _tmp5_;
				_tmp5_ = self->priv->audio_output_widget;
				raven_widget_set_show ((RavenWidget*) _tmp5_, FALSE);
			}
		} else {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->SHOW_MIC_INPUT_WIDGET;
			if (g_strcmp0 (key, _tmp6_) == 0) {
				BudgieSoundWidget* _tmp7_;
				_tmp7_ = self->priv->audio_input_widget;
				if (budgie_sound_widget_has_devices (_tmp7_)) {
					BudgieSoundWidget* _tmp8_;
					_tmp8_ = self->priv->audio_input_widget;
					raven_widget_set_show ((RavenWidget*) _tmp8_, show_widget);
				} else {
					BudgieSoundWidget* _tmp9_;
					_tmp9_ = self->priv->audio_input_widget;
					raven_widget_set_show ((RavenWidget*) _tmp9_, FALSE);
				}
			} else {
				if (g_strcmp0 (key, "show-mpris-widget") == 0) {
					MprisWidget* _tmp10_;
					_tmp10_ = self->priv->mpris;
					raven_widget_set_show ((RavenWidget*) _tmp10_, show_widget);
				}
			}
		}
	}
	g_signal_emit (self, budgie_main_view_signals[BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL], 0);
}

void
budgie_main_view_set_clean (BudgieMainView* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkStack* _tmp2_;
	g_return_if_fail (self != NULL);
	budgie_main_view_on_raven_settings_changed (self, "show-calendar-widget");
	_tmp0_ = self->priv->SHOW_SOUND_OUTPUT_WIDGET;
	budgie_main_view_on_raven_settings_changed (self, _tmp0_);
	_tmp1_ = self->priv->SHOW_MIC_INPUT_WIDGET;
	budgie_main_view_on_raven_settings_changed (self, _tmp1_);
	budgie_main_view_on_raven_settings_changed (self, "show-mpris-widget");
	_tmp2_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp2_, "applets");
}

static void
budgie_main_view_class_init (BudgieMainViewClass * klass,
                             gpointer klass_data)
{
	budgie_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieMainView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_main_view_finalize;
	budgie_main_view_signals[BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL] = g_signal_new ("requested-draw", BUDGIE_TYPE_MAIN_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_main_view_instance_init (BudgieMainView * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = budgie_main_view_get_instance_private (self);
	self->priv->box = NULL;
	self->priv->mpris = NULL;
	self->priv->cal = NULL;
	self->priv->audio_input_widget = NULL;
	self->priv->audio_output_widget = NULL;
	self->priv->raven_settings = NULL;
	self->priv->main_stack = NULL;
	self->priv->switcher = NULL;
	_tmp0_ = g_strdup ("show-sound-output-widget");
	self->priv->SHOW_SOUND_OUTPUT_WIDGET = _tmp0_;
	_tmp1_ = g_strdup ("show-mic-input-widget");
	self->priv->SHOW_MIC_INPUT_WIDGET = _tmp1_;
}

static void
budgie_main_view_finalize (GObject * obj)
{
	BudgieMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_MAIN_VIEW, BudgieMainView);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->mpris);
	_g_object_unref0 (self->priv->cal);
	_g_object_unref0 (self->priv->audio_input_widget);
	_g_object_unref0 (self->priv->audio_output_widget);
	_g_object_unref0 (self->priv->raven_settings);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->switcher);
	_g_free0 (self->priv->SHOW_SOUND_OUTPUT_WIDGET);
	_g_free0 (self->priv->SHOW_MIC_INPUT_WIDGET);
	G_OBJECT_CLASS (budgie_main_view_parent_class)->finalize (obj);
}

static GType
budgie_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMainView), 0, (GInstanceInitFunc) budgie_main_view_instance_init, NULL };
	GType budgie_main_view_type_id;
	budgie_main_view_type_id = g_type_register_static (gtk_box_get_type (), "BudgieMainView", &g_define_type_info, 0);
	BudgieMainView_private_offset = g_type_add_instance_private (budgie_main_view_type_id, sizeof (BudgieMainViewPrivate));
	return budgie_main_view_type_id;
}

GType
budgie_main_view_get_type (void)
{
	static volatile gsize budgie_main_view_type_id__once = 0;
	if (g_once_init_enter (&budgie_main_view_type_id__once)) {
		GType budgie_main_view_type_id;
		budgie_main_view_type_id = budgie_main_view_get_type_once ();
		g_once_init_leave (&budgie_main_view_type_id__once, budgie_main_view_type_id);
	}
	return budgie_main_view_type_id__once;
}

