/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import net.sf.sdedit.ui.components.HelpPanel;
import net.sf.sdedit.util.UIUtilities;
import net.sf.sdedit.util.Utilities;

public class AboutDialog
extends JDialog {
    private String text;
    private JEditorPane editorPane;

    public AboutDialog(JFrame frame, URL aboutURL, String title) {
        super(frame);
        this.getContentPane().setLayout(new BorderLayout());
        try {
            this.text = Utilities.toString(aboutURL, Charset.forName("utf-8"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot read about text from " + aboutURL);
        }
        this.text = Utilities.unixEncode(this.text);
        this.showPanel();
        this.setModal(true);
        this.setTitle(title);
        this.pack();
        UIUtilities.centerWindow(this);
    }

    private void showPanel() {
        String text = this.text;
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        double used = 1.0 * (double)(total - free) / 1048576.0;
        double avail = 1.0 * (double)(max - total + free) / 1048576.0;
        DecimalFormat format = new DecimalFormat("####.#");
        String _used = format.format(used);
        String _avail = format.format(avail);
        String _version = System.getProperty("java.version") + " (" + System.getProperty("os.name") + ")";
        text = text.replaceFirst("_USED_", _used + " MB");
        text = text.replaceFirst("_AVAIL_", _avail + " MB");
        text = text.replaceFirst("_JAVA_", _version);
        if (this.editorPane != null) {
            this.getContentPane().remove(this.editorPane);
        }
        this.editorPane = new HelpPanel(text).getPane();
        this.editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    AboutDialog.this.setVisible(false);
                    AboutDialog.this.dispose();
                }
            }
        });
        this.getContentPane().add((Component)this.editorPane, "Center");
        this.editorPane.revalidate();
    }
}

