
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "datapaths_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DataPaths_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DataPaths >()))
        return -1;

    ::DataPaths *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // DataPaths()
            cptr = new ::DataPaths();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DataPaths >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_DataPathsFunc_allPaths(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.allPaths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DataPaths::allPaths(DataPaths::Path)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX])->converter, (pyArg)))) {
        overloadId = 0; // allPaths(DataPaths::Path)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DataPathsFunc_allPaths_TypeError;

    // Call function/method
    {
        ::DataPaths::Path cppArg0{DataPaths::AppData};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // allPaths(DataPaths::Path)
            QStringList cppResult = ::DataPaths::allPaths(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_DataPathsFunc_allPaths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_DataPathsFunc_currentProfilePath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.currentProfilePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentProfilePath()
            QString cppResult = ::DataPaths::currentProfilePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DataPathsFunc_locate(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.locate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "locate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static DataPaths::locate(DataPaths::Path,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // locate(DataPaths::Path,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DataPathsFunc_locate_TypeError;

    // Call function/method
    {
        ::DataPaths::Path cppArg0{DataPaths::AppData};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // locate(DataPaths::Path,QString)
            QString cppResult = ::DataPaths::locate(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_DataPathsFunc_locate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_DataPathsFunc_path(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.path";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DataPaths::path(DataPaths::Path)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX])->converter, (pyArg)))) {
        overloadId = 0; // path(DataPaths::Path)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DataPathsFunc_path_TypeError;

    // Call function/method
    {
        ::DataPaths::Path cppArg0{DataPaths::AppData};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // path(DataPaths::Path)
            QString cppResult = ::DataPaths::path(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_DataPathsFunc_path_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_DataPathsFunc_setCurrentProfilePath(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.setCurrentProfilePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DataPaths::setCurrentProfilePath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCurrentProfilePath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DataPathsFunc_setCurrentProfilePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentProfilePath(QString)
            ::DataPaths::setCurrentProfilePath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_DataPathsFunc_setCurrentProfilePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_DataPathsFunc_setPortableVersion(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DataPaths.setPortableVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setPortableVersion()
            ::DataPaths::setPortableVersion();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_DataPaths_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DataPaths_methods[] = {
    {"allPaths", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_allPaths), METH_O|METH_STATIC},
    {"currentProfilePath", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_currentProfilePath), METH_NOARGS|METH_STATIC},
    {"locate", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_locate), METH_VARARGS|METH_STATIC},
    {"path", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_path), METH_O|METH_STATIC},
    {"setCurrentProfilePath", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_setCurrentProfilePath), METH_O|METH_STATIC},
    {"setPortableVersion", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_setPortableVersion), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_DataPaths_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_DataPaths_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_DataPaths_Type = nullptr;
static SbkObjectType *Sbk_DataPaths_TypeF(void)
{
    return _Sbk_DataPaths_Type;
}

static PyType_Slot Sbk_DataPaths_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DataPaths_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DataPaths_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DataPaths_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DataPaths_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_DataPaths_spec = {
    "1:PyFalkon.DataPaths",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_DataPaths_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void DataPaths_Path_PythonToCpp_DataPaths_Path(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::DataPaths::Path *>(cppOut) =
        static_cast<::DataPaths::Path>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_DataPaths_Path_PythonToCpp_DataPaths_Path_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX]))
        return DataPaths_Path_PythonToCpp_DataPaths_Path;
    return {};
}
static PyObject *DataPaths_Path_CppToPython_DataPaths_Path(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::DataPaths::Path *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DataPaths_PythonToCpp_DataPaths_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_DataPaths_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DataPaths_PythonToCpp_DataPaths_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_DataPaths_TypeF())))
        return DataPaths_PythonToCpp_DataPaths_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DataPaths_PTR_CppToPython_DataPaths(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::DataPaths *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_DataPaths_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *DataPaths_SignatureStrings[] = {
    "PyFalkon.DataPaths(self)",
    "PyFalkon.DataPaths.allPaths(type:PyFalkon.DataPaths.Path)->QStringList",
    "PyFalkon.DataPaths.currentProfilePath()->QString",
    "PyFalkon.DataPaths.locate(type:PyFalkon.DataPaths.Path,file:QString)->QString",
    "PyFalkon.DataPaths.path(type:PyFalkon.DataPaths.Path)->QString",
    "PyFalkon.DataPaths.setCurrentProfilePath(profilePath:QString)",
    "PyFalkon.DataPaths.setPortableVersion()",
    nullptr}; // Sentinel

void init_DataPaths(PyObject *module)
{
    _Sbk_DataPaths_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DataPaths",
        "DataPaths*",
        &Sbk_DataPaths_spec,
        &Shiboken::callCppDestructor< ::DataPaths >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_DataPaths_Type);
    InitSignatureStrings(pyType, DataPaths_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_DataPaths_Type), Sbk_DataPaths_PropertyStrings);
    SbkPyFalkonTypes[SBK_DATAPATHS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_DataPaths_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_DataPaths_TypeF(),
        DataPaths_PythonToCpp_DataPaths_PTR,
        is_DataPaths_PythonToCpp_DataPaths_PTR_Convertible,
        DataPaths_PTR_CppToPython_DataPaths);

    Shiboken::Conversions::registerConverterName(converter, "DataPaths");
    Shiboken::Conversions::registerConverterName(converter, "DataPaths*");
    Shiboken::Conversions::registerConverterName(converter, "DataPaths&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DataPaths).name());


    // Initialization of enums.

    // Initialization of enum 'Path'.
    SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX] = Shiboken::Enum::createScopedEnum(Sbk_DataPaths_TypeF(),
        "Path",
        "1:PyFalkon.DataPaths.Path",
        "DataPaths::Path");
    if (!SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "AppData", (long) DataPaths::Path::AppData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Themes", (long) DataPaths::Path::Themes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Plugins", (long) DataPaths::Path::Plugins))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Config", (long) DataPaths::Path::Config))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Profiles", (long) DataPaths::Path::Profiles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "CurrentProfile", (long) DataPaths::Path::CurrentProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Temp", (long) DataPaths::Path::Temp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Cache", (long) DataPaths::Path::Cache))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "Sessions", (long) DataPaths::Path::Sessions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
        Sbk_DataPaths_TypeF(), "LastPath", (long) DataPaths::Path::LastPath))
        return;
    // Register converter for enum 'DataPaths::Path'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX],
            DataPaths_Path_CppToPython_DataPaths_Path);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            DataPaths_Path_PythonToCpp_DataPaths_Path,
            is_DataPaths_Path_PythonToCpp_DataPaths_Path_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_DATAPATHS_PATH_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "DataPaths::Path");
        Shiboken::Conversions::registerConverterName(converter, "Path");
    }
    // End of 'Path' enum.

    qRegisterMetaType< ::DataPaths::Path >("DataPaths::Path");
}
