/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Timer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Lookup;

public abstract class HeapFragment {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final Heap heap;

    public HeapFragment(String id, String name, String description, Heap heap) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.heap = heap;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public static void setProgress(final ProgressHandle pHandle, final int offset) {
        Timer[] timer;
        final long progressId = HeapProgress.getProgressId();
        timer = new Timer[]{new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = HeapProgress.getProgressValue((long)progressId);
                if (value >= 0) {
                    pHandle.progress(value + offset);
                } else {
                    timer[0].stop();
                }
            }
        })};
        timer[0].start();
    }

    public static abstract class Provider {
        public abstract List<HeapFragment> getFragments(File var1, Lookup.Provider var2, Heap var3) throws IOException;
    }
}

