import { RemoteRoom } from "matrix-appservice-bridge";
import { IrcServer } from "../irc/IrcServer";
export declare class IrcRoom extends RemoteRoom {
    readonly server: IrcServer;
    readonly channel: string;
    /**
     * Construct a new IRC room.
     * @constructor
     * @param {IrcServer} server : The IRC server which contains this room.
     * @param {String} channel : The channel this room represents.
     */
    constructor(server: IrcServer, channel: string);
    getDomain(): string;
    getServer(): IrcServer;
    getChannel(): string;
    getType(): "channel" | "pm";
    static fromRemoteRoom(server: IrcServer, remoteRoom: RemoteRoom): IrcRoom;
    static createId(server: {
        domain: string;
    }, channel: string): string;
}
