/**
 * @fileoverview Rule to flag use of with statement
 * @author Nicholas C. Zakas
 */

"use strict";

//------------------------------------------------------------------------------
// Rule Definition
//------------------------------------------------------------------------------

/** @type {import('../shared/types').Rule} */
module.exports = {
    meta: {
        type: "suggestion",

        docs: {
            description: "disallow `with` statements",
            recommended: true,
            url: "https://eslint.org/docs/rules/no-with"
        },

        schema: [],

        messages: {
            unexpectedWith: "Unexpected use of 'with' statement."
        }
    },

    create(context) {

        return {
            WithStatement(node) {
                context.report({ node, messageId: "unexpectedWith" });
            }
        };

    }
};
