"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const logging_1 = __importDefault(require("../components/logging"));
const crypto_1 = __importDefault(require("crypto"));
class ProvisioningRequest {
    constructor(expressReq, userId, requestSource, widgetToken, fnName) {
        this.expressReq = expressReq;
        this.userId = userId;
        this.requestSource = requestSource;
        this.widgetToken = widgetToken;
        this.fnName = fnName;
        this.id = crypto_1.default.randomBytes(4).toString('hex');
        this.fnName = fnName || expressReq.path;
        this.log = logging_1.default.get(`ProvisionRequest ${[this.id, fnName].filter(n => !!n).join(" ")}`);
        this.log.info(`New request from ${userId} via ${requestSource}`);
    }
    getId() {
        return this.id;
    }
    get body() {
        return this.expressReq.body;
    }
    get params() {
        return this.expressReq.params;
    }
}
exports.default = ProvisioningRequest;
//# sourceMappingURL=request.js.map