# Copyright: (c) 2022, Jordan Borean (@jborean93) <jborean93@gmail.com>
# MIT License (see LICENSE or https://opensource.org/licenses/MIT)

import typing as t

class ClientContextAttr:
    delegate: int = ...
    mutual_auth: int = ...
    replay_detect: int = ...
    sequence_detect: int = ...
    confidentiality: int = ...
    use_session_key: int = ...
    used_collected_creds: int = ...
    used_supplied_creds: int = ...
    allocated_memory: int = ...
    used_dce_style: int = ...
    datagram: int = ...
    connection: int = ...
    intermediate_return: int = ...
    call_level: int = ...
    extended_error: int = ...
    stream: int = ...
    integrity: int = ...
    identify: int = ...
    null_session: int = ...
    manual_cred_validation: int = ...
    fragment_only: int = ...
    forward_credentials: int = ...
    used_http_style: int = ...
    no_additional_token: int = ...
    reauthentication: int = ...

class ClientContextReq:
    allocate_memory: int = ...
    confidentiality: int = ...
    connection: int = ...
    delegate: int = ...
    extended_error: int = ...
    http: int = ...
    integrity: int = ...
    identify: int = ...
    manual_cred_validation: int = ...
    mutual_auth: int = ...
    no_integrity: int = ...
    replay_detect: int = ...
    sequence_detect: int = ...
    stream: int = ...
    use_session_key: int = ...
    use_supplied_creds: int = ...

class CredentialUse:
    inbound: int = ...
    outbound: int = ...
    both: int = ...

class SecBufferType:
    empty: int = ...
    data: int = ...
    token: int = ...
    pkg_params: int = ...
    missing: int = ...
    extra: int = ...
    stream_trailer: int = ...
    stream_header: int = ...
    negotiation_info: int = ...
    padding: int = ...
    stream: int = ...
    mechlist: int = ...
    mechlist_signature: int = ...
    target: int = ...
    channel_bindings: int = ...
    change_pass_response: int = ...
    target_host: int = ...
    attrmask: int = ...
    readonly: int = ...
    readonly_with_checksum: int = ...
    reserved: int = ...

class SecPkgAttr:
    names: int = ...
    package_info: int = ...
    session_key: int = ...
    sizes: int = ...

class SecStatus:
    SEC_E_BUFFER_TOO_SMALL: int = ...
    SEC_E_CONTEXT_EXPIRED: int = ...
    SEC_E_CRYPTO_SYSTEM_INVALID: int = ...
    SEC_E_INCOMPLETE_MESSAGE: int = ...
    SEC_E_INSUFFICIENT_MEMORY: int = ...
    SEC_E_INTERNAL_ERROR: int = ...
    SEC_E_INVALID_HANDLE: int = ...
    SEC_E_INVALID_TOKEN: int = ...
    SEC_E_LOGON_DENIED: int = ...
    SEC_E_MESSAGE_ALTERED: int = ...
    SEC_E_NOT_OWNER: int = ...
    SEC_E_NO_AUTHENTICATING_AUTHORITY: int = ...
    SEC_E_NO_CREDENTIALS: int = ...
    SEC_E_OK: int = ...
    SEC_E_OUT_OF_SEQUENCE: int = ...
    SEC_E_QOP_NOT_SUPPORTED: int = ...
    SEC_E_SECPKG_NOT_FOUND: int = ...
    SEC_E_TARGET_UNKNOWN: int = ...
    SEC_E_UNKNOWN_CREDENTIALS: int = ...
    SEC_E_UNSUPPORTED_FUNCTION: int = ...
    SEC_E_WRONG_PRINCIPAL: int = ...
    SEC_I_COMPLETE_AND_CONTINUE: int = ...
    SEC_I_COMPLETE_NEEDED: int = ...
    SEC_I_CONTINUE_NEEDED: int = ...
    SEC_I_INCOMPLETE_CREDENTIALS: int = ...

class ServerContextAttr:
    delegate: int = ...
    mutual_auth: int = ...
    replay_detect: int = ...
    sequence_detect: int = ...
    confidentiality: int = ...
    use_session_key: int = ...
    allocated_memory: int = ...
    used_dce_style: int = ...
    datagram: int = ...
    connection: int = ...
    call_level: int = ...
    third_leg_failed: int = ...
    extended_error: int = ...
    stream: int = ...
    integrity: int = ...
    licensing: int = ...
    identify: int = ...
    null_session: int = ...
    allow_non_user_logons: int = ...
    allow_context_replay: int = ...
    fragment_only: int = ...
    no_token: int = ...
    no_additional_token: int = ...

class ServerContextReq:
    delegate: int = ...
    mutual_auth: int = ...
    replay_detect: int = ...
    sequence_detect: int = ...
    confidentiality: int = ...
    use_session_key: int = ...
    allocate_memory: int = ...
    use_dce_style: int = ...
    datagram: int = ...
    connection: int = ...
    call_level: int = ...
    fragment_supplied: int = ...
    extended_error: int = ...
    stream: int = ...
    integrity: int = ...
    licensing: int = ...
    identify: int = ...
    allow_null_session: int = ...
    allow_non_user_logons: int = ...
    allow_context_replay: int = ...
    fragment_to_fit: int = ...
    no_token: int = ...
    proxy_bindings: int = ...
    allow_missing_binding: int = ...

class SSPIQoP:
    wrap_no_encrypt: int = ...

class TargetDataRep:
    native: int = ...
    network: int = ...

class SecPkgAttrSizes(t.NamedTuple):
    max_token: int
    max_signature: int
    block_size: int
    security_trailer: int

class SecPkgInfo(t.NamedTuple):
    capabilities: int
    version: int
    rpcid: int
    max_token: int
    name: str
    comment: str

class Credential:
    expiry: int

class SecurityContext:
    context_attr: int
    expiry: int
    init: int

class SecBufferDesc:
    def __new__(
        cls,
        buffer_count: int,
        version: int = 0,
    ) -> "SecBufferDesc": ...
    def __len__(self) -> int: ...
    def __getitem__(
        self,
        key: int,
    ) -> SecBuffer: ...
    def __iter__(self) -> t.Iterator[SecBuffer]: ...
    @property
    def version(self) -> int: ...
    @version.setter
    def version(
        self,
        value: int,
    ) -> None: ...

class SecBuffer:
    def __len__(self) -> int: ...
    @property
    def buffer_type(self) -> int: ...
    @buffer_type.setter
    def buffer_type(
        self,
        value: int,
    ) -> None: ...
    @property
    def buffer(self) -> t.Optional[bytes]: ...
    @buffer.setter
    def buffer(
        self,
        value: t.Optional[bytearray],
    ) -> None: ...
    def free(self) -> None: ...

class _AuthIdentityBase: ...

class WinNTAuthIdentity(_AuthIdentityBase):

    username: t.Optional[str]
    domain: t.Optional[str]
    password: t.Optional[str]

    def __new__(
        cls,
        username: t.Optional[str],
        domain: t.Optional[str],
        password: t.Optional[str],
    ) -> "WinNTAuthIdentity": ...

def accept_security_context(
    credential: Credential,
    context: SecurityContext,
    input_buffer: t.Optional[SecBufferDesc] = None,
    context_req: int = 0,
    target_data_rep: int = 16,
    output_buffer: t.Optional[SecBufferDesc] = None,
) -> int: ...
def acquire_credentials_handle(
    principal: t.Optional[str],
    package: str,
    credential_use: int = 2,
    auth_data: t.Optional[_AuthIdentityBase] = None,
) -> Credential: ...
def decrypt_message(
    context: SecurityContext,
    message: SecBufferDesc,
    seq_no: int = 0,
) -> int: ...
def encrypt_message(
    context: SecurityContext,
    message: SecBufferDesc,
    seq_no: int = 0,
    qop: int = 0,
) -> None: ...
def initialize_security_context(
    credential: Credential,
    context: SecurityContext,
    target_name: str,
    context_req: int = 0,
    input_buffer: t.Optional[SecBufferDesc] = None,
    target_data_rep: int = 16,
    output_buffer: t.Optional[SecBufferDesc] = None,
) -> int: ...
def make_signature(
    context: SecurityContext,
    qop: int,
    message: SecBufferDesc,
    seq_no: int = 0,
) -> None: ...
def query_context_attributes(
    context: SecurityContext,
    attribute: int,
) -> t.Union[bytes, str, SecPkgInfo, SecPkgAttrSizes]: ...
def verify_signature(
    context: SecurityContext,
    message: SecBufferDesc,
    seq_no: int = 0,
) -> int: ...
