/* book-view.c generated by valac 0.56.0, the Vala compiler
 * generated from book-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* FIXME: When scrolling, copy existing render sideways?*/
/* FIXME: Only render pages that change and only the part that changed*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;
typedef struct _BookViewPrivate BookViewPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
enum  {
	BOOK_VIEW_0_PROPERTY,
	BOOK_VIEW_BOOK_PROPERTY,
	BOOK_VIEW_SELECTED_PAGE_PROPERTY,
	BOOK_VIEW_X_OFFSET_PROPERTY,
	BOOK_VIEW_NUM_PROPERTIES
};
static GParamSpec* book_view_properties[BOOK_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	BOOK_VIEW_PAGE_SELECTED_SIGNAL,
	BOOK_VIEW_SHOW_PAGE_SIGNAL,
	BOOK_VIEW_SHOW_MENU_SIGNAL,
	BOOK_VIEW_NUM_SIGNALS
};
static guint book_view_signals[BOOK_VIEW_NUM_SIGNALS] = {0};

struct _BookView {
	GtkBox parent_instance;
	BookViewPrivate * priv;
};

struct _BookViewClass {
	GtkBoxClass parent_class;
};

struct _BookViewPrivate {
	Book* _book;
	GHashTable* page_data;
	gboolean need_layout;
	gboolean laying_out;
	gboolean show_selected_page;
	PageView* selected_page_view;
	GtkWidget* drawing_area;
	GtkScrollbar* scroll;
	GtkAdjustment* adjustment;
	GdkCursorType cursor;
};

static gint BookView_private_offset;
static gpointer book_view_parent_class = NULL;

VALA_EXTERN GType book_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookView, g_object_unref)
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType page_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageView, g_object_unref)
VALA_EXTERN Book* book_view_get_book (BookView* self);
static void book_view_add_cb (BookView* self,
                       Book* book,
                       Page* page);
static void _book_view_add_cb_book_page_added (Book* _sender,
                                        Page* page,
                                        gpointer self);
static void book_view_remove_cb (BookView* self,
                          Book* book,
                          Page* page);
static void _book_view_remove_cb_book_page_removed (Book* _sender,
                                             Page* page,
                                             gpointer self);
static void book_view_reorder_cb (BookView* self,
                           Book* book);
static void _book_view_reorder_cb_book_reordered (Book* _sender,
                                           gpointer self);
static void book_view_clear_cb (BookView* self,
                         Book* book);
static void _book_view_clear_cb_book_cleared (Book* _sender,
                                       gpointer self);
static gboolean book_view_configure_cb (BookView* self,
                                 GtkWidget* widget,
                                 GdkEventConfigure* event);
static gboolean _book_view_configure_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                             GdkEventConfigure* event,
                                                             gpointer self);
static gboolean book_view_draw_cb (BookView* self,
                            GtkWidget* widget,
                            cairo_t* context);
static gboolean _book_view_draw_cb_gtk_widget_draw (GtkWidget* _sender,
                                             cairo_t* cr,
                                             gpointer self);
static gboolean book_view_motion_cb (BookView* self,
                              GtkWidget* widget,
                              GdkEventMotion* event);
static gboolean _book_view_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                              GdkEventMotion* event,
                                                              gpointer self);
static gboolean book_view_key_cb (BookView* self,
                           GtkWidget* widget,
                           GdkEventKey* event);
static gboolean _book_view_key_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                       GdkEventKey* event,
                                                       gpointer self);
static gboolean book_view_button_cb (BookView* self,
                              GtkWidget* widget,
                              GdkEventButton* event);
static gboolean _book_view_button_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self);
static gboolean _book_view_button_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                               GdkEventButton* event,
                                                               gpointer self);
static gboolean book_view_focus_cb (BookView* self,
                             GtkWidget* widget,
                             GdkEventFocus* event);
static gboolean _book_view_focus_cb_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                        GdkEventFocus* event,
                                                        gpointer self);
static gboolean _book_view_focus_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                         GdkEventFocus* event,
                                                         gpointer self);
static void book_view_scroll_cb (BookView* self,
                          GtkAdjustment* adjustment);
static void _book_view_scroll_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                        gpointer self);
VALA_EXTERN BookView* book_view_new (Book* book);
VALA_EXTERN BookView* book_view_construct (GType object_type,
                               Book* book);
static void book_view_set_book (BookView* self,
                         Book* value);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN void book_view_set_selected_page (BookView* self,
                                  Page* value);
static void _g_object_unref0_ (gpointer var);
static PageView* book_view_get_nth_page (BookView* self,
                                  gint n);
static PageView* book_view_get_next_page (BookView* self,
                                   PageView* page);
VALA_EXTERN Page* page_view_get_page (PageView* self);
static PageView* book_view_get_prev_page (BookView* self,
                                   PageView* page);
static void book_view_page_view_changed_cb (BookView* self,
                                     PageView* page);
VALA_EXTERN void book_view_redraw (BookView* self);
static void book_view_page_view_size_changed_cb (BookView* self,
                                          PageView* page);
VALA_EXTERN PageView* page_view_new (Page* page);
VALA_EXTERN PageView* page_view_construct (GType object_type,
                               Page* page);
static void _book_view_page_view_changed_cb_page_view_changed (PageView* _sender,
                                                        gpointer self);
static void _book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender,
                                                                  gpointer self);
static void book_view_set_selected_page_view (BookView* self,
                                       PageView* page);
VALA_EXTERN void page_view_set_selected (PageView* self,
                             gboolean value);
static void book_view_show_page_view (BookView* self,
                               PageView* page);
VALA_EXTERN gint page_view_get_x_offset (PageView* self);
VALA_EXTERN gint page_view_get_width (PageView* self);
VALA_EXTERN gint book_view_get_x_offset (BookView* self);
VALA_EXTERN void book_view_set_x_offset (BookView* self,
                             gint value);
static void book_view_select_page_view (BookView* self,
                                 PageView* page);
VALA_EXTERN Page* book_view_get_selected_page (BookView* self);
static void book_view_layout_into (BookView* self,
                            gint width,
                            gint height,
                            gint* book_width,
                            gint* book_height);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN void page_view_set_width (PageView* self,
                          gint value);
VALA_EXTERN void page_view_set_height (PageView* self,
                           gint value);
VALA_EXTERN gint page_view_get_height (PageView* self);
VALA_EXTERN void page_view_set_x_offset (PageView* self,
                             gint value);
VALA_EXTERN void page_view_set_y_offset (PageView* self,
                             gint value);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void book_view_layout (BookView* self);
VALA_EXTERN void page_view_render (PageView* self,
                       cairo_t* context,
                       GdkRGBA* ruler_color);
VALA_EXTERN gboolean page_view_get_selected (PageView* self);
VALA_EXTERN gint page_view_get_y_offset (PageView* self);
static PageView* book_view_get_page_at (BookView* self,
                                 gint x,
                                 gint y,
                                 gint* x_,
                                 gint* y_);
VALA_EXTERN void page_view_button_press (PageView* self,
                             gint x,
                             gint y);
VALA_EXTERN void page_view_button_release (PageView* self,
                               gint x,
                               gint y);
static void book_view_set_cursor (BookView* self,
                           GdkCursorType cursor);
VALA_EXTERN void page_view_motion (PageView* self,
                       gint x,
                       gint y);
VALA_EXTERN GdkCursorType page_view_get_cursor (PageView* self);
VALA_EXTERN void book_view_select_next_page (BookView* self);
VALA_EXTERN void book_view_select_prev_page (BookView* self);
static void book_view_finalize (GObject * obj);
static GType book_view_get_type_once (void);
static void _vala_book_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_book_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
book_view_get_instance_private (BookView* self)
{
	return G_STRUCT_MEMBER_P (self, BookView_private_offset);
}

static void
_book_view_add_cb_book_page_added (Book* _sender,
                                   Page* page,
                                   gpointer self)
{
	book_view_add_cb ((BookView*) self, _sender, page);
}

static void
_book_view_remove_cb_book_page_removed (Book* _sender,
                                        Page* page,
                                        gpointer self)
{
	book_view_remove_cb ((BookView*) self, _sender, page);
}

static void
_book_view_reorder_cb_book_reordered (Book* _sender,
                                      gpointer self)
{
	book_view_reorder_cb ((BookView*) self, _sender);
}

static void
_book_view_clear_cb_book_cleared (Book* _sender,
                                  gpointer self)
{
	book_view_clear_cb ((BookView*) self, _sender);
}

static gboolean
_book_view_configure_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                    GdkEventConfigure* event,
                                                    gpointer self)
{
	gboolean result;
	result = book_view_configure_cb ((BookView*) self, _sender, event);
	return result;
}

static gboolean
_book_view_draw_cb_gtk_widget_draw (GtkWidget* _sender,
                                    cairo_t* cr,
                                    gpointer self)
{
	gboolean result;
	result = book_view_draw_cb ((BookView*) self, _sender, cr);
	return result;
}

static gboolean
_book_view_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                     GdkEventMotion* event,
                                                     gpointer self)
{
	gboolean result;
	result = book_view_motion_cb ((BookView*) self, _sender, event);
	return result;
}

static gboolean
_book_view_key_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                              GdkEventKey* event,
                                              gpointer self)
{
	gboolean result;
	result = book_view_key_cb ((BookView*) self, _sender, event);
	return result;
}

static gboolean
_book_view_button_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self)
{
	gboolean result;
	result = book_view_button_cb ((BookView*) self, _sender, event);
	return result;
}

static gboolean
_book_view_button_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self)
{
	gboolean result;
	result = book_view_button_cb ((BookView*) self, _sender, event);
	return result;
}

static gboolean
_book_view_focus_cb_gtk_widget_focus_in_event (GtkWidget* _sender,
                                               GdkEventFocus* event,
                                               gpointer self)
{
	gboolean result;
	result = book_view_focus_cb ((BookView*) self, _sender, event);
	return result;
}

static gboolean
_book_view_focus_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                GdkEventFocus* event,
                                                gpointer self)
{
	gboolean result;
	result = book_view_focus_cb ((BookView*) self, _sender, event);
	return result;
}

static void
_book_view_scroll_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                   gpointer self)
{
	book_view_scroll_cb ((BookView*) self, _sender);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BookView*
book_view_construct (GType object_type,
                     Book* book)
{
	BookView * self = NULL;
	Page* _tmp6_;
	Page* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	GtkDrawingArea* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* _tmp16_;
	GtkScrollbar* _tmp17_;
	GtkScrollbar* _tmp18_;
	GtkAdjustment* _tmp19_;
	GtkAdjustment* _tmp20_;
	GtkAdjustment* _tmp21_;
	GtkScrollbar* _tmp22_;
	GtkWidget* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	GtkWidget* _tmp26_;
	GtkWidget* _tmp27_;
	GtkWidget* _tmp28_;
	GtkWidget* _tmp29_;
	GtkWidget* _tmp30_;
	GtkAdjustment* _tmp31_;
	GtkWidget* _tmp32_;
	g_return_val_if_fail (book != NULL, NULL);
	self = (BookView*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	book_view_set_book (self, book);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				Page* page = NULL;
				Page* _tmp4_;
				Page* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = book_get_n_pages (book);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < _tmp3_)) {
					break;
				}
				_tmp4_ = book_get_page (book, i);
				page = _tmp4_;
				_tmp5_ = page;
				book_view_add_cb (self, book, _tmp5_);
				_g_object_unref0 (page);
			}
		}
	}
	_tmp6_ = book_get_page (book, 0);
	_tmp7_ = _tmp6_;
	book_view_set_selected_page (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_signal_connect_object (book, "page-added", (GCallback) _book_view_add_cb_book_page_added, self, 0);
	g_signal_connect_object (book, "page-removed", (GCallback) _book_view_remove_cb_book_page_removed, self, 0);
	g_signal_connect_object (book, "reordered", (GCallback) _book_view_reorder_cb_book_reordered, self, 0);
	g_signal_connect_object (book, "cleared", (GCallback) _book_view_clear_cb_book_cleared, self, 0);
	self->priv->need_layout = TRUE;
	_tmp8_ = g_direct_hash;
	_tmp9_ = g_direct_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->page_data);
	self->priv->page_data = _tmp10_;
	self->priv->cursor = GDK_ARROW;
	_tmp11_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->drawing_area);
	self->priv->drawing_area = (GtkWidget*) _tmp11_;
	_tmp12_ = self->priv->drawing_area;
	gtk_widget_set_size_request (_tmp12_, 200, 100);
	_tmp13_ = self->priv->drawing_area;
	gtk_widget_set_can_focus (_tmp13_, TRUE);
	_tmp14_ = self->priv->drawing_area;
	gtk_widget_set_events (_tmp14_, ((((GDK_POINTER_MOTION_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_FOCUS_CHANGE_MASK) | GDK_STRUCTURE_MASK) | GDK_SCROLL_MASK);
	_tmp15_ = self->priv->drawing_area;
	gtk_widget_set_vexpand (_tmp15_, TRUE);
	_tmp16_ = self->priv->drawing_area;
	gtk_container_add ((GtkContainer*) self, _tmp16_);
	_tmp17_ = (GtkScrollbar*) gtk_scrollbar_new (GTK_ORIENTATION_HORIZONTAL, NULL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->scroll);
	self->priv->scroll = _tmp17_;
	_tmp18_ = self->priv->scroll;
	_tmp19_ = gtk_range_get_adjustment ((GtkRange*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (self->priv->adjustment);
	self->priv->adjustment = _tmp21_;
	_tmp22_ = self->priv->scroll;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp23_, "configure-event", (GCallback) _book_view_configure_cb_gtk_widget_configure_event, self, 0);
	_tmp24_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp24_, "draw", (GCallback) _book_view_draw_cb_gtk_widget_draw, self, 0);
	_tmp25_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp25_, "motion-notify-event", (GCallback) _book_view_motion_cb_gtk_widget_motion_notify_event, self, 0);
	_tmp26_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp26_, "key-press-event", (GCallback) _book_view_key_cb_gtk_widget_key_press_event, self, 0);
	_tmp27_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp27_, "button-press-event", (GCallback) _book_view_button_cb_gtk_widget_button_press_event, self, 0);
	_tmp28_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp28_, "button-release-event", (GCallback) _book_view_button_cb_gtk_widget_button_release_event, self, 0);
	_tmp29_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp29_, "focus-in-event", (GCallback) _book_view_focus_cb_gtk_widget_focus_in_event, self, G_CONNECT_AFTER);
	_tmp30_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp30_, "focus-out-event", (GCallback) _book_view_focus_cb_gtk_widget_focus_out_event, self, G_CONNECT_AFTER);
	_tmp31_ = self->priv->adjustment;
	g_signal_connect_object (_tmp31_, "value-changed", (GCallback) _book_view_scroll_cb_gtk_adjustment_value_changed, self, 0);
	_tmp32_ = self->priv->drawing_area;
	gtk_widget_set_visible (_tmp32_, TRUE);
	return self;
}

BookView*
book_view_new (Book* book)
{
	return book_view_construct (TYPE_BOOK_VIEW, book);
}

static PageView*
book_view_get_nth_page (BookView* self,
                        gint n)
{
	Page* page = NULL;
	Book* _tmp0_;
	Page* _tmp1_;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	PageView* _tmp4_;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	_tmp1_ = book_get_page (_tmp0_, n);
	page = _tmp1_;
	_tmp2_ = self->priv->page_data;
	_tmp3_ = g_hash_table_lookup (_tmp2_, page);
	_tmp4_ = _g_object_ref0 ((PageView*) _tmp3_);
	result = _tmp4_;
	_g_object_unref0 (page);
	return result;
}

static PageView*
book_view_get_next_page (BookView* self,
                         PageView* page)
{
	PageView* _tmp15_;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Page* p = NULL;
				Book* _tmp2_;
				Page* _tmp3_;
				Page* _tmp4_;
				Page* _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_book;
				_tmp3_ = book_get_page (_tmp2_, i);
				p = _tmp3_;
				_tmp4_ = p;
				if (_tmp4_ == NULL) {
					_g_object_unref0 (p);
					break;
				}
				_tmp5_ = p;
				_tmp6_ = page_view_get_page (page);
				_tmp7_ = _tmp6_;
				if (_tmp5_ == _tmp7_) {
					Book* _tmp8_;
					Page* _tmp9_;
					Page* _tmp10_;
					_tmp8_ = self->priv->_book;
					_tmp9_ = book_get_page (_tmp8_, i + 1);
					_g_object_unref0 (p);
					p = _tmp9_;
					_tmp10_ = p;
					if (_tmp10_ != NULL) {
						GHashTable* _tmp11_;
						Page* _tmp12_;
						gconstpointer _tmp13_;
						PageView* _tmp14_;
						_tmp11_ = self->priv->page_data;
						_tmp12_ = p;
						_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
						_tmp14_ = _g_object_ref0 ((PageView*) _tmp13_);
						result = _tmp14_;
						_g_object_unref0 (p);
						return result;
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp15_ = _g_object_ref0 (page);
	result = _tmp15_;
	return result;
}

static PageView*
book_view_get_prev_page (BookView* self,
                         PageView* page)
{
	PageView* prev_page = NULL;
	PageView* _tmp0_;
	PageView* _tmp13_;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = _g_object_ref0 (page);
	prev_page = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Page* p = NULL;
				Book* _tmp3_;
				Page* _tmp4_;
				Page* _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				Page* _tmp8_;
				GHashTable* _tmp9_;
				Page* _tmp10_;
				gconstpointer _tmp11_;
				PageView* _tmp12_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_book;
				_tmp4_ = book_get_page (_tmp3_, i);
				p = _tmp4_;
				_tmp5_ = p;
				if (_tmp5_ == NULL) {
					_g_object_unref0 (p);
					break;
				}
				_tmp6_ = p;
				_tmp7_ = page_view_get_page (page);
				_tmp8_ = _tmp7_;
				if (_tmp6_ == _tmp8_) {
					result = prev_page;
					_g_object_unref0 (p);
					return result;
				}
				_tmp9_ = self->priv->page_data;
				_tmp10_ = p;
				_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 ((PageView*) _tmp11_);
				_g_object_unref0 (prev_page);
				prev_page = _tmp12_;
				_g_object_unref0 (p);
			}
		}
	}
	_tmp13_ = _g_object_ref0 (page);
	result = _tmp13_;
	_g_object_unref0 (prev_page);
	return result;
}

static void
book_view_page_view_changed_cb (BookView* self,
                                PageView* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_view_redraw (self);
}

static void
book_view_page_view_size_changed_cb (BookView* self,
                                     PageView* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}

static void
_book_view_page_view_changed_cb_page_view_changed (PageView* _sender,
                                                   gpointer self)
{
	book_view_page_view_changed_cb ((BookView*) self, _sender);
}

static void
_book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender,
                                                             gpointer self)
{
	book_view_page_view_size_changed_cb ((BookView*) self, _sender);
}

static void
book_view_add_cb (BookView* self,
                  Book* book,
                  Page* page)
{
	PageView* page_view = NULL;
	PageView* _tmp0_;
	GHashTable* _tmp1_;
	Page* _tmp2_;
	PageView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_view_new (page);
	page_view = _tmp0_;
	g_signal_connect_object (page_view, "changed", (GCallback) _book_view_page_view_changed_cb_page_view_changed, self, 0);
	g_signal_connect_object (page_view, "size-changed", (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self, 0);
	_tmp1_ = self->priv->page_data;
	_tmp2_ = _g_object_ref0 (page);
	_tmp3_ = _g_object_ref0 (page_view);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
	_g_object_unref0 (page_view);
}

static void
book_view_set_selected_page_view (BookView* self,
                                  PageView* page)
{
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_;
	PageView* _tmp4_;
	PageView* _tmp5_;
	GtkWidget* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->selected_page_view;
	if (_tmp1_ != NULL) {
		PageView* _tmp2_;
		_tmp2_ = self->priv->selected_page_view;
		_tmp0_ = page != _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PageView* _tmp3_;
		_tmp3_ = self->priv->selected_page_view;
		page_view_set_selected (_tmp3_, TRUE);
	}
	_tmp4_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->selected_page_view);
	self->priv->selected_page_view = _tmp4_;
	_tmp5_ = self->priv->selected_page_view;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = self->priv->drawing_area;
	g_object_get (_tmp6_, "has-focus", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		PageView* _tmp9_;
		_tmp9_ = self->priv->selected_page_view;
		page_view_set_selected (_tmp9_, FALSE);
	} else {
		PageView* _tmp10_;
		_tmp10_ = self->priv->selected_page_view;
		page_view_set_selected (_tmp10_, TRUE);
	}
}

static void
book_view_show_page_view (BookView* self,
                          PageView* page)
{
	gboolean _tmp0_ = FALSE;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	gint left_edge = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint right_edge = 0;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	if (page == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkScrollbar* _tmp1_;
		_tmp1_ = self->priv->scroll;
		_tmp0_ = !gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->drawing_area;
	gtk_widget_get_allocation (_tmp2_, &_tmp3_);
	allocation = _tmp3_;
	_tmp4_ = page_view_get_x_offset (page);
	_tmp5_ = _tmp4_;
	left_edge = _tmp5_;
	_tmp6_ = page_view_get_x_offset (page);
	_tmp7_ = _tmp6_;
	_tmp8_ = page_view_get_width (page);
	_tmp9_ = _tmp8_;
	right_edge = _tmp7_ + _tmp9_;
	_tmp10_ = book_view_get_x_offset (self);
	_tmp11_ = _tmp10_;
	if ((left_edge - _tmp11_) < 0) {
		book_view_set_x_offset (self, left_edge);
	} else {
		gint _tmp12_;
		gint _tmp13_;
		GtkAllocation _tmp14_;
		_tmp12_ = book_view_get_x_offset (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = allocation;
		if ((right_edge - _tmp13_) > _tmp14_.width) {
			GtkAllocation _tmp15_;
			_tmp15_ = allocation;
			book_view_set_x_offset (self, right_edge - _tmp15_.width);
		}
	}
}

static void
book_view_select_page_view (BookView* self,
                            PageView* page)
{
	Page* p = NULL;
	PageView* _tmp0_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	p = NULL;
	_tmp0_ = self->priv->selected_page_view;
	if (_tmp0_ == page) {
		_g_object_unref0 (p);
		return;
	}
	book_view_set_selected_page_view (self, page);
	if (self->priv->need_layout) {
		self->priv->show_selected_page = TRUE;
	} else {
		book_view_show_page_view (self, page);
	}
	if (page != NULL) {
		Page* _tmp1_;
		Page* _tmp2_;
		Page* _tmp3_;
		_tmp1_ = page_view_get_page (page);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (p);
		p = _tmp3_;
	}
	_tmp4_ = p;
	g_signal_emit (self, book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL], 0, _tmp4_);
	_g_object_unref0 (p);
}

static void
book_view_remove_cb (BookView* self,
                     Book* book,
                     Page* page)
{
	PageView* new_selection = NULL;
	PageView* _tmp0_;
	PageView* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	PageView* page_view = NULL;
	GHashTable* _tmp10_;
	gconstpointer _tmp11_;
	PageView* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GHashTable* _tmp15_;
	PageView* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->selected_page_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	new_selection = _tmp1_;
	_tmp2_ = book_view_get_selected_page (self);
	_tmp3_ = _tmp2_;
	if (page == _tmp3_) {
		PageView* _tmp4_;
		PageView* _tmp5_;
		PageView* _tmp6_;
		PageView* _tmp7_;
		_tmp4_ = self->priv->selected_page_view;
		_tmp5_ = book_view_get_prev_page (self, _tmp4_);
		_g_object_unref0 (new_selection);
		new_selection = _tmp5_;
		_tmp6_ = new_selection;
		_tmp7_ = self->priv->selected_page_view;
		if (_tmp6_ == _tmp7_) {
			PageView* _tmp8_;
			PageView* _tmp9_;
			_tmp8_ = self->priv->selected_page_view;
			_tmp9_ = book_view_get_next_page (self, _tmp8_);
			_g_object_unref0 (new_selection);
			new_selection = _tmp9_;
		}
		_g_object_unref0 (self->priv->selected_page_view);
		self->priv->selected_page_view = NULL;
	}
	_tmp10_ = self->priv->page_data;
	_tmp11_ = g_hash_table_lookup (_tmp10_, page);
	_tmp12_ = _g_object_ref0 ((PageView*) _tmp11_);
	page_view = _tmp12_;
	g_signal_parse_name ("changed", TYPE_PAGE_VIEW, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_page_view_changed_cb_page_view_changed, self);
	g_signal_parse_name ("size-changed", TYPE_PAGE_VIEW, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self);
	_tmp15_ = self->priv->page_data;
	g_hash_table_remove (_tmp15_, page);
	_tmp16_ = new_selection;
	book_view_select_page_view (self, _tmp16_);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
	_g_object_unref0 (page_view);
	_g_object_unref0 (new_selection);
}

static void
book_view_reorder_cb (BookView* self,
                      Book* book)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}

static void
book_view_clear_cb (BookView* self,
                    Book* book)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->page_data;
	g_hash_table_remove_all (_tmp0_);
	_g_object_unref0 (self->priv->selected_page_view);
	self->priv->selected_page_view = NULL;
	g_signal_emit (self, book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL], 0, NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}

static gboolean
book_view_configure_cb (BookView* self,
                        GtkWidget* widget,
                        GdkEventConfigure* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->need_layout = TRUE;
	result = FALSE;
	return result;
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
book_view_layout_into (BookView* self,
                       gint width,
                       gint height,
                       gint* book_width,
                       gint* book_height)
{
	gint _vala_book_width = 0;
	gint _vala_book_height = 0;
	GList* pages = NULL;
	gint max_dpi = 0;
	GList* _tmp6_;
	gint max_width = 0;
	gint max_height = 0;
	GList* _tmp18_;
	gdouble aspect = 0.0;
	gdouble max_aspect = 0.0;
	gint spacing = 0;
	GList* _tmp36_;
	GList* _tmp62_;
	gint x_offset = 0;
	GList* _tmp63_;
	g_return_if_fail (self != NULL);
	pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Book* _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				PageView* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_book;
				_tmp3_ = book_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(((guint) i) < _tmp4_)) {
					break;
				}
				_tmp5_ = book_view_get_nth_page (self, i);
				pages = g_list_append (pages, _tmp5_);
			}
		}
	}
	max_dpi = 0;
	_tmp6_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp6_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp7_;
			PageView* page = NULL;
			_tmp7_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp7_;
			{
				Page* p = NULL;
				PageView* _tmp8_;
				Page* _tmp9_;
				Page* _tmp10_;
				Page* _tmp11_;
				Page* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp8_ = page;
				_tmp9_ = page_view_get_page (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				p = _tmp11_;
				_tmp12_ = p;
				_tmp13_ = page_get_dpi (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ > max_dpi) {
					Page* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					_tmp15_ = p;
					_tmp16_ = page_get_dpi (_tmp15_);
					_tmp17_ = _tmp16_;
					max_dpi = _tmp17_;
				}
				_g_object_unref0 (p);
				_g_object_unref0 (page);
			}
		}
	}
	max_width = 0;
	max_height = 0;
	_tmp18_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp18_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp19_;
			PageView* page = NULL;
			_tmp19_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp19_;
			{
				Page* p = NULL;
				PageView* _tmp20_;
				Page* _tmp21_;
				Page* _tmp22_;
				Page* _tmp23_;
				gint w = 0;
				Page* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint h = 0;
				Page* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				Page* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				Page* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp20_ = page;
				_tmp21_ = page_view_get_page (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				p = _tmp23_;
				_tmp24_ = p;
				_tmp25_ = page_get_width (_tmp24_);
				_tmp26_ = _tmp25_;
				w = _tmp26_;
				_tmp27_ = p;
				_tmp28_ = page_get_height (_tmp27_);
				_tmp29_ = _tmp28_;
				h = _tmp29_;
				_tmp30_ = p;
				_tmp31_ = page_get_dpi (_tmp30_);
				_tmp32_ = _tmp31_;
				w = (gint) (((((gdouble) w) * max_dpi) / _tmp32_) + 0.5);
				_tmp33_ = p;
				_tmp34_ = page_get_dpi (_tmp33_);
				_tmp35_ = _tmp34_;
				h = (gint) (((((gdouble) h) * max_dpi) / _tmp35_) + 0.5);
				if (w > max_width) {
					max_width = w;
				}
				if (h > max_height) {
					max_height = h;
				}
				_g_object_unref0 (p);
				_g_object_unref0 (page);
			}
		}
	}
	aspect = ((gdouble) width) / height;
	max_aspect = ((gdouble) max_width) / max_height;
	spacing = 12;
	_vala_book_width = 0;
	_vala_book_height = 0;
	_tmp36_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp36_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp37_;
			PageView* page = NULL;
			_tmp37_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp37_;
			{
				Page* p = NULL;
				PageView* _tmp38_;
				Page* _tmp39_;
				Page* _tmp40_;
				Page* _tmp41_;
				gint h = 0;
				PageView* _tmp56_;
				gint _tmp57_;
				gint _tmp58_;
				PageView* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				_tmp38_ = page;
				_tmp39_ = page_view_get_page (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _g_object_ref0 (_tmp40_);
				p = _tmp41_;
				if (max_aspect > aspect) {
					gint w = 0;
					Page* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					Page* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					PageView* _tmp48_;
					_tmp42_ = p;
					_tmp43_ = page_get_width (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = p;
					_tmp46_ = page_get_dpi (_tmp45_);
					_tmp47_ = _tmp46_;
					w = (gint) (((((gdouble) _tmp44_) * max_dpi) * width) / (_tmp47_ * max_width));
					_tmp48_ = page;
					page_view_set_width (_tmp48_, w);
				} else {
					gint h = 0;
					Page* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					Page* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					PageView* _tmp55_;
					_tmp49_ = p;
					_tmp50_ = page_get_height (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = p;
					_tmp53_ = page_get_dpi (_tmp52_);
					_tmp54_ = _tmp53_;
					h = (gint) (((((gdouble) _tmp51_) * max_dpi) * height) / (_tmp54_ * max_height));
					_tmp55_ = page;
					page_view_set_height (_tmp55_, h);
				}
				_tmp56_ = page;
				_tmp57_ = page_view_get_height (_tmp56_);
				_tmp58_ = _tmp57_;
				h = _tmp58_;
				if (h > _vala_book_height) {
					_vala_book_height = h;
				}
				_tmp59_ = page;
				_tmp60_ = page_view_get_width (_tmp59_);
				_tmp61_ = _tmp60_;
				_vala_book_width = _vala_book_width + (_tmp61_ + spacing);
				_g_object_unref0 (p);
				_g_object_unref0 (page);
			}
		}
	}
	_tmp62_ = pages;
	if (_tmp62_ != NULL) {
		_vala_book_width = _vala_book_width - spacing;
	}
	x_offset = 0;
	_tmp63_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp63_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp64_;
			PageView* page = NULL;
			_tmp64_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp64_;
			{
				PageView* _tmp65_;
				PageView* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				PageView* _tmp69_;
				PageView* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				_tmp65_ = page;
				page_view_set_x_offset (_tmp65_, x_offset);
				_tmp66_ = page;
				_tmp67_ = page_view_get_width (_tmp66_);
				_tmp68_ = _tmp67_;
				x_offset += _tmp68_ + spacing;
				_tmp69_ = page;
				_tmp70_ = page;
				_tmp71_ = page_view_get_height (_tmp70_);
				_tmp72_ = _tmp71_;
				page_view_set_y_offset (_tmp69_, (height - _tmp72_) / 2);
				_g_object_unref0 (page);
			}
		}
	}
	(pages == NULL) ? NULL : (pages = (_g_list_free__g_object_unref0_ (pages), NULL));
	if (book_width) {
		*book_width = _vala_book_width;
	}
	if (book_height) {
		*book_height = _vala_book_height;
	}
}

static void
book_view_layout (BookView* self)
{
	GtkAllocation allocation = {0};
	GtkWidget* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation box_allocation = {0};
	GtkAllocation _tmp2_ = {0};
	gboolean right_aligned = FALSE;
	GtkAdjustment* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	gint width = 0;
	GtkAllocation _tmp6_;
	gint height = 0;
	GtkAllocation _tmp7_;
	gint book_width = 0;
	gint book_height = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_;
	g_return_if_fail (self != NULL);
	if (!self->priv->need_layout) {
		return;
	}
	self->priv->laying_out = TRUE;
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_get_allocation (_tmp0_, &_tmp1_);
	allocation = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	box_allocation = _tmp2_;
	right_aligned = TRUE;
	_tmp3_ = self->priv->adjustment;
	_tmp4_ = self->priv->adjustment;
	_tmp5_ = self->priv->adjustment;
	if (gtk_adjustment_get_value (_tmp3_) < (gtk_adjustment_get_upper (_tmp4_) - gtk_adjustment_get_page_size (_tmp5_))) {
		right_aligned = FALSE;
	}
	_tmp6_ = allocation;
	width = (gint) _tmp6_.width;
	_tmp7_ = box_allocation;
	height = (gint) (_tmp7_.height - (gtk_container_get_border_width ((GtkContainer*) self) * 2));
	book_view_layout_into (self, width, height, &_tmp8_, &_tmp9_);
	book_width = _tmp8_;
	book_height = _tmp9_;
	_tmp10_ = allocation;
	if (book_width > _tmp10_.width) {
		GtkAllocation _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GtkAdjustment* _tmp14_;
		GtkAdjustment* _tmp15_;
		GtkAdjustment* _tmp16_;
		GtkAllocation _tmp17_;
		gint max_offset = 0;
		GtkAllocation _tmp18_;
		gboolean _tmp19_ = FALSE;
		GtkScrollbar* _tmp22_;
		_tmp11_ = allocation;
		height = _tmp11_.height;
		book_view_layout_into (self, width, height, &_tmp12_, &_tmp13_);
		book_width = _tmp12_;
		book_height = _tmp13_;
		_tmp14_ = self->priv->adjustment;
		gtk_adjustment_set_lower (_tmp14_, (gdouble) 0);
		_tmp15_ = self->priv->adjustment;
		gtk_adjustment_set_upper (_tmp15_, (gdouble) book_width);
		_tmp16_ = self->priv->adjustment;
		_tmp17_ = allocation;
		gtk_adjustment_set_page_size (_tmp16_, (gdouble) _tmp17_.width);
		_tmp18_ = allocation;
		max_offset = book_width - _tmp18_.width;
		if (right_aligned) {
			_tmp19_ = TRUE;
		} else {
			gint _tmp20_;
			gint _tmp21_;
			_tmp20_ = book_view_get_x_offset (self);
			_tmp21_ = _tmp20_;
			_tmp19_ = _tmp21_ > max_offset;
		}
		if (_tmp19_) {
			book_view_set_x_offset (self, max_offset);
		}
		_tmp22_ = self->priv->scroll;
		gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
	} else {
		GtkScrollbar* _tmp23_;
		gint offset = 0;
		GtkAllocation _tmp24_;
		GtkAdjustment* _tmp25_;
		GtkAdjustment* _tmp26_;
		GtkAdjustment* _tmp27_;
		_tmp23_ = self->priv->scroll;
		gtk_widget_set_visible ((GtkWidget*) _tmp23_, FALSE);
		_tmp24_ = allocation;
		offset = (book_width - _tmp24_.width) / 2;
		_tmp25_ = self->priv->adjustment;
		gtk_adjustment_set_lower (_tmp25_, (gdouble) offset);
		_tmp26_ = self->priv->adjustment;
		gtk_adjustment_set_upper (_tmp26_, (gdouble) offset);
		_tmp27_ = self->priv->adjustment;
		gtk_adjustment_set_page_size (_tmp27_, (gdouble) 0);
		book_view_set_x_offset (self, offset);
	}
	if (self->priv->show_selected_page) {
		PageView* _tmp28_;
		_tmp28_ = self->priv->selected_page_view;
		book_view_show_page_view (self, _tmp28_);
	}
	self->priv->need_layout = FALSE;
	self->priv->show_selected_page = FALSE;
	self->priv->laying_out = FALSE;
}

static gboolean
book_view_draw_cb (BookView* self,
                   GtkWidget* widget,
                   cairo_t* context)
{
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble right = 0.0;
	gdouble bottom = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GList* pages = NULL;
	GdkRGBA ruler_color = {0};
	GtkStyleContext* _tmp10_;
	GdkRGBA _tmp11_ = {0};
	GList* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	book_view_layout (self);
	cairo_clip_extents (context, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	left = _tmp0_;
	top = _tmp1_;
	right = _tmp2_;
	bottom = _tmp3_;
	pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				Book* _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				PageView* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->_book;
				_tmp7_ = book_get_n_pages (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(((guint) i) < _tmp8_)) {
					break;
				}
				_tmp9_ = book_view_get_nth_page (self, i);
				pages = g_list_append (pages, _tmp9_);
			}
		}
	}
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_color (_tmp10_, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp11_);
	ruler_color = _tmp11_;
	_tmp12_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp12_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp13_;
			PageView* page = NULL;
			_tmp13_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp13_;
			{
				gint left_edge = 0;
				PageView* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint right_edge = 0;
				PageView* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				PageView* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gboolean _tmp27_ = FALSE;
				gint _tmp28_;
				gint _tmp29_;
				PageView* _tmp30_;
				GdkRGBA _tmp31_;
				PageView* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp14_ = page;
				_tmp15_ = page_view_get_x_offset (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = book_view_get_x_offset (self);
				_tmp18_ = _tmp17_;
				left_edge = _tmp16_ - _tmp18_;
				_tmp19_ = page;
				_tmp20_ = page_view_get_x_offset (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = page;
				_tmp23_ = page_view_get_width (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = book_view_get_x_offset (self);
				_tmp26_ = _tmp25_;
				right_edge = (_tmp21_ + _tmp24_) - _tmp26_;
				if (((gdouble) right_edge) < left) {
					_tmp27_ = TRUE;
				} else {
					_tmp27_ = ((gdouble) left_edge) > right;
				}
				if (_tmp27_) {
					_g_object_unref0 (page);
					continue;
				}
				cairo_save (context);
				_tmp28_ = book_view_get_x_offset (self);
				_tmp29_ = _tmp28_;
				cairo_translate (context, (gdouble) (-_tmp29_), (gdouble) 0);
				_tmp30_ = page;
				_tmp31_ = ruler_color;
				page_view_render (_tmp30_, context, &_tmp31_);
				cairo_restore (context);
				_tmp32_ = page;
				_tmp33_ = page_view_get_selected (_tmp32_);
				_tmp34_ = _tmp33_;
				if (_tmp34_) {
					GtkWidget* _tmp35_;
					GtkStyleContext* _tmp36_;
					PageView* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					PageView* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					PageView* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					PageView* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					_tmp35_ = self->priv->drawing_area;
					_tmp36_ = gtk_widget_get_style_context (_tmp35_);
					_tmp37_ = page;
					_tmp38_ = page_view_get_x_offset (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = book_view_get_x_offset (self);
					_tmp41_ = _tmp40_;
					_tmp42_ = page;
					_tmp43_ = page_view_get_y_offset (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = page;
					_tmp46_ = page_view_get_width (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = page;
					_tmp49_ = page_view_get_height (_tmp48_);
					_tmp50_ = _tmp49_;
					gtk_render_focus (_tmp36_, context, (gdouble) (_tmp39_ - _tmp41_), (gdouble) _tmp44_, (gdouble) _tmp47_, (gdouble) _tmp50_);
				}
				_g_object_unref0 (page);
			}
		}
	}
	result = FALSE;
	(pages == NULL) ? NULL : (pages = (_g_list_free__g_object_unref0_ (pages), NULL));
	return result;
}

static PageView*
book_view_get_page_at (BookView* self,
                       gint x,
                       gint y,
                       gint* x_,
                       gint* y_)
{
	gint _vala_x_ = 0;
	gint _vala_y_ = 0;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_y_ = 0;
	_vala_x_ = _vala_y_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Book* _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				PageView* page = NULL;
				PageView* _tmp5_;
				gint left = 0;
				PageView* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint right = 0;
				PageView* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint top = 0;
				PageView* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint bottom = 0;
				PageView* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_book;
				_tmp3_ = book_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(((guint) i) < _tmp4_)) {
					break;
				}
				_tmp5_ = book_view_get_nth_page (self, i);
				page = _tmp5_;
				_tmp6_ = page;
				_tmp7_ = page_view_get_x_offset (_tmp6_);
				_tmp8_ = _tmp7_;
				left = _tmp8_;
				_tmp9_ = page;
				_tmp10_ = page_view_get_width (_tmp9_);
				_tmp11_ = _tmp10_;
				right = left + _tmp11_;
				_tmp12_ = page;
				_tmp13_ = page_view_get_y_offset (_tmp12_);
				_tmp14_ = _tmp13_;
				top = _tmp14_;
				_tmp15_ = page;
				_tmp16_ = page_view_get_height (_tmp15_);
				_tmp17_ = _tmp16_;
				bottom = top + _tmp17_;
				if (x >= left) {
					_tmp20_ = x <= right;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					_tmp19_ = y >= top;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					_tmp18_ = y <= bottom;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					_vala_x_ = x - left;
					_vala_y_ = y - top;
					result = page;
					if (x_) {
						*x_ = _vala_x_;
					}
					if (y_) {
						*y_ = _vala_y_;
					}
					return result;
				}
				_g_object_unref0 (page);
			}
		}
	}
	result = NULL;
	if (x_) {
		*x_ = _vala_x_;
	}
	if (y_) {
		*y_ = _vala_y_;
	}
	return result;
}

static gboolean
book_view_button_cb (BookView* self,
                     GtkWidget* widget,
                     GdkEventButton* event)
{
	GtkWidget* _tmp0_;
	gint x = 0;
	gint y = 0;
	PageView* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	book_view_layout (self);
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_grab_focus (_tmp0_);
	x = 0;
	y = 0;
	if (event->type == GDK_BUTTON_PRESS) {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		PageView* _tmp5_;
		PageView* _tmp6_;
		_tmp1_ = book_view_get_x_offset (self);
		_tmp2_ = _tmp1_;
		_tmp5_ = book_view_get_page_at (self, (gint) (event->x + _tmp2_), (gint) event->y, &_tmp3_, &_tmp4_);
		x = _tmp3_;
		y = _tmp4_;
		_tmp6_ = _tmp5_;
		book_view_select_page_view (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = self->priv->selected_page_view;
	if (_tmp7_ == NULL) {
		result = FALSE;
		return result;
	}
	if (event->button == ((guint) 1)) {
		if (event->type == GDK_BUTTON_PRESS) {
			PageView* _tmp8_;
			_tmp8_ = self->priv->selected_page_view;
			page_view_button_press (_tmp8_, x, y);
		} else {
			if (event->type == GDK_BUTTON_RELEASE) {
				PageView* _tmp9_;
				_tmp9_ = self->priv->selected_page_view;
				page_view_button_release (_tmp9_, x, y);
			} else {
				if (event->type == GDK_2BUTTON_PRESS) {
					Page* _tmp10_;
					Page* _tmp11_;
					_tmp10_ = book_view_get_selected_page (self);
					_tmp11_ = _tmp10_;
					g_signal_emit (self, book_view_signals[BOOK_VIEW_SHOW_PAGE_SIGNAL], 0, _tmp11_);
				}
			}
		}
	}
	if (event->button == ((guint) 3)) {
		g_signal_emit (self, book_view_signals[BOOK_VIEW_SHOW_MENU_SIGNAL], 0, (GdkEvent*) event);
	}
	result = FALSE;
	return result;
}

static void
book_view_set_cursor (BookView* self,
                      GdkCursorType cursor)
{
	GdkCursor* c = NULL;
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GtkWidget* _tmp2_;
	GdkWindow* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->cursor == cursor) {
		_g_object_unref0 (c);
		return;
	}
	self->priv->cursor = cursor;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, cursor);
	_g_object_unref0 (c);
	c = _tmp1_;
	_tmp2_ = self->priv->drawing_area;
	_tmp3_ = gtk_widget_get_window (_tmp2_);
	_tmp4_ = c;
	gdk_window_set_cursor (_tmp3_, _tmp4_);
	_g_object_unref0 (c);
}

static gboolean
book_view_motion_cb (BookView* self,
                     GtkWidget* widget,
                     GdkEventMotion* event)
{
	GdkCursorType cursor = 0;
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	cursor = GDK_ARROW;
	_tmp1_ = self->priv->selected_page_view;
	if (_tmp1_ != NULL) {
		_tmp0_ = (event->state & GDK_BUTTON1_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint x = 0;
		gint _tmp2_;
		gint _tmp3_;
		PageView* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint y = 0;
		PageView* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		PageView* _tmp10_;
		PageView* _tmp11_;
		GdkCursorType _tmp12_;
		GdkCursorType _tmp13_;
		_tmp2_ = book_view_get_x_offset (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->selected_page_view;
		_tmp5_ = page_view_get_x_offset (_tmp4_);
		_tmp6_ = _tmp5_;
		x = (gint) ((event->x + _tmp3_) - _tmp6_);
		_tmp7_ = self->priv->selected_page_view;
		_tmp8_ = page_view_get_y_offset (_tmp7_);
		_tmp9_ = _tmp8_;
		y = (gint) (event->y - _tmp9_);
		_tmp10_ = self->priv->selected_page_view;
		page_view_motion (_tmp10_, x, y);
		_tmp11_ = self->priv->selected_page_view;
		_tmp12_ = page_view_get_cursor (_tmp11_);
		_tmp13_ = _tmp12_;
		cursor = _tmp13_;
	} else {
		gint x = 0;
		gint y = 0;
		PageView* over_page = NULL;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		PageView* _tmp18_;
		PageView* _tmp19_;
		_tmp14_ = book_view_get_x_offset (self);
		_tmp15_ = _tmp14_;
		_tmp18_ = book_view_get_page_at (self, (gint) (event->x + _tmp15_), (gint) event->y, &_tmp16_, &_tmp17_);
		x = _tmp16_;
		y = _tmp17_;
		over_page = _tmp18_;
		_tmp19_ = over_page;
		if (_tmp19_ != NULL) {
			PageView* _tmp20_;
			PageView* _tmp21_;
			GdkCursorType _tmp22_;
			GdkCursorType _tmp23_;
			_tmp20_ = over_page;
			page_view_motion (_tmp20_, x, y);
			_tmp21_ = over_page;
			_tmp22_ = page_view_get_cursor (_tmp21_);
			_tmp23_ = _tmp22_;
			cursor = _tmp23_;
		}
		_g_object_unref0 (over_page);
	}
	book_view_set_cursor (self, cursor);
	result = FALSE;
	return result;
}

static gboolean
book_view_key_cb (BookView* self,
                  GtkWidget* widget,
                  GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case 0xff50:
		{
			Book* _tmp0_;
			Page* _tmp1_;
			Page* _tmp2_;
			_tmp0_ = self->priv->_book;
			_tmp1_ = book_get_page (_tmp0_, 0);
			_tmp2_ = _tmp1_;
			book_view_set_selected_page (self, _tmp2_);
			_g_object_unref0 (_tmp2_);
			result = TRUE;
			return result;
		}
		case 0xff51:
		{
			PageView* _tmp3_;
			PageView* _tmp4_;
			PageView* _tmp5_;
			_tmp3_ = self->priv->selected_page_view;
			_tmp4_ = book_view_get_prev_page (self, _tmp3_);
			_tmp5_ = _tmp4_;
			book_view_select_page_view (self, _tmp5_);
			_g_object_unref0 (_tmp5_);
			result = TRUE;
			return result;
		}
		case 0xff53:
		{
			PageView* _tmp6_;
			PageView* _tmp7_;
			PageView* _tmp8_;
			_tmp6_ = self->priv->selected_page_view;
			_tmp7_ = book_view_get_next_page (self, _tmp6_);
			_tmp8_ = _tmp7_;
			book_view_select_page_view (self, _tmp8_);
			_g_object_unref0 (_tmp8_);
			result = TRUE;
			return result;
		}
		case 0xFF57:
		{
			Book* _tmp9_;
			Book* _tmp10_;
			guint _tmp11_;
			guint _tmp12_;
			Page* _tmp13_;
			Page* _tmp14_;
			_tmp9_ = self->priv->_book;
			_tmp10_ = self->priv->_book;
			_tmp11_ = book_get_n_pages (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = book_get_page (_tmp9_, ((gint) _tmp12_) - 1);
			_tmp14_ = _tmp13_;
			book_view_set_selected_page (self, _tmp14_);
			_g_object_unref0 (_tmp14_);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
book_view_focus_cb (BookView* self,
                    GtkWidget* widget,
                    GdkEventFocus* event)
{
	PageView* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected_page_view;
	book_view_set_selected_page_view (self, _tmp0_);
	result = FALSE;
	return result;
}

static void
book_view_scroll_cb (BookView* self,
                     GtkAdjustment* adjustment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	if (!self->priv->laying_out) {
		book_view_redraw (self);
	}
}

void
book_view_redraw (BookView* self)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_queue_draw (_tmp0_);
}

void
book_view_select_next_page (BookView* self)
{
	PageView* _tmp0_;
	PageView* _tmp1_;
	PageView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_page_view;
	_tmp1_ = book_view_get_next_page (self, _tmp0_);
	_tmp2_ = _tmp1_;
	book_view_select_page_view (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

void
book_view_select_prev_page (BookView* self)
{
	PageView* _tmp0_;
	PageView* _tmp1_;
	PageView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_page_view;
	_tmp1_ = book_view_get_prev_page (self, _tmp0_);
	_tmp2_ = _tmp1_;
	book_view_select_page_view (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

Book*
book_view_get_book (BookView* self)
{
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	result = _tmp0_;
	return result;
}

static void
book_view_set_book (BookView* self,
                    Book* value)
{
	Book* old_value;
	g_return_if_fail (self != NULL);
	old_value = book_view_get_book (self);
	if (old_value != value) {
		Book* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_book);
		self->priv->_book = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_BOOK_PROPERTY]);
	}
}

Page*
book_view_get_selected_page (BookView* self)
{
	Page* result;
	PageView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected_page_view;
	if (_tmp0_ != NULL) {
		PageView* _tmp1_;
		Page* _tmp2_;
		Page* _tmp3_;
		_tmp1_ = self->priv->selected_page_view;
		_tmp2_ = page_view_get_page (_tmp1_);
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

void
book_view_set_selected_page (BookView* self,
                             Page* value)
{
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_view_get_selected_page (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	if (value != NULL) {
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->page_data;
		_tmp3_ = g_hash_table_lookup (_tmp2_, value);
		book_view_select_page_view (self, (PageView*) _tmp3_);
	} else {
		book_view_select_page_view (self, NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_SELECTED_PAGE_PROPERTY]);
}

gint
book_view_get_x_offset (BookView* self)
{
	gint result;
	GtkAdjustment* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->adjustment;
	result = (gint) gtk_adjustment_get_value (_tmp0_);
	return result;
}

void
book_view_set_x_offset (BookView* self,
                        gint value)
{
	GtkAdjustment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->adjustment;
	gtk_adjustment_set_value (_tmp0_, (gdouble) value);
	g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_X_OFFSET_PROPERTY]);
}

static void
book_view_class_init (BookViewClass * klass,
                      gpointer klass_data)
{
	book_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BookView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_book_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_book_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = book_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_BOOK_PROPERTY, book_view_properties[BOOK_VIEW_BOOK_PROPERTY] = g_param_spec_object ("book", "book", "book", TYPE_BOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_SELECTED_PAGE_PROPERTY, book_view_properties[BOOK_VIEW_SELECTED_PAGE_PROPERTY] = g_param_spec_object ("selected-page", "selected-page", "selected-page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_X_OFFSET_PROPERTY, book_view_properties[BOOK_VIEW_X_OFFSET_PROPERTY] = g_param_spec_int ("x-offset", "x-offset", "x-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL] = g_signal_new ("page-selected", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PAGE);
	book_view_signals[BOOK_VIEW_SHOW_PAGE_SIGNAL] = g_signal_new ("show-page", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PAGE);
	book_view_signals[BOOK_VIEW_SHOW_MENU_SIGNAL] = g_signal_new ("show-menu", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gdk_event_get_type ());
}

static void
book_view_instance_init (BookView * self,
                         gpointer klass)
{
	self->priv = book_view_get_instance_private (self);
	self->priv->selected_page_view = NULL;
}

static void
book_view_finalize (GObject * obj)
{
	BookView * self;
	Book* _tmp0_;
	guint _tmp1_;
	Book* _tmp2_;
	guint _tmp3_;
	Book* _tmp4_;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_;
	GtkWidget* _tmp8_;
	guint _tmp9_;
	GtkWidget* _tmp10_;
	guint _tmp11_;
	GtkWidget* _tmp12_;
	guint _tmp13_;
	GtkWidget* _tmp14_;
	guint _tmp15_;
	GtkWidget* _tmp16_;
	guint _tmp17_;
	GtkWidget* _tmp18_;
	guint _tmp19_;
	GtkWidget* _tmp20_;
	guint _tmp21_;
	GtkWidget* _tmp22_;
	guint _tmp23_;
	GtkAdjustment* _tmp24_;
	guint _tmp25_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK_VIEW, BookView);
	_tmp0_ = self->priv->_book;
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_view_add_cb_book_page_added, self);
	_tmp2_ = self->priv->_book;
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_view_remove_cb_book_page_removed, self);
	_tmp4_ = self->priv->_book;
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_view_reorder_cb_book_reordered, self);
	_tmp6_ = self->priv->_book;
	g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _book_view_clear_cb_book_cleared, self);
	_tmp8_ = self->priv->drawing_area;
	g_signal_parse_name ("configure-event", gtk_widget_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _book_view_configure_cb_gtk_widget_configure_event, self);
	_tmp10_ = self->priv->drawing_area;
	g_signal_parse_name ("draw", gtk_widget_get_type (), &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _book_view_draw_cb_gtk_widget_draw, self);
	_tmp12_ = self->priv->drawing_area;
	g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_motion_cb_gtk_widget_motion_notify_event, self);
	_tmp14_ = self->priv->drawing_area;
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _book_view_key_cb_gtk_widget_key_press_event, self);
	_tmp16_ = self->priv->drawing_area;
	g_signal_parse_name ("button-press-event", gtk_widget_get_type (), &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _book_view_button_cb_gtk_widget_button_press_event, self);
	_tmp18_ = self->priv->drawing_area;
	g_signal_parse_name ("button-release-event", gtk_widget_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _book_view_button_cb_gtk_widget_button_release_event, self);
	_tmp20_ = self->priv->drawing_area;
	g_signal_parse_name ("focus-in-event", gtk_widget_get_type (), &_tmp21_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_widget_focus_in_event, self);
	_tmp22_ = self->priv->drawing_area;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_widget_focus_out_event, self);
	_tmp24_ = self->priv->adjustment;
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp25_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp25_, 0, NULL, (GCallback) _book_view_scroll_cb_gtk_adjustment_value_changed, self);
	_g_object_unref0 (self->priv->_book);
	_g_hash_table_unref0 (self->priv->page_data);
	_g_object_unref0 (self->priv->selected_page_view);
	_g_object_unref0 (self->priv->drawing_area);
	_g_object_unref0 (self->priv->scroll);
	_g_object_unref0 (self->priv->adjustment);
	G_OBJECT_CLASS (book_view_parent_class)->finalize (obj);
}

static GType
book_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookView), 0, (GInstanceInitFunc) book_view_instance_init, NULL };
	GType book_view_type_id;
	book_view_type_id = g_type_register_static (gtk_box_get_type (), "BookView", &g_define_type_info, 0);
	BookView_private_offset = g_type_add_instance_private (book_view_type_id, sizeof (BookViewPrivate));
	return book_view_type_id;
}

GType
book_view_get_type (void)
{
	static volatile gsize book_view_type_id__once = 0;
	if (g_once_init_enter (&book_view_type_id__once)) {
		GType book_view_type_id;
		book_view_type_id = book_view_get_type_once ();
		g_once_init_leave (&book_view_type_id__once, book_view_type_id);
	}
	return book_view_type_id__once;
}

static void
_vala_book_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	BookView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK_VIEW, BookView);
	switch (property_id) {
		case BOOK_VIEW_BOOK_PROPERTY:
		g_value_set_object (value, book_view_get_book (self));
		break;
		case BOOK_VIEW_SELECTED_PAGE_PROPERTY:
		g_value_set_object (value, book_view_get_selected_page (self));
		break;
		case BOOK_VIEW_X_OFFSET_PROPERTY:
		g_value_set_int (value, book_view_get_x_offset (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_book_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	BookView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK_VIEW, BookView);
	switch (property_id) {
		case BOOK_VIEW_BOOK_PROPERTY:
		book_view_set_book (self, g_value_get_object (value));
		break;
		case BOOK_VIEW_SELECTED_PAGE_PROPERTY:
		book_view_set_selected_page (self, g_value_get_object (value));
		break;
		case BOOK_VIEW_X_OFFSET_PROPERTY:
		book_view_set_x_offset (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

