/* notification_widget.c generated by valac 0.56.2, the Vala compiler
 * generated from notification_widget.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include "budgie-private.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

enum  {
	NOTIFICATION_WIDGET_0_PROPERTY,
	NOTIFICATION_WIDGET_NOTIFICATION_PROPERTY,
	NOTIFICATION_WIDGET_NUM_PROPERTIES
};
static GParamSpec* notification_widget_properties[NOTIFICATION_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	NOTIFICATION_WIDGET_CLOSED_INDIVIDUALLY_SIGNAL,
	NOTIFICATION_WIDGET_NUM_SIGNALS
};
static guint notification_widget_signals[NOTIFICATION_WIDGET_NUM_SIGNALS] = {0};

struct _NotificationWidgetPrivate {
	BudgieNotification* _notification;
	GtkBox* header;
	GtkButton* dismiss_button;
	GtkLabel* label_title;
	GtkLabel* label_body;
	GtkLabel* label_timestamp;
};

static gint NotificationWidget_private_offset;
static gpointer notification_widget_parent_class = NULL;

static GObject * notification_widget_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _notification_widget_Dismiss_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
static void notification_widget_finalize (GObject * obj);
static GType notification_widget_get_type_once (void);
static void _vala_notification_widget_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_notification_widget_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
notification_widget_get_instance_private (NotificationWidget* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationWidget_private_offset);
}

NotificationWidget*
notification_widget_construct (GType object_type,
                               BudgieNotification* notification)
{
	NotificationWidget * self = NULL;
	g_return_val_if_fail (notification != NULL, NULL);
	self = (NotificationWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 4, "notification", notification, NULL);
	return self;
}

NotificationWidget*
notification_widget_new (BudgieNotification* notification)
{
	return notification_widget_construct (TYPE_NOTIFICATION_WIDGET, notification);
}

/**
 * Dismiss this notification
 */
void
notification_widget_Dismiss (NotificationWidget* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, notification_widget_signals[NOTIFICATION_WIDGET_CLOSED_INDIVIDUALLY_SIGNAL], 0);
}

BudgieNotification*
notification_widget_get_notification (NotificationWidget* self)
{
	BudgieNotification* result;
	BudgieNotification* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notification;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
notification_widget_set_notification (NotificationWidget* self,
                                      BudgieNotification* value)
{
	BudgieNotification* old_value;
	g_return_if_fail (self != NULL);
	old_value = notification_widget_get_notification (self);
	if (old_value != value) {
		BudgieNotification* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_notification);
		self->priv->_notification = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notification_widget_properties[NOTIFICATION_WIDGET_NOTIFICATION_PROPERTY]);
	}
}

static void
_notification_widget_Dismiss_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	notification_widget_Dismiss ((NotificationWidget*) self);
}

static GObject *
notification_widget_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NotificationWidget * self;
	GtkStyleContext* _tmp0_;
	GtkBox* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	BudgieNotification* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkLabel* _tmp10_ = NULL;
	BudgieNotification* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GDateTime* date = NULL;
	BudgieNotification* _tmp18_;
	gint64 _tmp19_;
	gint64 _tmp20_;
	GDateTime* _tmp21_;
	GSettings* gnome_settings = NULL;
	GSettings* _tmp22_;
	gchar* clock_format = NULL;
	GSettings* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	GtkLabel* _tmp33_ = NULL;
	GtkLabel* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkBox* _tmp36_;
	GtkLabel* _tmp37_;
	GtkBox* _tmp38_;
	GtkButton* _tmp39_;
	GtkBox* _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkButton* _tmp44_;
	parent_class = G_OBJECT_CLASS (notification_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATION_WIDGET, NotificationWidget);
	g_object_set ((GtkWidget*) self, "expand", FALSE, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 4);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "notification-clone");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->dismiss_button);
	self->priv->dismiss_button = _tmp2_;
	_tmp3_ = self->priv->dismiss_button;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "flat");
	_tmp5_ = self->priv->dismiss_button;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "image-button");
	_tmp7_ = self->priv->_notification;
	_tmp8_ = budgie_notification_get_summary (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	gtk_label_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	gtk_label_set_justify (_tmp10_, GTK_JUSTIFY_LEFT);
	gtk_label_set_use_markup (_tmp10_, TRUE);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->label_title);
	self->priv->label_title = _tmp10_;
	_tmp11_ = self->priv->_notification;
	_tmp12_ = budgie_notification_get_body (_tmp11_);
	_tmp13_ = _tmp12_;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		BudgieNotification* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GtkLabel* _tmp17_ = NULL;
		_tmp14_ = self->priv->_notification;
		_tmp15_ = budgie_notification_get_body (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
		gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
		gtk_label_set_justify (_tmp17_, GTK_JUSTIFY_LEFT);
		gtk_label_set_use_markup (_tmp17_, TRUE);
		gtk_label_set_width_chars (_tmp17_, 30);
		g_object_set (_tmp17_, "wrap", TRUE, NULL);
		g_object_set (_tmp17_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
		gtk_label_set_xalign (_tmp17_, (gfloat) 0);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->label_body);
		self->priv->label_body = _tmp17_;
	}
	_tmp18_ = self->priv->_notification;
	_tmp19_ = budgie_notification_get_timestamp (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_date_time_new_from_unix_local (_tmp20_);
	date = _tmp21_;
	_tmp22_ = g_settings_new ("org.gnome.desktop.interface");
	gnome_settings = _tmp22_;
	_tmp23_ = gnome_settings;
	_tmp24_ = g_settings_get_string (_tmp23_, "clock-format");
	clock_format = _tmp24_;
	_tmp26_ = clock_format;
	if (g_strcmp0 (_tmp26_, "12h") == 0) {
		GDateTime* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = date;
		_tmp28_ = g_date_time_format (_tmp27_, "%l:%M %p");
		_g_free0 (_tmp25_);
		_tmp25_ = _tmp28_;
	} else {
		GDateTime* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = date;
		_tmp30_ = g_date_time_format (_tmp29_, "%H:%M");
		_g_free0 (_tmp25_);
		_tmp25_ = _tmp30_;
	}
	_tmp31_ = g_strdup (_tmp25_);
	_g_free0 (clock_format);
	clock_format = _tmp31_;
	_tmp32_ = clock_format;
	_tmp33_ = (GtkLabel*) gtk_label_new (_tmp32_);
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
	gtk_label_set_justify (_tmp33_, GTK_JUSTIFY_LEFT);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->label_timestamp);
	self->priv->label_timestamp = _tmp33_;
	_tmp34_ = self->priv->label_timestamp;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	gtk_style_context_add_class (_tmp35_, "dim-label");
	_tmp36_ = self->priv->header;
	_tmp37_ = self->priv->label_title;
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 0);
	_tmp38_ = self->priv->header;
	_tmp39_ = self->priv->dismiss_button;
	gtk_box_pack_end (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
	_tmp40_ = self->priv->header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp40_, TRUE, TRUE, (guint) 0);
	_tmp41_ = self->priv->label_timestamp;
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp41_, TRUE, TRUE, (guint) 0);
	_tmp42_ = self->priv->label_body;
	if (_tmp42_ != NULL) {
		GtkLabel* _tmp43_;
		_tmp43_ = self->priv->label_body;
		gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp43_, TRUE, TRUE, (guint) 0);
	}
	_tmp44_ = self->priv->dismiss_button;
	g_signal_connect_object (_tmp44_, "clicked", (GCallback) _notification_widget_Dismiss_gtk_button_clicked, self, 0);
	_g_free0 (_tmp25_);
	_g_free0 (clock_format);
	_g_object_unref0 (gnome_settings);
	_g_date_time_unref0 (date);
	return obj;
}

static void
notification_widget_class_init (NotificationWidgetClass * klass,
                                gpointer klass_data)
{
	notification_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notification_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notification_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = notification_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = notification_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_WIDGET_NOTIFICATION_PROPERTY, notification_widget_properties[NOTIFICATION_WIDGET_NOTIFICATION_PROPERTY] = g_param_spec_object ("notification", "notification", "notification", BUDGIE_TYPE_NOTIFICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	notification_widget_signals[NOTIFICATION_WIDGET_CLOSED_INDIVIDUALLY_SIGNAL] = g_signal_new ("closed-individually", TYPE_NOTIFICATION_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
notification_widget_instance_init (NotificationWidget * self,
                                   gpointer klass)
{
	self->priv = notification_widget_get_instance_private (self);
	self->priv->header = NULL;
	self->priv->dismiss_button = NULL;
	self->priv->label_title = NULL;
	self->priv->label_body = NULL;
	self->priv->label_timestamp = NULL;
}

static void
notification_widget_finalize (GObject * obj)
{
	NotificationWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATION_WIDGET, NotificationWidget);
	_g_object_unref0 (self->priv->_notification);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->dismiss_button);
	_g_object_unref0 (self->priv->label_title);
	_g_object_unref0 (self->priv->label_body);
	_g_object_unref0 (self->priv->label_timestamp);
	G_OBJECT_CLASS (notification_widget_parent_class)->finalize (obj);
}

static GType
notification_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notification_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationWidget), 0, (GInstanceInitFunc) notification_widget_instance_init, NULL };
	GType notification_widget_type_id;
	notification_widget_type_id = g_type_register_static (gtk_box_get_type (), "NotificationWidget", &g_define_type_info, 0);
	NotificationWidget_private_offset = g_type_add_instance_private (notification_widget_type_id, sizeof (NotificationWidgetPrivate));
	return notification_widget_type_id;
}

GType
notification_widget_get_type (void)
{
	static volatile gsize notification_widget_type_id__once = 0;
	if (g_once_init_enter (&notification_widget_type_id__once)) {
		GType notification_widget_type_id;
		notification_widget_type_id = notification_widget_get_type_once ();
		g_once_init_leave (&notification_widget_type_id__once, notification_widget_type_id);
	}
	return notification_widget_type_id__once;
}

static void
_vala_notification_widget_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	NotificationWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NOTIFICATION_WIDGET, NotificationWidget);
	switch (property_id) {
		case NOTIFICATION_WIDGET_NOTIFICATION_PROPERTY:
		g_value_set_object (value, notification_widget_get_notification (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notification_widget_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	NotificationWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NOTIFICATION_WIDGET, NotificationWidget);
	switch (property_id) {
		case NOTIFICATION_WIDGET_NOTIFICATION_PROPERTY:
		notification_widget_set_notification (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

