/* number-picker.c generated by valac 0.56.0, the Vala compiler
 * generated from number-picker.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
typedef struct _NumberPickerPrivate NumberPickerPrivate;
enum  {
	NUMBER_PICKER_0_PROPERTY,
	NUMBER_PICKER_NUM_PROPERTIES
};
static GParamSpec* number_picker_properties[NUMBER_PICKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
enum  {
	NUMBER_PICKER_NUMBER_PICKED_SIGNAL,
	NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL,
	NUMBER_PICKER_NUM_SIGNALS
};
static guint number_picker_signals[NUMBER_PICKER_NUM_SIGNALS] = {0};

struct _NumberPicker {
	GtkGrid parent_instance;
	NumberPickerPrivate * priv;
};

struct _NumberPickerClass {
	GtkGridClass parent_class;
};

struct _NumberPickerPrivate {
	SudokuBoard* board;
	GtkButton* clear_button;
	gint earmarks_active;
};

struct _Block5Data {
	int _ref_count_;
	NumberPicker* self;
	gint n;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkToggleButton* toggle_button;
};

static gint NumberPicker_private_offset;
static gpointer number_picker_parent_class = NULL;

VALA_EXTERN GType number_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NumberPicker, g_object_unref)
VALA_EXTERN NumberPicker* number_picker_new (SudokuBoard** board,
                                 gboolean earmark);
VALA_EXTERN NumberPicker* number_picker_construct (GType object_type,
                                       SudokuBoard** board,
                                       gboolean earmark);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _________lambda4_ (Block5Data* _data5_);
static void __________lambda4__gtk_button_clicked (GtkButton* _sender,
                                            gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _________lambda5_ (Block6Data* _data6_);
static void __________lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                   gpointer self);
static void ___lambda6_ (NumberPicker* self);
static void ____lambda6__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN void number_picker_set_clear_button_visibility (NumberPicker* self,
                                                gboolean visible);
VALA_EXTERN void number_picker_set_earmarks (NumberPicker* self,
                                 gint row,
                                 gint col);
VALA_EXTERN void number_picker_set_earmark (NumberPicker* self,
                                gint row,
                                gint col,
                                gint index,
                                gboolean state);
static GtkToggleButton* number_picker_get_button_for (NumberPicker* self,
                                               gint number);
static void g_cclosure_user_marshal_VOID__INT_BOOLEAN (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void number_picker_finalize (GObject * obj);
static GType number_picker_get_type_once (void);

static inline gpointer
number_picker_get_instance_private (NumberPicker* self)
{
	return G_STRUCT_MEMBER_P (self, NumberPicker_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NumberPicker* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_________lambda4_ (Block5Data* _data5_)
{
	NumberPicker* self;
	self = _data5_->self;
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_NUMBER_PICKED_SIGNAL], 0, _data5_->n);
}

static void
__________lambda4__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self)
{
	_________lambda4_ (self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NumberPicker* self;
		self = _data6_->_data5_->self;
		_g_object_unref0 (_data6_->toggle_button);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_________lambda5_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	NumberPicker* self;
	gboolean toggle_active = FALSE;
	GtkToggleButton* _tmp0_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data6_->toggle_button;
	toggle_active = gtk_toggle_button_get_active (_tmp0_);
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL], 0, _data5_->n, toggle_active);
}

static void
__________lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self)
{
	_________lambda5_ (self);
}

static void
___lambda6_ (NumberPicker* self)
{
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_NUMBER_PICKED_SIGNAL], 0, 0);
}

static void
____lambda6__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	___lambda6_ ((NumberPicker*) self);
}

NumberPicker*
number_picker_construct (GType object_type,
                         SudokuBoard** board,
                         gboolean earmark)
{
	NumberPicker * self = NULL;
	SudokuBoard* _tmp0_;
	g_return_val_if_fail (*board != NULL, NULL);
	self = (NumberPicker*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (*board);
	_g_object_unref0 (self->priv->board);
	self->priv->board = _tmp0_;
	self->priv->earmarks_active = 0;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = col;
					col = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = sudoku_board_get_block_cols (*board);
				_tmp4_ = _tmp3_;
				if (!(col < _tmp4_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							Block5Data* _data5_;
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							GtkButton* _tmp11_ = NULL;
							GtkButton* button = NULL;
							GtkButton* _tmp14_;
							GtkButton* _tmp15_;
							GtkButton* _tmp16_;
							GtkLabel* label = NULL;
							gchar* _tmp17_;
							gchar* _tmp18_;
							GtkLabel* _tmp19_;
							GtkLabel* _tmp20_;
							GtkLabel* _tmp21_;
							gint _tmp22_ = 0;
							GtkLabel* _tmp23_;
							gint _tmp24_ = 0;
							GtkLabel* _tmp25_;
							gint _tmp26_ = 0;
							GtkLabel* _tmp27_;
							gint _tmp28_ = 0;
							GtkLabel* _tmp29_;
							GtkButton* _tmp30_;
							GtkLabel* _tmp31_;
							GtkLabel* _tmp32_;
							GtkButton* _tmp38_;
							_data5_ = g_slice_new0 (Block5Data);
							_data5_->_ref_count_ = 1;
							_data5_->self = g_object_ref (self);
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = row;
								row = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = sudoku_board_get_block_rows (*board);
							_tmp8_ = _tmp7_;
							if (!(row < _tmp8_)) {
								block5_data_unref (_data5_);
								_data5_ = NULL;
								break;
							}
							_tmp9_ = sudoku_board_get_block_cols (*board);
							_tmp10_ = _tmp9_;
							_data5_->n = (col + ((2 - row) * _tmp10_)) + 1;
							if (earmark) {
								GtkToggleButton* _tmp12_;
								_tmp12_ = (GtkToggleButton*) gtk_toggle_button_new ();
								g_object_ref_sink (_tmp12_);
								_g_object_unref0 (_tmp11_);
								_tmp11_ = (GtkButton*) _tmp12_;
							} else {
								GtkButton* _tmp13_;
								_tmp13_ = (GtkButton*) gtk_button_new ();
								g_object_ref_sink (_tmp13_);
								_g_object_unref0 (_tmp11_);
								_tmp11_ = _tmp13_;
							}
							_tmp14_ = _g_object_ref0 (_tmp11_);
							button = _tmp14_;
							_tmp15_ = button;
							gtk_widget_set_focus_on_click ((GtkWidget*) _tmp15_, FALSE);
							_tmp16_ = button;
							gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp16_, col, row, 1, 1);
							_tmp17_ = g_strdup_printf ("<big>%d</big>", _data5_->n);
							_tmp18_ = _tmp17_;
							_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
							g_object_ref_sink (_tmp19_);
							_tmp20_ = _tmp19_;
							_g_free0 (_tmp18_);
							label = _tmp20_;
							_tmp21_ = label;
							gtk_label_set_use_markup (_tmp21_, TRUE);
							if (earmark) {
								_tmp22_ = 0;
							} else {
								_tmp22_ = 8;
							}
							_tmp23_ = label;
							gtk_widget_set_margin_start ((GtkWidget*) _tmp23_, _tmp22_);
							if (earmark) {
								_tmp24_ = 16;
							} else {
								_tmp24_ = 8;
							}
							_tmp25_ = label;
							gtk_widget_set_margin_end ((GtkWidget*) _tmp25_, _tmp24_);
							if (earmark) {
								_tmp26_ = 0;
							} else {
								_tmp26_ = 4;
							}
							_tmp27_ = label;
							gtk_widget_set_margin_top ((GtkWidget*) _tmp27_, _tmp26_);
							if (earmark) {
								_tmp28_ = 8;
							} else {
								_tmp28_ = 4;
							}
							_tmp29_ = label;
							gtk_widget_set_margin_bottom ((GtkWidget*) _tmp29_, _tmp28_);
							_tmp30_ = button;
							_tmp31_ = label;
							gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
							_tmp32_ = label;
							gtk_widget_show ((GtkWidget*) _tmp32_);
							if (!earmark) {
								GtkButton* _tmp33_;
								_tmp33_ = button;
								g_signal_connect_data (_tmp33_, "clicked", (GCallback) __________lambda4__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
							} else {
								Block6Data* _data6_;
								GtkButton* _tmp34_;
								GtkToggleButton* _tmp35_;
								GtkToggleButton* _tmp36_;
								_data6_ = g_slice_new0 (Block6Data);
								_data6_->_ref_count_ = 1;
								_data6_->_data5_ = block5_data_ref (_data5_);
								_tmp34_ = button;
								_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_toggle_button_get_type (), GtkToggleButton));
								_data6_->toggle_button = _tmp35_;
								_tmp36_ = _data6_->toggle_button;
								g_signal_connect_data (_tmp36_, "toggled", (GCallback) __________lambda5__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
								block6_data_unref (_data6_);
								_data6_ = NULL;
							}
							if (_data5_->n == 5) {
								GtkButton* _tmp37_;
								_tmp37_ = button;
								gtk_widget_grab_focus ((GtkWidget*) _tmp37_);
							}
							_tmp38_ = button;
							gtk_widget_show ((GtkWidget*) _tmp38_);
							_g_object_unref0 (label);
							_g_object_unref0 (button);
							_g_object_unref0 (_tmp11_);
							block5_data_unref (_data5_);
							_data5_ = NULL;
						}
					}
				}
			}
		}
	}
	if (!earmark) {
		GtkButton* _tmp39_;
		GtkButton* _tmp40_;
		GtkButton* _tmp41_;
		GtkLabel* label = NULL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GtkLabel* _tmp44_;
		GtkLabel* _tmp45_;
		GtkLabel* _tmp46_;
		GtkButton* _tmp47_;
		GtkLabel* _tmp48_;
		GtkLabel* _tmp49_;
		GtkButton* _tmp50_;
		_tmp39_ = (GtkButton*) gtk_button_new ();
		g_object_ref_sink (_tmp39_);
		_g_object_unref0 (self->priv->clear_button);
		self->priv->clear_button = _tmp39_;
		_tmp40_ = self->priv->clear_button;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp40_, FALSE);
		_tmp41_ = self->priv->clear_button;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp41_, 0, 4, 3, 1);
		_tmp42_ = g_strdup_printf ("<big>%s</big>", _ ("Clear"));
		_tmp43_ = _tmp42_;
		_tmp44_ = (GtkLabel*) gtk_label_new (_tmp43_);
		g_object_ref_sink (_tmp44_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		label = _tmp45_;
		_tmp46_ = label;
		gtk_label_set_use_markup (_tmp46_, TRUE);
		_tmp47_ = self->priv->clear_button;
		_tmp48_ = label;
		gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
		_tmp49_ = label;
		gtk_widget_show ((GtkWidget*) _tmp49_);
		_tmp50_ = self->priv->clear_button;
		g_signal_connect_object (_tmp50_, "clicked", (GCallback) ____lambda6__gtk_button_clicked, self, 0);
		_g_object_unref0 (label);
	}
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	g_object_set ((GtkWidget*) self, "margin", 2, NULL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 3);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 3);
	gtk_widget_show ((GtkWidget*) self);
	return self;
}

NumberPicker*
number_picker_new (SudokuBoard** board,
                   gboolean earmark)
{
	return number_picker_construct (TYPE_NUMBER_PICKER, board, earmark);
}

void
number_picker_set_clear_button_visibility (NumberPicker* self,
                                           gboolean visible)
{
	g_return_if_fail (self != NULL);
	if (visible) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->clear_button;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->clear_button;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}

void
number_picker_set_earmarks (NumberPicker* self,
                            gint row,
                            gint col)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				SudokuBoard* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->board;
				_tmp3_ = sudoku_board_get_max_val (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->board;
				number_picker_set_earmark (self, row, col, i, sudoku_board_is_earmark_enabled (_tmp5_, row, col, i + 1));
			}
		}
	}
}

void
number_picker_set_earmark (NumberPicker* self,
                           gint row,
                           gint col,
                           gint index,
                           gboolean state)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = number_picker_get_button_for (self, index);
	_tmp1_ = _tmp0_;
	gtk_toggle_button_set_active (_tmp1_, state);
	_g_object_unref0 (_tmp1_);
}

static GtkToggleButton*
number_picker_get_button_for (NumberPicker* self,
                              gint number)
{
	SudokuBoard* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	SudokuBoard* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkWidget* _tmp6_;
	GtkToggleButton* _tmp7_;
	GtkToggleButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->board;
	_tmp1_ = sudoku_board_get_block_cols (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->board;
	_tmp4_ = sudoku_board_get_block_rows (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_grid_get_child_at ((GtkGrid*) self, number % _tmp2_, 2 - (number / _tmp5_));
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_toggle_button_get_type (), GtkToggleButton));
	result = _tmp7_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__INT_BOOLEAN (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_BOOLEAN) (gpointer data1, gint arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
number_picker_class_init (NumberPickerClass * klass,
                          gpointer klass_data)
{
	number_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NumberPicker_private_offset);
	G_OBJECT_CLASS (klass)->finalize = number_picker_finalize;
	number_picker_signals[NUMBER_PICKER_NUMBER_PICKED_SIGNAL] = g_signal_new ("number-picked", TYPE_NUMBER_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	number_picker_signals[NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL] = g_signal_new ("earmark-state-changed", TYPE_NUMBER_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_BOOLEAN);
}

static void
number_picker_instance_init (NumberPicker * self,
                             gpointer klass)
{
	self->priv = number_picker_get_instance_private (self);
}

static void
number_picker_finalize (GObject * obj)
{
	NumberPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER_PICKER, NumberPicker);
	_g_object_unref0 (self->priv->board);
	_g_object_unref0 (self->priv->clear_button);
	G_OBJECT_CLASS (number_picker_parent_class)->finalize (obj);
}

static GType
number_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NumberPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NumberPicker), 0, (GInstanceInitFunc) number_picker_instance_init, NULL };
	GType number_picker_type_id;
	number_picker_type_id = g_type_register_static (gtk_grid_get_type (), "NumberPicker", &g_define_type_info, 0);
	NumberPicker_private_offset = g_type_add_instance_private (number_picker_type_id, sizeof (NumberPickerPrivate));
	return number_picker_type_id;
}

GType
number_picker_get_type (void)
{
	static volatile gsize number_picker_type_id__once = 0;
	if (g_once_init_enter (&number_picker_type_id__once)) {
		GType number_picker_type_id;
		number_picker_type_id = number_picker_get_type_once ();
		g_once_init_leave (&number_picker_type_id__once, number_picker_type_id);
	}
	return number_picker_type_id__once;
}

