
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "desktopnotificationsfactory_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void DesktopNotificationsFactoryWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::DesktopNotificationsFactory::Type >("DesktopNotificationsFactory::Type");
}

void DesktopNotificationsFactoryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

DesktopNotificationsFactoryWrapper::DesktopNotificationsFactoryWrapper(QObject * parent) : DesktopNotificationsFactory(parent)
{
    resetPyMethodCache();
    // ... middle
}

void DesktopNotificationsFactoryWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void DesktopNotificationsFactoryWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void DesktopNotificationsFactoryWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void DesktopNotificationsFactoryWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool DesktopNotificationsFactoryWrapper::event(QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "DesktopNotificationsFactory.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool DesktopNotificationsFactoryWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "DesktopNotificationsFactory.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void DesktopNotificationsFactoryWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *DesktopNotificationsFactoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return DesktopNotificationsFactory::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int DesktopNotificationsFactoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = DesktopNotificationsFactory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *DesktopNotificationsFactoryWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< DesktopNotificationsFactoryWrapper *>(this));
        return DesktopNotificationsFactory::qt_metacast(_clname);
}

DesktopNotificationsFactoryWrapper::~DesktopNotificationsFactoryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DesktopNotificationsFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DesktopNotificationsFactory >()))
        return -1;

    ::DesktopNotificationsFactoryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopNotificationsFactory.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:DesktopNotificationsFactory", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: DesktopNotificationsFactory::DesktopNotificationsFactory(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // DesktopNotificationsFactory(QObject*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // DesktopNotificationsFactory(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DesktopNotificationsFactory_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_DesktopNotificationsFactory_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_DesktopNotificationsFactory_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                // fall through to handle extra keyword signals and properties
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // DesktopNotificationsFactory(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::DesktopNotificationsFactoryWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::DesktopNotificationsFactoryWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DesktopNotificationsFactory >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_DesktopNotificationsFactory_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_DesktopNotificationsFactory_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_DesktopNotificationsFactory_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopNotificationsFactory.loadSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loadSettings()
            cppSelf->loadSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_nativeNotificationPreview(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopNotificationsFactory.nativeNotificationPreview";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeNotificationPreview()
            cppSelf->nativeNotificationPreview();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_showNotification(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopNotificationsFactory.showNotification";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "showNotification", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: DesktopNotificationsFactory::showNotification(QPixmap,QString,QString)
    // 1: DesktopNotificationsFactory::showNotification(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // showNotification(QString,QString)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // showNotification(QPixmap,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DesktopNotificationsFactoryFunc_showNotification_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // showNotification(const QPixmap & icon, const QString & heading, const QString & text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // showNotification(QPixmap,QString,QString)
                cppSelf->showNotification(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // showNotification(const QString & heading, const QString & text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // showNotification(QString,QString)
                cppSelf->showNotification(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_DesktopNotificationsFactoryFunc_showNotification_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_supportsNativeNotifications(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopNotificationsFactory.supportsNativeNotifications";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsNativeNotifications()const
            bool cppResult = const_cast<const ::DesktopNotificationsFactoryWrapper *>(cppSelf)->supportsNativeNotifications();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_DesktopNotificationsFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DesktopNotificationsFactory_methods[] = {
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_loadSettings), METH_NOARGS},
    {"nativeNotificationPreview", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_nativeNotificationPreview), METH_NOARGS},
    {"showNotification", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_showNotification), METH_VARARGS},
    {"supportsNativeNotifications", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_supportsNativeNotifications), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_DesktopNotificationsFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<DesktopNotificationsFactoryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_DesktopNotificationsFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_DesktopNotificationsFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_DesktopNotificationsFactory_Type = nullptr;
static SbkObjectType *Sbk_DesktopNotificationsFactory_TypeF(void)
{
    return _Sbk_DesktopNotificationsFactory_Type;
}

static PyType_Slot Sbk_DesktopNotificationsFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_DesktopNotificationsFactory_spec = {
    "1:PyFalkon.DesktopNotificationsFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_DesktopNotificationsFactory_slots
};

} //extern "C"

static void *Sbk_DesktopNotificationsFactory_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::DesktopNotificationsFactory *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void DesktopNotificationsFactory_Type_PythonToCpp_DesktopNotificationsFactory_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::DesktopNotificationsFactory::Type *>(cppOut) =
        static_cast<::DesktopNotificationsFactory::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_DesktopNotificationsFactory_Type_PythonToCpp_DesktopNotificationsFactory_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX]))
        return DesktopNotificationsFactory_Type_PythonToCpp_DesktopNotificationsFactory_Type;
    return {};
}
static PyObject *DesktopNotificationsFactory_Type_CppToPython_DesktopNotificationsFactory_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::DesktopNotificationsFactory::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_DesktopNotificationsFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_DesktopNotificationsFactory_TypeF())))
        return DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DesktopNotificationsFactory_PTR_CppToPython_DesktopNotificationsFactory(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::DesktopNotificationsFactory *>(const_cast<void *>(cppIn)), Sbk_DesktopNotificationsFactory_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *DesktopNotificationsFactory_SignatureStrings[] = {
    "PyFalkon.DesktopNotificationsFactory(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PyFalkon.DesktopNotificationsFactory.loadSettings(self)",
    "PyFalkon.DesktopNotificationsFactory.nativeNotificationPreview(self)",
    "1:PyFalkon.DesktopNotificationsFactory.showNotification(self,icon:PySide2.QtGui.QPixmap,heading:QString,text:QString)",
    "0:PyFalkon.DesktopNotificationsFactory.showNotification(self,heading:QString,text:QString)",
    "PyFalkon.DesktopNotificationsFactory.supportsNativeNotifications(self)->bool",
    nullptr}; // Sentinel

void init_DesktopNotificationsFactory(PyObject *module)
{
    _Sbk_DesktopNotificationsFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DesktopNotificationsFactory",
        "DesktopNotificationsFactory*",
        &Sbk_DesktopNotificationsFactory_spec,
        &Shiboken::callCppDestructor< ::DesktopNotificationsFactory >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_DesktopNotificationsFactory_Type);
    InitSignatureStrings(pyType, DesktopNotificationsFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_DesktopNotificationsFactory_Type), Sbk_DesktopNotificationsFactory_PropertyStrings);
    SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_DesktopNotificationsFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_DesktopNotificationsFactory_TypeF(),
        DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR,
        is_DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR_Convertible,
        DesktopNotificationsFactory_PTR_CppToPython_DesktopNotificationsFactory);

    Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory");
    Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory*");
    Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DesktopNotificationsFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::DesktopNotificationsFactoryWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_DesktopNotificationsFactory_TypeF(), &Sbk_DesktopNotificationsFactory_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_DesktopNotificationsFactory_TypeF(),
        "Type",
        "1:PyFalkon.DesktopNotificationsFactory.Type",
        "DesktopNotificationsFactory::Type");
    if (!SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX],
        Sbk_DesktopNotificationsFactory_TypeF(), "DesktopNative", (long) DesktopNotificationsFactory::Type::DesktopNative))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX],
        Sbk_DesktopNotificationsFactory_TypeF(), "PopupWidget", (long) DesktopNotificationsFactory::Type::PopupWidget))
        return;
    // Register converter for enum 'DesktopNotificationsFactory::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX],
            DesktopNotificationsFactory_Type_CppToPython_DesktopNotificationsFactory_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            DesktopNotificationsFactory_Type_PythonToCpp_DesktopNotificationsFactory_Type,
            is_DesktopNotificationsFactory_Type_PythonToCpp_DesktopNotificationsFactory_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    PySide::Signal::registerSignals(Sbk_DesktopNotificationsFactory_TypeF(), &::DesktopNotificationsFactory::staticMetaObject);
    DesktopNotificationsFactoryWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_DesktopNotificationsFactory_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_DesktopNotificationsFactory_TypeF(), &::DesktopNotificationsFactory::staticMetaObject, sizeof(DesktopNotificationsFactoryWrapper));
}
