/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-recurrence.h"
#include "libical-glib-private.h"
#include "i-cal-array.h"
#include "i-cal-time.h"

G_DEFINE_TYPE (ICalRecurrence, i_cal_recurrence, I_CAL_TYPE_OBJECT)

static void i_cal_recurrence_class_init (G_GNUC_UNUSED ICalRecurrenceClass *klass)
{
}

static void i_cal_recurrence_init (G_GNUC_UNUSED ICalRecurrence *self)
{
}

/**
 * i_cal_recurrence_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalRecurrence *
i_cal_recurrence_new_full (struct icalrecurrencetype native)
{
    ICalRecurrence *object;
    struct icalrecurrencetype *clone;
    
    
    clone = g_new (struct icalrecurrencetype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_RECURRENCE,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_recurrence_rscale_is_supported:
 *
 * Checks whether rscale is supported.
 *
 * Returns: Whether rscale is supported
 *
 * Since: 2.0
 *
 **/
gboolean
i_cal_recurrence_rscale_is_supported (void)
{
	return icalrecurrencetype_rscale_is_supported ();
}

/**
 * i_cal_recurrence_rscale_supported_calendars:
 *
 * Gets an array of calendars supporting rscale (currently always return NULL).
 *
 * Returns: (transfer full): Array of calendars. Currently always NULL.
 *
 * Since: 2.0
 *
 **/
ICalArray *
i_cal_recurrence_rscale_supported_calendars (void)
{
	return i_cal_array_new_full (icalrecurrencetype_rscale_supported_calendars (), NULL, FALSE);
}

/**
 * i_cal_recurrence_new_default: (skip)
 *
 * Returns: The default value.
 *
 * Since: 1.0
 *
 **/
struct icalrecurrencetype
i_cal_recurrence_new_default (void)
{
	struct icalrecurrencetype ret;
	icalrecurrencetype_clear (&ret);
	return ret;
}

/**
 * i_cal_recurrence_new:
 *
 * Creates a new #ICalRecurrence.
 *
 * Returns: (transfer full): The newly created #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
ICalRecurrence *
i_cal_recurrence_new (void)
{
	return i_cal_recurrence_new_full(i_cal_recurrence_new_default());
}

/**
 * i_cal_recurrence_clear:
 * @r: The #ICalRecurrence to be reset
 *
 * Resets an #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_clear (ICalRecurrence *r)
{
	g_return_if_fail (I_CAL_IS_RECURRENCE (r));

	icalrecurrencetype_clear ((struct icalrecurrencetype *)i_cal_object_get_native (I_CAL_OBJECT (r)));
}

/**
 * i_cal_recurrence_day_day_of_week:
 * @day: The encoded day which represents the day of the week and Nth day of the week
 *
 * Decodes a day to a weekday in a week.
 *
 * Returns: The decoded weekday with Monday to be 1.
 *
 * Since: 1.0
 *
 **/
ICalRecurrenceWeekday
i_cal_recurrence_day_day_of_week (gshort day)
{
	return (ICalRecurrenceWeekday) (icalrecurrencetype_day_day_of_week (day));
}

/**
 * i_cal_recurrence_day_position:
 * @day: The encoded day which represents the day of the week and Nth day of the week
 *
 * Decodes a day to a position of the weekday.
 *
 * Returns: The decoded day of the week. 0 == any of day of week. 1 == first, 2 = second, -2 == second to last, etc
 *
 * Since: 1.0
 *
 **/
gint
i_cal_recurrence_day_position (gshort day)
{
	return icalrecurrencetype_day_position (day);
}

/**
 * i_cal_recurrence_month_is_leap:
 * @month: The month to be decoded
 *
 * Decodes a month and check whether it is a leap month.
 *
 * Returns: Whether this month is a leap month.
 *
 * Since: 2.0
 *
 **/
gboolean
i_cal_recurrence_month_is_leap (gshort month)
{
	return icalrecurrencetype_month_is_leap (month);
}

/**
 * i_cal_recurrence_month_month:
 * @month: The month to be decoded
 *
 * Returns: The actual month number regardless of the leap flag.
 *
 * Since: 2.0
 *
 **/
gint
i_cal_recurrence_month_month (gshort month)
{
	return icalrecurrencetype_month_month (month);
}

/**
 * i_cal_recurrence_new_from_string:
 * @str: The string representation of the #ICalRecurrence
 *
 * Converts a string to a #ICalRecurrence.
 *
 * Returns: (transfer full): The #ICalRecurrence converted from @str.
 *
 * Since: 1.0
 *
 **/
ICalRecurrence *
i_cal_recurrence_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_recurrence_new_full (icalrecurrencetype_from_string (str));
}

/**
 * i_cal_recurrence_to_string:
 * @recur: The #ICalRecurrence to be converted
 *
 * Converts a #ICalRecurrence to a string.
 *
 * Returns: (transfer full): The string representation of @recur.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_recurrence_to_string (ICalRecurrence *recur)
{
	g_return_val_if_fail (I_CAL_IS_RECURRENCE (recur), NULL);

	return icalrecurrencetype_as_string_r ((struct icalrecurrencetype *)i_cal_object_get_native (I_CAL_OBJECT (recur)));
}

/**
 * i_cal_recurrence_get_until:
 * @recur: The #ICalRecurrence
 *
 * Gets the until from #ICalRecurrence.
 *
 * Returns: (transfer full): The until of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_recurrence_get_until (ICalRecurrence *recur)
{
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	return i_cal_time_new_full (((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->until);
}

/**
 * i_cal_recurrence_set_until:
 * @recur: The #ICalRecurrence
 * @until: The until of #ICalRecurrence
 *
 * Sets the until from #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_until (ICalRecurrence *recur, 
                            ICalTime *until)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (until != NULL && I_CAL_IS_TIME(until));
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->until = *(icaltimetype *)i_cal_object_get_native ((ICalObject *)until);
}

/**
 * i_cal_recurrence_get_freq:
 * @recur: The #ICalRecurrence
 *
 * Gets the freq from #ICalRecurrence.
 *
 * Returns: The freq of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
ICalRecurrenceFrequency
i_cal_recurrence_get_freq (ICalRecurrence *recur)
{
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_NO_RECURRENCE);
	return (ICalRecurrenceFrequency) (((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->freq);
}

/**
 * i_cal_recurrence_set_freq:
 * @recur: The #ICalRecurrence
 * @freq: The freq of #ICalRecurrence
 *
 * Sets the freq from #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_freq (ICalRecurrence *recur, 
                           ICalRecurrenceFrequency freq)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	((struct icalrecurrencetype *) i_cal_object_get_native ((ICalObject *)recur))->freq = (icalrecurrencetype_frequency) freq;
}

/**
 * i_cal_recurrence_get_count:
 * @recur: The #ICalRecurrence
 *
 * Gets the count from #ICalRecurrence.
 *
 * Returns: The count of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_recurrence_get_count (ICalRecurrence *recur)
{
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), 0);
	return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->count;
}

/**
 * i_cal_recurrence_set_count:
 * @recur: The #ICalRecurrence
 * @count: The count of #ICalRecurrence
 *
 * Sets the count from #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_count (ICalRecurrence *recur, 
                            gint count)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->count = count;
}

/**
 * i_cal_recurrence_get_interval:
 * @recur: The #ICalRecurrence
 *
 * Gets the interval from #ICalRecurrence.
 *
 * Returns: The interval of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_interval (ICalRecurrence *recur)
{
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), 0);
	return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->interval;
}

/**
 * i_cal_recurrence_set_interval:
 * @recur: The #ICalRecurrence
 * @interval: The interval of #ICalRecurrence
 *
 * Sets the interval from #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_interval (ICalRecurrence *recur, 
                               gshort interval)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->interval = interval;
}

/**
 * i_cal_recurrence_get_week_start:
 * @recur: The #ICalRecurrence
 *
 * Gets the week_start from #ICalRecurrence.
 *
 * Returns: The week_start of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
ICalRecurrenceWeekday
i_cal_recurrence_get_week_start (ICalRecurrence *recur)
{
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_NO_WEEKDAY);
	return (ICalRecurrenceWeekday) (((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->week_start);
}

/**
 * i_cal_recurrence_set_week_start:
 * @recur: The #ICalRecurrence
 * @week_start: The week_start of #ICalRecurrence
 *
 * Sets the week_start from #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_week_start (ICalRecurrence *recur, 
                                 ICalRecurrenceWeekday week_start)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->week_start = (icalrecurrencetype_weekday) week_start;
}

/**
 * i_cal_recurrence_get_by_second_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_second array from #ICalRecurrence. The array size if I_CAL_BY_SECOND_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_second of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_second_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, TRUE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_second, I_CAL_BY_SECOND_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_second_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_second array in @recur at once. The array size can be less than I_CAL_BY_SECOND_SIZE. Shorter
 * arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_second_array (ICalRecurrence *recur, 
                                      GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_SECOND_SIZE; ii++) {
        rt->by_second[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_SECOND_SIZE)
        rt->by_second[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_second:
 * @recur: The #ICalRecurrence
 * @index: The index in by_second of #ICalRecurrence, less than %I_CAL_BY_SECOND_SIZE
 *
 * Gets the by_second value at index @index. The index should be less than %I_CAL_BY_SECOND_SIZE.
 *
 * Returns: The by_second of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_second (ICalRecurrence *recur, 
                                guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_SECOND_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_second[index];
}

/**
 * i_cal_recurrence_set_by_second:
 * @recur: The #ICalRecurrence
 * @index: The index in by_second of #ICalRecurrence, less than I_CAL_BY_SECOND_SIZE
 * @value: The value to be set into by_second of #ICalRecurrence
 *
 * Sets the by_second array from #ICalRecurrence at the given index. The array size is I_CAL_BY_SECOND_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_second (ICalRecurrence *recur, 
                                guint index, 
                                gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_SECOND_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_second[index] = value;
}

/**
 * i_cal_recurrence_get_by_minute_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_minute array from #ICalRecurrence. The array size is I_CAL_BY_MINUTE_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_minute of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_minute_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_minute, I_CAL_BY_MINUTE_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_minute_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_minute array in @recur at once. The array size can be less than I_CAL_BY_MINUTE_SIZE. Shorter
 * arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_minute_array (ICalRecurrence *recur, 
                                      GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_MINUTE_SIZE; ii++) {
        rt->by_minute[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_MINUTE_SIZE)
        rt->by_minute[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_minute:
 * @recur: The #ICalRecurrence
 * @index: The index in by_minute of #ICalRecurrence, less than %I_CAL_BY_MINUTE_SIZE
 *
 * Gets the by_minute value at index @index. The index should be less than %I_CAL_BY_MINUTE_SIZE.
 *
 * Returns: The by_minute of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_minute (ICalRecurrence *recur, 
                                guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_MINUTE_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_minute[index];
}

/**
 * i_cal_recurrence_set_by_minute:
 * @recur: The #ICalRecurrence
 * @index: The index in by_minute of #ICalRecurrence
 * @value: The value to be set into by_minute of #ICalRecurrence
 *
 * Sets the by_minute array from #ICalRecurrence at the given index. The array size is I_CAL_BY_MINUTE_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_minute (ICalRecurrence *recur, 
                                guint index, 
                                gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_MINUTE_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_minute[index] = value;
}

/**
 * i_cal_recurrence_get_by_hour_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_hour array from #ICalRecurrence. The array size is I_CAL_BY_HOUR_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_hour of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_hour_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_hour, I_CAL_BY_HOUR_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_hour_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_hour array in @recur at once. The array size can be less than I_CAL_BY_HOUR_SIZE. Shorter
 * arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_hour_array (ICalRecurrence *recur, 
                                    GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_HOUR_SIZE; ii++) {
        rt->by_hour[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_HOUR_SIZE)
        rt->by_hour[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_hour:
 * @recur: The #ICalRecurrence
 * @index: The index in by_hour of #ICalRecurrence, less than %I_CAL_BY_HOUR_SIZE
 *
 * Gets the by_hour value at index @index. The index should be less than %I_CAL_BY_HOUR_SIZE.
 *
 * Returns: The by_hour of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_hour (ICalRecurrence *recur, 
                              guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_HOUR_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_hour[index];
}

/**
 * i_cal_recurrence_set_by_hour:
 * @recur: The #ICalRecurrence
 * @index: The index in by_hour of #ICalRecurrence
 * @value: The value to be set into by_hour of #ICalRecurrence
 *
 * Sets the by_hour array from #ICalRecurrence at the given index. The array size is I_CAL_BY_HOUR_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_hour (ICalRecurrence *recur, 
                              guint index, 
                              gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_HOUR_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_hour[index] = value;
}

/**
 * i_cal_recurrence_get_by_day_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_day array from #ICalRecurrence. The array size is I_CAL_BY_DAY_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_day of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_day_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_day, I_CAL_BY_DAY_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_day_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_day array in @recur at once. The array size can be less than I_CAL_BY_DAY_SIZE. Shorter arrays
 * are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_day_array (ICalRecurrence *recur, 
                                   GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_DAY_SIZE; ii++) {
        rt->by_day[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_DAY_SIZE)
        rt->by_day[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_day:
 * @recur: The #ICalRecurrence
 * @index: The index in by_day of #ICalRecurrence, less than %I_CAL_BY_DAY_SIZE
 *
 * Gets the by_day value at index @index. The index should be less than %I_CAL_BY_DAY_SIZE.
 *
 * Returns: The by_day of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_day (ICalRecurrence *recur, 
                             guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_DAY_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_day[index];
}

/**
 * i_cal_recurrence_set_by_day:
 * @recur: The #ICalRecurrence
 * @index: The index in by_day of #ICalRecurrence
 * @value: The value to be set into by_day of #ICalRecurrence
 *
 * Sets the by_day array from #ICalRecurrence at the given index. The array size if I_CAL_BY_DAY_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_day (ICalRecurrence *recur, 
                             guint index, 
                             gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_DAY_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_day[index] = value;
}

/**
 * i_cal_recurrence_get_by_month_day_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_month_day array from #ICalRecurrence. The array size is I_CAL_BY_MONTHDAY_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_month_day of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_month_day_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_month_day, I_CAL_BY_MONTHDAY_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_month_day_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_month_day array in @recur at once. The array size can be less than I_CAL_BY_MONTHDAY_SIZE.
 * Shorter arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_month_day_array (ICalRecurrence *recur, 
                                         GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_MONTHDAY_SIZE; ii++) {
        rt->by_month_day[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_MONTHDAY_SIZE)
        rt->by_month_day[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_month_day:
 * @recur: The #ICalRecurrence
 * @index: The index in by_month_day of #ICalRecurrence, less than %I_CAL_BY_MONTHDAY_SIZE
 *
 * Gets the by_month_day value at index @index. The index should be less than %I_CAL_BY_MONTHDAY_SIZE.
 *
 * Returns: The by_month_day of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_month_day (ICalRecurrence *recur, 
                                   guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_MONTHDAY_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_month_day[index];
}

/**
 * i_cal_recurrence_set_by_month_day:
 * @recur: The #ICalRecurrence
 * @index: The index in by_month_day of #ICalRecurrence
 * @value: The value to be set into by_month_day of #ICalRecurrence
 *
 * Sets the by_month_day array from #ICalRecurrence at the given index. The array size if I_CAL_BY_MONTHDAY_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_month_day (ICalRecurrence *recur, 
                                   guint index, 
                                   gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_MONTHDAY_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_month_day[index] = value;
}

/**
 * i_cal_recurrence_get_by_year_day_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_year_day array from #ICalRecurrence. The array size is I_CAL_BY_YEARDAY_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_year_day of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_year_day_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_year_day, I_CAL_BY_YEARDAY_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_year_day_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_year_day array in @recur at once. The array size can be less than I_CAL_BY_YEARDAY_SIZE.
 * Shorter arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_year_day_array (ICalRecurrence *recur, 
                                        GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_YEARDAY_SIZE; ii++) {
        rt->by_year_day[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_YEARDAY_SIZE)
        rt->by_year_day[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_year_day:
 * @recur: The #ICalRecurrence
 * @index: The index in by_year_day of #ICalRecurrence, less than %I_CAL_BY_YEARDAY_SIZE
 *
 * Gets the by_year_day value at index @index. The index should be less than %I_CAL_BY_YEARDAY_SIZE.
 *
 * Returns: The by_year_day of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_year_day (ICalRecurrence *recur, 
                                  guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_YEARDAY_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_year_day[index];
}

/**
 * i_cal_recurrence_set_by_year_day:
 * @recur: The #ICalRecurrence
 * @index: The index in by_year_day of #ICalRecurrence
 * @value: The value to be set into by_year_day of #ICalRecurrence
 *
 * Sets the by_year_day array from #ICalRecurrence at the given index. The array size if I_CAL_BY_YEARDAY_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_year_day (ICalRecurrence *recur, 
                                  guint index, 
                                  gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_YEARDAY_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_year_day[index] = value;
}

/**
 * i_cal_recurrence_get_by_week_no_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_week_no array from #ICalRecurrence. The array size is I_CAL_BY_WEEKNO_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_week_no of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_week_no_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_week_no, I_CAL_BY_WEEKNO_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_week_no_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_week_no array in @recur at once. The array size can be less than I_CAL_BY_WEEKNO_SIZE. Shorter
 * arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_week_no_array (ICalRecurrence *recur, 
                                       GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_WEEKNO_SIZE; ii++) {
        rt->by_week_no[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_WEEKNO_SIZE)
        rt->by_week_no[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_week_no:
 * @recur: The #ICalRecurrence
 * @index: The index in by_week_no of #ICalRecurrence, less than %I_CAL_BY_WEEKNO_SIZE
 *
 * Gets the by_week_no value at index @index. The index should be less than %I_CAL_BY_WEEKNO_SIZE.
 *
 * Returns: The by_week_no of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_week_no (ICalRecurrence *recur, 
                                 guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_WEEKNO_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_week_no[index];
}

/**
 * i_cal_recurrence_set_by_week_no:
 * @recur: The #ICalRecurrence
 * @index: The index in by_week_no of #ICalRecurrence
 * @value: The value to be set into by_week_no of #ICalRecurrence
 *
 * Sets the by_week_no array from #ICalRecurrence at the given index. The array size is I_CAL_BY_WEEKNO_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_week_no (ICalRecurrence *recur, 
                                 guint index, 
                                 gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_WEEKNO_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_week_no[index] = value;
}

/**
 * i_cal_recurrence_get_by_month_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_month array from #ICalRecurrence. The array size is I_CAL_BY_MONTH_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_month of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_month_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_month, I_CAL_BY_MONTH_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_month_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_month array in @recur at once. The array size can be less than I_CAL_BY_MONTH_SIZE. Shorter
 * arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_month_array (ICalRecurrence *recur, 
                                     GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_MONTH_SIZE; ii++) {
        rt->by_month[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_MONTH_SIZE)
        rt->by_month[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_month:
 * @recur: The #ICalRecurrence
 * @index: The index in by_month of #ICalRecurrence, less than %I_CAL_BY_MONTH_SIZE
 *
 * Gets the by_month value at index @index. The index should be less than %I_CAL_BY_MONTH_SIZE.
 *
 * Returns: The by_month of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_month (ICalRecurrence *recur, 
                               guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_MONTH_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_month[index];
}

/**
 * i_cal_recurrence_set_by_month:
 * @recur: The #ICalRecurrence
 * @index: The index in by_month of #ICalRecurrence
 * @value: The value to be set into by_month of #ICalRecurrence
 *
 * Sets the by_month array from #ICalRecurrence at the given index. The array size is I_CAL_BY_MONTH_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_month (ICalRecurrence *recur, 
                               guint index, 
                               gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_MONTH_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_month[index] = value;
}

/**
 * i_cal_recurrence_get_by_set_pos_array:
 * @recur: The #ICalRecurrence
 *
 * Gets the by_set_pos array from #ICalRecurrence. The array size is I_CAL_BY_SETPOS_SIZE.
 *
 * Returns: (transfer full) (element-type gshort): The by_set_pos of #ICalRecurrence.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recurrence_get_by_set_pos_array (ICalRecurrence *recur)
{
	GArray *array;
	g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), NULL);
	array = g_array_new (FALSE, FALSE, sizeof (gshort));
	g_array_append_vals (array, ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_set_pos, I_CAL_BY_SETPOS_SIZE);
	return array;
}

/**
 * i_cal_recurrence_set_by_set_pos_array:
 * @recur: The #ICalRecurrence
 * @values: (element-type gshort): The array of values
 *
 * Sets the by_set_pos array in @recur at once. The array size can be less than I_CAL_BY_SETPOS_SIZE. Shorter
 * arrays are terminated with I_CAL_RECURRENCE_ARRAY_MAX value, longer arrays are truncated.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_set_pos_array (ICalRecurrence *recur, 
                                       GArray *values)
{
    struct icalrecurrencetype *rt;
    guint ii;

    g_return_if_fail(recur != NULL && I_CAL_IS_RECURRENCE (recur));
    g_return_if_fail(values != NULL);

    rt = (struct icalrecurrencetype *)i_cal_object_get_native((ICalObject *)recur);
    g_return_if_fail(rt != NULL);

    for(ii = 0; ii < values->len && ii < I_CAL_BY_SETPOS_SIZE; ii++) {
        rt->by_set_pos[ii] = g_array_index(values, gshort, ii);
    }
    if(ii < I_CAL_BY_SETPOS_SIZE)
        rt->by_set_pos[ii] = I_CAL_RECURRENCE_ARRAY_MAX;
}

/**
 * i_cal_recurrence_get_by_set_pos:
 * @recur: The #ICalRecurrence
 * @index: The index in by_set_pos of #ICalRecurrence, less than %I_CAL_BY_SETPOS_SIZE
 *
 * Gets the by_set_pos value at index @index. The index should be less than %I_CAL_BY_SETPOS_SIZE.
 *
 * Returns: The by_week_no of #ICalRecurrence at index @index.
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_recurrence_get_by_set_pos (ICalRecurrence *recur, 
                                 guint index)
{
    g_return_val_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur), I_CAL_RECURRENCE_ARRAY_MAX);
    g_return_val_if_fail (index < I_CAL_BY_SETPOS_SIZE, I_CAL_RECURRENCE_ARRAY_MAX);
    return ((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_set_pos[index];
}

/**
 * i_cal_recurrence_set_by_set_pos:
 * @recur: The #ICalRecurrence
 * @index: The index in by_set_pos of #ICalRecurrence
 * @value: The value to be set into by_set_pos of #ICalRecurrence
 *
 * Sets the by_set_pos array from #ICalRecurrence at the given index. The array size is I_CAL_BY_SETPOS_SIZE.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recurrence_set_by_set_pos (ICalRecurrence *recur, 
                                 guint index, 
                                 gshort value)
{
	g_return_if_fail (recur != NULL && I_CAL_IS_RECURRENCE (recur));
	g_return_if_fail (index < I_CAL_BY_SETPOS_SIZE);
	((struct icalrecurrencetype *)i_cal_object_get_native ((ICalObject *)recur))->by_set_pos[index] = value;
}
