/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebInspectorUIProxy.h"

#include "ArgumentCoders.h"
#include "Attachment.h"
#include "Decoder.h"
#include "HandleMessage.h"
#include "WebCoreArgumentCoders.h"
#include "WebInspectorUIProxyMessages.h"
#include <WebCore/CertificateInfo.h>
#include <WebCore/FloatRect.h>
#include <WebCore/InspectorClient.h>
#include <WebCore/InspectorFrontendClient.h>
#include <optional>
#include <wtf/text/WTFString.h>

namespace WebKit {

void WebInspectorUIProxy::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
    if (decoder.messageName() == Messages::WebInspectorUIProxy::OpenLocalInspectorFrontend::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::OpenLocalInspectorFrontend>(connection, decoder, this, &WebInspectorUIProxy::openLocalInspectorFrontend);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SetFrontendConnection::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SetFrontendConnection>(connection, decoder, this, &WebInspectorUIProxy::setFrontendConnection);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SendMessageToBackend::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SendMessageToBackend>(connection, decoder, this, &WebInspectorUIProxy::sendMessageToBackend);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::FrontendLoaded::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::FrontendLoaded>(connection, decoder, this, &WebInspectorUIProxy::frontendLoaded);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::DidClose::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::DidClose>(connection, decoder, this, &WebInspectorUIProxy::didClose);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::BringToFront::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::BringToFront>(connection, decoder, this, &WebInspectorUIProxy::bringToFront);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::BringInspectedPageToFront::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::BringInspectedPageToFront>(connection, decoder, this, &WebInspectorUIProxy::bringInspectedPageToFront);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::Reopen::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::Reopen>(connection, decoder, this, &WebInspectorUIProxy::reopen);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::ResetState::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::ResetState>(connection, decoder, this, &WebInspectorUIProxy::resetState);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SetForcedAppearance::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SetForcedAppearance>(connection, decoder, this, &WebInspectorUIProxy::setForcedAppearance);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::OpenURLExternally::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::OpenURLExternally>(connection, decoder, this, &WebInspectorUIProxy::openURLExternally);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::InspectedURLChanged::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::InspectedURLChanged>(connection, decoder, this, &WebInspectorUIProxy::inspectedURLChanged);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::ShowCertificate::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::ShowCertificate>(connection, decoder, this, &WebInspectorUIProxy::showCertificate);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::ElementSelectionChanged::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::ElementSelectionChanged>(connection, decoder, this, &WebInspectorUIProxy::elementSelectionChanged);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::TimelineRecordingChanged::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::TimelineRecordingChanged>(connection, decoder, this, &WebInspectorUIProxy::timelineRecordingChanged);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SetDeveloperPreferenceOverride::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SetDeveloperPreferenceOverride>(connection, decoder, this, &WebInspectorUIProxy::setDeveloperPreferenceOverride);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::Save::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::Save>(connection, decoder, this, &WebInspectorUIProxy::save);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::Append::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::Append>(connection, decoder, this, &WebInspectorUIProxy::append);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::AttachBottom::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::AttachBottom>(connection, decoder, this, &WebInspectorUIProxy::attachBottom);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::AttachRight::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::AttachRight>(connection, decoder, this, &WebInspectorUIProxy::attachRight);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::AttachLeft::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::AttachLeft>(connection, decoder, this, &WebInspectorUIProxy::attachLeft);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::Detach::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::Detach>(connection, decoder, this, &WebInspectorUIProxy::detach);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::AttachAvailabilityChanged::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::AttachAvailabilityChanged>(connection, decoder, this, &WebInspectorUIProxy::attachAvailabilityChanged);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SetAttachedWindowHeight::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SetAttachedWindowHeight>(connection, decoder, this, &WebInspectorUIProxy::setAttachedWindowHeight);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SetAttachedWindowWidth::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SetAttachedWindowWidth>(connection, decoder, this, &WebInspectorUIProxy::setAttachedWindowWidth);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::SetSheetRect::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::SetSheetRect>(connection, decoder, this, &WebInspectorUIProxy::setSheetRect);
    if (decoder.messageName() == Messages::WebInspectorUIProxy::StartWindowDrag::name())
        return IPC::handleMessage<Messages::WebInspectorUIProxy::StartWindowDrag>(connection, decoder, this, &WebInspectorUIProxy::startWindowDrag);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit
